#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtMultimedia, except for defaults which are replaced by "...".
"""

# Module PySide2.QtMultimedia
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtMultimedia


class QAbstractAudioDeviceInfo(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...

    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QAudioFormat) -> bool: ...
    def preferredFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def supportedByteOrders(self) -> typing.List[PySide2.QtMultimedia.QAudioFormat.Endian]: ...
    def supportedChannelCounts(self) -> typing.List[int]: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> typing.List[int]: ...
    def supportedSampleSizes(self) -> typing.List[int]: ...
    def supportedSampleTypes(self) -> typing.List[PySide2.QtMultimedia.QAudioFormat.SampleType]: ...


class QAbstractAudioInput(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...

    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, value: int) -> None: ...
    def setFormat(self, fmt: PySide2.QtMultimedia.QAudioFormat) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...


class QAbstractAudioOutput(PySide2.QtCore.QObject):

    def __init__(self) -> None: ...

    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, value: int) -> None: ...
    def setCategory(self, arg__1: str) -> None: ...
    def setFormat(self, fmt: PySide2.QtMultimedia.QAudioFormat) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...


class QAbstractVideoBuffer(Shiboken.Object):
    NoHandle                 : QAbstractVideoBuffer.HandleType = ... # 0x0
    GLTextureHandle          : QAbstractVideoBuffer.HandleType = ... # 0x1
    XvShmImageHandle         : QAbstractVideoBuffer.HandleType = ... # 0x2
    CoreImageHandle          : QAbstractVideoBuffer.HandleType = ... # 0x3
    QPixmapHandle            : QAbstractVideoBuffer.HandleType = ... # 0x4
    EGLImageHandle           : QAbstractVideoBuffer.HandleType = ... # 0x5
    UserHandle               : QAbstractVideoBuffer.HandleType = ... # 0x3e8
    NotMapped                : QAbstractVideoBuffer.MapMode = ... # 0x0
    ReadOnly                 : QAbstractVideoBuffer.MapMode = ... # 0x1
    WriteOnly                : QAbstractVideoBuffer.MapMode = ... # 0x2
    ReadWrite                : QAbstractVideoBuffer.MapMode = ... # 0x3

    class HandleType(Shiboken.Enum):
        NoHandle                 : QAbstractVideoBuffer.HandleType = ... # 0x0
        GLTextureHandle          : QAbstractVideoBuffer.HandleType = ... # 0x1
        XvShmImageHandle         : QAbstractVideoBuffer.HandleType = ... # 0x2
        CoreImageHandle          : QAbstractVideoBuffer.HandleType = ... # 0x3
        QPixmapHandle            : QAbstractVideoBuffer.HandleType = ... # 0x4
        EGLImageHandle           : QAbstractVideoBuffer.HandleType = ... # 0x5
        UserHandle               : QAbstractVideoBuffer.HandleType = ... # 0x3e8

    class MapMode(Shiboken.Enum):
        NotMapped                : QAbstractVideoBuffer.MapMode = ... # 0x0
        ReadOnly                 : QAbstractVideoBuffer.MapMode = ... # 0x1
        WriteOnly                : QAbstractVideoBuffer.MapMode = ... # 0x2
        ReadWrite                : QAbstractVideoBuffer.MapMode = ... # 0x3

    def __init__(self, type: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType) -> None: ...

    def handle(self) -> typing.Any: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def mapMode(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode: ...
    def release(self) -> None: ...
    def unmap(self) -> None: ...


class QAbstractVideoFilter(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def createFilterRunnable(self) -> PySide2.QtMultimedia.QVideoFilterRunnable: ...
    def isActive(self) -> bool: ...
    def setActive(self, v: bool) -> None: ...


class QAbstractVideoSurface(PySide2.QtCore.QObject):
    NoError                  : QAbstractVideoSurface.Error = ... # 0x0
    UnsupportedFormatError   : QAbstractVideoSurface.Error = ... # 0x1
    IncorrectFormatError     : QAbstractVideoSurface.Error = ... # 0x2
    StoppedError             : QAbstractVideoSurface.Error = ... # 0x3
    ResourceError            : QAbstractVideoSurface.Error = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QAbstractVideoSurface.Error = ... # 0x0
        UnsupportedFormatError   : QAbstractVideoSurface.Error = ... # 0x1
        IncorrectFormatError     : QAbstractVideoSurface.Error = ... # 0x2
        StoppedError             : QAbstractVideoSurface.Error = ... # 0x3
        ResourceError            : QAbstractVideoSurface.Error = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def error(self) -> PySide2.QtMultimedia.QAbstractVideoSurface.Error: ...
    def isActive(self) -> bool: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> bool: ...
    def nativeResolution(self) -> PySide2.QtCore.QSize: ...
    def nearestFormat(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> PySide2.QtMultimedia.QVideoSurfaceFormat: ...
    def present(self, frame: PySide2.QtMultimedia.QVideoFrame) -> bool: ...
    def setError(self, error: PySide2.QtMultimedia.QAbstractVideoSurface.Error) -> None: ...
    def setNativeResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
    def start(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> bool: ...
    def stop(self) -> None: ...
    def supportedPixelFormats(self, type: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType = ...) -> typing.List[PySide2.QtMultimedia.QVideoFrame.PixelFormat]: ...
    def surfaceFormat(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat: ...


class QAudio(Shiboken.Object):
    NoError                  : QAudio.Error = ... # 0x0
    OpenError                : QAudio.Error = ... # 0x1
    IOError                  : QAudio.Error = ... # 0x2
    UnderrunError            : QAudio.Error = ... # 0x3
    FatalError               : QAudio.Error = ... # 0x4
    AudioInput               : QAudio.Mode = ... # 0x0
    AudioOutput              : QAudio.Mode = ... # 0x1
    UnknownRole              : QAudio.Role = ... # 0x0
    MusicRole                : QAudio.Role = ... # 0x1
    VideoRole                : QAudio.Role = ... # 0x2
    VoiceCommunicationRole   : QAudio.Role = ... # 0x3
    AlarmRole                : QAudio.Role = ... # 0x4
    NotificationRole         : QAudio.Role = ... # 0x5
    RingtoneRole             : QAudio.Role = ... # 0x6
    AccessibilityRole        : QAudio.Role = ... # 0x7
    SonificationRole         : QAudio.Role = ... # 0x8
    GameRole                 : QAudio.Role = ... # 0x9
    CustomRole               : QAudio.Role = ... # 0xa
    ActiveState              : QAudio.State = ... # 0x0
    SuspendedState           : QAudio.State = ... # 0x1
    StoppedState             : QAudio.State = ... # 0x2
    IdleState                : QAudio.State = ... # 0x3
    InterruptedState         : QAudio.State = ... # 0x4
    LinearVolumeScale        : QAudio.VolumeScale = ... # 0x0
    CubicVolumeScale         : QAudio.VolumeScale = ... # 0x1
    LogarithmicVolumeScale   : QAudio.VolumeScale = ... # 0x2
    DecibelVolumeScale       : QAudio.VolumeScale = ... # 0x3

    class Error(Shiboken.Enum):
        NoError                  : QAudio.Error = ... # 0x0
        OpenError                : QAudio.Error = ... # 0x1
        IOError                  : QAudio.Error = ... # 0x2
        UnderrunError            : QAudio.Error = ... # 0x3
        FatalError               : QAudio.Error = ... # 0x4

    class Mode(Shiboken.Enum):
        AudioInput               : QAudio.Mode = ... # 0x0
        AudioOutput              : QAudio.Mode = ... # 0x1

    class Role(Shiboken.Enum):
        UnknownRole              : QAudio.Role = ... # 0x0
        MusicRole                : QAudio.Role = ... # 0x1
        VideoRole                : QAudio.Role = ... # 0x2
        VoiceCommunicationRole   : QAudio.Role = ... # 0x3
        AlarmRole                : QAudio.Role = ... # 0x4
        NotificationRole         : QAudio.Role = ... # 0x5
        RingtoneRole             : QAudio.Role = ... # 0x6
        AccessibilityRole        : QAudio.Role = ... # 0x7
        SonificationRole         : QAudio.Role = ... # 0x8
        GameRole                 : QAudio.Role = ... # 0x9
        CustomRole               : QAudio.Role = ... # 0xa

    class State(Shiboken.Enum):
        ActiveState              : QAudio.State = ... # 0x0
        SuspendedState           : QAudio.State = ... # 0x1
        StoppedState             : QAudio.State = ... # 0x2
        IdleState                : QAudio.State = ... # 0x3
        InterruptedState         : QAudio.State = ... # 0x4

    class VolumeScale(Shiboken.Enum):
        LinearVolumeScale        : QAudio.VolumeScale = ... # 0x0
        CubicVolumeScale         : QAudio.VolumeScale = ... # 0x1
        LogarithmicVolumeScale   : QAudio.VolumeScale = ... # 0x2
        DecibelVolumeScale       : QAudio.VolumeScale = ... # 0x3
    @staticmethod
    def convertVolume(volume: float, from_: PySide2.QtMultimedia.QAudio.VolumeScale, to: PySide2.QtMultimedia.QAudio.VolumeScale) -> float: ...


class QAudioBuffer(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, numFrames: int, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioBuffer) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def byteCount(self) -> int: ...
    def constData(self) -> int: ...
    def data(self) -> int: ...
    def duration(self) -> int: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def frameCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def sampleCount(self) -> int: ...
    def startTime(self) -> int: ...


class QAudioDecoder(PySide2.QtMultimedia.QMediaObject):
    NoError                  : QAudioDecoder.Error = ... # 0x0
    ResourceError            : QAudioDecoder.Error = ... # 0x1
    FormatError              : QAudioDecoder.Error = ... # 0x2
    AccessDeniedError        : QAudioDecoder.Error = ... # 0x3
    ServiceMissingError      : QAudioDecoder.Error = ... # 0x4
    StoppedState             : QAudioDecoder.State = ... # 0x0
    DecodingState            : QAudioDecoder.State = ... # 0x1

    class Error(Shiboken.Enum):
        NoError                  : QAudioDecoder.Error = ... # 0x0
        ResourceError            : QAudioDecoder.Error = ... # 0x1
        FormatError              : QAudioDecoder.Error = ... # 0x2
        AccessDeniedError        : QAudioDecoder.Error = ... # 0x3
        ServiceMissingError      : QAudioDecoder.Error = ... # 0x4

    class State(Shiboken.Enum):
        StoppedState             : QAudioDecoder.State = ... # 0x0
        DecodingState            : QAudioDecoder.State = ... # 0x1

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def audioFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudioDecoder.Error: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.Sequence[str] = ...) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def position(self) -> int: ...
    def read(self) -> PySide2.QtMultimedia.QAudioBuffer: ...
    def setAudioFormat(self, format: PySide2.QtMultimedia.QAudioFormat) -> None: ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setSourceFilename(self, fileName: str) -> None: ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudioDecoder.State: ...
    def stop(self) -> None: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...


class QAudioDecoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def audioFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def position(self) -> int: ...
    def read(self) -> PySide2.QtMultimedia.QAudioBuffer: ...
    def setAudioFormat(self, format: PySide2.QtMultimedia.QAudioFormat) -> None: ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def setSourceFilename(self, fileName: str) -> None: ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudioDecoder.State: ...
    def stop(self) -> None: ...


class QAudioDeviceInfo(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioDeviceInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def availableDevices(mode: PySide2.QtMultimedia.QAudio.Mode) -> typing.List[PySide2.QtMultimedia.QAudioDeviceInfo]: ...
    @staticmethod
    def defaultInputDevice() -> PySide2.QtMultimedia.QAudioDeviceInfo: ...
    @staticmethod
    def defaultOutputDevice() -> PySide2.QtMultimedia.QAudioDeviceInfo: ...
    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QAudioFormat) -> bool: ...
    def isNull(self) -> bool: ...
    def nearestFormat(self, format: PySide2.QtMultimedia.QAudioFormat) -> PySide2.QtMultimedia.QAudioFormat: ...
    def preferredFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def realm(self) -> str: ...
    def supportedByteOrders(self) -> typing.List[PySide2.QtMultimedia.QAudioFormat.Endian]: ...
    def supportedChannelCounts(self) -> typing.List[int]: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> typing.List[int]: ...
    def supportedSampleSizes(self) -> typing.List[int]: ...
    def supportedSampleTypes(self) -> typing.List[PySide2.QtMultimedia.QAudioFormat.SampleType]: ...


class QAudioEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioEncoderSettings) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bitRate(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> PySide2.QtMultimedia.QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def sampleRate(self) -> int: ...
    def setBitRate(self, bitrate: int) -> None: ...
    def setChannelCount(self, channels: int) -> None: ...
    def setCodec(self, codec: str) -> None: ...
    def setEncodingMode(self, arg__1: PySide2.QtMultimedia.QMultimedia.EncodingMode) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality) -> None: ...
    def setSampleRate(self, rate: int) -> None: ...


class QAudioEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def audioSettings(self) -> PySide2.QtMultimedia.QAudioEncoderSettings: ...
    def codecDescription(self, codecName: str) -> str: ...
    def setAudioSettings(self, settings: PySide2.QtMultimedia.QAudioEncoderSettings) -> None: ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...


class QAudioFormat(Shiboken.Object):
    BigEndian                : QAudioFormat.Endian = ... # 0x0
    LittleEndian             : QAudioFormat.Endian = ... # 0x1
    Unknown                  : QAudioFormat.SampleType = ... # 0x0
    SignedInt                : QAudioFormat.SampleType = ... # 0x1
    UnSignedInt              : QAudioFormat.SampleType = ... # 0x2
    Float                    : QAudioFormat.SampleType = ... # 0x3

    class Endian(Shiboken.Enum):
        BigEndian                : QAudioFormat.Endian = ... # 0x0
        LittleEndian             : QAudioFormat.Endian = ... # 0x1

    class SampleType(Shiboken.Enum):
        Unknown                  : QAudioFormat.SampleType = ... # 0x0
        SignedInt                : QAudioFormat.SampleType = ... # 0x1
        UnSignedInt              : QAudioFormat.SampleType = ... # 0x2
        Float                    : QAudioFormat.SampleType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def byteOrder(self) -> PySide2.QtMultimedia.QAudioFormat.Endian: ...
    def bytesForDuration(self, duration: int) -> int: ...
    def bytesForFrames(self, frameCount: int) -> int: ...
    def bytesPerFrame(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def durationForBytes(self, byteCount: int) -> int: ...
    def durationForFrames(self, frameCount: int) -> int: ...
    def framesForBytes(self, byteCount: int) -> int: ...
    def framesForDuration(self, duration: int) -> int: ...
    def isValid(self) -> bool: ...
    def sampleRate(self) -> int: ...
    def sampleSize(self) -> int: ...
    def sampleType(self) -> PySide2.QtMultimedia.QAudioFormat.SampleType: ...
    def setByteOrder(self, byteOrder: PySide2.QtMultimedia.QAudioFormat.Endian) -> None: ...
    def setChannelCount(self, channelCount: int) -> None: ...
    def setCodec(self, codec: str) -> None: ...
    def setSampleRate(self, sampleRate: int) -> None: ...
    def setSampleSize(self, sampleSize: int) -> None: ...
    def setSampleType(self, sampleType: PySide2.QtMultimedia.QAudioFormat.SampleType) -> None: ...


class QAudioInput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, bytes: int) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...


class QAudioInputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def activeInput(self) -> str: ...
    def availableInputs(self) -> typing.List[str]: ...
    def defaultInput(self) -> str: ...
    def inputDescription(self, name: str) -> str: ...
    def setActiveInput(self, name: str) -> None: ...


class QAudioOutput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self) -> None: ...
    def resume(self) -> None: ...
    def setBufferSize(self, bytes: int) -> None: ...
    def setCategory(self, category: str) -> None: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def setVolume(self, arg__1: float) -> None: ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def volume(self) -> float: ...


class QAudioOutputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def activeOutput(self) -> str: ...
    def availableOutputs(self) -> typing.List[str]: ...
    def defaultOutput(self) -> str: ...
    def outputDescription(self, name: str) -> str: ...
    def setActiveOutput(self, name: str) -> None: ...


class QAudioProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaRecorder) -> bool: ...


class QAudioRecorder(PySide2.QtMultimedia.QMediaRecorder):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def audioInput(self) -> str: ...
    def audioInputDescription(self, name: str) -> str: ...
    def audioInputs(self) -> typing.List[str]: ...
    def defaultAudioInput(self) -> str: ...
    def setAudioInput(self, name: str) -> None: ...


class QAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def audioRole(self) -> PySide2.QtMultimedia.QAudio.Role: ...
    def setAudioRole(self, role: PySide2.QtMultimedia.QAudio.Role) -> None: ...
    def supportedAudioRoles(self) -> typing.List[PySide2.QtMultimedia.QAudio.Role]: ...


class QCamera(PySide2.QtMultimedia.QMediaObject):
    CaptureViewfinder        : QCamera.CaptureMode = ... # 0x0
    CaptureStillImage        : QCamera.CaptureMode = ... # 0x1
    CaptureVideo             : QCamera.CaptureMode = ... # 0x2
    NoError                  : QCamera.Error = ... # 0x0
    CameraError              : QCamera.Error = ... # 0x1
    InvalidRequestError      : QCamera.Error = ... # 0x2
    ServiceMissingError      : QCamera.Error = ... # 0x3
    NotSupportedFeatureError : QCamera.Error = ... # 0x4
    UserRequest              : QCamera.LockChangeReason = ... # 0x0
    LockAcquired             : QCamera.LockChangeReason = ... # 0x1
    LockFailed               : QCamera.LockChangeReason = ... # 0x2
    LockLost                 : QCamera.LockChangeReason = ... # 0x3
    LockTemporaryLost        : QCamera.LockChangeReason = ... # 0x4
    Unlocked                 : QCamera.LockStatus = ... # 0x0
    Searching                : QCamera.LockStatus = ... # 0x1
    Locked                   : QCamera.LockStatus = ... # 0x2
    NoLock                   : QCamera.LockType = ... # 0x0
    LockExposure             : QCamera.LockType = ... # 0x1
    LockWhiteBalance         : QCamera.LockType = ... # 0x2
    LockFocus                : QCamera.LockType = ... # 0x4
    UnspecifiedPosition      : QCamera.Position = ... # 0x0
    BackFace                 : QCamera.Position = ... # 0x1
    FrontFace                : QCamera.Position = ... # 0x2
    UnloadedState            : QCamera.State = ... # 0x0
    LoadedState              : QCamera.State = ... # 0x1
    ActiveState              : QCamera.State = ... # 0x2
    UnavailableStatus        : QCamera.Status = ... # 0x0
    UnloadedStatus           : QCamera.Status = ... # 0x1
    LoadingStatus            : QCamera.Status = ... # 0x2
    UnloadingStatus          : QCamera.Status = ... # 0x3
    LoadedStatus             : QCamera.Status = ... # 0x4
    StandbyStatus            : QCamera.Status = ... # 0x5
    StartingStatus           : QCamera.Status = ... # 0x6
    StoppingStatus           : QCamera.Status = ... # 0x7
    ActiveStatus             : QCamera.Status = ... # 0x8

    class CaptureMode(Shiboken.Enum):
        CaptureViewfinder        : QCamera.CaptureMode = ... # 0x0
        CaptureStillImage        : QCamera.CaptureMode = ... # 0x1
        CaptureVideo             : QCamera.CaptureMode = ... # 0x2

    class CaptureModes(object): ...

    class Error(Shiboken.Enum):
        NoError                  : QCamera.Error = ... # 0x0
        CameraError              : QCamera.Error = ... # 0x1
        InvalidRequestError      : QCamera.Error = ... # 0x2
        ServiceMissingError      : QCamera.Error = ... # 0x3
        NotSupportedFeatureError : QCamera.Error = ... # 0x4

    class FrameRateRange(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FrameRateRange: PySide2.QtMultimedia.QCamera.FrameRateRange) -> None: ...
        @typing.overload
        def __init__(self, minimum: float, maximum: float) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class LockChangeReason(Shiboken.Enum):
        UserRequest              : QCamera.LockChangeReason = ... # 0x0
        LockAcquired             : QCamera.LockChangeReason = ... # 0x1
        LockFailed               : QCamera.LockChangeReason = ... # 0x2
        LockLost                 : QCamera.LockChangeReason = ... # 0x3
        LockTemporaryLost        : QCamera.LockChangeReason = ... # 0x4

    class LockStatus(Shiboken.Enum):
        Unlocked                 : QCamera.LockStatus = ... # 0x0
        Searching                : QCamera.LockStatus = ... # 0x1
        Locked                   : QCamera.LockStatus = ... # 0x2

    class LockType(Shiboken.Enum):
        NoLock                   : QCamera.LockType = ... # 0x0
        LockExposure             : QCamera.LockType = ... # 0x1
        LockWhiteBalance         : QCamera.LockType = ... # 0x2
        LockFocus                : QCamera.LockType = ... # 0x4

    class LockTypes(object): ...

    class Position(Shiboken.Enum):
        UnspecifiedPosition      : QCamera.Position = ... # 0x0
        BackFace                 : QCamera.Position = ... # 0x1
        FrontFace                : QCamera.Position = ... # 0x2

    class State(Shiboken.Enum):
        UnloadedState            : QCamera.State = ... # 0x0
        LoadedState              : QCamera.State = ... # 0x1
        ActiveState              : QCamera.State = ... # 0x2

    class Status(Shiboken.Enum):
        UnavailableStatus        : QCamera.Status = ... # 0x0
        UnloadedStatus           : QCamera.Status = ... # 0x1
        LoadingStatus            : QCamera.Status = ... # 0x2
        UnloadingStatus          : QCamera.Status = ... # 0x3
        LoadedStatus             : QCamera.Status = ... # 0x4
        StandbyStatus            : QCamera.Status = ... # 0x5
        StartingStatus           : QCamera.Status = ... # 0x6
        StoppingStatus           : QCamera.Status = ... # 0x7
        ActiveStatus             : QCamera.Status = ... # 0x8

    @typing.overload
    def __init__(self, cameraInfo: PySide2.QtMultimedia.QCameraInfo, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, deviceName: PySide2.QtCore.QByteArray, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    @staticmethod
    def availableDevices() -> typing.List[PySide2.QtCore.QByteArray]: ...
    def captureMode(self) -> PySide2.QtMultimedia.QCamera.CaptureModes: ...
    @staticmethod
    def deviceDescription(device: PySide2.QtCore.QByteArray) -> str: ...
    def error(self) -> PySide2.QtMultimedia.QCamera.Error: ...
    def errorString(self) -> str: ...
    def exposure(self) -> PySide2.QtMultimedia.QCameraExposure: ...
    def focus(self) -> PySide2.QtMultimedia.QCameraFocus: ...
    def imageProcessing(self) -> PySide2.QtMultimedia.QCameraImageProcessing: ...
    def isCaptureModeSupported(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes) -> bool: ...
    def load(self) -> None: ...
    @typing.overload
    def lockStatus(self) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    @typing.overload
    def lockStatus(self, lock: PySide2.QtMultimedia.QCamera.LockType) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    def requestedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    @typing.overload
    def searchAndLock(self) -> None: ...
    @typing.overload
    def searchAndLock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes) -> None: ...
    def setCaptureMode(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes) -> None: ...
    @typing.overload
    def setViewfinder(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface) -> None: ...
    @typing.overload
    def setViewfinder(self, viewfinder: PySide2.QtMultimediaWidgets.QGraphicsVideoItem) -> None: ...
    @typing.overload
    def setViewfinder(self, viewfinder: PySide2.QtMultimediaWidgets.QVideoWidget) -> None: ...
    def setViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings) -> None: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QCamera.State: ...
    def status(self) -> PySide2.QtMultimedia.QCamera.Status: ...
    def stop(self) -> None: ...
    def supportedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    def supportedViewfinderFrameRateRanges(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> typing.List[PySide2.QtMultimedia.QCamera.FrameRateRange]: ...
    def supportedViewfinderPixelFormats(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> typing.List[PySide2.QtMultimedia.QVideoFrame.PixelFormat]: ...
    def supportedViewfinderResolutions(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> typing.List[PySide2.QtCore.QSize]: ...
    def supportedViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> typing.List[PySide2.QtMultimedia.QCameraViewfinderSettings]: ...
    def unload(self) -> None: ...
    @typing.overload
    def unlock(self) -> None: ...
    @typing.overload
    def unlock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes) -> None: ...
    def viewfinderSettings(self) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...


class QCameraCaptureBufferFormatControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def bufferFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def setBufferFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    def supportedBufferFormats(self) -> typing.List[PySide2.QtMultimedia.QVideoFrame.PixelFormat]: ...


class QCameraCaptureDestinationControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def captureDestination(self) -> PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations: ...
    def isCaptureDestinationSupported(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> bool: ...
    def setCaptureDestination(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> None: ...


class QCameraControl(PySide2.QtMultimedia.QMediaControl):
    CaptureMode              : QCameraControl.PropertyChangeType = ... # 0x1
    ImageEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x2
    VideoEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x3
    Viewfinder               : QCameraControl.PropertyChangeType = ... # 0x4
    ViewfinderSettings       : QCameraControl.PropertyChangeType = ... # 0x5

    class PropertyChangeType(Shiboken.Enum):
        CaptureMode              : QCameraControl.PropertyChangeType = ... # 0x1
        ImageEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x2
        VideoEncodingSettings    : QCameraControl.PropertyChangeType = ... # 0x3
        Viewfinder               : QCameraControl.PropertyChangeType = ... # 0x4
        ViewfinderSettings       : QCameraControl.PropertyChangeType = ... # 0x5

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def canChangeProperty(self, changeType: PySide2.QtMultimedia.QCameraControl.PropertyChangeType, status: PySide2.QtMultimedia.QCamera.Status) -> bool: ...
    def captureMode(self) -> PySide2.QtMultimedia.QCamera.CaptureModes: ...
    def isCaptureModeSupported(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes) -> bool: ...
    def setCaptureMode(self, arg__1: PySide2.QtMultimedia.QCamera.CaptureModes) -> None: ...
    def setState(self, state: PySide2.QtMultimedia.QCamera.State) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QCamera.State: ...
    def status(self) -> PySide2.QtMultimedia.QCamera.Status: ...


class QCameraExposure(PySide2.QtCore.QObject):
    ExposureAuto             : QCameraExposure.ExposureMode = ... # 0x0
    ExposureManual           : QCameraExposure.ExposureMode = ... # 0x1
    ExposurePortrait         : QCameraExposure.ExposureMode = ... # 0x2
    ExposureNight            : QCameraExposure.ExposureMode = ... # 0x3
    ExposureBacklight        : QCameraExposure.ExposureMode = ... # 0x4
    ExposureSpotlight        : QCameraExposure.ExposureMode = ... # 0x5
    ExposureSports           : QCameraExposure.ExposureMode = ... # 0x6
    ExposureSnow             : QCameraExposure.ExposureMode = ... # 0x7
    ExposureBeach            : QCameraExposure.ExposureMode = ... # 0x8
    ExposureLargeAperture    : QCameraExposure.ExposureMode = ... # 0x9
    ExposureSmallAperture    : QCameraExposure.ExposureMode = ... # 0xa
    ExposureAction           : QCameraExposure.ExposureMode = ... # 0xb
    ExposureLandscape        : QCameraExposure.ExposureMode = ... # 0xc
    ExposureNightPortrait    : QCameraExposure.ExposureMode = ... # 0xd
    ExposureTheatre          : QCameraExposure.ExposureMode = ... # 0xe
    ExposureSunset           : QCameraExposure.ExposureMode = ... # 0xf
    ExposureSteadyPhoto      : QCameraExposure.ExposureMode = ... # 0x10
    ExposureFireworks        : QCameraExposure.ExposureMode = ... # 0x11
    ExposureParty            : QCameraExposure.ExposureMode = ... # 0x12
    ExposureCandlelight      : QCameraExposure.ExposureMode = ... # 0x13
    ExposureBarcode          : QCameraExposure.ExposureMode = ... # 0x14
    ExposureModeVendor       : QCameraExposure.ExposureMode = ... # 0x3e8
    FlashAuto                : QCameraExposure.FlashMode = ... # 0x1
    FlashOff                 : QCameraExposure.FlashMode = ... # 0x2
    FlashOn                  : QCameraExposure.FlashMode = ... # 0x4
    FlashRedEyeReduction     : QCameraExposure.FlashMode = ... # 0x8
    FlashFill                : QCameraExposure.FlashMode = ... # 0x10
    FlashTorch               : QCameraExposure.FlashMode = ... # 0x20
    FlashVideoLight          : QCameraExposure.FlashMode = ... # 0x40
    FlashSlowSyncFrontCurtain: QCameraExposure.FlashMode = ... # 0x80
    FlashSlowSyncRearCurtain : QCameraExposure.FlashMode = ... # 0x100
    FlashManual              : QCameraExposure.FlashMode = ... # 0x200
    MeteringMatrix           : QCameraExposure.MeteringMode = ... # 0x1
    MeteringAverage          : QCameraExposure.MeteringMode = ... # 0x2
    MeteringSpot             : QCameraExposure.MeteringMode = ... # 0x3

    class ExposureMode(Shiboken.Enum):
        ExposureAuto             : QCameraExposure.ExposureMode = ... # 0x0
        ExposureManual           : QCameraExposure.ExposureMode = ... # 0x1
        ExposurePortrait         : QCameraExposure.ExposureMode = ... # 0x2
        ExposureNight            : QCameraExposure.ExposureMode = ... # 0x3
        ExposureBacklight        : QCameraExposure.ExposureMode = ... # 0x4
        ExposureSpotlight        : QCameraExposure.ExposureMode = ... # 0x5
        ExposureSports           : QCameraExposure.ExposureMode = ... # 0x6
        ExposureSnow             : QCameraExposure.ExposureMode = ... # 0x7
        ExposureBeach            : QCameraExposure.ExposureMode = ... # 0x8
        ExposureLargeAperture    : QCameraExposure.ExposureMode = ... # 0x9
        ExposureSmallAperture    : QCameraExposure.ExposureMode = ... # 0xa
        ExposureAction           : QCameraExposure.ExposureMode = ... # 0xb
        ExposureLandscape        : QCameraExposure.ExposureMode = ... # 0xc
        ExposureNightPortrait    : QCameraExposure.ExposureMode = ... # 0xd
        ExposureTheatre          : QCameraExposure.ExposureMode = ... # 0xe
        ExposureSunset           : QCameraExposure.ExposureMode = ... # 0xf
        ExposureSteadyPhoto      : QCameraExposure.ExposureMode = ... # 0x10
        ExposureFireworks        : QCameraExposure.ExposureMode = ... # 0x11
        ExposureParty            : QCameraExposure.ExposureMode = ... # 0x12
        ExposureCandlelight      : QCameraExposure.ExposureMode = ... # 0x13
        ExposureBarcode          : QCameraExposure.ExposureMode = ... # 0x14
        ExposureModeVendor       : QCameraExposure.ExposureMode = ... # 0x3e8

    class FlashMode(Shiboken.Enum):
        FlashAuto                : QCameraExposure.FlashMode = ... # 0x1
        FlashOff                 : QCameraExposure.FlashMode = ... # 0x2
        FlashOn                  : QCameraExposure.FlashMode = ... # 0x4
        FlashRedEyeReduction     : QCameraExposure.FlashMode = ... # 0x8
        FlashFill                : QCameraExposure.FlashMode = ... # 0x10
        FlashTorch               : QCameraExposure.FlashMode = ... # 0x20
        FlashVideoLight          : QCameraExposure.FlashMode = ... # 0x40
        FlashSlowSyncFrontCurtain: QCameraExposure.FlashMode = ... # 0x80
        FlashSlowSyncRearCurtain : QCameraExposure.FlashMode = ... # 0x100
        FlashManual              : QCameraExposure.FlashMode = ... # 0x200

    class FlashModes(object): ...

    class MeteringMode(Shiboken.Enum):
        MeteringMatrix           : QCameraExposure.MeteringMode = ... # 0x1
        MeteringAverage          : QCameraExposure.MeteringMode = ... # 0x2
        MeteringSpot             : QCameraExposure.MeteringMode = ... # 0x3
    def aperture(self) -> float: ...
    def exposureCompensation(self) -> float: ...
    def exposureMode(self) -> PySide2.QtMultimedia.QCameraExposure.ExposureMode: ...
    def flashMode(self) -> PySide2.QtMultimedia.QCameraExposure.FlashModes: ...
    def isAvailable(self) -> bool: ...
    def isExposureModeSupported(self, mode: PySide2.QtMultimedia.QCameraExposure.ExposureMode) -> bool: ...
    def isFlashModeSupported(self, mode: PySide2.QtMultimedia.QCameraExposure.FlashModes) -> bool: ...
    def isFlashReady(self) -> bool: ...
    def isMeteringModeSupported(self, mode: PySide2.QtMultimedia.QCameraExposure.MeteringMode) -> bool: ...
    def isoSensitivity(self) -> int: ...
    def meteringMode(self) -> PySide2.QtMultimedia.QCameraExposure.MeteringMode: ...
    def requestedAperture(self) -> float: ...
    def requestedIsoSensitivity(self) -> int: ...
    def requestedShutterSpeed(self) -> float: ...
    def setAutoAperture(self) -> None: ...
    def setAutoIsoSensitivity(self) -> None: ...
    def setAutoShutterSpeed(self) -> None: ...
    def setExposureCompensation(self, ev: float) -> None: ...
    def setExposureMode(self, mode: PySide2.QtMultimedia.QCameraExposure.ExposureMode) -> None: ...
    def setFlashMode(self, mode: PySide2.QtMultimedia.QCameraExposure.FlashModes) -> None: ...
    def setManualAperture(self, aperture: float) -> None: ...
    def setManualIsoSensitivity(self, iso: int) -> None: ...
    def setManualShutterSpeed(self, seconds: float) -> None: ...
    def setMeteringMode(self, mode: PySide2.QtMultimedia.QCameraExposure.MeteringMode) -> None: ...
    def setSpotMeteringPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def shutterSpeed(self) -> float: ...
    def spotMeteringPoint(self) -> PySide2.QtCore.QPointF: ...


class QCameraExposureControl(PySide2.QtMultimedia.QMediaControl):
    ISO                      : QCameraExposureControl.ExposureParameter = ... # 0x0
    Aperture                 : QCameraExposureControl.ExposureParameter = ... # 0x1
    ShutterSpeed             : QCameraExposureControl.ExposureParameter = ... # 0x2
    ExposureCompensation     : QCameraExposureControl.ExposureParameter = ... # 0x3
    FlashPower               : QCameraExposureControl.ExposureParameter = ... # 0x4
    FlashCompensation        : QCameraExposureControl.ExposureParameter = ... # 0x5
    TorchPower               : QCameraExposureControl.ExposureParameter = ... # 0x6
    SpotMeteringPoint        : QCameraExposureControl.ExposureParameter = ... # 0x7
    ExposureMode             : QCameraExposureControl.ExposureParameter = ... # 0x8
    MeteringMode             : QCameraExposureControl.ExposureParameter = ... # 0x9
    ExtendedExposureParameter: QCameraExposureControl.ExposureParameter = ... # 0x3e8

    class ExposureParameter(Shiboken.Enum):
        ISO                      : QCameraExposureControl.ExposureParameter = ... # 0x0
        Aperture                 : QCameraExposureControl.ExposureParameter = ... # 0x1
        ShutterSpeed             : QCameraExposureControl.ExposureParameter = ... # 0x2
        ExposureCompensation     : QCameraExposureControl.ExposureParameter = ... # 0x3
        FlashPower               : QCameraExposureControl.ExposureParameter = ... # 0x4
        FlashCompensation        : QCameraExposureControl.ExposureParameter = ... # 0x5
        TorchPower               : QCameraExposureControl.ExposureParameter = ... # 0x6
        SpotMeteringPoint        : QCameraExposureControl.ExposureParameter = ... # 0x7
        ExposureMode             : QCameraExposureControl.ExposureParameter = ... # 0x8
        MeteringMode             : QCameraExposureControl.ExposureParameter = ... # 0x9
        ExtendedExposureParameter: QCameraExposureControl.ExposureParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def actualValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def isParameterSupported(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> bool: ...
    def requestedValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def setValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter, value: typing.Any) -> bool: ...


class QCameraFeedbackControl(PySide2.QtMultimedia.QMediaControl):
    ViewfinderStarted        : QCameraFeedbackControl.EventType = ... # 0x1
    ViewfinderStopped        : QCameraFeedbackControl.EventType = ... # 0x2
    ImageCaptured            : QCameraFeedbackControl.EventType = ... # 0x3
    ImageSaved               : QCameraFeedbackControl.EventType = ... # 0x4
    ImageError               : QCameraFeedbackControl.EventType = ... # 0x5
    RecordingStarted         : QCameraFeedbackControl.EventType = ... # 0x6
    RecordingInProgress      : QCameraFeedbackControl.EventType = ... # 0x7
    RecordingStopped         : QCameraFeedbackControl.EventType = ... # 0x8
    AutoFocusInProgress      : QCameraFeedbackControl.EventType = ... # 0x9
    AutoFocusLocked          : QCameraFeedbackControl.EventType = ... # 0xa
    AutoFocusFailed          : QCameraFeedbackControl.EventType = ... # 0xb

    class EventType(Shiboken.Enum):
        ViewfinderStarted        : QCameraFeedbackControl.EventType = ... # 0x1
        ViewfinderStopped        : QCameraFeedbackControl.EventType = ... # 0x2
        ImageCaptured            : QCameraFeedbackControl.EventType = ... # 0x3
        ImageSaved               : QCameraFeedbackControl.EventType = ... # 0x4
        ImageError               : QCameraFeedbackControl.EventType = ... # 0x5
        RecordingStarted         : QCameraFeedbackControl.EventType = ... # 0x6
        RecordingInProgress      : QCameraFeedbackControl.EventType = ... # 0x7
        RecordingStopped         : QCameraFeedbackControl.EventType = ... # 0x8
        AutoFocusInProgress      : QCameraFeedbackControl.EventType = ... # 0x9
        AutoFocusLocked          : QCameraFeedbackControl.EventType = ... # 0xa
        AutoFocusFailed          : QCameraFeedbackControl.EventType = ... # 0xb

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isEventFeedbackEnabled(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType) -> bool: ...
    def isEventFeedbackLocked(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType) -> bool: ...
    def resetEventFeedback(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType) -> None: ...
    def setEventFeedbackEnabled(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType, arg__2: bool) -> bool: ...
    def setEventFeedbackSound(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType, filePath: str) -> bool: ...


class QCameraFlashControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def flashMode(self) -> PySide2.QtMultimedia.QCameraExposure.FlashModes: ...
    def isFlashModeSupported(self, mode: PySide2.QtMultimedia.QCameraExposure.FlashModes) -> bool: ...
    def isFlashReady(self) -> bool: ...
    def setFlashMode(self, mode: PySide2.QtMultimedia.QCameraExposure.FlashModes) -> None: ...


class QCameraFocus(PySide2.QtCore.QObject):
    ManualFocus              : QCameraFocus.FocusMode = ... # 0x1
    HyperfocalFocus          : QCameraFocus.FocusMode = ... # 0x2
    InfinityFocus            : QCameraFocus.FocusMode = ... # 0x4
    AutoFocus                : QCameraFocus.FocusMode = ... # 0x8
    ContinuousFocus          : QCameraFocus.FocusMode = ... # 0x10
    MacroFocus               : QCameraFocus.FocusMode = ... # 0x20
    FocusPointAuto           : QCameraFocus.FocusPointMode = ... # 0x0
    FocusPointCenter         : QCameraFocus.FocusPointMode = ... # 0x1
    FocusPointFaceDetection  : QCameraFocus.FocusPointMode = ... # 0x2
    FocusPointCustom         : QCameraFocus.FocusPointMode = ... # 0x3

    class FocusMode(Shiboken.Enum):
        ManualFocus              : QCameraFocus.FocusMode = ... # 0x1
        HyperfocalFocus          : QCameraFocus.FocusMode = ... # 0x2
        InfinityFocus            : QCameraFocus.FocusMode = ... # 0x4
        AutoFocus                : QCameraFocus.FocusMode = ... # 0x8
        ContinuousFocus          : QCameraFocus.FocusMode = ... # 0x10
        MacroFocus               : QCameraFocus.FocusMode = ... # 0x20

    class FocusModes(object): ...

    class FocusPointMode(Shiboken.Enum):
        FocusPointAuto           : QCameraFocus.FocusPointMode = ... # 0x0
        FocusPointCenter         : QCameraFocus.FocusPointMode = ... # 0x1
        FocusPointFaceDetection  : QCameraFocus.FocusPointMode = ... # 0x2
        FocusPointCustom         : QCameraFocus.FocusPointMode = ... # 0x3
    def customFocusPoint(self) -> PySide2.QtCore.QPointF: ...
    def digitalZoom(self) -> float: ...
    def focusMode(self) -> PySide2.QtMultimedia.QCameraFocus.FocusModes: ...
    def focusPointMode(self) -> PySide2.QtMultimedia.QCameraFocus.FocusPointMode: ...
    def focusZones(self) -> typing.List[PySide2.QtMultimedia.QCameraFocusZone]: ...
    def isAvailable(self) -> bool: ...
    def isFocusModeSupported(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusModes) -> bool: ...
    def isFocusPointModeSupported(self, arg__1: PySide2.QtMultimedia.QCameraFocus.FocusPointMode) -> bool: ...
    def maximumDigitalZoom(self) -> float: ...
    def maximumOpticalZoom(self) -> float: ...
    def opticalZoom(self) -> float: ...
    def setCustomFocusPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def setFocusMode(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusModes) -> None: ...
    def setFocusPointMode(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusPointMode) -> None: ...
    def zoomTo(self, opticalZoom: float, digitalZoom: float) -> None: ...


class QCameraFocusControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def customFocusPoint(self) -> PySide2.QtCore.QPointF: ...
    def focusMode(self) -> PySide2.QtMultimedia.QCameraFocus.FocusModes: ...
    def focusPointMode(self) -> PySide2.QtMultimedia.QCameraFocus.FocusPointMode: ...
    def focusZones(self) -> typing.List[PySide2.QtMultimedia.QCameraFocusZone]: ...
    def isFocusModeSupported(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusModes) -> bool: ...
    def isFocusPointModeSupported(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusPointMode) -> bool: ...
    def setCustomFocusPoint(self, point: PySide2.QtCore.QPointF) -> None: ...
    def setFocusMode(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusModes) -> None: ...
    def setFocusPointMode(self, mode: PySide2.QtMultimedia.QCameraFocus.FocusPointMode) -> None: ...


class QCameraFocusZone(Shiboken.Object):
    Invalid                  : QCameraFocusZone.FocusZoneStatus = ... # 0x0
    Unused                   : QCameraFocusZone.FocusZoneStatus = ... # 0x1
    Selected                 : QCameraFocusZone.FocusZoneStatus = ... # 0x2
    Focused                  : QCameraFocusZone.FocusZoneStatus = ... # 0x3

    class FocusZoneStatus(Shiboken.Enum):
        Invalid                  : QCameraFocusZone.FocusZoneStatus = ... # 0x0
        Unused                   : QCameraFocusZone.FocusZoneStatus = ... # 0x1
        Selected                 : QCameraFocusZone.FocusZoneStatus = ... # 0x2
        Focused                  : QCameraFocusZone.FocusZoneStatus = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, area: PySide2.QtCore.QRectF, status: PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraFocusZone) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def area(self) -> PySide2.QtCore.QRectF: ...
    def isValid(self) -> bool: ...
    def setStatus(self, status: PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus) -> None: ...
    def status(self) -> PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus: ...


class QCameraImageCapture(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    CaptureToFile            : QCameraImageCapture.CaptureDestination = ... # 0x1
    CaptureToBuffer          : QCameraImageCapture.CaptureDestination = ... # 0x2
    SingleImageCapture       : QCameraImageCapture.DriveMode = ... # 0x0
    NoError                  : QCameraImageCapture.Error = ... # 0x0
    NotReadyError            : QCameraImageCapture.Error = ... # 0x1
    ResourceError            : QCameraImageCapture.Error = ... # 0x2
    OutOfSpaceError          : QCameraImageCapture.Error = ... # 0x3
    NotSupportedFeatureError : QCameraImageCapture.Error = ... # 0x4
    FormatError              : QCameraImageCapture.Error = ... # 0x5

    class CaptureDestination(Shiboken.Enum):
        CaptureToFile            : QCameraImageCapture.CaptureDestination = ... # 0x1
        CaptureToBuffer          : QCameraImageCapture.CaptureDestination = ... # 0x2

    class CaptureDestinations(object): ...

    class DriveMode(Shiboken.Enum):
        SingleImageCapture       : QCameraImageCapture.DriveMode = ... # 0x0

    class Error(Shiboken.Enum):
        NoError                  : QCameraImageCapture.Error = ... # 0x0
        NotReadyError            : QCameraImageCapture.Error = ... # 0x1
        ResourceError            : QCameraImageCapture.Error = ... # 0x2
        OutOfSpaceError          : QCameraImageCapture.Error = ... # 0x3
        NotSupportedFeatureError : QCameraImageCapture.Error = ... # 0x4
        FormatError              : QCameraImageCapture.Error = ... # 0x5

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def bufferFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def cancelCapture(self) -> None: ...
    def capture(self, location: str = ...) -> int: ...
    def captureDestination(self) -> PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations: ...
    def encodingSettings(self) -> PySide2.QtMultimedia.QImageEncoderSettings: ...
    def error(self) -> PySide2.QtMultimedia.QCameraImageCapture.Error: ...
    def errorString(self) -> str: ...
    def imageCodecDescription(self, codecName: str) -> str: ...
    def isAvailable(self) -> bool: ...
    def isCaptureDestinationSupported(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> bool: ...
    def isReadyForCapture(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setBufferFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    def setCaptureDestination(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> None: ...
    def setEncodingSettings(self, settings: PySide2.QtMultimedia.QImageEncoderSettings) -> None: ...
    def setMediaObject(self, arg__1: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def supportedBufferFormats(self) -> typing.List[PySide2.QtMultimedia.QVideoFrame.PixelFormat]: ...
    def supportedImageCodecs(self) -> typing.List[str]: ...


class QCameraImageCaptureControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def cancelCapture(self) -> None: ...
    def capture(self, fileName: str) -> int: ...
    def driveMode(self) -> PySide2.QtMultimedia.QCameraImageCapture.DriveMode: ...
    def isReadyForCapture(self) -> bool: ...
    def setDriveMode(self, mode: PySide2.QtMultimedia.QCameraImageCapture.DriveMode) -> None: ...


class QCameraImageProcessing(PySide2.QtCore.QObject):
    ColorFilterNone          : QCameraImageProcessing.ColorFilter = ... # 0x0
    ColorFilterGrayscale     : QCameraImageProcessing.ColorFilter = ... # 0x1
    ColorFilterNegative      : QCameraImageProcessing.ColorFilter = ... # 0x2
    ColorFilterSolarize      : QCameraImageProcessing.ColorFilter = ... # 0x3
    ColorFilterSepia         : QCameraImageProcessing.ColorFilter = ... # 0x4
    ColorFilterPosterize     : QCameraImageProcessing.ColorFilter = ... # 0x5
    ColorFilterWhiteboard    : QCameraImageProcessing.ColorFilter = ... # 0x6
    ColorFilterBlackboard    : QCameraImageProcessing.ColorFilter = ... # 0x7
    ColorFilterAqua          : QCameraImageProcessing.ColorFilter = ... # 0x8
    ColorFilterVendor        : QCameraImageProcessing.ColorFilter = ... # 0x3e8
    WhiteBalanceAuto         : QCameraImageProcessing.WhiteBalanceMode = ... # 0x0
    WhiteBalanceManual       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x1
    WhiteBalanceSunlight     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x2
    WhiteBalanceCloudy       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3
    WhiteBalanceShade        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x4
    WhiteBalanceTungsten     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x5
    WhiteBalanceFluorescent  : QCameraImageProcessing.WhiteBalanceMode = ... # 0x6
    WhiteBalanceFlash        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x7
    WhiteBalanceSunset       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x8
    WhiteBalanceVendor       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3e8

    class ColorFilter(Shiboken.Enum):
        ColorFilterNone          : QCameraImageProcessing.ColorFilter = ... # 0x0
        ColorFilterGrayscale     : QCameraImageProcessing.ColorFilter = ... # 0x1
        ColorFilterNegative      : QCameraImageProcessing.ColorFilter = ... # 0x2
        ColorFilterSolarize      : QCameraImageProcessing.ColorFilter = ... # 0x3
        ColorFilterSepia         : QCameraImageProcessing.ColorFilter = ... # 0x4
        ColorFilterPosterize     : QCameraImageProcessing.ColorFilter = ... # 0x5
        ColorFilterWhiteboard    : QCameraImageProcessing.ColorFilter = ... # 0x6
        ColorFilterBlackboard    : QCameraImageProcessing.ColorFilter = ... # 0x7
        ColorFilterAqua          : QCameraImageProcessing.ColorFilter = ... # 0x8
        ColorFilterVendor        : QCameraImageProcessing.ColorFilter = ... # 0x3e8

    class WhiteBalanceMode(Shiboken.Enum):
        WhiteBalanceAuto         : QCameraImageProcessing.WhiteBalanceMode = ... # 0x0
        WhiteBalanceManual       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x1
        WhiteBalanceSunlight     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x2
        WhiteBalanceCloudy       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3
        WhiteBalanceShade        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x4
        WhiteBalanceTungsten     : QCameraImageProcessing.WhiteBalanceMode = ... # 0x5
        WhiteBalanceFluorescent  : QCameraImageProcessing.WhiteBalanceMode = ... # 0x6
        WhiteBalanceFlash        : QCameraImageProcessing.WhiteBalanceMode = ... # 0x7
        WhiteBalanceSunset       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x8
        WhiteBalanceVendor       : QCameraImageProcessing.WhiteBalanceMode = ... # 0x3e8
    def brightness(self) -> float: ...
    def colorFilter(self) -> PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter: ...
    def contrast(self) -> float: ...
    def denoisingLevel(self) -> float: ...
    def isAvailable(self) -> bool: ...
    def isColorFilterSupported(self, filter: PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter) -> bool: ...
    def isWhiteBalanceModeSupported(self, mode: PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode) -> bool: ...
    def manualWhiteBalance(self) -> float: ...
    def saturation(self) -> float: ...
    def setBrightness(self, value: float) -> None: ...
    def setColorFilter(self, filter: PySide2.QtMultimedia.QCameraImageProcessing.ColorFilter) -> None: ...
    def setContrast(self, value: float) -> None: ...
    def setDenoisingLevel(self, value: float) -> None: ...
    def setManualWhiteBalance(self, colorTemperature: float) -> None: ...
    def setSaturation(self, value: float) -> None: ...
    def setSharpeningLevel(self, value: float) -> None: ...
    def setWhiteBalanceMode(self, mode: PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode) -> None: ...
    def sharpeningLevel(self) -> float: ...
    def whiteBalanceMode(self) -> PySide2.QtMultimedia.QCameraImageProcessing.WhiteBalanceMode: ...


class QCameraImageProcessingControl(PySide2.QtMultimedia.QMediaControl):
    WhiteBalancePreset       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x0
    ColorTemperature         : QCameraImageProcessingControl.ProcessingParameter = ... # 0x1
    Contrast                 : QCameraImageProcessingControl.ProcessingParameter = ... # 0x2
    Saturation               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3
    Brightness               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x4
    Sharpening               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x5
    Denoising                : QCameraImageProcessingControl.ProcessingParameter = ... # 0x6
    ContrastAdjustment       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x7
    SaturationAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x8
    BrightnessAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x9
    SharpeningAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0xa
    DenoisingAdjustment      : QCameraImageProcessingControl.ProcessingParameter = ... # 0xb
    ColorFilter              : QCameraImageProcessingControl.ProcessingParameter = ... # 0xc
    ExtendedParameter        : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3e8

    class ProcessingParameter(Shiboken.Enum):
        WhiteBalancePreset       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x0
        ColorTemperature         : QCameraImageProcessingControl.ProcessingParameter = ... # 0x1
        Contrast                 : QCameraImageProcessingControl.ProcessingParameter = ... # 0x2
        Saturation               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3
        Brightness               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x4
        Sharpening               : QCameraImageProcessingControl.ProcessingParameter = ... # 0x5
        Denoising                : QCameraImageProcessingControl.ProcessingParameter = ... # 0x6
        ContrastAdjustment       : QCameraImageProcessingControl.ProcessingParameter = ... # 0x7
        SaturationAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x8
        BrightnessAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0x9
        SharpeningAdjustment     : QCameraImageProcessingControl.ProcessingParameter = ... # 0xa
        DenoisingAdjustment      : QCameraImageProcessingControl.ProcessingParameter = ... # 0xb
        ColorFilter              : QCameraImageProcessingControl.ProcessingParameter = ... # 0xc
        ExtendedParameter        : QCameraImageProcessingControl.ProcessingParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isParameterSupported(self, arg__1: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter) -> bool: ...
    def isParameterValueSupported(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter, value: typing.Any) -> bool: ...
    def parameter(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter) -> typing.Any: ...
    def setParameter(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter, value: typing.Any) -> None: ...


class QCameraInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, camera: PySide2.QtMultimedia.QCamera) -> None: ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def availableCameras(position: PySide2.QtMultimedia.QCamera.Position = ...) -> typing.List[PySide2.QtMultimedia.QCameraInfo]: ...
    @staticmethod
    def defaultCamera() -> PySide2.QtMultimedia.QCameraInfo: ...
    def description(self) -> str: ...
    def deviceName(self) -> str: ...
    def isNull(self) -> bool: ...
    def orientation(self) -> int: ...
    def position(self) -> PySide2.QtMultimedia.QCamera.Position: ...


class QCameraInfoControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def cameraOrientation(self, deviceName: str) -> int: ...
    def cameraPosition(self, deviceName: str) -> PySide2.QtMultimedia.QCamera.Position: ...


class QCameraLocksControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def lockStatus(self, lock: PySide2.QtMultimedia.QCamera.LockType) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    def searchAndLock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes) -> None: ...
    def supportedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    def unlock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes) -> None: ...


class QCameraViewfinderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraViewfinderSettings) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isNull(self) -> bool: ...
    def maximumFrameRate(self) -> float: ...
    def minimumFrameRate(self) -> float: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setMaximumFrameRate(self, rate: float) -> None: ...
    def setMinimumFrameRate(self, rate: float) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, horizontal: int, vertical: int) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize) -> None: ...
    def setPixelFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    def swap(self, other: PySide2.QtMultimedia.QCameraViewfinderSettings) -> None: ...


class QCameraViewfinderSettingsControl(PySide2.QtMultimedia.QMediaControl):
    Resolution               : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x0
    PixelAspectRatio         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x1
    MinimumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x2
    MaximumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3
    PixelFormat              : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x4
    UserParameter            : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3e8

    class ViewfinderParameter(Shiboken.Enum):
        Resolution               : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x0
        PixelAspectRatio         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x1
        MinimumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x2
        MaximumFrameRate         : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3
        PixelFormat              : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x4
        UserParameter            : QCameraViewfinderSettingsControl.ViewfinderParameter = ... # 0x3e8

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isViewfinderParameterSupported(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter) -> bool: ...
    def setViewfinderParameter(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter, value: typing.Any) -> None: ...
    def viewfinderParameter(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter) -> typing.Any: ...


class QCameraViewfinderSettingsControl2(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def setViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings) -> None: ...
    def supportedViewfinderSettings(self) -> typing.List[PySide2.QtMultimedia.QCameraViewfinderSettings]: ...
    def viewfinderSettings(self) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...


class QCameraZoomControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def currentDigitalZoom(self) -> float: ...
    def currentOpticalZoom(self) -> float: ...
    def maximumDigitalZoom(self) -> float: ...
    def maximumOpticalZoom(self) -> float: ...
    def requestedDigitalZoom(self) -> float: ...
    def requestedOpticalZoom(self) -> float: ...
    def zoomTo(self, optical: float, digital: float) -> None: ...


class QCustomAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def customAudioRole(self) -> str: ...
    def setCustomAudioRole(self, role: str) -> None: ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...


class QImageEncoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def imageCodecDescription(self, codec: str) -> str: ...
    def imageSettings(self) -> PySide2.QtMultimedia.QImageEncoderSettings: ...
    def setImageSettings(self, settings: PySide2.QtMultimedia.QImageEncoderSettings) -> None: ...
    def supportedImageCodecs(self) -> typing.List[str]: ...


class QImageEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QImageEncoderSettings) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def codec(self) -> str: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setCodec(self, arg__1: str) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...


class QMediaAudioProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaAvailabilityControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...


class QMediaBindableInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...


class QMediaContainerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def containerDescription(self, formatMimeType: str) -> str: ...
    def containerFormat(self) -> str: ...
    def setContainerFormat(self, format: str) -> None: ...
    def supportedContainers(self) -> typing.List[str]: ...


class QMediaContent(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, contentRequest: PySide2.QtNetwork.QNetworkRequest) -> None: ...
    @typing.overload
    def __init__(self, contentResource: PySide2.QtMultimedia.QMediaResource) -> None: ...
    @typing.overload
    def __init__(self, contentUrl: PySide2.QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaContent) -> None: ...
    @typing.overload
    def __init__(self, playlist: PySide2.QtMultimedia.QMediaPlaylist, contentUrl: PySide2.QtCore.QUrl = ..., takeOwnership: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, resources: typing.Sequence[PySide2.QtMultimedia.QMediaResource]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def canonicalRequest(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def canonicalResource(self) -> PySide2.QtMultimedia.QMediaResource: ...
    def canonicalUrl(self) -> PySide2.QtCore.QUrl: ...
    def isNull(self) -> bool: ...
    def playlist(self) -> PySide2.QtMultimedia.QMediaPlaylist: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def resources(self) -> typing.List[PySide2.QtMultimedia.QMediaResource]: ...


class QMediaControl(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMediaGaplessPlaybackControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def crossfadeTime(self) -> float: ...
    def isCrossfadeSupported(self) -> bool: ...
    def nextMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def setCrossfadeTime(self, crossfadeTime: float) -> None: ...
    def setNextMedia(self, media: PySide2.QtMultimedia.QMediaContent) -> None: ...


class QMediaNetworkAccessControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def currentConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def setConfigurations(self, configuration: typing.Sequence[PySide2.QtNetwork.QNetworkConfiguration]) -> None: ...


class QMediaObject(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject, service: PySide2.QtMultimedia.QMediaService) -> None: ...

    def addPropertyWatch(self, name: PySide2.QtCore.QByteArray) -> None: ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def notifyInterval(self) -> int: ...
    def removePropertyWatch(self, name: PySide2.QtCore.QByteArray) -> None: ...
    def service(self) -> PySide2.QtMultimedia.QMediaService: ...
    def setNotifyInterval(self, milliSeconds: int) -> None: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...


class QMediaPlayer(PySide2.QtMultimedia.QMediaObject):
    NoError                  : QMediaPlayer.Error = ... # 0x0
    ResourceError            : QMediaPlayer.Error = ... # 0x1
    FormatError              : QMediaPlayer.Error = ... # 0x2
    NetworkError             : QMediaPlayer.Error = ... # 0x3
    AccessDeniedError        : QMediaPlayer.Error = ... # 0x4
    ServiceMissingError      : QMediaPlayer.Error = ... # 0x5
    MediaIsPlaylist          : QMediaPlayer.Error = ... # 0x6
    LowLatency               : QMediaPlayer.Flag = ... # 0x1
    StreamPlayback           : QMediaPlayer.Flag = ... # 0x2
    VideoSurface             : QMediaPlayer.Flag = ... # 0x4
    UnknownMediaStatus       : QMediaPlayer.MediaStatus = ... # 0x0
    NoMedia                  : QMediaPlayer.MediaStatus = ... # 0x1
    LoadingMedia             : QMediaPlayer.MediaStatus = ... # 0x2
    LoadedMedia              : QMediaPlayer.MediaStatus = ... # 0x3
    StalledMedia             : QMediaPlayer.MediaStatus = ... # 0x4
    BufferingMedia           : QMediaPlayer.MediaStatus = ... # 0x5
    BufferedMedia            : QMediaPlayer.MediaStatus = ... # 0x6
    EndOfMedia               : QMediaPlayer.MediaStatus = ... # 0x7
    InvalidMedia             : QMediaPlayer.MediaStatus = ... # 0x8
    StoppedState             : QMediaPlayer.State = ... # 0x0
    PlayingState             : QMediaPlayer.State = ... # 0x1
    PausedState              : QMediaPlayer.State = ... # 0x2

    class Error(Shiboken.Enum):
        NoError                  : QMediaPlayer.Error = ... # 0x0
        ResourceError            : QMediaPlayer.Error = ... # 0x1
        FormatError              : QMediaPlayer.Error = ... # 0x2
        NetworkError             : QMediaPlayer.Error = ... # 0x3
        AccessDeniedError        : QMediaPlayer.Error = ... # 0x4
        ServiceMissingError      : QMediaPlayer.Error = ... # 0x5
        MediaIsPlaylist          : QMediaPlayer.Error = ... # 0x6

    class Flag(Shiboken.Enum):
        LowLatency               : QMediaPlayer.Flag = ... # 0x1
        StreamPlayback           : QMediaPlayer.Flag = ... # 0x2
        VideoSurface             : QMediaPlayer.Flag = ... # 0x4

    class Flags(object): ...

    class MediaStatus(Shiboken.Enum):
        UnknownMediaStatus       : QMediaPlayer.MediaStatus = ... # 0x0
        NoMedia                  : QMediaPlayer.MediaStatus = ... # 0x1
        LoadingMedia             : QMediaPlayer.MediaStatus = ... # 0x2
        LoadedMedia              : QMediaPlayer.MediaStatus = ... # 0x3
        StalledMedia             : QMediaPlayer.MediaStatus = ... # 0x4
        BufferingMedia           : QMediaPlayer.MediaStatus = ... # 0x5
        BufferedMedia            : QMediaPlayer.MediaStatus = ... # 0x6
        EndOfMedia               : QMediaPlayer.MediaStatus = ... # 0x7
        InvalidMedia             : QMediaPlayer.MediaStatus = ... # 0x8

    class State(Shiboken.Enum):
        StoppedState             : QMediaPlayer.State = ... # 0x0
        PlayingState             : QMediaPlayer.State = ... # 0x1
        PausedState              : QMediaPlayer.State = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ..., flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> None: ...

    def audioRole(self) -> PySide2.QtMultimedia.QAudio.Role: ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferStatus(self) -> int: ...
    def currentMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def currentNetworkConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def customAudioRole(self) -> str: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QMediaPlayer.Error: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.Sequence[str] = ..., flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaStatus(self) -> PySide2.QtMultimedia.QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def playbackRate(self) -> float: ...
    def playlist(self) -> PySide2.QtMultimedia.QMediaPlaylist: ...
    def position(self) -> int: ...
    def setAudioRole(self, audioRole: PySide2.QtMultimedia.QAudio.Role) -> None: ...
    def setCustomAudioRole(self, audioRole: str) -> None: ...
    def setMedia(self, media: PySide2.QtMultimedia.QMediaContent, stream: typing.Optional[PySide2.QtCore.QIODevice] = ...) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setNetworkConfigurations(self, configurations: typing.Sequence[PySide2.QtNetwork.QNetworkConfiguration]) -> None: ...
    def setPlaybackRate(self, rate: float) -> None: ...
    def setPlaylist(self, playlist: PySide2.QtMultimedia.QMediaPlaylist) -> None: ...
    def setPosition(self, position: int) -> None: ...
    @typing.overload
    def setVideoOutput(self, arg__1: PySide2.QtMultimediaWidgets.QGraphicsVideoItem) -> None: ...
    @typing.overload
    def setVideoOutput(self, arg__1: PySide2.QtMultimediaWidgets.QVideoWidget) -> None: ...
    @typing.overload
    def setVideoOutput(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface) -> None: ...
    @typing.overload
    def setVideoOutput(self, surfaces: typing.List[PySide2.QtMultimedia.QAbstractVideoSurface]) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QMediaPlayer.State: ...
    def stop(self) -> None: ...
    def supportedAudioRoles(self) -> typing.List[PySide2.QtMultimedia.QAudio.Role]: ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...
    @staticmethod
    def supportedMimeTypes(flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> typing.List[str]: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject) -> None: ...
    def volume(self) -> int: ...


class QMediaPlayerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availablePlaybackRanges(self) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    def bufferStatus(self) -> int: ...
    def duration(self) -> int: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaStatus(self) -> PySide2.QtMultimedia.QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def playbackRate(self) -> float: ...
    def position(self) -> int: ...
    def setMedia(self, media: PySide2.QtMultimedia.QMediaContent, stream: PySide2.QtCore.QIODevice) -> None: ...
    def setMuted(self, mute: bool) -> None: ...
    def setPlaybackRate(self, rate: float) -> None: ...
    def setPosition(self, position: int) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QMediaPlayer.State: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...


class QMediaPlaylist(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QMediaPlaylist.Error = ... # 0x0
    FormatError              : QMediaPlaylist.Error = ... # 0x1
    FormatNotSupportedError  : QMediaPlaylist.Error = ... # 0x2
    NetworkError             : QMediaPlaylist.Error = ... # 0x3
    AccessDeniedError        : QMediaPlaylist.Error = ... # 0x4
    CurrentItemOnce          : QMediaPlaylist.PlaybackMode = ... # 0x0
    CurrentItemInLoop        : QMediaPlaylist.PlaybackMode = ... # 0x1
    Sequential               : QMediaPlaylist.PlaybackMode = ... # 0x2
    Loop                     : QMediaPlaylist.PlaybackMode = ... # 0x3
    Random                   : QMediaPlaylist.PlaybackMode = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QMediaPlaylist.Error = ... # 0x0
        FormatError              : QMediaPlaylist.Error = ... # 0x1
        FormatNotSupportedError  : QMediaPlaylist.Error = ... # 0x2
        NetworkError             : QMediaPlaylist.Error = ... # 0x3
        AccessDeniedError        : QMediaPlaylist.Error = ... # 0x4

    class PlaybackMode(Shiboken.Enum):
        CurrentItemOnce          : QMediaPlaylist.PlaybackMode = ... # 0x0
        CurrentItemInLoop        : QMediaPlaylist.PlaybackMode = ... # 0x1
        Sequential               : QMediaPlaylist.PlaybackMode = ... # 0x2
        Loop                     : QMediaPlaylist.PlaybackMode = ... # 0x3
        Random                   : QMediaPlaylist.PlaybackMode = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    @typing.overload
    def addMedia(self, content: PySide2.QtMultimedia.QMediaContent) -> bool: ...
    @typing.overload
    def addMedia(self, items: typing.Sequence[PySide2.QtMultimedia.QMediaContent]) -> bool: ...
    def clear(self) -> bool: ...
    def currentIndex(self) -> int: ...
    def currentMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def error(self) -> PySide2.QtMultimedia.QMediaPlaylist.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    def insertMedia(self, index: int, content: PySide2.QtMultimedia.QMediaContent) -> bool: ...
    @typing.overload
    def insertMedia(self, index: int, items: typing.Sequence[PySide2.QtMultimedia.QMediaContent]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @typing.overload
    def load(self, device: PySide2.QtCore.QIODevice, format: typing.Optional[bytes] = ...) -> None: ...
    @typing.overload
    def load(self, location: PySide2.QtCore.QUrl, format: typing.Optional[bytes] = ...) -> None: ...
    @typing.overload
    def load(self, request: PySide2.QtNetwork.QNetworkRequest, format: typing.Optional[bytes] = ...) -> None: ...
    def media(self, index: int) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaCount(self) -> int: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def moveMedia(self, from_: int, to: int) -> bool: ...
    def next(self) -> None: ...
    def nextIndex(self, steps: int = ...) -> int: ...
    def playbackMode(self) -> PySide2.QtMultimedia.QMediaPlaylist.PlaybackMode: ...
    def previous(self) -> None: ...
    def previousIndex(self, steps: int = ...) -> int: ...
    @typing.overload
    def removeMedia(self, pos: int) -> bool: ...
    @typing.overload
    def removeMedia(self, start: int, end: int) -> bool: ...
    @typing.overload
    def save(self, device: PySide2.QtCore.QIODevice, format: bytes) -> bool: ...
    @typing.overload
    def save(self, location: PySide2.QtCore.QUrl, format: typing.Optional[bytes] = ...) -> bool: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setPlaybackMode(self, mode: PySide2.QtMultimedia.QMediaPlaylist.PlaybackMode) -> None: ...
    def shuffle(self) -> None: ...


class QMediaRecorder(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QMediaRecorder.Error = ... # 0x0
    ResourceError            : QMediaRecorder.Error = ... # 0x1
    FormatError              : QMediaRecorder.Error = ... # 0x2
    OutOfSpaceError          : QMediaRecorder.Error = ... # 0x3
    StoppedState             : QMediaRecorder.State = ... # 0x0
    RecordingState           : QMediaRecorder.State = ... # 0x1
    PausedState              : QMediaRecorder.State = ... # 0x2
    UnavailableStatus        : QMediaRecorder.Status = ... # 0x0
    UnloadedStatus           : QMediaRecorder.Status = ... # 0x1
    LoadingStatus            : QMediaRecorder.Status = ... # 0x2
    LoadedStatus             : QMediaRecorder.Status = ... # 0x3
    StartingStatus           : QMediaRecorder.Status = ... # 0x4
    RecordingStatus          : QMediaRecorder.Status = ... # 0x5
    PausedStatus             : QMediaRecorder.Status = ... # 0x6
    FinalizingStatus         : QMediaRecorder.Status = ... # 0x7

    class Error(Shiboken.Enum):
        NoError                  : QMediaRecorder.Error = ... # 0x0
        ResourceError            : QMediaRecorder.Error = ... # 0x1
        FormatError              : QMediaRecorder.Error = ... # 0x2
        OutOfSpaceError          : QMediaRecorder.Error = ... # 0x3

    class State(Shiboken.Enum):
        StoppedState             : QMediaRecorder.State = ... # 0x0
        RecordingState           : QMediaRecorder.State = ... # 0x1
        PausedState              : QMediaRecorder.State = ... # 0x2

    class Status(Shiboken.Enum):
        UnavailableStatus        : QMediaRecorder.Status = ... # 0x0
        UnloadedStatus           : QMediaRecorder.Status = ... # 0x1
        LoadingStatus            : QMediaRecorder.Status = ... # 0x2
        LoadedStatus             : QMediaRecorder.Status = ... # 0x3
        StartingStatus           : QMediaRecorder.Status = ... # 0x4
        RecordingStatus          : QMediaRecorder.Status = ... # 0x5
        PausedStatus             : QMediaRecorder.Status = ... # 0x6
        FinalizingStatus         : QMediaRecorder.Status = ... # 0x7

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def actualLocation(self) -> PySide2.QtCore.QUrl: ...
    def audioCodecDescription(self, codecName: str) -> str: ...
    def audioSettings(self) -> PySide2.QtMultimedia.QAudioEncoderSettings: ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def containerDescription(self, format: str) -> str: ...
    def containerFormat(self) -> str: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QMediaRecorder.Error: ...
    def errorString(self) -> str: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isMetaDataWritable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def metaData(self, key: str) -> typing.Any: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def pause(self) -> None: ...
    def record(self) -> None: ...
    def setAudioSettings(self, audioSettings: PySide2.QtMultimedia.QAudioEncoderSettings) -> None: ...
    def setContainerFormat(self, container: str) -> None: ...
    def setEncodingSettings(self, audioSettings: PySide2.QtMultimedia.QAudioEncoderSettings, videoSettings: PySide2.QtMultimedia.QVideoEncoderSettings = ..., containerMimeType: str = ...) -> None: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setVideoSettings(self, videoSettings: PySide2.QtMultimedia.QVideoEncoderSettings) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QMediaRecorder.State: ...
    def status(self) -> PySide2.QtMultimedia.QMediaRecorder.Status: ...
    def stop(self) -> None: ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...
    def supportedContainers(self) -> typing.List[str]: ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codecName: str) -> str: ...
    def videoSettings(self) -> PySide2.QtMultimedia.QVideoEncoderSettings: ...
    def volume(self) -> float: ...


class QMediaRecorderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def applySettings(self) -> None: ...
    def duration(self) -> int: ...
    def isMuted(self) -> bool: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def setMuted(self, muted: bool) -> None: ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setState(self, state: PySide2.QtMultimedia.QMediaRecorder.State) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QMediaRecorder.State: ...
    def status(self) -> PySide2.QtMultimedia.QMediaRecorder.Status: ...
    def volume(self) -> float: ...


class QMediaResource(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaResource) -> None: ...
    @typing.overload
    def __init__(self, request: PySide2.QtNetwork.QNetworkRequest, mimeType: str = ...) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, mimeType: str = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def audioBitRate(self) -> int: ...
    def audioCodec(self) -> str: ...
    def channelCount(self) -> int: ...
    def dataSize(self) -> int: ...
    def isNull(self) -> bool: ...
    def language(self) -> str: ...
    def mimeType(self) -> str: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def sampleRate(self) -> int: ...
    def setAudioBitRate(self, rate: int) -> None: ...
    def setAudioCodec(self, codec: str) -> None: ...
    def setChannelCount(self, channels: int) -> None: ...
    def setDataSize(self, size: int) -> None: ...
    def setLanguage(self, language: str) -> None: ...
    @typing.overload
    def setResolution(self, resolution: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...
    def setSampleRate(self, frequency: int) -> None: ...
    def setVideoBitRate(self, rate: int) -> None: ...
    def setVideoCodec(self, codec: str) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def videoBitRate(self) -> int: ...
    def videoCodec(self) -> str: ...


class QMediaService(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject) -> None: ...

    def releaseControl(self, control: PySide2.QtMultimedia.QMediaControl) -> None: ...
    def requestControl(self, name: bytes) -> PySide2.QtMultimedia.QMediaControl: ...


class QMediaServiceCameraInfoInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def cameraOrientation(self, device: PySide2.QtCore.QByteArray) -> int: ...
    def cameraPosition(self, device: PySide2.QtCore.QByteArray) -> PySide2.QtMultimedia.QCamera.Position: ...


class QMediaServiceDefaultDeviceInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def defaultDevice(self, service: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...


class QMediaServiceFeaturesInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def supportedFeatures(self, service: PySide2.QtCore.QByteArray) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Features: ...


class QMediaServiceProviderHint(Shiboken.Object):
    LowLatencyPlayback       : QMediaServiceProviderHint.Feature = ... # 0x1
    RecordingSupport         : QMediaServiceProviderHint.Feature = ... # 0x2
    StreamPlayback           : QMediaServiceProviderHint.Feature = ... # 0x4
    VideoSurface             : QMediaServiceProviderHint.Feature = ... # 0x8
    Null                     : QMediaServiceProviderHint.Type = ... # 0x0
    ContentType              : QMediaServiceProviderHint.Type = ... # 0x1
    Device                   : QMediaServiceProviderHint.Type = ... # 0x2
    SupportedFeatures        : QMediaServiceProviderHint.Type = ... # 0x3
    CameraPosition           : QMediaServiceProviderHint.Type = ... # 0x4

    class Feature(Shiboken.Enum):
        LowLatencyPlayback       : QMediaServiceProviderHint.Feature = ... # 0x1
        RecordingSupport         : QMediaServiceProviderHint.Feature = ... # 0x2
        StreamPlayback           : QMediaServiceProviderHint.Feature = ... # 0x4
        VideoSurface             : QMediaServiceProviderHint.Feature = ... # 0x8

    class Features(object): ...

    class Type(Shiboken.Enum):
        Null                     : QMediaServiceProviderHint.Type = ... # 0x0
        ContentType              : QMediaServiceProviderHint.Type = ... # 0x1
        Device                   : QMediaServiceProviderHint.Type = ... # 0x2
        SupportedFeatures        : QMediaServiceProviderHint.Type = ... # 0x3
        CameraPosition           : QMediaServiceProviderHint.Type = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, features: PySide2.QtMultimedia.QMediaServiceProviderHint.Features) -> None: ...
    @typing.overload
    def __init__(self, mimeType: str, codecs: typing.Sequence[str]) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaServiceProviderHint) -> None: ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cameraPosition(self) -> PySide2.QtMultimedia.QCamera.Position: ...
    def codecs(self) -> typing.List[str]: ...
    def device(self) -> PySide2.QtCore.QByteArray: ...
    def features(self) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Features: ...
    def isNull(self) -> bool: ...
    def mimeType(self) -> str: ...
    def type(self) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Type: ...


class QMediaServiceSupportedDevicesInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def deviceDescription(self, service: PySide2.QtCore.QByteArray, device: PySide2.QtCore.QByteArray) -> str: ...
    def devices(self, service: PySide2.QtCore.QByteArray) -> typing.List[PySide2.QtCore.QByteArray]: ...


class QMediaServiceSupportedFormatsInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def hasSupport(self, mimeType: str, codecs: typing.Sequence[str]) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def supportedMimeTypes(self) -> typing.List[str]: ...


class QMediaStreamsControl(PySide2.QtMultimedia.QMediaControl):
    UnknownStream            : QMediaStreamsControl.StreamType = ... # 0x0
    VideoStream              : QMediaStreamsControl.StreamType = ... # 0x1
    AudioStream              : QMediaStreamsControl.StreamType = ... # 0x2
    SubPictureStream         : QMediaStreamsControl.StreamType = ... # 0x3
    DataStream               : QMediaStreamsControl.StreamType = ... # 0x4

    class StreamType(Shiboken.Enum):
        UnknownStream            : QMediaStreamsControl.StreamType = ... # 0x0
        VideoStream              : QMediaStreamsControl.StreamType = ... # 0x1
        AudioStream              : QMediaStreamsControl.StreamType = ... # 0x2
        SubPictureStream         : QMediaStreamsControl.StreamType = ... # 0x3
        DataStream               : QMediaStreamsControl.StreamType = ... # 0x4

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isActive(self, streamNumber: int) -> bool: ...
    def metaData(self, streamNumber: int, key: str) -> typing.Any: ...
    def setActive(self, streamNumber: int, state: bool) -> None: ...
    def streamCount(self) -> int: ...
    def streamType(self, streamNumber: int) -> PySide2.QtMultimedia.QMediaStreamsControl.StreamType: ...


class QMediaTimeInterval(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def contains(self, time: int) -> bool: ...
    def end(self) -> int: ...
    def isNormal(self) -> bool: ...
    def normalized(self) -> PySide2.QtMultimedia.QMediaTimeInterval: ...
    def start(self) -> int: ...
    def translated(self, offset: int) -> PySide2.QtMultimedia.QMediaTimeInterval: ...


class QMediaTimeRange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def __init__(self, range: PySide2.QtMultimedia.QMediaTimeRange) -> None: ...
    @typing.overload
    def __init__(self, start: int, end: int) -> None: ...

    def __add__(self, arg__2: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __iadd__(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    def __sub__(self, arg__2: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def addInterval(self, interval: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def addInterval(self, start: int, end: int) -> None: ...
    def addTimeRange(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> None: ...
    def clear(self) -> None: ...
    def contains(self, time: int) -> bool: ...
    def earliestTime(self) -> int: ...
    def intervals(self) -> typing.List[PySide2.QtMultimedia.QMediaTimeInterval]: ...
    def isContinuous(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def latestTime(self) -> int: ...
    @typing.overload
    def removeInterval(self, interval: PySide2.QtMultimedia.QMediaTimeInterval) -> None: ...
    @typing.overload
    def removeInterval(self, start: int, end: int) -> None: ...
    def removeTimeRange(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> None: ...


class QMediaVideoProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


class QMetaDataReaderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...


class QMetaDataWriterControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...


class QMultimedia(Shiboken.Object):
    Available                : QMultimedia.AvailabilityStatus = ... # 0x0
    ServiceMissing           : QMultimedia.AvailabilityStatus = ... # 0x1
    Busy                     : QMultimedia.AvailabilityStatus = ... # 0x2
    ResourceError            : QMultimedia.AvailabilityStatus = ... # 0x3
    ConstantQualityEncoding  : QMultimedia.EncodingMode = ... # 0x0
    ConstantBitRateEncoding  : QMultimedia.EncodingMode = ... # 0x1
    AverageBitRateEncoding   : QMultimedia.EncodingMode = ... # 0x2
    TwoPassEncoding          : QMultimedia.EncodingMode = ... # 0x3
    VeryLowQuality           : QMultimedia.EncodingQuality = ... # 0x0
    LowQuality               : QMultimedia.EncodingQuality = ... # 0x1
    NormalQuality            : QMultimedia.EncodingQuality = ... # 0x2
    HighQuality              : QMultimedia.EncodingQuality = ... # 0x3
    VeryHighQuality          : QMultimedia.EncodingQuality = ... # 0x4
    NotSupported             : QMultimedia.SupportEstimate = ... # 0x0
    MaybeSupported           : QMultimedia.SupportEstimate = ... # 0x1
    ProbablySupported        : QMultimedia.SupportEstimate = ... # 0x2
    PreferredService         : QMultimedia.SupportEstimate = ... # 0x3

    class AvailabilityStatus(Shiboken.Enum):
        Available                : QMultimedia.AvailabilityStatus = ... # 0x0
        ServiceMissing           : QMultimedia.AvailabilityStatus = ... # 0x1
        Busy                     : QMultimedia.AvailabilityStatus = ... # 0x2
        ResourceError            : QMultimedia.AvailabilityStatus = ... # 0x3

    class EncodingMode(Shiboken.Enum):
        ConstantQualityEncoding  : QMultimedia.EncodingMode = ... # 0x0
        ConstantBitRateEncoding  : QMultimedia.EncodingMode = ... # 0x1
        AverageBitRateEncoding   : QMultimedia.EncodingMode = ... # 0x2
        TwoPassEncoding          : QMultimedia.EncodingMode = ... # 0x3

    class EncodingQuality(Shiboken.Enum):
        VeryLowQuality           : QMultimedia.EncodingQuality = ... # 0x0
        LowQuality               : QMultimedia.EncodingQuality = ... # 0x1
        NormalQuality            : QMultimedia.EncodingQuality = ... # 0x2
        HighQuality              : QMultimedia.EncodingQuality = ... # 0x3
        VeryHighQuality          : QMultimedia.EncodingQuality = ... # 0x4

    class SupportEstimate(Shiboken.Enum):
        NotSupported             : QMultimedia.SupportEstimate = ... # 0x0
        MaybeSupported           : QMultimedia.SupportEstimate = ... # 0x1
        ProbablySupported        : QMultimedia.SupportEstimate = ... # 0x2
        PreferredService         : QMultimedia.SupportEstimate = ... # 0x3


class QRadioData(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):
    NoError                  : QRadioData.Error = ... # 0x0
    ResourceError            : QRadioData.Error = ... # 0x1
    OpenError                : QRadioData.Error = ... # 0x2
    OutOfRangeError          : QRadioData.Error = ... # 0x3
    Undefined                : QRadioData.ProgramType = ... # 0x0
    News                     : QRadioData.ProgramType = ... # 0x1
    CurrentAffairs           : QRadioData.ProgramType = ... # 0x2
    Information              : QRadioData.ProgramType = ... # 0x3
    Sport                    : QRadioData.ProgramType = ... # 0x4
    Education                : QRadioData.ProgramType = ... # 0x5
    Drama                    : QRadioData.ProgramType = ... # 0x6
    Culture                  : QRadioData.ProgramType = ... # 0x7
    Science                  : QRadioData.ProgramType = ... # 0x8
    Varied                   : QRadioData.ProgramType = ... # 0x9
    PopMusic                 : QRadioData.ProgramType = ... # 0xa
    RockMusic                : QRadioData.ProgramType = ... # 0xb
    EasyListening            : QRadioData.ProgramType = ... # 0xc
    LightClassical           : QRadioData.ProgramType = ... # 0xd
    SeriousClassical         : QRadioData.ProgramType = ... # 0xe
    OtherMusic               : QRadioData.ProgramType = ... # 0xf
    Weather                  : QRadioData.ProgramType = ... # 0x10
    Finance                  : QRadioData.ProgramType = ... # 0x11
    ChildrensProgrammes      : QRadioData.ProgramType = ... # 0x12
    SocialAffairs            : QRadioData.ProgramType = ... # 0x13
    Religion                 : QRadioData.ProgramType = ... # 0x14
    PhoneIn                  : QRadioData.ProgramType = ... # 0x15
    Travel                   : QRadioData.ProgramType = ... # 0x16
    Leisure                  : QRadioData.ProgramType = ... # 0x17
    JazzMusic                : QRadioData.ProgramType = ... # 0x18
    CountryMusic             : QRadioData.ProgramType = ... # 0x19
    NationalMusic            : QRadioData.ProgramType = ... # 0x1a
    OldiesMusic              : QRadioData.ProgramType = ... # 0x1b
    FolkMusic                : QRadioData.ProgramType = ... # 0x1c
    Documentary              : QRadioData.ProgramType = ... # 0x1d
    AlarmTest                : QRadioData.ProgramType = ... # 0x1e
    Alarm                    : QRadioData.ProgramType = ... # 0x1f
    Talk                     : QRadioData.ProgramType = ... # 0x20
    ClassicRock              : QRadioData.ProgramType = ... # 0x21
    AdultHits                : QRadioData.ProgramType = ... # 0x22
    SoftRock                 : QRadioData.ProgramType = ... # 0x23
    Top40                    : QRadioData.ProgramType = ... # 0x24
    Soft                     : QRadioData.ProgramType = ... # 0x25
    Nostalgia                : QRadioData.ProgramType = ... # 0x26
    Classical                : QRadioData.ProgramType = ... # 0x27
    RhythmAndBlues           : QRadioData.ProgramType = ... # 0x28
    SoftRhythmAndBlues       : QRadioData.ProgramType = ... # 0x29
    Language                 : QRadioData.ProgramType = ... # 0x2a
    ReligiousMusic           : QRadioData.ProgramType = ... # 0x2b
    ReligiousTalk            : QRadioData.ProgramType = ... # 0x2c
    Personality              : QRadioData.ProgramType = ... # 0x2d
    Public                   : QRadioData.ProgramType = ... # 0x2e
    College                  : QRadioData.ProgramType = ... # 0x2f

    class Error(Shiboken.Enum):
        NoError                  : QRadioData.Error = ... # 0x0
        ResourceError            : QRadioData.Error = ... # 0x1
        OpenError                : QRadioData.Error = ... # 0x2
        OutOfRangeError          : QRadioData.Error = ... # 0x3

    class ProgramType(Shiboken.Enum):
        Undefined                : QRadioData.ProgramType = ... # 0x0
        News                     : QRadioData.ProgramType = ... # 0x1
        CurrentAffairs           : QRadioData.ProgramType = ... # 0x2
        Information              : QRadioData.ProgramType = ... # 0x3
        Sport                    : QRadioData.ProgramType = ... # 0x4
        Education                : QRadioData.ProgramType = ... # 0x5
        Drama                    : QRadioData.ProgramType = ... # 0x6
        Culture                  : QRadioData.ProgramType = ... # 0x7
        Science                  : QRadioData.ProgramType = ... # 0x8
        Varied                   : QRadioData.ProgramType = ... # 0x9
        PopMusic                 : QRadioData.ProgramType = ... # 0xa
        RockMusic                : QRadioData.ProgramType = ... # 0xb
        EasyListening            : QRadioData.ProgramType = ... # 0xc
        LightClassical           : QRadioData.ProgramType = ... # 0xd
        SeriousClassical         : QRadioData.ProgramType = ... # 0xe
        OtherMusic               : QRadioData.ProgramType = ... # 0xf
        Weather                  : QRadioData.ProgramType = ... # 0x10
        Finance                  : QRadioData.ProgramType = ... # 0x11
        ChildrensProgrammes      : QRadioData.ProgramType = ... # 0x12
        SocialAffairs            : QRadioData.ProgramType = ... # 0x13
        Religion                 : QRadioData.ProgramType = ... # 0x14
        PhoneIn                  : QRadioData.ProgramType = ... # 0x15
        Travel                   : QRadioData.ProgramType = ... # 0x16
        Leisure                  : QRadioData.ProgramType = ... # 0x17
        JazzMusic                : QRadioData.ProgramType = ... # 0x18
        CountryMusic             : QRadioData.ProgramType = ... # 0x19
        NationalMusic            : QRadioData.ProgramType = ... # 0x1a
        OldiesMusic              : QRadioData.ProgramType = ... # 0x1b
        FolkMusic                : QRadioData.ProgramType = ... # 0x1c
        Documentary              : QRadioData.ProgramType = ... # 0x1d
        AlarmTest                : QRadioData.ProgramType = ... # 0x1e
        Alarm                    : QRadioData.ProgramType = ... # 0x1f
        Talk                     : QRadioData.ProgramType = ... # 0x20
        ClassicRock              : QRadioData.ProgramType = ... # 0x21
        AdultHits                : QRadioData.ProgramType = ... # 0x22
        SoftRock                 : QRadioData.ProgramType = ... # 0x23
        Top40                    : QRadioData.ProgramType = ... # 0x24
        Soft                     : QRadioData.ProgramType = ... # 0x25
        Nostalgia                : QRadioData.ProgramType = ... # 0x26
        Classical                : QRadioData.ProgramType = ... # 0x27
        RhythmAndBlues           : QRadioData.ProgramType = ... # 0x28
        SoftRhythmAndBlues       : QRadioData.ProgramType = ... # 0x29
        Language                 : QRadioData.ProgramType = ... # 0x2a
        ReligiousMusic           : QRadioData.ProgramType = ... # 0x2b
        ReligiousTalk            : QRadioData.ProgramType = ... # 0x2c
        Personality              : QRadioData.ProgramType = ... # 0x2d
        Public                   : QRadioData.ProgramType = ... # 0x2e
        College                  : QRadioData.ProgramType = ... # 0x2f

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def error(self) -> PySide2.QtMultimedia.QRadioData.Error: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def programType(self) -> PySide2.QtMultimedia.QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None: ...
    def setMediaObject(self, arg__1: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...


class QRadioDataControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def error(self) -> PySide2.QtMultimedia.QRadioData.Error: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def programType(self) -> PySide2.QtMultimedia.QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool) -> None: ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...


class QRadioTuner(PySide2.QtMultimedia.QMediaObject):
    AM                       : QRadioTuner.Band = ... # 0x0
    FM                       : QRadioTuner.Band = ... # 0x1
    SW                       : QRadioTuner.Band = ... # 0x2
    LW                       : QRadioTuner.Band = ... # 0x3
    FM2                      : QRadioTuner.Band = ... # 0x4
    NoError                  : QRadioTuner.Error = ... # 0x0
    ResourceError            : QRadioTuner.Error = ... # 0x1
    OpenError                : QRadioTuner.Error = ... # 0x2
    OutOfRangeError          : QRadioTuner.Error = ... # 0x3
    SearchFast               : QRadioTuner.SearchMode = ... # 0x0
    SearchGetStationId       : QRadioTuner.SearchMode = ... # 0x1
    ActiveState              : QRadioTuner.State = ... # 0x0
    StoppedState             : QRadioTuner.State = ... # 0x1
    ForceStereo              : QRadioTuner.StereoMode = ... # 0x0
    ForceMono                : QRadioTuner.StereoMode = ... # 0x1
    Auto                     : QRadioTuner.StereoMode = ... # 0x2

    class Band(Shiboken.Enum):
        AM                       : QRadioTuner.Band = ... # 0x0
        FM                       : QRadioTuner.Band = ... # 0x1
        SW                       : QRadioTuner.Band = ... # 0x2
        LW                       : QRadioTuner.Band = ... # 0x3
        FM2                      : QRadioTuner.Band = ... # 0x4

    class Error(Shiboken.Enum):
        NoError                  : QRadioTuner.Error = ... # 0x0
        ResourceError            : QRadioTuner.Error = ... # 0x1
        OpenError                : QRadioTuner.Error = ... # 0x2
        OutOfRangeError          : QRadioTuner.Error = ... # 0x3

    class SearchMode(Shiboken.Enum):
        SearchFast               : QRadioTuner.SearchMode = ... # 0x0
        SearchGetStationId       : QRadioTuner.SearchMode = ... # 0x1

    class State(Shiboken.Enum):
        ActiveState              : QRadioTuner.State = ... # 0x0
        StoppedState             : QRadioTuner.State = ... # 0x1

    class StereoMode(Shiboken.Enum):
        ForceStereo              : QRadioTuner.StereoMode = ... # 0x0
        ForceMono                : QRadioTuner.StereoMode = ... # 0x1
        Auto                     : QRadioTuner.StereoMode = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def band(self) -> PySide2.QtMultimedia.QRadioTuner.Band: ...
    def cancelSearch(self) -> None: ...
    def error(self) -> PySide2.QtMultimedia.QRadioTuner.Error: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, band: PySide2.QtMultimedia.QRadioTuner.Band) -> typing.Tuple[int, int]: ...
    def frequencyStep(self, band: PySide2.QtMultimedia.QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def radioData(self) -> PySide2.QtMultimedia.QRadioData: ...
    def searchAllStations(self, searchMode: PySide2.QtMultimedia.QRadioTuner.SearchMode = ...) -> None: ...
    def searchBackward(self) -> None: ...
    def searchForward(self) -> None: ...
    def setBand(self, band: PySide2.QtMultimedia.QRadioTuner.Band) -> None: ...
    def setFrequency(self, frequency: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setStereoMode(self, mode: PySide2.QtMultimedia.QRadioTuner.StereoMode) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def signalStrength(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QRadioTuner.State: ...
    def stereoMode(self) -> PySide2.QtMultimedia.QRadioTuner.StereoMode: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...


class QRadioTunerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def band(self) -> PySide2.QtMultimedia.QRadioTuner.Band: ...
    def cancelSearch(self) -> None: ...
    def error(self) -> PySide2.QtMultimedia.QRadioTuner.Error: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> typing.Tuple[int, int]: ...
    def frequencyStep(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def searchAllStations(self, searchMode: PySide2.QtMultimedia.QRadioTuner.SearchMode = ...) -> None: ...
    def searchBackward(self) -> None: ...
    def searchForward(self) -> None: ...
    def setBand(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> None: ...
    def setFrequency(self, frequency: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setStereoMode(self, mode: PySide2.QtMultimedia.QRadioTuner.StereoMode) -> None: ...
    def setVolume(self, volume: int) -> None: ...
    def signalStrength(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtMultimedia.QRadioTuner.State: ...
    def stereoMode(self) -> PySide2.QtMultimedia.QRadioTuner.StereoMode: ...
    def stop(self) -> None: ...
    def volume(self) -> int: ...


class QSound(PySide2.QtCore.QObject):
    Infinite                 : QSound.Loop = ... # -0x1

    class Loop(Shiboken.Enum):
        Infinite                 : QSound.Loop = ... # -0x1

    def __init__(self, filename: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def fileName(self) -> str: ...
    def isFinished(self) -> bool: ...
    def loops(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    @typing.overload
    @staticmethod
    def play(filename: str) -> None: ...
    @typing.overload
    def play(self) -> None: ...
    def setLoops(self, arg__1: int) -> None: ...
    def stop(self) -> None: ...


class QSoundEffect(PySide2.QtCore.QObject):
    Infinite                 : QSoundEffect.Loop = ... # -0x2
    Null                     : QSoundEffect.Status = ... # 0x0
    Loading                  : QSoundEffect.Status = ... # 0x1
    Ready                    : QSoundEffect.Status = ... # 0x2
    Error                    : QSoundEffect.Status = ... # 0x3

    class Loop(Shiboken.Enum):
        Infinite                 : QSoundEffect.Loop = ... # -0x2

    class Status(Shiboken.Enum):
        Null                     : QSoundEffect.Status = ... # 0x0
        Loading                  : QSoundEffect.Status = ... # 0x1
        Ready                    : QSoundEffect.Status = ... # 0x2
        Error                    : QSoundEffect.Status = ... # 0x3

    @typing.overload
    def __init__(self, audioDevice: PySide2.QtMultimedia.QAudioDeviceInfo, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def category(self) -> str: ...
    def isLoaded(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isPlaying(self) -> bool: ...
    def loopCount(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    def play(self) -> None: ...
    def setCategory(self, category: str) -> None: ...
    def setLoopCount(self, loopCount: int) -> None: ...
    def setMuted(self, muted: bool) -> None: ...
    def setSource(self, url: PySide2.QtCore.QUrl) -> None: ...
    def setVolume(self, volume: float) -> None: ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def status(self) -> PySide2.QtMultimedia.QSoundEffect.Status: ...
    def stop(self) -> None: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[str]: ...
    def volume(self) -> float: ...


class QVideoDeviceSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def defaultDevice(self) -> int: ...
    def deviceCount(self) -> int: ...
    def deviceDescription(self, index: int) -> str: ...
    def deviceName(self, index: int) -> str: ...
    def selectedDevice(self) -> int: ...
    def setSelectedDevice(self, index: int) -> None: ...


class QVideoEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoEncoderSettings) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bitRate(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> PySide2.QtMultimedia.QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> typing.Dict[str, typing.Any]: ...
    def frameRate(self) -> float: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setBitRate(self, bitrate: int) -> None: ...
    def setCodec(self, arg__1: str) -> None: ...
    def setEncodingMode(self, arg__1: PySide2.QtMultimedia.QMultimedia.EncodingMode) -> None: ...
    def setEncodingOption(self, option: str, value: typing.Any) -> None: ...
    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None: ...
    def setFrameRate(self, rate: float) -> None: ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality) -> None: ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setResolution(self, width: int, height: int) -> None: ...


class QVideoEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def setVideoSettings(self, settings: PySide2.QtMultimedia.QVideoEncoderSettings) -> None: ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codec: str) -> str: ...
    def videoSettings(self) -> PySide2.QtMultimedia.QVideoEncoderSettings: ...


class QVideoFilterRunnable(Shiboken.Object):
    LastInChain              : QVideoFilterRunnable.RunFlag = ... # 0x1

    class RunFlag(Shiboken.Enum):
        LastInChain              : QVideoFilterRunnable.RunFlag = ... # 0x1

    class RunFlags(object): ...

    def __init__(self) -> None: ...

    def run(self, input: PySide2.QtMultimedia.QVideoFrame, surfaceFormat: PySide2.QtMultimedia.QVideoSurfaceFormat, flags: PySide2.QtMultimedia.QVideoFilterRunnable.RunFlags) -> PySide2.QtMultimedia.QVideoFrame: ...


class QVideoFrame(Shiboken.Object):
    ProgressiveFrame         : QVideoFrame.FieldType = ... # 0x0
    TopField                 : QVideoFrame.FieldType = ... # 0x1
    BottomField              : QVideoFrame.FieldType = ... # 0x2
    InterlacedFrame          : QVideoFrame.FieldType = ... # 0x3
    Format_Invalid           : QVideoFrame.PixelFormat = ... # 0x0
    Format_ARGB32            : QVideoFrame.PixelFormat = ... # 0x1
    Format_ARGB32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x2
    Format_RGB32             : QVideoFrame.PixelFormat = ... # 0x3
    Format_RGB24             : QVideoFrame.PixelFormat = ... # 0x4
    Format_RGB565            : QVideoFrame.PixelFormat = ... # 0x5
    Format_RGB555            : QVideoFrame.PixelFormat = ... # 0x6
    Format_ARGB8565_Premultiplied: QVideoFrame.PixelFormat = ... # 0x7
    Format_BGRA32            : QVideoFrame.PixelFormat = ... # 0x8
    Format_BGRA32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x9
    Format_BGR32             : QVideoFrame.PixelFormat = ... # 0xa
    Format_BGR24             : QVideoFrame.PixelFormat = ... # 0xb
    Format_BGR565            : QVideoFrame.PixelFormat = ... # 0xc
    Format_BGR555            : QVideoFrame.PixelFormat = ... # 0xd
    Format_BGRA5658_Premultiplied: QVideoFrame.PixelFormat = ... # 0xe
    Format_AYUV444           : QVideoFrame.PixelFormat = ... # 0xf
    Format_AYUV444_Premultiplied: QVideoFrame.PixelFormat = ... # 0x10
    Format_YUV444            : QVideoFrame.PixelFormat = ... # 0x11
    Format_YUV420P           : QVideoFrame.PixelFormat = ... # 0x12
    Format_YV12              : QVideoFrame.PixelFormat = ... # 0x13
    Format_UYVY              : QVideoFrame.PixelFormat = ... # 0x14
    Format_YUYV              : QVideoFrame.PixelFormat = ... # 0x15
    Format_NV12              : QVideoFrame.PixelFormat = ... # 0x16
    Format_NV21              : QVideoFrame.PixelFormat = ... # 0x17
    Format_IMC1              : QVideoFrame.PixelFormat = ... # 0x18
    Format_IMC2              : QVideoFrame.PixelFormat = ... # 0x19
    Format_IMC3              : QVideoFrame.PixelFormat = ... # 0x1a
    Format_IMC4              : QVideoFrame.PixelFormat = ... # 0x1b
    Format_Y8                : QVideoFrame.PixelFormat = ... # 0x1c
    Format_Y16               : QVideoFrame.PixelFormat = ... # 0x1d
    Format_Jpeg              : QVideoFrame.PixelFormat = ... # 0x1e
    Format_CameraRaw         : QVideoFrame.PixelFormat = ... # 0x1f
    Format_AdobeDng          : QVideoFrame.PixelFormat = ... # 0x20
    Format_ABGR32            : QVideoFrame.PixelFormat = ... # 0x21
    Format_YUV422P           : QVideoFrame.PixelFormat = ... # 0x22
    NPixelFormats            : QVideoFrame.PixelFormat = ... # 0x23
    Format_User              : QVideoFrame.PixelFormat = ... # 0x3e8

    class FieldType(Shiboken.Enum):
        ProgressiveFrame         : QVideoFrame.FieldType = ... # 0x0
        TopField                 : QVideoFrame.FieldType = ... # 0x1
        BottomField              : QVideoFrame.FieldType = ... # 0x2
        InterlacedFrame          : QVideoFrame.FieldType = ... # 0x3

    class PixelFormat(Shiboken.Enum):
        Format_Invalid           : QVideoFrame.PixelFormat = ... # 0x0
        Format_ARGB32            : QVideoFrame.PixelFormat = ... # 0x1
        Format_ARGB32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x2
        Format_RGB32             : QVideoFrame.PixelFormat = ... # 0x3
        Format_RGB24             : QVideoFrame.PixelFormat = ... # 0x4
        Format_RGB565            : QVideoFrame.PixelFormat = ... # 0x5
        Format_RGB555            : QVideoFrame.PixelFormat = ... # 0x6
        Format_ARGB8565_Premultiplied: QVideoFrame.PixelFormat = ... # 0x7
        Format_BGRA32            : QVideoFrame.PixelFormat = ... # 0x8
        Format_BGRA32_Premultiplied: QVideoFrame.PixelFormat = ... # 0x9
        Format_BGR32             : QVideoFrame.PixelFormat = ... # 0xa
        Format_BGR24             : QVideoFrame.PixelFormat = ... # 0xb
        Format_BGR565            : QVideoFrame.PixelFormat = ... # 0xc
        Format_BGR555            : QVideoFrame.PixelFormat = ... # 0xd
        Format_BGRA5658_Premultiplied: QVideoFrame.PixelFormat = ... # 0xe
        Format_AYUV444           : QVideoFrame.PixelFormat = ... # 0xf
        Format_AYUV444_Premultiplied: QVideoFrame.PixelFormat = ... # 0x10
        Format_YUV444            : QVideoFrame.PixelFormat = ... # 0x11
        Format_YUV420P           : QVideoFrame.PixelFormat = ... # 0x12
        Format_YV12              : QVideoFrame.PixelFormat = ... # 0x13
        Format_UYVY              : QVideoFrame.PixelFormat = ... # 0x14
        Format_YUYV              : QVideoFrame.PixelFormat = ... # 0x15
        Format_NV12              : QVideoFrame.PixelFormat = ... # 0x16
        Format_NV21              : QVideoFrame.PixelFormat = ... # 0x17
        Format_IMC1              : QVideoFrame.PixelFormat = ... # 0x18
        Format_IMC2              : QVideoFrame.PixelFormat = ... # 0x19
        Format_IMC3              : QVideoFrame.PixelFormat = ... # 0x1a
        Format_IMC4              : QVideoFrame.PixelFormat = ... # 0x1b
        Format_Y8                : QVideoFrame.PixelFormat = ... # 0x1c
        Format_Y16               : QVideoFrame.PixelFormat = ... # 0x1d
        Format_Jpeg              : QVideoFrame.PixelFormat = ... # 0x1e
        Format_CameraRaw         : QVideoFrame.PixelFormat = ... # 0x1f
        Format_AdobeDng          : QVideoFrame.PixelFormat = ... # 0x20
        Format_ABGR32            : QVideoFrame.PixelFormat = ... # 0x21
        Format_YUV422P           : QVideoFrame.PixelFormat = ... # 0x22
        NPixelFormats            : QVideoFrame.PixelFormat = ... # 0x23
        Format_User              : QVideoFrame.PixelFormat = ... # 0x3e8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, buffer: PySide2.QtMultimedia.QAbstractVideoBuffer, size: PySide2.QtCore.QSize, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, bytes: int, size: PySide2.QtCore.QSize, bytesPerLine: int, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> None: ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoFrame) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def availableMetaData(self) -> typing.Dict[str, typing.Any]: ...
    def bits(self) -> bytes: ...
    def buffer(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer: ...
    @typing.overload
    def bytesPerLine(self) -> int: ...
    @typing.overload
    def bytesPerLine(self, plane: int) -> int: ...
    def endTime(self) -> int: ...
    def fieldType(self) -> PySide2.QtMultimedia.QVideoFrame.FieldType: ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def height(self) -> int: ...
    def image(self) -> PySide2.QtGui.QImage: ...
    @staticmethod
    def imageFormatFromPixelFormat(format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> PySide2.QtGui.QImage.Format: ...
    def isMapped(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def map(self, mode: PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode) -> bool: ...
    def mapMode(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode: ...
    def mappedBytes(self) -> int: ...
    def metaData(self, key: str) -> typing.Any: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    @staticmethod
    def pixelFormatFromImageFormat(format: PySide2.QtGui.QImage.Format) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def planeCount(self) -> int: ...
    def setEndTime(self, time: int) -> None: ...
    def setFieldType(self, arg__1: PySide2.QtMultimedia.QVideoFrame.FieldType) -> None: ...
    def setMetaData(self, key: str, value: typing.Any) -> None: ...
    def setStartTime(self, time: int) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def startTime(self) -> int: ...
    def unmap(self) -> None: ...
    def width(self) -> int: ...


class QVideoProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaRecorder) -> bool: ...


class QVideoRendererControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def setSurface(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface) -> None: ...
    def surface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoSurfaceFormat(Shiboken.Object):
    TopToBottom              : QVideoSurfaceFormat.Direction = ... # 0x0
    BottomToTop              : QVideoSurfaceFormat.Direction = ... # 0x1
    YCbCr_Undefined          : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x0
    YCbCr_BT601              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x1
    YCbCr_BT709              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x2
    YCbCr_xvYCC601           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x3
    YCbCr_xvYCC709           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x4
    YCbCr_JPEG               : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x5
    YCbCr_CustomMatrix       : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x6

    class Direction(Shiboken.Enum):
        TopToBottom              : QVideoSurfaceFormat.Direction = ... # 0x0
        BottomToTop              : QVideoSurfaceFormat.Direction = ... # 0x1

    class YCbCrColorSpace(Shiboken.Enum):
        YCbCr_Undefined          : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x0
        YCbCr_BT601              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x1
        YCbCr_BT709              : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x2
        YCbCr_xvYCC601           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x3
        YCbCr_xvYCC709           : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x4
        YCbCr_JPEG               : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x5
        YCbCr_CustomMatrix       : QVideoSurfaceFormat.YCbCrColorSpace = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, pixelFormat: PySide2.QtMultimedia.QVideoFrame.PixelFormat, handleType: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def frameHeight(self) -> int: ...
    def frameRate(self) -> float: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def frameWidth(self) -> int: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def isMirrored(self) -> bool: ...
    def isValid(self) -> bool: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def property(self, name: bytes) -> typing.Any: ...
    def propertyNames(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def scanLineDirection(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat.Direction: ...
    def setFrameRate(self, rate: float) -> None: ...
    @typing.overload
    def setFrameSize(self, size: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setFrameSize(self, width: int, height: int) -> None: ...
    def setMirrored(self, mirrored: bool) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setPixelAspectRatio(self, width: int, height: int) -> None: ...
    def setProperty(self, name: bytes, value: typing.Any) -> None: ...
    def setScanLineDirection(self, direction: PySide2.QtMultimedia.QVideoSurfaceFormat.Direction) -> None: ...
    def setViewport(self, viewport: PySide2.QtCore.QRect) -> None: ...
    def setYCbCrColorSpace(self, colorSpace: PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def yCbCrColorSpace(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace: ...


class QVideoWindowControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def displayRect(self) -> PySide2.QtCore.QRect: ...
    def hue(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def nativeSize(self) -> PySide2.QtCore.QSize: ...
    def repaint(self) -> None: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness: int) -> None: ...
    def setContrast(self, contrast: int) -> None: ...
    def setDisplayRect(self, rect: PySide2.QtCore.QRect) -> None: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def setHue(self, hue: int) -> None: ...
    def setSaturation(self, saturation: int) -> None: ...
    def setWinId(self, id: int) -> None: ...
    def winId(self) -> int: ...

# eof
