#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtScxml, except for defaults which are replaced by "...".
"""

# Module PySide2.QtScxml
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtScxml


class QScxmlCompiler(Shiboken.Object):

    class Loader(Shiboken.Object):

        def __init__(self) -> None: ...

        def load(self, name: str, baseDir: str) -> typing.Tuple[PySide2.QtCore.QByteArray, typing.List[str]]: ...

    def __init__(self, xmlReader: PySide2.QtCore.QXmlStreamReader) -> None: ...

    def compile(self) -> PySide2.QtScxml.QScxmlStateMachine: ...
    def errors(self) -> typing.List[PySide2.QtScxml.QScxmlError]: ...
    def fileName(self) -> str: ...
    def loader(self) -> PySide2.QtScxml.QScxmlCompiler.Loader: ...
    def setFileName(self, fileName: str) -> None: ...
    def setLoader(self, newLoader: PySide2.QtScxml.QScxmlCompiler.Loader) -> None: ...


class QScxmlCppDataModel(PySide2.QtScxml.QScxmlDataModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def evaluateAssignment(self, id: int) -> bool: ...
    def evaluateForeach(self, id: int, body: PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody) -> bool: ...
    def evaluateInitialization(self, id: int) -> bool: ...
    def hasScxmlProperty(self, name: str) -> bool: ...
    def inState(self, stateName: str) -> bool: ...
    def scxmlEvent(self) -> PySide2.QtScxml.QScxmlEvent: ...
    def scxmlProperty(self, name: str) -> typing.Any: ...
    def setScxmlEvent(self, scxmlEvent: PySide2.QtScxml.QScxmlEvent) -> None: ...
    def setScxmlProperty(self, name: str, value: typing.Any, context: str) -> bool: ...
    def setup(self, initialDataValues: typing.Dict[str, typing.Any]) -> bool: ...


class QScxmlDataModel(PySide2.QtCore.QObject):

    class ForeachLoopBody(Shiboken.Object):

        def __init__(self) -> None: ...

        def run(self) -> bool: ...

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def evaluateAssignment(self, id: int) -> bool: ...
    def evaluateForeach(self, id: int, body: PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody) -> bool: ...
    def evaluateInitialization(self, id: int) -> bool: ...
    def evaluateToBool(self, id: int) -> typing.Tuple[bool, bool]: ...
    def evaluateToString(self, id: int) -> typing.Tuple[str, bool]: ...
    def evaluateToVariant(self, id: int) -> typing.Tuple[typing.Any, bool]: ...
    def evaluateToVoid(self, id: int) -> bool: ...
    def hasScxmlProperty(self, name: str) -> bool: ...
    def scxmlProperty(self, name: str) -> typing.Any: ...
    def setScxmlEvent(self, event: PySide2.QtScxml.QScxmlEvent) -> None: ...
    def setScxmlProperty(self, name: str, value: typing.Any, context: str) -> bool: ...
    def setStateMachine(self, stateMachine: PySide2.QtScxml.QScxmlStateMachine) -> None: ...
    def setup(self, initialDataValues: typing.Dict[str, typing.Any]) -> bool: ...
    def stateMachine(self) -> PySide2.QtScxml.QScxmlStateMachine: ...


class QScxmlDynamicScxmlServiceFactory(PySide2.QtScxml.QScxmlInvokableServiceFactory):

    def __init__(self, invokeInfo: PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo, names: typing.List[int], parameters: typing.List[PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def invoke(self, parentStateMachine: PySide2.QtScxml.QScxmlStateMachine) -> PySide2.QtScxml.QScxmlInvokableService: ...


class QScxmlEcmaScriptDataModel(PySide2.QtScxml.QScxmlDataModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def evaluateAssignment(self, id: int) -> bool: ...
    def evaluateForeach(self, id: int, body: PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody) -> bool: ...
    def evaluateInitialization(self, id: int) -> bool: ...
    def evaluateToBool(self, id: int) -> typing.Tuple[bool, bool]: ...
    def evaluateToString(self, id: int) -> typing.Tuple[str, bool]: ...
    def evaluateToVariant(self, id: int) -> typing.Tuple[typing.Any, bool]: ...
    def evaluateToVoid(self, id: int) -> bool: ...
    def hasScxmlProperty(self, name: str) -> bool: ...
    def scxmlProperty(self, name: str) -> typing.Any: ...
    def setScxmlEvent(self, event: PySide2.QtScxml.QScxmlEvent) -> None: ...
    def setScxmlProperty(self, name: str, value: typing.Any, context: str) -> bool: ...
    def setup(self, initialDataValues: typing.Dict[str, typing.Any]) -> bool: ...


class QScxmlError(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtScxml.QScxmlError) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, line: int, column: int, description: str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def column(self) -> int: ...
    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def isValid(self) -> bool: ...
    def line(self) -> int: ...
    def toString(self) -> str: ...


class QScxmlEvent(Shiboken.Object):
    PlatformEvent            : QScxmlEvent.EventType = ... # 0x0
    InternalEvent            : QScxmlEvent.EventType = ... # 0x1
    ExternalEvent            : QScxmlEvent.EventType = ... # 0x2

    class EventType(Shiboken.Enum):
        PlatformEvent            : QScxmlEvent.EventType = ... # 0x0
        InternalEvent            : QScxmlEvent.EventType = ... # 0x1
        ExternalEvent            : QScxmlEvent.EventType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: PySide2.QtScxml.QScxmlEvent) -> None: ...

    def clear(self) -> None: ...
    def data(self) -> typing.Any: ...
    def delay(self) -> int: ...
    def errorMessage(self) -> str: ...
    def eventType(self) -> PySide2.QtScxml.QScxmlEvent.EventType: ...
    def invokeId(self) -> str: ...
    def isErrorEvent(self) -> bool: ...
    def name(self) -> str: ...
    def origin(self) -> str: ...
    def originType(self) -> str: ...
    def scxmlType(self) -> str: ...
    def sendId(self) -> str: ...
    def setData(self, data: typing.Any) -> None: ...
    def setDelay(self, delayInMiliSecs: int) -> None: ...
    def setErrorMessage(self, message: str) -> None: ...
    def setEventType(self, type: PySide2.QtScxml.QScxmlEvent.EventType) -> None: ...
    def setInvokeId(self, invokeId: str) -> None: ...
    def setName(self, name: str) -> None: ...
    def setOrigin(self, origin: str) -> None: ...
    def setOriginType(self, originType: str) -> None: ...
    def setSendId(self, sendId: str) -> None: ...


class QScxmlExecutableContent(Shiboken.Object):

    class AssignmentInfo(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, AssignmentInfo: PySide2.QtScxml.QScxmlExecutableContent.AssignmentInfo) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class EvaluatorInfo(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, EvaluatorInfo: PySide2.QtScxml.QScxmlExecutableContent.EvaluatorInfo) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class ForeachInfo(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ForeachInfo: PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class InvokeInfo(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, InvokeInfo: PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class ParameterInfo(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, ParameterInfo: PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


class QScxmlInvokableService(PySide2.QtCore.QObject):

    def __init__(self, parentStateMachine: PySide2.QtScxml.QScxmlStateMachine, parent: PySide2.QtScxml.QScxmlInvokableServiceFactory) -> None: ...

    def id(self) -> str: ...
    def name(self) -> str: ...
    def parentStateMachine(self) -> PySide2.QtScxml.QScxmlStateMachine: ...
    def postEvent(self, event: PySide2.QtScxml.QScxmlEvent) -> None: ...
    def start(self) -> bool: ...


class QScxmlInvokableServiceFactory(PySide2.QtCore.QObject):

    def __init__(self, invokeInfo: PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo, names: typing.List[int], parameters: typing.List[PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def invoke(self, parentStateMachine: PySide2.QtScxml.QScxmlStateMachine) -> PySide2.QtScxml.QScxmlInvokableService: ...
    def invokeInfo(self) -> PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo: ...
    def names(self) -> typing.List[int]: ...
    def parameters(self) -> typing.List[PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo]: ...


class QScxmlNullDataModel(PySide2.QtScxml.QScxmlDataModel):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def evaluateAssignment(self, id: int) -> bool: ...
    def evaluateForeach(self, id: int, body: PySide2.QtScxml.QScxmlDataModel.ForeachLoopBody) -> bool: ...
    def evaluateInitialization(self, id: int) -> bool: ...
    def evaluateToBool(self, id: int) -> typing.Tuple[bool, bool]: ...
    def evaluateToString(self, id: int) -> typing.Tuple[str, bool]: ...
    def evaluateToVariant(self, id: int) -> typing.Tuple[typing.Any, bool]: ...
    def evaluateToVoid(self, id: int) -> bool: ...
    def hasScxmlProperty(self, name: str) -> bool: ...
    def scxmlProperty(self, name: str) -> typing.Any: ...
    def setScxmlEvent(self, event: PySide2.QtScxml.QScxmlEvent) -> None: ...
    def setScxmlProperty(self, name: str, value: typing.Any, context: str) -> bool: ...
    def setup(self, initialDataValues: typing.Dict[str, typing.Any]) -> bool: ...


class QScxmlStateMachine(PySide2.QtCore.QObject):

    def __init__(self, metaObject: PySide2.QtCore.QMetaObject, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def activeStateNames(self, compress: bool = ...) -> typing.List[str]: ...
    def cancelDelayedEvent(self, sendId: str) -> None: ...
    def connectToEvent(self, scxmlEventSpec: str, receiver: PySide2.QtCore.QObject, method: bytes, type: PySide2.QtCore.Qt.ConnectionType = ...) -> PySide2.QtCore.QMetaObject.Connection: ...
    def connectToState(self, scxmlStateName: str, receiver: PySide2.QtCore.QObject, method: bytes, type: PySide2.QtCore.Qt.ConnectionType = ...) -> PySide2.QtCore.QMetaObject.Connection: ...
    def dataModel(self) -> PySide2.QtScxml.QScxmlDataModel: ...
    @staticmethod
    def fromData(data: PySide2.QtCore.QIODevice, fileName: str = ...) -> PySide2.QtScxml.QScxmlStateMachine: ...
    @staticmethod
    def fromFile(fileName: str) -> PySide2.QtScxml.QScxmlStateMachine: ...
    def init(self) -> bool: ...
    def initialValues(self) -> typing.Dict[str, typing.Any]: ...
    def invokedServices(self) -> typing.List[PySide2.QtScxml.QScxmlInvokableService]: ...
    @typing.overload
    def isActive(self, scxmlStateName: str) -> bool: ...
    @typing.overload
    def isActive(self, stateIndex: int) -> bool: ...
    def isDispatchableTarget(self, target: str) -> bool: ...
    def isInitialized(self) -> bool: ...
    def isInvoked(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def loader(self) -> PySide2.QtScxml.QScxmlCompiler.Loader: ...
    def name(self) -> str: ...
    def parseErrors(self) -> typing.List[PySide2.QtScxml.QScxmlError]: ...
    def sessionId(self) -> str: ...
    def setDataModel(self, model: PySide2.QtScxml.QScxmlDataModel) -> None: ...
    def setInitialValues(self, initialValues: typing.Dict[str, typing.Any]) -> None: ...
    def setLoader(self, loader: PySide2.QtScxml.QScxmlCompiler.Loader) -> None: ...
    def setRunning(self, running: bool) -> None: ...
    def setTableData(self, tableData: PySide2.QtScxml.QScxmlTableData) -> None: ...
    def start(self) -> None: ...
    def stateNames(self, compress: bool = ...) -> typing.List[str]: ...
    def stop(self) -> None: ...
    @typing.overload
    def submitEvent(self, event: PySide2.QtScxml.QScxmlEvent) -> None: ...
    @typing.overload
    def submitEvent(self, eventName: str) -> None: ...
    @typing.overload
    def submitEvent(self, eventName: str, data: typing.Any) -> None: ...
    def tableData(self) -> PySide2.QtScxml.QScxmlTableData: ...


class QScxmlStaticScxmlServiceFactory(PySide2.QtScxml.QScxmlInvokableServiceFactory):

    def __init__(self, metaObject: PySide2.QtCore.QMetaObject, invokeInfo: PySide2.QtScxml.QScxmlExecutableContent.InvokeInfo, nameList: typing.List[int], parameters: typing.List[PySide2.QtScxml.QScxmlExecutableContent.ParameterInfo], parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def invoke(self, parentStateMachine: PySide2.QtScxml.QScxmlStateMachine) -> PySide2.QtScxml.QScxmlInvokableService: ...


class QScxmlTableData(Shiboken.Object):

    def __init__(self) -> None: ...

    def assignmentInfo(self, assignmentId: int) -> PySide2.QtScxml.QScxmlExecutableContent.AssignmentInfo: ...
    def dataNames(self) -> typing.Tuple[typing.List[int], int]: ...
    def evaluatorInfo(self, evaluatorId: int) -> PySide2.QtScxml.QScxmlExecutableContent.EvaluatorInfo: ...
    def foreachInfo(self, foreachId: int) -> PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo: ...
    def initialSetup(self) -> int: ...
    def instructions(self) -> typing.List[int]: ...
    def name(self) -> str: ...
    def serviceFactory(self, id: int) -> PySide2.QtScxml.QScxmlInvokableServiceFactory: ...
    def stateMachineTable(self) -> typing.List[int]: ...
    def string(self, id: int) -> str: ...

# eof
