#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWebEngineCore, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWebEngineCore
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtWebEngineCore


class QWebEngineCookieStore(PySide2.QtCore.QObject):
    def deleteAllCookies(self) -> None: ...
    def deleteCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie, origin: PySide2.QtCore.QUrl = ...) -> None: ...
    def deleteSessionCookies(self) -> None: ...
    def loadAllCookies(self) -> None: ...
    def setCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie, origin: PySide2.QtCore.QUrl = ...) -> None: ...


class QWebEngineHttpRequest(Shiboken.Object):
    Get                      : QWebEngineHttpRequest.Method = ... # 0x0
    Post                     : QWebEngineHttpRequest.Method = ... # 0x1

    class Method(Shiboken.Enum):
        Get                      : QWebEngineHttpRequest.Method = ... # 0x0
        Post                     : QWebEngineHttpRequest.Method = ... # 0x1

    @typing.overload
    def __init__(self, other: PySide2.QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl = ..., method: PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method = ...) -> None: ...

    def hasHeader(self, headerName: PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, headerName: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def headers(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def method(self) -> PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method: ...
    def postData(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def postRequest(url: PySide2.QtCore.QUrl, postData: typing.Dict[str, str]) -> PySide2.QtWebEngineCore.QWebEngineHttpRequest: ...
    def setHeader(self, headerName: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray) -> None: ...
    def setMethod(self, method: PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method) -> None: ...
    def setPostData(self, postData: PySide2.QtCore.QByteArray) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def swap(self, other: PySide2.QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    def unsetHeader(self, headerName: PySide2.QtCore.QByteArray) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QWebEngineUrlRequestInfo(Shiboken.Object):
    NavigationTypeLink       : QWebEngineUrlRequestInfo.NavigationType = ... # 0x0
    NavigationTypeTyped      : QWebEngineUrlRequestInfo.NavigationType = ... # 0x1
    NavigationTypeFormSubmitted: QWebEngineUrlRequestInfo.NavigationType = ... # 0x2
    NavigationTypeBackForward: QWebEngineUrlRequestInfo.NavigationType = ... # 0x3
    NavigationTypeReload     : QWebEngineUrlRequestInfo.NavigationType = ... # 0x4
    NavigationTypeOther      : QWebEngineUrlRequestInfo.NavigationType = ... # 0x5
    NavigationTypeRedirect   : QWebEngineUrlRequestInfo.NavigationType = ... # 0x6
    ResourceTypeMainFrame    : QWebEngineUrlRequestInfo.ResourceType = ... # 0x0
    ResourceTypeSubFrame     : QWebEngineUrlRequestInfo.ResourceType = ... # 0x1
    ResourceTypeStylesheet   : QWebEngineUrlRequestInfo.ResourceType = ... # 0x2
    ResourceTypeScript       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x3
    ResourceTypeImage        : QWebEngineUrlRequestInfo.ResourceType = ... # 0x4
    ResourceTypeFontResource : QWebEngineUrlRequestInfo.ResourceType = ... # 0x5
    ResourceTypeSubResource  : QWebEngineUrlRequestInfo.ResourceType = ... # 0x6
    ResourceTypeObject       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x7
    ResourceTypeMedia        : QWebEngineUrlRequestInfo.ResourceType = ... # 0x8
    ResourceTypeWorker       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x9
    ResourceTypeSharedWorker : QWebEngineUrlRequestInfo.ResourceType = ... # 0xa
    ResourceTypePrefetch     : QWebEngineUrlRequestInfo.ResourceType = ... # 0xb
    ResourceTypeFavicon      : QWebEngineUrlRequestInfo.ResourceType = ... # 0xc
    ResourceTypeXhr          : QWebEngineUrlRequestInfo.ResourceType = ... # 0xd
    ResourceTypePing         : QWebEngineUrlRequestInfo.ResourceType = ... # 0xe
    ResourceTypeServiceWorker: QWebEngineUrlRequestInfo.ResourceType = ... # 0xf
    ResourceTypeCspReport    : QWebEngineUrlRequestInfo.ResourceType = ... # 0x10
    ResourceTypePluginResource: QWebEngineUrlRequestInfo.ResourceType = ... # 0x11
    ResourceTypeNavigationPreloadMainFrame: QWebEngineUrlRequestInfo.ResourceType = ... # 0x13
    ResourceTypeLast         : QWebEngineUrlRequestInfo.ResourceType = ... # 0x14
    ResourceTypeNavigationPreloadSubFrame: QWebEngineUrlRequestInfo.ResourceType = ... # 0x14
    ResourceTypeUnknown      : QWebEngineUrlRequestInfo.ResourceType = ... # 0xff

    class NavigationType(Shiboken.Enum):
        NavigationTypeLink       : QWebEngineUrlRequestInfo.NavigationType = ... # 0x0
        NavigationTypeTyped      : QWebEngineUrlRequestInfo.NavigationType = ... # 0x1
        NavigationTypeFormSubmitted: QWebEngineUrlRequestInfo.NavigationType = ... # 0x2
        NavigationTypeBackForward: QWebEngineUrlRequestInfo.NavigationType = ... # 0x3
        NavigationTypeReload     : QWebEngineUrlRequestInfo.NavigationType = ... # 0x4
        NavigationTypeOther      : QWebEngineUrlRequestInfo.NavigationType = ... # 0x5
        NavigationTypeRedirect   : QWebEngineUrlRequestInfo.NavigationType = ... # 0x6

    class ResourceType(Shiboken.Enum):
        ResourceTypeMainFrame    : QWebEngineUrlRequestInfo.ResourceType = ... # 0x0
        ResourceTypeSubFrame     : QWebEngineUrlRequestInfo.ResourceType = ... # 0x1
        ResourceTypeStylesheet   : QWebEngineUrlRequestInfo.ResourceType = ... # 0x2
        ResourceTypeScript       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x3
        ResourceTypeImage        : QWebEngineUrlRequestInfo.ResourceType = ... # 0x4
        ResourceTypeFontResource : QWebEngineUrlRequestInfo.ResourceType = ... # 0x5
        ResourceTypeSubResource  : QWebEngineUrlRequestInfo.ResourceType = ... # 0x6
        ResourceTypeObject       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x7
        ResourceTypeMedia        : QWebEngineUrlRequestInfo.ResourceType = ... # 0x8
        ResourceTypeWorker       : QWebEngineUrlRequestInfo.ResourceType = ... # 0x9
        ResourceTypeSharedWorker : QWebEngineUrlRequestInfo.ResourceType = ... # 0xa
        ResourceTypePrefetch     : QWebEngineUrlRequestInfo.ResourceType = ... # 0xb
        ResourceTypeFavicon      : QWebEngineUrlRequestInfo.ResourceType = ... # 0xc
        ResourceTypeXhr          : QWebEngineUrlRequestInfo.ResourceType = ... # 0xd
        ResourceTypePing         : QWebEngineUrlRequestInfo.ResourceType = ... # 0xe
        ResourceTypeServiceWorker: QWebEngineUrlRequestInfo.ResourceType = ... # 0xf
        ResourceTypeCspReport    : QWebEngineUrlRequestInfo.ResourceType = ... # 0x10
        ResourceTypePluginResource: QWebEngineUrlRequestInfo.ResourceType = ... # 0x11
        ResourceTypeNavigationPreloadMainFrame: QWebEngineUrlRequestInfo.ResourceType = ... # 0x13
        ResourceTypeLast         : QWebEngineUrlRequestInfo.ResourceType = ... # 0x14
        ResourceTypeNavigationPreloadSubFrame: QWebEngineUrlRequestInfo.ResourceType = ... # 0x14
        ResourceTypeUnknown      : QWebEngineUrlRequestInfo.ResourceType = ... # 0xff
    def block(self, shouldBlock: bool) -> None: ...
    def changed(self) -> bool: ...
    def firstPartyUrl(self) -> PySide2.QtCore.QUrl: ...
    def initiator(self) -> PySide2.QtCore.QUrl: ...
    def navigationType(self) -> PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.NavigationType: ...
    def redirect(self, url: PySide2.QtCore.QUrl) -> None: ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...
    def resourceType(self) -> PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.ResourceType: ...
    def setHttpHeader(self, name: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray) -> None: ...


class QWebEngineUrlRequestInterceptor(PySide2.QtCore.QObject):

    def __init__(self, p: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def interceptRequest(self, info: PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo) -> None: ...


class QWebEngineUrlRequestJob(PySide2.QtCore.QObject):
    NoError                  : QWebEngineUrlRequestJob.Error = ... # 0x0
    UrlNotFound              : QWebEngineUrlRequestJob.Error = ... # 0x1
    UrlInvalid               : QWebEngineUrlRequestJob.Error = ... # 0x2
    RequestAborted           : QWebEngineUrlRequestJob.Error = ... # 0x3
    RequestDenied            : QWebEngineUrlRequestJob.Error = ... # 0x4
    RequestFailed            : QWebEngineUrlRequestJob.Error = ... # 0x5

    class Error(Shiboken.Enum):
        NoError                  : QWebEngineUrlRequestJob.Error = ... # 0x0
        UrlNotFound              : QWebEngineUrlRequestJob.Error = ... # 0x1
        UrlInvalid               : QWebEngineUrlRequestJob.Error = ... # 0x2
        RequestAborted           : QWebEngineUrlRequestJob.Error = ... # 0x3
        RequestDenied            : QWebEngineUrlRequestJob.Error = ... # 0x4
        RequestFailed            : QWebEngineUrlRequestJob.Error = ... # 0x5
    def fail(self, error: PySide2.QtWebEngineCore.QWebEngineUrlRequestJob.Error) -> None: ...
    def initiator(self) -> PySide2.QtCore.QUrl: ...
    def redirect(self, url: PySide2.QtCore.QUrl) -> None: ...
    def reply(self, contentType: PySide2.QtCore.QByteArray, device: PySide2.QtCore.QIODevice) -> None: ...
    def requestHeaders(self) -> typing.Dict[PySide2.QtCore.QByteArray, PySide2.QtCore.QByteArray]: ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...


class QWebEngineUrlScheme(Shiboken.Object):
    SecureScheme             : QWebEngineUrlScheme.Flag = ... # 0x1
    LocalScheme              : QWebEngineUrlScheme.Flag = ... # 0x2
    LocalAccessAllowed       : QWebEngineUrlScheme.Flag = ... # 0x4
    NoAccessAllowed          : QWebEngineUrlScheme.Flag = ... # 0x8
    ServiceWorkersAllowed    : QWebEngineUrlScheme.Flag = ... # 0x10
    ViewSourceAllowed        : QWebEngineUrlScheme.Flag = ... # 0x20
    ContentSecurityPolicyIgnored: QWebEngineUrlScheme.Flag = ... # 0x40
    CorsEnabled              : QWebEngineUrlScheme.Flag = ... # 0x80
    PortUnspecified          : QWebEngineUrlScheme.SpecialPort = ... # -0x1

    class Flag(Shiboken.Enum):
        SecureScheme             : QWebEngineUrlScheme.Flag = ... # 0x1
        LocalScheme              : QWebEngineUrlScheme.Flag = ... # 0x2
        LocalAccessAllowed       : QWebEngineUrlScheme.Flag = ... # 0x4
        NoAccessAllowed          : QWebEngineUrlScheme.Flag = ... # 0x8
        ServiceWorkersAllowed    : QWebEngineUrlScheme.Flag = ... # 0x10
        ViewSourceAllowed        : QWebEngineUrlScheme.Flag = ... # 0x20
        ContentSecurityPolicyIgnored: QWebEngineUrlScheme.Flag = ... # 0x40
        CorsEnabled              : QWebEngineUrlScheme.Flag = ... # 0x80

    class Flags(object): ...

    class SpecialPort(Shiboken.Enum):
        PortUnspecified          : QWebEngineUrlScheme.SpecialPort = ... # -0x1

    class Syntax(Shiboken.Enum):
        HostPortAndUserInformation: QWebEngineUrlScheme.Syntax = ... # 0x0
        HostAndPort              : QWebEngineUrlScheme.Syntax = ... # 0x1
        Host                     : QWebEngineUrlScheme.Syntax = ... # 0x2
        Path                     : QWebEngineUrlScheme.Syntax = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, that: PySide2.QtWebEngineCore.QWebEngineUrlScheme) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def defaultPort(self) -> int: ...
    def flags(self) -> PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flags: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def registerScheme(scheme: PySide2.QtWebEngineCore.QWebEngineUrlScheme) -> None: ...
    @staticmethod
    def schemeByName(name: PySide2.QtCore.QByteArray) -> PySide2.QtWebEngineCore.QWebEngineUrlScheme: ...
    def setDefaultPort(self, newValue: int) -> None: ...
    def setFlags(self, newValue: PySide2.QtWebEngineCore.QWebEngineUrlScheme.Flags) -> None: ...
    def setName(self, newValue: PySide2.QtCore.QByteArray) -> None: ...
    def setSyntax(self, newValue: PySide2.QtWebEngineCore.QWebEngineUrlScheme.Syntax) -> None: ...
    def syntax(self) -> PySide2.QtWebEngineCore.QWebEngineUrlScheme.Syntax: ...


class QWebEngineUrlSchemeHandler(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def requestStarted(self, arg__1: PySide2.QtWebEngineCore.QWebEngineUrlRequestJob) -> None: ...

# eof
