from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

VTK_ATTRIBUTE_MODE_DEFAULT:int
VTK_ATTRIBUTE_MODE_USE_CELL_DATA:int
VTK_ATTRIBUTE_MODE_USE_POINT_DATA:int
VTK_BEST_FITTING_PLANE:int
VTK_CELL_DATA:int
VTK_CELL_DATA_FIELD:int
VTK_COLOR_BY_SCALAR:int
VTK_COLOR_BY_SCALE:int
VTK_COLOR_BY_VECTOR:int
VTK_COMPONENT_MODE_USE_ALL:int
VTK_COMPONENT_MODE_USE_ANY:int
VTK_COMPONENT_MODE_USE_SELECTED:int
VTK_DATA_OBJECT_FIELD:int
VTK_DATA_SCALING_OFF:int
VTK_DELAUNAY_XY_PLANE:int
VTK_EXTRACT_ALL_REGIONS:int
VTK_EXTRACT_CELL_SEEDED_REGIONS:int
VTK_EXTRACT_CLOSEST_POINT_REGION:int
VTK_EXTRACT_LARGEST_REGION:int
VTK_EXTRACT_LARGE_REGIONS:int
VTK_EXTRACT_POINT_SEEDED_REGIONS:int
VTK_EXTRACT_SPECIFIED_REGIONS:int
VTK_FOLLOW_CAMERA_DIRECTION:int
VTK_INDEXING_BY_SCALAR:int
VTK_INDEXING_BY_VECTOR:int
VTK_INDEXING_OFF:int
VTK_POINT_DATA:int
VTK_POINT_DATA_FIELD:int
VTK_SCALE_BY_SCALAR:int
VTK_SCALE_BY_VECTOR:int
VTK_SCALE_BY_VECTORCOMPONENTS:int
VTK_SET_TRANSFORM_PLANE:int
VTK_SORT_BY_CELL:int
VTK_SORT_BY_VALUE:int
VTK_SPHERE_TREE_LEVELS:int
VTK_SPHERE_TREE_LINE:int
VTK_SPHERE_TREE_PLANE:int
VTK_SPHERE_TREE_POINT:int
VTK_TCOORDS_FROM_LENGTH:int
VTK_TCOORDS_FROM_NORMALIZED_LENGTH:int
VTK_TCOORDS_FROM_SCALARS:int
VTK_TCOORDS_OFF:int
VTK_USE_NORMAL:int
VTK_USE_VECTOR:int
VTK_VARY_RADIUS_BY_ABSOLUTE_SCALAR:int
VTK_VARY_RADIUS_BY_SCALAR:int
VTK_VARY_RADIUS_BY_VECTOR:int
VTK_VARY_RADIUS_BY_VECTOR_NORM:int
VTK_VARY_RADIUS_OFF:int
VTK_VECTOR_ROTATION_OFF:int

class vtk3DLinearGridCrinkleExtractor(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def CopyCellDataOff(self) -> None: ...
    def CopyCellDataOn(self) -> None: ...
    def CopyPointDataOff(self) -> None: ...
    def CopyPointDataOn(self) -> None: ...
    def GetCopyCellData(self) -> bool: ...
    def GetCopyPointData(self) -> bool: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetSequentialProcessing(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtk3DLinearGridCrinkleExtractor': ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DLinearGridCrinkleExtractor': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetCopyCellData(self, _arg:bool) -> None: ...
    def SetCopyPointData(self, _arg:bool) -> None: ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetSequentialProcessing(self, _arg:bool) -> None: ...

class vtk3DLinearGridPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetComputeNormals(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetLargeIds(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def GetSequentialProcessing(self) -> bool: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtk3DLinearGridPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DLinearGridPlaneCutter': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...
    def SetSequentialProcessing(self, _arg:bool) -> None: ...

class vtkAppendArcLength(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendArcLength': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendArcLength': ...

class vtkAppendCompositeDataLeaves(vtkmodules.vtkCommonExecutionModel.vtkCompositeDataSetAlgorithm):
    def AppendFieldDataOff(self) -> None: ...
    def AppendFieldDataOn(self) -> None: ...
    def GetAppendFieldData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendCompositeDataLeaves': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendCompositeDataLeaves': ...
    def SetAppendFieldData(self, _arg:int) -> None: ...

class vtkAppendDataSets(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDataSetType(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAppendDataSets': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendDataSets': ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputDataSetType(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkAppendFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    @overload
    def GetInput(self, idx:int) -> 'vtkDataSet': ...
    @overload
    def GetInput(self) -> 'vtkDataSet': ...
    def GetInputList(self) -> 'vtkDataSetCollection': ...
    def GetMergePoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAppendFilter': ...
    def RemoveInputData(self, in_:'vtkDataSet') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendFilter': ...
    def SetMergePoints(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkAppendPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AddInputData(self, __a:'vtkPolyData') -> None: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkPolyData': ...
    @overload
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetParallelStreaming(self) -> int: ...
    def GetUserManagedInputs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendPolyData': ...
    def ParallelStreamingOff(self) -> None: ...
    def ParallelStreamingOn(self) -> None: ...
    def RemoveInputData(self, __a:'vtkPolyData') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendPolyData': ...
    def SetInputConnectionByNumber(self, num:int, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputDataByNumber(self, num:int, ds:'vtkPolyData') -> None: ...
    def SetNumberOfInputs(self, num:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetParallelStreaming(self, _arg:int) -> None: ...
    def SetUserManagedInputs(self, _arg:int) -> None: ...
    def UserManagedInputsOff(self) -> None: ...
    def UserManagedInputsOn(self) -> None: ...

class vtkAppendSelection(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    def AddInputData(self, __a:'vtkSelection') -> None: ...
    def AppendByUnionOff(self) -> None: ...
    def AppendByUnionOn(self) -> None: ...
    def GetAppendByUnion(self) -> int: ...
    def GetExpression(self) -> str: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkSelection': ...
    @overload
    def GetInput(self) -> 'vtkSelection': ...
    def GetInputName(self, index:int) -> str: ...
    def GetInverse(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUserManagedInputs(self) -> int: ...
    def InverseOff(self) -> None: ...
    def InverseOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendSelection': ...
    def RemoveAllInputNames(self) -> None: ...
    def RemoveInputData(self, __a:'vtkSelection') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendSelection': ...
    def SetAppendByUnion(self, _arg:int) -> None: ...
    def SetExpression(self, arg:str) -> None: ...
    def SetInputConnectionByNumber(self, num:int, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputName(self, index:int, name:str) -> None: ...
    def SetInverse(self, _arg:bool) -> None: ...
    def SetNumberOfInputs(self, num:int) -> None: ...
    def SetUserManagedInputs(self, _arg:int) -> None: ...
    def UserManagedInputsOff(self) -> None: ...
    def UserManagedInputsOn(self) -> None: ...

class vtkArrayCalculator(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class FunctionParserTypes(int): ...
    DEFAULT_ATTRIBUTE_TYPE:int
    ExprTkFunctionParser:'FunctionParserTypes'
    FunctionParser:'FunctionParserTypes'
    NumberOfFunctionParserTypes:'FunctionParserTypes'
    def AddCoordinateScalarVariable(self, variableName:str, component:int=0) -> None: ...
    def AddCoordinateVectorVariable(self, variableName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def AddScalarArrayName(self, arrayName:str, component:int=0) -> None: ...
    def AddScalarVariable(self, variableName:str, arrayName:str, component:int=0) -> None: ...
    def AddVectorArrayName(self, arrayName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def AddVectorVariable(self, variableName:str, arrayName:str, component0:int=0, component1:int=1, component2:int=2) -> None: ...
    def CoordinateResultsOff(self) -> None: ...
    def CoordinateResultsOn(self) -> None: ...
    def GetAttributeType(self) -> int: ...
    def GetAttributeTypeAsString(self) -> str: ...
    def GetCoordinateResults(self) -> int: ...
    def GetDataSetOutput(self) -> 'vtkDataSet': ...
    def GetFunction(self) -> str: ...
    def GetFunctionParserType(self) -> 'FunctionParserTypes': ...
    def GetIgnoreMissingArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfScalarArrays(self) -> int: ...
    def GetNumberOfVectorArrays(self) -> int: ...
    def GetReplaceInvalidValues(self) -> int: ...
    def GetReplacementValue(self) -> float: ...
    def GetResultArrayName(self) -> str: ...
    def GetResultArrayType(self) -> int: ...
    def GetResultNormals(self) -> bool: ...
    def GetResultTCoords(self) -> bool: ...
    def GetScalarArrayName(self, i:int) -> str: ...
    def GetScalarArrayNames(self) -> Tuple[str, str]: ...
    def GetScalarVariableName(self, i:int) -> str: ...
    def GetScalarVariableNames(self) -> Tuple[str, str]: ...
    def GetSelectedScalarComponent(self, i:int) -> int: ...
    def GetSelectedScalarComponents(self) -> Tuple[int, int]: ...
    def GetSelectedVectorComponents(self, i:int) -> 'vtkTuple_IiLi3EE': ...
    def GetVectorArrayName(self, i:int) -> str: ...
    def GetVectorArrayNames(self) -> Tuple[str, str]: ...
    def GetVectorVariableName(self, i:int) -> str: ...
    def GetVectorVariableNames(self) -> Tuple[str, str]: ...
    def IgnoreMissingArraysOff(self) -> None: ...
    def IgnoreMissingArraysOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayCalculator': ...
    def RemoveAllVariables(self) -> None: ...
    def RemoveCoordinateScalarVariables(self) -> None: ...
    def RemoveCoordinateVectorVariables(self) -> None: ...
    def RemoveScalarVariables(self) -> None: ...
    def RemoveVectorVariables(self) -> None: ...
    def ReplaceInvalidValuesOff(self) -> None: ...
    def ReplaceInvalidValuesOn(self) -> None: ...
    def ResultNormalsOff(self) -> None: ...
    def ResultNormalsOn(self) -> None: ...
    def ResultTCoordsOff(self) -> None: ...
    def ResultTCoordsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayCalculator': ...
    def SetAttributeType(self, _arg:int) -> None: ...
    def SetAttributeTypeToCellData(self) -> None: ...
    def SetAttributeTypeToDefault(self) -> None: ...
    def SetAttributeTypeToEdgeData(self) -> None: ...
    def SetAttributeTypeToPointData(self) -> None: ...
    def SetAttributeTypeToRowData(self) -> None: ...
    def SetAttributeTypeToVertexData(self) -> None: ...
    def SetCoordinateResults(self, _arg:int) -> None: ...
    def SetFunction(self, _arg:str) -> None: ...
    def SetFunctionParserType(self, _arg:'FunctionParserTypes') -> None: ...
    def SetFunctionParserTypeToExprTkFunctionParser(self) -> None: ...
    def SetFunctionParserTypeToFunctionParser(self) -> None: ...
    def SetIgnoreMissingArrays(self, _arg:bool) -> None: ...
    def SetReplaceInvalidValues(self, _arg:int) -> None: ...
    def SetReplacementValue(self, _arg:float) -> None: ...
    def SetResultArrayName(self, _arg:str) -> None: ...
    def SetResultArrayType(self, _arg:int) -> None: ...
    def SetResultNormals(self, _arg:bool) -> None: ...
    def SetResultTCoords(self, _arg:bool) -> None: ...

class vtkArrayRename(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def ClearAll(self) -> None: ...
    def ClearCellMapping(self) -> None: ...
    def ClearEdgeMapping(self) -> None: ...
    def ClearFieldMapping(self) -> None: ...
    def ClearMapping(self, attributeType:int) -> None: ...
    def ClearPointMapping(self) -> None: ...
    def ClearRowMapping(self) -> None: ...
    def ClearVertexMapping(self) -> None: ...
    def GetArrayNewName(self, attributeType:int, idx:int) -> str: ...
    def GetArrayOriginalName(self, attributeType:int, idx:int) -> str: ...
    def GetCellArrayNewName(self, idx:int) -> str: ...
    def GetCellArrayOriginalName(self, idx:int) -> str: ...
    def GetEdgeArrayNewName(self, idx:int) -> str: ...
    def GetEdgeArrayOriginalName(self, idx:int) -> str: ...
    def GetFieldArrayNewName(self, idx:int) -> str: ...
    def GetFieldArrayOriginalName(self, idx:int) -> str: ...
    def GetNumberOfArrays(self, attributeType:int) -> int: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfEdgeArrays(self) -> int: ...
    def GetNumberOfFieldArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfRowArrays(self) -> int: ...
    def GetNumberOfVertexArrays(self) -> int: ...
    def GetPointArrayNewName(self, idx:int) -> str: ...
    def GetPointArrayOriginalName(self, idx:int) -> str: ...
    def GetRowArrayNewName(self, idx:int) -> str: ...
    def GetRowArrayOriginalName(self, idx:int) -> str: ...
    def GetVertexArrayNewName(self, idx:int) -> str: ...
    def GetVertexArrayOriginalName(self, idx:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayRename': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayRename': ...
    @overload
    def SetArrayName(self, attributeType:int, idx:int, newName:str) -> None: ...
    @overload
    def SetArrayName(self, attributeType:int, inputName:str, newName:str) -> None: ...
    @overload
    def SetCellArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetCellArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetEdgeArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetEdgeArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetFieldArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetFieldArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetPointArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetPointArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetRowArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetRowArrayName(self, inputName:str, newName:str) -> None: ...
    @overload
    def SetVertexArrayName(self, idx:int, newName:str) -> None: ...
    @overload
    def SetVertexArrayName(self, inputName:str, newName:str) -> None: ...

class vtkAssignAttribute(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class AttributeLocation(int): ...
    CELL_DATA:'AttributeLocation'
    EDGE_DATA:'AttributeLocation'
    NUM_ATTRIBUTE_LOCS:'AttributeLocation'
    POINT_DATA:'AttributeLocation'
    VERTEX_DATA:'AttributeLocation'
    @overload
    def Assign(self, inputAttributeType:int, attributeType:int, attributeLoc:int) -> None: ...
    @overload
    def Assign(self, fieldName:str, attributeType:int, attributeLoc:int) -> None: ...
    @overload
    def Assign(self, name:str, attributeType:str, attributeLoc:str) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssignAttribute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssignAttribute': ...

class vtkAttributeDataToFieldDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassAttributeData(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAttributeDataToFieldDataFilter': ...
    def PassAttributeDataOff(self) -> None: ...
    def PassAttributeDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAttributeDataToFieldDataFilter': ...
    def SetPassAttributeData(self, _arg:int) -> None: ...

class vtkBinCellDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class CellOverlapCriterion(int): ...
    CELL_CENTROID:'CellOverlapCriterion'
    CELL_POINTS:'CellOverlapCriterion'
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    @overload
    def GenerateValues(self, numBins:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numBins:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetCellLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetCellOverlapMethod(self) -> int: ...
    def GetCellOverlapMethodMaxValue(self) -> int: ...
    def GetCellOverlapMethodMinValue(self) -> int: ...
    def GetComputeTolerance(self) -> bool: ...
    def GetNumberOfBins(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNonzeroBinsArrayName(self) -> str: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetSpatialMatch(self) -> int: ...
    def GetStoreNumberOfNonzeroBins(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, binValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBinCellDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBinCellDataFilter': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetCellLocator(self, cellLocator:'vtkAbstractCellLocator') -> None: ...
    def SetCellOverlapMethod(self, _arg:int) -> None: ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetNumberOfBins(self, numBins:int) -> None: ...
    def SetNumberOfNonzeroBinsArrayName(self, _arg:str) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetSpatialMatch(self, _arg:int) -> None: ...
    def SetStoreNumberOfNonzeroBins(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def SpatialMatchOff(self) -> None: ...
    def SpatialMatchOn(self) -> None: ...
    def StoreNumberOfNonzeroBinsOff(self) -> None: ...
    def StoreNumberOfNonzeroBinsOn(self) -> None: ...

class vtkBinnedDecimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    BIN_AVERAGES:int
    BIN_CENTERS:int
    BIN_POINTS:int
    INPUT_POINTS:int
    def AutoAdjustNumberOfDivisionsOff(self) -> None: ...
    def AutoAdjustNumberOfDivisionsOn(self) -> None: ...
    def GetAutoAdjustNumberOfDivisions(self) -> bool: ...
    def GetDivisionOrigin(self) -> Tuple[float, float, float]: ...
    def GetDivisionSpacing(self) -> Tuple[float, float, float]: ...
    def GetLargeIds(self) -> bool: ...
    @overload
    def GetNumberOfDivisions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXDivisions(self) -> int: ...
    def GetNumberOfYDivisions(self) -> int: ...
    def GetNumberOfZDivisions(self) -> int: ...
    def GetPointGenerationMode(self) -> int: ...
    def GetPointGenerationModeMaxValue(self) -> int: ...
    def GetPointGenerationModeMinValue(self) -> int: ...
    def GetProduceCellData(self) -> bool: ...
    def GetProducePointData(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBinnedDecimation': ...
    def ProduceCellDataOff(self) -> None: ...
    def ProduceCellDataOn(self) -> None: ...
    def ProducePointDataOff(self) -> None: ...
    def ProducePointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBinnedDecimation': ...
    def SetAutoAdjustNumberOfDivisions(self, _arg:bool) -> None: ...
    @overload
    def SetDivisionOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionOrigin(self, o:MutableSequence[float]) -> None: ...
    @overload
    def SetDivisionSpacing(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionSpacing(self, s:MutableSequence[float]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div0:int, div1:int, div2:int) -> None: ...
    def SetNumberOfXDivisions(self, num:int) -> None: ...
    def SetNumberOfYDivisions(self, num:int) -> None: ...
    def SetNumberOfZDivisions(self, num:int) -> None: ...
    def SetPointGenerationMode(self, _arg:int) -> None: ...
    def SetPointGenerationModeToBinAverages(self) -> None: ...
    def SetPointGenerationModeToBinCenters(self) -> None: ...
    def SetPointGenerationModeToBinPoints(self) -> None: ...
    def SetPointGenerationModeToUseInputPoints(self) -> None: ...
    def SetProduceCellData(self, _arg:bool) -> None: ...
    def SetProducePointData(self, _arg:bool) -> None: ...

class vtkCellCenters(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    @staticmethod
    def ComputeCellCenters(dataset:'vtkDataSet', centers:'vtkDoubleArray') -> None: ...
    def CopyArraysOff(self) -> None: ...
    def CopyArraysOn(self) -> None: ...
    def GetCopyArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVertexCells(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellCenters': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellCenters': ...
    def SetCopyArrays(self, _arg:bool) -> None: ...
    def SetVertexCells(self, _arg:bool) -> None: ...
    def VertexCellsOff(self) -> None: ...
    def VertexCellsOn(self) -> None: ...

class vtkCellDataToPointData(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class ContributingCellEnum(int): ...
    All:'ContributingCellEnum'
    DataSetMax:'ContributingCellEnum'
    Patch:'ContributingCellEnum'
    def AddCellDataArray(self, name:str) -> None: ...
    def ClearCellDataArrays(self) -> None: ...
    def GetContributingCellOption(self) -> int: ...
    def GetContributingCellOptionMaxValue(self) -> int: ...
    def GetContributingCellOptionMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellData(self) -> bool: ...
    def GetProcessAllArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellDataToPointData': ...
    def PassCellDataOff(self) -> None: ...
    def PassCellDataOn(self) -> None: ...
    def ProcessAllArraysOff(self) -> None: ...
    def ProcessAllArraysOn(self) -> None: ...
    def RemoveCellDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellDataToPointData': ...
    def SetContributingCellOption(self, _arg:int) -> None: ...
    def SetPassCellData(self, _arg:bool) -> None: ...
    def SetProcessAllArrays(self, _arg:bool) -> None: ...

class vtkCenterOfMass(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    @staticmethod
    def ComputeCenterOfMass(input:'vtkPoints', scalars:'vtkDataArray', center:MutableSequence[float]) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseScalarsAsWeights(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCenterOfMass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCenterOfMass': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetUseScalarsAsWeights(self, _arg:bool) -> None: ...

class vtkCleanPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ConvertLinesToPointsOff(self) -> None: ...
    def ConvertLinesToPointsOn(self) -> None: ...
    def ConvertPolysToLinesOff(self) -> None: ...
    def ConvertPolysToLinesOn(self) -> None: ...
    def ConvertStripsToPolysOff(self) -> None: ...
    def ConvertStripsToPolysOn(self) -> None: ...
    def CreateDefaultLocator(self, input:'vtkPolyData'=...) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetConvertLinesToPoints(self) -> int: ...
    def GetConvertPolysToLines(self) -> int: ...
    def GetConvertStripsToPolys(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def GetPointMerging(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> int: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCleanPolyData': ...
    def OperateOnBounds(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    def OperateOnPoint(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def PointMergingOff(self) -> None: ...
    def PointMergingOn(self) -> None: ...
    def ReleaseLocator(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCleanPolyData': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetConvertLinesToPoints(self, _arg:int) -> None: ...
    def SetConvertPolysToLines(self, _arg:int) -> None: ...
    def SetConvertStripsToPolys(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetPointMerging(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:int) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkClipPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateDefaultLocator(self) -> None: ...
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetClipFunction(self) -> 'vtkImplicitFunction': ...
    def GetClippedOutput(self) -> 'vtkPolyData': ...
    def GetClippedOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetValue(self) -> float: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClipPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipPolyData': ...
    def SetClipFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetValue(self, _arg:float) -> None: ...

class vtkCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateDefaultLocator(self) -> None: ...
    def GenerateCutScalarsOff(self) -> None: ...
    def GenerateCutScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    @staticmethod
    def GetCellTypeDimensions(cellTypeDimensions:MutableSequence[int]) -> None: ...
    def GetCutFunction(self) -> 'vtkImplicitFunction': ...
    def GetGenerateCutScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetSortBy(self) -> int: ...
    def GetSortByAsString(self) -> str: ...
    def GetSortByMaxValue(self) -> int: ...
    def GetSortByMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCutter': ...
    def SetCutFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateCutScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSortBy(self, _arg:int) -> None: ...
    def SetSortByToSortByCell(self) -> None: ...
    def SetSortByToSortByValue(self) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkCompositeCutter(vtkCutter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeCutter': ...

class vtkProbeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def CategoricalDataOff(self) -> None: ...
    def CategoricalDataOn(self) -> None: ...
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    def GetCategoricalData(self) -> int: ...
    def GetCellLocatorPrototype(self) -> 'vtkAbstractCellLocator': ...
    def GetComputeTolerance(self) -> bool: ...
    def GetFindCellStrategy(self) -> 'vtkFindCellStrategy': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> int: ...
    def GetPassFieldArrays(self) -> int: ...
    def GetPassPointArrays(self) -> int: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetSpatialMatch(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetValidPointMaskArrayName(self) -> str: ...
    def GetValidPoints(self) -> 'vtkIdTypeArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProbeFilter': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProbeFilter': ...
    def SetCategoricalData(self, _arg:int) -> None: ...
    def SetCellLocatorPrototype(self, __a:'vtkAbstractCellLocator') -> None: ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetFindCellStrategy(self, __a:'vtkFindCellStrategy') -> None: ...
    def SetPassCellArrays(self, _arg:int) -> None: ...
    def SetPassFieldArrays(self, _arg:int) -> None: ...
    def SetPassPointArrays(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetSpatialMatch(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetValidPointMaskArrayName(self, _arg:str) -> None: ...
    def SpatialMatchOff(self) -> None: ...
    def SpatialMatchOn(self) -> None: ...

class vtkCompositeDataProbeFilter(vtkProbeFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPartialArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataProbeFilter': ...
    def PassPartialArraysOff(self) -> None: ...
    def PassPartialArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataProbeFilter': ...
    def SetPassPartialArrays(self, _arg:bool) -> None: ...

class vtkConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class RegionIdAssignment(int): ...
    CELL_COUNT_ASCENDING:'RegionIdAssignment'
    CELL_COUNT_DESCENDING:'RegionIdAssignment'
    UNSPECIFIED:'RegionIdAssignment'
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionIdAssignmentMode(self) -> int: ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRegionIdAssignmentMode(self, _arg:int) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkConstrainedSmoothingFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class ConstraintStrategyType(int): ...
    CONSTRAINT_ARRAY:'ConstraintStrategyType'
    CONSTRAINT_DISTANCE:'ConstraintStrategyType'
    DEFAULT:'ConstraintStrategyType'
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetConstraintDistance(self) -> float: ...
    def GetConstraintDistanceMaxValue(self) -> float: ...
    def GetConstraintDistanceMinValue(self) -> float: ...
    def GetConstraintStrategy(self) -> int: ...
    def GetConstraintStrategyMaxValue(self) -> int: ...
    def GetConstraintStrategyMinValue(self) -> int: ...
    def GetConvergence(self) -> float: ...
    def GetConvergenceMaxValue(self) -> float: ...
    def GetConvergenceMinValue(self) -> float: ...
    def GetGenerateErrorScalars(self) -> bool: ...
    def GetGenerateErrorVectors(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetSmoothingStencils(self) -> 'vtkCellArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConstrainedSmoothingFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConstrainedSmoothingFilter': ...
    def SetConstraintDistance(self, _arg:float) -> None: ...
    def SetConstraintStrategy(self, _arg:int) -> None: ...
    def SetConstraintStrategyToConstraintArray(self) -> None: ...
    def SetConstraintStrategyToConstraintDistance(self) -> None: ...
    def SetConstraintStrategyToDefault(self) -> None: ...
    def SetConvergence(self, _arg:float) -> None: ...
    def SetGenerateErrorScalars(self, _arg:bool) -> None: ...
    def SetGenerateErrorVectors(self, _arg:bool) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRelaxationFactor(self, _arg:float) -> None: ...
    def SetSmoothingStencils(self, _arg:'vtkCellArray') -> None: ...

class vtkContour3DLinearGrid(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject', scalarArrayName:str) -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetLargeIds(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMergePoints(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetSequentialProcessing(self) -> int: ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkContour3DLinearGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContour3DLinearGrid': ...
    def SequentialProcessingOff(self) -> None: ...
    def SequentialProcessingOn(self) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetMergePoints(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetScalarTree(self, __a:'vtkScalarTree') -> None: ...
    def SetSequentialProcessing(self, _arg:int) -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourFilter': ...
    def SetArrayComponent(self, __a:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetScalarTree(self, __a:'vtkScalarTree') -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourGrid(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScalarTree(self) -> 'vtkScalarTree': ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourGrid': ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetScalarTree(self, sTree:'vtkScalarTree') -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkContourHelper(object):
    def __init__(self, locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', lines:'vtkCellArray', polys:'vtkCellArray', inPd:'vtkPointData', inCd:'vtkCellData', outPd:'vtkPointData', outCd:'vtkCellData', estimatedSize:int, outputTriangles:bool) -> None: ...
    def Contour(self, cell:'vtkCell', value:float, cellScalars:'vtkDataArray', cellId:int) -> None: ...

class vtkConvertToMultiBlockDataSet(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToMultiBlockDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToMultiBlockDataSet': ...

class vtkConvertToPartitionedDataSetCollection(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToPartitionedDataSetCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToPartitionedDataSetCollection': ...

class vtkConvertToPolyhedra(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputAllCells(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertToPolyhedra': ...
    def OutputAllCellsOff(self) -> None: ...
    def OutputAllCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertToPolyhedra': ...
    def SetOutputAllCells(self, _arg:bool) -> None: ...

class vtkDataObjectGenerator(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProgram(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectGenerator': ...
    def SetProgram(self, _arg:str) -> None: ...

class vtkDataObjectToDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def DefaultNormalizeOff(self) -> None: ...
    def DefaultNormalizeOn(self) -> None: ...
    def GetCellConnectivityComponentArrayComponent(self) -> int: ...
    def GetCellConnectivityComponentArrayName(self) -> str: ...
    def GetCellConnectivityComponentMaxRange(self) -> int: ...
    def GetCellConnectivityComponentMinRange(self) -> int: ...
    def GetCellTypeComponentArrayComponent(self) -> int: ...
    def GetCellTypeComponentArrayName(self) -> str: ...
    def GetCellTypeComponentMaxRange(self) -> int: ...
    def GetCellTypeComponentMinRange(self) -> int: ...
    def GetDataSetType(self) -> int: ...
    def GetDefaultNormalize(self) -> int: ...
    def GetDimensions(self) -> Tuple[int, int, int]: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLinesComponentArrayComponent(self) -> int: ...
    def GetLinesComponentArrayName(self) -> str: ...
    def GetLinesComponentMaxRange(self) -> int: ...
    def GetLinesComponentMinRange(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOutput(self) -> 'vtkDataSet': ...
    @overload
    def GetOutput(self, idx:int) -> 'vtkDataSet': ...
    def GetPointComponentArrayComponent(self, comp:int) -> int: ...
    def GetPointComponentArrayName(self, comp:int) -> str: ...
    def GetPointComponentMaxRange(self, comp:int) -> int: ...
    def GetPointComponentMinRange(self, comp:int) -> int: ...
    def GetPointComponentNormailzeFlag(self, comp:int) -> int: ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetPolysComponentArrayComponent(self) -> int: ...
    def GetPolysComponentArrayName(self) -> str: ...
    def GetPolysComponentMaxRange(self) -> int: ...
    def GetPolysComponentMinRange(self) -> int: ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def GetStripsComponentArrayComponent(self) -> int: ...
    def GetStripsComponentArrayName(self) -> str: ...
    def GetStripsComponentMaxRange(self) -> int: ...
    def GetStripsComponentMinRange(self) -> int: ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetVertsComponentArrayComponent(self) -> int: ...
    def GetVertsComponentArrayName(self) -> str: ...
    def GetVertsComponentMaxRange(self) -> int: ...
    def GetVertsComponentMinRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectToDataSetFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectToDataSetFilter': ...
    @overload
    def SetCellConnectivityComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetCellConnectivityComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetCellTypeComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetCellTypeComponent(self, arrayName:str, arrayComp:int) -> None: ...
    def SetDataSetType(self, __a:int) -> None: ...
    def SetDataSetTypeToPolyData(self) -> None: ...
    def SetDataSetTypeToRectilinearGrid(self) -> None: ...
    def SetDataSetTypeToStructuredGrid(self) -> None: ...
    def SetDataSetTypeToStructuredPoints(self) -> None: ...
    def SetDataSetTypeToUnstructuredGrid(self) -> None: ...
    def SetDefaultNormalize(self, _arg:int) -> None: ...
    @overload
    def SetDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetDimensions(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetDimensionsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetDimensionsComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetLinesComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetLinesComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetOriginComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetOriginComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetPointComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetPointComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetPolysComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetPolysComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpacing(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSpacingComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetSpacingComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetStripsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetStripsComponent(self, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetVertsComponent(self, arrayName:str, arrayComp:int, min:int, max:int) -> None: ...
    @overload
    def SetVertsComponent(self, arrayName:str, arrayComp:int) -> None: ...

class vtkEdgeSubdivisionCriterion(vtkmodules.vtkCommonCore.vtkObject):
    def DontPassField(self, sourceId:int, t:'vtkStreamingTessellator') -> bool: ...
    def EvaluateLocationAndFields(self, p1:MutableSequence[float], field_start:int) -> bool: ...
    def GetFieldIds(self) -> Pointer: ...
    def GetFieldOffsets(self) -> Pointer: ...
    def GetNumberOfFields(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputField(self, fieldId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgeSubdivisionCriterion': ...
    def PassField(self, sourceId:int, sourceSize:int, t:'vtkStreamingTessellator') -> int: ...
    def ResetFieldList(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgeSubdivisionCriterion': ...

class vtkDataSetEdgeSubdivisionCriterion(vtkEdgeSubdivisionCriterion):
    def EvaluateCellDataField(self, result:MutableSequence[float], weights:MutableSequence[float], field:int) -> None: ...
    def EvaluateFields(self, vertex:MutableSequence[float], weights:MutableSequence[float], field_start:int) -> Pointer: ...
    def EvaluateLocationAndFields(self, midpt:MutableSequence[float], field_start:int) -> bool: ...
    def EvaluatePointDataField(self, result:MutableSequence[float], weights:MutableSequence[float], field:int) -> None: ...
    def GetActiveFieldCriteria(self) -> int: ...
    def GetCell(self) -> 'vtkCell': ...
    def GetCellId(self) -> int: ...
    def GetChordError2(self) -> float: ...
    def GetFieldError2(self, s:int) -> float: ...
    def GetMesh(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetEdgeSubdivisionCriterion': ...
    def ResetFieldError2(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetEdgeSubdivisionCriterion': ...
    def SetCellId(self, cell:int) -> None: ...
    def SetChordError2(self, _arg:float) -> None: ...
    def SetFieldError2(self, s:int, err:float) -> None: ...
    def SetMesh(self, __a:'vtkDataSet') -> None: ...

class vtkDataSetToDataObjectFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def CellDataOff(self) -> None: ...
    def CellDataOn(self) -> None: ...
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GeometryOff(self) -> None: ...
    def GeometryOn(self) -> None: ...
    def GetCellData(self) -> int: ...
    def GetFieldData(self) -> int: ...
    def GetGeometry(self) -> int: ...
    def GetLegacyTopology(self) -> int: ...
    def GetModernTopology(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointData(self) -> int: ...
    def GetTopology(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LegacyTopologyOff(self) -> None: ...
    def LegacyTopologyOn(self) -> None: ...
    def ModernTopologyOff(self) -> None: ...
    def ModernTopologyOn(self) -> None: ...
    def NewInstance(self) -> 'vtkDataSetToDataObjectFilter': ...
    def PointDataOff(self) -> None: ...
    def PointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetToDataObjectFilter': ...
    def SetCellData(self, _arg:int) -> None: ...
    def SetFieldData(self, _arg:int) -> None: ...
    def SetGeometry(self, _arg:int) -> None: ...
    def SetLegacyTopology(self, _arg:int) -> None: ...
    def SetModernTopology(self, _arg:int) -> None: ...
    def SetPointData(self, _arg:int) -> None: ...
    def SetTopology(self, _arg:int) -> None: ...
    def TopologyOff(self) -> None: ...
    def TopologyOn(self) -> None: ...

class vtkDecimatePolylineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetMaximumError(self) -> float: ...
    def GetMaximumErrorMaxValue(self) -> float: ...
    def GetMaximumErrorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePolylineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePolylineFilter': ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...

class vtkDecimatePro(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AccumulateErrorOff(self) -> None: ...
    def AccumulateErrorOn(self) -> None: ...
    def BoundaryVertexDeletionOff(self) -> None: ...
    def BoundaryVertexDeletionOn(self) -> None: ...
    def GetAbsoluteError(self) -> float: ...
    def GetAbsoluteErrorMaxValue(self) -> float: ...
    def GetAbsoluteErrorMinValue(self) -> float: ...
    def GetAccumulateError(self) -> int: ...
    def GetBoundaryVertexDeletion(self) -> int: ...
    def GetDegree(self) -> int: ...
    def GetDegreeMaxValue(self) -> int: ...
    def GetDegreeMinValue(self) -> int: ...
    def GetErrorIsAbsolute(self) -> int: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetInflectionPointRatio(self) -> float: ...
    def GetInflectionPointRatioMaxValue(self) -> float: ...
    def GetInflectionPointRatioMinValue(self) -> float: ...
    @overload
    def GetInflectionPoints(self, inflectionPoints:MutableSequence[float]) -> None: ...
    @overload
    def GetInflectionPoints(self) -> Pointer: ...
    def GetMaximumError(self) -> float: ...
    def GetMaximumErrorMaxValue(self) -> float: ...
    def GetMaximumErrorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInflectionPoints(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPreSplitMesh(self) -> int: ...
    def GetPreserveTopology(self) -> int: ...
    def GetSplitAngle(self) -> float: ...
    def GetSplitAngleMaxValue(self) -> float: ...
    def GetSplitAngleMinValue(self) -> float: ...
    def GetSplitting(self) -> int: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDecimatePro': ...
    def PreSplitMeshOff(self) -> None: ...
    def PreSplitMeshOn(self) -> None: ...
    def PreserveTopologyOff(self) -> None: ...
    def PreserveTopologyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDecimatePro': ...
    def SetAbsoluteError(self, _arg:float) -> None: ...
    def SetAccumulateError(self, _arg:int) -> None: ...
    def SetBoundaryVertexDeletion(self, _arg:int) -> None: ...
    def SetDegree(self, _arg:int) -> None: ...
    def SetErrorIsAbsolute(self, _arg:int) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetInflectionPointRatio(self, _arg:float) -> None: ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPreSplitMesh(self, _arg:int) -> None: ...
    def SetPreserveTopology(self, _arg:int) -> None: ...
    def SetSplitAngle(self, _arg:float) -> None: ...
    def SetSplitting(self, _arg:int) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...
    def SplittingOff(self) -> None: ...
    def SplittingOn(self) -> None: ...

class vtkDelaunay2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def BoundingTriangulationOff(self) -> None: ...
    def BoundingTriangulationOn(self) -> None: ...
    @staticmethod
    def ComputeBestFittingPlane(input:'vtkPointSet') -> 'vtkAbstractTransform': ...
    def GetAlpha(self) -> float: ...
    def GetAlphaMaxValue(self) -> float: ...
    def GetAlphaMinValue(self) -> float: ...
    def GetBoundingTriangulation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOffsetMaxValue(self) -> float: ...
    def GetOffsetMinValue(self) -> float: ...
    def GetProjectionPlaneMode(self) -> int: ...
    def GetProjectionPlaneModeMaxValue(self) -> int: ...
    def GetProjectionPlaneModeMinValue(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDelaunay2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDelaunay2D': ...
    def SetAlpha(self, _arg:float) -> None: ...
    def SetBoundingTriangulation(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetProjectionPlaneMode(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, __a:'vtkPolyData') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...

class vtkDelaunay3D(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def AlphaLinesOff(self) -> None: ...
    def AlphaLinesOn(self) -> None: ...
    def AlphaTetsOff(self) -> None: ...
    def AlphaTetsOn(self) -> None: ...
    def AlphaTrisOff(self) -> None: ...
    def AlphaTrisOn(self) -> None: ...
    def AlphaVertsOff(self) -> None: ...
    def AlphaVertsOn(self) -> None: ...
    def BoundingTriangulationOff(self) -> None: ...
    def BoundingTriangulationOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def EndPointInsertion(self) -> None: ...
    def GetAlpha(self) -> float: ...
    def GetAlphaLines(self) -> int: ...
    def GetAlphaMaxValue(self) -> float: ...
    def GetAlphaMinValue(self) -> float: ...
    def GetAlphaTets(self) -> int: ...
    def GetAlphaTris(self) -> int: ...
    def GetAlphaVerts(self) -> int: ...
    def GetBoundingTriangulation(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOffsetMaxValue(self) -> float: ...
    def GetOffsetMinValue(self) -> float: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def InsertPoint(self, Mesh:'vtkUnstructuredGrid', points:'vtkPoints', id:int, x:MutableSequence[float], holeTetras:'vtkIdList') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDelaunay3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDelaunay3D': ...
    def SetAlpha(self, _arg:float) -> None: ...
    def SetAlphaLines(self, _arg:int) -> None: ...
    def SetAlphaTets(self, _arg:int) -> None: ...
    def SetAlphaTris(self, _arg:int) -> None: ...
    def SetAlphaVerts(self, _arg:int) -> None: ...
    def SetBoundingTriangulation(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkElevationFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetHighPoint(self) -> Tuple[float, float, float]: ...
    def GetLowPoint(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkElevationFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkElevationFilter': ...
    @overload
    def SetHighPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHighPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLowPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLowPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkExecutionTimer(vtkmodules.vtkCommonCore.vtkObject):
    def GetElapsedCPUTime(self) -> float: ...
    def GetElapsedWallClockTime(self) -> float: ...
    def GetFilter(self) -> 'vtkAlgorithm': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExecutionTimer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExecutionTimer': ...
    def SetFilter(self, filter:'vtkAlgorithm') -> None: ...

class vtkExplicitStructuredGridCrop(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridCrop': ...
    def ResetOutputWholeExtent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridCrop': ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int], outInfo:'vtkInformation'=...) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkExplicitStructuredGridToUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridToUnstructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridToUnstructuredGrid': ...

class vtkExtractCellsAlongPolyLine(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractCellsAlongPolyLine': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractCellsAlongPolyLine': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSourceConnection(self, input:'vtkAlgorithmOutput') -> None: ...

class vtkExtractEdges(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseAllPoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractEdges': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractEdges': ...
    def SetLocator(self, _arg:'vtkIncrementalPointLocator') -> None: ...
    def SetUseAllPoints(self, _arg:bool) -> None: ...
    def UseAllPointsOff(self) -> None: ...
    def UseAllPointsOn(self) -> None: ...

class vtkFeatureEdges(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def BoundaryEdgesOff(self) -> None: ...
    def BoundaryEdgesOn(self) -> None: ...
    def ColoringOff(self) -> None: ...
    def ColoringOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def ExtractAllEdgeTypesOff(self) -> None: ...
    def ExtractAllEdgeTypesOn(self) -> None: ...
    def FeatureEdgesOff(self) -> None: ...
    def FeatureEdgesOn(self) -> None: ...
    def GetBoundaryEdges(self) -> bool: ...
    def GetColoring(self) -> bool: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdges(self) -> bool: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetManifoldEdges(self) -> bool: ...
    def GetNonManifoldEdges(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassLines(self) -> bool: ...
    def GetRemoveGhostInterfaces(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ManifoldEdgesOff(self) -> None: ...
    def ManifoldEdgesOn(self) -> None: ...
    def NewInstance(self) -> 'vtkFeatureEdges': ...
    def NonManifoldEdgesOff(self) -> None: ...
    def NonManifoldEdgesOn(self) -> None: ...
    def PassLinesOff(self) -> None: ...
    def PassLinesOn(self) -> None: ...
    def RemoveGhostInterfacesOff(self) -> None: ...
    def RemoveGhostInterfacesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFeatureEdges': ...
    def SetBoundaryEdges(self, _arg:bool) -> None: ...
    def SetColoring(self, _arg:bool) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdges(self, _arg:bool) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetManifoldEdges(self, _arg:bool) -> None: ...
    def SetNonManifoldEdges(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPassLines(self, _arg:bool) -> None: ...
    def SetRemoveGhostInterfaces(self, _arg:bool) -> None: ...

class vtkFieldDataToAttributeDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    @staticmethod
    def ConstructArray(da:'vtkDataArray', comp:int, fieldArray:'vtkDataArray', fieldComp:int, min:int, max:int, normalize:int) -> int: ...
    def DefaultNormalizeOff(self) -> None: ...
    def DefaultNormalizeOn(self) -> None: ...
    def GetDefaultNormalize(self) -> int: ...
    @staticmethod
    def GetFieldArray(fd:'vtkFieldData', name:str, comp:int) -> 'vtkDataArray': ...
    def GetInputField(self) -> int: ...
    def GetNormalComponentArrayComponent(self, comp:int) -> int: ...
    def GetNormalComponentArrayName(self, comp:int) -> str: ...
    def GetNormalComponentMaxRange(self, comp:int) -> int: ...
    def GetNormalComponentMinRange(self, comp:int) -> int: ...
    def GetNormalComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputAttributeData(self) -> int: ...
    def GetScalarComponentArrayComponent(self, comp:int) -> int: ...
    def GetScalarComponentArrayName(self, comp:int) -> str: ...
    def GetScalarComponentMaxRange(self, comp:int) -> int: ...
    def GetScalarComponentMinRange(self, comp:int) -> int: ...
    def GetScalarComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetTCoordComponentArrayComponent(self, comp:int) -> int: ...
    def GetTCoordComponentArrayName(self, comp:int) -> str: ...
    def GetTCoordComponentMaxRange(self, comp:int) -> int: ...
    def GetTCoordComponentMinRange(self, comp:int) -> int: ...
    def GetTCoordComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetTensorComponentArrayComponent(self, comp:int) -> int: ...
    def GetTensorComponentArrayName(self, comp:int) -> str: ...
    def GetTensorComponentMaxRange(self, comp:int) -> int: ...
    def GetTensorComponentMinRange(self, comp:int) -> int: ...
    def GetTensorComponentNormalizeFlag(self, comp:int) -> int: ...
    def GetVectorComponentArrayComponent(self, comp:int) -> int: ...
    def GetVectorComponentArrayName(self, comp:int) -> str: ...
    def GetVectorComponentMaxRange(self, comp:int) -> int: ...
    def GetVectorComponentMinRange(self, comp:int) -> int: ...
    def GetVectorComponentNormalizeFlag(self, comp:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFieldDataToAttributeDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFieldDataToAttributeDataFilter': ...
    def SetDefaultNormalize(self, _arg:int) -> None: ...
    def SetInputField(self, _arg:int) -> None: ...
    def SetInputFieldToCellDataField(self) -> None: ...
    def SetInputFieldToDataObjectField(self) -> None: ...
    def SetInputFieldToPointDataField(self) -> None: ...
    @overload
    def SetNormalComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetNormalComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    def SetOutputAttributeData(self, _arg:int) -> None: ...
    def SetOutputAttributeDataToCellData(self) -> None: ...
    def SetOutputAttributeDataToPointData(self) -> None: ...
    @overload
    def SetScalarComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetScalarComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetTCoordComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetTCoordComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetTensorComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetTensorComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @overload
    def SetVectorComponent(self, comp:int, arrayName:str, arrayComp:int, min:int, max:int, normalize:int) -> None: ...
    @overload
    def SetVectorComponent(self, comp:int, arrayName:str, arrayComp:int) -> None: ...
    @staticmethod
    def UpdateComponentRange(da:'vtkDataArray', compRange:MutableSequence[int]) -> int: ...

class vtkFlyingEdges2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdges2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdges2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkFlyingEdges3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdges3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdges3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkFlyingEdgesPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlyingEdgesPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlyingEdgesPlaneCutter': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkGlyph3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def FillCellDataOff(self) -> None: ...
    def FillCellDataOn(self) -> None: ...
    def GeneratePointIdsOff(self) -> None: ...
    def GeneratePointIdsOn(self) -> None: ...
    def GetClamping(self) -> int: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetFillCellData(self) -> int: ...
    def GetFollowedCameraPosition(self) -> Tuple[float, float, float]: ...
    def GetFollowedCameraViewUp(self) -> Tuple[float, float, float]: ...
    def GetGeneratePointIds(self) -> int: ...
    def GetIndexMode(self) -> int: ...
    def GetIndexModeAsString(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrient(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPointIdsName(self) -> str: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleMode(self) -> int: ...
    def GetScaleModeAsString(self) -> str: ...
    def GetScaling(self) -> int: ...
    def GetSource(self, id:int=0) -> 'vtkPolyData': ...
    def GetSourceTransform(self) -> 'vtkTransform': ...
    def GetVectorMode(self) -> int: ...
    def GetVectorModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    def IsPointVisible(self, __a:'vtkDataSet', __b:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGlyph3D': ...
    def OrientOff(self) -> None: ...
    def OrientOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGlyph3D': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetClamping(self, _arg:int) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToColorByScalar(self) -> None: ...
    def SetColorModeToColorByScale(self) -> None: ...
    def SetColorModeToColorByVector(self) -> None: ...
    def SetFillCellData(self, _arg:int) -> None: ...
    def SetFollowedCameraPosition(self, data:Sequence[float]) -> None: ...
    def SetFollowedCameraViewUp(self, data:Sequence[float]) -> None: ...
    def SetGeneratePointIds(self, _arg:int) -> None: ...
    def SetIndexMode(self, _arg:int) -> None: ...
    def SetIndexModeToOff(self) -> None: ...
    def SetIndexModeToScalar(self) -> None: ...
    def SetIndexModeToVector(self) -> None: ...
    def SetOrient(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPointIdsName(self, _arg:str) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleMode(self, _arg:int) -> None: ...
    def SetScaleModeToDataScalingOff(self) -> None: ...
    def SetScaleModeToScaleByScalar(self) -> None: ...
    def SetScaleModeToScaleByVector(self) -> None: ...
    def SetScaleModeToScaleByVectorComponents(self) -> None: ...
    def SetScaling(self, _arg:int) -> None: ...
    @overload
    def SetSourceConnection(self, id:int, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceData(self, pd:'vtkPolyData') -> None: ...
    @overload
    def SetSourceData(self, id:int, pd:'vtkPolyData') -> None: ...
    def SetSourceTransform(self, __a:'vtkTransform') -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToFollowCameraDirection(self) -> None: ...
    def SetVectorModeToUseNormal(self) -> None: ...
    def SetVectorModeToUseVector(self) -> None: ...
    def SetVectorModeToVectorRotationOff(self) -> None: ...

class vtkGlyph2D(vtkGlyph3D):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGlyph2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGlyph2D': ...

class vtkGridSynchronizedTemplates3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGridSynchronizedTemplates3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGridSynchronizedTemplates3D': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetInputMemoryLimit(self, limit:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkHedgeHog(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetVectorMode(self) -> int: ...
    def GetVectorModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHedgeHog': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHedgeHog': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToUseNormal(self) -> None: ...
    def SetVectorModeToUseVector(self) -> None: ...

class vtkHull(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def AddCubeEdgePlanes(self) -> None: ...
    def AddCubeFacePlanes(self) -> None: ...
    def AddCubeVertexPlanes(self) -> None: ...
    @overload
    def AddPlane(self, A:float, B:float, C:float) -> int: ...
    @overload
    def AddPlane(self, plane:MutableSequence[float]) -> int: ...
    @overload
    def AddPlane(self, A:float, B:float, C:float, D:float) -> int: ...
    @overload
    def AddPlane(self, plane:MutableSequence[float], D:float) -> int: ...
    def AddRecursiveSpherePlanes(self, level:int) -> None: ...
    @overload
    def GenerateHull(self, pd:'vtkPolyData', bounds:MutableSequence[float]) -> None: ...
    @overload
    def GenerateHull(self, pd:'vtkPolyData', xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPlanes(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHull': ...
    def RemoveAllPlanes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHull': ...
    @overload
    def SetPlane(self, i:int, A:float, B:float, C:float) -> None: ...
    @overload
    def SetPlane(self, i:int, plane:MutableSequence[float]) -> None: ...
    @overload
    def SetPlane(self, i:int, A:float, B:float, C:float, D:float) -> None: ...
    @overload
    def SetPlane(self, i:int, plane:MutableSequence[float], D:float) -> None: ...
    def SetPlanes(self, planes:'vtkPlanes') -> None: ...

class vtkIdFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def CellIdsOff(self) -> None: ...
    def CellIdsOn(self) -> None: ...
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GetCellIds(self) -> int: ...
    def GetCellIdsArrayName(self) -> str: ...
    def GetFieldData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIds(self) -> int: ...
    def GetPointIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIdFilter': ...
    def PointIdsOff(self) -> None: ...
    def PointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIdFilter': ...
    def SetCellIds(self, _arg:int) -> None: ...
    def SetCellIdsArrayName(self, _arg:str) -> None: ...
    def SetFieldData(self, _arg:int) -> None: ...
    def SetPointIds(self, _arg:int) -> None: ...
    def SetPointIdsArrayName(self, _arg:str) -> None: ...

class vtkImageAppend(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    def GetAppendAxis(self) -> int: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def GetPreserveExtents(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageAppend': ...
    def PreserveExtentsOff(self) -> None: ...
    def PreserveExtentsOn(self) -> None: ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageAppend': ...
    def SetAppendAxis(self, _arg:int) -> None: ...
    @overload
    def SetInputData(self, idx:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...
    def SetPreserveExtents(self, _arg:int) -> None: ...

class vtkImageDataToExplicitStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataToExplicitStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataToExplicitStructuredGrid': ...

class vtkImplicitPolyDataDistance(vtkmodules.vtkCommonDataModel.vtkImplicitFunction):
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateFunctionAndGetClosestPoint(self, x:MutableSequence[float], closestPoint:MutableSequence[float]) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNoClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetNoGradient(self) -> Tuple[float, float, float]: ...
    def GetNoValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitPolyDataDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitPolyDataDistance': ...
    def SetInput(self, input:'vtkPolyData') -> None: ...
    @overload
    def SetNoClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNoClosestPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNoGradient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNoGradient(self, _arg:Sequence[float]) -> None: ...
    def SetNoValue(self, _arg:float) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkImplicitProjectOnPlaneDistance(vtkmodules.vtkCommonDataModel.vtkImplicitFunction):
    class NormType(int):
        L0:'NormType'
        L2:'NormType'
    @overload
    def EvaluateFunction(self, x:MutableSequence[float]) -> float: ...
    @overload
    def EvaluateFunction(self, input:'vtkDataArray', output:'vtkDataArray') -> None: ...
    @overload
    def EvaluateFunction(self, x:float, y:float, z:float) -> float: ...
    def EvaluateGradient(self, x:MutableSequence[float], g:MutableSequence[float]) -> None: ...
    def GetLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetMTime(self) -> int: ...
    def GetNorm(self) -> 'NormType': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitProjectOnPlaneDistance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitProjectOnPlaneDistance': ...
    def SetInput(self, input:'vtkPolyData') -> None: ...
    def SetLocator(self, _arg:'vtkAbstractCellLocator') -> None: ...
    @overload
    def SetNorm(self, n:'NormType') -> None: ...
    @overload
    def SetNorm(self, n:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkMarchingCubes(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarchingCubes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarchingCubes': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkMarchingSquares(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetImageRange(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarchingSquares': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarchingSquares': ...
    @overload
    def SetImageRange(self, data:Sequence[int]) -> None: ...
    @overload
    def SetImageRange(self, imin:int, imax:int, jmin:int, jmax:int, kmin:int, kmax:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkMaskFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldLocation(int): ...
    CELL_DATA:'FieldLocation'
    OBJECT_DATA:'FieldLocation'
    POINT_DATA:'FieldLocation'
    def CopyAllOff(self) -> None: ...
    def CopyAllOn(self) -> None: ...
    @overload
    def CopyAttributeOff(self, attributeLocation:int, attributeType:int) -> None: ...
    @overload
    def CopyAttributeOff(self, attributeLoc:str, attributeType:str) -> None: ...
    @overload
    def CopyAttributeOn(self, attributeLocation:int, attributeType:int) -> None: ...
    @overload
    def CopyAttributeOn(self, attributeLoc:str, attributeType:str) -> None: ...
    def CopyAttributesOff(self) -> None: ...
    def CopyAttributesOn(self) -> None: ...
    @overload
    def CopyFieldOff(self, fieldLocation:int, name:str) -> None: ...
    @overload
    def CopyFieldOff(self, fieldLoc:str, name:str) -> None: ...
    @overload
    def CopyFieldOn(self, fieldLocation:int, name:str) -> None: ...
    @overload
    def CopyFieldOn(self, fieldLoc:str, name:str) -> None: ...
    def CopyFieldsOff(self) -> None: ...
    def CopyFieldsOn(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskFields': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskFields': ...

class vtkMaskPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class DistributionType(int): ...
    RANDOMIZED_ID_STRIDES:'DistributionType'
    RANDOM_SAMPLING:'DistributionType'
    SPATIALLY_STRATIFIED:'DistributionType'
    UNIFORM_SPATIAL_BOUNDS:'DistributionType'
    UNIFORM_SPATIAL_SURFACE:'DistributionType'
    UNIFORM_SPATIAL_VOLUME:'DistributionType'
    def GenerateVerticesOff(self) -> None: ...
    def GenerateVerticesOn(self) -> None: ...
    def GetGenerateVertices(self) -> bool: ...
    def GetMaximumNumberOfPoints(self) -> int: ...
    def GetMaximumNumberOfPointsMaxValue(self) -> int: ...
    def GetMaximumNumberOfPointsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetProportionalMaximumNumberOfPoints(self) -> bool: ...
    def GetRandomMode(self) -> bool: ...
    def GetRandomModeType(self) -> int: ...
    def GetRandomModeTypeMaxValue(self) -> int: ...
    def GetRandomModeTypeMinValue(self) -> int: ...
    def GetRandomSeed(self) -> int: ...
    def GetSingleVertexPerCell(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskPoints': ...
    def ProportionalMaximumNumberOfPointsOff(self) -> None: ...
    def ProportionalMaximumNumberOfPointsOn(self) -> None: ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskPoints': ...
    def SetGenerateVertices(self, _arg:bool) -> None: ...
    def SetMaximumNumberOfPoints(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetProportionalMaximumNumberOfPoints(self, _arg:bool) -> None: ...
    def SetRandomMode(self, _arg:bool) -> None: ...
    def SetRandomModeType(self, _arg:int) -> None: ...
    def SetRandomSeed(self, _arg:int) -> None: ...
    def SetSingleVertexPerCell(self, _arg:bool) -> None: ...
    def SingleVertexPerCellOff(self) -> None: ...
    def SingleVertexPerCellOn(self) -> None: ...

class vtkMaskPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMaskPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMaskPolyData': ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...

class vtkMassProperties(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetKx(self) -> float: ...
    def GetKy(self) -> float: ...
    def GetKz(self) -> float: ...
    def GetMaxCellArea(self) -> float: ...
    def GetMinCellArea(self) -> float: ...
    def GetNormalizedShapeIndex(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSurfaceArea(self) -> float: ...
    def GetVolume(self) -> float: ...
    def GetVolumeProjected(self) -> float: ...
    def GetVolumeX(self) -> float: ...
    def GetVolumeY(self) -> float: ...
    def GetVolumeZ(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMassProperties': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMassProperties': ...

class vtkMergeDataObjectFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetDataObject(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputField(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeDataObjectFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeDataObjectFilter': ...
    def SetDataObjectInputData(self, object:'vtkDataObject') -> None: ...
    def SetOutputField(self, _arg:int) -> None: ...
    def SetOutputFieldToCellDataField(self) -> None: ...
    def SetOutputFieldToDataObjectField(self) -> None: ...
    def SetOutputFieldToPointDataField(self) -> None: ...

class vtkMergeFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldLocations(int): ...
    CELL_DATA:'FieldLocations'
    DATA_OBJECT:'FieldLocations'
    POINT_DATA:'FieldLocations'
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Merge(self, component:int, arrayName:str, sourceComp:int) -> None: ...
    def NewInstance(self) -> 'vtkMergeFields': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeFields': ...
    def SetNumberOfComponents(self, _arg:int) -> None: ...
    @overload
    def SetOutputField(self, name:str, fieldLoc:int) -> None: ...
    @overload
    def SetOutputField(self, name:str, fieldLoc:str) -> None: ...

class vtkMergeFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def AddField(self, name:str, input:'vtkDataSet') -> None: ...
    def GetGeometry(self) -> 'vtkDataSet': ...
    def GetNormals(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalars(self) -> 'vtkDataSet': ...
    def GetTCoords(self) -> 'vtkDataSet': ...
    def GetTensors(self) -> 'vtkDataSet': ...
    def GetVectors(self) -> 'vtkDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeFilter': ...
    def SetGeometryConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetGeometryInputData(self, input:'vtkDataSet') -> None: ...
    def SetNormalsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetNormalsData(self, __a:'vtkDataSet') -> None: ...
    def SetScalarsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetScalarsData(self, __a:'vtkDataSet') -> None: ...
    def SetTCoordsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTCoordsData(self, __a:'vtkDataSet') -> None: ...
    def SetTensorsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTensorsData(self, __a:'vtkDataSet') -> None: ...
    def SetVectorsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetVectorsData(self, __a:'vtkDataSet') -> None: ...

class vtkMoleculeAppend(vtkmodules.vtkCommonExecutionModel.vtkMoleculeAlgorithm):
    @overload
    def GetInput(self, idx:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetMergeCoincidentAtoms(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeCoincidentAtomsOff(self) -> None: ...
    def MergeCoincidentAtomsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMoleculeAppend': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeAppend': ...
    def SetMergeCoincidentAtoms(self, _arg:bool) -> None: ...

class vtkMultiObjectMassProperties(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetAllValid(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjects(self) -> int: ...
    def GetObjectIdsArrayName(self) -> str: ...
    def GetSkipValidityCheck(self) -> int: ...
    def GetTotalArea(self) -> float: ...
    def GetTotalVolume(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiObjectMassProperties': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiObjectMassProperties': ...
    def SetObjectIdsArrayName(self, arg:str) -> None: ...
    def SetSkipValidityCheck(self, _arg:int) -> None: ...
    def SkipValidityCheckOff(self) -> None: ...
    def SkipValidityCheckOn(self) -> None: ...

class vtkPassThrough(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def AllowNullInputOff(self) -> None: ...
    def AllowNullInputOn(self) -> None: ...
    def DeepCopyInputOff(self) -> None: ...
    def DeepCopyInputOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetAllowNullInput(self) -> bool: ...
    def GetDeepCopyInput(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPassThrough': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPassThrough': ...
    def SetAllowNullInput(self, _arg:bool) -> None: ...
    def SetDeepCopyInput(self, _arg:int) -> None: ...

class vtkPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def BuildHierarchyOff(self) -> None: ...
    def BuildHierarchyOn(self) -> None: ...
    def BuildTreeOff(self) -> None: ...
    def BuildTreeOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GeneratePolygonsOff(self) -> None: ...
    def GeneratePolygonsOn(self) -> None: ...
    def GetBuildHierarchy(self) -> bool: ...
    def GetBuildTree(self) -> bool: ...
    def GetComputeNormals(self) -> bool: ...
    def GetGeneratePolygons(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaneCutter': ...
    def SetBuildHierarchy(self, _arg:bool) -> None: ...
    def SetBuildTree(self, _arg:bool) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetGeneratePolygons(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPointDataToCellData(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def AddPointDataArray(self, name:str) -> None: ...
    def CategoricalDataOff(self) -> None: ...
    def CategoricalDataOn(self) -> None: ...
    def ClearPointDataArrays(self) -> None: ...
    def GetCategoricalData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPointData(self) -> bool: ...
    def GetProcessAllArrays(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointDataToCellData': ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    def ProcessAllArraysOff(self) -> None: ...
    def ProcessAllArraysOn(self) -> None: ...
    def RemovePointDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointDataToCellData': ...
    def SetCategoricalData(self, _arg:bool) -> None: ...
    def SetPassPointData(self, _arg:bool) -> None: ...
    def SetProcessAllArrays(self, _arg:bool) -> None: ...

class vtkPolyDataConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def FullScalarConnectivityOff(self) -> None: ...
    def FullScalarConnectivityOn(self) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetFullScalarConnectivity(self) -> int: ...
    def GetMarkVisitedPointIds(self) -> int: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionSizes(self) -> 'vtkIdTypeArray': ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetVisitedPointIds(self) -> 'vtkIdList': ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkVisitedPointIdsOff(self) -> None: ...
    def MarkVisitedPointIdsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPolyDataConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetFullScalarConnectivity(self, _arg:int) -> None: ...
    def SetMarkVisitedPointIds(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkPolyDataEdgeConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class RegionGrowingType(int): ...
    LargeRegions:'RegionGrowingType'
    RegionGrowingOff:'RegionGrowingType'
    SmallRegions:'RegionGrowingType'
    def AddSeed(self, id:int) -> None: ...
    def AddSpecifiedRegion(self, id:int) -> None: ...
    def BarrierEdgesOff(self) -> None: ...
    def BarrierEdgesOn(self) -> None: ...
    def CellRegionAreasOff(self) -> None: ...
    def CellRegionAreasOn(self) -> None: ...
    def ColorRegionsOff(self) -> None: ...
    def ColorRegionsOn(self) -> None: ...
    def DeleteSeed(self, id:int) -> None: ...
    def DeleteSpecifiedRegion(self, id:int) -> None: ...
    def GetBarrierEdgeLength(self) -> Tuple[float, float]: ...
    def GetBarrierEdges(self) -> int: ...
    def GetCellRegionAreas(self) -> int: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetColorRegions(self) -> int: ...
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetExtractionModeMaxValue(self) -> int: ...
    def GetExtractionModeMinValue(self) -> int: ...
    def GetLargeRegionThreshold(self) -> float: ...
    def GetLargeRegionThresholdMaxValue(self) -> float: ...
    def GetLargeRegionThresholdMinValue(self) -> float: ...
    def GetNumberOfExtractedRegions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSpecifiedRegions(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRegionGrowing(self) -> int: ...
    def GetRegionGrowingMaxValue(self) -> int: ...
    def GetRegionGrowingMinValue(self) -> int: ...
    def GetRegionSizes(self) -> 'vtkIdTypeArray': ...
    def GetScalarConnectivity(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetTotalArea(self) -> float: ...
    def GrowLargeRegionsOff(self) -> None: ...
    def GrowLargeRegionsOn(self) -> None: ...
    def GrowSmallRegionsOff(self) -> None: ...
    def GrowSmallRegionsOn(self) -> None: ...
    def InitializeSeedList(self) -> None: ...
    def InitializeSpecifiedRegionList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataEdgeConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataEdgeConnectivityFilter': ...
    def ScalarConnectivityOff(self) -> None: ...
    def ScalarConnectivityOn(self) -> None: ...
    @overload
    def SetBarrierEdgeLength(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetBarrierEdgeLength(self, _arg:Sequence[float]) -> None: ...
    def SetBarrierEdges(self, _arg:int) -> None: ...
    def SetCellRegionAreas(self, _arg:int) -> None: ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetColorRegions(self, _arg:int) -> None: ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToAllRegions(self) -> None: ...
    def SetExtractionModeToCellSeededRegions(self) -> None: ...
    def SetExtractionModeToClosestPointRegion(self) -> None: ...
    def SetExtractionModeToLargeRegions(self) -> None: ...
    def SetExtractionModeToLargestRegion(self) -> None: ...
    def SetExtractionModeToPointSeededRegions(self) -> None: ...
    def SetExtractionModeToSpecifiedRegions(self) -> None: ...
    def SetLargeRegionThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRegionGrowing(self, _arg:int) -> None: ...
    def SetRegionGrowingOff(self) -> None: ...
    def SetRegionGrowingToLargeRegions(self) -> None: ...
    def SetRegionGrowingToSmallRegions(self) -> None: ...
    def SetScalarConnectivity(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, __a:'vtkPolyData') -> None: ...

class vtkPolyDataNormals(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AutoOrientNormalsOff(self) -> None: ...
    def AutoOrientNormalsOn(self) -> None: ...
    def ComputeCellNormalsOff(self) -> None: ...
    def ComputeCellNormalsOn(self) -> None: ...
    def ComputePointNormalsOff(self) -> None: ...
    def ComputePointNormalsOn(self) -> None: ...
    def ConsistencyOff(self) -> None: ...
    def ConsistencyOn(self) -> None: ...
    def FlipNormalsOff(self) -> None: ...
    def FlipNormalsOn(self) -> None: ...
    def GetAutoOrientNormals(self) -> int: ...
    def GetComputeCellNormals(self) -> int: ...
    def GetComputePointNormals(self) -> int: ...
    def GetConsistency(self) -> int: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFlipNormals(self) -> int: ...
    def GetNonManifoldTraversal(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetSplitting(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataNormals': ...
    def NonManifoldTraversalOff(self) -> None: ...
    def NonManifoldTraversalOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataNormals': ...
    def SetAutoOrientNormals(self, _arg:int) -> None: ...
    def SetComputeCellNormals(self, _arg:int) -> None: ...
    def SetComputePointNormals(self, _arg:int) -> None: ...
    def SetConsistency(self, _arg:int) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFlipNormals(self, _arg:int) -> None: ...
    def SetNonManifoldTraversal(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSplitting(self, _arg:int) -> None: ...
    def SplittingOff(self) -> None: ...
    def SplittingOn(self) -> None: ...

class vtkPolyDataPlaneClipper(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def ClippingLoopsOff(self) -> None: ...
    def ClippingLoopsOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetCap(self) -> 'vtkPolyData': ...
    def GetCapping(self) -> bool: ...
    def GetClippingLoops(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassCapPointData(self) -> bool: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPlaneClipper': ...
    def PassCapPointDataOff(self) -> None: ...
    def PassCapPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPlaneClipper': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetCapping(self, _arg:bool) -> None: ...
    def SetClippingLoops(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPassCapPointData(self, _arg:bool) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPolyDataPlaneCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    @staticmethod
    def CanFullyProcessDataObject(object:'vtkDataObject') -> bool: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetComputeNormals(self) -> bool: ...
    def GetInterpolateAttributes(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPlane(self) -> 'vtkPlane': ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPlaneCutter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPlaneCutter': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:bool) -> None: ...
    def SetInterpolateAttributes(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPlane(self, __a:'vtkPlane') -> None: ...

class vtkPolyDataTangents(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeCellTangentsOff(self) -> None: ...
    def ComputeCellTangentsOn(self) -> None: ...
    def ComputePointTangentsOff(self) -> None: ...
    def ComputePointTangentsOn(self) -> None: ...
    def GetComputeCellTangents(self) -> bool: ...
    def GetComputePointTangents(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataTangents': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataTangents': ...
    def SetComputeCellTangents(self, _arg:bool) -> None: ...
    def SetComputePointTangents(self, _arg:bool) -> None: ...

class vtkQuadricClustering(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def Append(self, piece:'vtkPolyData') -> None: ...
    def AutoAdjustNumberOfDivisionsOff(self) -> None: ...
    def AutoAdjustNumberOfDivisionsOn(self) -> None: ...
    def CopyCellDataOff(self) -> None: ...
    def CopyCellDataOn(self) -> None: ...
    def EndAppend(self) -> None: ...
    def GetAutoAdjustNumberOfDivisions(self) -> int: ...
    def GetCopyCellData(self) -> int: ...
    def GetDivisionOrigin(self) -> Tuple[float, float, float]: ...
    def GetDivisionSpacing(self) -> Tuple[float, float, float]: ...
    def GetFeatureEdges(self) -> 'vtkFeatureEdges': ...
    def GetFeaturePointsAngle(self) -> float: ...
    def GetFeaturePointsAngleMaxValue(self) -> float: ...
    def GetFeaturePointsAngleMinValue(self) -> float: ...
    @overload
    def GetNumberOfDivisions(self) -> Tuple[int, int, int]: ...
    @overload
    def GetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXDivisions(self) -> int: ...
    def GetNumberOfYDivisions(self) -> int: ...
    def GetNumberOfZDivisions(self) -> int: ...
    def GetPreventDuplicateCells(self) -> int: ...
    def GetUseFeatureEdges(self) -> int: ...
    def GetUseFeaturePoints(self) -> int: ...
    def GetUseInputPoints(self) -> int: ...
    def GetUseInternalTriangles(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadricClustering': ...
    def PreventDuplicateCellsOff(self) -> None: ...
    def PreventDuplicateCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadricClustering': ...
    def SetAutoAdjustNumberOfDivisions(self, _arg:int) -> None: ...
    def SetCopyCellData(self, _arg:int) -> None: ...
    @overload
    def SetDivisionOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionOrigin(self, o:MutableSequence[float]) -> None: ...
    @overload
    def SetDivisionSpacing(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDivisionSpacing(self, s:MutableSequence[float]) -> None: ...
    def SetFeaturePointsAngle(self, _arg:float) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div:MutableSequence[int]) -> None: ...
    @overload
    def SetNumberOfDivisions(self, div0:int, div1:int, div2:int) -> None: ...
    def SetNumberOfXDivisions(self, num:int) -> None: ...
    def SetNumberOfYDivisions(self, num:int) -> None: ...
    def SetNumberOfZDivisions(self, num:int) -> None: ...
    def SetPreventDuplicateCells(self, _arg:int) -> None: ...
    def SetUseFeatureEdges(self, _arg:int) -> None: ...
    def SetUseFeaturePoints(self, _arg:int) -> None: ...
    def SetUseInputPoints(self, _arg:int) -> None: ...
    def SetUseInternalTriangles(self, _arg:int) -> None: ...
    @overload
    def StartAppend(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def StartAppend(self, x0:float, x1:float, y0:float, y1:float, z0:float, z1:float) -> None: ...
    def UseFeatureEdgesOff(self) -> None: ...
    def UseFeatureEdgesOn(self) -> None: ...
    def UseFeaturePointsOff(self) -> None: ...
    def UseFeaturePointsOn(self) -> None: ...
    def UseInputPointsOff(self) -> None: ...
    def UseInputPointsOn(self) -> None: ...
    def UseInternalTrianglesOff(self) -> None: ...
    def UseInternalTrianglesOn(self) -> None: ...

class vtkQuadricDecimation(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AttributeErrorMetricOff(self) -> None: ...
    def AttributeErrorMetricOn(self) -> None: ...
    def GetActualReduction(self) -> float: ...
    def GetAttributeErrorMetric(self) -> int: ...
    def GetNormalsAttribute(self) -> int: ...
    def GetNormalsWeight(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarsAttribute(self) -> int: ...
    def GetScalarsWeight(self) -> float: ...
    def GetTCoordsAttribute(self) -> int: ...
    def GetTCoordsWeight(self) -> float: ...
    def GetTargetReduction(self) -> float: ...
    def GetTargetReductionMaxValue(self) -> float: ...
    def GetTargetReductionMinValue(self) -> float: ...
    def GetTensorsAttribute(self) -> int: ...
    def GetTensorsWeight(self) -> float: ...
    def GetVectorsAttribute(self) -> int: ...
    def GetVectorsWeight(self) -> float: ...
    def GetVolumePreservation(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadricDecimation': ...
    def NormalsAttributeOff(self) -> None: ...
    def NormalsAttributeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadricDecimation': ...
    def ScalarsAttributeOff(self) -> None: ...
    def ScalarsAttributeOn(self) -> None: ...
    def SetAttributeErrorMetric(self, _arg:int) -> None: ...
    def SetNormalsAttribute(self, _arg:int) -> None: ...
    def SetNormalsWeight(self, _arg:float) -> None: ...
    def SetScalarsAttribute(self, _arg:int) -> None: ...
    def SetScalarsWeight(self, _arg:float) -> None: ...
    def SetTCoordsAttribute(self, _arg:int) -> None: ...
    def SetTCoordsWeight(self, _arg:float) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...
    def SetTensorsAttribute(self, _arg:int) -> None: ...
    def SetTensorsWeight(self, _arg:float) -> None: ...
    def SetVectorsAttribute(self, _arg:int) -> None: ...
    def SetVectorsWeight(self, _arg:float) -> None: ...
    def SetVolumePreservation(self, _arg:int) -> None: ...
    def TCoordsAttributeOff(self) -> None: ...
    def TCoordsAttributeOn(self) -> None: ...
    def TensorsAttributeOff(self) -> None: ...
    def TensorsAttributeOn(self) -> None: ...
    def VectorsAttributeOff(self) -> None: ...
    def VectorsAttributeOn(self) -> None: ...
    def VolumePreservationOff(self) -> None: ...
    def VolumePreservationOn(self) -> None: ...

class vtkRearrangeFields(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldType(int): ...
    class FieldLocation(int): ...
    class OperationType(int): ...
    ATTRIBUTE:'FieldType'
    CELL_DATA:'FieldLocation'
    COPY:'OperationType'
    DATA_OBJECT:'FieldLocation'
    MOVE:'OperationType'
    NAME:'FieldType'
    POINT_DATA:'FieldLocation'
    @overload
    def AddOperation(self, operationType:int, attributeType:int, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def AddOperation(self, operationType:int, name:str, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def AddOperation(self, operationType:str, attributeType:str, fromFieldLoc:str, toFieldLoc:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRearrangeFields': ...
    def RemoveAllOperations(self) -> None: ...
    @overload
    def RemoveOperation(self, operationId:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:int, attributeType:int, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:int, name:str, fromFieldLoc:int, toFieldLoc:int) -> int: ...
    @overload
    def RemoveOperation(self, operationType:str, attributeType:str, fromFieldLoc:str, toFieldLoc:str) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRearrangeFields': ...

class vtkRectilinearSynchronizedTemplates(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def ComputeSpacing(self, data:'vtkRectilinearGrid', i:int, j:int, k:int, extent:MutableSequence[int], spacing:MutableSequence[float]) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearSynchronizedTemplates': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearSynchronizedTemplates': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkRemoveDuplicatePolys(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveDuplicatePolys': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveDuplicatePolys': ...

class vtkRemoveUnusedPoints(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GenerateOriginalPointIdsOff(self) -> None: ...
    def GenerateOriginalPointIdsOn(self) -> None: ...
    def GetGenerateOriginalPointIds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalPointIdsArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveUnusedPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveUnusedPoints': ...
    def SetGenerateOriginalPointIds(self, _arg:bool) -> None: ...
    def SetOriginalPointIdsArrayName(self, _arg:str) -> None: ...

class vtkResampleToImage(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def GetMaskArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def GetSamplingBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetSamplingDimensions(self) -> Tuple[int, int, int]: ...
    def GetUseInputBounds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResampleToImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResampleToImage': ...
    @overload
    def SetSamplingBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetSamplingBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg:Sequence[int]) -> None: ...
    def SetUseInputBounds(self, _arg:bool) -> None: ...
    def UseInputBoundsOff(self) -> None: ...
    def UseInputBoundsOn(self) -> None: ...

class vtkResampleWithDataSet(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    def GetCategoricalData(self) -> bool: ...
    def GetCellLocatorPrototype(self) -> 'vtkAbstractCellLocator': ...
    def GetComputeTolerance(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMarkBlankPointsAndCells(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> bool: ...
    def GetPassFieldArrays(self) -> bool: ...
    def GetPassPartialArrays(self) -> bool: ...
    def GetPassPointArrays(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkBlankPointsAndCellsOff(self) -> None: ...
    def MarkBlankPointsAndCellsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkResampleWithDataSet': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPartialArraysOff(self) -> None: ...
    def PassPartialArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResampleWithDataSet': ...
    def SetCategoricalData(self, arg:bool) -> None: ...
    def SetCellLocatorPrototype(self, __a:'vtkAbstractCellLocator') -> None: ...
    def SetComputeTolerance(self, arg:bool) -> None: ...
    def SetMarkBlankPointsAndCells(self, _arg:bool) -> None: ...
    def SetPassCellArrays(self, arg:bool) -> None: ...
    def SetPassFieldArrays(self, arg:bool) -> None: ...
    def SetPassPartialArrays(self, arg:bool) -> None: ...
    def SetPassPointArrays(self, arg:bool) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetTolerance(self, arg:float) -> None: ...

class vtkReverseSense(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverseCells(self) -> int: ...
    def GetReverseNormals(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReverseSense': ...
    def ReverseCellsOff(self) -> None: ...
    def ReverseCellsOn(self) -> None: ...
    def ReverseNormalsOff(self) -> None: ...
    def ReverseNormalsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReverseSense': ...
    def SetReverseCells(self, _arg:int) -> None: ...
    def SetReverseNormals(self, _arg:int) -> None: ...

class vtkSimpleElevationFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleElevationFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleElevationFilter': ...
    @overload
    def SetVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVector(self, _arg:Sequence[float]) -> None: ...

class vtkSmoothPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def BoundarySmoothingOff(self) -> None: ...
    def BoundarySmoothingOn(self) -> None: ...
    def FeatureEdgeSmoothingOff(self) -> None: ...
    def FeatureEdgeSmoothingOn(self) -> None: ...
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetBoundarySmoothing(self) -> int: ...
    def GetConvergence(self) -> float: ...
    def GetConvergenceMaxValue(self) -> float: ...
    def GetConvergenceMinValue(self) -> float: ...
    def GetEdgeAngle(self) -> float: ...
    def GetEdgeAngleMaxValue(self) -> float: ...
    def GetEdgeAngleMinValue(self) -> float: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdgeSmoothing(self) -> int: ...
    def GetGenerateErrorScalars(self) -> int: ...
    def GetGenerateErrorVectors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSmoothPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSmoothPolyDataFilter': ...
    def SetBoundarySmoothing(self, _arg:int) -> None: ...
    def SetConvergence(self, _arg:float) -> None: ...
    def SetEdgeAngle(self, _arg:float) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdgeSmoothing(self, _arg:int) -> None: ...
    def SetGenerateErrorScalars(self, _arg:int) -> None: ...
    def SetGenerateErrorVectors(self, _arg:int) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRelaxationFactor(self, _arg:float) -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...

class vtkSphereTreeFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetExtractionMode(self) -> int: ...
    def GetExtractionModeAsString(self) -> str: ...
    def GetLevel(self) -> int: ...
    def GetLevelMaxValue(self) -> int: ...
    def GetLevelMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint(self) -> Tuple[float, float, float]: ...
    def GetRay(self) -> Tuple[float, float, float]: ...
    def GetSphereTree(self) -> 'vtkSphereTree': ...
    def GetTreeHierarchy(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereTreeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereTreeFilter': ...
    def SetExtractionMode(self, _arg:int) -> None: ...
    def SetExtractionModeToLevels(self) -> None: ...
    def SetExtractionModeToLine(self) -> None: ...
    def SetExtractionModeToPlane(self) -> None: ...
    def SetExtractionModeToPoint(self) -> None: ...
    def SetLevel(self, _arg:int) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetRay(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRay(self, _arg:Sequence[float]) -> None: ...
    def SetSphereTree(self, __a:'vtkSphereTree') -> None: ...
    def SetTreeHierarchy(self, _arg:bool) -> None: ...
    def TreeHierarchyOff(self) -> None: ...
    def TreeHierarchyOn(self) -> None: ...

class vtkStaticCleanPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def AveragePointDataOff(self) -> None: ...
    def AveragePointDataOn(self) -> None: ...
    def ConvertLinesToPointsOff(self) -> None: ...
    def ConvertLinesToPointsOn(self) -> None: ...
    def ConvertPolysToLinesOff(self) -> None: ...
    def ConvertPolysToLinesOn(self) -> None: ...
    def ConvertStripsToPolysOff(self) -> None: ...
    def ConvertStripsToPolysOn(self) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetAveragePointData(self) -> bool: ...
    def GetConvertLinesToPoints(self) -> bool: ...
    def GetConvertPolysToLines(self) -> bool: ...
    def GetConvertStripsToPolys(self) -> bool: ...
    def GetLocator(self) -> 'vtkStaticPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergingArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> bool: ...
    def GetProduceMergeMap(self) -> bool: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStaticCleanPolyData': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def ProduceMergeMapOff(self) -> None: ...
    def ProduceMergeMapOn(self) -> None: ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCleanPolyData': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetAveragePointData(self, _arg:bool) -> None: ...
    def SetConvertLinesToPoints(self, _arg:bool) -> None: ...
    def SetConvertPolysToLines(self, _arg:bool) -> None: ...
    def SetConvertStripsToPolys(self, _arg:bool) -> None: ...
    def SetMergingArray(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:bool) -> None: ...
    def SetProduceMergeMap(self, _arg:bool) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkStaticCleanUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def AveragePointDataOff(self) -> None: ...
    def AveragePointDataOn(self) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetAveragePointData(self) -> bool: ...
    def GetLocator(self) -> 'vtkStaticPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergingArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPieceInvariant(self) -> bool: ...
    def GetProduceMergeMap(self) -> bool: ...
    def GetRemoveUnusedPoints(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStaticCleanUnstructuredGrid': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    def ProduceMergeMapOff(self) -> None: ...
    def ProduceMergeMapOn(self) -> None: ...
    def RemoveUnusedPointsOff(self) -> None: ...
    def RemoveUnusedPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStaticCleanUnstructuredGrid': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetAveragePointData(self, _arg:bool) -> None: ...
    def SetMergingArray(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:bool) -> None: ...
    def SetProduceMergeMap(self, _arg:bool) -> None: ...
    def SetRemoveUnusedPoints(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkStreamerBase(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamerBase': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamerBase': ...

class vtkStreamingTessellator(vtkmodules.vtkCommonCore.vtkObject):
    MaxFieldSize:int
    def AdaptivelySample0Facet(self, v0:MutableSequence[float]) -> None: ...
    def AdaptivelySample1Facet(self, v0:MutableSequence[float], v1:MutableSequence[float]) -> None: ...
    def AdaptivelySample1FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float]) -> None: ...
    def AdaptivelySample2Facet(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float]) -> None: ...
    def AdaptivelySample2FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float]) -> None: ...
    def AdaptivelySample3Facet(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float], v3:MutableSequence[float]) -> None: ...
    def AdaptivelySample3FacetLinear(self, v0:MutableSequence[float], v1:MutableSequence[float], v2:MutableSequence[float], v3:MutableSequence[float]) -> None: ...
    def GetCaseCount(self, c:int) -> int: ...
    def GetConstPrivateData(self) -> Pointer: ...
    def GetEmbeddingDimension(self, k:int) -> int: ...
    def GetFieldSize(self, k:int) -> int: ...
    def GetMaximumNumberOfSubdivisions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrivateData(self) -> Pointer: ...
    def GetSubcaseCount(self, casenum:int, sub:int) -> int: ...
    def GetSubdivisionAlgorithm(self) -> 'vtkEdgeSubdivisionCriterion': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamingTessellator': ...
    def ResetCounts(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamingTessellator': ...
    def SetConstPrivateData(self, ConstPrivate:Pointer) -> None: ...
    def SetEmbeddingDimension(self, k:int, d:int) -> None: ...
    def SetFieldSize(self, k:int, s:int) -> None: ...
    def SetMaximumNumberOfSubdivisions(self, num_subdiv_in:int) -> None: ...
    def SetPrivateData(self, Private:Pointer) -> None: ...
    def SetSubdivisionAlgorithm(self, __a:'vtkEdgeSubdivisionCriterion') -> None: ...

class vtkStripper(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetJoinContiguousSegments(self) -> int: ...
    def GetMaximumLength(self) -> int: ...
    def GetMaximumLengthMaxValue(self) -> int: ...
    def GetMaximumLengthMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellDataAsFieldData(self) -> int: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def JoinContiguousSegmentsOff(self) -> None: ...
    def JoinContiguousSegmentsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkStripper': ...
    def PassCellDataAsFieldDataOff(self) -> None: ...
    def PassCellDataAsFieldDataOn(self) -> None: ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStripper': ...
    def SetJoinContiguousSegments(self, _arg:int) -> None: ...
    def SetMaximumLength(self, _arg:int) -> None: ...
    def SetPassCellDataAsFieldData(self, _arg:int) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...

class vtkStructuredGridAppend(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    @overload
    def GetInput(self, num:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridAppend': ...
    def ReplaceNthInputConnection(self, idx:int, input:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridAppend': ...
    @overload
    def SetInputData(self, num:int, input:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, input:'vtkDataObject') -> None: ...

class vtkStructuredGridOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridOutlineFilter': ...

class vtkSurfaceNets2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def DataCachingOff(self) -> None: ...
    def DataCachingOn(self) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateLabels(self, numLabels:int, rangeStart:float, rangeEnd:float) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetBackgroundLabel(self) -> float: ...
    def GetComputeScalars(self) -> bool: ...
    def GetDataCaching(self) -> bool: ...
    def GetLabel(self, i:int) -> float: ...
    @overload
    def GetLabels(self) -> Pointer: ...
    @overload
    def GetLabels(self, contourValues:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetSmoother(self) -> 'vtkConstrainedSmoothingFilter': ...
    def GetSmoothing(self) -> bool: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSurfaceNets2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSurfaceNets2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetBackgroundLabel(self, _arg:float) -> None: ...
    def SetComputeScalars(self, _arg:bool) -> None: ...
    def SetDataCaching(self, _arg:bool) -> None: ...
    def SetLabel(self, i:int, value:float) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetNumberOfLabels(self, number:int) -> None: ...
    def SetSmoothing(self, _arg:bool) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def SmoothingOff(self) -> None: ...
    def SmoothingOn(self) -> None: ...

class vtkSynchronizedTemplates2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplates2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplates2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkSynchronizedTemplates3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetGenerateTriangles(self) -> int: ...
    def GetInputMemoryLimit(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplates3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplates3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetGenerateTriangles(self, _arg:int) -> None: ...
    def SetInputMemoryLimit(self, limit:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def ThreadedExecute(self, data:'vtkImageData', inInfo:'vtkInformation', outInfo:'vtkInformation', inScalars:'vtkDataArray') -> None: ...

class vtkSynchronizedTemplatesCutter3D(vtkSynchronizedTemplates3D):
    def GetCutFunction(self) -> 'vtkImplicitFunction': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizedTemplatesCutter3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizedTemplatesCutter3D': ...
    def SetCutFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def ThreadedExecute(self, data:'vtkImageData', outInfo:'vtkInformation', __c:int) -> None: ...

class vtkTensorGlyph(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    COLOR_BY_EIGENVALUES:int
    COLOR_BY_SCALARS:int
    def ClampScalingOff(self) -> None: ...
    def ClampScalingOn(self) -> None: ...
    def ColorGlyphsOff(self) -> None: ...
    def ColorGlyphsOn(self) -> None: ...
    def ExtractEigenvaluesOff(self) -> None: ...
    def ExtractEigenvaluesOn(self) -> None: ...
    def GetClampScaling(self) -> int: ...
    def GetColorGlyphs(self) -> int: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeMaxValue(self) -> int: ...
    def GetColorModeMinValue(self) -> int: ...
    def GetExtractEigenvalues(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMaxScaleFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaling(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def GetSymmetric(self) -> int: ...
    def GetThreeGlyphs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTensorGlyph': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorGlyph': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetClampScaling(self, _arg:int) -> None: ...
    def SetColorGlyphs(self, _arg:int) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToEigenvalues(self) -> None: ...
    def SetColorModeToScalars(self) -> None: ...
    def SetExtractEigenvalues(self, _arg:int) -> None: ...
    def SetLength(self, _arg:float) -> None: ...
    def SetMaxScaleFactor(self, _arg:float) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaling(self, _arg:int) -> None: ...
    @overload
    def SetSourceConnection(self, id:int, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...
    def SetSymmetric(self, _arg:int) -> None: ...
    def SetThreeGlyphs(self, _arg:int) -> None: ...
    def SymmetricOff(self) -> None: ...
    def SymmetricOn(self) -> None: ...
    def ThreeGlyphsOff(self) -> None: ...
    def ThreeGlyphsOn(self) -> None: ...

class vtkThreshold(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class ThresholdType(int): ...
    THRESHOLD_BETWEEN:'ThresholdType'
    THRESHOLD_LOWER:'ThresholdType'
    THRESHOLD_UPPER:'ThresholdType'
    def AllScalarsOff(self) -> None: ...
    def AllScalarsOn(self) -> None: ...
    def Between(self, s:float) -> int: ...
    def GetAllScalars(self) -> int: ...
    def GetAttributeMode(self) -> int: ...
    def GetAttributeModeAsString(self) -> str: ...
    def GetComponentMode(self) -> int: ...
    def GetComponentModeAsString(self) -> str: ...
    def GetComponentModeMaxValue(self) -> int: ...
    def GetComponentModeMinValue(self) -> int: ...
    def GetInvert(self) -> bool: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPointsDataType(self) -> int: ...
    def GetSelectedComponent(self) -> int: ...
    def GetSelectedComponentMaxValue(self) -> int: ...
    def GetSelectedComponentMinValue(self) -> int: ...
    def GetThresholdFunction(self) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def GetUseContinuousCellRange(self) -> int: ...
    def InvertOff(self) -> None: ...
    def InvertOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Lower(self, s:float) -> int: ...
    def NewInstance(self) -> 'vtkThreshold': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThreshold': ...
    def SetAllScalars(self, _arg:int) -> None: ...
    def SetAttributeMode(self, _arg:int) -> None: ...
    def SetAttributeModeToDefault(self) -> None: ...
    def SetAttributeModeToUseCellData(self) -> None: ...
    def SetAttributeModeToUsePointData(self) -> None: ...
    def SetComponentMode(self, _arg:int) -> None: ...
    def SetComponentModeToUseAll(self) -> None: ...
    def SetComponentModeToUseAny(self) -> None: ...
    def SetComponentModeToUseSelected(self) -> None: ...
    def SetInvert(self, _arg:bool) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetPointsDataType(self, type:int) -> None: ...
    def SetPointsDataTypeToDouble(self) -> None: ...
    def SetPointsDataTypeToFloat(self) -> None: ...
    def SetSelectedComponent(self, _arg:int) -> None: ...
    def SetThresholdFunction(self, function:int) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def SetUseContinuousCellRange(self, _arg:int) -> None: ...
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...
    def ThresholdByLower(self, lower:float) -> None: ...
    def ThresholdByUpper(self, upper:float) -> None: ...
    def Upper(self, s:float) -> int: ...
    def UseContinuousCellRangeOff(self) -> None: ...
    def UseContinuousCellRangeOn(self) -> None: ...

class vtkThresholdPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetInputArrayComponent(self) -> int: ...
    def GetLowerThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetUpperThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkThresholdPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThresholdPoints': ...
    def SetInputArrayComponent(self, _arg:int) -> None: ...
    def SetLowerThreshold(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetUpperThreshold(self, _arg:float) -> None: ...
    def ThresholdBetween(self, lower:float, upper:float) -> None: ...
    def ThresholdByLower(self, lower:float) -> None: ...
    def ThresholdByUpper(self, upper:float) -> None: ...

class vtkTransposeTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def AddIdColumnOff(self) -> None: ...
    def AddIdColumnOn(self) -> None: ...
    def GetAddIdColumn(self) -> bool: ...
    def GetIdColumnName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseIdColumn(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransposeTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransposeTable': ...
    def SetAddIdColumn(self, _arg:bool) -> None: ...
    def SetIdColumnName(self, _arg:str) -> None: ...
    def SetUseIdColumn(self, _arg:bool) -> None: ...
    def UseIdColumnOff(self) -> None: ...
    def UseIdColumnOn(self) -> None: ...

class vtkTriangleFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassLines(self) -> int: ...
    def GetPassVerts(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangleFilter': ...
    def PassLinesOff(self) -> None: ...
    def PassLinesOn(self) -> None: ...
    def PassVertsOff(self) -> None: ...
    def PassVertsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangleFilter': ...
    def SetPassLines(self, _arg:int) -> None: ...
    def SetPassVerts(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkTriangleMeshPointNormals(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTriangleMeshPointNormals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTriangleMeshPointNormals': ...

class vtkTubeBender(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTubeBender': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTubeBender': ...
    def SetRadius(self, _arg:float) -> None: ...

class vtkTubeFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetCapping(self) -> int: ...
    def GetDefaultNormal(self) -> Tuple[float, float, float]: ...
    def GetGenerateTCoords(self) -> int: ...
    def GetGenerateTCoordsAsString(self) -> str: ...
    def GetGenerateTCoordsMaxValue(self) -> int: ...
    def GetGenerateTCoordsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSides(self) -> int: ...
    def GetNumberOfSidesMaxValue(self) -> int: ...
    def GetNumberOfSidesMinValue(self) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusFactor(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetSidesShareVertices(self) -> int: ...
    def GetTextureLength(self) -> float: ...
    def GetTextureLengthMaxValue(self) -> float: ...
    def GetTextureLengthMinValue(self) -> float: ...
    def GetUseDefaultNormal(self) -> int: ...
    def GetVaryRadius(self) -> int: ...
    def GetVaryRadiusAsString(self) -> str: ...
    def GetVaryRadiusMaxValue(self) -> int: ...
    def GetVaryRadiusMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTubeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTubeFilter': ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg:Sequence[float]) -> None: ...
    def SetGenerateTCoords(self, _arg:int) -> None: ...
    def SetGenerateTCoordsToNormalizedLength(self) -> None: ...
    def SetGenerateTCoordsToOff(self) -> None: ...
    def SetGenerateTCoordsToUseLength(self) -> None: ...
    def SetGenerateTCoordsToUseScalars(self) -> None: ...
    def SetNumberOfSides(self, _arg:int) -> None: ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetRadiusFactor(self, _arg:float) -> None: ...
    def SetSidesShareVertices(self, _arg:int) -> None: ...
    def SetTextureLength(self, _arg:float) -> None: ...
    def SetUseDefaultNormal(self, _arg:int) -> None: ...
    def SetVaryRadius(self, _arg:int) -> None: ...
    def SetVaryRadiusToVaryRadiusByAbsoluteScalar(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByScalar(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByVector(self) -> None: ...
    def SetVaryRadiusToVaryRadiusByVectorNorm(self) -> None: ...
    def SetVaryRadiusToVaryRadiusOff(self) -> None: ...
    def SidesShareVerticesOff(self) -> None: ...
    def SidesShareVerticesOn(self) -> None: ...
    def UseDefaultNormalOff(self) -> None: ...
    def UseDefaultNormalOn(self) -> None: ...

class vtkUnstructuredGridQuadricDecimation(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    NON_ERROR:int
    NON_TETRAHEDRA:int
    NO_CELLS:int
    NO_SCALARS:int
    def GetAutoAddCandidates(self) -> int: ...
    def GetAutoAddCandidatesThreshold(self) -> float: ...
    def GetBoundaryWeight(self) -> float: ...
    def GetNumberOfCandidates(self) -> int: ...
    def GetNumberOfEdgesToDecimate(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTetsOutput(self) -> int: ...
    def GetScalarsName(self) -> str: ...
    def GetTargetReduction(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridQuadricDecimation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridQuadricDecimation': ...
    def SetAutoAddCandidates(self, _arg:int) -> None: ...
    def SetAutoAddCandidatesThreshold(self, _arg:float) -> None: ...
    def SetBoundaryWeight(self, _arg:float) -> None: ...
    def SetNumberOfCandidates(self, _arg:int) -> None: ...
    def SetNumberOfEdgesToDecimate(self, _arg:int) -> None: ...
    def SetNumberOfTetsOutput(self, _arg:int) -> None: ...
    def SetScalarsName(self, _arg:str) -> None: ...
    def SetTargetReduction(self, _arg:float) -> None: ...

class vtkUnstructuredGridToExplicitStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkExplicitStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridToExplicitStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridToExplicitStructuredGrid': ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkVectorDot(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetActualRange(self) -> Tuple[float, float]: ...
    def GetMapScalars(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsOff(self) -> None: ...
    def MapScalarsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkVectorDot': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorDot': ...
    def SetMapScalars(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...

class vtkVectorNorm(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetAttributeMode(self) -> int: ...
    def GetAttributeModeAsString(self) -> str: ...
    def GetNormalize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVectorNorm': ...
    def NormalizeOff(self) -> None: ...
    def NormalizeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorNorm': ...
    def SetAttributeMode(self, _arg:int) -> None: ...
    def SetAttributeModeToDefault(self) -> None: ...
    def SetAttributeModeToUseCellData(self) -> None: ...
    def SetAttributeModeToUsePointData(self) -> None: ...
    def SetNormalize(self, _arg:int) -> None: ...

class vtkVoronoi2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class ProjectionPlaneStrategy(int): ...
    class GenerateScalarsStrategy(int): ...
    BEST_FITTING_PLANE:'ProjectionPlaneStrategy'
    NONE:'GenerateScalarsStrategy'
    POINT_IDS:'GenerateScalarsStrategy'
    SPECIFIED_TRANSFORM_PLANE:'ProjectionPlaneStrategy'
    THREAD_IDS:'GenerateScalarsStrategy'
    XY_PLANE:'ProjectionPlaneStrategy'
    def GenerateVoronoiFlowerOff(self) -> None: ...
    def GenerateVoronoiFlowerOn(self) -> None: ...
    def GetGenerateScalars(self) -> int: ...
    def GetGenerateVoronoiFlower(self) -> int: ...
    def GetLocator(self) -> 'vtkStaticPointLocator2D': ...
    def GetMTime(self) -> int: ...
    def GetMaximumNumberOfTileClips(self) -> int: ...
    def GetMaximumNumberOfTileClipsMaxValue(self) -> int: ...
    def GetMaximumNumberOfTileClipsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreadsUsed(self) -> int: ...
    def GetPadding(self) -> float: ...
    def GetPaddingMaxValue(self) -> float: ...
    def GetPaddingMinValue(self) -> float: ...
    def GetPointOfInterest(self) -> int: ...
    def GetPointOfInterestMaxValue(self) -> int: ...
    def GetPointOfInterestMinValue(self) -> int: ...
    def GetProjectionPlaneMode(self) -> int: ...
    def GetProjectionPlaneModeMaxValue(self) -> int: ...
    def GetProjectionPlaneModeMinValue(self) -> int: ...
    def GetSpheres(self) -> 'vtkSpheres': ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoronoi2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoronoi2D': ...
    def SetGenerateScalars(self, _arg:int) -> None: ...
    def SetGenerateScalarsToNone(self) -> None: ...
    def SetGenerateScalarsToPointIds(self) -> None: ...
    def SetGenerateScalarsToThreadIds(self) -> None: ...
    def SetGenerateVoronoiFlower(self, _arg:int) -> None: ...
    def SetMaximumNumberOfTileClips(self, _arg:int) -> None: ...
    def SetPadding(self, _arg:float) -> None: ...
    def SetPointOfInterest(self, _arg:int) -> None: ...
    def SetProjectionPlaneMode(self, _arg:int) -> None: ...
    def SetProjectionPlaneModeToBestFittingPlane(self) -> None: ...
    def SetProjectionPlaneModeToSpecifiedTransformPlane(self) -> None: ...
    def SetProjectionPlaneModeToXYPlane(self) -> None: ...
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...

class vtkWindowedSincPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def BoundarySmoothingOff(self) -> None: ...
    def BoundarySmoothingOn(self) -> None: ...
    def FeatureEdgeSmoothingOff(self) -> None: ...
    def FeatureEdgeSmoothingOn(self) -> None: ...
    def GenerateErrorScalarsOff(self) -> None: ...
    def GenerateErrorScalarsOn(self) -> None: ...
    def GenerateErrorVectorsOff(self) -> None: ...
    def GenerateErrorVectorsOn(self) -> None: ...
    def GetBoundarySmoothing(self) -> int: ...
    def GetEdgeAngle(self) -> float: ...
    def GetEdgeAngleMaxValue(self) -> float: ...
    def GetEdgeAngleMinValue(self) -> float: ...
    def GetFeatureAngle(self) -> float: ...
    def GetFeatureAngleMaxValue(self) -> float: ...
    def GetFeatureAngleMinValue(self) -> float: ...
    def GetFeatureEdgeSmoothing(self) -> int: ...
    def GetGenerateErrorScalars(self) -> int: ...
    def GetGenerateErrorVectors(self) -> int: ...
    def GetNonManifoldSmoothing(self) -> int: ...
    def GetNormalizeCoordinates(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetPassBand(self) -> float: ...
    def GetPassBandMaxValue(self) -> float: ...
    def GetPassBandMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWindowedSincPolyDataFilter': ...
    def NonManifoldSmoothingOff(self) -> None: ...
    def NonManifoldSmoothingOn(self) -> None: ...
    def NormalizeCoordinatesOff(self) -> None: ...
    def NormalizeCoordinatesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindowedSincPolyDataFilter': ...
    def SetBoundarySmoothing(self, _arg:int) -> None: ...
    def SetEdgeAngle(self, _arg:float) -> None: ...
    def SetFeatureAngle(self, _arg:float) -> None: ...
    def SetFeatureEdgeSmoothing(self, _arg:int) -> None: ...
    def SetGenerateErrorScalars(self, _arg:int) -> None: ...
    def SetGenerateErrorVectors(self, _arg:int) -> None: ...
    def SetNonManifoldSmoothing(self, _arg:int) -> None: ...
    def SetNormalizeCoordinates(self, _arg:int) -> None: ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetPassBand(self, _arg:float) -> None: ...

