from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingOpenGL2

class vtkOpenGLGL2PSHelperImpl(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLGL2PSHelper):
    def Draw3DPath(self, path:'vtkPath', actorMatrix:'vtkMatrix4x4', rasterPos:MutableSequence[float], actorColor:MutableSequence[int], ren:'vtkRenderer', label:str=...) -> None: ...
    def DrawImage(self, input:'vtkImageData', pos:MutableSequence[float]) -> None: ...
    def DrawPath(self, path:'vtkPath', rasterPos:MutableSequence[float], windowPos:MutableSequence[float], rgba:MutableSequence[int], scale:MutableSequence[float]=..., rotateAngle:float=0.0, strokeWidth:float=-1, label:str=...) -> None: ...
    def DrawString(self, str:str, tprop:'vtkTextProperty', pos:MutableSequence[float], backgroundDepth:float, ren:'vtkRenderer') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLGL2PSHelperImpl': ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', col:MutableSequence[int]) -> None: ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', col:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLGL2PSHelperImpl': ...

