from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore

class vtkGenericRenderWindowInteractor(vtkmodules.vtkRenderingCore.vtkRenderWindowInteractor):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTimerEventResetsTimer(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericRenderWindowInteractor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericRenderWindowInteractor': ...
    def SetTimerEventResetsTimer(self, _arg:int) -> None: ...
    def TimerEvent(self) -> None: ...
    def TimerEventResetsTimerOff(self) -> None: ...
    def TimerEventResetsTimerOn(self) -> None: ...

class vtkWin32HardwareWindow(vtkmodules.vtkRenderingCore.vtkHardwareWindow):
    def Create(self) -> None: ...
    def Destroy(self) -> None: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWin32HardwareWindow': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWin32HardwareWindow': ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    @overload
    def SetPosition(self, __a:int, __b:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    @overload
    def SetSize(self, __a:int, __b:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...

class vtkWin32RenderWindowInteractor(vtkmodules.vtkRenderingCore.vtkRenderWindowInteractor):
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def ExitCallback(self) -> None: ...
    def GetInstallMessageProc(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def InstallMessageProcOff(self) -> None: ...
    def InstallMessageProcOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWin32RenderWindowInteractor': ...
    def ProcessEvents(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWin32RenderWindowInteractor': ...
    @staticmethod
    def SetClassExitMethod(f:Callback) -> None: ...
    def SetInstallMessageProc(self, _arg:int) -> None: ...
    def TerminateApp(self) -> None: ...

