def create_webserver(server_config, backend="aiohttp"):
    if backend == "aiohttp":
        from .aiohttp import create_webserver

        return create_webserver(server_config)

    if backend == "generic":
        from .generic import create_webserver

        return create_webserver(server_config)

    if backend == "tornado":
        from .tornado import create_webserver

        return create_webserver(server_config)

    raise Exception(f"{backend} backend is not implemented")


def launcher_start(args, config, backend="aiohttp"):
    if backend == "aiohttp":
        from .aiohttp.launcher import startWebServer

        return startWebServer(args, config)

    if backend == "generic":
        from .generic import startWebServer

        return startWebServer(args, config)

    if backend == "tornado":
        from .tornado import startWebServer

        return startWebServer(args, config)

    raise Exception(f"{backend} backend is not implemented")
