/*
 * PROJECT:     ReactOS Task Manager
 * LICENSE:     LGPL-2.1-or-later (https://spdx.org/licenses/LGPL-2.1-or-later)
 * PURPOSE:     Resources header.
 * COPYRIGHT:   Copyright 1999-2001 Brian Palmer <brianp@reactos.org>
 */

#pragma once

#define IDS_IDLE_PROCESS              102
#define IDD_TASKMGR_DIALOG            102
#define IDS_APP_TITLE                 103
#define IDM_ABOUT                     104
#define IDM_EXIT                      105
#define IDD_APPLICATION_PAGE          106
#define IDI_TASKMGR                   107
#define IDI_SMALL                     108
#define IDC_TASKMGR                   109
#define IDR_MAINFRAME                 128
#define IDR_TASKMANAGER               130
#define IDD_PROCESS_PAGE              133
#define IDD_PERFORMANCE_PAGE          134
#define IDR_WINDOWSMENU               135
#define IDI_TASKMANAGER               136
#define IDI_WINDOW                    137
#define IDI_WINDOWSM                  138
#define IDR_APPLICATION_PAGE_CONTEXT1 139
#define IDR_APPLICATION_PAGE_CONTEXT2 140
#define IDR_TRAY_POPUP                141
#define IDD_AFFINITY_DIALOG           142
#define IDD_COLUMNS_DIALOG            143
#define IDR_PROCESS_PAGE_CONTEXT      144
#define IDB_TRAYMASK                  150
#define IDB_TRAYICON                  153

#define IDC_ENDTASK                      1012
#define IDC_SWITCHTO                     1013
#define IDC_NEWTASK                      1014
#define IDC_TAB                          1015
#define IDC_APPLIST                      1016
#define IDC_ENDPROCESS                   1017
#define IDC_PROCESSLIST                  1018
#define IDC_CPU0                         1019
#define IDC_CPU1                         1020
#define IDC_CPU2                         1021
#define IDC_SHOWALLPROCESSES             1021
#define IDC_CPU3                         1022
#define IDC_IMAGENAME                    1022
#define IDC_CPU4                         1023
#define IDC_PID                          1023
#define IDC_CPU5                         1024
#define IDC_CPUUSAGE                     1024
#define IDC_TOTALS_HANDLE_COUNT          1024
#define IDC_CPU6                         1025
#define IDC_CPUTIME                      1025
#define IDC_CPU7                         1026
#define IDC_MEMORYUSAGE                  1026
#define IDC_TOTALS_THREAD_COUNT          1026
#define IDC_CPU8                         1027
#define IDC_MEMORYUSAGEDELTA             1027
#define IDC_TOTALS_PROCESS_COUNT         1027
#define IDC_CPU9                         1028
#define IDC_PEAKMEMORYUSAGE              1028
#define IDC_COMMIT_CHARGE_TOTAL          1028
#define IDC_CPU10                        1029
#define IDC_PAGEFAULTS                   1029
#define IDC_COMMIT_CHARGE_LIMIT          1029
#define IDC_LICENSE_EDIT                 1029
#define IDC_CPU11                        1030
#define IDC_USEROBJECTS                  1030
#define IDC_COMMIT_CHARGE_PEAK           1030
#define IDC_CPU12                        1031
#define IDC_IOREADS                      1031
#define IDC_PHYSICAL_MEMORY_TOTAL        1031
#define IDC_CPU13                        1032
#define IDC_IOREADBYTES                  1032
#define IDC_PHYSICAL_MEMORY_AVAILABLE    1032
#define IDC_CPU14                        1033
#define IDC_SESSIONID                    1033
#define IDC_PHYSICAL_MEMORY_SYSTEM_CACHE 1033
#define IDC_CPU15                        1034
#define IDC_USERNAME                     1034
#define IDC_KERNEL_MEMORY_TOTAL          1034
#define IDC_CPU16                        1035
#define IDC_PAGEFAULTSDELTA              1035
#define IDC_KERNEL_MEMORY_PAGED          1035
#define IDC_CPU17                        1036
#define IDC_VIRTUALMEMORYSIZE            1036
#define IDC_KERNEL_MEMORY_NONPAGED       1036
#define IDC_CPU18                        1037
#define IDC_PAGEDPOOL                    1037
#define IDC_TOTALS_FRAME                 1037
#define IDC_CPU19                        1038
#define IDC_NONPAGEDPOOL                 1038
#define IDC_COMMIT_CHARGE_FRAME          1038
#define IDC_CPU20                        1039
#define IDC_BASEPRIORITY                 1039
#define IDC_KERNEL_MEMORY_FRAME          1039
#define IDC_CPU21                        1040
#define IDC_HANDLECOUNT                  1040
#define IDC_PHYSICAL_MEMORY_FRAME        1040
#define IDC_CPU22                        1041
#define IDC_THREADCOUNT                  1041
#define IDC_CPU23                        1042
#define IDC_CPU24                        1043
#define IDC_GDIOBJECTS                   1043
#define IDC_CPU_USAGE_FRAME              1043
#define IDC_CPU25                        1044
#define IDC_IOWRITES                     1044
#define IDC_MEM_USAGE_FRAME              1044
#define IDC_CPU26                        1045
#define IDC_IOWRITEBYTES                 1045
#define IDC_CPU_USAGE_HISTORY_FRAME      1045
#define IDC_CPU27                        1046
#define IDC_IOOTHER                      1046
#define IDC_MEMORY_USAGE_HISTORY_FRAME   1046
#define IDC_CPU28                        1047
#define IDC_IOOTHERBYTES                 1047
#define IDC_CPU_USAGE_GRAPH              1047
#define IDC_CPU29                        1048
#define IDC_COMMANDLINE                  1048
#define IDC_MEM_USAGE_GRAPH2             1048
#define IDC_MEM_USAGE_GRAPH              1048
#define IDC_CPU30                        1049
#define IDC_MEM_USAGE_HISTORY_GRAPH      1049
#define IDC_CPU_USAGE_HISTORY_GRAPH      1050
#define IDC_CPU31                        1051

#define IDS_TOTALS_HANDLE_COUNT          1060
#define IDS_TOTALS_THREAD_COUNT          1061
#define IDS_TOTALS_PROCESS_COUNT         1062
#define IDS_COMMIT_CHARGE_TOTAL          1063
#define IDS_COMMIT_CHARGE_LIMIT          1064
#define IDS_COMMIT_CHARGE_PEAK           1065
#define IDS_PHYSICAL_MEMORY_TOTAL        1066
#define IDS_PHYSICAL_MEMORY_AVAILABLE    1067
#define IDS_PHYSICAL_MEMORY_SYSTEM_CACHE 1068
#define IDS_KERNEL_MEMORY_TOTAL          1069
#define IDS_KERNEL_MEMORY_PAGED          1070
#define IDS_KERNEL_MEMORY_NONPAGED       1071

#define ID_FILE_NEW                  32771
#define ID_OPTIONS_ALWAYSONTOP       32773
#define ID_OPTIONS_MINIMIZEONUSE     32774
#define ID_OPTIONS_HIDEWHENMINIMIZED 32775
#define ID_VIEW_REFRESH              32776
#define ID_VIEW_LARGE                32778
#define ID_VIEW_SMALL                32779
#define ID_VIEW_DETAILS              32780
#define ID_VIEW_UPDATESPEED_HIGH     32781
#define ID_VIEW_UPDATESPEED_NORMAL   32782
#define ID_VIEW_UPDATESPEED_LOW      32783
#define ID_VIEW_UPDATESPEED_PAUSED   32784
#define ID_WINDOWS_TILEHORIZONTALLY  32785
#define ID_WINDOWS_TILEVERTICALLY    32786
#define ID_WINDOWS_MINIMIZE          32787
#define ID_WINDOWS_MAXIMIZE          32788
#define ID_WINDOWS_CASCADE           32789
#define ID_WINDOWS_BRINGTOFRONT      32790
#define ID_HELP_TOPICS               32791
#define ID_HELP_ABOUT                32792
#define ID_FILE_EXIT                 32793
#define ID_OPTIONS_SHOW16BITTASKS    32794

#define ID_VIEW_SELECTCOLUMNS             32795
#define ID_VIEW_SHOWKERNELTIMES           32796
#define ID_VIEW_CPUHISTORY_ONEGRAPHALL    32797
#define ID_VIEW_CPUHISTORY_ONEGRAPHPERCPU 32798

#define ID_APPLICATION_PAGE_SWITCHTO    32799
#define ID_ENDTASK                      32800
#define ID_GOTOPROCESS                  32801
#define ID_RESTORE                      32802
#define ID_APPLICATION_PAGE_ENDTASK     32803
#define ID_APPLICATION_PAGE_GOTOPROCESS 32804

#define ID_PROCESS_PAGE_ENDPROCESS              32805
#define ID_PROCESS_PAGE_ENDPROCESSTREE          32806
#define ID_PROCESS_PAGE_DEBUG                   32807
#define ID_PROCESS_PAGE_SETAFFINITY             32808
#define ID_PROCESS_PAGE_SETPRIORITY_REALTIME    32809
#define ID_PROCESS_PAGE_SETPRIORITY_HIGH        32810
#define ID_PROCESS_PAGE_SETPRIORITY_ABOVENORMAL 32811
#define ID_PROCESS_PAGE_SETPRIORITY_NORMAL      32812
#define ID_PROCESS_PAGE_SETPRIORITY_BELOWNORMAL 32813
#define ID_PROCESS_PAGE_SETPRIORITY_LOW         32814
#define ID_PROCESS_PAGE_PROPERTIES              32825
#define ID_PROCESS_PAGE_OPENFILELOCATION        32826

#define ID_SHUTDOWN_STANDBY         32816
#define ID_SHUTDOWN_HIBERNATE       32817
#define ID_SHUTDOWN_POWEROFF        32818
#define ID_SHUTDOWN_REBOOT          32819
#define ID_SHUTDOWN_LOGOFF          32820
#define ID_SHUTDOWN_SWITCHUSER      32821
#define ID_SHUTDOWN_LOCKCOMPUTER    32822
#define ID_SHUTDOWN_DISCONNECT      32823
#define ID_SHUTDOWN_EJECT_COMPUTER  32824

#define IDC_STATIC -1

#define IDS_TAB_APPS          310
#define IDS_TAB_PROCESSES     311
#define IDS_TAB_PERFORMANCE   312
#define IDS_TAB_TASK          313
#define IDS_TAB_STATUS        314
#define IDS_TAB_IMAGENAME     315
#define IDS_TAB_PID           316
#define IDS_TAB_USERNAME      317
#define IDS_TAB_SESSIONID     318
#define IDS_TAB_CPU           319
#define IDS_TAB_CPUTIME       320
#define IDS_TAB_MEMUSAGE      321
#define IDS_TAB_PEAKMEMUSAGE  322
#define IDS_TAB_MEMDELTA      323
#define IDS_TAB_PAGEFAULT     324
#define IDS_TAB_PFDELTA       325
#define IDS_TAB_VMSIZE        326
#define IDS_TAB_PAGEDPOOL     327
#define IDS_TAB_NPPOOL        328
#define IDS_TAB_BASEPRI       329
#define IDS_TAB_HANDLES       330
#define IDS_TAB_THREADS       331
#define IDS_TAB_USERPBJECTS   332
#define IDS_TAB_GDIOBJECTS    333
#define IDS_TAB_IOREADS       334
#define IDS_TAB_IOWRITES      335
#define IDS_TAB_IOOTHER       336
#define IDS_TAB_IOREADBYTES   337
#define IDS_TAB_IOWRITESBYTES 338
#define IDS_TAB_IOOTHERBYTES  339
#define IDS_TAB_COMMANDLINE   368

#define IDS_MENU_SELECTCOLUMNS   340
#define IDS_MENU_16BITTASK       341
#define IDS_MENU_WINDOWS         342
#define IDS_MENU_LARGEICONS      343
#define IDS_MENU_SMALLICONS      344
#define IDS_MENU_DETAILS         345
#define IDS_MENU_ONEGRAPHALLCPUS 346
#define IDS_MENU_ONEGRAPHPERCPU  347
#define IDS_MENU_CPUHISTORY      348
#define IDS_MENU_SHOWKERNELTIMES 349
#define IDS_CREATENEWTASK        350
#define IDS_CREATENEWTASK_DESC   351

#define IDS_MSG_ACCESSPROCESSAFF      352
#define IDS_MSG_PROCESSONEPRO         353
#define IDS_MSG_INVALIDOPTION         354
#define IDS_MSG_UNABLEDEBUGPROCESS    355
#define IDS_MSG_WARNINGDEBUG          356
#define IDS_MSG_TASKMGRWARNING        357
#define IDS_MSG_WARNINGTERMINATING    358
#define IDS_MSG_UNABLETERMINATEPRO    359
#define IDS_MSG_UNABLECHANGEPRIORITY  360
#define IDS_MSG_WARNINGCHANGEPRIORITY 361
#define IDS_MSG_TRAYICONCPUUSAGE      362
#define IDS_MSG_CLOSESYSTEMPROCESS    369

#define IDS_STATUS_MEMUSAGE  363
#define IDS_STATUS_CPUUSAGE  364
#define IDS_STATUS_PROCESSES 365
#define IDS_NOT_RESPONDING   366
#define IDS_RUNNING          367
