/*
 * PROJECT:     ReactOS IMM32
 * LICENSE:     LGPL-2.1-or-later (https://spdx.org/licenses/LGPL-2.1-or-later)
 * PURPOSE:     Defining internal codes (C1K_...) of IME Soft Keyboard Type C1
 * COPYRIGHT:   Copyright 2023 Katayama Hirofumi MZ <katayama.hirofumi.mz@gmail.com>
 */

/* DEFINE_C1K(c1k_code, virtual_key_code, c1k_code_name, virtual_key_name, is_special) */
DEFINE_C1K( 0, 0xC0, C1K_OEM_3,     VK_OEM_3,      FALSE)
DEFINE_C1K( 1, 0x31, C1K_1,         VK_1,          FALSE)
DEFINE_C1K( 2, 0x32, C1K_2,         VK_2,          FALSE)
DEFINE_C1K( 3, 0x33, C1K_3,         VK_3,          FALSE)
DEFINE_C1K( 4, 0x34, C1K_4,         VK_4,          FALSE)
DEFINE_C1K( 5, 0x35, C1K_5,         VK_5,          FALSE)
DEFINE_C1K( 6, 0x36, C1K_6,         VK_6,          FALSE)
DEFINE_C1K( 7, 0x37, C1K_7,         VK_7,          FALSE)
DEFINE_C1K( 8, 0x38, C1K_8,         VK_8,          FALSE)
DEFINE_C1K( 9, 0x39, C1K_9,         VK_9,          FALSE)
DEFINE_C1K(10, 0x30, C1K_0,         VK_0,          FALSE)
DEFINE_C1K(11, 0xBD, C1K_OEM_MINUS, VK_OEM_MINUS,  FALSE)
DEFINE_C1K(12, 0xBB, C1K_OEM_PLUS,  VK_OEM_PLUS,   FALSE)
DEFINE_C1K(13, 0x51, C1K_Q,         VK_Q,          FALSE)
DEFINE_C1K(14, 0x57, C1K_W,         VK_W,          FALSE)
DEFINE_C1K(15, 0x45, C1K_E,         VK_E,          FALSE)
DEFINE_C1K(16, 0x52, C1K_R,         VK_R,          FALSE)
DEFINE_C1K(17, 0x54, C1K_T,         VK_T,          FALSE)
DEFINE_C1K(18, 0x59, C1K_Y,         VK_Y,          FALSE)
DEFINE_C1K(19, 0x55, C1K_U,         VK_U,          FALSE)
DEFINE_C1K(20, 0x49, C1K_I,         VK_I,          FALSE)
DEFINE_C1K(21, 0x4F, C1K_O,         VK_O,          FALSE)
DEFINE_C1K(22, 0x50, C1K_P,         VK_P,          FALSE)
DEFINE_C1K(23, 0xDB, C1K_OEM_4,     VK_OEM_4,      FALSE)
DEFINE_C1K(24, 0xDD, C1K_OEM_6,     VK_OEM_6,      FALSE)
DEFINE_C1K(25, 0xDC, C1K_OEM_5,     VK_OEM_5,      FALSE)
DEFINE_C1K(26, 0x41, C1K_A,         VK_A,          FALSE)
DEFINE_C1K(27, 0x53, C1K_S,         VK_S,          FALSE)
DEFINE_C1K(28, 0x44, C1K_D,         VK_D,          FALSE)
DEFINE_C1K(29, 0x46, C1K_F,         VK_F,          FALSE)
DEFINE_C1K(30, 0x47, C1K_G,         VK_G,          FALSE)
DEFINE_C1K(31, 0x48, C1K_H,         VK_H,          FALSE)
DEFINE_C1K(32, 0x4A, C1K_J,         VK_J,          FALSE)
DEFINE_C1K(33, 0x4B, C1K_K,         VK_K,          FALSE)
DEFINE_C1K(34, 0x4C, C1K_L,         VK_L,          FALSE)
DEFINE_C1K(35, 0xBA, C1K_OEM_1,     VK_OEM_1,      FALSE)
DEFINE_C1K(36, 0xDE, C1K_OEM_7,     VK_OEM_7,      FALSE)
DEFINE_C1K(37, 0x5A, C1K_Z,         VK_Z,          FALSE)
DEFINE_C1K(38, 0x58, C1K_X,         VK_X,          FALSE)
DEFINE_C1K(39, 0x43, C1K_C,         VK_C,          FALSE)
DEFINE_C1K(40, 0x56, C1K_V,         VK_V,          FALSE)
DEFINE_C1K(41, 0x42, C1K_B,         VK_B,          FALSE)
DEFINE_C1K(42, 0x4E, C1K_N,         VK_N,          FALSE)
DEFINE_C1K(43, 0x4D, C1K_M,         VK_M,          FALSE)
DEFINE_C1K(44, 0xBC, C1K_OEM_COMMA, VK_OEM_COMMA,  FALSE)
DEFINE_C1K(45, 0xBE, C1K_OEM_DOT,   VK_OEM_PERIOD, FALSE)
DEFINE_C1K(46, 0xBF, C1K_OEM_2,     VK_OEM_2,      FALSE)
DEFINE_C1K(47, 0x08, C1K_BACKSPACE, VK_BACK,       TRUE)
DEFINE_C1K(48, 0x09, C1K_TAB,       VK_TAB,        TRUE)
DEFINE_C1K(49, 0x14, C1K_CAPS,      VK_CAPITAL,    TRUE)
DEFINE_C1K(50, 0x0D, C1K_ENTER,     VK_RETURN,     TRUE)
DEFINE_C1K(51, 0x10, C1K_SHIFT,     VK_SHIFT,      TRUE)
DEFINE_C1K(52, 0x2D, C1K_INSERT,    VK_INSERT,     TRUE)
DEFINE_C1K(53, 0x2E, C1K_DELETE,    VK_DELETE,     TRUE)
DEFINE_C1K(54, 0x20, C1K_SPACE,     VK_SPACE,      TRUE)
DEFINE_C1K(55, 0x1B, C1K_ESCAPE,    VK_ESCAPE,     TRUE)
