/*
 * PROJECT:     ReactOS IMM32
 * LICENSE:     LGPL-2.1-or-later (https://spdx.org/licenses/LGPL-2.1-or-later)
 * PURPOSE:     Defining internal codes (T1K_...) of IME Soft Keyboard Type T1
 * COPYRIGHT:   Copyright 2023 Katayama Hirofumi MZ <katayama.hirofumi.mz@gmail.com>
 */

/* DEFINE_T1K(t1k_code, virtual_key_code, t1k_code_name, virtual_key_name, is_special) */
DEFINE_T1K( 0, 0xC0, T1K_BACKTICK,   VK_OEM_3,      FALSE)
DEFINE_T1K( 1, 0x31, T1K_1,          VK_1,          FALSE)
DEFINE_T1K( 2, 0x32, T1K_2,          VK_2,          FALSE)
DEFINE_T1K( 3, 0x33, T1K_3,          VK_3,          FALSE)
DEFINE_T1K( 4, 0x34, T1K_4,          VK_4,          FALSE)
DEFINE_T1K( 5, 0x35, T1K_5,          VK_5,          FALSE)
DEFINE_T1K( 6, 0x36, T1K_6,          VK_6,          FALSE)
DEFINE_T1K( 7, 0x37, T1K_7,          VK_7,          FALSE)
DEFINE_T1K( 8, 0x38, T1K_8,          VK_8,          FALSE)
DEFINE_T1K( 9, 0x39, T1K_9,          VK_9,          FALSE)
DEFINE_T1K(10, 0x30, T1K_0,          VK_0,          FALSE)
DEFINE_T1K(11, 0xBD, T1K_MINUS,      VK_OEM_MINUS,  FALSE)
DEFINE_T1K(12, 0xBB, T1K_PLUS,       VK_OEM_PLUS,   FALSE)
DEFINE_T1K(13, 0xDC, T1K_OEM_5,      VK_OEM_5,      FALSE)
DEFINE_T1K(14, 0x51, T1K_Q,          VK_Q,          FALSE)
DEFINE_T1K(15, 0x57, T1K_W,          VK_W,          FALSE)
DEFINE_T1K(16, 0x45, T1K_E,          VK_E,          FALSE)
DEFINE_T1K(17, 0x52, T1K_R,          VK_R,          FALSE)
DEFINE_T1K(18, 0x54, T1K_T,          VK_T,          FALSE)
DEFINE_T1K(19, 0x59, T1K_Y,          VK_Y,          FALSE)
DEFINE_T1K(20, 0x55, T1K_U,          VK_U,          FALSE)
DEFINE_T1K(21, 0x49, T1K_I,          VK_I,          FALSE)
DEFINE_T1K(22, 0x4F, T1K_O,          VK_O,          FALSE)
DEFINE_T1K(23, 0x50, T1K_P,          VK_P,          FALSE)
DEFINE_T1K(24, 0xDB, T1K_OEM_4,      VK_OEM_4,      FALSE)
DEFINE_T1K(25, 0xDD, T1K_OEM_6,      VK_OEM_6,      FALSE)
DEFINE_T1K(26, 0x41, T1K_A,          VK_A,          FALSE)
DEFINE_T1K(27, 0x53, T1K_S,          VK_S,          FALSE)
DEFINE_T1K(28, 0x44, T1K_D,          VK_D,          FALSE)
DEFINE_T1K(29, 0x46, T1K_F,          VK_F,          FALSE)
DEFINE_T1K(30, 0x47, T1K_G,          VK_G,          FALSE)
DEFINE_T1K(31, 0x48, T1K_H,          VK_H,          FALSE)
DEFINE_T1K(32, 0x4A, T1K_J,          VK_J,          FALSE)
DEFINE_T1K(33, 0x4B, T1K_K,          VK_K,          FALSE)
DEFINE_T1K(34, 0x4C, T1K_L,          VK_L,          FALSE)
DEFINE_T1K(35, 0xBA, T1K_OEM_1,      VK_OEM_1,      FALSE)
DEFINE_T1K(36, 0xDE, T1K_OEM_7,      VK_OEM_7,      FALSE)
DEFINE_T1K(37, 0x5A, T1K_Z,          VK_Z,          FALSE)
DEFINE_T1K(38, 0x58, T1K_X,          VK_X,          FALSE)
DEFINE_T1K(39, 0x43, T1K_C,          VK_C,          FALSE)
DEFINE_T1K(40, 0x56, T1K_V,          VK_V,          FALSE)
DEFINE_T1K(41, 0x42, T1K_B,          VK_B,          FALSE)
DEFINE_T1K(42, 0x4E, T1K_N,          VK_N,          FALSE)
DEFINE_T1K(43, 0x4D, T1K_M,          VK_M,          FALSE)
DEFINE_T1K(44, 0xBC, T1K_OEM_COMMA,  VK_OEM_COMMA,  FALSE)
DEFINE_T1K(45, 0xBE, T1K_OEM_PERIOD, VK_OEM_PERIOD, FALSE)
DEFINE_T1K(46, 0xBF, T1K_OEM_2,      VK_OEM_2,      FALSE)
DEFINE_T1K(47, 0x08, T1K_BACKSPACE,  VK_BACK,       TRUE)
DEFINE_T1K(48, 0x09, T1K_TAB,        VK_TAB,        TRUE)
DEFINE_T1K(49, 0x14, T1K_CAPS,       VK_CAPITAL,    TRUE)
DEFINE_T1K(50, 0x0D, T1K_ENTER,      VK_RETURN,     TRUE)
DEFINE_T1K(51, 0x10, T1K_L_SHIFT,    VK_SHIFT,      TRUE)
DEFINE_T1K(52, 0x10, T1K_R_SHIFT,    VK_SHIFT,      TRUE)
DEFINE_T1K(53, 0x11, T1K_L_CTRL,     VK_CONTROL,    TRUE)
DEFINE_T1K(54, 0x11, T1K_R_CTRL,     VK_CONTROL,    TRUE)
DEFINE_T1K(55, 0x12, T1K_L_ALT,      VK_MENU,       TRUE)
DEFINE_T1K(56, 0x12, T1K_R_ALT,      VK_MENU,       TRUE)
DEFINE_T1K(57, 0x1B, T1K_ESCAPE,     VK_ESCAPE,     TRUE)
DEFINE_T1K(58, 0x20, T1K_SPACE,      VK_SPACE,      TRUE)
DEFINE_T1K(59, 0x00, T1K_NONE,       0,             TRUE)
