/*
 * Copyright (C) 2004 Filip Navara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#pragma once

#define IDB_WATERMARK 100
#define IDB_HEADER    101
#define IDB_CLASSIC   102
#define IDB_LAUTUS    103
#define IDB_LUNAR     104
#define IDB_MIZU      105
#define IDB_REACTOS   106
#define IDB_LINE      107

#define IDI_ICON1 10
#define IDI_ICON2 11
#define IDI_ICON3 12
#define IDI_ICON4 13
#define IDI_ICON5 14

#define IDC_STATIC -1

#define IDD_WELCOMEPAGE       1000
#define IDC_WELCOMETITLE      1001

#define IDD_ACKPAGE           1010
#define IDC_PROJECTS          1011
#define IDC_VIEWGPL           1012

#define IDD_OWNERPAGE         1020
#define IDC_OWNERNAME         1021
#define IDC_OWNERORGANIZATION 1022

#define IDD_COMPUTERPAGE      1030
#define IDC_COMPUTERNAME      1031
#define IDC_ADMINPASSWORD1    1032
#define IDC_ADMINPASSWORD2    1033

#define IDD_LOCALEPAGE        1040
#define IDC_LOCALETEXT        1041
#define IDC_CUSTOMLOCALE      1042
#define IDC_LAYOUTTEXT        1043
#define IDC_CUSTOMLAYOUT      1044

#define IDD_DATETIMEPAGE      1050
#define IDC_DATEPICKER        1051
#define IDC_TIMEPICKER        1052
#define IDC_TIMEZONELIST      1053
#define IDC_AUTODAYLIGHT      1054

#define IDD_PROCESSPAGE       1060
#define IDC_ITEM              1061
#define IDC_PROCESSPROGRESS   1062
#define IDC_TASKTEXT1         1063
#define IDC_TASKTEXT2         1064
#define IDC_TASKTEXT3         1065
#define IDC_TASKTEXT4         1066
#define IDC_TASKBITMAP1       1067
#define IDC_TASKBITMAP2       1068
#define IDC_TASKBITMAP3       1069
#define IDC_TASKBITMAP4       1070

#define IDD_FINISHPAGE        1080
#define IDC_FINISHTITLE       1081
#define IDC_RESTART_PROGRESS  1082

#define IDD_THEMEPAGE         1090
#define IDC_THEMEPICKER       1091

#define IDD_GPL      2100
#define IDC_GPL_TEXT 2101

#define IDD_STATUSWINDOW_DLG 2200
#define IDC_STATUSLABEL      2201
#define IDC_ROSLOGO          2202
#define IDC_BAR              2503

#define IDD_PS2MOUSEPROPERTIES 2300
#define IDC_PS2MOUSESAMPLERATE 2301
#define IDC_PS2MOUSEWHEEL      2302
#define IDC_PS2MOUSEINPUTLEN   2303
#define IDC_PS2MOUSEINPUTUPDN  2304
#define IDC_PS2MOUSEFASTINIT   2305
#define IDC_PS2MOUSEDEFAULTS   2306
#define IDC_PS2STATIC          2307

#define IDD_PRODUCT                2400
#define IDC_PRODUCT_ICON           2401
#define IDC_PRODUCT_OPTIONS        2402
#define IDC_PRODUCT_DESCRIPTION    2405

#define IDS_ACKTITLE    3010
#define IDS_ACKSUBTITLE 3011

#define IDS_OWNERTITLE    3020
#define IDS_OWNERSUBTITLE 3021

#define IDS_COMPUTERTITLE    3030
#define IDS_COMPUTERSUBTITLE 3031

#define IDS_LOCALETITLE    3040
#define IDS_LOCALESUBTITLE 3041
#define IDS_LOCALETEXT     3042
#define IDS_LAYOUTTEXT     3043

#define IDS_DATETIMETITLE    3050
#define IDS_DATETIMESUBTITLE 3051

#define IDS_PROCESSTITLE    3060
#define IDS_PROCESSSUBTITLE 3061

#define IDS_THEMESELECTIONTITLE    3070
#define IDS_THEMESELECTIONSUBTITLE 3071

#define IDS_ACKPROJECTS 3100

#define IDS_REACTOS_SETUP          3300
#define IDS_UNKNOWN_ERROR          3301
#define IDS_LOADLIBRARY_FAILED     3302
#define IDS_GETPROCADDR_FAILED     3303
#define IDS_REGSVR_FAILED          3304
#define IDS_DLLINSTALL_FAILED      3305
#define IDS_TIMEOUT                3306
#define IDS_REASON_UNKNOWN         3307
#define IDS_ADMINISTRATOR_NAME     3308
#define IDS_MACHINE_OWNER_NAME     3309

#define IDS_WZD_NAME            3450
#define IDS_WZD_SETCOMPUTERNAME 3451
#define IDS_WZD_COMPUTERNAME    3452
#define IDS_WZD_PASSWORDEMPTY   3453
#define IDS_WZD_PASSWORDMATCH   3454
#define IDS_WZD_PASSWORDCHAR    3455
#define IDS_WZD_LOCALTIME       3456

#define IDS_STATUS_INSTALL_DEV 3500

/* ATTENTION: Synchronize the translation of these strings with shell32 */
#define IDS_PROGRAMFILES    3600
#define IDS_COMMONFILES     3601

#define IDS_DETECTIONDISABLED 3700
#define IDS_LOOKFORWHEEL      3701
#define IDS_ASSUMEPRESENT     3702

#define IDS_CLASSIC 3800
#define IDS_LAUTUS  3801
#define IDS_LUNAR   3802
#define IDS_MIZU    3803

#define IDS_PRODUCTTITLE            3900
#define IDS_PRODUCTSUBTITLE         3901
#define IDS_PRODUCTSERVERNAME       3902
#define IDS_PRODUCTWORKSTATIONNAME  3903
#define IDS_PRODUCTSERVERINFO       3904
#define IDS_PRODUCTWORKSTATIONINFO  3905
#define IDS_DEFAULT                 3906

#define IDR_GPL 4000

/* Timer ID for the animated dialog bar. */
#define IDT_BAR 1
