////////////////////////////////////////////////////////////////////
// Copyright (C) Alexander Telyatnikov, Ivan Keliukh, Yegor Anchishkin, SKIF Software, 1999-2013. Kiev, Ukraine
// All rights reserved
// This file was released under the GPLv2 on June 2015.
////////////////////////////////////////////////////////////////////

#ifndef __UDFERR_USR_H__
#define __UDFERR_USR_H__

#ifndef WITHOUT_FORMATTER

#define MKUDF_OK                       0x00000000
#include "udferr_usr_h.h"
//#define MKUDF_HW_READ_ONLY             0x80000001
//#define MKUDF_CANT_BLANK               0x80000002
#define MKUDF_INVALID_PARAM_MT         0x80000003
#define MKUDF_INVALID_PARAM_PT         0x80000004
#define MKUDF_INVALID_PARAM            0x80000005
#define MKUDF_HW_CANT_READ_LAYOUT      0x80000006
#define MKUDF_AUTO_BLOCKCOUNT_FAILED   0x80000007
#define MKUDF_CANT_RECORD_BEA01        0x80000008
#define MKUDF_CANT_RECORD_NSR02        0x80000009
#define MKUDF_CANT_RECORD_TEA01        0x8000000a
#define MKUDF_CANT_RECORD_ANCHOR       0x8000000b
#define MKUDF_CANT_RECORD_PVD          0x8000000c
#define MKUDF_CANT_RECORD_LVD          0x8000000d
#define MKUDF_CANT_RECORD_LVID         0x8000000e
#define MKUDF_CANT_RECORD_PARTD        0x8000000f
#define MKUDF_CANT_RECORD_USD          0x80000010
#define MKUDF_CANT_RECORD_IUVD         0x80000011
#define MKUDF_CANT_RECORD_TERMD        0x80000012
#define MKUDF_CANT_RECORD_FSD          0x80000013
#define MKUDF_CANT_RECORD_SPT          0x80000014
#define MKUDF_PARTITION_TOO_SHORT      0x80000015
#define MKUDF_CANT_RECORD_FSBM         0x80000016
#define MKUDF_CANT_RECORD_ROOT_FE      0x80000017
#define MKUDF_CANT_RECORD_VAT_FE       0x80000018
#define MKUDF_CANT_OPEN_FILE           0x80000019
#define MKUDF_CANT_RESERVE_TRACK       0x8000001a
#define MKUDF_VAT_MULTISESS_NOT_SUPP   0x8000001b
#define MKUDF_NOT_ENOUGH_PARAMS        0x8000001c
#define MKUDF_INVALID_PT_FOR_HDD       0x8000001d
#define MKUDF_INVALID_PT_FOR_WORM      0x8000001e
#define MKUDF_CANT_FORMAT              0x8000001f
#define MKUDF_MEDIA_TYPE_NOT_SUPP      0x80000020
#define MKUDF_INVALID_PARAM_BC_FOR_VAT 0x80000021
#define MKUDF_HW_PARTITION_TOO_SHORT   0x80000022
#define MKUDF_CANT_LOCK_VOL            0x80000023
#define MKUDF_CANT_SET_WPARAMS         0x80000024
#define MKUDF_HW_WRITE_ERROR           0x80000025
#define MKUDF_BLANK_MEDIA_REQUIRED     0x80000026
#define MKUDF_INVALID_PT_FOR_BLANK     0x80000027
#define MKUDF_FINALIZE_TOO_MANY_PARAMS 0x80000028
#define MKUDF_NO_ANCHOR_FOUND          0x80000029
#define MKUDF_HW_INVALID_NWA           0x8000002a
#define MKUDF_NO_MEDIA_IN_DEVICE       0x8000002b
#define MKUDF_INVALID_BC               0x8000002c
#define MKUDF_INVALID_MT_FOR_BLANK     0x8000002d
#define MKUDF_HW_CANT_SET_WRITE_PARAMS 0x8000002e
#define MKUDF_CANT_ALLOW_DASD_IO       0x8000002f
#define MKUDF_CANT_DISMOUNT_VOLUME     0x80000030
#define MKUDF_FORMAT_REQUIRED          0x80000031
#define MKUDF_FULL_BLANK_REQUIRED      0x80000032
#define MKUDF_NO_SUITABLE_MODE_FOR_FMT 0x80000033
#define MKUDF_CANT_BLANK_DVDRAM        0x80000034
#define MKUDF_CANT_RESERVE_ISO_SPACE   0x80000035
#define MKUDF_CANT_RECORD_NOTALLOC_FE  0x80000036
#define MKUDF_BAD_BLOCK_IN_SYSTEM_AREA 0x80000037
#define MKUDF_CANT_OPEN_ISO_IMAGE      0x80000038
#define MKUDF_BAD_ISO_IMAGE_ALIGN      0x80000039
#define MKUDF_CANT_READ_ISO_IMAGE      0x8000003a
#define MKUDF_CANT_WRITE_ISO_IMAGE     0x8000003b
#define MKUDF_INVALID_PARAM_SPEED      0x8000003c
#define MKUDF_CANT_MAKE_WINUDF         0x8000003d
#define MKUDF_FLUSH_ERROR              0x8000003e
#define MKUDF_FINAL_VERIFY_FAILED      0x8000003f
#define MKUDF_INSUFFICIENT_MEMORY      0x80000040
#define MKUDF_CANT_CREATE_THREAD       0x80000041
#define MKUDF_CANT_APPLY_R             0x80000042
#define MKUDF_USER_BREAK               0x80000043
#define MKUDF_INVALID_USER_BUFFER      0x80000044
#define MKUDF_INTERNAL_ERROR           0x80000045
#define MKUDF_INVALID_PARAM_VFIN       0x80000046
#define MKUDF_INVALID_PARAM_VFOUT      0x80000047
#define MKUDF_CANT_CREATE_BB_LOG       0x80000048
#define MKUDF_CANT_OPEN_BB_LOG         0x80000049
#define MKUDF_INSUFFICIENT_PRIVILIGES  0x8000004a
#define MKUDF_BLANK_FORMAT_REQUIRED    0x8000004b
#define MKUDF_NO_DEVICE_NAME           0x8000004c
#define MKUDF_CANT_FLUSH               0x8000004d
#define MKUDF_INVALID_PARAM_ISO_MODE   0x8000004e
#define MKUDF_INVALID_PARAM_ISO_SES    0x8000004f
#define MKUDF_SMART_BLANK_FORMAT_FAILED   0x80000050
#define MKUDF_SMART_FORMAT_FAILED      0x80000051
#define MKUDF_OTHER_PACKET_FS          0x80000052
#define MKUDF_RAW_PACKET_FS            0x80000053
#define MKUDF_CANT_ZERO                0x80000054
#define MKUDF_NO_UNERASE_FOR_THIS_MEDIA 0x80000055
#define MKUDF_UNERASE_FAILED           0x80000056
#define MKUDF_INVALID_PARAM_REVISION   0x80000057
#define MKUDF_FORMAT_IN_PROGRESS       0x80000058
#define MKUDF_CANT_CREATE_ISO_IMAGE    0x80000059
#define MKUDF_ABORTED                  0x80000100
//#define MKUDF_   0x800000
#define MKUDF_PENDING                  0x00000103

#define CHKUDF_CANT_MOUNT              0x80010000

struct err_msg_item
{
    unsigned int err_code;
    const char* err_msg;
};

extern struct err_msg_item mkudf_err_msg[];

#endif //WITHOUT_FORMATTER

//NT-like status codes

#ifndef STATUS_SUCCESS

#define STATUS_SUCCESS                   1
#define STATUS_MORE_ENTRIES              ((NTSTATUS)0x00000105L)
#define STATUS_BUFFER_ALL_ZEROS          ((NTSTATUS)0x00000117L)
#define STATUS_FT_WRITE_RECOVERY         ((NTSTATUS)0x4000000BL)
#define STATUS_BUFFER_OVERFLOW           ((NTSTATUS)0x80000005L)
#define STATUS_NO_MORE_FILES             ((NTSTATUS)0x80000006L)
#define STATUS_DEVICE_BUSY               ((NTSTATUS)0x80000011L)
#define STATUS_VERIFY_REQUIRED           ((NTSTATUS)0x80000016L)
#define STATUS_NO_DATA_DETECTED          ((NTSTATUS)0x80000022L)
#define STATUS_UNSUCCESSFUL              ((NTSTATUS)0xC0000001L)
#define STATUS_INFO_LENGTH_MISMATCH      ((NTSTATUS)0xC0000004L)
//#define STATUS_INVALID_HANDLE            ((NTSTATUS)0xC0000008L)
#define STATUS_INVALID_PARAMETER         ((NTSTATUS)0xC000000DL)
#define STATUS_NO_SUCH_DEVICE            ((NTSTATUS)0xC000000EL)
#define STATUS_NO_SUCH_FILE              ((NTSTATUS)0xC000000FL)
#define STATUS_INVALID_DEVICE_REQUEST    ((NTSTATUS)0xC0000010L)
#define STATUS_END_OF_FILE               ((NTSTATUS)0xC0000011L)
#define STATUS_WRONG_VOLUME              ((NTSTATUS)0xC0000012L)
#define STATUS_NO_MEDIA_IN_DEVICE        ((NTSTATUS)0xC0000013L)
#define STATUS_UNRECOGNIZED_MEDIA        ((NTSTATUS)0xC0000014L)
#define STATUS_NONEXISTENT_SECTOR        ((NTSTATUS)0xC0000015L)
#define STATUS_MORE_PROCESSING_REQUIRED  ((NTSTATUS)0xC0000016L)
#define STATUS_ACCESS_DENIED             ((NTSTATUS)0xC0000022L)
#define STATUS_BUFFER_TOO_SMALL          ((NTSTATUS)0xC0000023L)
#define STATUS_DISK_CORRUPT_ERROR        ((NTSTATUS)0xC0000032L)
#define STATUS_OBJECT_NAME_INVALID       ((NTSTATUS)0xC0000033L)
#define STATUS_OBJECT_NAME_NOT_FOUND     ((NTSTATUS)0xC0000034L)
#define STATUS_OBJECT_NAME_COLLISION     ((NTSTATUS)0xC0000035L)
#define STATUS_OBJECT_PATH_NOT_FOUND     ((NTSTATUS)0xC000003AL)
#define STATUS_DATA_OVERRUN              ((NTSTATUS)0xC000003CL)
#define STATUS_CRC_ERROR                 ((NTSTATUS)0xC000003FL)
#define STATUS_SHARING_VIOLATION         ((NTSTATUS)0xC0000043L)
#define STATUS_DISK_FULL                 ((NTSTATUS)0xC000007FL)
#define STATUS_INVALID_VOLUME_LABEL      ((NTSTATUS)0xC0000086L)
#define STATUS_NOT_MAPPED_DATA           ((NTSTATUS)0xC0000088L)
#define STATUS_INSUFFICIENT_RESOURCES    ((NTSTATUS)0xC000009AL)
#define STATUS_DEVICE_DATA_ERROR         ((NTSTATUS)0xC000009CL)
#define STATUS_DEVICE_NOT_CONNECTED      ((NTSTATUS)0xC000009DL)
#define STATUS_MEDIA_WRITE_PROTECTED     ((NTSTATUS)0xC00000A2L)
#define STATUS_DEVICE_NOT_READY          ((NTSTATUS)0xC00000A3L)
#define STATUS_IO_TIMEOUT                ((NTSTATUS)0xC00000B5L)
#define STATUS_FILE_IS_A_DIRECTORY       ((NTSTATUS)0xC00000BAL)
#define STATUS_SHARING_PAUSED            ((NTSTATUS)0xC00000CFL)
#define STATUS_INVALID_USER_BUFFER       ((NTSTATUS)0xC00000E8L)
#define STATUS_DIRECTORY_NOT_EMPTY       ((NTSTATUS)0xC0000101L)
#define STATUS_FILE_CORRUPT_ERROR        ((NTSTATUS)0xC0000102L)
#define STATUS_NOT_A_DIRECTORY           ((NTSTATUS)0xC0000103L)
#define STATUS_CANCELLED                 ((NTSTATUS)0xC0000120L)
#define STATUS_CANNOT_DELETE             ((NTSTATUS)0xC0000121L)
#define STATUS_FILE_DELETED              ((NTSTATUS)0xC0000123L)
#define STATUS_UNRECOGNIZED_VOLUME       ((NTSTATUS)0xC000014FL)
#define STATUS_TOO_MANY_SECRETS          ((NTSTATUS)0xC0000156L)
#define STATUS_INVALID_BLOCK_LENGTH      ((NTSTATUS)0xC0000173L)
#define STATUS_UNABLE_TO_UNLOAD_MEDIA    ((NTSTATUS)0xC0000176L)
#define STATUS_DRIVER_INTERNAL_ERROR     ((NTSTATUS)0xC0000183L)
#define STATUS_INVALID_DEVICE_STATE      ((NTSTATUS)0xC0000184L)
#define STATUS_IO_DEVICE_ERROR           ((NTSTATUS)0xC0000185L)
#define STATUS_LOST_WRITEBEHIND_DATA     ((NTSTATUS)0xC0000222L)
#define STATUS_NOT_FOUND                 ((NTSTATUS)0xC0000225L)
#define STATUS_RETRY                     ((NTSTATUS)0xC000022DL)
#define STATUS_REQUEST_ABORTED           ((NTSTATUS)0xC0000240L)
#define STATUS_TOO_MANY_LINKS            ((NTSTATUS)0xC0000265L)
#define STATUS_LICENSE_VIOLATION         ((NTSTATUS)0xC000026AL)

#endif // STATUS_SUCCESS

#endif // __UDFERR_USR_H__
