/*
	vfddbg.c

	Virtual Floppy Drive for Windows NT platform
	Kernel mode driver debug functions

	Copyright (C) 2003-2005 Ken Kato
*/

#if !DBG

#if !defined(__REACTOS__) || defined(_MSC_VER)
//	suppress empty compile unit warning
#pragma warning (disable: 4206)
#pragma message ("Debug feature is disabled.")
#endif

#else	// DBG

#include "imports.h"
#include "vfddrv.h"
#include "vfddbg.h"

#define CASE_RETURN_STR(str)	case str: return #str;

//
//	Return IRP Major Function name
//
#ifndef IRP_MJ_POWER
#define IRP_MJ_POWER			0x16
#endif
#ifndef IRP_MJ_SYSTEM_CONTROL
#define IRP_MJ_SYSTEM_CONTROL	0x17
#endif
#ifndef IRP_MJ_PNP
#define IRP_MJ_PNP				0x1b
#endif

PCSTR
GetMajorFuncName(
	UCHAR				major_code)
{
	static char functionName[80];

	switch (major_code) {
	CASE_RETURN_STR(IRP_MJ_CREATE);						// 0x00
	CASE_RETURN_STR(IRP_MJ_CREATE_NAMED_PIPE);			// 0x01
	CASE_RETURN_STR(IRP_MJ_CLOSE);						// 0x02
	CASE_RETURN_STR(IRP_MJ_READ);						// 0x03
	CASE_RETURN_STR(IRP_MJ_WRITE);						// 0x04
	CASE_RETURN_STR(IRP_MJ_QUERY_INFORMATION);			// 0x05
	CASE_RETURN_STR(IRP_MJ_SET_INFORMATION);			// 0x06
	CASE_RETURN_STR(IRP_MJ_QUERY_EA);					// 0x07
	CASE_RETURN_STR(IRP_MJ_SET_EA);						// 0x08
	CASE_RETURN_STR(IRP_MJ_FLUSH_BUFFERS);				// 0x09
	CASE_RETURN_STR(IRP_MJ_QUERY_VOLUME_INFORMATION);	// 0x0a
	CASE_RETURN_STR(IRP_MJ_SET_VOLUME_INFORMATION);		// 0x0b
	CASE_RETURN_STR(IRP_MJ_DIRECTORY_CONTROL);			// 0x0c
	CASE_RETURN_STR(IRP_MJ_FILE_SYSTEM_CONTROL);		// 0x0d
	CASE_RETURN_STR(IRP_MJ_DEVICE_CONTROL);				// 0x0e
	CASE_RETURN_STR(IRP_MJ_INTERNAL_DEVICE_CONTROL);	// 0x0f
	CASE_RETURN_STR(IRP_MJ_SHUTDOWN);					// 0x10
	CASE_RETURN_STR(IRP_MJ_LOCK_CONTROL);				// 0x11
	CASE_RETURN_STR(IRP_MJ_CLEANUP);					// 0x12
	CASE_RETURN_STR(IRP_MJ_CREATE_MAILSLOT);			// 0x13
	CASE_RETURN_STR(IRP_MJ_QUERY_SECURITY);				// 0x14
	CASE_RETURN_STR(IRP_MJ_SET_SECURITY);				// 0x15
	CASE_RETURN_STR(IRP_MJ_POWER);						// 0x16
	CASE_RETURN_STR(IRP_MJ_SYSTEM_CONTROL);				// 0x17
	CASE_RETURN_STR(IRP_MJ_DEVICE_CHANGE);				// 0x18
	CASE_RETURN_STR(IRP_MJ_QUERY_QUOTA);				// 0x19
	CASE_RETURN_STR(IRP_MJ_SET_QUOTA);					// 0x1a
	CASE_RETURN_STR(IRP_MJ_PNP);						// 0x1b
	default:
		functionName[sizeof(functionName) - 1] = '\0';
		_snprintf(functionName, sizeof(functionName) - 1,
		// sprintf(functionName,
			"Unknown Major Function (0x%x)", major_code);
		return functionName;
	}
}

#ifdef VFD_PNP

//
//	Return PnP IRP Minor Function Name
//
PCSTR
GetPnpIrpName(ULONG minor_code)
{
	static char functionName[80];

	switch (minor_code) {
	CASE_RETURN_STR(IRP_MN_START_DEVICE);					// 0x00
	CASE_RETURN_STR(IRP_MN_QUERY_REMOVE_DEVICE);			// 0x01
	CASE_RETURN_STR(IRP_MN_REMOVE_DEVICE);					// 0x02
	CASE_RETURN_STR(IRP_MN_CANCEL_REMOVE_DEVICE);			// 0x03
	CASE_RETURN_STR(IRP_MN_STOP_DEVICE);					// 0x04
	CASE_RETURN_STR(IRP_MN_QUERY_STOP_DEVICE);				// 0x05
	CASE_RETURN_STR(IRP_MN_CANCEL_STOP_DEVICE);				// 0x06
	CASE_RETURN_STR(IRP_MN_QUERY_DEVICE_RELATIONS);			// 0x07
	CASE_RETURN_STR(IRP_MN_QUERY_INTERFACE);				// 0x08
	CASE_RETURN_STR(IRP_MN_QUERY_CAPABILITIES);				// 0x09
	CASE_RETURN_STR(IRP_MN_QUERY_RESOURCES);				// 0x0A
	CASE_RETURN_STR(IRP_MN_QUERY_RESOURCE_REQUIREMENTS);	// 0x0B
	CASE_RETURN_STR(IRP_MN_QUERY_DEVICE_TEXT);				// 0x0C
	CASE_RETURN_STR(IRP_MN_FILTER_RESOURCE_REQUIREMENTS);	// 0x0D
	CASE_RETURN_STR(IRP_MN_READ_CONFIG);					// 0x0F
	CASE_RETURN_STR(IRP_MN_WRITE_CONFIG);					// 0x10
	CASE_RETURN_STR(IRP_MN_EJECT);							// 0x11
	CASE_RETURN_STR(IRP_MN_SET_LOCK);						// 0x12
	CASE_RETURN_STR(IRP_MN_QUERY_ID);						// 0x13
	CASE_RETURN_STR(IRP_MN_QUERY_PNP_DEVICE_STATE);			// 0x14
	CASE_RETURN_STR(IRP_MN_QUERY_BUS_INFORMATION);			// 0x15
	CASE_RETURN_STR(IRP_MN_DEVICE_USAGE_NOTIFICATION);		// 0x16
	CASE_RETURN_STR(IRP_MN_SURPRISE_REMOVAL);				// 0x17
	CASE_RETURN_STR(IRP_MN_QUERY_LEGACY_BUS_INFORMATION);	// 0x18
	default:
		functionName[sizeof(functionName) - 1] = '\0';
		_snprintf(functionName, sizeof(functionName) - 1,
		// sprintf(functionName,
			"Unknown PNP IRP (0x%x)", minor_code);
		return functionName;
	}
}

//
//	Return Power IRP Minor Function Name
//
PCSTR
GetPowerIrpName(ULONG minor_code)
{
	static char functionName[80];

	switch (minor_code) {
	CASE_RETURN_STR(IRP_MN_SET_POWER);
	CASE_RETURN_STR(IRP_MN_QUERY_POWER);
	CASE_RETURN_STR(IRP_MN_WAIT_WAKE);
	CASE_RETURN_STR(IRP_MN_POWER_SEQUENCE);
	default:
		functionName[sizeof(functionName) - 1] = '\0';
		_snprintf(functionName, sizeof(functionName) - 1,
		// sprintf(functionName,
			"Unknown Power IRP (0x%x)", minor_code);
		return functionName;
	}
}

//
//	Return System IRP Minor Function Name
//
PCSTR
GetSystemIrpName(ULONG minor_code)
{
	static char functionName[80];

	switch (minor_code) {
	CASE_RETURN_STR(IRP_MN_QUERY_ALL_DATA);					// 0x00
	CASE_RETURN_STR(IRP_MN_QUERY_SINGLE_INSTANCE);			// 0x01
	CASE_RETURN_STR(IRP_MN_CHANGE_SINGLE_INSTANCE);			// 0x02
	CASE_RETURN_STR(IRP_MN_CHANGE_SINGLE_ITEM);				// 0x03
	CASE_RETURN_STR(IRP_MN_ENABLE_EVENTS);					// 0x04
	CASE_RETURN_STR(IRP_MN_DISABLE_EVENTS);					// 0x05
	CASE_RETURN_STR(IRP_MN_ENABLE_COLLECTION);				// 0x06
	CASE_RETURN_STR(IRP_MN_DISABLE_COLLECTION);				// 0x07
	CASE_RETURN_STR(IRP_MN_REGINFO);						// 0x08
	CASE_RETURN_STR(IRP_MN_EXECUTE_METHOD);					// 0x09
	default:
		functionName[sizeof(functionName) - 1] = '\0';
		_snprintf(functionName, sizeof(functionName) - 1,
		// sprintf(functionName,
			"Unknown System IRP (0x%x)", minor_code);
		return functionName;
	}
}

#endif	// VFD_PNP


#include <ntdddisk.h>
#ifndef __REACTOS__
#include <ntddft.h>
#endif
#include <ntddstor.h>

#if (VER_PRODUCTBUILD < 2195)
//
// imports from Win2K DDK
//

// mountmgr.h

#define MOUNTMGRCONTROLTYPE  ((ULONG) 'm')
#define MOUNTDEVCONTROLTYPE  ((ULONG) 'M')
/*
#define IOCTL_MOUNTMGR_CREATE_POINT \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 0, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_DELETE_POINTS \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 1, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
*/
#define IOCTL_MOUNTMGR_QUERY_POINTS \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 3, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 5, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 6, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 7, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_CHANGE_NOTIFY \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 8, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 9, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 10, METHOD_BUFFERED, FILE_READ_ACCESS)
/*
#define IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 11, METHOD_BUFFERED, FILE_READ_ACCESS)
*/

// mountdev.h
/*
#define IOCTL_MOUNTDEV_QUERY_UNIQUE_ID \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTDEV_QUERY_DEVICE_NAME \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTDEV_LINK_CREATED \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTDEV_LINK_DELETED \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
*/

// ntdddisk.h
#define IOCTL_DISK_UPDATE_DRIVE_SIZE \
	CTL_CODE(IOCTL_DISK_BASE, 0x0032, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GROW_PARTITION \
	CTL_CODE(IOCTL_DISK_BASE, 0x0034, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_CACHE_INFORMATION \
	CTL_CODE(IOCTL_DISK_BASE, 0x0035, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_SET_CACHE_INFORMATION \
	CTL_CODE(IOCTL_DISK_BASE, 0x0036, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_DELETE_DRIVE_LAYOUT \
	CTL_CODE(IOCTL_DISK_BASE, 0x0040, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_FORMAT_DRIVE  \
	CTL_CODE(IOCTL_DISK_BASE, 0x00f3, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_SENSE_DEVICE  \
	CTL_CODE(IOCTL_DISK_BASE, 0x00f8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_INTERNAL_SET_NOTIFY \
	CTL_CODE(IOCTL_DISK_BASE, 0x0102, METHOD_BUFFERED, FILE_ANY_ACCESS)

// ntddft.h
#define FT_SECONDARY_READ_ALT \
	CTL_CODE(FTTYPE, 4, METHOD_OUT_DIRECT, FILE_READ_ACCESS)
#define FT_PRIMARY_READ_ALT \
	CTL_CODE(FTTYPE, 5, METHOD_OUT_DIRECT, FILE_READ_ACCESS)
#define FT_CLUSTER_SET_MEMBER_STATE  \
	CTL_CODE(FTTYPE,11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FT_CLUSTER_GET_MEMBER_STATE  \
	CTL_CODE(FTTYPE,12, METHOD_BUFFERED, FILE_ANY_ACCESS)

// ntddstor.h
#define IOCTL_STORAGE_LOAD_MEDIA2 \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0203, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_EJECTION_CONTROL \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0250, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_MCN_CONTROL \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0251, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_GET_MEDIA_TYPES_EX \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0301, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_RESET_BUS  \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0400, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_RESET_DEVICE \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0401, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_STORAGE_GET_DEVICE_NUMBER  \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0420, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_PREDICT_FAILURE \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0440, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_STORAGE_QUERY_PROPERTY \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0500, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define OBSOLETE_IOCTL_STORAGE_RESET_BUS \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0400, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define OBSOLETE_IOCTL_STORAGE_RESET_DEVICE  \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0401, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)

// ntddft2.h
#define FTCONTROLTYPE	((ULONG) 'g')
#define FT_CREATE_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 0, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_BREAK_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 1, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_ENUMERATE_LOGICAL_DISKS \
	CTL_CODE(FTCONTROLTYPE, 2, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_QUERY_LOGICAL_DISK_INFORMATION \
	CTL_CODE(FTCONTROLTYPE, 3, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_ORPHAN_LOGICAL_DISK_MEMBER \
	CTL_CODE(FTCONTROLTYPE, 4, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_REPLACE_LOGICAL_DISK_MEMBER \
	CTL_CODE(FTCONTROLTYPE, 5, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_QUERY_NT_DEVICE_NAME_FOR_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 6, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_INITIALIZE_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 7, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_QUERY_DRIVE_LETTER_FOR_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 8, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_CHECK_IO \
	CTL_CODE(FTCONTROLTYPE, 9, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_SET_DRIVE_LETTER_FOR_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 10, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_QUERY_NT_DEVICE_NAME_FOR_PARTITION \
	CTL_CODE(FTCONTROLTYPE, 12, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_CHANGE_NOTIFY \
	CTL_CODE(FTCONTROLTYPE, 13, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_STOP_SYNC_OPERATIONS \
	CTL_CODE(FTCONTROLTYPE, 14, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define FT_QUERY_LOGICAL_DISK_ID \
	CTL_CODE(FTCONTROLTYPE, 100, METHOD_BUFFERED, FILE_READ_ACCESS)
#define FT_CREATE_PARTITION_LOGICAL_DISK \
	CTL_CODE(FTCONTROLTYPE, 101, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)

// ntddvol.h
#define IOCTL_VOLUME_BASE	((ULONG) 'V')
#define IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS \
	CTL_CODE(IOCTL_VOLUME_BASE, 0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_SUPPORTS_ONLINE_OFFLINE \
	CTL_CODE(IOCTL_VOLUME_BASE, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_ONLINE \
	CTL_CODE(IOCTL_VOLUME_BASE, 2, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_VOLUME_OFFLINE \
	CTL_CODE(IOCTL_VOLUME_BASE, 3, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_VOLUME_IS_OFFLINE \
	CTL_CODE(IOCTL_VOLUME_BASE, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_IS_IO_CAPABLE \
	CTL_CODE(IOCTL_VOLUME_BASE, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_QUERY_FAILOVER_SET \
	CTL_CODE(IOCTL_VOLUME_BASE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_QUERY_VOLUME_NUMBER \
	CTL_CODE(IOCTL_VOLUME_BASE, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_LOGICAL_TO_PHYSICAL \
	CTL_CODE(IOCTL_VOLUME_BASE, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_PHYSICAL_TO_LOGICAL \
	CTL_CODE(IOCTL_VOLUME_BASE, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)

#else	// (VER_PRODUCTBUILD < 2195)

#include <mountmgr.h>
#include <mountdev.h>
#ifndef __REACTOS__
#include <ntddft2.h>
#endif
#include <ntddvol.h>

#define FT_SECONDARY_READ_ALT \
	CTL_CODE(FTTYPE, 4, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define FT_PRIMARY_READ_ALT \
	CTL_CODE(FTTYPE, 5, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)

#endif	// (VER_PRODUCTBUILD < 2195)

#if (VER_PRODUCTBUILD < 2600)
//
// imports from WinXP DDK
//

// mountmgr.h
#define IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATH \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATHS \
	CTL_CODE(MOUNTMGRCONTROLTYPE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS)

// mountdev.h
/*
#define IOCTL_MOUNTDEV_QUERY_STABLE_GUID \
	CTL_CODE(MOUNTDEVCONTROLTYPE, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
*/

// ntdddisk.h
#define IOCTL_DISK_PERFORMANCE_OFF \
	CTL_CODE(IOCTL_DISK_BASE, 0x0018, METHOD_BUFFERED, FILE_ANY_ACCESS)
/*
#define IOCTL_DISK_GET_PARTITION_INFO_EX \
	CTL_CODE(IOCTL_DISK_BASE, 0x0012, METHOD_BUFFERED, FILE_ANY_ACCESS)
*/
#define IOCTL_DISK_SET_PARTITION_INFO_EX \
	CTL_CODE(IOCTL_DISK_BASE, 0x0013, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_GET_DRIVE_LAYOUT_EX \
	CTL_CODE(IOCTL_DISK_BASE, 0x0014, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_SET_DRIVE_LAYOUT_EX \
	CTL_CODE(IOCTL_DISK_BASE, 0x0015, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_DISK_CREATE_DISK \
	CTL_CODE(IOCTL_DISK_BASE, 0x0016, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
/*
#define IOCTL_DISK_GET_LENGTH_INFO \
	CTL_CODE(IOCTL_DISK_BASE, 0x0017, METHOD_BUFFERED, FILE_READ_ACCESS)
*/
#define IOCTL_DISK_GET_DRIVE_GEOMETRY_EX \
	CTL_CODE(IOCTL_DISK_BASE, 0x0028, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_DISK_GET_WRITE_CACHE_STATE \
	CTL_CODE(IOCTL_DISK_BASE, 0x0037, METHOD_BUFFERED, FILE_READ_ACCESS)
#define IOCTL_DISK_UPDATE_PROPERTIES \
	CTL_CODE(IOCTL_DISK_BASE, 0x0050, METHOD_BUFFERED, FILE_ANY_ACCESS)

// ntddstor.h
#define IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0304, METHOD_BUFFERED, FILE_ANY_ACCESS)
/*
#define IOCTL_STORAGE_GET_HOTPLUG_INFO \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0305, METHOD_BUFFERED, FILE_ANY_ACCESS)
*/
#define IOCTL_STORAGE_SET_HOTPLUG_INFO \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0306, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)
#define IOCTL_STORAGE_BREAK_RESERVATION \
	CTL_CODE(IOCTL_STORAGE_BASE, 0x0405, METHOD_BUFFERED, FILE_READ_ACCESS)

// ntddvol.h
#define IOCTL_VOLUME_IS_PARTITION \
	CTL_CODE(IOCTL_VOLUME_BASE, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_READ_PLEX \
	CTL_CODE(IOCTL_VOLUME_BASE, 11, METHOD_OUT_DIRECT, FILE_READ_ACCESS)
#define IOCTL_VOLUME_IS_CLUSTERED \
	CTL_CODE(IOCTL_VOLUME_BASE, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_SET_GPT_ATTRIBUTES \
	CTL_CODE(IOCTL_VOLUME_BASE, 13, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VOLUME_GET_GPT_ATTRIBUTES \
	CTL_CODE(IOCTL_VOLUME_BASE, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif	// (VER_PRODUCTBUILD < 2600)

PCSTR
GetIoControlName(
	ULONG ctrl_code)
{
	static CHAR buf[20];

	switch (ctrl_code) {
	//
	//	VFD control codes
	//
	CASE_RETURN_STR(IOCTL_VFD_OPEN_IMAGE);
	CASE_RETURN_STR(IOCTL_VFD_CLOSE_IMAGE);
	CASE_RETURN_STR(IOCTL_VFD_QUERY_IMAGE);
	CASE_RETURN_STR(IOCTL_VFD_SET_LINK);
	CASE_RETURN_STR(IOCTL_VFD_QUERY_LINK);
	CASE_RETURN_STR(IOCTL_VFD_SET_PROTECT);
	CASE_RETURN_STR(IOCTL_VFD_CLEAR_PROTECT);
	CASE_RETURN_STR(IOCTL_VFD_RESET_MODIFY);
	CASE_RETURN_STR(IOCTL_VFD_QUERY_NUMBER);
	CASE_RETURN_STR(IOCTL_VFD_QUERY_NAME);
	CASE_RETURN_STR(IOCTL_VFD_QUERY_VERSION);

	//
	// Standard control codes
	//
	// mountmgr.h
	CASE_RETURN_STR(IOCTL_MOUNTMGR_CREATE_POINT);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_DELETE_POINTS);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_QUERY_POINTS);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_CHANGE_NOTIFY);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATH);
	CASE_RETURN_STR(IOCTL_MOUNTMGR_QUERY_DOS_VOLUME_PATHS);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_QUERY_DEVICE_NAME);

	// mountdev.h
	CASE_RETURN_STR(IOCTL_MOUNTDEV_QUERY_UNIQUE_ID);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_LINK_CREATED);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_LINK_DELETED);
	CASE_RETURN_STR(IOCTL_MOUNTDEV_QUERY_STABLE_GUID);

	// ntdddisk.h
	CASE_RETURN_STR(IOCTL_DISK_GET_DRIVE_GEOMETRY);
	CASE_RETURN_STR(IOCTL_DISK_GET_PARTITION_INFO);
	CASE_RETURN_STR(IOCTL_DISK_SET_PARTITION_INFO);
	CASE_RETURN_STR(IOCTL_DISK_GET_DRIVE_LAYOUT);
	CASE_RETURN_STR(IOCTL_DISK_SET_DRIVE_LAYOUT);
	CASE_RETURN_STR(IOCTL_DISK_VERIFY);
	CASE_RETURN_STR(IOCTL_DISK_FORMAT_TRACKS);
	CASE_RETURN_STR(IOCTL_DISK_REASSIGN_BLOCKS);
	CASE_RETURN_STR(IOCTL_DISK_PERFORMANCE);
	CASE_RETURN_STR(IOCTL_DISK_IS_WRITABLE);
	CASE_RETURN_STR(IOCTL_DISK_LOGGING);
	CASE_RETURN_STR(IOCTL_DISK_FORMAT_TRACKS_EX);
	CASE_RETURN_STR(IOCTL_DISK_HISTOGRAM_STRUCTURE);
	CASE_RETURN_STR(IOCTL_DISK_HISTOGRAM_DATA);
	CASE_RETURN_STR(IOCTL_DISK_HISTOGRAM_RESET);
	CASE_RETURN_STR(IOCTL_DISK_REQUEST_STRUCTURE);
	CASE_RETURN_STR(IOCTL_DISK_REQUEST_DATA);
	CASE_RETURN_STR(IOCTL_DISK_PERFORMANCE_OFF);
	CASE_RETURN_STR(IOCTL_DISK_CONTROLLER_NUMBER);
	CASE_RETURN_STR(SMART_GET_VERSION);
	CASE_RETURN_STR(SMART_SEND_DRIVE_COMMAND);
	CASE_RETURN_STR(SMART_RCV_DRIVE_DATA);
	CASE_RETURN_STR(IOCTL_DISK_GET_PARTITION_INFO_EX);
	CASE_RETURN_STR(IOCTL_DISK_SET_PARTITION_INFO_EX);
	CASE_RETURN_STR(IOCTL_DISK_GET_DRIVE_LAYOUT_EX);
	CASE_RETURN_STR(IOCTL_DISK_SET_DRIVE_LAYOUT_EX);
	CASE_RETURN_STR(IOCTL_DISK_CREATE_DISK);
	CASE_RETURN_STR(IOCTL_DISK_GET_LENGTH_INFO);
	CASE_RETURN_STR(IOCTL_DISK_GET_DRIVE_GEOMETRY_EX);
	CASE_RETURN_STR(IOCTL_DISK_UPDATE_DRIVE_SIZE);
	CASE_RETURN_STR(IOCTL_DISK_GROW_PARTITION);
	CASE_RETURN_STR(IOCTL_DISK_GET_CACHE_INFORMATION);
	CASE_RETURN_STR(IOCTL_DISK_SET_CACHE_INFORMATION);
#if !defined(__REACTOS__) || (NTDDI_VERSION < NTDDI_WS03)
	CASE_RETURN_STR(IOCTL_DISK_GET_WRITE_CACHE_STATE);
#else
    CASE_RETURN_STR(OBSOLETE_DISK_GET_WRITE_CACHE_STATE);
#endif
	CASE_RETURN_STR(IOCTL_DISK_DELETE_DRIVE_LAYOUT);
	CASE_RETURN_STR(IOCTL_DISK_UPDATE_PROPERTIES);
	CASE_RETURN_STR(IOCTL_DISK_FORMAT_DRIVE);
	CASE_RETURN_STR(IOCTL_DISK_SENSE_DEVICE);
	CASE_RETURN_STR(IOCTL_DISK_INTERNAL_SET_VERIFY);
	CASE_RETURN_STR(IOCTL_DISK_INTERNAL_CLEAR_VERIFY);
	CASE_RETURN_STR(IOCTL_DISK_INTERNAL_SET_NOTIFY);
	CASE_RETURN_STR(IOCTL_DISK_CHECK_VERIFY);
	CASE_RETURN_STR(IOCTL_DISK_MEDIA_REMOVAL);
	CASE_RETURN_STR(IOCTL_DISK_EJECT_MEDIA);
	CASE_RETURN_STR(IOCTL_DISK_LOAD_MEDIA);
	CASE_RETURN_STR(IOCTL_DISK_RESERVE);
	CASE_RETURN_STR(IOCTL_DISK_RELEASE);
	CASE_RETURN_STR(IOCTL_DISK_FIND_NEW_DEVICES);
	CASE_RETURN_STR(IOCTL_DISK_GET_MEDIA_TYPES);
	CASE_RETURN_STR(IOCTL_DISK_SIMBAD);

#ifndef __REACTOS__
	// ntddft.h
	CASE_RETURN_STR(FT_INITIALIZE_SET);
	CASE_RETURN_STR(FT_REGENERATE);
	CASE_RETURN_STR(FT_CONFIGURE);
	CASE_RETURN_STR(FT_VERIFY);
	CASE_RETURN_STR(FT_SECONDARY_READ);
	CASE_RETURN_STR(FT_PRIMARY_READ);
	CASE_RETURN_STR(FT_BALANCED_READ_MODE);
	CASE_RETURN_STR(FT_SYNC_REDUNDANT_COPY);
	CASE_RETURN_STR(FT_SEQUENTIAL_WRITE_MODE);
	CASE_RETURN_STR(FT_PARALLEL_WRITE_MODE);
	CASE_RETURN_STR(FT_QUERY_SET_STATE);
	CASE_RETURN_STR(FT_CLUSTER_SET_MEMBER_STATE);
	CASE_RETURN_STR(FT_CLUSTER_GET_MEMBER_STATE);

	// ntddft2.h
	CASE_RETURN_STR(FT_CREATE_LOGICAL_DISK);
	CASE_RETURN_STR(FT_BREAK_LOGICAL_DISK);
	CASE_RETURN_STR(FT_ENUMERATE_LOGICAL_DISKS);
	CASE_RETURN_STR(FT_QUERY_LOGICAL_DISK_INFORMATION);
	CASE_RETURN_STR(FT_ORPHAN_LOGICAL_DISK_MEMBER);
	CASE_RETURN_STR(FT_REPLACE_LOGICAL_DISK_MEMBER);
	CASE_RETURN_STR(FT_QUERY_NT_DEVICE_NAME_FOR_LOGICAL_DISK);
	CASE_RETURN_STR(FT_INITIALIZE_LOGICAL_DISK);
	CASE_RETURN_STR(FT_QUERY_DRIVE_LETTER_FOR_LOGICAL_DISK);
	CASE_RETURN_STR(FT_CHECK_IO);
	CASE_RETURN_STR(FT_SET_DRIVE_LETTER_FOR_LOGICAL_DISK);
	CASE_RETURN_STR(FT_QUERY_NT_DEVICE_NAME_FOR_PARTITION);
	CASE_RETURN_STR(FT_CHANGE_NOTIFY);
	CASE_RETURN_STR(FT_STOP_SYNC_OPERATIONS);
	CASE_RETURN_STR(FT_QUERY_LOGICAL_DISK_ID);
	CASE_RETURN_STR(FT_CREATE_PARTITION_LOGICAL_DISK);
#endif

	// ntddstor.h
	CASE_RETURN_STR(IOCTL_STORAGE_CHECK_VERIFY);
	CASE_RETURN_STR(IOCTL_STORAGE_CHECK_VERIFY2);
	CASE_RETURN_STR(IOCTL_STORAGE_MEDIA_REMOVAL);
	CASE_RETURN_STR(IOCTL_STORAGE_EJECT_MEDIA);
	CASE_RETURN_STR(IOCTL_STORAGE_LOAD_MEDIA);
	CASE_RETURN_STR(IOCTL_STORAGE_LOAD_MEDIA2);
	CASE_RETURN_STR(IOCTL_STORAGE_RESERVE);
	CASE_RETURN_STR(IOCTL_STORAGE_RELEASE);
	CASE_RETURN_STR(IOCTL_STORAGE_FIND_NEW_DEVICES);
	CASE_RETURN_STR(IOCTL_STORAGE_EJECTION_CONTROL);
	CASE_RETURN_STR(IOCTL_STORAGE_MCN_CONTROL);
	CASE_RETURN_STR(IOCTL_STORAGE_GET_MEDIA_TYPES);
	CASE_RETURN_STR(IOCTL_STORAGE_GET_MEDIA_TYPES_EX);
	CASE_RETURN_STR(IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER);
	CASE_RETURN_STR(IOCTL_STORAGE_GET_HOTPLUG_INFO);
	CASE_RETURN_STR(IOCTL_STORAGE_SET_HOTPLUG_INFO);
	CASE_RETURN_STR(IOCTL_STORAGE_RESET_BUS);
	CASE_RETURN_STR(IOCTL_STORAGE_RESET_DEVICE);
	CASE_RETURN_STR(IOCTL_STORAGE_BREAK_RESERVATION);
	CASE_RETURN_STR(IOCTL_STORAGE_GET_DEVICE_NUMBER);
	CASE_RETURN_STR(IOCTL_STORAGE_PREDICT_FAILURE);
	CASE_RETURN_STR(IOCTL_STORAGE_QUERY_PROPERTY);
	CASE_RETURN_STR(OBSOLETE_IOCTL_STORAGE_RESET_BUS);
	CASE_RETURN_STR(OBSOLETE_IOCTL_STORAGE_RESET_DEVICE);

	// ntddvol.h
	CASE_RETURN_STR(IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS);
	CASE_RETURN_STR(IOCTL_VOLUME_IS_CLUSTERED);
	CASE_RETURN_STR(IOCTL_VOLUME_SUPPORTS_ONLINE_OFFLINE);
	CASE_RETURN_STR(IOCTL_VOLUME_ONLINE);
	CASE_RETURN_STR(IOCTL_VOLUME_OFFLINE);
	CASE_RETURN_STR(IOCTL_VOLUME_IS_OFFLINE);
	CASE_RETURN_STR(IOCTL_VOLUME_IS_IO_CAPABLE);
	CASE_RETURN_STR(IOCTL_VOLUME_QUERY_FAILOVER_SET);
	CASE_RETURN_STR(IOCTL_VOLUME_QUERY_VOLUME_NUMBER);
	CASE_RETURN_STR(IOCTL_VOLUME_LOGICAL_TO_PHYSICAL);
	CASE_RETURN_STR(IOCTL_VOLUME_PHYSICAL_TO_LOGICAL);
	CASE_RETURN_STR(IOCTL_VOLUME_IS_PARTITION);
	CASE_RETURN_STR(IOCTL_VOLUME_READ_PLEX);
	CASE_RETURN_STR(IOCTL_VOLUME_SET_GPT_ATTRIBUTES);
	CASE_RETURN_STR(IOCTL_VOLUME_GET_GPT_ATTRIBUTES);

	default:
		buf[sizeof(buf) - 1] = '\0';
		_snprintf(buf, sizeof(buf) - 1,
		// sprintf(buf,
			"Unknown IOCTL: 0x%08x", ctrl_code);
		return buf;
	}
}

#if (VER_PRODUCTBUILD < 2195)
//
// from new <ntstatus.h>
//
#define FACILITY_USB_ERROR_CODE					0x10
#define FACILITY_TERMINAL_SERVER				0xA
#define FACILITY_HID_ERROR_CODE					0x11
#define FACILITY_FIREWIRE_ERROR_CODE			0x12
#define FACILITY_DEBUGGER						0x1
#define FACILITY_CLUSTER_ERROR_CODE				0x13
#define FACILITY_ACPI_ERROR_CODE				0x14
#define STATUS_RESOURCE_REQUIREMENTS_CHANGED	((NTSTATUS)0x00000119L)
#define STATUS_TRANSLATION_COMPLETE				((NTSTATUS)0x00000120L)
#define STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY	((NTSTATUS)0x00000121L)
#define DBG_EXCEPTION_HANDLED					((NTSTATUS)0x00010001L)
#define DBG_CONTINUE							((NTSTATUS)0x00010002L)
#define STATUS_ARBITRATION_UNHANDLED			((NTSTATUS)0x40000026L)
#define STATUS_CARDBUS_NOT_SUPPORTED			((NTSTATUS)0x40000027L)
#define STATUS_WX86_CREATEWX86TIB				((NTSTATUS)0x40000028L)
#define STATUS_MP_PROCESSOR_MISMATCH			((NTSTATUS)0x40000029L)
#define DBG_REPLY_LATER							((NTSTATUS)0x40010001L)
#define DBG_UNABLE_TO_PROVIDE_HANDLE			((NTSTATUS)0x40010002L)
#define DBG_TERMINATE_THREAD					((NTSTATUS)0x40010003L)
#define DBG_TERMINATE_PROCESS					((NTSTATUS)0x40010004L)
#define DBG_CONTROL_C							((NTSTATUS)0x40010005L)
#define DBG_PRINTEXCEPTION_C					((NTSTATUS)0x40010006L)
#define DBG_RIPEXCEPTION						((NTSTATUS)0x40010007L)
#define DBG_CONTROL_BREAK						((NTSTATUS)0x40010008L)
#define DBG_EXCEPTION_NOT_HANDLED				((NTSTATUS)0x80010001L)
#define STATUS_VALIDATE_CONTINUE				((NTSTATUS)0xC0000271L)
#define STATUS_NO_MATCH							((NTSTATUS)0xC0000272L)
#define STATUS_NO_MORE_MATCHES					((NTSTATUS)0xC0000273L)
#define STATUS_NOT_A_REPARSE_POINT				((NTSTATUS)0xC0000275L)
#define STATUS_IO_REPARSE_TAG_INVALID			((NTSTATUS)0xC0000276L)
#define STATUS_IO_REPARSE_TAG_MISMATCH			((NTSTATUS)0xC0000277L)
#define STATUS_IO_REPARSE_DATA_INVALID			((NTSTATUS)0xC0000278L)
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED		((NTSTATUS)0xC0000279L)
#define STATUS_REPARSE_POINT_NOT_RESOLVED		((NTSTATUS)0xC0000280L)
#define STATUS_DIRECTORY_IS_A_REPARSE_POINT		((NTSTATUS)0xC0000281L)
#define STATUS_RANGE_LIST_CONFLICT				((NTSTATUS)0xC0000282L)
#define STATUS_SOURCE_ELEMENT_EMPTY				((NTSTATUS)0xC0000283L)
#define STATUS_DESTINATION_ELEMENT_FULL			((NTSTATUS)0xC0000284L)
#define STATUS_ILLEGAL_ELEMENT_ADDRESS			((NTSTATUS)0xC0000285L)
#define STATUS_MAGAZINE_NOT_PRESENT				((NTSTATUS)0xC0000286L)
#define STATUS_REINITIALIZATION_NEEDED			((NTSTATUS)0xC0000287L)
#define STATUS_DEVICE_REQUIRES_CLEANING			((NTSTATUS)0x80000288L)
#define STATUS_DEVICE_DOOR_OPEN					((NTSTATUS)0x80000289L)
#define STATUS_ENCRYPTION_FAILED				((NTSTATUS)0xC000028AL)
#define STATUS_DECRYPTION_FAILED				((NTSTATUS)0xC000028BL)
#define STATUS_RANGE_NOT_FOUND					((NTSTATUS)0xC000028CL)
#define STATUS_NO_RECOVERY_POLICY				((NTSTATUS)0xC000028DL)
#define STATUS_NO_EFS							((NTSTATUS)0xC000028EL)
#define STATUS_WRONG_EFS						((NTSTATUS)0xC000028FL)
#define STATUS_NO_USER_KEYS						((NTSTATUS)0xC0000290L)
#define STATUS_FILE_NOT_ENCRYPTED				((NTSTATUS)0xC0000291L)
#define STATUS_NOT_EXPORT_FORMAT				((NTSTATUS)0xC0000292L)
#define STATUS_FILE_ENCRYPTED					((NTSTATUS)0xC0000293L)
#define STATUS_WAKE_SYSTEM						((NTSTATUS)0x40000294L)
#define STATUS_WMI_GUID_NOT_FOUND				((NTSTATUS)0xC0000295L)
#define STATUS_WMI_INSTANCE_NOT_FOUND			((NTSTATUS)0xC0000296L)
#define STATUS_WMI_ITEMID_NOT_FOUND				((NTSTATUS)0xC0000297L)
#define STATUS_WMI_TRY_AGAIN					((NTSTATUS)0xC0000298L)
#define STATUS_SHARED_POLICY					((NTSTATUS)0xC0000299L)
#define STATUS_POLICY_OBJECT_NOT_FOUND			((NTSTATUS)0xC000029AL)
#define STATUS_POLICY_ONLY_IN_DS				((NTSTATUS)0xC000029BL)
#define STATUS_VOLUME_NOT_UPGRADED				((NTSTATUS)0xC000029CL)
#define STATUS_REMOTE_STORAGE_NOT_ACTIVE		((NTSTATUS)0xC000029DL)
#define STATUS_REMOTE_STORAGE_MEDIA_ERROR		((NTSTATUS)0xC000029EL)
#define STATUS_NO_TRACKING_SERVICE				((NTSTATUS)0xC000029FL)
#define STATUS_SERVER_SID_MISMATCH				((NTSTATUS)0xC00002A0L)
#define STATUS_DS_NO_ATTRIBUTE_OR_VALUE			((NTSTATUS)0xC00002A1L)
#define STATUS_DS_INVALID_ATTRIBUTE_SYNTAX		((NTSTATUS)0xC00002A2L)
#define STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED		((NTSTATUS)0xC00002A3L)
#define STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS		((NTSTATUS)0xC00002A4L)
#define STATUS_DS_BUSY							((NTSTATUS)0xC00002A5L)
#define STATUS_DS_UNAVAILABLE					((NTSTATUS)0xC00002A6L)
#define STATUS_DS_NO_RIDS_ALLOCATED				((NTSTATUS)0xC00002A7L)
#define STATUS_DS_NO_MORE_RIDS					((NTSTATUS)0xC00002A8L)
#define STATUS_DS_INCORRECT_ROLE_OWNER			((NTSTATUS)0xC00002A9L)
#define STATUS_DS_RIDMGR_INIT_ERROR				((NTSTATUS)0xC00002AAL)
#define STATUS_DS_OBJ_CLASS_VIOLATION			((NTSTATUS)0xC00002ABL)
#define STATUS_DS_CANT_ON_NON_LEAF				((NTSTATUS)0xC00002ACL)
#define STATUS_DS_CANT_ON_RDN					((NTSTATUS)0xC00002ADL)
#define STATUS_DS_CANT_MOD_OBJ_CLASS			((NTSTATUS)0xC00002AEL)
#define STATUS_DS_CROSS_DOM_MOVE_FAILED			((NTSTATUS)0xC00002AFL)
#define STATUS_DS_GC_NOT_AVAILABLE				((NTSTATUS)0xC00002B0L)
#define STATUS_DIRECTORY_SERVICE_REQUIRED		((NTSTATUS)0xC00002B1L)
#define STATUS_REPARSE_ATTRIBUTE_CONFLICT		((NTSTATUS)0xC00002B2L)
#define STATUS_CANT_ENABLE_DENY_ONLY			((NTSTATUS)0xC00002B3L)
#define STATUS_FLOAT_MULTIPLE_FAULTS			((NTSTATUS)0xC00002B4L)
#define STATUS_FLOAT_MULTIPLE_TRAPS				((NTSTATUS)0xC00002B5L)
#define STATUS_DEVICE_REMOVED					((NTSTATUS)0xC00002B6L)
#define STATUS_JOURNAL_DELETE_IN_PROGRESS		((NTSTATUS)0xC00002B7L)
#define STATUS_JOURNAL_NOT_ACTIVE				((NTSTATUS)0xC00002B8L)
#define STATUS_NOINTERFACE						((NTSTATUS)0xC00002B9L)
#define STATUS_DS_ADMIN_LIMIT_EXCEEDED			((NTSTATUS)0xC00002C1L)
#define STATUS_DRIVER_FAILED_SLEEP				((NTSTATUS)0xC00002C2L)
#define STATUS_MUTUAL_AUTHENTICATION_FAILED		((NTSTATUS)0xC00002C3L)
#define STATUS_CORRUPT_SYSTEM_FILE				((NTSTATUS)0xC00002C4L)
#define STATUS_DATATYPE_MISALIGNMENT_ERROR		((NTSTATUS)0xC00002C5L)
#define STATUS_WMI_READ_ONLY					((NTSTATUS)0xC00002C6L)
#define STATUS_WMI_SET_FAILURE					((NTSTATUS)0xC00002C7L)
#define STATUS_COMMITMENT_MINIMUM				((NTSTATUS)0xC00002C8L)
#define STATUS_REG_NAT_CONSUMPTION				((NTSTATUS)0xC00002C9L)
#define STATUS_TRANSPORT_FULL					((NTSTATUS)0xC00002CAL)
#define STATUS_DS_SAM_INIT_FAILURE				((NTSTATUS)0xC00002CBL)
#define STATUS_ONLY_IF_CONNECTED				((NTSTATUS)0xC00002CCL)
#define STATUS_DS_SENSITIVE_GROUP_VIOLATION		((NTSTATUS)0xC00002CDL)
#define STATUS_PNP_RESTART_ENUMERATION			((NTSTATUS)0xC00002CEL)
#define STATUS_JOURNAL_ENTRY_DELETED			((NTSTATUS)0xC00002CFL)
#define STATUS_DS_CANT_MOD_PRIMARYGROUPID		((NTSTATUS)0xC00002D0L)
#define STATUS_SYSTEM_IMAGE_BAD_SIGNATURE		((NTSTATUS)0xC00002D1L)
#define STATUS_PNP_REBOOT_REQUIRED				((NTSTATUS)0xC00002D2L)
#define STATUS_POWER_STATE_INVALID				((NTSTATUS)0xC00002D3L)
#define STATUS_DS_INVALID_GROUP_TYPE			((NTSTATUS)0xC00002D4L)
#define STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN	((NTSTATUS)0xC00002D5L)
#define STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN		((NTSTATUS)0xC00002D6L)
#define STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER			((NTSTATUS)0xC00002D7L)
#define STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER		((NTSTATUS)0xC00002D8L)
#define STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER		((NTSTATUS)0xC00002D9L)
#define STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER	((NTSTATUS)0xC00002DAL)
#define STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER	((NTSTATUS)0xC00002DBL)
#define STATUS_DS_HAVE_PRIMARY_MEMBERS			((NTSTATUS)0xC00002DCL)
#define STATUS_WMI_NOT_SUPPORTED				((NTSTATUS)0xC00002DDL)
#define STATUS_INSUFFICIENT_POWER				((NTSTATUS)0xC00002DEL)
#define STATUS_SAM_NEED_BOOTKEY_PASSWORD		((NTSTATUS)0xC00002DFL)
#define STATUS_SAM_NEED_BOOTKEY_FLOPPY			((NTSTATUS)0xC00002E0L)
#define STATUS_DS_CANT_START					((NTSTATUS)0xC00002E1L)
#define STATUS_DS_INIT_FAILURE					((NTSTATUS)0xC00002E2L)
#define STATUS_SAM_INIT_FAILURE					((NTSTATUS)0xC00002E3L)
#define STATUS_DS_GC_REQUIRED					((NTSTATUS)0xC00002E4L)
#define STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY	((NTSTATUS)0xC00002E5L)
#define STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS	((NTSTATUS)0xC00002E6L)
#define STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED	((NTSTATUS)0xC00002E7L)
#define STATUS_MULTIPLE_FAULT_VIOLATION			((NTSTATUS)0xC00002E8L)
#define STATUS_NOT_SUPPORTED_ON_SBS				((NTSTATUS)0xC0000300L)
#define DBG_NO_STATE_CHANGE						((NTSTATUS)0xC0010001L)
#define DBG_APP_NOT_IDLE						((NTSTATUS)0xC0010002L)
#define RPC_NT_PIPE_CLOSED						((NTSTATUS)0xC003005FL)
#define RPC_NT_PIPE_DISCIPLINE_ERROR			((NTSTATUS)0xC0030060L)
#define RPC_NT_PIPE_EMPTY						((NTSTATUS)0xC0030061L)
#define RPC_NT_INVALID_ASYNC_HANDLE				((NTSTATUS)0xC0020062L)
#define RPC_NT_INVALID_ASYNC_CALL				((NTSTATUS)0xC0020063L)
#define STATUS_ACPI_INVALID_OPCODE				((NTSTATUS)0xC0140001L)
#define STATUS_ACPI_STACK_OVERFLOW				((NTSTATUS)0xC0140002L)
#define STATUS_ACPI_ASSERT_FAILED				((NTSTATUS)0xC0140003L)
#define STATUS_ACPI_INVALID_INDEX				((NTSTATUS)0xC0140004L)
#define STATUS_ACPI_INVALID_ARGUMENT			((NTSTATUS)0xC0140005L)
#define STATUS_ACPI_FATAL						((NTSTATUS)0xC0140006L)
#define STATUS_ACPI_INVALID_SUPERNAME			((NTSTATUS)0xC0140007L)
#define STATUS_ACPI_INVALID_ARGTYPE				((NTSTATUS)0xC0140008L)
#define STATUS_ACPI_INVALID_OBJTYPE				((NTSTATUS)0xC0140009L)
#define STATUS_ACPI_INVALID_TARGETTYPE			((NTSTATUS)0xC014000AL)
#define STATUS_ACPI_INCORRECT_ARGUMENT_COUNT	((NTSTATUS)0xC014000BL)
#define STATUS_ACPI_ADDRESS_NOT_MAPPED			((NTSTATUS)0xC014000CL)
#define STATUS_ACPI_INVALID_EVENTTYPE			((NTSTATUS)0xC014000DL)
#define STATUS_ACPI_HANDLER_COLLISION			((NTSTATUS)0xC014000EL)
#define STATUS_ACPI_INVALID_DATA				((NTSTATUS)0xC014000FL)
#define STATUS_ACPI_INVALID_REGION				((NTSTATUS)0xC0140010L)
#define STATUS_ACPI_INVALID_ACCESS_SIZE			((NTSTATUS)0xC0140011L)
#define STATUS_ACPI_ACQUIRE_GLOBAL_LOCK			((NTSTATUS)0xC0140012L)
#define STATUS_ACPI_ALREADY_INITIALIZED			((NTSTATUS)0xC0140013L)
#define STATUS_ACPI_NOT_INITIALIZED				((NTSTATUS)0xC0140014L)
#define STATUS_ACPI_INVALID_MUTEX_LEVEL			((NTSTATUS)0xC0140015L)
#define STATUS_ACPI_MUTEX_NOT_OWNED				((NTSTATUS)0xC0140016L)
#define STATUS_ACPI_MUTEX_NOT_OWNER				((NTSTATUS)0xC0140017L)
#define STATUS_ACPI_RS_ACCESS					((NTSTATUS)0xC0140018L)
#define STATUS_ACPI_INVALID_TABLE				((NTSTATUS)0xC0140019L)
#define STATUS_ACPI_REG_HANDLER_FAILED			((NTSTATUS)0xC0140020L)
#define STATUS_ACPI_POWER_REQUEST_FAILED		((NTSTATUS)0xC0140021L)
#define STATUS_CTX_WINSTATION_NAME_INVALID		((NTSTATUS)0xC00A0001L)
#define STATUS_CTX_INVALID_PD					((NTSTATUS)0xC00A0002L)
#define STATUS_CTX_PD_NOT_FOUND					((NTSTATUS)0xC00A0003L)
#define STATUS_CTX_CDM_CONNECT					((NTSTATUS)0x400A0004L)
#define STATUS_CTX_CDM_DISCONNECT				((NTSTATUS)0x400A0005L)
#define STATUS_CTX_CLOSE_PENDING				((NTSTATUS)0xC00A0006L)
#define STATUS_CTX_NO_OUTBUF					((NTSTATUS)0xC00A0007L)
#define STATUS_CTX_MODEM_INF_NOT_FOUND			((NTSTATUS)0xC00A0008L)
#define STATUS_CTX_INVALID_MODEMNAME			((NTSTATUS)0xC00A0009L)
#define STATUS_CTX_RESPONSE_ERROR				((NTSTATUS)0xC00A000AL)
#define STATUS_CTX_MODEM_RESPONSE_TIMEOUT		((NTSTATUS)0xC00A000BL)
#define STATUS_CTX_MODEM_RESPONSE_NO_CARRIER	((NTSTATUS)0xC00A000CL)
#define STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE	((NTSTATUS)0xC00A000DL)
#define STATUS_CTX_MODEM_RESPONSE_BUSY			((NTSTATUS)0xC00A000EL)
#define STATUS_CTX_MODEM_RESPONSE_VOICE			((NTSTATUS)0xC00A000FL)
#define STATUS_CTX_TD_ERROR						((NTSTATUS)0xC00A0010L)
#define STATUS_CTX_LICENSE_CLIENT_INVALID		((NTSTATUS)0xC00A0012L)
#define STATUS_CTX_LICENSE_NOT_AVAILABLE		((NTSTATUS)0xC00A0013L)
#define STATUS_CTX_LICENSE_EXPIRED				((NTSTATUS)0xC00A0014L)
#define STATUS_CTX_WINSTATION_NOT_FOUND			((NTSTATUS)0xC00A0015L)
#define STATUS_CTX_WINSTATION_NAME_COLLISION	((NTSTATUS)0xC00A0016L)
#define STATUS_CTX_WINSTATION_BUSY				((NTSTATUS)0xC00A0017L)
#define STATUS_CTX_BAD_VIDEO_MODE				((NTSTATUS)0xC00A0018L)
#define STATUS_CTX_GRAPHICS_INVALID				((NTSTATUS)0xC00A0022L)
#define STATUS_CTX_NOT_CONSOLE					((NTSTATUS)0xC00A0024L)
#define STATUS_CTX_CLIENT_QUERY_TIMEOUT			((NTSTATUS)0xC00A0026L)
#define STATUS_CTX_CONSOLE_DISCONNECT			((NTSTATUS)0xC00A0027L)
#define STATUS_CTX_CONSOLE_CONNECT				((NTSTATUS)0xC00A0028L)
#define STATUS_CTX_SHADOW_DENIED				((NTSTATUS)0xC00A002AL)
#define STATUS_CTX_WINSTATION_ACCESS_DENIED		((NTSTATUS)0xC00A002BL)
#define STATUS_CTX_INVALID_WD					((NTSTATUS)0xC00A002EL)
#define STATUS_CTX_WD_NOT_FOUND					((NTSTATUS)0xC00A002FL)
#define STATUS_CTX_SHADOW_INVALID				((NTSTATUS)0xC00A0030L)
#define STATUS_CTX_SHADOW_DISABLED				((NTSTATUS)0xC00A0031L)
#define STATUS_RDP_PROTOCOL_ERROR				((NTSTATUS)0xC00A0032L)
#define STATUS_CTX_CLIENT_LICENSE_NOT_SET		((NTSTATUS)0xC00A0033L)
#define STATUS_CTX_CLIENT_LICENSE_IN_USE		((NTSTATUS)0xC00A0034L)
#define STATUS_PNP_BAD_MPS_TABLE				((NTSTATUS)0xC0040035L)
#define STATUS_PNP_TRANSLATION_FAILED			((NTSTATUS)0xC0040036L)
#define STATUS_PNP_IRQ_TRANSLATION_FAILED		((NTSTATUS)0xC0040037L)
#endif	// VER_PRODUCTBUILD < 2195

static PCSTR
NtStatusToStr(
	NTSTATUS status);

PCSTR
GetStatusName(
	NTSTATUS			status)
{
	static CHAR	statusName[80];
	CHAR severity;

	switch (status & 0xf0000000) {
	case 0x00000000:	severity = 'S';	break;
	case 0x40000000:	severity = 'I';	break;
	case 0x80000000:	severity = 'W';	break;
	case 0xC0000000:	severity = 'E';	break;
	default:			severity = '?';
	}

	statusName[sizeof(statusName) - 1] = '\0';
	_snprintf(statusName, sizeof(statusName) - 1,
	// sprintf(statusName,
		"(%c)%s", severity, NtStatusToStr(status));

	return statusName;
}

PCSTR
NtStatusToStr(
	NTSTATUS status)
{
	switch (status) {
	CASE_RETURN_STR(STATUS_SUCCESS);
/*
	CASE_RETURN_STR(STATUS_WAIT_0);
*/
	CASE_RETURN_STR(STATUS_WAIT_1);
	CASE_RETURN_STR(STATUS_WAIT_2);
	CASE_RETURN_STR(STATUS_WAIT_3);
	CASE_RETURN_STR(STATUS_WAIT_63);
	CASE_RETURN_STR(STATUS_ABANDONED);
/*
	CASE_RETURN_STR(STATUS_ABANDONED_WAIT_0);
*/
	CASE_RETURN_STR(STATUS_ABANDONED_WAIT_63);
	CASE_RETURN_STR(STATUS_USER_APC);
	CASE_RETURN_STR(STATUS_KERNEL_APC);
	CASE_RETURN_STR(STATUS_ALERTED);
	CASE_RETURN_STR(STATUS_TIMEOUT);
	CASE_RETURN_STR(STATUS_PENDING);
	CASE_RETURN_STR(STATUS_REPARSE);
	CASE_RETURN_STR(STATUS_MORE_ENTRIES);
	CASE_RETURN_STR(STATUS_NOT_ALL_ASSIGNED);
	CASE_RETURN_STR(STATUS_SOME_NOT_MAPPED);
	CASE_RETURN_STR(STATUS_OPLOCK_BREAK_IN_PROGRESS);
	CASE_RETURN_STR(STATUS_VOLUME_MOUNTED);
	CASE_RETURN_STR(STATUS_RXACT_COMMITTED);
	CASE_RETURN_STR(STATUS_NOTIFY_CLEANUP);
	CASE_RETURN_STR(STATUS_NOTIFY_ENUM_DIR);
	CASE_RETURN_STR(STATUS_NO_QUOTAS_FOR_ACCOUNT);
	CASE_RETURN_STR(STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED);
	CASE_RETURN_STR(STATUS_PAGE_FAULT_TRANSITION);
	CASE_RETURN_STR(STATUS_PAGE_FAULT_DEMAND_ZERO);
	CASE_RETURN_STR(STATUS_PAGE_FAULT_COPY_ON_WRITE);
	CASE_RETURN_STR(STATUS_PAGE_FAULT_GUARD_PAGE);
	CASE_RETURN_STR(STATUS_PAGE_FAULT_PAGING_FILE);
	CASE_RETURN_STR(STATUS_CACHE_PAGE_LOCKED);
	CASE_RETURN_STR(STATUS_CRASH_DUMP);
	CASE_RETURN_STR(STATUS_BUFFER_ALL_ZEROS);
	CASE_RETURN_STR(STATUS_REPARSE_OBJECT);
	CASE_RETURN_STR(STATUS_RESOURCE_REQUIREMENTS_CHANGED);
	CASE_RETURN_STR(STATUS_TRANSLATION_COMPLETE);
	CASE_RETURN_STR(STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY);
	CASE_RETURN_STR(DBG_EXCEPTION_HANDLED);
	CASE_RETURN_STR(DBG_CONTINUE);
	CASE_RETURN_STR(STATUS_OBJECT_NAME_EXISTS);
	CASE_RETURN_STR(STATUS_THREAD_WAS_SUSPENDED);
	CASE_RETURN_STR(STATUS_WORKING_SET_LIMIT_RANGE);
	CASE_RETURN_STR(STATUS_IMAGE_NOT_AT_BASE);
	CASE_RETURN_STR(STATUS_RXACT_STATE_CREATED);
	CASE_RETURN_STR(STATUS_SEGMENT_NOTIFICATION);
	CASE_RETURN_STR(STATUS_LOCAL_USER_SESSION_KEY);
	CASE_RETURN_STR(STATUS_BAD_CURRENT_DIRECTORY);
	CASE_RETURN_STR(STATUS_SERIAL_MORE_WRITES);
	CASE_RETURN_STR(STATUS_REGISTRY_RECOVERED);
	CASE_RETURN_STR(STATUS_FT_READ_RECOVERY_FROM_BACKUP);
	CASE_RETURN_STR(STATUS_FT_WRITE_RECOVERY);
	CASE_RETURN_STR(STATUS_SERIAL_COUNTER_TIMEOUT);
	CASE_RETURN_STR(STATUS_NULL_LM_PASSWORD);
	CASE_RETURN_STR(STATUS_IMAGE_MACHINE_TYPE_MISMATCH);
	CASE_RETURN_STR(STATUS_RECEIVE_PARTIAL);
	CASE_RETURN_STR(STATUS_RECEIVE_EXPEDITED);
	CASE_RETURN_STR(STATUS_RECEIVE_PARTIAL_EXPEDITED);
	CASE_RETURN_STR(STATUS_EVENT_DONE);
	CASE_RETURN_STR(STATUS_EVENT_PENDING);
	CASE_RETURN_STR(STATUS_CHECKING_FILE_SYSTEM);
	CASE_RETURN_STR(STATUS_FATAL_APP_EXIT);
	CASE_RETURN_STR(STATUS_PREDEFINED_HANDLE);
	CASE_RETURN_STR(STATUS_WAS_UNLOCKED);
	CASE_RETURN_STR(STATUS_SERVICE_NOTIFICATION);
	CASE_RETURN_STR(STATUS_WAS_LOCKED);
	CASE_RETURN_STR(STATUS_LOG_HARD_ERROR);
	CASE_RETURN_STR(STATUS_ALREADY_WIN32);
	CASE_RETURN_STR(STATUS_WX86_UNSIMULATE);
	CASE_RETURN_STR(STATUS_WX86_CONTINUE);
	CASE_RETURN_STR(STATUS_WX86_SINGLE_STEP);
	CASE_RETURN_STR(STATUS_WX86_BREAKPOINT);
	CASE_RETURN_STR(STATUS_WX86_EXCEPTION_CONTINUE);
	CASE_RETURN_STR(STATUS_WX86_EXCEPTION_LASTCHANCE);
	CASE_RETURN_STR(STATUS_WX86_EXCEPTION_CHAIN);
	CASE_RETURN_STR(STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE);
	CASE_RETURN_STR(STATUS_NO_YIELD_PERFORMED);
	CASE_RETURN_STR(STATUS_TIMER_RESUME_IGNORED);
	CASE_RETURN_STR(STATUS_ARBITRATION_UNHANDLED);
	CASE_RETURN_STR(STATUS_CARDBUS_NOT_SUPPORTED);
	CASE_RETURN_STR(STATUS_WX86_CREATEWX86TIB);
	CASE_RETURN_STR(STATUS_MP_PROCESSOR_MISMATCH);
	CASE_RETURN_STR(DBG_REPLY_LATER);
	CASE_RETURN_STR(DBG_UNABLE_TO_PROVIDE_HANDLE);
	CASE_RETURN_STR(DBG_TERMINATE_THREAD);
	CASE_RETURN_STR(DBG_TERMINATE_PROCESS);
	CASE_RETURN_STR(DBG_CONTROL_C);
	CASE_RETURN_STR(DBG_PRINTEXCEPTION_C);
	CASE_RETURN_STR(DBG_RIPEXCEPTION);
	CASE_RETURN_STR(DBG_CONTROL_BREAK);
	CASE_RETURN_STR(STATUS_GUARD_PAGE_VIOLATION);
	CASE_RETURN_STR(STATUS_DATATYPE_MISALIGNMENT);
	CASE_RETURN_STR(STATUS_BREAKPOINT);
	CASE_RETURN_STR(STATUS_SINGLE_STEP);
	CASE_RETURN_STR(STATUS_BUFFER_OVERFLOW);
	CASE_RETURN_STR(STATUS_NO_MORE_FILES);
	CASE_RETURN_STR(STATUS_WAKE_SYSTEM_DEBUGGER);
	CASE_RETURN_STR(STATUS_HANDLES_CLOSED);
	CASE_RETURN_STR(STATUS_NO_INHERITANCE);
	CASE_RETURN_STR(STATUS_GUID_SUBSTITUTION_MADE);
	CASE_RETURN_STR(STATUS_PARTIAL_COPY);
	CASE_RETURN_STR(STATUS_DEVICE_PAPER_EMPTY);
	CASE_RETURN_STR(STATUS_DEVICE_POWERED_OFF);
	CASE_RETURN_STR(STATUS_DEVICE_OFF_LINE);
	CASE_RETURN_STR(STATUS_DEVICE_BUSY);
	CASE_RETURN_STR(STATUS_NO_MORE_EAS);
	CASE_RETURN_STR(STATUS_INVALID_EA_NAME);
	CASE_RETURN_STR(STATUS_EA_LIST_INCONSISTENT);
	CASE_RETURN_STR(STATUS_INVALID_EA_FLAG);
	CASE_RETURN_STR(STATUS_VERIFY_REQUIRED);
	CASE_RETURN_STR(STATUS_EXTRANEOUS_INFORMATION);
	CASE_RETURN_STR(STATUS_RXACT_COMMIT_NECESSARY);
	CASE_RETURN_STR(STATUS_NO_MORE_ENTRIES);
	CASE_RETURN_STR(STATUS_FILEMARK_DETECTED);
	CASE_RETURN_STR(STATUS_MEDIA_CHANGED);
	CASE_RETURN_STR(STATUS_BUS_RESET);
	CASE_RETURN_STR(STATUS_END_OF_MEDIA);
	CASE_RETURN_STR(STATUS_BEGINNING_OF_MEDIA);
	CASE_RETURN_STR(STATUS_MEDIA_CHECK);
	CASE_RETURN_STR(STATUS_SETMARK_DETECTED);
	CASE_RETURN_STR(STATUS_NO_DATA_DETECTED);
	CASE_RETURN_STR(STATUS_REDIRECTOR_HAS_OPEN_HANDLES);
	CASE_RETURN_STR(STATUS_SERVER_HAS_OPEN_HANDLES);
	CASE_RETURN_STR(STATUS_ALREADY_DISCONNECTED);
	CASE_RETURN_STR(STATUS_LONGJUMP);
	CASE_RETURN_STR(DBG_EXCEPTION_NOT_HANDLED);
	CASE_RETURN_STR(STATUS_UNSUCCESSFUL);
	CASE_RETURN_STR(STATUS_NOT_IMPLEMENTED);
	CASE_RETURN_STR(STATUS_INVALID_INFO_CLASS);
	CASE_RETURN_STR(STATUS_INFO_LENGTH_MISMATCH);
	CASE_RETURN_STR(STATUS_ACCESS_VIOLATION);
	CASE_RETURN_STR(STATUS_IN_PAGE_ERROR);
	CASE_RETURN_STR(STATUS_PAGEFILE_QUOTA);
	CASE_RETURN_STR(STATUS_INVALID_HANDLE);
	CASE_RETURN_STR(STATUS_BAD_INITIAL_STACK);
	CASE_RETURN_STR(STATUS_BAD_INITIAL_PC);
	CASE_RETURN_STR(STATUS_INVALID_CID);
	CASE_RETURN_STR(STATUS_TIMER_NOT_CANCELED);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER);
	CASE_RETURN_STR(STATUS_NO_SUCH_DEVICE);
	CASE_RETURN_STR(STATUS_NO_SUCH_FILE);
	CASE_RETURN_STR(STATUS_INVALID_DEVICE_REQUEST);
	CASE_RETURN_STR(STATUS_END_OF_FILE);
	CASE_RETURN_STR(STATUS_WRONG_VOLUME);
	CASE_RETURN_STR(STATUS_NO_MEDIA_IN_DEVICE);
	CASE_RETURN_STR(STATUS_UNRECOGNIZED_MEDIA);
	CASE_RETURN_STR(STATUS_NONEXISTENT_SECTOR);
	CASE_RETURN_STR(STATUS_MORE_PROCESSING_REQUIRED);
	CASE_RETURN_STR(STATUS_NO_MEMORY);
	CASE_RETURN_STR(STATUS_CONFLICTING_ADDRESSES);
	CASE_RETURN_STR(STATUS_NOT_MAPPED_VIEW);
	CASE_RETURN_STR(STATUS_UNABLE_TO_FREE_VM);
	CASE_RETURN_STR(STATUS_UNABLE_TO_DELETE_SECTION);
	CASE_RETURN_STR(STATUS_INVALID_SYSTEM_SERVICE);
	CASE_RETURN_STR(STATUS_ILLEGAL_INSTRUCTION);
	CASE_RETURN_STR(STATUS_INVALID_LOCK_SEQUENCE);
	CASE_RETURN_STR(STATUS_INVALID_VIEW_SIZE);
	CASE_RETURN_STR(STATUS_INVALID_FILE_FOR_SECTION);
	CASE_RETURN_STR(STATUS_ALREADY_COMMITTED);
	CASE_RETURN_STR(STATUS_ACCESS_DENIED);
	CASE_RETURN_STR(STATUS_BUFFER_TOO_SMALL);
	CASE_RETURN_STR(STATUS_OBJECT_TYPE_MISMATCH);
	CASE_RETURN_STR(STATUS_NONCONTINUABLE_EXCEPTION);
	CASE_RETURN_STR(STATUS_INVALID_DISPOSITION);
	CASE_RETURN_STR(STATUS_UNWIND);
	CASE_RETURN_STR(STATUS_BAD_STACK);
	CASE_RETURN_STR(STATUS_INVALID_UNWIND_TARGET);
	CASE_RETURN_STR(STATUS_NOT_LOCKED);
	CASE_RETURN_STR(STATUS_PARITY_ERROR);
	CASE_RETURN_STR(STATUS_UNABLE_TO_DECOMMIT_VM);
	CASE_RETURN_STR(STATUS_NOT_COMMITTED);
	CASE_RETURN_STR(STATUS_INVALID_PORT_ATTRIBUTES);
	CASE_RETURN_STR(STATUS_PORT_MESSAGE_TOO_LONG);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_MIX);
	CASE_RETURN_STR(STATUS_INVALID_QUOTA_LOWER);
	CASE_RETURN_STR(STATUS_DISK_CORRUPT_ERROR);
	CASE_RETURN_STR(STATUS_OBJECT_NAME_INVALID);
	CASE_RETURN_STR(STATUS_OBJECT_NAME_NOT_FOUND);
	CASE_RETURN_STR(STATUS_OBJECT_NAME_COLLISION);
	CASE_RETURN_STR(STATUS_PORT_DISCONNECTED);
	CASE_RETURN_STR(STATUS_DEVICE_ALREADY_ATTACHED);
	CASE_RETURN_STR(STATUS_OBJECT_PATH_INVALID);
	CASE_RETURN_STR(STATUS_OBJECT_PATH_NOT_FOUND);
	CASE_RETURN_STR(STATUS_OBJECT_PATH_SYNTAX_BAD);
	CASE_RETURN_STR(STATUS_DATA_OVERRUN);
	CASE_RETURN_STR(STATUS_DATA_LATE_ERROR);
	CASE_RETURN_STR(STATUS_DATA_ERROR);
	CASE_RETURN_STR(STATUS_CRC_ERROR);
	CASE_RETURN_STR(STATUS_SECTION_TOO_BIG);
	CASE_RETURN_STR(STATUS_PORT_CONNECTION_REFUSED);
	CASE_RETURN_STR(STATUS_INVALID_PORT_HANDLE);
	CASE_RETURN_STR(STATUS_SHARING_VIOLATION);
	CASE_RETURN_STR(STATUS_QUOTA_EXCEEDED);
	CASE_RETURN_STR(STATUS_INVALID_PAGE_PROTECTION);
	CASE_RETURN_STR(STATUS_MUTANT_NOT_OWNED);
	CASE_RETURN_STR(STATUS_SEMAPHORE_LIMIT_EXCEEDED);
	CASE_RETURN_STR(STATUS_PORT_ALREADY_SET);
	CASE_RETURN_STR(STATUS_SECTION_NOT_IMAGE);
	CASE_RETURN_STR(STATUS_SUSPEND_COUNT_EXCEEDED);
	CASE_RETURN_STR(STATUS_THREAD_IS_TERMINATING);
	CASE_RETURN_STR(STATUS_BAD_WORKING_SET_LIMIT);
	CASE_RETURN_STR(STATUS_INCOMPATIBLE_FILE_MAP);
	CASE_RETURN_STR(STATUS_SECTION_PROTECTION);
	CASE_RETURN_STR(STATUS_EAS_NOT_SUPPORTED);
	CASE_RETURN_STR(STATUS_EA_TOO_LARGE);
	CASE_RETURN_STR(STATUS_NONEXISTENT_EA_ENTRY);
	CASE_RETURN_STR(STATUS_NO_EAS_ON_FILE);
	CASE_RETURN_STR(STATUS_EA_CORRUPT_ERROR);
	CASE_RETURN_STR(STATUS_FILE_LOCK_CONFLICT);
	CASE_RETURN_STR(STATUS_LOCK_NOT_GRANTED);
	CASE_RETURN_STR(STATUS_DELETE_PENDING);
	CASE_RETURN_STR(STATUS_CTL_FILE_NOT_SUPPORTED);
	CASE_RETURN_STR(STATUS_UNKNOWN_REVISION);
	CASE_RETURN_STR(STATUS_REVISION_MISMATCH);
	CASE_RETURN_STR(STATUS_INVALID_OWNER);
	CASE_RETURN_STR(STATUS_INVALID_PRIMARY_GROUP);
	CASE_RETURN_STR(STATUS_NO_IMPERSONATION_TOKEN);
	CASE_RETURN_STR(STATUS_CANT_DISABLE_MANDATORY);
	CASE_RETURN_STR(STATUS_NO_LOGON_SERVERS);
	CASE_RETURN_STR(STATUS_NO_SUCH_LOGON_SESSION);
	CASE_RETURN_STR(STATUS_NO_SUCH_PRIVILEGE);
	CASE_RETURN_STR(STATUS_PRIVILEGE_NOT_HELD);
	CASE_RETURN_STR(STATUS_INVALID_ACCOUNT_NAME);
	CASE_RETURN_STR(STATUS_USER_EXISTS);
	CASE_RETURN_STR(STATUS_NO_SUCH_USER);
	CASE_RETURN_STR(STATUS_GROUP_EXISTS);
	CASE_RETURN_STR(STATUS_NO_SUCH_GROUP);
	CASE_RETURN_STR(STATUS_MEMBER_IN_GROUP);
	CASE_RETURN_STR(STATUS_MEMBER_NOT_IN_GROUP);
	CASE_RETURN_STR(STATUS_LAST_ADMIN);
	CASE_RETURN_STR(STATUS_WRONG_PASSWORD);
	CASE_RETURN_STR(STATUS_ILL_FORMED_PASSWORD);
	CASE_RETURN_STR(STATUS_PASSWORD_RESTRICTION);
	CASE_RETURN_STR(STATUS_LOGON_FAILURE);
	CASE_RETURN_STR(STATUS_ACCOUNT_RESTRICTION);
	CASE_RETURN_STR(STATUS_INVALID_LOGON_HOURS);
	CASE_RETURN_STR(STATUS_INVALID_WORKSTATION);
	CASE_RETURN_STR(STATUS_PASSWORD_EXPIRED);
	CASE_RETURN_STR(STATUS_ACCOUNT_DISABLED);
	CASE_RETURN_STR(STATUS_NONE_MAPPED);
	CASE_RETURN_STR(STATUS_TOO_MANY_LUIDS_REQUESTED);
	CASE_RETURN_STR(STATUS_LUIDS_EXHAUSTED);
	CASE_RETURN_STR(STATUS_INVALID_SUB_AUTHORITY);
	CASE_RETURN_STR(STATUS_INVALID_ACL);
	CASE_RETURN_STR(STATUS_INVALID_SID);
	CASE_RETURN_STR(STATUS_INVALID_SECURITY_DESCR);
	CASE_RETURN_STR(STATUS_PROCEDURE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_FORMAT);
	CASE_RETURN_STR(STATUS_NO_TOKEN);
	CASE_RETURN_STR(STATUS_BAD_INHERITANCE_ACL);
	CASE_RETURN_STR(STATUS_RANGE_NOT_LOCKED);
	CASE_RETURN_STR(STATUS_DISK_FULL);
	CASE_RETURN_STR(STATUS_SERVER_DISABLED);
	CASE_RETURN_STR(STATUS_SERVER_NOT_DISABLED);
	CASE_RETURN_STR(STATUS_TOO_MANY_GUIDS_REQUESTED);
	CASE_RETURN_STR(STATUS_GUIDS_EXHAUSTED);
	CASE_RETURN_STR(STATUS_INVALID_ID_AUTHORITY);
	CASE_RETURN_STR(STATUS_AGENTS_EXHAUSTED);
	CASE_RETURN_STR(STATUS_INVALID_VOLUME_LABEL);
	CASE_RETURN_STR(STATUS_SECTION_NOT_EXTENDED);
	CASE_RETURN_STR(STATUS_NOT_MAPPED_DATA);
	CASE_RETURN_STR(STATUS_RESOURCE_DATA_NOT_FOUND);
	CASE_RETURN_STR(STATUS_RESOURCE_TYPE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_RESOURCE_NAME_NOT_FOUND);
	CASE_RETURN_STR(STATUS_ARRAY_BOUNDS_EXCEEDED);
	CASE_RETURN_STR(STATUS_FLOAT_DENORMAL_OPERAND);
	CASE_RETURN_STR(STATUS_FLOAT_DIVIDE_BY_ZERO);
	CASE_RETURN_STR(STATUS_FLOAT_INEXACT_RESULT);
	CASE_RETURN_STR(STATUS_FLOAT_INVALID_OPERATION);
	CASE_RETURN_STR(STATUS_FLOAT_OVERFLOW);
	CASE_RETURN_STR(STATUS_FLOAT_STACK_CHECK);
	CASE_RETURN_STR(STATUS_FLOAT_UNDERFLOW);
	CASE_RETURN_STR(STATUS_INTEGER_DIVIDE_BY_ZERO);
	CASE_RETURN_STR(STATUS_INTEGER_OVERFLOW);
	CASE_RETURN_STR(STATUS_PRIVILEGED_INSTRUCTION);
	CASE_RETURN_STR(STATUS_TOO_MANY_PAGING_FILES);
	CASE_RETURN_STR(STATUS_FILE_INVALID);
	CASE_RETURN_STR(STATUS_ALLOTTED_SPACE_EXCEEDED);
	CASE_RETURN_STR(STATUS_INSUFFICIENT_RESOURCES);
	CASE_RETURN_STR(STATUS_DFS_EXIT_PATH_FOUND);
	CASE_RETURN_STR(STATUS_DEVICE_DATA_ERROR);
	CASE_RETURN_STR(STATUS_DEVICE_NOT_CONNECTED);
	CASE_RETURN_STR(STATUS_DEVICE_POWER_FAILURE);
	CASE_RETURN_STR(STATUS_FREE_VM_NOT_AT_BASE);
	CASE_RETURN_STR(STATUS_MEMORY_NOT_ALLOCATED);
	CASE_RETURN_STR(STATUS_WORKING_SET_QUOTA);
	CASE_RETURN_STR(STATUS_MEDIA_WRITE_PROTECTED);
	CASE_RETURN_STR(STATUS_DEVICE_NOT_READY);
	CASE_RETURN_STR(STATUS_INVALID_GROUP_ATTRIBUTES);
	CASE_RETURN_STR(STATUS_BAD_IMPERSONATION_LEVEL);
	CASE_RETURN_STR(STATUS_CANT_OPEN_ANONYMOUS);
	CASE_RETURN_STR(STATUS_BAD_VALIDATION_CLASS);
	CASE_RETURN_STR(STATUS_BAD_TOKEN_TYPE);
	CASE_RETURN_STR(STATUS_BAD_MASTER_BOOT_RECORD);
	CASE_RETURN_STR(STATUS_INSTRUCTION_MISALIGNMENT);
	CASE_RETURN_STR(STATUS_INSTANCE_NOT_AVAILABLE);
	CASE_RETURN_STR(STATUS_PIPE_NOT_AVAILABLE);
	CASE_RETURN_STR(STATUS_INVALID_PIPE_STATE);
	CASE_RETURN_STR(STATUS_PIPE_BUSY);
	CASE_RETURN_STR(STATUS_ILLEGAL_FUNCTION);
	CASE_RETURN_STR(STATUS_PIPE_DISCONNECTED);
	CASE_RETURN_STR(STATUS_PIPE_CLOSING);
	CASE_RETURN_STR(STATUS_PIPE_CONNECTED);
	CASE_RETURN_STR(STATUS_PIPE_LISTENING);
	CASE_RETURN_STR(STATUS_INVALID_READ_MODE);
	CASE_RETURN_STR(STATUS_IO_TIMEOUT);
	CASE_RETURN_STR(STATUS_FILE_FORCED_CLOSED);
	CASE_RETURN_STR(STATUS_PROFILING_NOT_STARTED);
	CASE_RETURN_STR(STATUS_PROFILING_NOT_STOPPED);
	CASE_RETURN_STR(STATUS_COULD_NOT_INTERPRET);
	CASE_RETURN_STR(STATUS_FILE_IS_A_DIRECTORY);
	CASE_RETURN_STR(STATUS_NOT_SUPPORTED);
	CASE_RETURN_STR(STATUS_REMOTE_NOT_LISTENING);
	CASE_RETURN_STR(STATUS_DUPLICATE_NAME);
	CASE_RETURN_STR(STATUS_BAD_NETWORK_PATH);
	CASE_RETURN_STR(STATUS_NETWORK_BUSY);
	CASE_RETURN_STR(STATUS_DEVICE_DOES_NOT_EXIST);
	CASE_RETURN_STR(STATUS_TOO_MANY_COMMANDS);
	CASE_RETURN_STR(STATUS_ADAPTER_HARDWARE_ERROR);
	CASE_RETURN_STR(STATUS_INVALID_NETWORK_RESPONSE);
	CASE_RETURN_STR(STATUS_UNEXPECTED_NETWORK_ERROR);
	CASE_RETURN_STR(STATUS_BAD_REMOTE_ADAPTER);
	CASE_RETURN_STR(STATUS_PRINT_QUEUE_FULL);
	CASE_RETURN_STR(STATUS_NO_SPOOL_SPACE);
	CASE_RETURN_STR(STATUS_PRINT_CANCELLED);
	CASE_RETURN_STR(STATUS_NETWORK_NAME_DELETED);
	CASE_RETURN_STR(STATUS_NETWORK_ACCESS_DENIED);
	CASE_RETURN_STR(STATUS_BAD_DEVICE_TYPE);
	CASE_RETURN_STR(STATUS_BAD_NETWORK_NAME);
	CASE_RETURN_STR(STATUS_TOO_MANY_NAMES);
	CASE_RETURN_STR(STATUS_TOO_MANY_SESSIONS);
	CASE_RETURN_STR(STATUS_SHARING_PAUSED);
	CASE_RETURN_STR(STATUS_REQUEST_NOT_ACCEPTED);
	CASE_RETURN_STR(STATUS_REDIRECTOR_PAUSED);
	CASE_RETURN_STR(STATUS_NET_WRITE_FAULT);
	CASE_RETURN_STR(STATUS_PROFILING_AT_LIMIT);
	CASE_RETURN_STR(STATUS_NOT_SAME_DEVICE);
	CASE_RETURN_STR(STATUS_FILE_RENAMED);
	CASE_RETURN_STR(STATUS_VIRTUAL_CIRCUIT_CLOSED);
	CASE_RETURN_STR(STATUS_NO_SECURITY_ON_OBJECT);
	CASE_RETURN_STR(STATUS_CANT_WAIT);
	CASE_RETURN_STR(STATUS_PIPE_EMPTY);
	CASE_RETURN_STR(STATUS_CANT_ACCESS_DOMAIN_INFO);
	CASE_RETURN_STR(STATUS_CANT_TERMINATE_SELF);
	CASE_RETURN_STR(STATUS_INVALID_SERVER_STATE);
	CASE_RETURN_STR(STATUS_INVALID_DOMAIN_STATE);
	CASE_RETURN_STR(STATUS_INVALID_DOMAIN_ROLE);
	CASE_RETURN_STR(STATUS_NO_SUCH_DOMAIN);
	CASE_RETURN_STR(STATUS_DOMAIN_EXISTS);
	CASE_RETURN_STR(STATUS_DOMAIN_LIMIT_EXCEEDED);
	CASE_RETURN_STR(STATUS_OPLOCK_NOT_GRANTED);
	CASE_RETURN_STR(STATUS_INVALID_OPLOCK_PROTOCOL);
	CASE_RETURN_STR(STATUS_INTERNAL_DB_CORRUPTION);
	CASE_RETURN_STR(STATUS_INTERNAL_ERROR);
	CASE_RETURN_STR(STATUS_GENERIC_NOT_MAPPED);
	CASE_RETURN_STR(STATUS_BAD_DESCRIPTOR_FORMAT);
	CASE_RETURN_STR(STATUS_INVALID_USER_BUFFER);
	CASE_RETURN_STR(STATUS_UNEXPECTED_IO_ERROR);
	CASE_RETURN_STR(STATUS_UNEXPECTED_MM_CREATE_ERR);
	CASE_RETURN_STR(STATUS_UNEXPECTED_MM_MAP_ERROR);
	CASE_RETURN_STR(STATUS_UNEXPECTED_MM_EXTEND_ERR);
	CASE_RETURN_STR(STATUS_NOT_LOGON_PROCESS);
	CASE_RETURN_STR(STATUS_LOGON_SESSION_EXISTS);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_1);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_2);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_3);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_4);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_5);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_6);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_7);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_8);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_9);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_10);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_11);
	CASE_RETURN_STR(STATUS_INVALID_PARAMETER_12);
	CASE_RETURN_STR(STATUS_REDIRECTOR_NOT_STARTED);
	CASE_RETURN_STR(STATUS_REDIRECTOR_STARTED);
	CASE_RETURN_STR(STATUS_STACK_OVERFLOW);
	CASE_RETURN_STR(STATUS_NO_SUCH_PACKAGE);
	CASE_RETURN_STR(STATUS_BAD_FUNCTION_TABLE);
	CASE_RETURN_STR(STATUS_VARIABLE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_DIRECTORY_NOT_EMPTY);
	CASE_RETURN_STR(STATUS_FILE_CORRUPT_ERROR);
	CASE_RETURN_STR(STATUS_NOT_A_DIRECTORY);
	CASE_RETURN_STR(STATUS_BAD_LOGON_SESSION_STATE);
	CASE_RETURN_STR(STATUS_LOGON_SESSION_COLLISION);
	CASE_RETURN_STR(STATUS_NAME_TOO_LONG);
	CASE_RETURN_STR(STATUS_FILES_OPEN);
	CASE_RETURN_STR(STATUS_CONNECTION_IN_USE);
	CASE_RETURN_STR(STATUS_MESSAGE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_PROCESS_IS_TERMINATING);
	CASE_RETURN_STR(STATUS_INVALID_LOGON_TYPE);
	CASE_RETURN_STR(STATUS_NO_GUID_TRANSLATION);
	CASE_RETURN_STR(STATUS_CANNOT_IMPERSONATE);
	CASE_RETURN_STR(STATUS_IMAGE_ALREADY_LOADED);
	CASE_RETURN_STR(STATUS_ABIOS_NOT_PRESENT);
	CASE_RETURN_STR(STATUS_ABIOS_LID_NOT_EXIST);
	CASE_RETURN_STR(STATUS_ABIOS_LID_ALREADY_OWNED);
	CASE_RETURN_STR(STATUS_ABIOS_NOT_LID_OWNER);
	CASE_RETURN_STR(STATUS_ABIOS_INVALID_COMMAND);
	CASE_RETURN_STR(STATUS_ABIOS_INVALID_LID);
	CASE_RETURN_STR(STATUS_ABIOS_SELECTOR_NOT_AVAILABLE);
	CASE_RETURN_STR(STATUS_ABIOS_INVALID_SELECTOR);
	CASE_RETURN_STR(STATUS_NO_LDT);
	CASE_RETURN_STR(STATUS_INVALID_LDT_SIZE);
	CASE_RETURN_STR(STATUS_INVALID_LDT_OFFSET);
	CASE_RETURN_STR(STATUS_INVALID_LDT_DESCRIPTOR);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_NE_FORMAT);
	CASE_RETURN_STR(STATUS_RXACT_INVALID_STATE);
	CASE_RETURN_STR(STATUS_RXACT_COMMIT_FAILURE);
	CASE_RETURN_STR(STATUS_MAPPED_FILE_SIZE_ZERO);
	CASE_RETURN_STR(STATUS_TOO_MANY_OPENED_FILES);
	CASE_RETURN_STR(STATUS_CANCELLED);
	CASE_RETURN_STR(STATUS_CANNOT_DELETE);
	CASE_RETURN_STR(STATUS_INVALID_COMPUTER_NAME);
	CASE_RETURN_STR(STATUS_FILE_DELETED);
	CASE_RETURN_STR(STATUS_SPECIAL_ACCOUNT);
	CASE_RETURN_STR(STATUS_SPECIAL_GROUP);
	CASE_RETURN_STR(STATUS_SPECIAL_USER);
	CASE_RETURN_STR(STATUS_MEMBERS_PRIMARY_GROUP);
	CASE_RETURN_STR(STATUS_FILE_CLOSED);
	CASE_RETURN_STR(STATUS_TOO_MANY_THREADS);
	CASE_RETURN_STR(STATUS_THREAD_NOT_IN_PROCESS);
	CASE_RETURN_STR(STATUS_TOKEN_ALREADY_IN_USE);
	CASE_RETURN_STR(STATUS_PAGEFILE_QUOTA_EXCEEDED);
	CASE_RETURN_STR(STATUS_COMMITMENT_LIMIT);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_LE_FORMAT);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_NOT_MZ);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_PROTECT);
	CASE_RETURN_STR(STATUS_INVALID_IMAGE_WIN_16);
	CASE_RETURN_STR(STATUS_LOGON_SERVER_CONFLICT);
	CASE_RETURN_STR(STATUS_TIME_DIFFERENCE_AT_DC);
	CASE_RETURN_STR(STATUS_SYNCHRONIZATION_REQUIRED);
	CASE_RETURN_STR(STATUS_DLL_NOT_FOUND);
	CASE_RETURN_STR(STATUS_OPEN_FAILED);
	CASE_RETURN_STR(STATUS_IO_PRIVILEGE_FAILED);
	CASE_RETURN_STR(STATUS_ORDINAL_NOT_FOUND);
	CASE_RETURN_STR(STATUS_ENTRYPOINT_NOT_FOUND);
	CASE_RETURN_STR(STATUS_CONTROL_C_EXIT);
	CASE_RETURN_STR(STATUS_LOCAL_DISCONNECT);
	CASE_RETURN_STR(STATUS_REMOTE_DISCONNECT);
	CASE_RETURN_STR(STATUS_REMOTE_RESOURCES);
	CASE_RETURN_STR(STATUS_LINK_FAILED);
	CASE_RETURN_STR(STATUS_LINK_TIMEOUT);
	CASE_RETURN_STR(STATUS_INVALID_CONNECTION);
	CASE_RETURN_STR(STATUS_INVALID_ADDRESS);
	CASE_RETURN_STR(STATUS_DLL_INIT_FAILED);
	CASE_RETURN_STR(STATUS_MISSING_SYSTEMFILE);
	CASE_RETURN_STR(STATUS_UNHANDLED_EXCEPTION);
	CASE_RETURN_STR(STATUS_APP_INIT_FAILURE);
	CASE_RETURN_STR(STATUS_PAGEFILE_CREATE_FAILED);
	CASE_RETURN_STR(STATUS_NO_PAGEFILE);
	CASE_RETURN_STR(STATUS_INVALID_LEVEL);
	CASE_RETURN_STR(STATUS_WRONG_PASSWORD_CORE);
	CASE_RETURN_STR(STATUS_ILLEGAL_FLOAT_CONTEXT);
	CASE_RETURN_STR(STATUS_PIPE_BROKEN);
	CASE_RETURN_STR(STATUS_REGISTRY_CORRUPT);
	CASE_RETURN_STR(STATUS_REGISTRY_IO_FAILED);
	CASE_RETURN_STR(STATUS_NO_EVENT_PAIR);
	CASE_RETURN_STR(STATUS_UNRECOGNIZED_VOLUME);
	CASE_RETURN_STR(STATUS_SERIAL_NO_DEVICE_INITED);
	CASE_RETURN_STR(STATUS_NO_SUCH_ALIAS);
	CASE_RETURN_STR(STATUS_MEMBER_NOT_IN_ALIAS);
	CASE_RETURN_STR(STATUS_MEMBER_IN_ALIAS);
	CASE_RETURN_STR(STATUS_ALIAS_EXISTS);
	CASE_RETURN_STR(STATUS_LOGON_NOT_GRANTED);
	CASE_RETURN_STR(STATUS_TOO_MANY_SECRETS);
	CASE_RETURN_STR(STATUS_SECRET_TOO_LONG);
	CASE_RETURN_STR(STATUS_INTERNAL_DB_ERROR);
	CASE_RETURN_STR(STATUS_FULLSCREEN_MODE);
	CASE_RETURN_STR(STATUS_TOO_MANY_CONTEXT_IDS);
	CASE_RETURN_STR(STATUS_LOGON_TYPE_NOT_GRANTED);
	CASE_RETURN_STR(STATUS_NOT_REGISTRY_FILE);
	CASE_RETURN_STR(STATUS_NT_CROSS_ENCRYPTION_REQUIRED);
	CASE_RETURN_STR(STATUS_DOMAIN_CTRLR_CONFIG_ERROR);
	CASE_RETURN_STR(STATUS_FT_MISSING_MEMBER);
	CASE_RETURN_STR(STATUS_ILL_FORMED_SERVICE_ENTRY);
	CASE_RETURN_STR(STATUS_ILLEGAL_CHARACTER);
	CASE_RETURN_STR(STATUS_UNMAPPABLE_CHARACTER);
	CASE_RETURN_STR(STATUS_UNDEFINED_CHARACTER);
	CASE_RETURN_STR(STATUS_FLOPPY_VOLUME);
	CASE_RETURN_STR(STATUS_FLOPPY_ID_MARK_NOT_FOUND);
	CASE_RETURN_STR(STATUS_FLOPPY_WRONG_CYLINDER);
	CASE_RETURN_STR(STATUS_FLOPPY_UNKNOWN_ERROR);
	CASE_RETURN_STR(STATUS_FLOPPY_BAD_REGISTERS);
	CASE_RETURN_STR(STATUS_DISK_RECALIBRATE_FAILED);
	CASE_RETURN_STR(STATUS_DISK_OPERATION_FAILED);
	CASE_RETURN_STR(STATUS_DISK_RESET_FAILED);
	CASE_RETURN_STR(STATUS_SHARED_IRQ_BUSY);
	CASE_RETURN_STR(STATUS_FT_ORPHANING);
	CASE_RETURN_STR(STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT);
	CASE_RETURN_STR(STATUS_PARTITION_FAILURE);
	CASE_RETURN_STR(STATUS_INVALID_BLOCK_LENGTH);
	CASE_RETURN_STR(STATUS_DEVICE_NOT_PARTITIONED);
	CASE_RETURN_STR(STATUS_UNABLE_TO_LOCK_MEDIA);
	CASE_RETURN_STR(STATUS_UNABLE_TO_UNLOAD_MEDIA);
	CASE_RETURN_STR(STATUS_EOM_OVERFLOW);
	CASE_RETURN_STR(STATUS_NO_MEDIA);
	CASE_RETURN_STR(STATUS_NO_SUCH_MEMBER);
	CASE_RETURN_STR(STATUS_INVALID_MEMBER);
	CASE_RETURN_STR(STATUS_KEY_DELETED);
	CASE_RETURN_STR(STATUS_NO_LOG_SPACE);
	CASE_RETURN_STR(STATUS_TOO_MANY_SIDS);
	CASE_RETURN_STR(STATUS_LM_CROSS_ENCRYPTION_REQUIRED);
	CASE_RETURN_STR(STATUS_KEY_HAS_CHILDREN);
	CASE_RETURN_STR(STATUS_CHILD_MUST_BE_VOLATILE);
	CASE_RETURN_STR(STATUS_DEVICE_CONFIGURATION_ERROR);
	CASE_RETURN_STR(STATUS_DRIVER_INTERNAL_ERROR);
	CASE_RETURN_STR(STATUS_INVALID_DEVICE_STATE);
	CASE_RETURN_STR(STATUS_IO_DEVICE_ERROR);
	CASE_RETURN_STR(STATUS_DEVICE_PROTOCOL_ERROR);
	CASE_RETURN_STR(STATUS_BACKUP_CONTROLLER);
	CASE_RETURN_STR(STATUS_LOG_FILE_FULL);
	CASE_RETURN_STR(STATUS_TOO_LATE);
	CASE_RETURN_STR(STATUS_NO_TRUST_LSA_SECRET);
	CASE_RETURN_STR(STATUS_NO_TRUST_SAM_ACCOUNT);
	CASE_RETURN_STR(STATUS_TRUSTED_DOMAIN_FAILURE);
	CASE_RETURN_STR(STATUS_TRUSTED_RELATIONSHIP_FAILURE);
	CASE_RETURN_STR(STATUS_EVENTLOG_FILE_CORRUPT);
	CASE_RETURN_STR(STATUS_EVENTLOG_CANT_START);
	CASE_RETURN_STR(STATUS_TRUST_FAILURE);
	CASE_RETURN_STR(STATUS_MUTANT_LIMIT_EXCEEDED);
	CASE_RETURN_STR(STATUS_NETLOGON_NOT_STARTED);
	CASE_RETURN_STR(STATUS_ACCOUNT_EXPIRED);
	CASE_RETURN_STR(STATUS_POSSIBLE_DEADLOCK);
	CASE_RETURN_STR(STATUS_NETWORK_CREDENTIAL_CONFLICT);
	CASE_RETURN_STR(STATUS_REMOTE_SESSION_LIMIT);
	CASE_RETURN_STR(STATUS_EVENTLOG_FILE_CHANGED);
	CASE_RETURN_STR(STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT);
	CASE_RETURN_STR(STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT);
	CASE_RETURN_STR(STATUS_NOLOGON_SERVER_TRUST_ACCOUNT);
	CASE_RETURN_STR(STATUS_DOMAIN_TRUST_INCONSISTENT);
	CASE_RETURN_STR(STATUS_FS_DRIVER_REQUIRED);
	CASE_RETURN_STR(STATUS_NO_USER_SESSION_KEY);
	CASE_RETURN_STR(STATUS_USER_SESSION_DELETED);
	CASE_RETURN_STR(STATUS_RESOURCE_LANG_NOT_FOUND);
	CASE_RETURN_STR(STATUS_INSUFF_SERVER_RESOURCES);
	CASE_RETURN_STR(STATUS_INVALID_BUFFER_SIZE);
	CASE_RETURN_STR(STATUS_INVALID_ADDRESS_COMPONENT);
	CASE_RETURN_STR(STATUS_INVALID_ADDRESS_WILDCARD);
	CASE_RETURN_STR(STATUS_TOO_MANY_ADDRESSES);
	CASE_RETURN_STR(STATUS_ADDRESS_ALREADY_EXISTS);
	CASE_RETURN_STR(STATUS_ADDRESS_CLOSED);
	CASE_RETURN_STR(STATUS_CONNECTION_DISCONNECTED);
	CASE_RETURN_STR(STATUS_CONNECTION_RESET);
	CASE_RETURN_STR(STATUS_TOO_MANY_NODES);
	CASE_RETURN_STR(STATUS_TRANSACTION_ABORTED);
	CASE_RETURN_STR(STATUS_TRANSACTION_TIMED_OUT);
	CASE_RETURN_STR(STATUS_TRANSACTION_NO_RELEASE);
	CASE_RETURN_STR(STATUS_TRANSACTION_NO_MATCH);
	CASE_RETURN_STR(STATUS_TRANSACTION_RESPONDED);
	CASE_RETURN_STR(STATUS_TRANSACTION_INVALID_ID);
	CASE_RETURN_STR(STATUS_TRANSACTION_INVALID_TYPE);
	CASE_RETURN_STR(STATUS_NOT_SERVER_SESSION);
	CASE_RETURN_STR(STATUS_NOT_CLIENT_SESSION);
	CASE_RETURN_STR(STATUS_CANNOT_LOAD_REGISTRY_FILE);
	CASE_RETURN_STR(STATUS_DEBUG_ATTACH_FAILED);
	CASE_RETURN_STR(STATUS_SYSTEM_PROCESS_TERMINATED);
	CASE_RETURN_STR(STATUS_DATA_NOT_ACCEPTED);
	CASE_RETURN_STR(STATUS_NO_BROWSER_SERVERS_FOUND);
	CASE_RETURN_STR(STATUS_VDM_HARD_ERROR);
	CASE_RETURN_STR(STATUS_DRIVER_CANCEL_TIMEOUT);
	CASE_RETURN_STR(STATUS_REPLY_MESSAGE_MISMATCH);
	CASE_RETURN_STR(STATUS_MAPPED_ALIGNMENT);
	CASE_RETURN_STR(STATUS_IMAGE_CHECKSUM_MISMATCH);
	CASE_RETURN_STR(STATUS_LOST_WRITEBEHIND_DATA);
	CASE_RETURN_STR(STATUS_CLIENT_SERVER_PARAMETERS_INVALID);
	CASE_RETURN_STR(STATUS_PASSWORD_MUST_CHANGE);
	CASE_RETURN_STR(STATUS_NOT_FOUND);
	CASE_RETURN_STR(STATUS_NOT_TINY_STREAM);
	CASE_RETURN_STR(STATUS_RECOVERY_FAILURE);
	CASE_RETURN_STR(STATUS_STACK_OVERFLOW_READ);
	CASE_RETURN_STR(STATUS_FAIL_CHECK);
	CASE_RETURN_STR(STATUS_DUPLICATE_OBJECTID);
	CASE_RETURN_STR(STATUS_OBJECTID_EXISTS);
	CASE_RETURN_STR(STATUS_CONVERT_TO_LARGE);
	CASE_RETURN_STR(STATUS_RETRY);
	CASE_RETURN_STR(STATUS_FOUND_OUT_OF_SCOPE);
	CASE_RETURN_STR(STATUS_ALLOCATE_BUCKET);
	CASE_RETURN_STR(STATUS_PROPSET_NOT_FOUND);
	CASE_RETURN_STR(STATUS_MARSHALL_OVERFLOW);
	CASE_RETURN_STR(STATUS_INVALID_VARIANT);
	CASE_RETURN_STR(STATUS_DOMAIN_CONTROLLER_NOT_FOUND);
	CASE_RETURN_STR(STATUS_ACCOUNT_LOCKED_OUT);
	CASE_RETURN_STR(STATUS_HANDLE_NOT_CLOSABLE);
	CASE_RETURN_STR(STATUS_CONNECTION_REFUSED);
	CASE_RETURN_STR(STATUS_GRACEFUL_DISCONNECT);
	CASE_RETURN_STR(STATUS_ADDRESS_ALREADY_ASSOCIATED);
	CASE_RETURN_STR(STATUS_ADDRESS_NOT_ASSOCIATED);
	CASE_RETURN_STR(STATUS_CONNECTION_INVALID);
	CASE_RETURN_STR(STATUS_CONNECTION_ACTIVE);
	CASE_RETURN_STR(STATUS_NETWORK_UNREACHABLE);
	CASE_RETURN_STR(STATUS_HOST_UNREACHABLE);
	CASE_RETURN_STR(STATUS_PROTOCOL_UNREACHABLE);
	CASE_RETURN_STR(STATUS_PORT_UNREACHABLE);
	CASE_RETURN_STR(STATUS_REQUEST_ABORTED);
	CASE_RETURN_STR(STATUS_CONNECTION_ABORTED);
	CASE_RETURN_STR(STATUS_BAD_COMPRESSION_BUFFER);
	CASE_RETURN_STR(STATUS_USER_MAPPED_FILE);
	CASE_RETURN_STR(STATUS_AUDIT_FAILED);
	CASE_RETURN_STR(STATUS_TIMER_RESOLUTION_NOT_SET);
	CASE_RETURN_STR(STATUS_CONNECTION_COUNT_LIMIT);
	CASE_RETURN_STR(STATUS_LOGIN_TIME_RESTRICTION);
	CASE_RETURN_STR(STATUS_LOGIN_WKSTA_RESTRICTION);
	CASE_RETURN_STR(STATUS_IMAGE_MP_UP_MISMATCH);
	CASE_RETURN_STR(STATUS_INSUFFICIENT_LOGON_INFO);
	CASE_RETURN_STR(STATUS_BAD_DLL_ENTRYPOINT);
	CASE_RETURN_STR(STATUS_BAD_SERVICE_ENTRYPOINT);
	CASE_RETURN_STR(STATUS_LPC_REPLY_LOST);
	CASE_RETURN_STR(STATUS_IP_ADDRESS_CONFLICT1);
	CASE_RETURN_STR(STATUS_IP_ADDRESS_CONFLICT2);
	CASE_RETURN_STR(STATUS_REGISTRY_QUOTA_LIMIT);
	CASE_RETURN_STR(STATUS_PATH_NOT_COVERED);
	CASE_RETURN_STR(STATUS_NO_CALLBACK_ACTIVE);
	CASE_RETURN_STR(STATUS_LICENSE_QUOTA_EXCEEDED);
	CASE_RETURN_STR(STATUS_PWD_TOO_SHORT);
	CASE_RETURN_STR(STATUS_PWD_TOO_RECENT);
	CASE_RETURN_STR(STATUS_PWD_HISTORY_CONFLICT);
	CASE_RETURN_STR(STATUS_PLUGPLAY_NO_DEVICE);
	CASE_RETURN_STR(STATUS_UNSUPPORTED_COMPRESSION);
	CASE_RETURN_STR(STATUS_INVALID_HW_PROFILE);
	CASE_RETURN_STR(STATUS_INVALID_PLUGPLAY_DEVICE_PATH);
	CASE_RETURN_STR(STATUS_DRIVER_ORDINAL_NOT_FOUND);
	CASE_RETURN_STR(STATUS_DRIVER_ENTRYPOINT_NOT_FOUND);
	CASE_RETURN_STR(STATUS_RESOURCE_NOT_OWNED);
	CASE_RETURN_STR(STATUS_TOO_MANY_LINKS);
	CASE_RETURN_STR(STATUS_QUOTA_LIST_INCONSISTENT);
	CASE_RETURN_STR(STATUS_FILE_IS_OFFLINE);
	CASE_RETURN_STR(STATUS_EVALUATION_EXPIRATION);
	CASE_RETURN_STR(STATUS_ILLEGAL_DLL_RELOCATION);
	CASE_RETURN_STR(STATUS_LICENSE_VIOLATION);
	CASE_RETURN_STR(STATUS_DLL_INIT_FAILED_LOGOFF);
	CASE_RETURN_STR(STATUS_DRIVER_UNABLE_TO_LOAD);
	CASE_RETURN_STR(STATUS_DFS_UNAVAILABLE);
	CASE_RETURN_STR(STATUS_VOLUME_DISMOUNTED);
	CASE_RETURN_STR(STATUS_WX86_INTERNAL_ERROR);
	CASE_RETURN_STR(STATUS_WX86_FLOAT_STACK_CHECK);
	CASE_RETURN_STR(STATUS_VALIDATE_CONTINUE);
	CASE_RETURN_STR(STATUS_NO_MATCH);
	CASE_RETURN_STR(STATUS_NO_MORE_MATCHES);
	CASE_RETURN_STR(STATUS_NOT_A_REPARSE_POINT);
	CASE_RETURN_STR(STATUS_IO_REPARSE_TAG_INVALID);
	CASE_RETURN_STR(STATUS_IO_REPARSE_TAG_MISMATCH);
	CASE_RETURN_STR(STATUS_IO_REPARSE_DATA_INVALID);
	CASE_RETURN_STR(STATUS_IO_REPARSE_TAG_NOT_HANDLED);
	CASE_RETURN_STR(STATUS_REPARSE_POINT_NOT_RESOLVED);
	CASE_RETURN_STR(STATUS_DIRECTORY_IS_A_REPARSE_POINT);
	CASE_RETURN_STR(STATUS_RANGE_LIST_CONFLICT);
	CASE_RETURN_STR(STATUS_SOURCE_ELEMENT_EMPTY);
	CASE_RETURN_STR(STATUS_DESTINATION_ELEMENT_FULL);
	CASE_RETURN_STR(STATUS_ILLEGAL_ELEMENT_ADDRESS);
	CASE_RETURN_STR(STATUS_MAGAZINE_NOT_PRESENT);
	CASE_RETURN_STR(STATUS_REINITIALIZATION_NEEDED);
	CASE_RETURN_STR(STATUS_DEVICE_REQUIRES_CLEANING);
	CASE_RETURN_STR(STATUS_DEVICE_DOOR_OPEN);
	CASE_RETURN_STR(STATUS_ENCRYPTION_FAILED);
	CASE_RETURN_STR(STATUS_DECRYPTION_FAILED);
	CASE_RETURN_STR(STATUS_RANGE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_NO_RECOVERY_POLICY);
	CASE_RETURN_STR(STATUS_NO_EFS);
	CASE_RETURN_STR(STATUS_WRONG_EFS);
	CASE_RETURN_STR(STATUS_NO_USER_KEYS);
	CASE_RETURN_STR(STATUS_FILE_NOT_ENCRYPTED);
	CASE_RETURN_STR(STATUS_NOT_EXPORT_FORMAT);
	CASE_RETURN_STR(STATUS_FILE_ENCRYPTED);
	CASE_RETURN_STR(STATUS_WAKE_SYSTEM);
	CASE_RETURN_STR(STATUS_WMI_GUID_NOT_FOUND);
	CASE_RETURN_STR(STATUS_WMI_INSTANCE_NOT_FOUND);
	CASE_RETURN_STR(STATUS_WMI_ITEMID_NOT_FOUND);
	CASE_RETURN_STR(STATUS_WMI_TRY_AGAIN);
	CASE_RETURN_STR(STATUS_SHARED_POLICY);
	CASE_RETURN_STR(STATUS_POLICY_OBJECT_NOT_FOUND);
	CASE_RETURN_STR(STATUS_POLICY_ONLY_IN_DS);
	CASE_RETURN_STR(STATUS_VOLUME_NOT_UPGRADED);
	CASE_RETURN_STR(STATUS_REMOTE_STORAGE_NOT_ACTIVE);
	CASE_RETURN_STR(STATUS_REMOTE_STORAGE_MEDIA_ERROR);
	CASE_RETURN_STR(STATUS_NO_TRACKING_SERVICE);
	CASE_RETURN_STR(STATUS_SERVER_SID_MISMATCH);
	CASE_RETURN_STR(STATUS_DS_NO_ATTRIBUTE_OR_VALUE);
	CASE_RETURN_STR(STATUS_DS_INVALID_ATTRIBUTE_SYNTAX);
	CASE_RETURN_STR(STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED);
	CASE_RETURN_STR(STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS);
	CASE_RETURN_STR(STATUS_DS_BUSY);
	CASE_RETURN_STR(STATUS_DS_UNAVAILABLE);
	CASE_RETURN_STR(STATUS_DS_NO_RIDS_ALLOCATED);
	CASE_RETURN_STR(STATUS_DS_NO_MORE_RIDS);
	CASE_RETURN_STR(STATUS_DS_INCORRECT_ROLE_OWNER);
	CASE_RETURN_STR(STATUS_DS_RIDMGR_INIT_ERROR);
	CASE_RETURN_STR(STATUS_DS_OBJ_CLASS_VIOLATION);
	CASE_RETURN_STR(STATUS_DS_CANT_ON_NON_LEAF);
	CASE_RETURN_STR(STATUS_DS_CANT_ON_RDN);
	CASE_RETURN_STR(STATUS_DS_CANT_MOD_OBJ_CLASS);
	CASE_RETURN_STR(STATUS_DS_CROSS_DOM_MOVE_FAILED);
	CASE_RETURN_STR(STATUS_DS_GC_NOT_AVAILABLE);
	CASE_RETURN_STR(STATUS_DIRECTORY_SERVICE_REQUIRED);
	CASE_RETURN_STR(STATUS_REPARSE_ATTRIBUTE_CONFLICT);
	CASE_RETURN_STR(STATUS_CANT_ENABLE_DENY_ONLY);
	CASE_RETURN_STR(STATUS_FLOAT_MULTIPLE_FAULTS);
	CASE_RETURN_STR(STATUS_FLOAT_MULTIPLE_TRAPS);
	CASE_RETURN_STR(STATUS_DEVICE_REMOVED);
	CASE_RETURN_STR(STATUS_JOURNAL_DELETE_IN_PROGRESS);
	CASE_RETURN_STR(STATUS_JOURNAL_NOT_ACTIVE);
	CASE_RETURN_STR(STATUS_NOINTERFACE);
	CASE_RETURN_STR(STATUS_DS_ADMIN_LIMIT_EXCEEDED);
	CASE_RETURN_STR(STATUS_DRIVER_FAILED_SLEEP);
	CASE_RETURN_STR(STATUS_MUTUAL_AUTHENTICATION_FAILED);
	CASE_RETURN_STR(STATUS_CORRUPT_SYSTEM_FILE);
	CASE_RETURN_STR(STATUS_DATATYPE_MISALIGNMENT_ERROR);
	CASE_RETURN_STR(STATUS_WMI_READ_ONLY);
	CASE_RETURN_STR(STATUS_WMI_SET_FAILURE);
	CASE_RETURN_STR(STATUS_COMMITMENT_MINIMUM);
	CASE_RETURN_STR(STATUS_REG_NAT_CONSUMPTION);
	CASE_RETURN_STR(STATUS_TRANSPORT_FULL);
	CASE_RETURN_STR(STATUS_DS_SAM_INIT_FAILURE);
	CASE_RETURN_STR(STATUS_ONLY_IF_CONNECTED);
	CASE_RETURN_STR(STATUS_DS_SENSITIVE_GROUP_VIOLATION);
	CASE_RETURN_STR(STATUS_PNP_RESTART_ENUMERATION);
	CASE_RETURN_STR(STATUS_JOURNAL_ENTRY_DELETED);
	CASE_RETURN_STR(STATUS_DS_CANT_MOD_PRIMARYGROUPID);
	CASE_RETURN_STR(STATUS_SYSTEM_IMAGE_BAD_SIGNATURE);
	CASE_RETURN_STR(STATUS_PNP_REBOOT_REQUIRED);
	CASE_RETURN_STR(STATUS_POWER_STATE_INVALID);
	CASE_RETURN_STR(STATUS_DS_INVALID_GROUP_TYPE);
	CASE_RETURN_STR(STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN);
	CASE_RETURN_STR(STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN);
	CASE_RETURN_STR(STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER);
	CASE_RETURN_STR(STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER);
	CASE_RETURN_STR(STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER);
	CASE_RETURN_STR(STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER);
	CASE_RETURN_STR(STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER);
	CASE_RETURN_STR(STATUS_DS_HAVE_PRIMARY_MEMBERS);
	CASE_RETURN_STR(STATUS_WMI_NOT_SUPPORTED);
	CASE_RETURN_STR(STATUS_INSUFFICIENT_POWER);
	CASE_RETURN_STR(STATUS_SAM_NEED_BOOTKEY_PASSWORD);
	CASE_RETURN_STR(STATUS_SAM_NEED_BOOTKEY_FLOPPY);
	CASE_RETURN_STR(STATUS_DS_CANT_START);
	CASE_RETURN_STR(STATUS_DS_INIT_FAILURE);
	CASE_RETURN_STR(STATUS_SAM_INIT_FAILURE);
	CASE_RETURN_STR(STATUS_DS_GC_REQUIRED);
	CASE_RETURN_STR(STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY);
	CASE_RETURN_STR(STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS);
	CASE_RETURN_STR(STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED);
	CASE_RETURN_STR(STATUS_MULTIPLE_FAULT_VIOLATION);
	CASE_RETURN_STR(STATUS_NOT_SUPPORTED_ON_SBS);
	CASE_RETURN_STR(STATUS_WOW_ASSERTION);
	CASE_RETURN_STR(DBG_NO_STATE_CHANGE);
	CASE_RETURN_STR(DBG_APP_NOT_IDLE);
	CASE_RETURN_STR(RPC_NT_INVALID_STRING_BINDING);
	CASE_RETURN_STR(RPC_NT_WRONG_KIND_OF_BINDING);
	CASE_RETURN_STR(RPC_NT_INVALID_BINDING);
	CASE_RETURN_STR(RPC_NT_PROTSEQ_NOT_SUPPORTED);
	CASE_RETURN_STR(RPC_NT_INVALID_RPC_PROTSEQ);
	CASE_RETURN_STR(RPC_NT_INVALID_STRING_UUID);
	CASE_RETURN_STR(RPC_NT_INVALID_ENDPOINT_FORMAT);
	CASE_RETURN_STR(RPC_NT_INVALID_NET_ADDR);
	CASE_RETURN_STR(RPC_NT_NO_ENDPOINT_FOUND);
	CASE_RETURN_STR(RPC_NT_INVALID_TIMEOUT);
	CASE_RETURN_STR(RPC_NT_OBJECT_NOT_FOUND);
	CASE_RETURN_STR(RPC_NT_ALREADY_REGISTERED);
	CASE_RETURN_STR(RPC_NT_TYPE_ALREADY_REGISTERED);
	CASE_RETURN_STR(RPC_NT_ALREADY_LISTENING);
	CASE_RETURN_STR(RPC_NT_NO_PROTSEQS_REGISTERED);
	CASE_RETURN_STR(RPC_NT_NOT_LISTENING);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_MGR_TYPE);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_IF);
	CASE_RETURN_STR(RPC_NT_NO_BINDINGS);
	CASE_RETURN_STR(RPC_NT_NO_PROTSEQS);
	CASE_RETURN_STR(RPC_NT_CANT_CREATE_ENDPOINT);
	CASE_RETURN_STR(RPC_NT_OUT_OF_RESOURCES);
	CASE_RETURN_STR(RPC_NT_SERVER_UNAVAILABLE);
	CASE_RETURN_STR(RPC_NT_SERVER_TOO_BUSY);
	CASE_RETURN_STR(RPC_NT_INVALID_NETWORK_OPTIONS);
	CASE_RETURN_STR(RPC_NT_NO_CALL_ACTIVE);
	CASE_RETURN_STR(RPC_NT_CALL_FAILED);
	CASE_RETURN_STR(RPC_NT_CALL_FAILED_DNE);
	CASE_RETURN_STR(RPC_NT_PROTOCOL_ERROR);
	CASE_RETURN_STR(RPC_NT_UNSUPPORTED_TRANS_SYN);
	CASE_RETURN_STR(RPC_NT_UNSUPPORTED_TYPE);
	CASE_RETURN_STR(RPC_NT_INVALID_TAG);
	CASE_RETURN_STR(RPC_NT_INVALID_BOUND);
	CASE_RETURN_STR(RPC_NT_NO_ENTRY_NAME);
	CASE_RETURN_STR(RPC_NT_INVALID_NAME_SYNTAX);
	CASE_RETURN_STR(RPC_NT_UNSUPPORTED_NAME_SYNTAX);
	CASE_RETURN_STR(RPC_NT_UUID_NO_ADDRESS);
	CASE_RETURN_STR(RPC_NT_DUPLICATE_ENDPOINT);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_AUTHN_TYPE);
	CASE_RETURN_STR(RPC_NT_MAX_CALLS_TOO_SMALL);
	CASE_RETURN_STR(RPC_NT_STRING_TOO_LONG);
	CASE_RETURN_STR(RPC_NT_PROTSEQ_NOT_FOUND);
	CASE_RETURN_STR(RPC_NT_PROCNUM_OUT_OF_RANGE);
	CASE_RETURN_STR(RPC_NT_BINDING_HAS_NO_AUTH);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_AUTHN_SERVICE);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_AUTHN_LEVEL);
	CASE_RETURN_STR(RPC_NT_INVALID_AUTH_IDENTITY);
	CASE_RETURN_STR(RPC_NT_UNKNOWN_AUTHZ_SERVICE);
	CASE_RETURN_STR(EPT_NT_INVALID_ENTRY);
	CASE_RETURN_STR(EPT_NT_CANT_PERFORM_OP);
	CASE_RETURN_STR(EPT_NT_NOT_REGISTERED);
	CASE_RETURN_STR(RPC_NT_NOTHING_TO_EXPORT);
	CASE_RETURN_STR(RPC_NT_INCOMPLETE_NAME);
	CASE_RETURN_STR(RPC_NT_INVALID_VERS_OPTION);
	CASE_RETURN_STR(RPC_NT_NO_MORE_MEMBERS);
	CASE_RETURN_STR(RPC_NT_NOT_ALL_OBJS_UNEXPORTED);
	CASE_RETURN_STR(RPC_NT_INTERFACE_NOT_FOUND);
	CASE_RETURN_STR(RPC_NT_ENTRY_ALREADY_EXISTS);
	CASE_RETURN_STR(RPC_NT_ENTRY_NOT_FOUND);
	CASE_RETURN_STR(RPC_NT_NAME_SERVICE_UNAVAILABLE);
	CASE_RETURN_STR(RPC_NT_INVALID_NAF_ID);
	CASE_RETURN_STR(RPC_NT_CANNOT_SUPPORT);
	CASE_RETURN_STR(RPC_NT_NO_CONTEXT_AVAILABLE);
	CASE_RETURN_STR(RPC_NT_INTERNAL_ERROR);
	CASE_RETURN_STR(RPC_NT_ZERO_DIVIDE);
	CASE_RETURN_STR(RPC_NT_ADDRESS_ERROR);
	CASE_RETURN_STR(RPC_NT_FP_DIV_ZERO);
	CASE_RETURN_STR(RPC_NT_FP_UNDERFLOW);
	CASE_RETURN_STR(RPC_NT_FP_OVERFLOW);
	CASE_RETURN_STR(RPC_NT_NO_MORE_ENTRIES);
	CASE_RETURN_STR(RPC_NT_SS_CHAR_TRANS_OPEN_FAIL);
	CASE_RETURN_STR(RPC_NT_SS_CHAR_TRANS_SHORT_FILE);
	CASE_RETURN_STR(RPC_NT_SS_IN_NULL_CONTEXT);
	CASE_RETURN_STR(RPC_NT_SS_CONTEXT_MISMATCH);
	CASE_RETURN_STR(RPC_NT_SS_CONTEXT_DAMAGED);
	CASE_RETURN_STR(RPC_NT_SS_HANDLES_MISMATCH);
	CASE_RETURN_STR(RPC_NT_SS_CANNOT_GET_CALL_HANDLE);
	CASE_RETURN_STR(RPC_NT_NULL_REF_POINTER);
	CASE_RETURN_STR(RPC_NT_ENUM_VALUE_OUT_OF_RANGE);
	CASE_RETURN_STR(RPC_NT_BYTE_COUNT_TOO_SMALL);
	CASE_RETURN_STR(RPC_NT_BAD_STUB_DATA);
	CASE_RETURN_STR(RPC_NT_CALL_IN_PROGRESS);
	CASE_RETURN_STR(RPC_NT_NO_MORE_BINDINGS);
	CASE_RETURN_STR(RPC_NT_GROUP_MEMBER_NOT_FOUND);
	CASE_RETURN_STR(EPT_NT_CANT_CREATE);
	CASE_RETURN_STR(RPC_NT_INVALID_OBJECT);
	CASE_RETURN_STR(RPC_NT_NO_INTERFACES);
	CASE_RETURN_STR(RPC_NT_CALL_CANCELLED);
	CASE_RETURN_STR(RPC_NT_BINDING_INCOMPLETE);
	CASE_RETURN_STR(RPC_NT_COMM_FAILURE);
	CASE_RETURN_STR(RPC_NT_UNSUPPORTED_AUTHN_LEVEL);
	CASE_RETURN_STR(RPC_NT_NO_PRINC_NAME);
	CASE_RETURN_STR(RPC_NT_NOT_RPC_ERROR);
	CASE_RETURN_STR(RPC_NT_UUID_LOCAL_ONLY);
	CASE_RETURN_STR(RPC_NT_SEC_PKG_ERROR);
	CASE_RETURN_STR(RPC_NT_NOT_CANCELLED);
	CASE_RETURN_STR(RPC_NT_INVALID_ES_ACTION);
	CASE_RETURN_STR(RPC_NT_WRONG_ES_VERSION);
	CASE_RETURN_STR(RPC_NT_WRONG_STUB_VERSION);
	CASE_RETURN_STR(RPC_NT_INVALID_PIPE_OBJECT);
	CASE_RETURN_STR(RPC_NT_INVALID_PIPE_OPERATION);
	CASE_RETURN_STR(RPC_NT_WRONG_PIPE_VERSION);
	CASE_RETURN_STR(RPC_NT_PIPE_CLOSED);
	CASE_RETURN_STR(RPC_NT_PIPE_DISCIPLINE_ERROR);
	CASE_RETURN_STR(RPC_NT_PIPE_EMPTY);
	CASE_RETURN_STR(RPC_NT_INVALID_ASYNC_HANDLE);
	CASE_RETURN_STR(RPC_NT_INVALID_ASYNC_CALL);
	CASE_RETURN_STR(RPC_NT_SEND_INCOMPLETE);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_OPCODE);
	CASE_RETURN_STR(STATUS_ACPI_STACK_OVERFLOW);
	CASE_RETURN_STR(STATUS_ACPI_ASSERT_FAILED);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_INDEX);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_ARGUMENT);
	CASE_RETURN_STR(STATUS_ACPI_FATAL);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_SUPERNAME);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_ARGTYPE);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_OBJTYPE);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_TARGETTYPE);
	CASE_RETURN_STR(STATUS_ACPI_INCORRECT_ARGUMENT_COUNT);
	CASE_RETURN_STR(STATUS_ACPI_ADDRESS_NOT_MAPPED);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_EVENTTYPE);
	CASE_RETURN_STR(STATUS_ACPI_HANDLER_COLLISION);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_DATA);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_REGION);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_ACCESS_SIZE);
	CASE_RETURN_STR(STATUS_ACPI_ACQUIRE_GLOBAL_LOCK);
	CASE_RETURN_STR(STATUS_ACPI_ALREADY_INITIALIZED);
	CASE_RETURN_STR(STATUS_ACPI_NOT_INITIALIZED);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_MUTEX_LEVEL);
	CASE_RETURN_STR(STATUS_ACPI_MUTEX_NOT_OWNED);
	CASE_RETURN_STR(STATUS_ACPI_MUTEX_NOT_OWNER);
	CASE_RETURN_STR(STATUS_ACPI_RS_ACCESS);
	CASE_RETURN_STR(STATUS_ACPI_INVALID_TABLE);
	CASE_RETURN_STR(STATUS_ACPI_REG_HANDLER_FAILED);
	CASE_RETURN_STR(STATUS_ACPI_POWER_REQUEST_FAILED);
	CASE_RETURN_STR(STATUS_CTX_WINSTATION_NAME_INVALID);
	CASE_RETURN_STR(STATUS_CTX_INVALID_PD);
	CASE_RETURN_STR(STATUS_CTX_PD_NOT_FOUND);
	CASE_RETURN_STR(STATUS_CTX_CDM_CONNECT);
	CASE_RETURN_STR(STATUS_CTX_CDM_DISCONNECT);
	CASE_RETURN_STR(STATUS_CTX_CLOSE_PENDING);
	CASE_RETURN_STR(STATUS_CTX_NO_OUTBUF);
	CASE_RETURN_STR(STATUS_CTX_MODEM_INF_NOT_FOUND);
	CASE_RETURN_STR(STATUS_CTX_INVALID_MODEMNAME);
	CASE_RETURN_STR(STATUS_CTX_RESPONSE_ERROR);
	CASE_RETURN_STR(STATUS_CTX_MODEM_RESPONSE_TIMEOUT);
	CASE_RETURN_STR(STATUS_CTX_MODEM_RESPONSE_NO_CARRIER);
	CASE_RETURN_STR(STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE);
	CASE_RETURN_STR(STATUS_CTX_MODEM_RESPONSE_BUSY);
	CASE_RETURN_STR(STATUS_CTX_MODEM_RESPONSE_VOICE);
	CASE_RETURN_STR(STATUS_CTX_TD_ERROR);
	CASE_RETURN_STR(STATUS_CTX_LICENSE_CLIENT_INVALID);
	CASE_RETURN_STR(STATUS_CTX_LICENSE_NOT_AVAILABLE);
	CASE_RETURN_STR(STATUS_CTX_LICENSE_EXPIRED);
	CASE_RETURN_STR(STATUS_CTX_WINSTATION_NOT_FOUND);
	CASE_RETURN_STR(STATUS_CTX_WINSTATION_NAME_COLLISION);
	CASE_RETURN_STR(STATUS_CTX_WINSTATION_BUSY);
	CASE_RETURN_STR(STATUS_CTX_BAD_VIDEO_MODE);
	CASE_RETURN_STR(STATUS_CTX_GRAPHICS_INVALID);
	CASE_RETURN_STR(STATUS_CTX_NOT_CONSOLE);
	CASE_RETURN_STR(STATUS_CTX_CLIENT_QUERY_TIMEOUT);
	CASE_RETURN_STR(STATUS_CTX_CONSOLE_DISCONNECT);
	CASE_RETURN_STR(STATUS_CTX_CONSOLE_CONNECT);
	CASE_RETURN_STR(STATUS_CTX_SHADOW_DENIED);
	CASE_RETURN_STR(STATUS_CTX_WINSTATION_ACCESS_DENIED);
	CASE_RETURN_STR(STATUS_CTX_INVALID_WD);
	CASE_RETURN_STR(STATUS_CTX_WD_NOT_FOUND);
	CASE_RETURN_STR(STATUS_CTX_SHADOW_INVALID);
	CASE_RETURN_STR(STATUS_CTX_SHADOW_DISABLED);
	CASE_RETURN_STR(STATUS_RDP_PROTOCOL_ERROR);
	CASE_RETURN_STR(STATUS_CTX_CLIENT_LICENSE_NOT_SET);
	CASE_RETURN_STR(STATUS_CTX_CLIENT_LICENSE_IN_USE);
	CASE_RETURN_STR(STATUS_PNP_BAD_MPS_TABLE);
	CASE_RETURN_STR(STATUS_PNP_TRANSLATION_FAILED);
	CASE_RETURN_STR(STATUS_PNP_IRQ_TRANSLATION_FAILED);
	default:
		return "Unknown";
	}
}
#endif	// DBG
