/*
 * ntiologc.h
 *
 * This file is part of the ReactOS PSDK package.
 *
 * Contributors:
 *   Created by Amine Khaldi.
 *
 * THIS SOFTWARE IS NOT COPYRIGHTED
 *
 * This source code is offered for use in the public domain. You may
 * use, modify or distribute it freely.
 *
 * This code is distributed in the hope that it will be useful but
 * WITHOUT ANY WARRANTY. ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
 * DISCLAIMED. This includes but is not limited to warranties of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#pragma once

#define FACILITY_RPC_RUNTIME             0x2
#define FACILITY_RPC_STUBS               0x3
#define FACILITY_IO_ERROR_CODE           0x4
#define FACILITY_MCA_ERROR_CODE          0x5

#define IO_ERR_RETRY_SUCCEEDED           ((NTSTATUS)0x00040001L)
#define IO_ERR_INSUFFICIENT_RESOURCES    ((NTSTATUS)0xC0040002L)
#define IO_ERR_CONFIGURATION_ERROR       ((NTSTATUS)0xC0040003L)
#define IO_ERR_DRIVER_ERROR              ((NTSTATUS)0xC0040004L)
#define IO_ERR_PARITY                    ((NTSTATUS)0xC0040005L)
#define IO_ERR_SEEK_ERROR                ((NTSTATUS)0xC0040006L)
#define IO_ERR_BAD_BLOCK                 ((NTSTATUS)0xC0040007L)
#define IO_ERR_OVERRUN_ERROR             ((NTSTATUS)0xC0040008L)
#define IO_ERR_TIMEOUT                   ((NTSTATUS)0xC0040009L)
#define IO_ERR_SEQUENCE                  ((NTSTATUS)0xC004000AL)
#define IO_ERR_CONTROLLER_ERROR          ((NTSTATUS)0xC004000BL)
#define IO_ERR_INTERNAL_ERROR            ((NTSTATUS)0xC004000CL)
#define IO_ERR_INCORRECT_IRQL            ((NTSTATUS)0xC004000DL)
#define IO_ERR_INVALID_IOBASE            ((NTSTATUS)0xC004000EL)
#define IO_ERR_NOT_READY                 ((NTSTATUS)0xC004000FL)
#define IO_ERR_INVALID_REQUEST           ((NTSTATUS)0xC0040010L)
#define IO_ERR_VERSION                   ((NTSTATUS)0xC0040011L)
#define IO_ERR_LAYERED_FAILURE           ((NTSTATUS)0xC0040012L)
#define IO_ERR_RESET                     ((NTSTATUS)0xC0040013L)
#define IO_ERR_PROTOCOL                  ((NTSTATUS)0xC0040014L)
#define IO_ERR_MEMORY_CONFLICT_DETECTED  ((NTSTATUS)0xC0040015L)
#define IO_ERR_PORT_CONFLICT_DETECTED    ((NTSTATUS)0xC0040016L)
#define IO_ERR_DMA_CONFLICT_DETECTED     ((NTSTATUS)0xC0040017L)
#define IO_ERR_IRQ_CONFLICT_DETECTED     ((NTSTATUS)0xC0040018L)
#define IO_ERR_BAD_FIRMWARE              ((NTSTATUS)0xC0040019L)
#define IO_WRN_BAD_FIRMWARE              ((NTSTATUS)0x8004001AL)
#define IO_ERR_DMA_RESOURCE_CONFLICT     ((NTSTATUS)0xC004001BL)
#define IO_ERR_INTERRUPT_RESOURCE_CONFLICT ((NTSTATUS)0xC004001CL)
#define IO_ERR_MEMORY_RESOURCE_CONFLICT  ((NTSTATUS)0xC004001DL)
#define IO_ERR_PORT_RESOURCE_CONFLICT    ((NTSTATUS)0xC004001EL)
#define IO_BAD_BLOCK_WITH_NAME           ((NTSTATUS)0xC004001FL)
#define IO_WRITE_CACHE_ENABLED           ((NTSTATUS)0x80040020L)
#define IO_RECOVERED_VIA_ECC             ((NTSTATUS)0x80040021L)
#define IO_WRITE_CACHE_DISABLED          ((NTSTATUS)0x80040022L)
#define IO_FILE_QUOTA_THRESHOLD          ((NTSTATUS)0x40040024L)
#define IO_FILE_QUOTA_LIMIT              ((NTSTATUS)0x40040025L)
#define IO_FILE_QUOTA_STARTED            ((NTSTATUS)0x40040026L)
#define IO_FILE_QUOTA_SUCCEEDED          ((NTSTATUS)0x40040027L)
#define IO_FILE_QUOTA_FAILED             ((NTSTATUS)0x80040028L)
#define IO_FILE_SYSTEM_CORRUPT           ((NTSTATUS)0xC0040029L)
#define IO_FILE_QUOTA_CORRUPT            ((NTSTATUS)0xC004002AL)
#define IO_SYSTEM_SLEEP_FAILED           ((NTSTATUS)0xC004002BL)
#define IO_DUMP_POINTER_FAILURE          ((NTSTATUS)0xC004002CL)
#define IO_DUMP_DRIVER_LOAD_FAILURE      ((NTSTATUS)0xC004002DL)
#define IO_DUMP_INITIALIZATION_FAILURE   ((NTSTATUS)0xC004002EL)
#define IO_DUMP_DUMPFILE_CONFLICT        ((NTSTATUS)0xC004002FL)
#define IO_DUMP_DIRECT_CONFIG_FAILED     ((NTSTATUS)0xC0040030L)
#define IO_DUMP_PAGE_CONFIG_FAILED       ((NTSTATUS)0xC0040031L)
#define IO_LOST_DELAYED_WRITE            ((NTSTATUS)0x80040032L)
#define IO_WARNING_PAGING_FAILURE        ((NTSTATUS)0x80040033L)
#define IO_WRN_FAILURE_PREDICTED         ((NTSTATUS)0x80040034L)
#define IO_WARNING_INTERRUPT_STILL_PENDING ((NTSTATUS)0x80040035L)
#define IO_DRIVER_CANCEL_TIMEOUT         ((NTSTATUS)0x80040036L)
#define IO_FILE_SYSTEM_CORRUPT_WITH_NAME ((NTSTATUS)0xC0040037L)
#define IO_WARNING_ALLOCATION_FAILED     ((NTSTATUS)0x80040038L)
#define IO_WARNING_LOG_FLUSH_FAILED      ((NTSTATUS)0x80040039L)
#define IO_WARNING_DUPLICATE_SIGNATURE   ((NTSTATUS)0x8004003AL)
#define IO_WARNING_DUPLICATE_PATH        ((NTSTATUS)0x8004003BL)
#define IO_ERR_THREAD_STUCK_IN_DEVICE_DRIVER ((NTSTATUS)0xC004006CL)
#define IO_ERR_PORT_TIMEOUT              ((NTSTATUS)0xC0040075L)
#define IO_WARNING_BUS_RESET             ((NTSTATUS)0x80040076L)
#define IO_INFO_THROTTLE_COMPLETE        ((NTSTATUS)0x40040077L)
#define IO_WARNING_RESET                 ((NTSTATUS)0x80040081L)
#define IO_FILE_SYSTEM_REPAIR_SUCCESS    ((NTSTATUS)0x80040082L)
#define IO_FILE_SYSTEM_REPAIR_FAILED     ((NTSTATUS)0xC0040083L)
#define IO_WARNING_WRITE_FUA_PROBLEM     ((NTSTATUS)0x80040084L)
#define IO_CDROM_EXCLUSIVE_LOCK          ((NTSTATUS)0x40040085L)
#define IO_FILE_SYSTEM_TXF_RECOVERY_FAILURE ((NTSTATUS)0x80040086L)
#define IO_FILE_SYSTEM_TXF_LOG_FULL_HANDLING_FAILED ((NTSTATUS)0xC0040087L)
#define IO_FILE_SYSTEM_TXF_RESOURCE_MANAGER_RESET ((NTSTATUS)0x80040088L)
#define IO_FILE_SYSTEM_TXF_RESOURCE_MANAGER_START_FAILED ((NTSTATUS)0xC0040089L)
#define IO_FILE_SYSTEM_TXF_RESOURCE_MANAGER_SHUT_DOWN ((NTSTATUS)0xC004008AL)
#define IO_LOST_DELAYED_WRITE_NETWORK_DISCONNECTED ((NTSTATUS)0x8004008BL)
#define IO_LOST_DELAYED_WRITE_NETWORK_SERVER_ERROR ((NTSTATUS)0x8004008CL)
#define IO_LOST_DELAYED_WRITE_NETWORK_LOCAL_DISK_ERROR ((NTSTATUS)0x8004008DL)
#define IO_WARNING_VOLUME_LOST_DISK_EXTENT ((NTSTATUS)0x8004008EL)
#define IO_WARNING_DEVICE_HAS_INTERNAL_DUMP ((NTSTATUS)0x8004008FL)
#define IO_WARNING_SOFT_THRESHOLD_REACHED ((NTSTATUS)0x80040090L)
#define IO_WARNING_SOFT_THRESHOLD_REACHED_EX ((NTSTATUS)0x80040091L)
#define IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_LUN ((NTSTATUS)0x80040092L)
#define IO_WARNING_SOFT_THRESHOLD_REACHED_EX_LUN_POOL ((NTSTATUS)0x80040093L)
#define IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_LUN ((NTSTATUS)0x80040094L)
#define IO_WARNING_SOFT_THRESHOLD_REACHED_EX_POOL_POOL ((NTSTATUS)0x80040095L)
#define IO_ERROR_DISK_RESOURCES_EXHAUSTED ((NTSTATUS)0xC0040096L)
#define IO_WARNING_DISK_CAPACITY_CHANGED ((NTSTATUS)0x80040097L)
#define IO_WARNING_DISK_PROVISIONING_TYPE_CHANGED ((NTSTATUS)0x80040098L)
#define IO_WARNING_IO_OPERATION_RETRIED  ((NTSTATUS)0x80040099L)
#define IO_ERROR_IO_HARDWARE_ERROR       ((NTSTATUS)0xC004009AL)
#define IO_WARNING_COMPLETION_TIME       ((NTSTATUS)0x8004009BL)
#define IO_WARNING_DUMP_DISABLED_DEVICE_GONE ((NTSTATUS)0x8004009CL)
#define IO_WARNING_DISK_SURPRISE_REMOVED ((NTSTATUS)0x8004009DL)
#define IO_WARNING_REPEATED_DISK_GUID    ((NTSTATUS)0x8004009EL)
#define IO_WARNING_DISK_FIRMWARE_UPDATED ((NTSTATUS)0x4004009FL)
#define IO_WARNING_ADAPTER_FIRMWARE_UPDATED ((NTSTATUS)0x400400A0L)
#define IO_ERROR_DUMP_CREATION_ERROR     ((NTSTATUS)0xC00400A1L)

#define MCA_WARNING_CACHE                ((NTSTATUS)0x8005003CL)
#define MCA_ERROR_CACHE                  ((NTSTATUS)0xC005003DL)
#define MCA_WARNING_TLB                  ((NTSTATUS)0x8005003EL)
#define MCA_ERROR_TLB                    ((NTSTATUS)0xC005003FL)
#define MCA_WARNING_CPU_BUS              ((NTSTATUS)0x80050040L)
#define MCA_ERROR_CPU_BUS                ((NTSTATUS)0xC0050041L)
#define MCA_WARNING_REGISTER_FILE        ((NTSTATUS)0x80050042L)
#define MCA_ERROR_REGISTER_FILE          ((NTSTATUS)0xC0050043L)
#define MCA_WARNING_MAS                  ((NTSTATUS)0x80050044L)
#define MCA_ERROR_MAS                    ((NTSTATUS)0xC0050045L)
#define MCA_WARNING_MEM_UNKNOWN          ((NTSTATUS)0x80050046L)
#define MCA_ERROR_MEM_UNKNOWN            ((NTSTATUS)0xC0050047L)
#define MCA_WARNING_MEM_1_2              ((NTSTATUS)0x80050048L)
#define MCA_ERROR_MEM_1_2                ((NTSTATUS)0xC0050049L)
#define MCA_WARNING_MEM_1_2_5            ((NTSTATUS)0x8005004AL)
#define MCA_ERROR_MEM_1_2_5              ((NTSTATUS)0xC005004BL)
#define MCA_WARNING_MEM_1_2_5_4          ((NTSTATUS)0x8005004CL)
#define MCA_ERROR_MEM_1_2_5_4            ((NTSTATUS)0xC005004DL)
#define MCA_WARNING_SYSTEM_EVENT         ((NTSTATUS)0x8005004EL)
#define MCA_ERROR_SYSTEM_EVENT           ((NTSTATUS)0xC005004FL)
#define MCA_WARNING_PCI_BUS_PARITY       ((NTSTATUS)0x80050050L)
#define MCA_ERROR_PCI_BUS_PARITY         ((NTSTATUS)0xC0050051L)
#define MCA_WARNING_PCI_BUS_PARITY_NO_INFO ((NTSTATUS)0x80050052L)
#define MCA_ERROR_PCI_BUS_PARITY_NO_INFO ((NTSTATUS)0xC0050053L)
#define MCA_WARNING_PCI_BUS_SERR         ((NTSTATUS)0x80050054L)
#define MCA_ERROR_PCI_BUS_SERR           ((NTSTATUS)0xC0050055L)
#define MCA_WARNING_PCI_BUS_SERR_NO_INFO ((NTSTATUS)0x80050056L)
#define MCA_ERROR_PCI_BUS_SERR_NO_INFO   ((NTSTATUS)0xC0050057L)
#define MCA_WARNING_PCI_BUS_MASTER_ABORT ((NTSTATUS)0x80050058L)
#define MCA_ERROR_PCI_BUS_MASTER_ABORT   ((NTSTATUS)0xC0050059L)
#define MCA_WARNING_PCI_BUS_MASTER_ABORT_NO_INFO ((NTSTATUS)0x8005005AL)
#define MCA_ERROR_PCI_BUS_MASTER_ABORT_NO_INFO ((NTSTATUS)0xC005005BL)
#define MCA_WARNING_PCI_BUS_TIMEOUT      ((NTSTATUS)0x8005005CL)
#define MCA_ERROR_PCI_BUS_TIMEOUT        ((NTSTATUS)0xC005005DL)
#define MCA_WARNING_PCI_BUS_TIMEOUT_NO_INFO ((NTSTATUS)0x8005005EL)
#define MCA_ERROR_PCI_BUS_TIMEOUT_NO_INFO ((NTSTATUS)0xC005005FL)
#define MCA_WARNING_PCI_BUS_UNKNOWN      ((NTSTATUS)0x80050060L)
#define MCA_ERROR_PCI_BUS_UNKNOWN        ((NTSTATUS)0xC0050061L)
#define MCA_WARNING_PCI_DEVICE           ((NTSTATUS)0x80050062L)
#define MCA_ERROR_PCI_DEVICE             ((NTSTATUS)0xC0050063L)
#define MCA_WARNING_SMBIOS               ((NTSTATUS)0x80050064L)
#define MCA_ERROR_SMBIOS                 ((NTSTATUS)0xC0050065L)
#define MCA_WARNING_PLATFORM_SPECIFIC    ((NTSTATUS)0x80050066L)
#define MCA_ERROR_PLATFORM_SPECIFIC      ((NTSTATUS)0xC0050067L)
#define MCA_WARNING_UNKNOWN              ((NTSTATUS)0x80050068L)
#define MCA_ERROR_UNKNOWN                ((NTSTATUS)0xC0050069L)
#define MCA_WARNING_UNKNOWN_NO_CPU       ((NTSTATUS)0x8005006AL)
#define MCA_ERROR_UNKNOWN_NO_CPU         ((NTSTATUS)0xC005006BL)
#define MCA_WARNING_CMC_THRESHOLD_EXCEEDED ((NTSTATUS)0x8005006DL)
#define MCA_WARNING_CPE_THRESHOLD_EXCEEDED ((NTSTATUS)0x8005006EL)
#define MCA_WARNING_CPU_THERMAL_THROTTLED ((NTSTATUS)0x8005006FL)
#define MCA_INFO_CPU_THERMAL_THROTTLING_REMOVED ((NTSTATUS)0x40050070L)
#define MCA_WARNING_CPU                  ((NTSTATUS)0x80050071L)
#define MCA_ERROR_CPU                    ((NTSTATUS)0xC0050072L)
#define MCA_INFO_NO_MORE_CORRECTED_ERROR_LOGS ((NTSTATUS)0x40050073L)
#define MCA_INFO_MEMORY_PAGE_MARKED_BAD  ((NTSTATUS)0x40050074L)
#define MCA_MEMORYHIERARCHY_ERROR        ((NTSTATUS)0xC0050078L)
#define MCA_TLB_ERROR                    ((NTSTATUS)0xC0050079L)
#define MCA_BUS_ERROR                    ((NTSTATUS)0xC005007AL)
#define MCA_BUS_TIMEOUT_ERROR            ((NTSTATUS)0xC005007BL)
#define MCA_INTERNALTIMER_ERROR          ((NTSTATUS)0xC005007CL)
#define MCA_MICROCODE_ROM_PARITY_ERROR   ((NTSTATUS)0xC005007EL)
#define MCA_EXTERNAL_ERROR               ((NTSTATUS)0xC005007FL)
#define MCA_FRC_ERROR                    ((NTSTATUS)0xC0050080L)

#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_ERROR            0x3
