/*
 * PROJECT:     ReactOS PSDK
 * LICENSE:     MIT (https://spdx.org/licenses/MIT)
 * PURPOSE:     Undefines SAL definitions
 * COPYRIGHT:   Copyright 2020 Timo Kreuzer <timo.kreuzer@reactos.org>
 */

#pragma once

#undef __ecount
#undef __bcount
#undef __xcount
#undef __in
#undef __in_ecount
#undef __in_bcount
#undef __in_xcount
#undef __in_z
#undef __in_ecount_z
#undef __in_bcount_z
#undef __out
#undef __out_ecount
#undef __out_bcount
#undef __out_xcount
#undef __out_ecount_part
#undef __out_bcount_part
#undef __out_xcount_part
#undef __out_ecount_full
#undef __out_bcount_full
#undef __out_xcount_full
#undef __out_z
#undef __out_ecount_z
#undef __out_bcount_z
#undef __inout
#undef __inout_ecount
#undef __inout_bcount
#undef __inout_xcount
#undef __inout_ecount_part
#undef __inout_bcount_part
#undef __inout_xcount_part
#undef __inout_ecount_full
#undef __inout_bcount_full
#undef __inout_xcount_full
#undef __inout_z
#undef __inout_ecount_z
#undef __inout_bcount_z
#undef __ecount_opt
#undef __bcount_opt
#undef __xcount_opt
#undef __in_opt
#undef __in_ecount_opt
#undef __in_bcount_opt
#undef __in_z_opt
#undef __in_ecount_z_opt
#undef __in_bcount_z_opt
#undef __in_xcount_opt
#undef __out_opt
#undef __out_ecount_opt
#undef __out_bcount_opt
#undef __out_xcount_opt
#undef __out_ecount_part_opt
#undef __out_bcount_part_opt
#undef __out_xcount_part_opt
#undef __out_ecount_full_opt
#undef __out_bcount_full_opt
#undef __out_xcount_full_opt
#undef __out_ecount_z_opt
#undef __out_bcount_z_opt
#undef __inout_opt
#undef __inout_ecount_opt
#undef __inout_bcount_opt
#undef __inout_xcount_opt
#undef __inout_ecount_part_opt
#undef __inout_bcount_part_opt
#undef __inout_xcount_part_opt
#undef __inout_ecount_full_opt
#undef __inout_bcount_full_opt
#undef __inout_xcount_full_opt
#undef __inout_z_opt
#undef __inout_ecount_z_opt
#undef __inout_ecount_z_opt
#undef __inout_bcount_z_opt
#undef __deref_ecount
#undef __deref_bcount
#undef __deref_xcount
#undef __deref_in
#undef __deref_in_ecount
#undef __deref_in_bcount
#undef __deref_in_xcount
#undef __deref_out
#undef __deref_out_ecount
#undef __deref_out_bcount
#undef __deref_out_xcount
#undef __deref_out_ecount_part
#undef __deref_out_bcount_part
#undef __deref_out_xcount_part
#undef __deref_out_ecount_full
#undef __deref_out_bcount_full
#undef __deref_out_xcount_full
#undef __deref_out_z
#undef __deref_out_ecount_z
#undef __deref_out_bcount_z
#undef __deref_inout
#undef __deref_inout_ecount
#undef __deref_inout_bcount
#undef __deref_inout_xcount
#undef __deref_inout_ecount_part
#undef __deref_inout_bcount_part
#undef __deref_inout_xcount_part
#undef __deref_inout_ecount_full
#undef __deref_inout_bcount_full
#undef __deref_inout_xcount_full
#undef __deref_inout_z
#undef __deref_inout_ecount_z
#undef __deref_inout_bcount_z
#undef __deref_ecount_opt
#undef __deref_bcount_opt
#undef __deref_xcount_opt
#undef __deref_in_opt
#undef __deref_in_opt_out
#undef __deref_in_ecount_opt
#undef __deref_in_bcount_opt
#undef __deref_in_xcount_opt
#undef __deref_out_opt
#undef __deref_out_ecount_opt
#undef __deref_out_bcount_opt
#undef __deref_out_xcount_opt
#undef __deref_out_ecount_part_opt
#undef __deref_out_bcount_part_opt
#undef __deref_out_xcount_part_opt
#undef __deref_out_ecount_full_opt
#undef __deref_out_bcount_full_opt
#undef __deref_out_xcount_full_opt
#undef __deref_out_z_opt
#undef __deref_out_ecount_z_opt
#undef __deref_out_bcount_z_opt
#undef __deref_inout_opt
#undef __deref_inout_ecount_opt
#undef __deref_inout_bcount_opt
#undef __deref_inout_xcount_opt
#undef __deref_inout_ecount_part_opt
#undef __deref_inout_bcount_part_opt
#undef __deref_inout_xcount_part_opt
#undef __deref_inout_ecount_full_opt
#undef __deref_inout_bcount_full_opt
#undef __deref_inout_xcount_full_opt
#undef __deref_inout_z_opt
#undef __deref_inout_ecount_z_opt
#undef __deref_inout_bcount_z_opt
#undef __deref_opt_ecount
#undef __deref_opt_bcount
#undef __deref_opt_xcount
#undef __deref_opt_in
#undef __deref_opt_in_ecount
#undef __deref_opt_in_bcount
#undef __deref_opt_in_xcount
#undef __deref_opt_out
#undef __deref_opt_out_ecount
#undef __deref_opt_out_bcount
#undef __deref_opt_out_xcount
#undef __deref_opt_out_ecount_part
#undef __deref_opt_out_bcount_part
#undef __deref_opt_out_xcount_part
#undef __deref_opt_out_ecount_full
#undef __deref_opt_out_bcount_full
#undef __deref_opt_out_xcount_full
#undef __deref_opt_inout
#undef __deref_opt_inout_ecount
#undef __deref_opt_inout_bcount
#undef __deref_opt_inout_xcount
#undef __deref_opt_inout_ecount_part
#undef __deref_opt_inout_bcount_part
#undef __deref_opt_inout_xcount_part
#undef __deref_opt_inout_ecount_full
#undef __deref_opt_inout_bcount_full
#undef __deref_opt_inout_xcount_full
#undef __deref_opt_inout_z
#undef __deref_opt_inout_ecount_z
#undef __deref_opt_inout_bcount_z
#undef __deref_opt_ecount_opt
#undef __deref_opt_bcount_opt
#undef __deref_opt_xcount_opt
#undef __deref_opt_in_opt
#undef __deref_opt_in_ecount_opt
#undef __deref_opt_in_bcount_opt
#undef __deref_opt_in_xcount_opt
#undef __deref_opt_out_opt
#undef __deref_opt_out_ecount_opt
#undef __deref_opt_out_bcount_opt
#undef __deref_opt_out_xcount_opt
#undef __deref_opt_out_ecount_part_opt
#undef __deref_opt_out_bcount_part_opt
#undef __deref_opt_out_xcount_part_opt
#undef __deref_opt_out_ecount_full_opt
#undef __deref_opt_out_bcount_full_opt
#undef __deref_opt_out_xcount_full_opt
#undef __deref_opt_out_z_opt
#undef __deref_opt_out_ecount_z_opt
#undef __deref_opt_out_bcount_z_opt
#undef __deref_opt_inout_opt
#undef __deref_opt_inout_ecount_opt
#undef __deref_opt_inout_bcount_opt
#undef __deref_opt_inout_xcount_opt
#undef __deref_opt_inout_ecount_part_opt
#undef __deref_opt_inout_bcount_part_opt
#undef __deref_opt_inout_xcount_part_opt
#undef __deref_opt_inout_ecount_full_opt
#undef __deref_opt_inout_bcount_full_opt
#undef __deref_opt_inout_xcount_full_opt
#undef __deref_opt_inout_z_opt
#undef __deref_opt_inout_ecount_z_opt
#undef __deref_opt_inout_bcount_z_opt
#undef __deref_in_ecount_iterator
#undef __deref_out_ecount_iterator
#undef __deref_inout_ecount_iterator
#undef __deref_realloc_bcount

/************************************************************************
*  SAL 2 _Ouptr_ family of annotations
************************************************************************/

#undef _Outptr_
#undef _Outptr_result_maybenull_
#undef _Outptr_opt_
#undef _Outptr_opt_result_maybenull_
#undef _Outptr_result_z_
#undef _Outptr_opt_result_z_
#undef _Outptr_result_maybenull_z_
#undef _Outptr_opt_result_maybenull_z_
#undef _Outptr_result_nullonfailure_
#undef _Outptr_opt_result_nullonfailure_
#undef _COM_Outptr_
#undef _COM_Outptr_result_maybenull_
#undef _COM_Outptr_opt_
#undef _COM_Outptr_opt_result_maybenull_
#undef _Outptr_result_buffer_
#undef _Outptr_opt_result_buffer_
#undef _Outptr_result_buffer_to_
#undef _Outptr_opt_result_buffer_to_
#undef _Outptr_result_buffer_all_
#undef _Outptr_opt_result_buffer_all_
#undef _Outptr_result_buffer_maybenull_
#undef _Outptr_opt_result_buffer_maybenull_
#undef _Outptr_result_buffer_to_maybenull_
#undef _Outptr_opt_result_buffer_to_maybenull_
#undef _Outptr_result_buffer_all_maybenull_
#undef _Outptr_opt_result_buffer_all_maybenull_
#undef _Outptr_result_bytebuffer_
#undef _Outptr_opt_result_bytebuffer_
#undef _Outptr_result_bytebuffer_to_
#undef _Outptr_opt_result_bytebuffer_to_
#undef _Outptr_result_bytebuffer_all_
#undef _Outptr_opt_result_bytebuffer_all_
#undef _Outptr_result_bytebuffer_maybenull_
#undef _Outptr_opt_result_bytebuffer_maybenull_
#undef _Outptr_result_bytebuffer_to_maybenull_
#undef _Outptr_opt_result_bytebuffer_to_maybenull_
#undef _Outptr_result_bytebuffer_all_maybenull_
#undef _Outptr_opt_result_bytebuffer_all_maybenull_

/************************************************************************
*  Orcas SAL
************************************************************************/
#undef _Deref_out_
#undef _Deref_out_opt_
#undef _Deref_opt_out_
#undef _Deref_opt_out_opt_
#undef _In_count_
#undef _In_opt_count_
#undef _In_bytecount_
#undef _In_opt_bytecount_
#undef _Out_cap_
#undef _Out_opt_cap_
#undef _Out_bytecap_
#undef _Out_opt_bytecap_
#undef _Deref_post_count_
#undef _Deref_post_opt_count_
#undef _Deref_post_bytecount_
#undef _Deref_post_opt_bytecount_
#undef _Deref_post_cap_
#undef _Deref_post_opt_cap_
#undef _Deref_post_bytecap_
#undef _Deref_post_opt_bytecap_

/************************************************************************
*  Advanced Annotations
************************************************************************/
#undef _At_
#undef _When_
#undef __success
#undef __out_awcount
#undef __in_awcount
#undef __nullterminated
#undef __nullnullterminated
#undef __reserved
#undef __checkReturn
#undef __typefix
#undef __override
#undef __callback
#undef __format_string
#undef __blocksOn
#undef __fallthrough
#undef __range
#undef __in_range
#undef __out_range
#undef __deref_in_range
#undef __deref_out_range
#undef __deref_inout_range
#undef __field_range
#undef __range_max
#undef __range_min
#undef __bound
#undef __in_bound
#undef __out_bound
#undef __deref_out_bound
#undef __assume_bound
#undef __analysis_assume_nullterminated
#undef __allocator
#undef __deallocate
#undef __deallocate_opt
#undef __post_invalid
#undef __post_nullnullterminated
/***************************************************************************
* Expert Macros
***************************************************************************/
#undef __null
#undef __notnull
#undef __maybenull
#undef __exceptthat
/***************************************************************************
* Macros to classify fields of structures.
****************************************************************************/
#undef __field_ecount
#undef __field_bcount
#undef __field_xcount
#undef __field_ecount_opt
#undef __field_bcount_opt
#undef __field_xcount_opt
#undef __field_ecount_part
#undef __field_bcount_part
#undef __field_xcount_part
#undef __field_ecount_part_opt
#undef __field_bcount_part_opt
#undef __field_xcount_part_opt
#undef __field_ecount_full
#undef __field_bcount_full
#undef __field_xcount_full
#undef __field_ecount_full_opt
#undef __field_bcount_full_opt
#undef __field_xcount_full_opt
#undef __field_nullterminated
#undef __struct_bcount
#undef __struct_xcount

/***************************************************************************
* Macros to classify the entrypoints and indicate their category.
***************************************************************************/
#undef __control_entrypoint
#undef __rpc_entry
#undef __kernel_entry
#undef __gdi_entry

/***************************************************************************
* Macros to track untrusted data and their validation.
***************************************************************************/
#undef __in_data_source
#undef __out_data_source
#undef __field_data_source
#undef __this_out_data_source

/**************************************************************************
* Macros to tag file parsing code.
**************************************************************************/
#undef __out_validated
#undef __this_out_validated
#undef __file_parser
#undef __file_parser_class
#undef __file_parser_library

/***************************************************************************
* Macros to track the code content in the file.
***************************************************************************/
#undef __source_code_content

/***************************************************************************
* Macros to track the code content in the class.
***************************************************************************/
#undef __class_code_content

/*************************************************************************
* Macros to tag encoded function pointers
**************************************************************************/
#undef __encoded_pointer
#undef __encoded_array
#undef __field_encoded_pointer
#undef __field_encoded_array

#undef __transfer
#undef __assume_validated

/*************************************************************************
* __analysis_assume
*************************************************************************/
#undef __analysis_assume
#undef __analysis_assert

/*************************************************************************
* __analysis_hint
*************************************************************************/
#undef __analysis_hint

/*************************************************************************
* Macros to encode abstract properties of values. Used by SALadt.h
*************************************************************************/
#undef __type_has_adt_prop
#undef __out_has_adt_prop
#undef __out_not_has_adt_prop
#undef __out_transfer_adt_prop
#undef __out_has_type_adt_props

/*************************************************************************
* Macros used by Prefast for Drivers
*************************************************************************/
#undef __possibly_notnullterminated

/*************************************************************************
* Advanced macros
*************************************************************************/
#undef __volatile
#undef __deref_volatile
#undef __nonvolatile
#undef __deref_nonvolatile

/*************************************************************************
* Macros deprecated with strict level greater then 1.
**************************************************************************/
#undef __in_nz
#undef __in_ecount_nz
#undef __in_bcount_nz
#undef __out_nz
#undef __out_nz_opt
#undef __out_ecount_nz
#undef __out_bcount_nz
#undef __inout_nz
#undef __inout_ecount_nz
#undef __inout_bcount_nz
#undef __in_nz_opt
#undef __in_ecount_nz_opt
#undef __in_bcount_nz_opt
#undef __out_ecount_nz_opt
#undef __out_bcount_nz_opt
#undef __inout_nz_opt
#undef __inout_ecount_nz_opt
#undef __inout_bcount_nz_opt
#undef __deref_out_nz
#undef __deref_out_ecount_nz
#undef __deref_out_bcount_nz
#undef __deref_inout_nz
#undef __deref_inout_ecount_nz
#undef __deref_inout_bcount_nz
#undef __deref_out_nz_opt
#undef __deref_out_ecount_nz_opt
#undef __deref_out_bcount_nz_opt
#undef __deref_inout_nz_opt
#undef __deref_inout_ecount_nz_opt
#undef __deref_inout_bcount_nz_opt
#undef __deref_opt_inout_nz
#undef __deref_opt_inout_ecount_nz
#undef __deref_opt_inout_bcount_nz
#undef __deref_opt_out_nz_opt
#undef __deref_opt_out_ecount_nz_opt
#undef __deref_opt_out_bcount_nz_opt
#undef __deref_opt_inout_nz_opt
#undef __deref_opt_inout_ecount_nz_opt
#undef __deref_opt_inout_bcount_nz_opt
#undef __deref
#undef __pre
#undef __post
#undef __readableTo
#undef __writableTo
#undef __maybevalid
#undef __inexpressible_readableTo
#undef __data_entrypoint
#undef __readonly
#undef __byte_writableTo
#undef __byte_readableTo
#undef __elem_readableTo
#undef __elem_writableTo
#undef __valid
#undef __notvalid
#undef __refparam
#undef __precond
