#ifndef _WINAPIFAMILY_H_
#define _WINAPIFAMILY_H_

#include <winpackagefamily.h>

#define WINAPI_FAMILY_PC_APP      2
#define WINAPI_FAMILY_PHONE_APP   3
#define WINAPI_FAMILY_SYSTEM      4
#define WINAPI_FAMILY_SERVER      5
#define WINAPI_FAMILY_GAMES       6
#define WINAPI_FAMILY_DESKTOP_APP 100

#define WINAPI_FAMILY_APP  WINAPI_FAMILY_PC_APP

#ifndef WINAPI_FAMILY
#define WINAPI_FAMILY WINAPI_FAMILY_DESKTOP_APP
#endif

#if WINAPI_FAMILY != WINAPI_FAMILY_DESKTOP_APP &&     \
    WINAPI_FAMILY != WINAPI_FAMILY_PC_APP &&          \
    WINAPI_FAMILY != WINAPI_FAMILY_PHONE_APP &&       \
    WINAPI_FAMILY != WINAPI_FAMILY_SYSTEM &&          \
    WINAPI_FAMILY != WINAPI_FAMILY_GAMES &&           \
    WINAPI_FAMILY != WINAPI_FAMILY_SERVER
#error Unknown WINAPI_FAMILY value?
#endif

#ifndef WINAPI_PARTITION_DESKTOP
#define WINAPI_PARTITION_DESKTOP (WINAPI_FAMILY == WINAPI_FAMILY_DESKTOP_APP)
#endif

#ifndef WINAPI_PARTITION_APP
#define WINAPI_PARTITION_APP                          \
  (WINAPI_FAMILY == WINAPI_FAMILY_DESKTOP_APP ||      \
   WINAPI_FAMILY == WINAPI_FAMILY_PC_APP ||           \
   WINAPI_FAMILY == WINAPI_FAMILY_PHONE_APP)
#endif

#ifndef WINAPI_PARTITION_PC_APP
#define WINAPI_PARTITION_PC_APP                       \
  (WINAPI_FAMILY == WINAPI_FAMILY_DESKTOP_APP ||      \
   WINAPI_FAMILY == WINAPI_FAMILY_PC_APP)
#endif

#ifndef WINAPI_PARTITION_PHONE_APP
#define WINAPI_PARTITION_PHONE_APP (WINAPI_FAMILY == WINAPI_FAMILY_PHONE_APP)
#endif

#ifndef WINAPI_PARTITION_GAMES
#define WINAPI_PARTITION_GAMES                        \
  (WINAPI_FAMILY == WINAPI_FAMILY_GAMES ||            \
   WINAPI_FAMILY == WINAPI_FAMILY_DESKTOP_APP)
#endif

#ifndef WINAPI_PARTITION_SYSTEM
#define WINAPI_PARTITION_SYSTEM                       \
  (WINAPI_FAMILY == WINAPI_FAMILY_SYSTEM ||           \
   WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#endif

#define WINAPI_PARTITION_PHONE  WINAPI_PARTITION_PHONE_APP

#define WINAPI_FAMILY_PARTITION(Partitions)     (Partitions)

#define _WINAPI_DEPRECATED_DECLARATION

#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) && !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#define APP_DEPRECATED_HRESULT    HRESULT _WINAPI_DEPRECATED_DECLARATION
#endif

#endif // _WINAPIFAMILY_H_
