#ifndef _WINUSER_H
#define _WINUSER_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable:4201)
#pragma warning(disable:4820)
#endif

#if !defined(_USER32_)
#define WINUSERAPI DECLSPEC_IMPORT
#else
#define WINUSERAPI
#endif

#define FALT	16
#define FCONTROL	8
#define FNOINVERT	2
#define FSHIFT	4
#define FVIRTKEY	1
#define ATF_TIMEOUTON	1
#define ATF_ONOFFFEEDBACK	2
#define ATF_AVAILABLE	4 /* May be obsolete. Not in recent MS docs. */
#define WH_MIN	(-1)
#define WH_MSGFILTER	(-1)
#define WH_JOURNALRECORD	0
#define WH_JOURNALPLAYBACK	1
#define WH_KEYBOARD	2
#define WH_GETMESSAGE	3
#define WH_CALLWNDPROC	4
#define WH_CBT	5
#define WH_SYSMSGFILTER	6
#define WH_MOUSE	7
#define WH_HARDWARE	8
#define WH_DEBUG	9
#define WH_SHELL	10
#define WH_FOREGROUNDIDLE	11
#define WH_CALLWNDPROCRET	12
#define WH_KEYBOARD_LL	13
#define WH_MOUSE_LL	14
#define WH_MAX		14
#define WH_MINHOOK	WH_MIN
#define WH_MAXHOOK	WH_MAX
#define HC_ACTION	0
#define HC_GETNEXT	1
#define HC_SKIP	2
#define HC_NOREMOVE	3
#define HC_NOREM	3
#define HC_SYSMODALON	4
#define HC_SYSMODALOFF	5
#define HCBT_MOVESIZE	0
#define HCBT_MINMAX	1
#define HCBT_QS	2
#define HCBT_CREATEWND	3
#define HCBT_DESTROYWND	4
#define HCBT_ACTIVATE	5
#define HCBT_CLICKSKIPPED	6
#define HCBT_KEYSKIPPED	7
#define HCBT_SYSCOMMAND	8
#define HCBT_SETFOCUS	9

/* Predefined Clipboard Formats */
#define CF_TEXT	1
#define CF_BITMAP	2
#define CF_METAFILEPICT	3
#define CF_SYLK	4
#define CF_DIF	5
#define CF_TIFF	6
#define CF_OEMTEXT	7
#define CF_DIB	8
#define CF_PALETTE	9
#define CF_PENDATA	10
#define CF_RIFF	11
#define CF_WAVE	12
#define CF_UNICODETEXT	13
#define CF_ENHMETAFILE	14

#if(WINVER >= 0x0400)
#define CF_HDROP 15
#define CF_LOCALE 16
#endif

#if(WINVER >= 0x0500)
#define CF_DIBV5 17
#endif

#if(WINVER >= 0x0500)
#define CF_MAX 18
#elif(WINVER >= 0x0400)
#define CF_MAX 17
#else
#define CF_MAX 15
#endif

#define CF_OWNERDISPLAY	128
#define CF_DSPTEXT	129
#define CF_DSPBITMAP	130
#define CF_DSPMETAFILEPICT	131
#define CF_DSPENHMETAFILE	142
#define CF_PRIVATEFIRST	512
#define CF_PRIVATELAST	767
#define CF_GDIOBJFIRST	768
#define CF_GDIOBJLAST	1023

#define HKL_NEXT	1
#define HKL_PREV	0
#define KLF_ACTIVATE	1
#define KLF_SUBSTITUTE_OK	2
#define KLF_UNLOADPREVIOUS	4
#define KLF_REORDER	8
#define KLF_REPLACELANG	16
#define KLF_NOTELLSHELL	128
#define KLF_SETFORPROCESS	256
#if (_WIN32_WINNT >= 0x0500)
#define KLF_SHIFTLOCK  0x00010000
#define KLF_RESET 0x40000000
#endif  /*(_WIN32_WINNT >= 0x0500) */
#define KL_NAMELENGTH 9
#if (WINVER >= 0x0500)
#define INPUTLANGCHANGE_BACKWARD   4
#define INPUTLANGCHANGE_FORWARD    2
#define INPUTLANGCHANGE_SYSCHARSET 1
#endif /* (WINVER >= 0x0500) */
#define MF_ENABLED	0
#define MF_GRAYED	1
#define MF_DISABLED	2
#define MF_BITMAP	4
#define MF_CHECKED	8
#define MF_MENUBARBREAK 32
#define MF_MENUBREAK	64
#define MF_OWNERDRAW	256
#define MF_POPUP	16
#define MF_SEPARATOR	0x800
#define MF_STRING	0
#define MF_UNCHECKED	0
#define MF_DEFAULT	4096
#define MF_SYSMENU	0x2000
#define MF_HELP	0x4000
#define MF_END	128
#define MF_RIGHTJUSTIFY	0x4000
#define MF_MOUSESELECT	0x8000
#define MF_INSERT 0
#define MF_CHANGE 128
#define MF_APPEND 256
#define MF_DELETE 512
#define MF_REMOVE 4096
#define MF_USECHECKBITMAPS 512
#define MF_UNHILITE 0
#define MF_HILITE 128

/* Also defined in dbt.h */
#define BSM_ALLCOMPONENTS	0
#define BSM_APPLICATIONS	8
#define BSM_ALLDESKTOPS		16
#define BSM_INSTALLABLEDRIVERS	4
#define BSM_NETDRIVER	2
#define BSM_VXDS	1
#define BSF_FLUSHDISK 0x00000004
#define BSF_FORCEIFHUNG 0x00000020
#define BSF_IGNORECURRENTTASK 0x00000002
#define BSF_NOHANG 0x00000008
#define BSF_NOTIMEOUTIFNOTHUNG 0x00000040
#define BSF_POSTMESSAGE 0x00000010
#define BSF_QUERY 0x00000001
#if (_WIN32_WINNT >= 0x0500)
#define BSF_ALLOWSFW 0x00000080
#define BSF_SENDNOTIFYMESSAGE 0x00000100
#endif /* (_WIN32_WINNT >= 0x0500) */
#if (_WIN32_WINNT >= 0x0501)
#define BSF_LUID 0x00000400
#define BSF_RETURNHDESK 0x00000200
#endif /* (_WIN32_WINNT >= 0x0501) */

#define BROADCAST_QUERY_DENY	1112363332
#define ENUM_CURRENT_SETTINGS	((DWORD)-1)
#define ENUM_REGISTRY_SETTINGS	((DWORD)-2)
#define CDS_UPDATEREGISTRY	1
#define CDS_TEST	2
#define CDS_FULLSCREEN	4
#define CDS_GLOBAL	8
#define CDS_SET_PRIMARY	16
#define CDS_VIDEOPARAMETERS 20
#define CDS_RESET	0x40000000
#define CDS_SETRECT	0x20000000
#define CDS_NORESET	0x10000000
#define DISP_CHANGE_SUCCESSFUL	0
#define DISP_CHANGE_RESTART	1
#define DISP_CHANGE_BADFLAGS	(-4)
#define DISP_CHANGE_BADPARAM	(-5)
#define DISP_CHANGE_FAILED	(-1)
#define DISP_CHANGE_BADMODE	(-2)
#define DISP_CHANGE_NOTUPDATED	(-3)
#define BST_CHECKED	1
#define BST_INDETERMINATE	2
#define BST_UNCHECKED	0
#define BST_FOCUS	8
#define BST_PUSHED	4
#define MF_BYCOMMAND	0
#define MF_BYPOSITION	1024
#define MF_UNCHECKED	0
#define MF_HILITE	128
#define MF_UNHILITE	0
#define CWP_ALL 0
#define CWP_SKIPINVISIBLE	1
#define CWP_SKIPDISABLED	2
#define CWP_SKIPTRANSPARENT	4
#define IMAGE_BITMAP	0
#define IMAGE_ICON	1
#define IMAGE_CURSOR	2
#define IMAGE_ENHMETAFILE	3
#define DF_ALLOWOTHERACCOUNTHOOK	1
#define DESKTOP_CREATEMENU	4
#define DESKTOP_CREATEWINDOW	2
#define DESKTOP_ENUMERATE	64
#define DESKTOP_HOOKCONTROL	8
#define DESKTOP_JOURNALPLAYBACK	32
#define DESKTOP_JOURNALRECORD	16
#define DESKTOP_READOBJECTS	1
#define DESKTOP_SWITCHDESKTOP	256
#define DESKTOP_WRITEOBJECTS	128
#define CW_USEDEFAULT	((int)0x80000000)
#define WS_BORDER	0x800000
#define WS_CAPTION	0xc00000
#define WS_CHILD	0x40000000
#define WS_CHILDWINDOW	0x40000000
#define WS_CLIPCHILDREN 0x2000000
#define WS_CLIPSIBLINGS 0x4000000
#define WS_DISABLED	0x8000000
#define WS_DLGFRAME	0x400000
#define WS_GROUP	0x20000
#define WS_HSCROLL	0x100000
#define WS_ICONIC	0x20000000
#define WS_MAXIMIZE	0x1000000
#define WS_MAXIMIZEBOX	0x10000
#define WS_MINIMIZE	0x20000000
#define WS_MINIMIZEBOX	0x20000
#define WS_OVERLAPPED	0
#define WS_OVERLAPPEDWINDOW	0xcf0000
#define WS_POPUP	0x80000000
#define WS_POPUPWINDOW	0x80880000
#define WS_SIZEBOX	0x40000
#define WS_SYSMENU	0x80000
#define WS_TABSTOP	0x10000
#define WS_THICKFRAME	0x40000
#define WS_TILED	0
#define WS_TILEDWINDOW	0xcf0000
#define WS_VISIBLE	0x10000000
#define WS_VSCROLL	0x200000
#define MDIS_ALLCHILDSTYLES	1
#define BS_3STATE	5
#define BS_AUTO3STATE	6
#define BS_AUTOCHECKBOX	3
#define BS_AUTORADIOBUTTON	9
#define BS_BITMAP	128
#define BS_BOTTOM	0x800
#define BS_CENTER	0x300
#define BS_CHECKBOX	2
#define BS_DEFPUSHBUTTON	1
#define BS_GROUPBOX	7
#define BS_ICON	64
#define BS_LEFT	256
#define BS_LEFTTEXT	32
#define BS_MULTILINE	0x2000
#define BS_NOTIFY	0x4000
#define BS_OWNERDRAW	0xb
#define BS_TYPEMASK	0xFL
#define BS_PUSHBUTTON	0
#define BS_PUSHLIKE	4096
#define BS_RADIOBUTTON 4
#define BS_RIGHT	512
#define BS_RIGHTBUTTON	32
#define BS_TEXT	0
#define BS_TOP	0x400
#define BS_USERBUTTON	8
#define BS_VCENTER	0xc00
#define BS_FLAT	0x8000
#define CBS_AUTOHSCROLL	64
#define CBS_DISABLENOSCROLL	0x800
#define CBS_DROPDOWN	2
#define CBS_DROPDOWNLIST	3
#define CBS_HASSTRINGS	512
#define CBS_LOWERCASE	0x4000
#define CBS_NOINTEGRALHEIGHT	0x400
#define CBS_OEMCONVERT	128
#define CBS_OWNERDRAWFIXED	16
#define CBS_OWNERDRAWVARIABLE	32
#define CBS_SIMPLE	1
#define CBS_SORT	256
#define CBS_UPPERCASE	0x2000
#define ES_AUTOHSCROLL	128
#define ES_AUTOVSCROLL	64
#define ES_CENTER	1
#define ES_LEFT	0
#define ES_LOWERCASE 16
#define ES_MULTILINE 4
#define ES_NOHIDESEL 256
#define ES_NUMBER 0x2000
#define ES_OEMCONVERT 0x400
#define ES_PASSWORD 32
#define ES_READONLY 0x800
#define ES_RIGHT 2
#define ES_UPPERCASE 8
#define ES_WANTRETURN 4096
#define LBS_DISABLENOSCROLL 4096
#define LBS_EXTENDEDSEL 0x800
#define LBS_HASSTRINGS 64
#define LBS_MULTICOLUMN 512
#define LBS_MULTIPLESEL 8
#define LBS_NODATA	0x2000
#define LBS_NOINTEGRALHEIGHT 256
#define LBS_NOREDRAW 4
#define LBS_NOSEL 0x4000
#define LBS_NOTIFY 1
#define LBS_OWNERDRAWFIXED 16
#define LBS_OWNERDRAWVARIABLE 32
#define LBS_SORT 2
#define LBS_STANDARD 0xa00003
#define LBS_USETABSTOPS 128
#define LBS_WANTKEYBOARDINPUT 0x400
#define LBS_COMBOBOX 0x8000
#define SBS_BOTTOMALIGN 4
#define SBS_HORZ 0
#define SBS_LEFTALIGN 2
#define SBS_RIGHTALIGN 4
#define SBS_SIZEBOX 8
#define SBS_SIZEBOXBOTTOMRIGHTALIGN 4
#define SBS_SIZEBOXTOPLEFTALIGN 2
#define SBS_SIZEGRIP 16
#define SBS_TOPALIGN 2
#define SBS_VERT 1
#define SS_BITMAP 14
#define SS_BLACKFRAME 7
#define SS_BLACKRECT 4
#define SS_CENTER 1
#define SS_CENTERIMAGE 512
#define SS_EDITCONTROL 0x2000
#define SS_ENHMETAFILE 15
#define SS_ETCHEDFRAME 18
#define SS_ETCHEDHORZ 16
#define SS_ETCHEDVERT 17
#define SS_GRAYFRAME 8
#define SS_GRAYRECT 5
#define SS_ICON 3
#define SS_LEFT 0
#define SS_LEFTNOWORDWRAP 0xc
#define SS_NOPREFIX 128
#define SS_NOTIFY 256
#define SS_OWNERDRAW 0xd
#define SS_REALSIZECONTROL 0x040
#define SS_REALSIZEIMAGE 0x800
#define SS_RIGHT 2
#define SS_RIGHTJUST 0x400
#define SS_SIMPLE 11
#define SS_SUNKEN 4096
#define SS_WHITEFRAME 9
#define SS_WHITERECT	6
#define SS_USERITEM	10
#define SS_TYPEMASK	0x0000001FL
#define SS_ENDELLIPSIS	0x00004000L
#define SS_PATHELLIPSIS	0x00008000L
#define SS_WORDELLIPSIS	0x0000C000L
#define SS_ELLIPSISMASK 0x0000C000L
#define DS_3DLOOK 4
#define DS_ABSALIGN 1
#define DS_CENTER 0x800
#define DS_CENTERMOUSE 4096
#define DS_CONTEXTHELP 0x2000
#define DS_CONTROL 0x400
#define DS_FIXEDSYS 8
#define DS_LOCALEDIT 32
#define DS_MODALFRAME 128
#define DS_NOFAILCREATE 16
#define DS_NOIDLEMSG	256
#define DS_SETFONT 64
#define DS_SETFOREGROUND 512
#define DS_SYSMODAL 2
#define DS_SHELLFONT (DS_SETFONT | DS_FIXEDSYS)
#define WS_EX_ACCEPTFILES 16
#define WS_EX_APPWINDOW	0x40000
#define WS_EX_CLIENTEDGE 512
#define WS_EX_COMPOSITED 0x2000000 /* XP */
#define WS_EX_CONTEXTHELP 0x400
#define WS_EX_CONTROLPARENT 0x10000
#define WS_EX_DLGMODALFRAME 1
#define WS_EX_LAYERED 0x80000   /* w2k */
#define WS_EX_LAYOUTRTL 0x400000 /* w98, w2k */
#define WS_EX_LEFT	0
#define WS_EX_LEFTSCROLLBAR	0x4000
#define WS_EX_LTRREADING	0
#define WS_EX_MDICHILD	64
#define WS_EX_NOACTIVATE 0x8000000 /* w2k */
#define WS_EX_NOINHERITLAYOUT 0x100000 /* w2k */
#define WS_EX_NOPARENTNOTIFY	4
#define WS_EX_OVERLAPPEDWINDOW	0x300
#define WS_EX_PALETTEWINDOW	0x188
#define WS_EX_RIGHT	0x1000
#define WS_EX_RIGHTSCROLLBAR	0
#define WS_EX_RTLREADING	0x2000
#define WS_EX_STATICEDGE	0x20000
#define WS_EX_TOOLWINDOW	128
#define WS_EX_TOPMOST	8
#define WS_EX_TRANSPARENT	32
#define WS_EX_WINDOWEDGE	256
#define WINSTA_ACCESSCLIPBOARD	4
#define WINSTA_ACCESSGLOBALATOMS	32
#define WINSTA_CREATEDESKTOP	8
#define WINSTA_ENUMDESKTOPS	1
#define WINSTA_ENUMERATE	256
#define WINSTA_EXITWINDOWS	64
#define WINSTA_READATTRIBUTES	2
#define WINSTA_READSCREEN	512
#define WINSTA_WRITEATTRIBUTES	16
#define WINSTA_ALL_ACCESS       895
#define DDL_READWRITE	0
#define DDL_READONLY	1
#define DDL_HIDDEN	2
#define DDL_SYSTEM	4
#define DDL_DIRECTORY	16
#define DDL_ARCHIVE	32
#define DDL_POSTMSGS	8192
#define DDL_DRIVES	16384
#define DDL_EXCLUSIVE	32768
#define DC_ACTIVE	0x00000001
#define DC_SMALLCAP	0x00000002
#define DC_ICON	0x00000004
#define DC_TEXT	0x00000008
#define DC_INBUTTON	0x00000010
#if (_WIN32_WINDOWS >= 0x0410 || _WIN32_WINNT >= 0x0500)
#define DC_GRADIENT	0x00000020
#endif
#if (_WIN32_WINNT >= 0x0501)
#define DC_BUTTONS	0x00001000
#endif
/* Where are these documented? */
#define DC_CAPTION	(DC_ICON|DC_TEXT|DC_BUTTONS)
#define DC_NC	(DC_CAPTION|DC_FRAME)

#define BDR_RAISEDOUTER	1
#define BDR_SUNKENOUTER	2
#define BDR_RAISEDINNER	4
#define BDR_SUNKENINNER	8
#define BDR_OUTER	3
#define BDR_INNER	0xc
#define BDR_RAISED	5
#define BDR_SUNKEN	10
#define EDGE_RAISED	(BDR_RAISEDOUTER|BDR_RAISEDINNER)
#define EDGE_SUNKEN	(BDR_SUNKENOUTER|BDR_SUNKENINNER)
#define EDGE_ETCHED	(BDR_SUNKENOUTER|BDR_RAISEDINNER)
#define EDGE_BUMP	(BDR_RAISEDOUTER|BDR_SUNKENINNER)
#define BF_LEFT	1
#define BF_TOP	2
#define BF_RIGHT	4
#define BF_BOTTOM	8
#define BF_TOPLEFT	(BF_TOP|BF_LEFT)
#define BF_TOPRIGHT	(BF_TOP|BF_RIGHT)
#define BF_BOTTOMLEFT	(BF_BOTTOM|BF_LEFT)
#define BF_BOTTOMRIGHT	(BF_BOTTOM|BF_RIGHT)
#define BF_RECT	(BF_LEFT|BF_TOP|BF_RIGHT|BF_BOTTOM)
#define BF_DIAGONAL	16
#define BF_DIAGONAL_ENDTOPRIGHT	(BF_DIAGONAL|BF_TOP|BF_RIGHT)
#define BF_DIAGONAL_ENDTOPLEFT	(BF_DIAGONAL|BF_TOP|BF_LEFT)
#define BF_DIAGONAL_ENDBOTTOMLEFT	(BF_DIAGONAL|BF_BOTTOM|BF_LEFT)
#define BF_DIAGONAL_ENDBOTTOMRIGHT	(BF_DIAGONAL|BF_BOTTOM|BF_RIGHT)
#define BF_MIDDLE	0x800
#define BF_SOFT	0x1000
#define BF_ADJUST	0x2000
#define BF_FLAT	0x4000
#define BF_MONO	0x8000
#define DFC_CAPTION	1
#define DFC_MENU	2
#define DFC_SCROLL	3
#define DFC_BUTTON	4
#if (WINVER >= 0x0500)
#define DFC_POPUPMENU 5
#endif /* WINVER >= 0x0500 */
#define DFCS_CAPTIONCLOSE	0
#define DFCS_CAPTIONMIN	1
#define DFCS_CAPTIONMAX	2
#define DFCS_CAPTIONRESTORE	3
#define DFCS_CAPTIONHELP	4
#define DFCS_MENUARROW	0
#define DFCS_MENUCHECK	1
#define DFCS_MENUBULLET	2
#define DFCS_MENUARROWRIGHT	4
#define DFCS_SCROLLUP	0
#define DFCS_SCROLLDOWN	1
#define DFCS_SCROLLLEFT	2
#define DFCS_SCROLLRIGHT	3
#define DFCS_SCROLLCOMBOBOX	5
#define DFCS_SCROLLSIZEGRIP	8
#define DFCS_SCROLLSIZEGRIPRIGHT	16
#define DFCS_BUTTONCHECK	0
#define DFCS_BUTTONRADIOIMAGE	1
#define DFCS_BUTTONRADIOMASK	2
#define DFCS_BUTTONRADIO	4
#define DFCS_BUTTON3STATE	8
#define DFCS_BUTTONPUSH	16
#define DFCS_INACTIVE	256
#define DFCS_PUSHED	512
#define DFCS_CHECKED	1024
#if (WINVER >= 0x0500)
#define DFCS_TRANSPARENT	0x800
#define DFCS_HOT	0x1000
#endif
#define DFCS_ADJUSTRECT	0x2000
#define DFCS_FLAT	0x4000
#define DFCS_MONO	0x8000
#define DST_COMPLEX	0
#define DST_TEXT	1
#define DST_PREFIXTEXT	2
#define DST_ICON	3
#define DST_BITMAP	4
#define DSS_NORMAL	0
#define DSS_UNION	16
#define DSS_DISABLED	32
#define	DSS_DEFAULT	64
#define DSS_MONO	128
#define	DSS_HIDEPREFIX	0x0200
#define	DSS_PREFIXONLY	0x0400
#define DSS_RIGHT	0x8000
#define DT_BOTTOM	8
#define DT_CALCRECT	1024
#define DT_CENTER	1
#define DT_EDITCONTROL	8192
#define DT_END_ELLIPSIS	32768
#define DT_PATH_ELLIPSIS	16384
#define DT_WORD_ELLIPSIS 0x40000
#define DT_EXPANDTABS	64
#define DT_EXTERNALLEADING	512
#define DT_LEFT	0
#define DT_MODIFYSTRING	65536
#define DT_NOCLIP	256
#define DT_NOPREFIX	2048
#define DT_RIGHT	2
#define DT_RTLREADING	131072
#define DT_SINGLELINE	32
#define DT_TABSTOP	128
#define DT_TOP	0
#define DT_VCENTER	4
#define DT_WORDBREAK	16
#define DT_INTERNAL	4096
#define DT_NOFULLWIDTHCHARBREAK	524288
#define DT_HIDEPREFIX	1048576
#define DT_PREFIXONLY	2097152
#define WB_ISDELIMITER	2
#define WB_LEFT	0
#define WB_RIGHT	1
#define SB_HORZ	0
#define SB_VERT	1
#define SB_CTL	2
#define SB_BOTH	3
#define ESB_DISABLE_BOTH	3
#define ESB_DISABLE_DOWN	2
#define ESB_DISABLE_LEFT	1
#define ESB_DISABLE_LTUP	1
#define ESB_DISABLE_RIGHT	2
#define ESB_DISABLE_RTDN	2
#define ESB_DISABLE_UP	1
#define ESB_ENABLE_BOTH	0
#define SB_LINEUP	0
#define SB_LINEDOWN	1
#define SB_LINELEFT	0
#define SB_LINERIGHT	1
#define SB_PAGEUP	2
#define SB_PAGEDOWN	3
#define SB_PAGELEFT	2
#define SB_PAGERIGHT	3
#define SB_THUMBPOSITION	4
#define SB_THUMBTRACK	5
#define SB_ENDSCROLL	8
#define SB_LEFT	6
#define SB_RIGHT	7
#define SB_BOTTOM	7
#define SB_TOP	6

#define IS_INTRESOURCE(i) (((ULONG_PTR)(i) >> 16) == 0)
#define MAKEINTRESOURCEA(i) ((LPSTR)(ULONG_PTR)LOWORD(i))
#define MAKEINTRESOURCEW(i) ((LPWSTR)(ULONG_PTR)LOWORD(i))

#ifndef RC_INVOKED
#ifdef WINE_NO_UNICODE_MACROS /* force using a cast */
#define MAKEINTRESOURCE(i) ((ULONG_PTR)((WORD)(i)))
#else
#ifdef UNICODE
#define MAKEINTRESOURCE MAKEINTRESOURCEW
#else
#define MAKEINTRESOURCE MAKEINTRESOURCEA
#endif /* UNICODE */
#endif /* WINE_NO_UNICODE_MACROS */
#endif /* !RC_INVOKED */


#ifndef NORESOURCE

#define RT_CURSOR MAKEINTRESOURCE(1)
#define RT_BITMAP MAKEINTRESOURCE(2)
#define RT_ICON MAKEINTRESOURCE(3)
#define RT_MENU MAKEINTRESOURCE(4)
#define RT_DIALOG MAKEINTRESOURCE(5)
#define RT_STRING MAKEINTRESOURCE(6)
#define RT_FONTDIR MAKEINTRESOURCE(7)
#define RT_FONT MAKEINTRESOURCE(8)
#define RT_ACCELERATOR MAKEINTRESOURCE(9)
#define RT_RCDATA MAKEINTRESOURCE(10)
#define RT_MESSAGETABLE MAKEINTRESOURCE(11)
#define DIFFERENCE 11
#define RT_GROUP_CURSOR MAKEINTRESOURCE((ULONG_PTR)RT_CURSOR+DIFFERENCE)
#define RT_GROUP_ICON MAKEINTRESOURCE((ULONG_PTR)RT_ICON+DIFFERENCE)
#define RT_VERSION MAKEINTRESOURCE(16)
#define RT_DLGINCLUDE MAKEINTRESOURCE(17)
#define RT_PLUGPLAY MAKEINTRESOURCE(19)
#define RT_VXD MAKEINTRESOURCE(20)
#define RT_ANICURSOR MAKEINTRESOURCE(21)
#define RT_ANIICON MAKEINTRESOURCE(22)
#define RT_HTML MAKEINTRESOURCE(23)
#ifndef RC_INVOKED
#define RT_MANIFEST MAKEINTRESOURCE(24)
#define CREATEPROCESS_MANIFEST_RESOURCE_ID  MAKEINTRESOURCE(1)
#define ISOLATIONAWARE_MANIFEST_RESOURCE_ID MAKEINTRESOURCE(2)
#define ISOLATIONAWARE_NOSTATICIMPORT_MANIFEST_RESOURCE_ID MAKEINTRESOURCE(3)
#else
#define RT_MANIFEST 24
#define CREATEPROCESS_MANIFEST_RESOURCE_ID  1
#define ISOLATIONAWARE_MANIFEST_RESOURCE_ID 2
#define ISOLATIONAWARE_NOSTATICIMPORT_MANIFEST_RESOURCE_ID 3
#endif /* !RC_INVOKED */

#endif /* !NORESOURCE */


#define EWX_FORCE 0x00000004
#define EWX_LOGOFF 0
#define EWX_POWEROFF 0x00000008
#define EWX_REBOOT 0x00000002
#define EWX_SHUTDOWN 0x00000001
#if (_WIN32_WINNT >= 0x0500)
#define EWX_FORCEIFHUNG 0x00000010
#endif
#if (_WIN32_WINNT > 0x06010000)
#define EWX_HYBRID_SHUTDOWN 0x00400000
#endif
#define CS_BYTEALIGNCLIENT 4096
#define CS_BYTEALIGNWINDOW 8192
#define CS_KEYCVTWINDOW 4
#define CS_NOKEYCVT 256 // Class Name to Version
#define CS_CLASSDC 64
#define CS_DBLCLKS 8
#define CS_GLOBALCLASS 16384
#define CS_HREDRAW 2
#define CS_NOCLOSE 512
#define CS_OWNDC 32
#define CS_PARENTDC 128
#define CS_SAVEBITS 2048
#define CS_VREDRAW 1
#define CS_IME 0x10000
#define CS_DROPSHADOW 0x20000
#define GCW_ATOM (-32)
#define GCL_CBCLSEXTRA (-20)
#define GCL_CBWNDEXTRA (-18)
#define GCL_HBRBACKGROUND (-10)
#define GCL_HCURSOR (-12)
#define GCL_HICON (-14)
#define GCL_HICONSM (-34)
#define GCL_HMODULE (-16)
#define GCL_MENUNAME (-8)
#define GCL_STYLE (-26)
#define GCL_WNDPROC (-24)
#define GCLP_HBRBACKGROUND (-10)
#define GCLP_HCURSOR (-12)
#define GCLP_HICON (-14)
#define GCLP_HICONSM (-34)
#define GCLP_HMODULE (-16)
#define GCLP_MENUNAME (-8)
#define GCLP_WNDPROC (-24)
#if 0
    /* This is supposed to be defined by the program using it not defined
       in the w32api headers.  I've left it here for documentation purposes.
    */
#ifndef IDC_STATIC  /* May be predefined by resource compiler. */
#define IDC_STATIC (-1)
#endif
#endif
#define IDC_ARROW MAKEINTRESOURCE(32512)
#define IDC_IBEAM MAKEINTRESOURCE(32513)
#define IDC_WAIT MAKEINTRESOURCE(32514)
#define IDC_CROSS MAKEINTRESOURCE(32515)
#define IDC_UPARROW MAKEINTRESOURCE(32516)
#define IDC_SIZENWSE MAKEINTRESOURCE(32642)
#define IDC_SIZENESW MAKEINTRESOURCE(32643)
#define IDC_SIZEWE MAKEINTRESOURCE(32644)
#define IDC_SIZENS MAKEINTRESOURCE(32645)
#define IDC_SIZEALL MAKEINTRESOURCE(32646)
#define IDC_NO MAKEINTRESOURCE(32648)
#define IDC_HAND MAKEINTRESOURCE(32649)
#define IDC_APPSTARTING MAKEINTRESOURCE(32650)
#define IDC_HELP MAKEINTRESOURCE(32651)
#define IDC_ICON MAKEINTRESOURCE(32641)
#define IDC_SIZE MAKEINTRESOURCE(32640)
#ifndef RC_INVOKED
#define IDI_APPLICATION MAKEINTRESOURCE(32512)
#define IDI_HAND MAKEINTRESOURCE(32513)
#define IDI_QUESTION MAKEINTRESOURCE(32514)
#define IDI_EXCLAMATION MAKEINTRESOURCE(32515)
#define IDI_ASTERISK MAKEINTRESOURCE(32516)
#define IDI_WINLOGO MAKEINTRESOURCE(32517)
#else
#define IDI_APPLICATION 32512
#define IDI_HAND 32513
#define IDI_QUESTION 32514
#define IDI_EXCLAMATION 32515
#define IDI_ASTERISK 32516
#define IDI_WINLOGO 32517
#if(WINVER >= 0x0600)
#define IDI_SHIELD  32518
#endif /* WINVER >= 0x0600 */
#endif
#define IDI_WARNING IDI_EXCLAMATION
#define IDI_ERROR IDI_HAND
#define IDI_INFORMATION IDI_ASTERISK
#define MIIM_STATE 1
#define MIIM_ID 2
#define MIIM_SUBMENU 4
#define MIIM_CHECKMARKS 8
#define MIIM_TYPE 16
#define MIIM_DATA 32
#define MIIM_STRING 64
#define MIIM_BITMAP 128
#define MIIM_FTYPE 256
#if (WINVER >= 0x0500)
#define MIM_MAXHEIGHT 1
#define MIM_BACKGROUND 2
#define MIM_HELPID 4
#define MIM_MENUDATA 8
#define MIM_STYLE 16
#define MIM_APPLYTOSUBMENUS 0x80000000L
#endif
#define MFT_BITMAP 4
#define MFT_MENUBARBREAK 32
#define MFT_MENUBREAK 64
#define MFT_OWNERDRAW 256
#define MFT_RADIOCHECK 512
#define MFT_RIGHTJUSTIFY 0x4000
#define MFT_SEPARATOR 0x800
#define MFT_RIGHTORDER 0x2000L
#define MFT_STRING 0
#define MFS_CHECKED 8
#define MFS_DEFAULT 4096
#define MFS_DISABLED 3
#define MFS_ENABLED 0
#define MFS_GRAYED 3
#define MFS_HILITE 128
#define MFS_UNCHECKED 0
#define MFS_UNHILITE 0
#define MNS_NOCHECK 0x80000000
#define MNS_MODELESS 0x40000000
#define MNS_DRAGDROP 0x20000000
#define MNS_AUTODISMISS 0x10000000
#define MNS_NOTIFYBYPOS 0x08000000
#define MNS_CHECKORBMP 0x04000000
#define GW_HWNDNEXT 2
#define GW_HWNDPREV 3
#define GW_CHILD 5
#define GW_HWNDFIRST 0
#define GW_HWNDLAST 1
#define GW_OWNER 4
#define GW_ENABLEDPOPUP 6
#define SW_HIDE 0
#define SW_NORMAL 1
#define SW_SHOWNORMAL 1
#define SW_SHOWMINIMIZED 2
#define SW_MAXIMIZE 3
#define SW_SHOWMAXIMIZED 3
#define SW_SHOWNOACTIVATE 4
#define SW_SHOW 5
#define SW_MINIMIZE 6
#define SW_SHOWMINNOACTIVE 7
#define SW_SHOWNA 8
#define SW_RESTORE 9
#define SW_SHOWDEFAULT 10
#define SW_FORCEMINIMIZE 11
#define SW_MAX 11
#define MB_USERICON 128
#define MB_ICONASTERISK 64
#define MB_ICONEXCLAMATION 0x30
#define MB_ICONWARNING 0x30
#define MB_ICONERROR 16
#define MB_ICONHAND 16
#define MB_ICONQUESTION 32
#define MB_OK 0
#define MB_ABORTRETRYIGNORE 2
#define MB_APPLMODAL 0
#define MB_DEFAULT_DESKTOP_ONLY 0x20000
#define MB_HELP 0x4000
#define MB_RIGHT 0x80000
#define MB_RTLREADING 0x100000
#define MB_TOPMOST 0x40000
#define MB_DEFBUTTON1 0
#define MB_DEFBUTTON2 256
#define MB_DEFBUTTON3 512
#define MB_DEFBUTTON4 0x300
#define MB_ICONINFORMATION 64
#define MB_ICONSTOP 16
#define MB_OKCANCEL 1
#define MB_RETRYCANCEL 5
#ifdef _WIN32_WINNT
#if (_WIN32_WINNT >= 0x0400)
#define MB_SERVICE_NOTIFICATION 0x00200000
#else
#define MB_SERVICE_NOTIFICATION 0x00040000
#endif
#define MB_SERVICE_NOTIFICATION_NT3X 0x00040000
#endif
#define MB_SETFOREGROUND 0x10000
#define MB_SYSTEMMODAL 4096
#define MB_TASKMODAL 0x2000
#define MB_YESNO 4
#define MB_YESNOCANCEL 3
#define MB_ICONMASK 240
#define MB_DEFMASK 3840
#define MB_MODEMASK 0x00003000
#define MB_MISCMASK 0x0000C000
#define MB_NOFOCUS 0x00008000
#define MB_TYPEMASK 15
#define MB_TOPMOST 0x40000
#if (WINVER >= 0x0500)
#define MB_CANCELTRYCONTINUE 6
#endif

#define IDOK 1
#define IDCANCEL 2
#define IDABORT 3
#define IDRETRY 4
#define IDIGNORE 5
#define IDYES 6
#define IDNO 7
#if (WINVER >= 0x0400)
#define IDCLOSE 8
#define IDHELP 9
#endif
#if (WINVER >= 0x0500)
#define IDTRYAGAIN 10
#define IDCONTINUE 11
#endif
#if (WINVER >= 0x0501)
#ifndef IDTIMEOUT
#define IDTIMEOUT 32000
#endif
#endif

#define GWL_EXSTYLE (-20)
#define GWL_STYLE (-16)
#define GWL_WNDPROC (-4)
#define GWLP_WNDPROC (-4)
#define GWL_HINSTANCE (-6)
#define GWLP_HINSTANCE (-6)
#define GWL_HWNDPARENT (-8)
#define GWLP_HWNDPARENT (-8)
#define GWL_ID (-12)
#define GWLP_ID (-12)
#define GWL_USERDATA (-21)
#define GWLP_USERDATA (-21)

#ifndef __REACTOS__ // NEVER USE THESE!
#define DWL_MSGRESULT 0
#define DWL_DLGPROC 4
#define DWL_USER 8
#endif

#define DWLP_MSGRESULT 0
#define DWLP_DLGPROC (DWLP_MSGRESULT + sizeof(LRESULT))
#define DWLP_USER (DWLP_DLGPROC + sizeof(DLGPROC))

#define QS_KEY              1
#define QS_MOUSEMOVE        2
#define QS_MOUSEBUTTON      4
#define QS_POSTMESSAGE      8
#define QS_TIMER            16
#define QS_PAINT            32
#define QS_SENDMESSAGE      64
#define QS_HOTKEY           128
#define QS_ALLPOSTMESSAGE   256

#if (_WIN32_WINNT >= 0x0501)
#define QS_RAWINPUT         1024
#endif
#if (_WIN32_WINNT >= 0x0602)
#define QS_TOUCH            2048
#define QS_POINTER          4096
#endif

#define QS_MOUSE            (QS_MOUSEMOVE | QS_MOUSEBUTTON)

#if (_WIN32_WINNT >= 0x0602)
#define QS_INPUT            (QS_KEY | QS_MOUSE | QS_RAWINPUT | QS_TOUCH | QS_POINTER)
#elif (_WIN32_WINNT >= 0x0501)
#define QS_INPUT            (QS_KEY | QS_MOUSE | QS_RAWINPUT)
#else
#define QS_INPUT            (QS_KEY | QS_MOUSE)
#endif

#define QS_ALLEVENTS        (QS_INPUT | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_HOTKEY)
#define QS_ALLINPUT         (QS_ALLEVENTS | QS_SENDMESSAGE)

#define USER_TIMER_MAXIMUM  2147483647
#define USER_TIMER_MINIMUM  10

#define MWMO_WAITALL 1
#define MWMO_ALERTABLE 2
#define MWMO_INPUTAVAILABLE 4

#define COLOR_SCROLLBAR 0
#define COLOR_BACKGROUND 1
#define COLOR_DESKTOP COLOR_BACKGROUND
#define COLOR_ACTIVECAPTION 2
#define COLOR_INACTIVECAPTION 3
#define COLOR_MENU 4
#define COLOR_WINDOW 5
#define COLOR_WINDOWFRAME 6
#define COLOR_MENUTEXT 7
#define COLOR_WINDOWTEXT 8
#define COLOR_CAPTIONTEXT 9
#define COLOR_ACTIVEBORDER 10
#define COLOR_INACTIVEBORDER 11
#define COLOR_APPWORKSPACE 12
#define COLOR_HIGHLIGHT 13
#define COLOR_HIGHLIGHTTEXT 14
#define COLOR_BTNFACE 15
#define COLOR_3DFACE COLOR_BTNFACE
#define COLOR_BTNSHADOW 16
#define COLOR_3DSHADOW COLOR_BTNSHADOW
#define COLOR_GRAYTEXT 17
#define COLOR_BTNTEXT 18
#define COLOR_INACTIVECAPTIONTEXT 19
#define COLOR_BTNHIGHLIGHT 20
#define COLOR_3DHIGHLIGHT COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT COLOR_BTNHIGHLIGHT
#define COLOR_3DDKSHADOW 21
#define COLOR_3DLIGHT 22
#define COLOR_INFOTEXT 23
#define COLOR_INFOBK 24
#define COLOR_HOTLIGHT 26
#define COLOR_GRADIENTACTIVECAPTION 27
#define COLOR_GRADIENTINACTIVECAPTION 28
#if WINVER >= 0x0501
#define COLOR_MENUHILIGHT 29
#define COLOR_MENUBAR 30
#endif

#define CTLCOLOR_MSGBOX 0
#define CTLCOLOR_EDIT 1
#define CTLCOLOR_LISTBOX 2
#define CTLCOLOR_BTN 3
#define CTLCOLOR_DLG 4
#define CTLCOLOR_SCROLLBAR 5
#define CTLCOLOR_STATIC 6
#define CTLCOLOR_MAX 7
#define SM_CXSCREEN 0
#define SM_CYSCREEN 1
#define SM_CXVSCROLL 2
#define SM_CYHSCROLL 3
#define SM_CYCAPTION 4
#define SM_CXBORDER 5
#define SM_CYBORDER 6
#define SM_CXDLGFRAME 7
#define SM_CXFIXEDFRAME 7
#define SM_CYDLGFRAME 8
#define SM_CYFIXEDFRAME 8
#define SM_CYVTHUMB 9
#define SM_CXHTHUMB 10
#define SM_CXICON 11
#define SM_CYICON 12
#define SM_CXCURSOR 13
#define SM_CYCURSOR 14
#define SM_CYMENU 15
#define SM_CXFULLSCREEN 16
#define SM_CYFULLSCREEN 17
#define SM_CYKANJIWINDOW 18
#define SM_MOUSEPRESENT 19
#define SM_CYVSCROLL 20
#define SM_CXHSCROLL 21
#define SM_DEBUG 22
#define SM_SWAPBUTTON 23
#define SM_RESERVED1 24
#define SM_RESERVED2 25
#define SM_RESERVED3 26
#define SM_RESERVED4 27
#define SM_CXMIN 28
#define SM_CYMIN 29
#define SM_CXSIZE 30
#define SM_CYSIZE 31
#define SM_CXSIZEFRAME 32
#define SM_CXFRAME 32
#define SM_CYSIZEFRAME 33
#define SM_CYFRAME 33
#define SM_CXMINTRACK 34
#define SM_CYMINTRACK 35
#define SM_CXDOUBLECLK 36
#define SM_CYDOUBLECLK 37
#define SM_CXICONSPACING 38
#define SM_CYICONSPACING 39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS 41
#define SM_DBCSENABLED 42
#define SM_CMOUSEBUTTONS 43
#define SM_SECURE 44
#define SM_CXEDGE 45
#define SM_CYEDGE 46
#define SM_CXMINSPACING 47
#define SM_CYMINSPACING 48
#define SM_CXSMICON 49
#define SM_CYSMICON 50
#define SM_CYSMCAPTION 51
#define SM_CXSMSIZE 52
#define SM_CYSMSIZE 53
#define SM_CXMENUSIZE 54
#define SM_CYMENUSIZE 55
#define SM_ARRANGE 56
#define SM_CXMINIMIZED 57
#define SM_CYMINIMIZED 58
#define SM_CXMAXTRACK 59
#define SM_CYMAXTRACK 60
#define SM_CXMAXIMIZED 61
#define SM_CYMAXIMIZED 62
#define SM_NETWORK 63
#define SM_CLEANBOOT 67
#define SM_CXDRAG 68
#define SM_CYDRAG 69
#define SM_SHOWSOUNDS 70
#define SM_CXMENUCHECK 71
#define SM_CYMENUCHECK 72
#define SM_SLOWMACHINE 73
#define SM_MIDEASTENABLED 74
#define SM_MOUSEWHEELPRESENT 75
#define SM_XVIRTUALSCREEN 76
#define SM_YVIRTUALSCREEN 77
#define SM_CXVIRTUALSCREEN 78
#define SM_CYVIRTUALSCREEN 79
#define SM_CMONITORS 80
#define SM_SAMEDISPLAYFORMAT 81
#if(_WIN32_WINNT >= 0x0500)
#define SM_IMMENABLED 82
#endif /* _WIN32_WINNT >= 0x0500 */
#if (_WIN32_WINNT >= 0x0501)
#define SM_CXFOCUSBORDER 83
#define SM_CYFOCUSBORDER 84
#define SM_TABLETPC      86
#define SM_MEDIACENTER   87
#define SM_STARTER       88
#define SM_SERVERR2      89
#endif /* _WIN32_WINNT >= 0x0501 */
#if (_WIN32_WINNT >= 0x0600)
#define SM_MOUSEHORIZONTALWHEELPRESENT 91
#define SM_CXPADDEDBORDER 92
#endif /* _WIN32_WINNT >= 0x0600 */

#define SM_REMOTESESSION 0x1000
#if (_WIN32_WINNT >= 0x0501)
#define SM_SHUTTINGDOWN 0x2000
#define SM_REMOTECONTROL 0x2001
#endif /* _WIN32_WINNT >= 0x0501 */

#if (WINVER < 0x0500) && ((_WIN32_WINNT < 0x0400) || !defined(_WIN32_WINNT))
#define SM_CMETRICS 76
#elif (WINVER == 0x500)
#define SM_CMETRICS 83
#elif (WINVER == 0x501)
#define SM_CMETRICS 90
#else
#define SM_CMETRICS 93
#endif

#define ARW_BOTTOMLEFT 0
#define ARW_BOTTOMRIGHT 1
#define ARW_HIDE 8
#define ARW_TOPLEFT 2
#define ARW_TOPRIGHT 3
#define ARW_DOWN 4
#define ARW_LEFT 0
#define ARW_RIGHT 0
#define ARW_UP 4
#define UOI_FLAGS 1
#define UOI_NAME 2
#define UOI_TYPE 3
#define UOI_USER_SID 4
#define LR_DEFAULTCOLOR 0
#define LR_MONOCHROME 1
#define LR_COLOR 2
#define LR_COPYRETURNORG 4
#define LR_COPYDELETEORG 8
#define LR_LOADFROMFILE 16
#define LR_LOADTRANSPARENT 32
#define LR_DEFAULTSIZE 64
#define LR_LOADREALSIZE 128
#define LR_VGACOLOR 128
#define LR_LOADMAP3DCOLORS 4096
#define LR_CREATEDIBSECTION 8192
#define LR_COPYFROMRESOURCE 0x4000
#define LR_SHARED 32768
#define KEYEVENTF_EXTENDEDKEY 0x00000001
#define KEYEVENTF_KEYUP 00000002
#if (_WIN32_WINNT >= 0x0500)
#define KEYEVENTF_UNICODE 0x00000004
#define KEYEVENTF_SCANCODE 0x00000008
#endif

#ifdef OEMRESOURCE
#define OBM_TRTYPE 32732
#define OBM_LFARROWI 32734
#define OBM_RGARROWI 32735
#define OBM_DNARROWI 32736
#define OBM_UPARROWI 32737
#define OBM_COMBO 32738
#define OBM_MNARROW 32739
#define OBM_LFARROWD 32740
#define OBM_RGARROWD 32741
#define OBM_DNARROWD 32742
#define OBM_UPARROWD 32743
#define OBM_RESTORED 32744
#define OBM_ZOOMD 32745
#define OBM_REDUCED 32746
#define OBM_RESTORE 32747
#define OBM_ZOOM 32748
#define OBM_REDUCE 32749
#define OBM_LFARROW 32750
#define OBM_RGARROW 32751
#define OBM_DNARROW 32752
#define OBM_UPARROW 32753
#define OBM_CLOSE 32754
#define OBM_OLD_RESTORE 32755
#define OBM_OLD_ZOOM 32756
#define OBM_OLD_REDUCE 32757
#define OBM_BTNCORNERS 32758
#define OBM_CHECKBOXES 32759
#define OBM_CHECK 32760
#define OBM_BTSIZE 32761
#define OBM_OLD_LFARROW 32762
#define OBM_OLD_RGARROW 32763
#define OBM_OLD_DNARROW 32764
#define OBM_OLD_UPARROW 32765
#define OBM_SIZE 32766
#define OBM_OLD_CLOSE 32767
#define OCR_NORMAL 32512
#define OCR_IBEAM 32513
#define OCR_WAIT 32514
#define OCR_CROSS 32515
#define OCR_UP 32516
#define OCR_SIZE 32640
#define OCR_ICON 32641
#define OCR_SIZENWSE 32642
#define OCR_SIZENESW 32643
#define OCR_SIZEWE 32644
#define OCR_SIZENS 32645
#define OCR_SIZEALL 32646
#define OCR_NO 32648
#define OCR_HAND 32649
#define OCR_APPSTARTING 32650
#define OCR_HELP 32651
#define OIC_SAMPLE 32512
#define OIC_HAND 32513
#define OIC_QUES 32514
#define OIC_BANG 32515
#define OIC_NOTE 32516
#define OIC_WINLOGO 32517
#define OIC_WARNING OIC_BANG
#define OIC_ERROR OIC_HAND
#define OIC_INFORMATION OIC_NOTE
#endif /* OEMRESOURCE */

#define HELPINFO_MENUITEM 2
#define HELPINFO_WINDOW 1
#define MSGF_DIALOGBOX 0
#define MSGF_MESSAGEBOX 1
#define MSGF_MENU 2
#define MSGF_MOVE 3
#define MSGF_SIZE 4
#define MSGF_SCROLLBAR 5
#define MSGF_NEXTWINDOW 6
#define MSGF_MAINLOOP 8
#define MSGF_USER 4096
#define MSGF_MAX  8
#define MOUSEEVENTF_MOVE        0x0001
#define MOUSEEVENTF_LEFTDOWN    0x0002
#define MOUSEEVENTF_LEFTUP      0x0004
#define MOUSEEVENTF_RIGHTDOWN   0x0008
#define MOUSEEVENTF_RIGHTUP     0x0010
#define MOUSEEVENTF_MIDDLEDOWN  0x0020
#define MOUSEEVENTF_MIDDLEUP    0x0040
#define MOUSEEVENTF_XDOWN       0x0080
#define MOUSEEVENTF_XUP         0x0100
#define MOUSEEVENTF_WHEEL       0x0800
#define MOUSEEVENTF_VIRTUALDESK 0x4000
#define MOUSEEVENTF_ABSOLUTE    0x8000
#define PM_NOREMOVE 0
#define PM_REMOVE 1
#define PM_NOYIELD 2
#if (WINVER >= 0x0500)
# define PM_QS_INPUT (QS_INPUT << 16)
# define PM_QS_POSTMESSAGE ((QS_POSTMESSAGE|QS_HOTKEY|QS_TIMER) << 16)
# define PM_QS_PAINT (QS_PAINT << 16)
# define PM_QS_SENDMESSAGE (QS_SENDMESSAGE << 16)
#endif
#define HWND_BROADCAST  ((HWND)0xffff)
#define HWND_BOTTOM ((HWND)1)
#define HWND_NOTOPMOST ((HWND)(-2))
#define HWND_TOP ((HWND)0)
#define HWND_TOPMOST ((HWND)(-1))
#define HWND_DESKTOP (HWND)0
#define HWND_MESSAGE ((HWND)(-3)) /* w2k */
#define RDW_ERASE 4
#define RDW_FRAME 1024
#define RDW_INTERNALPAINT 2
#define RDW_INVALIDATE 1
#define RDW_NOERASE 32
#define RDW_NOFRAME 2048
#define RDW_NOINTERNALPAINT 16
#define RDW_VALIDATE 8
#define RDW_ERASENOW 512
#define RDW_UPDATENOW 256
#define RDW_ALLCHILDREN 128
#define RDW_NOCHILDREN 64
#define SMTO_ABORTIFHUNG 2
#define SMTO_BLOCK 1
#define SMTO_NORMAL 0
#if (WINVER >= 0x0500)
#define SMTO_NOTIMEOUTIFNOTHUNG 8
#endif
#if (WINVER >= 0x0600)
#define SMTO_ERRORONEXIT 32
#endif
#define SIF_ALL 23
#define SIF_PAGE 2
#define SIF_POS 4
#define SIF_RANGE 1
#define SIF_DISABLENOSCROLL 8
#define SIF_TRACKPOS   16
#define SIF_THEMED 128      /* REACTOS Specific Only */
#define SWP_DRAWFRAME 32
#define SWP_FRAMECHANGED 32
#define SWP_HIDEWINDOW 128
#define SWP_NOACTIVATE 16
#define SWP_NOCOPYBITS 256
#define SWP_NOMOVE 2
#define SWP_NOSIZE 1
#define SWP_NOREDRAW 8
#define SWP_NOZORDER 4
#define SWP_SHOWWINDOW 64
#define SWP_NOOWNERZORDER 512
#define SWP_NOREPOSITION 512
#define SWP_NOSENDCHANGING 1024
#define SWP_DEFERERASE 8192
#define SWP_ASYNCWINDOWPOS  16384

#define HSHELL_WINDOWCREATED 1
#define HSHELL_WINDOWDESTROYED 2
#define HSHELL_ACTIVATESHELLWINDOW 3
#if(WINVER >= 0x0400)
#define HSHELL_WINDOWACTIVATED 4
#define HSHELL_GETMINRECT 5
#define HSHELL_REDRAW 6
#define HSHELL_TASKMAN 7
#define HSHELL_LANGUAGE 8
#define HSHELL_SYSMENU  9
#define HSHELL_ENDTASK  10
#endif /* WINVER >= 0x0400 */
#if(_WIN32_WINNT >= 0x0500)
#define HSHELL_ACCESSIBILITYSTATE 11
#define ACCESS_STICKYKEYS 0x01
#define ACCESS_FILTERKEYS 0x02
#define ACCESS_MOUSEKEYS 0x03
#define HSHELL_APPCOMMAND 12
#endif /* _WIN32_WINNT >= 0x0500 */
#if(_WIN32_WINNT >= 0x0501)
#define HSHELL_WINDOWREPLACED 13
#define HSHELL_WINDOWREPLACING 14
#endif /* _WIN32_WINNT >= 0x0501 */

#define HSHELL_HIGHBIT          0x8000
#define HSHELL_FLASH            (HSHELL_REDRAW|HSHELL_HIGHBIT)
#define HSHELL_RUDEAPPACTIVATED (HSHELL_WINDOWACTIVATED|HSHELL_HIGHBIT)

#if(_WIN32_WINNT >= 0x0500)
#define APPCOMMAND_BROWSER_BACKWARD 1
#define APPCOMMAND_BROWSER_FORWARD 2
#define APPCOMMAND_BROWSER_REFRESH 3
#define APPCOMMAND_BROWSER_STOP 4
#define APPCOMMAND_BROWSER_SEARCH 5
#define APPCOMMAND_BROWSER_FAVORITES 6
#define APPCOMMAND_BROWSER_HOME 7
#define APPCOMMAND_VOLUME_MUTE 8
#define APPCOMMAND_VOLUME_DOWN 9
#define APPCOMMAND_VOLUME_UP 10
#define APPCOMMAND_MEDIA_NEXTTRACK 11
#define APPCOMMAND_MEDIA_PREVIOUSTRACK 12
#define APPCOMMAND_MEDIA_STOP 13
#define APPCOMMAND_MEDIA_PLAY_PAUSE 14
#define APPCOMMAND_LAUNCH_MAIL 15
#define APPCOMMAND_LAUNCH_MEDIA_SELECT 16
#define APPCOMMAND_LAUNCH_APP1 17
#define APPCOMMAND_LAUNCH_APP2 18
#define APPCOMMAND_BASS_DOWN 19
#define APPCOMMAND_BASS_BOOST 20
#define APPCOMMAND_BASS_UP 21
#define APPCOMMAND_TREBLE_DOWN 22
#define APPCOMMAND_TREBLE_UP 23
#if( _WIN32_WINNT >= 0x0501 )
#define APPCOMMAND_MICROPHONE_VOLUME_MUTE 24
#define APPCOMMAND_MICROPHONE_VOLUME_DOWN 25
#define APPCOMMAND_MICROPHONE_VOLUME_UP 26
#define APPCOMMAND_HELP 27
#define APPCOMMAND_FIND 28
#define APPCOMMAND_NEW 29
#define APPCOMMAND_OPEN 30
#define APPCOMMAND_CLOSE 31
#define APPCOMMAND_SAVE 32
#define APPCOMMAND_PRINT 33
#define APPCOMMAND_UNDO 34
#define APPCOMMAND_REDO 35
#define APPCOMMAND_COPY 36
#define APPCOMMAND_CUT 37
#define APPCOMMAND_PASTE 38
#define APPCOMMAND_REPLY_TO_MAIL 39
#define APPCOMMAND_FORWARD_MAIL 40
#define APPCOMMAND_SEND_MAIL 41
#define APPCOMMAND_SPELL_CHECK 42
#define APPCOMMAND_DICTATE_OR_COMMAND_CONTROL_TOGGLE 43
#define APPCOMMAND_MIC_ON_OFF_TOGGLE 44
#define APPCOMMAND_CORRECTION_LIST 45
#define APPCOMMAND_MEDIA_PLAY 46
#define APPCOMMAND_MEDIA_PAUSE 47
#define APPCOMMAND_MEDIA_RECORD 48
#define APPCOMMAND_MEDIA_FAST_FORWARD 49
#define APPCOMMAND_MEDIA_REWIND 50
#define APPCOMMAND_MEDIA_CHANNEL_UP 51
#define APPCOMMAND_MEDIA_CHANNEL_DOWN 52
#endif /* _WIN32_WINNT >= 0x0501 */

#define FAPPCOMMAND_MOUSE   0x8000
#define FAPPCOMMAND_KEY 0
#define FAPPCOMMAND_OEM 0x1000
#define FAPPCOMMAND_MASK    0xf000

#define GET_APPCOMMAND_LPARAM(lParam)   ((SHORT)(HIWORD(lParam) & ~FAPPCOMMAND_MASK))
#define GET_DEVICE_LPARAM(lParam)   ((WORD)(HIWORD(lParam) & FAPPCOMMAND_MASK))
#define GET_MOUSEORKEY_LPARAM   GET_DEVICE_LPARAM
#define GET_FLAGS_LPARAM(lParam)    (LOWORD(lParam))
#define GET_KEYSTATE_LPARAM(lParam) GET_FLAGS_LPARAM(lParam)
#endif



#define SPI_GETBEEP 0x0001
#define SPI_SETBEEP 0x0002
#define SPI_GETMOUSE 0x0003
#define SPI_SETMOUSE 0x0004
#define SPI_GETBORDER 0x0005
#define SPI_SETBORDER 0x0006
#define SPI_GETKEYBOARDSPEED 0x000A
#define SPI_SETKEYBOARDSPEED 0x000B
#define SPI_LANGDRIVER 0x000C
#define SPI_ICONHORIZONTALSPACING 0x000D
#define SPI_GETSCREENSAVETIMEOUT 0x000E
#define SPI_SETSCREENSAVETIMEOUT 0x000F
#define SPI_GETSCREENSAVEACTIVE 0x0010
#define SPI_SETSCREENSAVEACTIVE 0x0011
#define SPI_GETGRIDGRANULARITY 0x0012
#define SPI_SETGRIDGRANULARITY 0x0013
#define SPI_SETDESKWALLPAPER 0x0014
#define SPI_SETDESKPATTERN 0x0015
#define SPI_GETKEYBOARDDELAY 0x0016
#define SPI_SETKEYBOARDDELAY 0x0017
#define SPI_ICONVERTICALSPACING 0x0018
#define SPI_GETICONTITLEWRAP 0x0019
#define SPI_SETICONTITLEWRAP 0x001A
#define SPI_GETMENUDROPALIGNMENT 0x001B
#define SPI_SETMENUDROPALIGNMENT 0x001C
#define SPI_SETDOUBLECLKWIDTH 0x001D
#define SPI_SETDOUBLECLKHEIGHT 0x001E
#define SPI_GETICONTITLELOGFONT 0x001F
#define SPI_SETDOUBLECLICKTIME 0x0020
#define SPI_SETMOUSEBUTTONSWAP 0x0021
#define SPI_SETICONTITLELOGFONT 0x0022
#define SPI_GETFASTTASKSWITCH 0x0023
#define SPI_SETFASTTASKSWITCH 0x0024
#if(WINVER >= 0x0400)
    #define SPI_SETDRAGFULLWINDOWS 0x0025
    #define SPI_GETDRAGFULLWINDOWS 0x0026
    #define SPI_GETNONCLIENTMETRICS 0x0029
    #define SPI_SETNONCLIENTMETRICS 0x002A
    #define SPI_GETMINIMIZEDMETRICS 0x002B
    #define SPI_SETMINIMIZEDMETRICS 0x002C
    #define SPI_GETICONMETRICS 0x002D
    #define SPI_SETICONMETRICS 0x002E
    #define SPI_SETWORKAREA 0x002F
    #define SPI_GETWORKAREA 0x0030
    #define SPI_SETPENWINDOWS 0x0031
#endif
#define SPI_GETFILTERKEYS 0x0032
#define SPI_SETFILTERKEYS 0x0033
#define SPI_GETTOGGLEKEYS 0x0034
#define SPI_SETTOGGLEKEYS 0x0035
#define SPI_GETMOUSEKEYS 0x0036
#define SPI_SETMOUSEKEYS 0x0037
#define SPI_GETSHOWSOUNDS 0x0038
#define SPI_SETSHOWSOUNDS 0x0039
#define SPI_GETSTICKYKEYS 0x003A
#define SPI_SETSTICKYKEYS 0x003B
#define SPI_GETACCESSTIMEOUT 0x003C
#define SPI_SETACCESSTIMEOUT 0x003D
#if(WINVER >= 0x0400)
    #define SPI_GETSERIALKEYS 0x003E
    #define SPI_SETSERIALKEYS 0x003F
#endif
#define SPI_GETSOUNDSENTRY 0x0040
#define SPI_SETSOUNDSENTRY 0x0041
#if(WINVER >= 0x0400)
    #define SPI_GETHIGHCONTRAST 0x0042
    #define SPI_SETHIGHCONTRAST 0x0043
    #define SPI_GETKEYBOARDPREF 0x0044
    #define SPI_SETKEYBOARDPREF 0x0045
    #define SPI_GETSCREENREADER 0x0046
    #define SPI_SETSCREENREADER 0x0047
    #define SPI_GETANIMATION 0x0048
    #define SPI_SETANIMATION 0x0049
    #define SPI_GETFONTSMOOTHING 0x004A
    #define SPI_SETFONTSMOOTHING 0x004B
    #define SPI_SETDRAGWIDTH 0x004C
    #define SPI_SETDRAGHEIGHT 0x004D
    #define SPI_SETHANDHELD 0x004E
    #define SPI_GETLOWPOWERTIMEOUT 0x004F
    #define SPI_GETPOWEROFFTIMEOUT 0x0050
    #define SPI_SETLOWPOWERTIMEOUT 0x0051
    #define SPI_SETPOWEROFFTIMEOUT 0x0052
    #define SPI_GETLOWPOWERACTIVE 0x0053
    #define SPI_GETPOWEROFFACTIVE 0x0054
    #define SPI_SETLOWPOWERACTIVE 0x0055
    #define SPI_SETPOWEROFFACTIVE 0x0056
    #define SPI_SETCURSORS 0x0057
    #define SPI_SETICONS 0x0058
    #define SPI_GETDEFAULTINPUTLANG 0x0059
    #define SPI_SETDEFAULTINPUTLANG 0x005A
    #define SPI_SETLANGTOGGLE 0x005B
    #define SPI_GETWINDOWSEXTENSION 0x005C
    #define SPI_SETMOUSETRAILS 0x005D
    #define SPI_GETMOUSETRAILS 0x005E
#endif
#if(_WIN32_WINNT >= 0x0400)
    #define SPI_GETSNAPTODEFBUTTON 0x005F
    #define SPI_SETSNAPTODEFBUTTON 0x0060
#endif
#if(WINVER >= 0x0400)
    #define SPI_SCREENSAVERRUNNING 0x0061
    #define SPI_SETSCREENSAVERRUNNING SPI_SCREENSAVERRUNNING
#endif
#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
    #define SPI_GETMOUSEHOVERWIDTH 0x0062
    #define SPI_SETMOUSEHOVERWIDTH 0x0063
    #define SPI_GETMOUSEHOVERHEIGHT 0x0064
    #define SPI_SETMOUSEHOVERHEIGHT 0x0065
    #define SPI_GETMOUSEHOVERTIME 0x0066
    #define SPI_SETMOUSEHOVERTIME 0x0067
    #define SPI_GETWHEELSCROLLLINES 0x0068
    #define SPI_SETWHEELSCROLLLINES 0x0069
    #define SPI_GETMENUSHOWDELAY 0x006A
    #define SPI_SETMENUSHOWDELAY 0x006B
    #if (_WIN32_WINNT >= 0x0600)
        #define SPI_GETWHEELSCROLLCHARS 0x006C
        #define SPI_SETWHEELSCROLLCHARS 0x006D
    #endif
    #define SPI_GETSHOWIMEUI 0x006E
    #define SPI_SETSHOWIMEUI 0x006F
#endif
#if(WINVER >= 0x0500)
    #define SPI_GETMOUSESPEED 0x0070
    #define SPI_SETMOUSESPEED 0x0071
    #define SPI_GETSCREENSAVERRUNNING 0x0072
    #define SPI_GETDESKWALLPAPER 0x0073
#endif
#if(WINVER >= 0x0600)
    #define SPI_GETAUDIODESCRIPTION 0x0074
    #define SPI_SETAUDIODESCRIPTION 0x0075
    #define SPI_GETSCREENSAVESECURE 0x0076
    #define SPI_SETSCREENSAVESECURE 0x0077
#endif
#if(WINVER >= 0x0500)
    #define SPI_GETACTIVEWINDOWTRACKING 0x1000
    #define SPI_SETACTIVEWINDOWTRACKING 0x1001
    #define SPI_GETMENUANIMATION 0x1002
    #define SPI_SETMENUANIMATION 0x1003
    #define SPI_GETCOMBOBOXANIMATION 0x1004
    #define SPI_SETCOMBOBOXANIMATION 0x1005
    #define SPI_GETLISTBOXSMOOTHSCROLLING 0x1006
    #define SPI_SETLISTBOXSMOOTHSCROLLING 0x1007
    #define SPI_GETGRADIENTCAPTIONS 0x1008
    #define SPI_SETGRADIENTCAPTIONS 0x1009
    #define SPI_GETKEYBOARDCUES 0x100A
    #define SPI_SETKEYBOARDCUES 0x100B
    #define SPI_GETMENUUNDERLINES SPI_GETKEYBOARDCUES
    #define SPI_SETMENUUNDERLINES SPI_SETKEYBOARDCUES
    #define SPI_GETACTIVEWNDTRKZORDER 0x100C
    #define SPI_SETACTIVEWNDTRKZORDER 0x100D
    #define SPI_GETHOTTRACKING 0x100E
    #define SPI_SETHOTTRACKING 0x100F
    #define SPI_GETMENUFADE 0x1012
    #define SPI_SETMENUFADE 0x1013
    #define SPI_GETSELECTIONFADE 0x1014
    #define SPI_SETSELECTIONFADE 0x1015
    #define SPI_GETTOOLTIPANIMATION 0x1016
    #define SPI_SETTOOLTIPANIMATION 0x1017
    #define SPI_GETTOOLTIPFADE 0x1018
    #define SPI_SETTOOLTIPFADE 0x1019
    #define SPI_GETCURSORSHADOW 0x101A
    #define SPI_SETCURSORSHADOW 0x101B
    #if(_WIN32_WINNT >= 0x0501)
        #define SPI_GETMOUSESONAR 0x101C
        #define SPI_SETMOUSESONAR 0x101D
        #define SPI_GETMOUSECLICKLOCK 0x101E
        #define SPI_SETMOUSECLICKLOCK 0x101F
        #define SPI_GETMOUSEVANISH 0x1020
        #define SPI_SETMOUSEVANISH 0x1021
        #define SPI_GETFLATMENU 0x1022
        #define SPI_SETFLATMENU 0x1023
        #define SPI_GETDROPSHADOW 0x1024
        #define SPI_SETDROPSHADOW 0x1025
        #define SPI_GETBLOCKSENDINPUTRESETS 0x1026
        #define SPI_SETBLOCKSENDINPUTRESETS 0x1027
    #endif
    #define SPI_GETUIEFFECTS 0x103E
    #define SPI_SETUIEFFECTS 0x103F
    #if(_WIN32_WINNT >= 0x0600)
        #define SPI_GETDISABLEOVERLAPPEDCONTENT 0x1040
        #define SPI_SETDISABLEOVERLAPPEDCONTENT 0x1041
        #define SPI_GETCLIENTAREAANIMATION 0x1042
        #define SPI_SETCLIENTAREAANIMATION 0x1043
        #define SPI_GETCLEARTYPE 0x1048
        #define SPI_SETCLEARTYPE 0x1049
        #define SPI_GETSPEECHRECOGNITION 0x104A
        #define SPI_SETSPEECHRECOGNITION 0x104B
    #endif
    #define SPI_GETFOREGROUNDLOCKTIMEOUT 0x2000
    #define SPI_SETFOREGROUNDLOCKTIMEOUT 0x2001
    #define SPI_GETACTIVEWNDTRKTIMEOUT 0x2002
    #define SPI_SETACTIVEWNDTRKTIMEOUT 0x2003
    #define SPI_GETFOREGROUNDFLASHCOUNT 0x2004
    #define SPI_SETFOREGROUNDFLASHCOUNT 0x2005
    #define SPI_GETCARETWIDTH 0x2006
    #define SPI_SETCARETWIDTH 0x2007
    #if(_WIN32_WINNT >= 0x0501)
        #define SPI_GETMOUSECLICKLOCKTIME 0x2008
        #define SPI_SETMOUSECLICKLOCKTIME 0x2009
        #define SPI_GETFONTSMOOTHINGTYPE 0x200A
        #define SPI_SETFONTSMOOTHINGTYPE 0x200B
        #define SPI_GETFONTSMOOTHINGCONTRAST 0x200C
        #define SPI_SETFONTSMOOTHINGCONTRAST 0x200D
        #define SPI_GETFOCUSBORDERWIDTH 0x200E
        #define SPI_SETFOCUSBORDERWIDTH 0x200F
        #define SPI_GETFOCUSBORDERHEIGHT 0x2010
        #define SPI_SETFOCUSBORDERHEIGHT 0x2011
        #define SPI_GETFONTSMOOTHINGORIENTATION 0x2012
        #define SPI_SETFONTSMOOTHINGORIENTATION 0x2013

        #define FE_FONTSMOOTHINGSTANDARD 0x0001
        #define FE_FONTSMOOTHINGCLEARTYPE 0x0002
        #define FE_FONTSMOOTHINGDOCKING 0x8000
        #define FE_FONTSMOOTHINGORIENTATIONBGR 0x0000
        #define FE_FONTSMOOTHINGORIENTATIONRGB 0x0001
    #endif
#endif

#define SPIF_UPDATEINIFILE 1
#define SPIF_SENDCHANGE 2
#define SPIF_SENDWININICHANGE SPIF_SENDCHANGE
#define ATF_ONOFFFEEDBACK 2
#define ATF_TIMEOUTON 1

#if (WINVER >= 0x0500)
#define UIS_SET 1
#define UIS_CLEAR 2
#define UIS_INITIALIZE 3

#define UISF_HIDEFOCUS 0x1
#define UISF_HIDEACCEL 0x2
#if (WINVER >= 0x0501)
#define UISF_ACTIVE 0x4
#endif

#endif

#define PBT_APMQUERYSUSPEND 0x0000
#define PBT_APMQUERYSTANDBY 0x0001
#define PBT_APMQUERYSUSPENDFAILED 0x0002
#define PBT_APMQUERYSTANDBYFAILED 0x0003
#define PBT_APMSUSPEND 0x0004
#define PBT_APMSTANDBY 0x0005
#define PBT_APMRESUMECRITICAL 0x0006
#define PBT_APMRESUMESUSPEND 0x0007
#define PBT_APMRESUMESTANDBY 0x0008
#define PBTF_APMRESUMEFROMFAILURE 0x00000001
#define PBT_APMBATTERYLOW 0x0009
#define PBT_APMPOWERSTATUSCHANGE 0x000A
#define PBT_APMOEMEVENT 0x000B
#define PBT_APMRESUMEAUTOMATIC 0x0012


/* Window messages */
#define WM_NULL 0
#define WM_CREATE 1
#define WM_DESTROY 2
#define WM_MOVE 3
#define WM_SIZE 5
#define WM_ACTIVATE 6
#define WM_SETFOCUS 7
#define WM_KILLFOCUS 8
#define WM_ENABLE 10
#define WM_SETREDRAW 11
#define WM_SETTEXT 12
#define WM_GETTEXT 13
#define WM_GETTEXTLENGTH 14
#define WM_PAINT 15
#define WM_CLOSE 16
#define WM_QUERYENDSESSION 17
#define WM_QUIT 18
#define WM_QUERYOPEN 19
#define WM_ERASEBKGND 20
#define WM_SYSCOLORCHANGE 21
#define WM_ENDSESSION 22
#define WM_SHOWWINDOW 24
#define WM_SETTINGCHANGE 26
#define WM_WININICHANGE 26
#define WM_DEVMODECHANGE 27
#define WM_ACTIVATEAPP 28
#define WM_FONTCHANGE 29
#define WM_TIMECHANGE 30
#define WM_CANCELMODE 31
#define WM_SETCURSOR 32
#define WM_MOUSEACTIVATE 33
#define WM_CHILDACTIVATE 34
#define WM_QUEUESYNC 35
#define WM_GETMINMAXINFO 36
#define WM_PAINTICON 38
#define WM_ICONERASEBKGND 39
#define WM_NEXTDLGCTL 40
#define WM_SPOOLERSTATUS 42
#define WM_DRAWITEM 43
#define WM_MEASUREITEM 44
#define WM_DELETEITEM 45
#define WM_VKEYTOITEM 46
#define WM_CHARTOITEM 47
#define WM_SETFONT 48
#define WM_GETFONT 49
#define WM_SETHOTKEY 50
#define WM_GETHOTKEY 51
#define WM_QUERYDRAGICON 55
#define WM_COMPAREITEM 57
#if (WINVER >= 0x0500)
#define WM_GETOBJECT 61
#endif /* (WINVER >= 0x0500) */
#define WM_COMPACTING 65
#define WM_COMMNOTIFY 68		/* obsolete */
#define WM_WINDOWPOSCHANGING 70
#define WM_WINDOWPOSCHANGED 71
#define WM_POWER 72
#define WM_COPYDATA 74
#define WM_CANCELJOURNAL 75

#if (WINVER >= 0x0400)
#define WM_NOTIFY 78
#define WM_INPUTLANGCHANGEREQUEST 80
#define WM_INPUTLANGCHANGE 81
#define WM_TCARD 82
#define WM_HELP 83
#define WM_USERCHANGED 84
#define WM_NOTIFYFORMAT 85
#define WM_CONTEXTMENU 123
#define WM_STYLECHANGING 124
#define WM_STYLECHANGED 125
#define WM_DISPLAYCHANGE 126
#define WM_GETICON 127
#define WM_SETICON 128
#endif /* (WINVER >= 0x0400) */

#define WM_NCCREATE 129
#define WM_NCDESTROY 130
#define WM_NCCALCSIZE 131
#define WM_NCHITTEST 132
#define WM_NCPAINT 133
#define WM_NCACTIVATE 134
#define WM_GETDLGCODE 135
#define WM_SYNCPAINT  136
#define WM_NCMOUSEMOVE 160
#define WM_NCLBUTTONDOWN 161
#define WM_NCLBUTTONUP 162
#define WM_NCLBUTTONDBLCLK 163
#define WM_NCRBUTTONDOWN 164
#define WM_NCRBUTTONUP 165
#define WM_NCRBUTTONDBLCLK 166
#define WM_NCMBUTTONDOWN 167
#define WM_NCMBUTTONUP 168
#define WM_NCMBUTTONDBLCLK 169

#if (_WIN32_WINNT >= 0x0500)
#define WM_NCXBUTTONDOWN 171
#define WM_NCXBUTTONUP 172
#define WM_NCXBUTTONDBLCLK 173
#endif /* (_WIN32_WINNT >= 0x0500) */

#define GIDC_ARRIVAL 1
#define GIDC_REMOVAL 2

#define WM_INPUT_DEVICE_CHANGE 254
#define WM_INPUT 255

#define WM_KEYFIRST 256
#define WM_KEYDOWN 256
#define WM_KEYUP 257
#define WM_CHAR 258
#define WM_DEADCHAR 259
#define WM_SYSKEYDOWN 260
#define WM_SYSKEYUP 261
#define WM_SYSCHAR 262
#define WM_SYSDEADCHAR 263
#if(_WIN32_WINNT >= 0x0501)
#define WM_UNICHAR 0x0109
#define WM_KEYLAST WM_UNICHAR
#define UNICODE_NOCHAR 0xffff
#else
#define WM_KEYLAST 264
#endif

/* Win32 4.0 messages for IME */
#if (WINVER >= 0x0400)
#define WM_IME_STARTCOMPOSITION     0x010d
#define WM_IME_ENDCOMPOSITION       0x010e
#define WM_IME_COMPOSITION          0x010f
#define WM_IME_KEYLAST              0x010f
#endif /* (WINVER >= 0x0400) */

#define WM_INITDIALOG 272
#define WM_COMMAND 273
#define WM_SYSCOMMAND 274
#define WM_TIMER 275
#define WM_HSCROLL 276
#define WM_VSCROLL 277
#define WM_INITMENU 278
#define WM_INITMENUPOPUP 279
#define WM_MENUSELECT 287
#define WM_MENUCHAR 288
#define WM_ENTERIDLE 289

#if (WINVER >= 0x0500)
#ifndef _WIN32_WCE
#define WM_MENURBUTTONUP 290
#define WM_MENUDRAG 291
#define WM_MENUGETOBJECT 292
#define WM_UNINITMENUPOPUP 293
#define WM_MENUCOMMAND 294
#if(_WIN32_WINNT >= 0x0500)
#define WM_CHANGEUISTATE 295
#define WM_UPDATEUISTATE 296
#define WM_QUERYUISTATE 297
#endif /* _WIN32_WINNT >= 0x0500 */
#endif /* _WIN32_WCE */
#endif /* (WINVER >= 0x0500) */

#define WM_CTLCOLORMSGBOX 306
#define WM_CTLCOLOREDIT 307
#define WM_CTLCOLORLISTBOX 308
#define WM_CTLCOLORBTN 309
#define WM_CTLCOLORDLG 310
#define WM_CTLCOLORSCROLLBAR 311
#define WM_CTLCOLORSTATIC 312
#define MN_GETHMENU 481
#define WM_MOUSEFIRST 512
#define WM_MOUSEMOVE 512
#define WM_LBUTTONDOWN 513
#define WM_LBUTTONUP 514
#define WM_LBUTTONDBLCLK 515
#define WM_RBUTTONDOWN 516
#define WM_RBUTTONUP 517
#define WM_RBUTTONDBLCLK 518
#define WM_MBUTTONDOWN 519
#define WM_MBUTTONUP 520
#define WM_MBUTTONDBLCLK 521
#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
#define WM_MOUSEWHEEL 522
#endif
#if (_WIN32_WINNT >= 0x0500)
#define WM_XBUTTONDOWN 523
#define WM_XBUTTONUP 524
#define WM_XBUTTONDBLCLK 525
#endif
#if (_WIN32_WINNT >= 0x0600)
#define WM_MOUSEHWHEEL 526
#endif
#if (_WIN32_WINNT >= 0x0500)
#define WM_MOUSELAST 525
#elif (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
#define WM_MOUSELAST 522
#else
#define WM_MOUSELAST 521
#endif
#define WM_PARENTNOTIFY 528
#define WM_ENTERMENULOOP 529
#define WM_EXITMENULOOP 530
#define WM_NEXTMENU 531
#define WM_SIZING 532
#define WM_CAPTURECHANGED 533
#define WM_MOVING 534
#define WM_POWERBROADCAST 536
#define WM_DEVICECHANGE 537
#define WM_MDICREATE 544
#define WM_MDIDESTROY 545
#define WM_MDIACTIVATE 546
#define WM_MDIRESTORE 547
#define WM_MDINEXT 548
#define WM_MDIMAXIMIZE 549
#define WM_MDITILE 550
#define WM_MDICASCADE 551
#define WM_MDIICONARRANGE 552
#define WM_MDIGETACTIVE 553
#define WM_MDISETMENU 560
#define WM_ENTERSIZEMOVE 561
#define WM_EXITSIZEMOVE 562
#define WM_DROPFILES 563
#define WM_MDIREFRESHMENU 564

/* Win32 4.0 messages for IME */
#define WM_IME_SETCONTEXT           0x0281
#define WM_IME_NOTIFY               0x0282
#define WM_IME_CONTROL              0x0283
#define WM_IME_COMPOSITIONFULL      0x0284
#define WM_IME_SELECT               0x0285
#define WM_IME_CHAR                 0x0286
/* Win32 5.0 messages for IME */
#define WM_IME_REQUEST              0x0288
/* Win32 4.0 messages for IME */
#define WM_IME_KEYDOWN              0x0290
#define WM_IME_KEYUP                0x0291

#define WM_NCMOUSEHOVER             0x02A0
#define WM_NCMOUSELEAVE             0x02A2
#define WM_MOUSEHOVER               0x02A1
#define WM_MOUSELEAVE               0x02A3

#if (_WIN32_WINNT >= 0x0501)
#define WTS_CONSOLE_CONNECT 0x1
#define WTS_CONSOLE_DISCONNECT 0x2
#define WTS_REMOTE_CONNECT 0x3
#define WTS_REMOTE_DISCONNECT 0x4
#define WTS_SESSION_LOGON 0x5
#define WTS_SESSION_LOGOFF 0x6
#define WTS_SESSION_LOCK 0x7
#define WTS_SESSION_UNLOCK 0x8
#define WTS_SESSION_REMOTE_CONTROL 0x9
#define WTS_SESSION_CREATE 0xA
#define WTS_SESSION_TERMINATE 0xB
#define WM_WTSSESSION_CHANGE 0x02B1
#endif

#define WM_CUT 768
#define WM_COPY 769
#define WM_PASTE 770
#define WM_CLEAR 771
#define WM_UNDO 772
#define WM_RENDERFORMAT 773
#define WM_RENDERALLFORMATS 774
#define WM_DESTROYCLIPBOARD 775
#define WM_DRAWCLIPBOARD 776
#define WM_PAINTCLIPBOARD 777
#define WM_VSCROLLCLIPBOARD 778
#define WM_SIZECLIPBOARD 779
#define WM_ASKCBFORMATNAME 780
#define WM_CHANGECBCHAIN 781
#define WM_HSCROLLCLIPBOARD 782
#define WM_PALETTEISCHANGING 784
#define WM_PALETTECHANGED 785
#define WM_QUERYNEWPALETTE 783
#define WM_HOTKEY 786
#define WM_PRINT 791
#define WM_PRINTCLIENT 792
#define WM_APPCOMMAND 793

#define WM_DWMCOMPOSITIONCHANGED 0x031E
#define WM_DWMNCRENDERINGCHANGED 0x031F
#define WM_DWMCOLORIZATIONCOLORCHANGED 0x0320
#define WM_DWMWINDOWMAXIMIZEDCHANGE 0x0321

#define WM_HANDHELDFIRST 856
#define WM_HANDHELDLAST 863
#define WM_AFXFIRST 864
#define WM_AFXLAST 895
#define WM_PENWINFIRST 896
#define WM_PENWINLAST 911
#define WM_USER 1024
#define WM_APP 32768
#define WM_GETTITLEBARINFOEX 0x033F

#if (_WIN32_WINNT >= 0x0400)
#define WHEEL_DELTA 120
#define GET_WHEEL_DELTA_WPARAM(wParam)  ((short)HIWORD(wParam))
#define WHEEL_PAGESCROLL UINT_MAX
#endif

#if (_WIN32_WINNT >= 0x0500)
#define GET_KEYSTATE_WPARAM(wParam)     (LOWORD(wParam))
#define GET_NCHITTEST_WPARAM(wParam)    ((short)LOWORD(wParam))
#define GET_XBUTTON_WPARAM(wParam)      (HIWORD(wParam))
#define XBUTTON1    0x0001
#define XBUTTON2    0x0002
#endif

#if (_WIN32_WINNT >= 0x0501)
#define WM_THEMECHANGED 794
#endif

#define BM_CLICK 245
#define BM_GETCHECK 240
#define BM_GETIMAGE 246
#define BM_GETSTATE 242
#define BM_SETCHECK 241
#define BM_SETIMAGE 247
#define BM_SETSTATE 243
#define BM_SETSTYLE 244
#define BN_CLICKED 0
#define BN_DBLCLK 5
#define BN_DISABLE 4
#define BN_DOUBLECLICKED 5
#define BN_HILITE 2
#define BN_KILLFOCUS 7
#define BN_PAINT 1
#define BN_PUSHED 2
#define BN_SETFOCUS 6
#define BN_UNHILITE 3
#define BN_UNPUSHED 3
#define CB_ADDSTRING 323
#define CB_DELETESTRING 324
#define CB_DIR 325
#define CB_FINDSTRING 332
#define CB_FINDSTRINGEXACT 344
#define CB_GETCOMBOBOXINFO 356
#define CB_GETCOUNT 326
#define CB_GETCURSEL 327
#define CB_GETDROPPEDCONTROLRECT 338
#define CB_GETDROPPEDSTATE 343
#define CB_GETDROPPEDWIDTH 351
#define CB_GETEDITSEL 320
#define CB_GETEXTENDEDUI 342
#define CB_GETHORIZONTALEXTENT 349
#define CB_GETITEMDATA 336
#define CB_GETITEMHEIGHT 340
#define CB_GETLBTEXT 328
#define CB_GETLBTEXTLEN 329
#define CB_GETLOCALE 346
#define CB_GETTOPINDEX 347
#define CB_INITSTORAGE 353
#define CB_INSERTSTRING 330
#define CB_LIMITTEXT 321
#define CB_RESETCONTENT 331
#define CB_SELECTSTRING 333
#define CB_SETCURSEL 334
#define CB_SETDROPPEDWIDTH 352
#define CB_SETEDITSEL 322
#define CB_SETEXTENDEDUI 341
#define CB_SETHORIZONTALEXTENT 350
#define CB_SETITEMDATA 337
#define CB_SETITEMHEIGHT 339
#define CB_SETLOCALE 345
#define CB_SETTOPINDEX 348
#define CB_SHOWDROPDOWN 335
#define CB_MSGMAX 357
#define CBN_CLOSEUP 8
#define CBN_DBLCLK 2
#define CBN_DROPDOWN 7
#define CBN_EDITCHANGE 5
#define CBN_EDITUPDATE 6
#define CBN_ERRSPACE (-1)
#define CBN_KILLFOCUS 4
#define CBN_SELCHANGE 1
#define CBN_SELENDCANCEL 10
#define CBN_SELENDOK 9
#define CBN_SETFOCUS 3
#define EM_CANUNDO 198
#define EM_CHARFROMPOS 215
#define EM_EMPTYUNDOBUFFER 205
#define EM_FMTLINES 200
#define EM_GETIMESTATUS 217
#define EM_GETFIRSTVISIBLELINE 206
#define EM_GETHANDLE 189
#define EM_GETLIMITTEXT 213
#define EM_GETLINE 196
#define EM_GETLINECOUNT 186
#define EM_GETMARGINS 212
#define EM_GETMODIFY 184
#define EM_GETPASSWORDCHAR 210
#define EM_GETRECT 178
#define EM_GETSEL 176
#define EM_GETTHUMB 190
#define EM_GETWORDBREAKPROC 209
#define EM_LIMITTEXT 197
#define EM_LINEFROMCHAR 201
#define EM_LINEINDEX 187
#define EM_LINELENGTH 193
#define EM_LINESCROLL 182
#define EM_POSFROMCHAR 214
#define EM_REPLACESEL 194
#define EM_SCROLL 181
#define EM_SCROLLCARET 183
#define EM_SETHANDLE 188
#define EM_SETIMESTATUS 216
#define EM_SETLIMITTEXT 197
#define EM_SETMARGINS 211
#define EM_SETMODIFY 185
#define EM_SETPASSWORDCHAR 204
#define EM_SETREADONLY 207
#define EM_SETRECT 179
#define EM_SETRECTNP 180
#define EM_SETSEL 177
#define EM_SETTABSTOPS 203
#define EM_SETWORDBREAKPROC 208
#define EM_UNDO 199
#define EN_CHANGE 768
#define EN_ERRSPACE 1280
#define EN_HSCROLL 1537
#define EN_KILLFOCUS 512
#define EN_MAXTEXT 1281
#define EN_SETFOCUS 256
#define EN_UPDATE 1024
#define EN_VSCROLL 1538
#define LB_ADDFILE 406
#define LB_ADDSTRING 384
#define LB_DELETESTRING 386
#define LB_DIR 397
#define LB_FINDSTRING 399
#define LB_FINDSTRINGEXACT 418
#define LB_GETANCHORINDEX 413
#define LB_GETCARETINDEX 415
#define LB_GETCOUNT 395
#define LB_GETCURSEL 392
#define LB_GETHORIZONTALEXTENT 403
#define LB_GETITEMDATA 409
#define LB_GETITEMHEIGHT 417
#define LB_GETITEMRECT 408
#define LB_GETLISTBOXINFO 434
#define LB_GETLOCALE 422
#define LB_GETSEL 391
#define LB_GETSELCOUNT 400
#define LB_GETSELITEMS 401
#define LB_GETTEXT 393
#define LB_GETTEXTLEN 394
#define LB_GETTOPINDEX 398
#define LB_INITSTORAGE 424
#define LB_INSERTSTRING 385
#define LB_ITEMFROMPOINT 425
#define LB_RESETCONTENT 388
#define LB_SELECTSTRING 396
#define LB_SELITEMRANGE 411
#define LB_SELITEMRANGEEX 387
#define LB_SETANCHORINDEX 412
#define LB_SETCARETINDEX 414
#define LB_SETCOLUMNWIDTH 405
#define LB_SETCOUNT 423
#define LB_SETCURSEL 390
#define LB_SETHORIZONTALEXTENT 404
#define LB_SETITEMDATA 410
#define LB_SETITEMHEIGHT 416
#define LB_SETLOCALE 421
#define LB_SETSEL 389
#define LB_SETTABSTOPS 402
#define LB_SETTOPINDEX 407
#define LBN_DBLCLK 2
#define LBN_ERRSPACE (-2)
#define LBN_KILLFOCUS 5
#define LBN_SELCANCEL 3
#define LBN_SELCHANGE 1
#define LBN_SETFOCUS 4
#define SBM_ENABLE_ARROWS 228
#define SBM_GETPOS 225
#define SBM_GETRANGE 227
#define SBM_SETPOS 224
#define SBM_SETRANGE 226
#define SBM_SETRANGEREDRAW 230
#if (_WIN32_WINNT >= 0x0400)
#define SBM_GETSCROLLINFO 234
#define SBM_SETSCROLLINFO 233
#endif
#if (_WIN32_WINNT >= 0x0501)
#define SBM_GETSCROLLBARINFO 235
#endif
#define STM_GETICON 369
#define STM_GETIMAGE 371
#define STM_SETICON 368
#define STM_SETIMAGE 370
#define STN_CLICKED 0
#define STN_DBLCLK 1
#define STN_DISABLE 3
#define STN_ENABLE 2
#define DM_GETDEFID WM_USER
#define DM_SETDEFID (WM_USER+1)
#define DM_REPOSITION (WM_USER+2)
#define PSM_PAGEINFO (WM_USER+100)
#define PSM_SHEETINFO (WM_USER+101)
#define PSI_SETACTIVE 1
#define PSI_KILLACTIVE 2
#define PSI_APPLY 3
#define PSI_RESET 4
#define PSI_HASHELP 5
#define PSI_HELP 6
#define PSI_CHANGED 1
#define PSI_GUISTART 2
#define PSI_REBOOT 3
#define PSI_GETSIBLINGS 4
#define DCX_WINDOW 1
#define DCX_CACHE 2
#define DCX_PARENTCLIP 32
#define DCX_CLIPSIBLINGS 16
#define DCX_CLIPCHILDREN 8
#define DCX_NORESETATTRS 4
#define DCX_INTERSECTUPDATE 0x200
#define DCX_LOCKWINDOWUPDATE 0x400
#define DCX_EXCLUDERGN 64
#define DCX_INTERSECTRGN 128
#define DCX_VALIDATE 0x200000
#define DCX_EXCLUDEUPDATE   0x100
#define GMDI_GOINTOPOPUPS 2
#define GMDI_USEDISABLED 1
#define FKF_AVAILABLE 2
#define FKF_CLICKON 64
#define FKF_FILTERKEYSON 1
#define FKF_HOTKEYACTIVE 4
#define FKF_HOTKEYSOUND 16
#define FKF_CONFIRMHOTKEY 8
#define FKF_INDICATOR 32
#define HCF_HIGHCONTRASTON 1
#define HCF_AVAILABLE 2
#define HCF_HOTKEYACTIVE 4
#define HCF_CONFIRMHOTKEY 8
#define HCF_HOTKEYSOUND 16
#define HCF_INDICATOR 32
#define HCF_HOTKEYAVAILABLE 64

#define MKF_MOUSEKEYSON     0x00000001
#define MKF_AVAILABLE       0x00000002
#define MKF_HOTKEYACTIVE    0x00000004
#define MKF_CONFIRMHOTKEY   0x00000008
#define MKF_HOTKEYSOUND     0x00000010
#define MKF_INDICATOR       0x00000020
#define MKF_MODIFIERS       0x00000040
#define MKF_REPLACENUMBERS  0x00000080
#define MKF_LEFTBUTTONDOWN  0x01000000
#define MKF_RIGHTBUTTONDOWN 0x02000000
#define MKF_LEFTBUTTONSEL   0x10000000
#define MKF_RIGHTBUTTONSEL  0x20000000
#define MKF_MOUSEMODE       0x80000000

#define SERKF_ACTIVE 8 /* May be obsolete. Not in recent MS docs. */
#define SERKF_AVAILABLE 2
#define SERKF_INDICATOR 4
#define SERKF_SERIALKEYSON 1
#define SSF_AVAILABLE 2
#define SSF_SOUNDSENTRYON 1
#define SSTF_BORDER 2
#define SSTF_CHARS 1
#define SSTF_DISPLAY 3
#define SSTF_NONE 0
#define SSGF_DISPLAY 3
#define SSGF_NONE 0
#define SSWF_CUSTOM 4
#define SSWF_DISPLAY 3
#define SSWF_NONE 0
#define SSWF_TITLE 1
#define SSWF_WINDOW 2
#define SKF_AUDIBLEFEEDBACK 64
#define SKF_AVAILABLE 2
#define SKF_CONFIRMHOTKEY 8
#define SKF_HOTKEYACTIVE 4
#define SKF_HOTKEYSOUND 16
#define SKF_INDICATOR 32
#define SKF_STICKYKEYSON 1
#define SKF_TRISTATE 128
#define SKF_TWOKEYSOFF 256
#define TKF_AVAILABLE 2
#define TKF_CONFIRMHOTKEY 8
#define TKF_HOTKEYACTIVE 4
#define TKF_HOTKEYSOUND 16
#define TKF_TOGGLEKEYSON 1
#define MDITILE_SKIPDISABLED 2
#define MDITILE_HORIZONTAL 1
#define MDITILE_VERTICAL 0
#define VK_LBUTTON	1
#define VK_RBUTTON	2
#define VK_CANCEL	3
#define VK_MBUTTON	4
#if (_WIN32_WINNT >= 0x0500)
#define VK_XBUTTON1	5
#define VK_XBUTTON2	6
#endif
#define VK_BACK	8
#define VK_TAB	9
#define VK_CLEAR	12
#define VK_RETURN	13
#define VK_SHIFT	16
#define VK_CONTROL	17
#define VK_MENU	18
#define VK_PAUSE	19
#define VK_CAPITAL	20
#define VK_KANA	0x15
#define VK_HANGEUL	0x15
#define VK_HANGUL	0x15
#define VK_JUNJA	0x17
#define VK_FINAL	0x18
#define VK_HANJA	0x19
#define VK_KANJI	0x19
#define VK_ESCAPE	0x1B
#define VK_CONVERT	0x1C
#define VK_NONCONVERT	0x1D
#define VK_ACCEPT	0x1E
#define VK_MODECHANGE	0x1F
#define VK_SPACE	32
#define VK_PRIOR	33
#define VK_NEXT	34
#define VK_END	35
#define VK_HOME	36
#define VK_LEFT	37
#define VK_UP	38
#define VK_RIGHT	39
#define VK_DOWN	40
#define VK_SELECT	41
#define VK_PRINT	42
#define VK_EXECUTE	43
#define VK_SNAPSHOT	44
#define VK_INSERT	45
#define VK_DELETE	46
#define VK_HELP	47
#define VK_LWIN	0x5B
#define VK_RWIN	0x5C
#define VK_APPS	0x5D
#define VK_SLEEP	0x5F
#define VK_NUMPAD0	0x60
#define VK_NUMPAD1	0x61
#define VK_NUMPAD2	0x62
#define VK_NUMPAD3	0x63
#define VK_NUMPAD4	0x64
#define VK_NUMPAD5	0x65
#define VK_NUMPAD6	0x66
#define VK_NUMPAD7	0x67
#define VK_NUMPAD8	0x68
#define VK_NUMPAD9	0x69
#define VK_MULTIPLY	0x6A
#define VK_ADD	0x6B
#define VK_SEPARATOR	0x6C
#define VK_SUBTRACT	0x6D
#define VK_DECIMAL	0x6E
#define VK_DIVIDE	0x6F
#define VK_F1	0x70
#define VK_F2	0x71
#define VK_F3	0x72
#define VK_F4	0x73
#define VK_F5	0x74
#define VK_F6	0x75
#define VK_F7	0x76
#define VK_F8	0x77
#define VK_F9	0x78
#define VK_F10	0x79
#define VK_F11	0x7A
#define VK_F12	0x7B
#define VK_F13	0x7C
#define VK_F14	0x7D
#define VK_F15	0x7E
#define VK_F16	0x7F
#define VK_F17	0x80
#define VK_F18	0x81
#define VK_F19	0x82
#define VK_F20	0x83
#define VK_F21	0x84
#define VK_F22	0x85
#define VK_F23	0x86
#define VK_F24	0x87
#define VK_NUMLOCK	0x90
#define VK_SCROLL	0x91
#define VK_OEM_NEC_EQUAL	0x92
#define VK_LSHIFT	0xA0
#define VK_RSHIFT	0xA1
#define VK_LCONTROL	0xA2
#define VK_RCONTROL	0xA3
#define VK_LMENU	0xA4
#define VK_RMENU	0xA5
#if (_WIN32_WINNT >= 0x0500)
#define VK_BROWSER_BACK	0xA6
#define VK_BROWSER_FORWARD	0xA7
#define VK_BROWSER_REFRESH	0xA8
#define VK_BROWSER_STOP	0xA9
#define VK_BROWSER_SEARCH	0xAA
#define VK_BROWSER_FAVORITES	0xAB
#define VK_BROWSER_HOME	0xAC
#define VK_VOLUME_MUTE	0xAD
#define VK_VOLUME_DOWN	0xAE
#define VK_VOLUME_UP	0xAF
#define VK_MEDIA_NEXT_TRACK	0xB0
#define VK_MEDIA_PREV_TRACK	0xB1
#define VK_MEDIA_STOP	0xB2
#define VK_MEDIA_PLAY_PAUSE	0xB3
#define VK_LAUNCH_MAIL	0xB4
#define VK_LAUNCH_MEDIA_SELECT	0xB5
#define VK_LAUNCH_APP1	0xB6
#define VK_LAUNCH_APP2	0xB7
#endif
#define VK_OEM_1	0xBA
#if (_WIN32_WINNT >= 0x0500)
#define VK_OEM_PLUS	0xBB
#define VK_OEM_COMMA	0xBC
#define VK_OEM_MINUS	0xBD
#define VK_OEM_PERIOD	0xBE
#endif
#define VK_OEM_2	0xBF
#define VK_OEM_3	0xC0
#define VK_OEM_4	0xDB
#define VK_OEM_5	0xDC
#define VK_OEM_6	0xDD
#define VK_OEM_7	0xDE
#define VK_OEM_8	0xDF
#if (_WIN32_WINNT >= 0x0500)
#define VK_OEM_102	0xE2
#endif
#define VK_ICO_HELP	0xE3  /* Help key on ICO */
#define VK_ICO_00	0xE4  /* 00 key on ICO */
#define VK_PROCESSKEY	0xE5
#if (_WIN32_WINNT >= 0x0500)
#define VK_PACKET	0xE7
#endif
#define VK_OEM_RESET	0xE9
#define VK_OEM_JUMP	0xEA
#define VK_OEM_PA1	0xEB
#define VK_OEM_PA2	0xEC
#define VK_OEM_PA3	0xED
#define VK_OEM_WSCTRL	0xEE
#define VK_OEM_CUSEL	0xEF
#define VK_OEM_ATTN	0xF0
#define VK_OEM_FINISH	0xF1
#define VK_OEM_COPY	0xF2
#define VK_OEM_AUTO	0xF3
#define VK_OEM_ENLW	0xF4
#define VK_OEM_BACKTAB	0xF5
#define VK_ATTN	0xF6
#define VK_CRSEL	0xF7
#define VK_EXSEL	0xF8
#define VK_EREOF	0xF9
#define VK_PLAY	0xFA
#define VK_ZOOM	0xFB
#define VK_NONAME	0xFC
#define VK_PA1	0xFD
#define VK_OEM_CLEAR	0xFE

/* MapVirtualKey translation types */
#define MAPVK_VK_TO_VSC     0
#define MAPVK_VSC_TO_VK     1
#define MAPVK_VK_TO_CHAR    2
#define MAPVK_VSC_TO_VK_EX  3
#define MAPVK_VK_TO_VSC_EX  4

#define TME_HOVER	1
#define TME_LEAVE	2
#define TME_NONCLIENT   0x00000010
#define TME_QUERY	0x40000000
#define TME_CANCEL	0x80000000
#define HOVER_DEFAULT	0xFFFFFFFF
#define MK_LBUTTON	1
#define MK_RBUTTON	2
#define MK_SHIFT	4
#define MK_CONTROL	8
#define MK_MBUTTON	16
#if(_WIN32_WINNT >= 0x0500)
#define MK_XBUTTON1	0x0020
#define MK_XBUTTON2	0x0040
#endif
#define TPM_CENTERALIGN 4
#define TPM_LEFTALIGN 0
#define TPM_RIGHTALIGN 8
#define TPM_LEFTBUTTON 0
#define TPM_RIGHTBUTTON 2
#define TPM_HORIZONTAL 0
#define TPM_VERTICAL 64
#define TPM_TOPALIGN 0
#define TPM_VCENTERALIGN 16
#define TPM_BOTTOMALIGN 32
#define TPM_NONOTIFY 128
#define TPM_RETURNCMD 256
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
#define TPM_RECURSE 0x0001
#define TPM_HORPOSANIMATION 0x0400
#define TPM_HORNEGANIMATION 0x0800
#define TPM_VERPOSANIMATION 0x1000
#define TPM_VERNEGANIMATION 0x2000
#endif
#if(_WIN32_WINNT >= 0x0500)
#define TPM_NOANIMATION 16384
#endif
#if (_WIN32_WINNT >= 0x0501)
#define TPM_LAYOUTRTL 32768
#endif
#if (_WIN32_WINNT >= 0x0601)
#define TPM_WORKAREA 65536
#endif
#define HELP_COMMAND 0x102
#define HELP_CONTENTS 3
#define HELP_CONTEXT 1
#define HELP_CONTEXTPOPUP 8
#define HELP_FORCEFILE 9
#define HELP_HELPONHELP 4
#define HELP_INDEX 3
#define HELP_KEY 0x101
#define HELP_MULTIKEY 0x201
#define HELP_PARTIALKEY 0x105
#define HELP_QUIT 2
#define HELP_SETCONTENTS 5
#define HELP_SETINDEX 5
#define HELP_SETWINPOS 0x203
#define HELP_CONTEXTMENU 0xa
#define HELP_FINDER 0xb
#define HELP_WM_HELP 0xc
#define HELP_TCARD 0x8000
#define HELP_TCARD_DATA 16
#define HELP_TCARD_OTHER_CALLER 0x11
#define IDH_NO_HELP	28440
#define IDH_MISSING_CONTEXT	28441
#define IDH_GENERIC_HELP_BUTTON	28442
#define IDH_OK	28443
#define IDH_CANCEL	28444
#define IDH_HELP	28445
#define LB_CTLCODE 0
#define LB_OKAY 0
#define LB_ERR (-1)
#define LB_ERRSPACE (-2)
#define CB_OKAY 0
#define CB_ERR (-1)
#define CB_ERRSPACE (-2)
#define HIDE_WINDOW 0
#define SHOW_OPENWINDOW 1
#define SHOW_ICONWINDOW 2
#define SHOW_FULLSCREEN 3
#define SHOW_OPENNOACTIVATE 4
#define SW_PARENTCLOSING 1
#define SW_OTHERZOOM 2
#define SW_PARENTOPENING 3
#define SW_OTHERUNZOOM 4
#define KF_EXTENDED 256
#define KF_DLGMODE 2048
#define KF_MENUMODE 4096
#define KF_ALTDOWN 8192
#define KF_REPEAT 16384
#define KF_UP 32768
#define WSF_VISIBLE 1
#define PWR_OK 1
#define PWR_FAIL (-1)
#define PWR_SUSPENDREQUEST 1
#define PWR_SUSPENDRESUME 2
#define PWR_CRITICALRESUME 3
#define NFR_ANSI 1
#define NFR_UNICODE 2
#define NF_QUERY 3
#define NF_REQUERY 4
#define MENULOOP_WINDOW 0
#define MENULOOP_POPUP 1
#define WMSZ_LEFT 1
#define WMSZ_RIGHT 2
#define WMSZ_TOP 3
#define WMSZ_TOPLEFT 4
#define WMSZ_TOPRIGHT 5
#define WMSZ_BOTTOM 6
#define WMSZ_BOTTOMLEFT 7
#define WMSZ_BOTTOMRIGHT 8
#define HTERROR (-2)
#define HTTRANSPARENT (-1)
#define HTNOWHERE 0
#define HTCLIENT 1
#define HTCAPTION 2
#define HTSYSMENU 3
#define HTGROWBOX 4
#define HTSIZE 4
#define HTMENU 5
#define HTHSCROLL 6
#define HTVSCROLL 7
#define HTMINBUTTON 8
#define HTMAXBUTTON 9
#define HTREDUCE 8
#define HTZOOM 9
#define HTLEFT 10
#define HTSIZEFIRST 10
#define HTRIGHT 11
#define HTTOP 12
#define HTTOPLEFT 13
#define HTTOPRIGHT 14
#define HTBOTTOM 15
#define HTBOTTOMLEFT 16
#define HTBOTTOMRIGHT 17
#define HTSIZELAST 17
#define HTBORDER 18
#define HTOBJECT 19
#define HTCLOSE 20
#define HTHELP 21
#define MA_ACTIVATE 1
#define MA_ACTIVATEANDEAT 2
#define MA_NOACTIVATE 3
#define MA_NOACTIVATEANDEAT 4
#define SIZE_RESTORED 0
#define SIZE_MINIMIZED 1
#define SIZE_MAXIMIZED 2
#define SIZE_MAXSHOW 3
#define SIZE_MAXHIDE 4
#define SIZENORMAL 0
#define SIZEICONIC 1
#define SIZEFULLSCREEN 2
#define SIZEZOOMSHOW 3
#define SIZEZOOMHIDE 4
#define WVR_ALIGNTOP 16
#define WVR_ALIGNLEFT 32
#define WVR_ALIGNBOTTOM 64
#define WVR_ALIGNRIGHT 128
#define WVR_HREDRAW 256
#define WVR_VREDRAW 512
#define WVR_REDRAW (WVR_HREDRAW|WVR_VREDRAW)
#define WVR_VALIDRECTS 1024
#define PRF_CHECKVISIBLE 1
#define PRF_NONCLIENT 2
#define PRF_CLIENT 4
#define PRF_ERASEBKGND 8
#define PRF_CHILDREN 16
#define PRF_OWNED 32
#define IDANI_OPEN 1
#define IDANI_CLOSE 2
#define IDANI_CAPTION 3
#define WPF_RESTORETOMAXIMIZED 2
#define WPF_SETMINPOSITION 1
#if(_WIN32_WINNT >= 0x0500)
#define WPF_ASYNCWINDOWPLACEMENT 4
#endif
#define ODT_MENU 1
#define ODT_LISTBOX 2
#define ODT_COMBOBOX 3
#define ODT_BUTTON 4
#define ODT_STATIC 5
#define ODA_DRAWENTIRE 1
#define ODA_SELECT 2
#define ODA_FOCUS 4
#define ODS_SELECTED 1
#define ODS_GRAYED 2
#define ODS_DISABLED 4
#define ODS_CHECKED 8
#define ODS_FOCUS 16
#if(WINVER >= 0x0400)
#define ODS_DEFAULT 32
#define ODS_COMBOBOXEDIT 4096
#endif
#if(WINVER >= 0x0500)
#define ODS_HOTLIGHT        0x0040
#define ODS_INACTIVE        0x0080
#if(_WIN32_WINNT >= 0x0500)
#define ODS_NOACCEL         0x0100
#define ODS_NOFOCUSRECT     0x0200
#endif
#endif
#define IDHOT_SNAPWINDOW (-1)
#define IDHOT_SNAPDESKTOP (-2)
#define DBWF_LPARAMPOINTER 0x8000
#define DLGWINDOWEXTRA 30
#define MNC_IGNORE 0
#define MNC_CLOSE 1
#define MNC_EXECUTE 2
#define MNC_SELECT 3
#define DOF_EXECUTABLE 0x8001
#define DOF_DOCUMENT 0x8002
#define DOF_DIRECTORY 0x8003
#define DOF_MULTIPLE 0x8004
#define DOF_PROGMAN 1
#define DOF_SHELLDATA 2
#define DO_DROPFILE 0x454C4946
#define DO_PRINTFILE 0x544E5250
#define SW_SCROLLCHILDREN 1
#define SW_INVALIDATE 2
#define SW_ERASE 4
#if(WINVER >= 0x0500)
#define SW_SMOOTHSCROLL 16
#endif
#define SC_SIZE 0xF000
#define SC_MOVE 0xF010
#define SC_MINIMIZE 0xF020
#define SC_ICON 0xf020
#define SC_MAXIMIZE 0xF030
#define SC_ZOOM 0xF030
#define SC_NEXTWINDOW 0xF040
#define SC_PREVWINDOW 0xF050
#define SC_CLOSE 0xF060
#define SC_VSCROLL 0xF070
#define SC_HSCROLL 0xF080
#define SC_MOUSEMENU 0xF090
#define SC_KEYMENU 0xF100
#define SC_ARRANGE 0xF110
#define SC_RESTORE 0xF120
#define SC_TASKLIST 0xF130
#define SC_SCREENSAVE 0xF140
#define SC_HOTKEY 0xF150
#define SC_DEFAULT 0xF160
#define SC_MONITORPOWER 0xF170
#define SC_CONTEXTHELP 0xF180
#define SC_SEPARATOR 0xF00F
#define EC_LEFTMARGIN 1
#define EC_RIGHTMARGIN 2
#define EC_USEFONTINFO 0xffff
#define DC_HASDEFID 0x534B
#define DLGC_WANTARROWS 1
#define DLGC_WANTTAB 2
#define DLGC_WANTALLKEYS 4
#define DLGC_WANTMESSAGE 4
#define DLGC_HASSETSEL 8
#define DLGC_DEFPUSHBUTTON 16
#define DLGC_UNDEFPUSHBUTTON 32
#define DLGC_RADIOBUTTON 64
#define DLGC_WANTCHARS 128
#define DLGC_STATIC 256
#define DLGC_BUTTON 0x2000
#define LB_CTLCODE 0
#define WA_INACTIVE 0
#define WA_ACTIVE 1
#define WA_CLICKACTIVE 2
#define ICON_SMALL 0
#define ICON_BIG 1
#if (_WIN32_WINNT >= 0x0501)
#define ICON_SMALL2 2
#endif
#define HBMMENU_CALLBACK ((HBITMAP) -1)
#define HBMMENU_SYSTEM ((HBITMAP)1)
#define HBMMENU_MBAR_RESTORE ((HBITMAP)2)
#define HBMMENU_MBAR_MINIMIZE ((HBITMAP)3)
#define HBMMENU_MBAR_CLOSE ((HBITMAP)5)
#define HBMMENU_MBAR_CLOSE_D ((HBITMAP)6)
#define HBMMENU_MBAR_MINIMIZE_D ((HBITMAP)7)
#define HBMMENU_POPUP_CLOSE ((HBITMAP)8)
#define HBMMENU_POPUP_RESTORE ((HBITMAP)9)
#define HBMMENU_POPUP_MAXIMIZE ((HBITMAP)10)
#define HBMMENU_POPUP_MINIMIZE ((HBITMAP)11)
#define MOD_ALT         0x0001
#define MOD_CONTROL     0x0002
#define MOD_SHIFT       0x0004
#define MOD_WIN         0x0008
#define LLKHF_EXTENDED 0x00000001
#define LLKHF_INJECTED 0x00000010
#define LLKHF_ALTDOWN  0x00000020
#define LLKHF_UP  0x00000080
#define LLMHF_INJECTED  0x00000001
#if (WINVER >= 0x0500)
#define FLASHW_STOP 0
#define FLASHW_CAPTION 1
#define FLASHW_TRAY 2
#define FLASHW_ALL (FLASHW_CAPTION|FLASHW_TRAY)
#define FLASHW_TIMER 4
#define FLASHW_TIMERNOFG 12
#endif /* (WINVER >= 0x0500) */
#define CURSOR_SHOWING 0x00000001
#define WS_ACTIVECAPTION 0x00000001
#if (_WIN32_WINNT >= 0x0400)
#define INPUT_MOUSE 0
#define INPUT_KEYBOARD 1
#define INPUT_HARDWARE 2
#endif /* (_WIN32_WINNT >= 0x0400) */
#if (WINVER >= 0x0400)
#define ENDSESSION_LOGOFF 0x80000000
#define ENDSESSION_CRITICAL 0x40000000
#define ENDSESSION_CLOSEAPP 0x00000001
#endif
#if (WINVER >= 0x0500)
#define CHILDID_SELF 0
#define OBJID_WINDOW 0x00000000
#define OBJID_SYSMENU 0xFFFFFFFF
#define OBJID_TITLEBAR 0xFFFFFFFE
#define OBJID_MENU 0xFFFFFFFD
#define OBJID_CLIENT 0xFFFFFFFC
#define OBJID_VSCROLL 0xFFFFFFFB
#define OBJID_HSCROLL 0xFFFFFFFA
#define OBJID_SIZEGRIP 0xFFFFFFF9
#define OBJID_CARET 0xFFFFFFF8
#define OBJID_CURSOR 0xFFFFFFF7
#define OBJID_ALERT 0xFFFFFFF6
#define OBJID_SOUND 0xFFFFFFF5
#define OBJID_QUERYCLASSNAMEIDX 0xFFFFFFF4
#define OBJID_NATIVEOM 0xFFFFFF0
#define GUI_CARETBLINKING 0x00000001
#define GUI_INMOVESIZE 0x00000002
#define GUI_INMENUMODE 0x00000004
#define GUI_SYSTEMMENUMODE 0x00000008
#define GUI_POPUPMENUMODE 0x00000010
#if (_WIN32_WINNT >= 0x0501)
#define GUI_16BITTASK 0x00000020
#endif
#define WINEVENT_OUTOFCONTEXT   0x0000
#define WINEVENT_SKIPOWNTHREAD  0x0001
#define WINEVENT_SKIPOWNPROCESS 0x0002
#define WINEVENT_INCONTEXT      0x0004
#define AW_HOR_POSITIVE 0x00000001
#define AW_HOR_NEGATIVE 0x00000002
#define AW_VER_POSITIVE 0x00000004
#define AW_VER_NEGATIVE 0x00000008
#define AW_CENTER 0x00000010
#define AW_HIDE 0x00010000
#define AW_ACTIVATE 0x00020000
#define AW_SLIDE 0x00040000
#define AW_BLEND 0x00080000
#define DEVICE_NOTIFY_WINDOW_HANDLE 0x00000000
#define DEVICE_NOTIFY_SERVICE_HANDLE 0x00000001
#if (_WIN32_WINNT >= 0x0501)
#define DEVICE_NOTIFY_ALL_INTERFACE_CLASSES 0x00000004
#endif
#define EVENT_MIN                       0x00000001
#define EVENT_SYSTEM_SOUND              0x00000001
#define EVENT_SYSTEM_ALERT              0x00000002
#define EVENT_SYSTEM_FOREGROUND         0x00000003
#define EVENT_SYSTEM_MENUSTART          0x00000004
#define EVENT_SYSTEM_MENUEND            0x00000005
#define EVENT_SYSTEM_MENUPOPUPSTART     0x00000006
#define EVENT_SYSTEM_MENUPOPUPEND       0x00000007
#define EVENT_SYSTEM_CAPTURESTART       0x00000008
#define EVENT_SYSTEM_CAPTUREEND         0x00000009
#define EVENT_SYSTEM_MOVESIZESTART      0x0000000a
#define EVENT_SYSTEM_MOVESIZEEND        0x0000000b
#define EVENT_SYSTEM_CONTEXTHELPSTART   0x0000000c
#define EVENT_SYSTEM_CONTEXTHELPEND     0x0000000d
#define EVENT_SYSTEM_DRAGDROPSTART      0x0000000e
#define EVENT_SYSTEM_DRAGDROPEND        0x0000000f
#define EVENT_SYSTEM_DIALOGSTART        0x00000010
#define EVENT_SYSTEM_DIALOGEND          0x00000011
#define EVENT_SYSTEM_SCROLLINGSTART     0x00000012
#define EVENT_SYSTEM_SCROLLINGEND       0x00000013
#define EVENT_SYSTEM_SWITCHSTART        0x00000014
#define EVENT_SYSTEM_SWITCHEND          0x00000015
#define EVENT_SYSTEM_MINIMIZESTART      0x00000016
#define EVENT_SYSTEM_MINIMIZEEND        0x00000017
#define EVENT_OBJECT_CREATE             0x00008000
#define EVENT_OBJECT_DESTROY            0x00008001
#define EVENT_OBJECT_SHOW               0x00008002
#define EVENT_OBJECT_HIDE               0x00008003
#define EVENT_OBJECT_REORDER            0x00008004
#define EVENT_OBJECT_FOCUS              0x00008005
#define EVENT_OBJECT_SELECTION          0x00008006
#define EVENT_OBJECT_SELECTIONADD       0x00008007
#define EVENT_OBJECT_SELECTIONREMOVE    0x00008008
#define EVENT_OBJECT_SELECTIONWITHIN    0x00008009
#define EVENT_OBJECT_STATECHANGE        0x0000800a
#define EVENT_OBJECT_LOCATIONCHANGE     0x0000800b
#define EVENT_OBJECT_NAMECHANGE         0x0000800c
#define EVENT_OBJECT_DESCRIPTIONCHANGE  0x0000800d
#define EVENT_OBJECT_VALUECHANGE        0x0000800e
#define EVENT_OBJECT_PARENTCHANGE       0x0000800f
#define EVENT_OBJECT_HELPCHANGE         0x00008010
#define EVENT_OBJECT_DEFACTIONCHANGE    0x00008011
#define EVENT_OBJECT_ACCELERATORCHANGE  0x00008012
#define ALERT_SYSTEM_INFORMATIONAL      1          /* MB_INFORMATION */
#define ALERT_SYSTEM_WARNING            2          /* MB_WARNING */
#define ALERT_SYSTEM_ERROR              3          /* MB_ERROR */
#define ALERT_SYSTEM_QUERY              4          /* MB_QUESTION */
#define ALERT_SYSTEM_CRITICAL           5          /* HardSysErrBox */
#define CALERT_SYSTEM                   6
#if (_WIN32_WINNT >= 0x0501)
#define EVENT_CONSOLE_CARET             0x00004001
#define CONSOLE_CARET_SELECTION         0x00000001
#define CONSOLE_CARET_VISIBLE           0x00000002
#define EVENT_CONSOLE_UPDATE_REGION     0x00004002
#define EVENT_CONSOLE_UPDATE_SIMPLE     0x00004003
#define EVENT_CONSOLE_UPDATE_SCROLL     0x00004004
#define EVENT_CONSOLE_LAYOUT            0x00004005
#define EVENT_CONSOLE_START_APPLICATION 0x00004006
#define CONSOLE_APPLICATION_16BIT       0x00000001
#define EVENT_CONSOLE_END_APPLICATION   0x00004007
#endif /* (_WIN32_WINNT >= 0x0501) */
#define EVENT_MAX                       0x7fffffff
#endif /* (WINVER >= 0x0500) */
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0490)
#define ASFW_ANY ((DWORD)-1)
#define LSFW_LOCK 1
#define LSFW_UNLOCK 2
#endif
#if (_WIN32_WINNT >= 0x0500)
#define LWA_COLORKEY 1
#define LWA_ALPHA 2
#endif
#define ULW_COLORKEY        0x00000001
#define ULW_ALPHA           0x00000002
#define ULW_OPAQUE          0x00000004
#define ULW_EX_NORESIZE     0x00000008
#define GA_PARENT 1
#define GA_ROOT 2
#define GA_ROOTOWNER 3
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
#define MONITOR_DEFAULTTONULL 0
#define MONITOR_DEFAULTTOPRIMARY 1
#define MONITOR_DEFAULTTONEAREST 2
#define MONITORINFOF_PRIMARY 1
#define EDD_GET_DEVICE_INTERFACE_NAME 0x00000001
#define EDS_RAWMODE 0x00000002
#define EDS_ROTATEDMODE 0x00000004
#define ISMEX_NOSEND 0x00000000
#define ISMEX_CALLBACK 0x00000004
#define ISMEX_NOTIFY 0x00000002
#define ISMEX_REPLIED 0x00000008
#define ISMEX_SEND 0x00000001
#endif
#if (_WIN32_WINNT >= 0x0500)
#define GR_GDIOBJECTS 0
#define GR_USEROBJECTS 1
#endif
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0490)
#define GMMP_USE_DISPLAY_POINTS 1
#define GMMP_USE_HIGH_RESOLUTION_POINTS 2
#endif
#if (_WIN32_WINNT >= 0x0501)
#define PW_CLIENTONLY 0x00000001
#define RIM_INPUT     0x00000000
#define RIM_INPUTSINK 0x00000001
#define RIM_TYPEMOUSE    0x00000000
#define RIM_TYPEKEYBOARD 0x00000001
#define RIM_TYPEHID      0x00000002
#define MOUSE_MOVE_RELATIVE               0
#define MOUSE_MOVE_ABSOLUTE               1
#define MOUSE_VIRTUAL_DESKTOP             0x02
#define MOUSE_ATTRIBUTES_CHANGED          0x04
#define RI_MOUSE_LEFT_BUTTON_DOWN   0x0001
#define RI_MOUSE_LEFT_BUTTON_UP     0x0002
#define RI_MOUSE_RIGHT_BUTTON_DOWN  0x0004
#define RI_MOUSE_RIGHT_BUTTON_UP    0x0008
#define RI_MOUSE_MIDDLE_BUTTON_DOWN 0x0010
#define RI_MOUSE_MIDDLE_BUTTON_UP   0x0020
#define RI_MOUSE_BUTTON_1_DOWN      RI_MOUSE_LEFT_BUTTON_DOWN
#define RI_MOUSE_BUTTON_1_UP        RI_MOUSE_LEFT_BUTTON_UP
#define RI_MOUSE_BUTTON_2_DOWN      RI_MOUSE_RIGHT_BUTTON_DOWN
#define RI_MOUSE_BUTTON_2_UP        RI_MOUSE_RIGHT_BUTTON_UP
#define RI_MOUSE_BUTTON_3_DOWN      RI_MOUSE_MIDDLE_BUTTON_DOWN
#define RI_MOUSE_BUTTON_3_UP        RI_MOUSE_MIDDLE_BUTTON_UP
#define RI_MOUSE_BUTTON_4_DOWN      0x0040
#define RI_MOUSE_BUTTON_4_UP        0x0080
#define RI_MOUSE_BUTTON_5_DOWN      0x0100
#define RI_MOUSE_BUTTON_5_UP        0x0200
#define RI_MOUSE_WHEEL              0x0400
#define KEYBOARD_OVERRUN_MAKE_CODE 0xFF
#define RI_KEY_MAKE            0x0000
#define RI_KEY_BREAK           0x0001
#define RI_KEY_E0              0x0002
#define RI_KEY_E1              0x0004
#define RI_KEY_TERMSRV_SET_LED 0x0008
#define RI_KEY_TERMSRV_SHADOW  0x0010
#define RID_INPUT  0x10000003
#define RID_HEADER 0x10000005
#define RIDI_PREPARSEDDATA 0x20000005
#define RIDI_DEVICENAME    0x20000007
#define RIDI_DEVICEINFO    0x2000000b
#define RIDEV_REMOVE       0x00000001
#define RIDEV_EXCLUDE      0x00000010
#define RIDEV_PAGEONLY     0x00000020
#define RIDEV_NOLEGACY     0x00000030
#define RIDEV_INPUTSINK    0x00000100
#define RIDEV_CAPTUREMOUSE 0x00000200
#define RIDEV_NOHOTKEYS    0x00000200
#define RIDEV_APPKEYS      0x00000400
#endif
#define STATE_SYSTEM_UNAVAILABLE 0x00000001
#define STATE_SYSTEM_SELECTED 0x00000002
#define STATE_SYSTEM_FOCUSED 0x00000004
#define STATE_SYSTEM_PRESSED 0x00000008
#define STATE_SYSTEM_CHECKED 0x00000010
#define STATE_SYSTEM_MIXED 0x00000020
#define STATE_SYSTEM_READONLY 0x00000040
#define STATE_SYSTEM_HOTTRACKED 0x00000080
#define STATE_SYSTEM_DEFAULT 0x00000100
#define STATE_SYSTEM_EXPANDED 0x00000200
#define STATE_SYSTEM_COLLAPSED 0x00000400
#define STATE_SYSTEM_BUSY 0x00000800
#define STATE_SYSTEM_FLOATING 0x00001000
#define STATE_SYSTEM_MARQUEED 0x00002000
#define STATE_SYSTEM_ANIMATED 0x00004000
#define STATE_SYSTEM_INVISIBLE 0x00008000
#define STATE_SYSTEM_OFFSCREEN 0x00010000
#define STATE_SYSTEM_SIZEABLE 0x00020000
#define STATE_SYSTEM_MOVEABLE 0x00040000
#define STATE_SYSTEM_SELFVOICING 0x00080000
#define STATE_SYSTEM_FOCUSABLE 0x00100000
#define STATE_SYSTEM_SELECTABLE 0x00200000
#define STATE_SYSTEM_LINKED 0x00400000
#define STATE_SYSTEM_TRAVERSED 0x00800000
#define STATE_SYSTEM_MULTISELECTABLE 0x01000000
#define STATE_SYSTEM_EXTSELECTABLE 0x02000000
#define STATE_SYSTEM_ALERT_LOW 0x04000000
#define STATE_SYSTEM_ALERT_MEDIUM 0x08000000
#define STATE_SYSTEM_ALERT_HIGH 0x10000000
#define STATE_SYSTEM_VALID 0x1fffffff

#define USER_DEFAULT_SCREEN_DPI 96

#ifndef RC_INVOKED
typedef INT_PTR(CALLBACK *DLGPROC)(HWND,UINT,WPARAM,LPARAM);
typedef VOID(CALLBACK *TIMERPROC)(HWND,UINT,UINT_PTR,DWORD);
typedef BOOL(CALLBACK *GRAYSTRINGPROC)(HDC,LPARAM,int);
typedef LRESULT(CALLBACK *HOOKPROC)(int,WPARAM,LPARAM);
typedef BOOL(CALLBACK *PROPENUMPROCA)(HWND,LPCSTR,HANDLE);
typedef BOOL(CALLBACK *PROPENUMPROCW)(HWND,LPCWSTR,HANDLE);
typedef BOOL(CALLBACK *PROPENUMPROCEXA)(HWND,LPSTR,HANDLE,ULONG_PTR);
typedef BOOL(CALLBACK *PROPENUMPROCEXW)(HWND,LPWSTR,HANDLE,ULONG_PTR);
typedef int(CALLBACK *EDITWORDBREAKPROCA)(LPSTR,int,int,int);
typedef int(CALLBACK *EDITWORDBREAKPROCW)(LPWSTR,int,int,int);
typedef LRESULT(CALLBACK *WNDPROC)(HWND,UINT,WPARAM,LPARAM);
typedef BOOL(CALLBACK *DRAWSTATEPROC)(HDC,LPARAM,WPARAM,int,int);
typedef BOOL(CALLBACK *WNDENUMPROC)(HWND,LPARAM);
typedef BOOL(CALLBACK* MONITORENUMPROC)(HMONITOR,HDC,LPRECT,LPARAM);
typedef BOOL(CALLBACK *NAMEENUMPROCA)(LPSTR,LPARAM);
typedef BOOL(CALLBACK *NAMEENUMPROCW)(LPWSTR,LPARAM);
typedef NAMEENUMPROCA DESKTOPENUMPROCA;
typedef NAMEENUMPROCW DESKTOPENUMPROCW;
typedef NAMEENUMPROCA WINSTAENUMPROCA;
typedef NAMEENUMPROCW WINSTAENUMPROCW;
typedef void(CALLBACK *SENDASYNCPROC)(HWND,UINT,ULONG_PTR,LRESULT);
DECLARE_HANDLE(HHOOK);
DECLARE_HANDLE(HDWP);
DECLARE_HANDLE(HDEVNOTIFY);
typedef HDEVNOTIFY *PHDEVNOTIFY;

typedef struct tagACCEL {
	BYTE fVirt;
	WORD key;
	WORD cmd;
} ACCEL,*LPACCEL;

typedef struct tagACCESSTIMEOUT {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iTimeOutMSec;
} ACCESSTIMEOUT, *LPACCESSTIMEOUT;

typedef struct tagANIMATIONINFO {
	UINT cbSize;
	int iMinAnimate;
} ANIMATIONINFO,*LPANIMATIONINFO;

typedef struct tagCREATESTRUCTA {
	LPVOID	lpCreateParams;
	HINSTANCE	hInstance;
	HMENU	hMenu;
	HWND	hwndParent;
	int	cy;
	int	cx;
	int	y;
	int	x;
	LONG	style;
	LPCSTR	lpszName;
	LPCSTR	lpszClass;
	DWORD	dwExStyle;
} CREATESTRUCTA,*LPCREATESTRUCTA;

typedef struct tagCREATESTRUCTW {
	LPVOID	lpCreateParams;
	HINSTANCE	hInstance;
	HMENU	hMenu;
	HWND	hwndParent;
	int	cy;
	int	cx;
	int	y;
	int	x;
	LONG	style;
	LPCWSTR	lpszName;
	LPCWSTR	lpszClass;
	DWORD	dwExStyle;
} CREATESTRUCTW,*LPCREATESTRUCTW;

typedef struct tagCBT_CREATEWNDA {
	LPCREATESTRUCTA lpcs;
	HWND	hwndInsertAfter;
} CBT_CREATEWNDA, *LPCBT_CREATEWNDA;

typedef struct tagCBT_CREATEWNDW {
	LPCREATESTRUCTW lpcs;
	HWND	hwndInsertAfter;
} CBT_CREATEWNDW, *LPCBT_CREATEWNDW;

typedef struct tagCBTACTIVATESTRUCT {
	BOOL fMouse;
	HWND hWndActive;
} CBTACTIVATESTRUCT,*LPCBTACTIVATESTRUCT;

typedef struct tagCLIENTCREATESTRUCT {
	HANDLE	hWindowMenu;
	UINT	idFirstChild;
} CLIENTCREATESTRUCT,*LPCLIENTCREATESTRUCT;

typedef struct tagCOMPAREITEMSTRUCT {
	UINT	CtlType;
	UINT	CtlID;
	HWND	hwndItem;
	UINT	itemID1;
	ULONG_PTR	itemData1;
	UINT	itemID2;
	ULONG_PTR	itemData2;
	DWORD	dwLocaleId;
} COMPAREITEMSTRUCT, *PCOMPAREITEMSTRUCT,*LPCOMPAREITEMSTRUCT;

typedef struct tagCOPYDATASTRUCT {
  ULONG_PTR dwData;
  DWORD cbData;
  _Field_size_bytes_(cbData) PVOID lpData;
} COPYDATASTRUCT,*PCOPYDATASTRUCT;

typedef struct tagCURSORSHAPE {
	int xHotSpot;
	int yHotSpot;
	int cx;
	int cy;
	int cbWidth;
    BYTE Planes;
    BYTE BitsPixel;
} CURSORSHAPE,*LPCURSORSHAPE;

typedef struct tagCWPRETSTRUCT {
	LRESULT lResult;
	LPARAM lParam;
	WPARAM wParam;
	DWORD message;
	HWND hwnd;
} CWPRETSTRUCT,*PCWPRETSTRUCT, *LPCWPRETSTRUCT;

typedef struct tagCWPSTRUCT {
	LPARAM lParam;
	WPARAM wParam;
	UINT message;
	HWND hwnd;
} CWPSTRUCT,*PCWPSTRUCT, *LPCWPSTRUCT;

typedef struct tagDEBUGHOOKINFO {
	DWORD idThread;
	DWORD idThreadInstaller;
	LPARAM lParam;
	WPARAM wParam;
	int code;
} DEBUGHOOKINFO,*PDEBUGHOOKINFO,*LPDEBUGHOOKINFO;

typedef struct tagDELETEITEMSTRUCT {
	UINT CtlType;
	UINT CtlID;
	UINT itemID;
	HWND hwndItem;
	ULONG_PTR itemData;
} DELETEITEMSTRUCT,*PDELETEITEMSTRUCT,*LPDELETEITEMSTRUCT;

#include <pshpack2.h>
typedef struct {
	DWORD style;
	DWORD dwExtendedStyle;
	short x;
	short y;
	short cx;
	short cy;
	WORD id;
} DLGITEMTEMPLATE,*LPDLGITEMTEMPLATE;

typedef struct {
	DWORD style;
	DWORD dwExtendedStyle;
	WORD cdit;
	short x;
	short y;
	short cx;
	short cy;
} DLGTEMPLATE,*LPDLGTEMPLATE,*LPDLGTEMPLATEA,*LPDLGTEMPLATEW;

typedef const DLGTEMPLATE *LPCDLGTEMPLATEA;
typedef const DLGTEMPLATE *LPCDLGTEMPLATEW;
typedef DLGITEMTEMPLATE *PDLGITEMTEMPLATEA;
typedef DLGITEMTEMPLATE *PDLGITEMTEMPLATEW;
DECL_WINELIB_TYPE_AW(PDLGITEMTEMPLATE)
typedef DLGITEMTEMPLATE *LPDLGITEMTEMPLATEA;
typedef DLGITEMTEMPLATE *LPDLGITEMTEMPLATEW;


#ifdef UNICODE
typedef LPCDLGTEMPLATEW LPCDLGTEMPLATE;
#else
typedef LPCDLGTEMPLATEA LPCDLGTEMPLATE;
#endif // UNICODE
#include <poppack.h>

typedef struct tagDRAWITEMSTRUCT {
	UINT CtlType;
	UINT CtlID;
	UINT itemID;
	UINT itemAction;
	UINT itemState;
	HWND hwndItem;
	HDC	hDC;
	RECT rcItem;
	ULONG_PTR itemData;
} DRAWITEMSTRUCT,*LPDRAWITEMSTRUCT,*PDRAWITEMSTRUCT;

typedef struct {
	UINT cbSize;
	int iTabLength;
	int iLeftMargin;
	int iRightMargin;
	UINT uiLengthDrawn;
} DRAWTEXTPARAMS,*LPDRAWTEXTPARAMS;

typedef struct tagPAINTSTRUCT {
	HDC	hdc;
	BOOL fErase;
	RECT rcPaint;
	BOOL fRestore;
	BOOL fIncUpdate;
	BYTE rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT,*LPPAINTSTRUCT;

typedef struct tagMSG {
	HWND hwnd;
	UINT message;
	WPARAM wParam;
	LPARAM lParam;
	DWORD time;
	POINT pt;
} MSG,*LPMSG,*PMSG;

typedef struct _ICONINFO {
	BOOL fIcon;
	DWORD xHotspot;
	DWORD yHotspot;
	HBITMAP hbmMask;
	HBITMAP hbmColor;
} ICONINFO,*PICONINFO;

typedef struct _ICONINFOEXA
{
	DWORD     cbSize;
	BOOL      fIcon;
	DWORD     xHotspot;
	DWORD     yHotspot;
	HBITMAP   hbmMask;
	HBITMAP   hbmColor;
	WORD      wResID;
	CHAR      szModName[MAX_PATH];
	CHAR      szResName[MAX_PATH];
} ICONINFOEXA, *PICONINFOEXA;

typedef struct _ICONINFOEXW
{
	DWORD     cbSize;
	BOOL      fIcon;
	DWORD     xHotspot;
	DWORD     yHotspot;
	HBITMAP   hbmMask;
	HBITMAP   hbmColor;
	WORD      wResID;
	WCHAR     szModName[MAX_PATH];
	WCHAR     szResName[MAX_PATH];
} ICONINFOEXW, *PICONINFOEXW;

typedef struct tagNMHDR {
	HWND hwndFrom;
	UINT_PTR idFrom;
	UINT code;
} NMHDR,*LPNMHDR;

typedef struct _WNDCLASSA {
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCSTR lpszMenuName;
	LPCSTR lpszClassName;
} WNDCLASSA,*LPWNDCLASSA,*PWNDCLASSA;

typedef struct _WNDCLASSW {
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCWSTR lpszMenuName;
	LPCWSTR lpszClassName;
} WNDCLASSW,*LPWNDCLASSW,*PWNDCLASSW;

typedef enum tagAR_STATE {
  AR_ENABLED = 0x0,
  AR_DISABLED = 0x1,
  AR_SUPPRESSED = 0x2,
  AR_REMOTESESSION = 0x4,
  AR_MULTIMON = 0x8,
  AR_NOSENSOR = 0x10,
  AR_NOT_SUPPORTED = 0x20,
  AR_DOCKED = 0x40,
  AR_LAPTOP = 0x80
} AR_STATE, *PAR_STATE;

typedef struct _WNDCLASSEXA {
	UINT cbSize;
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCSTR lpszMenuName;
	LPCSTR lpszClassName;
	HICON hIconSm;
} WNDCLASSEXA,*LPWNDCLASSEXA,*PWNDCLASSEXA;

typedef struct _WNDCLASSEXW {
	UINT cbSize;
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCWSTR lpszMenuName;
	LPCWSTR lpszClassName;
	HICON hIconSm;
} WNDCLASSEXW,*LPWNDCLASSEXW,*PWNDCLASSEXW;

#define MNGOF_TOPGAP 0x00000001
#define MNGOF_BOTTOMGAP 0x00000002

typedef struct tagMENUGETOBJECTINFO {
	DWORD dwFlags;
	UINT uPos;
	HMENU hmenu;
	PVOID riid;
	PVOID pvObj;
} MENUGETOBJECTINFO,*PMENUGETOBJECTINFO;

typedef struct tagMENUITEMINFOA {
	UINT cbSize;
	UINT fMask;
	UINT fType;
	UINT fState;
	UINT wID;
	HMENU hSubMenu;
	HBITMAP hbmpChecked;
	HBITMAP hbmpUnchecked;
	ULONG_PTR dwItemData;
	LPSTR dwTypeData;
	UINT cch;
#if (_WIN32_WINNT >= 0x0500)
	HBITMAP hbmpItem;
#endif
} MENUITEMINFOA,*LPMENUITEMINFOA;
typedef const MENUITEMINFOA *LPCMENUITEMINFOA;

typedef struct tagMENUITEMINFOW {
	UINT cbSize;
	UINT fMask;
	UINT fType;
	UINT fState;
	UINT wID;
	HMENU hSubMenu;
	HBITMAP hbmpChecked;
	HBITMAP hbmpUnchecked;
	ULONG_PTR dwItemData;
	LPWSTR dwTypeData;
	UINT cch;
#if (_WIN32_WINNT >= 0x0500)
	HBITMAP hbmpItem;
#endif
} MENUITEMINFOW,*LPMENUITEMINFOW;

typedef const MENUITEMINFOW *LPCMENUITEMINFOW;

typedef struct tagSCROLLINFO {
	UINT cbSize;
	UINT fMask;
	int nMin;
	int nMax;
	UINT nPage;
	int nPos;
	int nTrackPos;
} SCROLLINFO,*LPSCROLLINFO;
typedef const SCROLLINFO *LPCSCROLLINFO;

typedef struct _WINDOWPLACEMENT {
	UINT length;
	UINT flags;
	UINT showCmd;
	POINT ptMinPosition;
	POINT ptMaxPosition;
	RECT rcNormalPosition;
} WINDOWPLACEMENT,*LPWINDOWPLACEMENT,*PWINDOWPLACEMENT;

typedef struct {
	WORD versionNumber;
	WORD offset;
} MENUITEMTEMPLATEHEADER, *PMENUITEMTEMPLATEHEADER;

typedef struct {
	WORD mtOption;
	WORD mtID;
	WCHAR mtString[1];
} MENUITEMTEMPLATE, *PMENUITEMTEMPLATE;

typedef void MENUTEMPLATE,MENUTEMPLATEA,MENUTEMPLATEW,*LPMENUTEMPLATEA,*LPMENUTEMPLATEW,*LPMENUTEMPLATE;

typedef struct tagHELPINFO {
	UINT cbSize;
	int iContextType;
	int iCtrlId;
	HANDLE hItemHandle;
	DWORD_PTR dwContextId;
	POINT MousePos;
} HELPINFO,*LPHELPINFO;

typedef void(CALLBACK *MSGBOXCALLBACK)(LPHELPINFO);

typedef struct {
	UINT cbSize;
	HWND hwndOwner;
	HINSTANCE hInstance;
	LPCSTR lpszText;
	LPCSTR lpszCaption;
	DWORD dwStyle;
	LPCSTR lpszIcon;
	DWORD_PTR dwContextHelpId;
	MSGBOXCALLBACK lpfnMsgBoxCallback;
	DWORD dwLanguageId;
} MSGBOXPARAMSA,*PMSGBOXPARAMSA,*LPMSGBOXPARAMSA;

typedef struct {
	UINT cbSize;
	HWND hwndOwner;
	HINSTANCE hInstance;
	LPCWSTR lpszText;
	LPCWSTR lpszCaption;
	DWORD dwStyle;
	LPCWSTR lpszIcon;
	DWORD_PTR dwContextHelpId;
	MSGBOXCALLBACK lpfnMsgBoxCallback;
	DWORD dwLanguageId;
} MSGBOXPARAMSW,*PMSGBOXPARAMSW,*LPMSGBOXPARAMSW;

typedef struct tagUSEROBJECTFLAGS {
	BOOL fInherit;
	BOOL fReserved;
	DWORD dwFlags;
} USEROBJECTFLAGS, *PUSEROBJECTFLAGS;

typedef struct tagFILTERKEYS {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iWaitMSec;
	DWORD iDelayMSec;
	DWORD iRepeatMSec;
	DWORD iBounceMSec;
} FILTERKEYS, *LPFILTERKEYS;

typedef struct tagHIGHCONTRASTA {
	UINT cbSize;
	DWORD dwFlags;
	LPSTR lpszDefaultScheme;
} HIGHCONTRASTA,*LPHIGHCONTRASTA;

typedef struct tagHIGHCONTRASTW {
	UINT cbSize;
	DWORD dwFlags;
	LPWSTR lpszDefaultScheme;
} HIGHCONTRASTW,*LPHIGHCONTRASTW;

#if defined(_WINGDI_) && !defined(NOGDI)
typedef struct tagICONMETRICSA {
	UINT cbSize;
	int iHorzSpacing;
	int iVertSpacing;
	int iTitleWrap;
	LOGFONTA lfFont;
} ICONMETRICSA, *PICONMETRICSA, *LPICONMETRICSA;

typedef struct tagICONMETRICSW {
	UINT cbSize;
	int iHorzSpacing;
	int iVertSpacing;
	int iTitleWrap;
	LOGFONTW lfFont;
} ICONMETRICSW, *PICONMETRICSW, *LPICONMETRICSW;

#ifdef UNICODE
typedef ICONMETRICSW ICONMETRICS,*LPICONMETRICS;
#else /* UNICODE */
typedef ICONMETRICSA ICONMETRICS,*LPICONMETRICS;
#endif /* UNICODE */
#endif /*  NOGDI */

typedef struct tagMINIMIZEDMETRICS {
	UINT cbSize;
	int iWidth;
	int iHorzGap;
	int iVertGap;
	int iArrange;
} MINIMIZEDMETRICS, *PMINIMIZEDMETRICS,*LPMINIMIZEDMETRICS;

#define WDA_NONE    0x0
#define WDA_MONITOR 0x1

typedef struct tagMOUSEKEYS{
	UINT cbSize;
	DWORD dwFlags;
	DWORD iMaxSpeed;
	DWORD iTimeToMaxSpeed;
	DWORD iCtrlSpeed;
	DWORD dwReserved1;
	DWORD dwReserved2;
} MOUSEKEYS,*LPMOUSEKEYS;

#if defined(_WINGDI_) && !defined(NOGDI)
typedef struct tagNONCLIENTMETRICSA {
	UINT cbSize;
	int iBorderWidth;
	int iScrollWidth;
	int iScrollHeight;
	int iCaptionWidth;
	int iCaptionHeight;
	LOGFONTA lfCaptionFont;
	int iSmCaptionWidth;
	int iSmCaptionHeight;
	LOGFONTA lfSmCaptionFont;
	int iMenuWidth;
	int iMenuHeight;
	LOGFONTA lfMenuFont;
	LOGFONTA lfStatusFont;
	LOGFONTA lfMessageFont;
#if (WINVER >= 0x0600)
        int iPaddedBorderWidth;
#endif
} NONCLIENTMETRICSA, *PNONCLIENTMETRICSA,*LPNONCLIENTMETRICSA;

typedef struct tagNONCLIENTMETRICSW {
	UINT cbSize;
	int iBorderWidth;
	int iScrollWidth;
	int iScrollHeight;
	int iCaptionWidth;
	int iCaptionHeight;
	LOGFONTW lfCaptionFont;
	int iSmCaptionWidth;
	int iSmCaptionHeight;
	LOGFONTW lfSmCaptionFont;
	int iMenuWidth;
	int iMenuHeight;
	LOGFONTW lfMenuFont;
	LOGFONTW lfStatusFont;
	LOGFONTW lfMessageFont;
#if (WINVER >= 0x0600)
        int iPaddedBorderWidth;
#endif
} NONCLIENTMETRICSW, *PNONCLIENTMETRICSW,*LPNONCLIENTMETRICSW;

#ifdef UNICODE
typedef NONCLIENTMETRICSW NONCLIENTMETRICS,*LPNONCLIENTMETRICS;
#else /* UNICODE */
typedef NONCLIENTMETRICSA NONCLIENTMETRICS,*LPNONCLIENTMETRICS;
#endif /* UNICODE */
#endif

typedef struct tagSERIALKEYSA {
	UINT cbSize;
	DWORD dwFlags;
	LPSTR lpszActivePort;
	LPSTR lpszPort;
	UINT iBaudRate;
	UINT iPortState;
	UINT iActive;
} SERIALKEYSA,*LPSERIALKEYSA;

typedef struct tagSERIALKEYSW {
	UINT cbSize;
	DWORD dwFlags;
	LPWSTR lpszActivePort;
	LPWSTR lpszPort;
	UINT iBaudRate;
	UINT iPortState;
	UINT iActive;
} SERIALKEYSW,*LPSERIALKEYSW;

typedef struct tagSOUNDSENTRYA {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iFSTextEffect;
	DWORD iFSTextEffectMSec;
	DWORD iFSTextEffectColorBits;
	DWORD iFSGrafEffect;
	DWORD iFSGrafEffectMSec;
	DWORD iFSGrafEffectColor;
	DWORD iWindowsEffect;
	DWORD iWindowsEffectMSec;
	LPSTR lpszWindowsEffectDLL;
	DWORD iWindowsEffectOrdinal;
} SOUNDSENTRYA,*LPSOUNDSENTRYA;

typedef struct tagSOUNDSENTRYW {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iFSTextEffect;
	DWORD iFSTextEffectMSec;
	DWORD iFSTextEffectColorBits;
	DWORD iFSGrafEffect;
	DWORD iFSGrafEffectMSec;
	DWORD iFSGrafEffectColor;
	DWORD iWindowsEffect;
	DWORD iWindowsEffectMSec;
	LPWSTR lpszWindowsEffectDLL;
	DWORD iWindowsEffectOrdinal;
} SOUNDSENTRYW,*LPSOUNDSENTRYW;

#if (_WIN32_WINNT >= 0x0600)
typedef struct tagAUDIODESCRIPTION {
	UINT cbSize;
	BOOL Enabled;
	LCID Locale;
} AUDIODESCRIPTION, *LPAUDIODESCRIPTION;
#endif

typedef struct tagSTICKYKEYS {
	DWORD cbSize;
	DWORD dwFlags;
} STICKYKEYS,*LPSTICKYKEYS;

typedef struct tagTOGGLEKEYS {
	DWORD cbSize;
	DWORD dwFlags;
} TOGGLEKEYS, *LPTOGGLEKEYS;

typedef struct tagMOUSEHOOKSTRUCT {
	POINT pt;
	HWND hwnd;
	UINT wHitTestCode;
	ULONG_PTR dwExtraInfo;
} MOUSEHOOKSTRUCT,*LPMOUSEHOOKSTRUCT,*PMOUSEHOOKSTRUCT;

typedef struct tagHARDWAREHOOKSTRUCT {
    HWND    hwnd;
    UINT    message;
    WPARAM  wParam;
    LPARAM  lParam;
} HARDWAREHOOKSTRUCT, *PHARDWAREHOOKSTRUCT, *LPHARDWAREHOOKSTRUCT;

#if ( _WIN32_WINNT >= 0x0500 )
#ifdef __cplusplus
typedef struct tagMOUSEHOOKSTRUCTEX : public tagMOUSEHOOKSTRUCT
{
        DWORD   mouseData;
} MOUSEHOOKSTRUCTEX, *LPMOUSEHOOKSTRUCTEX, *PMOUSEHOOKSTRUCTEX;
#else
typedef struct tagMOUSEHOOKSTRUCTEX
{
        MOUSEHOOKSTRUCT MOUSEHOOKSTRUCT;
        DWORD   mouseData;
} MOUSEHOOKSTRUCTEX, *LPMOUSEHOOKSTRUCTEX, *PMOUSEHOOKSTRUCTEX;
#endif
#endif

typedef struct tagTRACKMOUSEEVENT {
	DWORD cbSize;
	DWORD dwFlags;
	HWND  hwndTrack;
	DWORD dwHoverTime;
} TRACKMOUSEEVENT,*LPTRACKMOUSEEVENT;

typedef struct tagTPMPARAMS {
	UINT cbSize;
	RECT rcExclude;
} TPMPARAMS,*LPTPMPARAMS;

typedef struct tagEVENTMSG {
	UINT message;
	UINT paramL;
	UINT paramH;
	DWORD time;
	HWND hwnd;
} EVENTMSG,*PEVENTMSGMSG,*LPEVENTMSGMSG,*PEVENTMSG,*LPEVENTMSG;

typedef struct _WINDOWPOS {
	HWND hwnd;
	HWND hwndInsertAfter;
	int x;
	int y;
	int cx;
	int cy;
	UINT flags;
} WINDOWPOS,*PWINDOWPOS,*LPWINDOWPOS;

typedef struct tagNCCALCSIZE_PARAMS {
	RECT rgrc[3];
	PWINDOWPOS lppos;
} NCCALCSIZE_PARAMS, *LPNCCALCSIZE_PARAMS;

typedef struct tagMDICREATESTRUCTA {
	LPCSTR szClass;
	LPCSTR szTitle;
	HANDLE hOwner;
	int x;
	int y;
	int cx;
	int cy;
	DWORD style;
	LPARAM lParam;
} MDICREATESTRUCTA,*LPMDICREATESTRUCTA;

typedef struct tagMDICREATESTRUCTW {
	LPCWSTR szClass;
	LPCWSTR szTitle;
	HANDLE hOwner;
	int x;
	int y;
	int cx;
	int cy;
	DWORD style;
	LPARAM lParam;
} MDICREATESTRUCTW,*LPMDICREATESTRUCTW;

typedef struct tagMINMAXINFO {
	POINT ptReserved;
	POINT ptMaxSize;
	POINT ptMaxPosition;
	POINT ptMinTrackSize;
	POINT ptMaxTrackSize;
} MINMAXINFO,*PMINMAXINFO,*LPMINMAXINFO;

typedef struct tagMDINEXTMENU {
	HMENU hmenuIn;
	HMENU hmenuNext;
	HWND hwndNext;
} MDINEXTMENU,*PMDINEXTMENU,*LPMDINEXTMENU;

typedef struct tagMEASUREITEMSTRUCT {
	UINT CtlType;
	UINT CtlID;
	UINT itemID;
	UINT itemWidth;
	UINT itemHeight;
	ULONG_PTR itemData;
} MEASUREITEMSTRUCT,*PMEASUREITEMSTRUCT,*LPMEASUREITEMSTRUCT;

typedef struct tagDROPSTRUCT {
	HWND hwndSource;
	HWND hwndSink;
	DWORD wFmt;
	ULONG_PTR dwData;
	POINT ptDrop;
	DWORD dwControlData;
} DROPSTRUCT,*PDROPSTRUCT,*LPDROPSTRUCT;

typedef DWORD HELPPOLY;
typedef struct tagMULTIKEYHELPA {
	DWORD mkSize;
	CHAR mkKeylist;
	CHAR szKeyphrase[1];
} MULTIKEYHELPA,*PMULTIKEYHELPA,*LPMULTIKEYHELPA;

typedef struct tagMULTIKEYHELPW {
	DWORD mkSize;
	WCHAR mkKeylist;
	WCHAR szKeyphrase[1];
} MULTIKEYHELPW,*PMULTIKEYHELPW,*LPMULTIKEYHELPW;

typedef struct tagHELPWININFOA {
	int wStructSize;
	int x;
	int y;
	int dx;
	int dy;
	int wMax;
	CHAR rgchMember[2];
} HELPWININFOA,*PHELPWININFOA,*LPHELPWININFOA;

typedef struct tagHELPWININFOW {
	int wStructSize;
	int x;
	int y;
	int dx;
	int dy;
	int wMax;
	WCHAR rgchMember[2];
} HELPWININFOW,*PHELPWININFOW,*LPHELPWININFOW;

typedef struct tagSTYLESTRUCT {
	DWORD styleOld;
	DWORD styleNew;
} STYLESTRUCT,*LPSTYLESTRUCT;

typedef struct tagALTTABINFO {
	DWORD cbSize;
	int   cItems;
	int   cColumns;
	int   cRows;
	int   iColFocus;
	int   iRowFocus;
	int   cxItem;
	int   cyItem;
	POINT ptStart;
} ALTTABINFO,*PALTTABINFO,*LPALTTABINFO;

typedef struct tagCOMBOBOXINFO {
	DWORD cbSize;
	RECT rcItem;
	RECT rcButton;
	DWORD stateButton;
	HWND hwndCombo;
	HWND hwndItem;
	HWND hwndList;
} COMBOBOXINFO,*PCOMBOBOXINFO,*LPCOMBOBOXINFO;

typedef struct tagCURSORINFO {
	DWORD cbSize;
	DWORD flags;
	HCURSOR hCursor;
	POINT ptScreenPos;
} CURSORINFO,*PCURSORINFO,*LPCURSORINFO;

typedef struct tagMENUBARINFO {
	DWORD cbSize;
	RECT  rcBar;
	HMENU hMenu;
	HWND  hwndMenu;
	BOOL  fBarFocused:1;
	BOOL  fFocused:1;
} MENUBARINFO,*PMENUBARINFO;

typedef struct tagMENUINFO {
	DWORD cbSize;
	DWORD fMask;
	DWORD dwStyle;
	UINT cyMax;
	HBRUSH  hbrBack;
	DWORD   dwContextHelpID;
	ULONG_PTR dwMenuData;
} MENUINFO,*LPMENUINFO;

typedef MENUINFO CONST *LPCMENUINFO;
#define CCHILDREN_SCROLLBAR 5

typedef struct tagSCROLLBARINFO {
	DWORD cbSize;
	RECT  rcScrollBar;
	int   dxyLineButton;
	int   xyThumbTop;
	int   xyThumbBottom;
	int   reserved;
	DWORD rgstate[CCHILDREN_SCROLLBAR+1];
} SCROLLBARINFO,*PSCROLLBARINFO,*LPSCROLLBARINFO;

#define CCHILDREN_TITLEBAR 5

typedef struct tagTITLEBARINFO {
	DWORD cbSize;
	RECT  rcTitleBar;
	DWORD rgstate[CCHILDREN_TITLEBAR+1];
} TITLEBARINFO,*PTITLEBARINFO,*LPTITLEBARINFO;

typedef struct tagWINDOWINFO {
	DWORD cbSize;
	RECT  rcWindow;
	RECT  rcClient;
	DWORD dwStyle;
	DWORD dwExStyle;
	DWORD dwWindowStatus;
	UINT  cxWindowBorders;
	UINT  cyWindowBorders;
	ATOM  atomWindowType;
	WORD  wCreatorVersion;
} WINDOWINFO,*PWINDOWINFO,*LPWINDOWINFO;

typedef struct tagLASTINPUTINFO {
	UINT cbSize;
	DWORD dwTime;
} LASTINPUTINFO,*PLASTINPUTINFO;

typedef struct tagMONITORINFO {
	DWORD cbSize;
	RECT rcMonitor;
	RECT rcWork;
	DWORD dwFlags;
} MONITORINFO,*LPMONITORINFO;

#define CCHDEVICENAME 32
typedef struct tagMONITORINFOEXA {
	DWORD	cbSize;
	RECT	rcMonitor;
	RECT	rcWork;
	DWORD	dwFlags;
	CHAR	szDevice[CCHDEVICENAME];
} MONITORINFOEXA,*LPMONITORINFOEXA;

typedef struct tagMONITORINFOEXW {
	DWORD	cbSize;
	RECT	rcMonitor;
	RECT	rcWork;
	DWORD	dwFlags;
	WCHAR	szDevice[CCHDEVICENAME];
} MONITORINFOEXW,*LPMONITORINFOEXW;

typedef struct tagKBDLLHOOKSTRUCT {
	DWORD vkCode;
	DWORD scanCode;
	DWORD flags;
	DWORD time;
	ULONG_PTR dwExtraInfo;
} KBDLLHOOKSTRUCT,*LPKBDLLHOOKSTRUCT,*PKBDLLHOOKSTRUCT;

typedef struct tagMSLLHOOKSTRUCT
{
	POINT pt;
	DWORD mouseData;
	DWORD flags;
	DWORD time;
	ULONG_PTR dwExtraInfo;
} MSLLHOOKSTRUCT, *LPMSLLHOOKSTRUCT, *PMSLLHOOKSTRUCT;

#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
typedef struct {
  UINT  cbSize;
  HWND  hwnd;
  DWORD dwFlags;
  UINT  uCount;
  DWORD dwTimeout;
} FLASHWINFO,*PFLASHWINFO;
#endif /* (WINVER >= 0x0500 || _WIN32_WINDOWS >= 0x0410) */

#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0490)
typedef struct tagMOUSEMOVEPOINT {
  int x;
  int y;
  DWORD time;
  ULONG_PTR dwExtraInfo;
} MOUSEMOVEPOINT,*PMOUSEMOVEPOINT,*LPMOUSEMOVEPOINT;
#endif

#if (_WIN32_WINNT >= 0x0400)
typedef struct tagMOUSEINPUT {
  LONG dx;
  LONG dy;
  DWORD mouseData;
  DWORD dwFlags;
  DWORD time;
  ULONG_PTR dwExtraInfo;
} MOUSEINPUT,*PMOUSEINPUT, *LPMOUSEINPUT;

typedef struct tagKEYBDINPUT {
  WORD wVk;
  WORD wScan;
  DWORD dwFlags;
  DWORD time;
  ULONG_PTR dwExtraInfo;
} KEYBDINPUT, *PKEYBDINPUT, *LPKEYBDINPUT;

typedef struct tagHARDWAREINPUT {
  DWORD uMsg;
  WORD wParamL;
  WORD wParamH;
} HARDWAREINPUT, *PHARDWAREINPUT, *LPHARDWAREINPUT;

typedef struct tagINPUT {
  DWORD type;
  _ANONYMOUS_UNION union {
		MOUSEINPUT mi;
		KEYBDINPUT ki;
		HARDWAREINPUT hi;
  } DUMMYUNIONNAME;
} INPUT,*PINPUT,*LPINPUT;
#endif /* (_WIN32_WINNT >= 0x0400) */

#if (WINVER >= 0x0500)
typedef struct tagGUITHREADINFO {
	DWORD cbSize;
	DWORD flags;
	HWND hwndActive;
	HWND hwndFocus;
	HWND hwndCapture;
	HWND hwndMenuOwner;
	HWND hwndMoveSize;
	HWND hwndCaret;
	RECT rcCaret;
} GUITHREADINFO,*PGUITHREADINFO,*LPGUITHREADINFO;

typedef VOID (CALLBACK *WINEVENTPROC)(HWINEVENTHOOK,DWORD,HWND,LONG,LONG,DWORD,DWORD);
#endif /* (WINVER >= 0x0500) */

#if (_WIN32_WINNT >= 0x0501)
typedef struct {
	UINT  cbSize;
	HDESK hdesk;
	HWND  hwnd;
	LUID  luid;
} BSMINFO,*PBSMINFO;
DECLARE_HANDLE(HRAWINPUT);

typedef struct tagRAWINPUTHEADER {
	DWORD dwType;
	DWORD dwSize;
	HANDLE hDevice;
	WPARAM wParam;
} RAWINPUTHEADER,*PRAWINPUTHEADER;

typedef struct tagRAWMOUSE {
	USHORT usFlags;
	_ANONYMOUS_UNION union {
		ULONG ulButtons;
		_ANONYMOUS_STRUCT struct {
			USHORT usButtonFlags;
			USHORT usButtonData;
		};
	};
	ULONG ulRawButtons;
	LONG lLastX;
	LONG lLastY;
	ULONG ulExtraInformation;
} RAWMOUSE,*PRAWMOUSE,*LPRAWMOUSE;

typedef struct tagRAWKEYBOARD {
	USHORT MakeCode;
	USHORT Flags;
	USHORT Reserved;
	USHORT VKey;
	UINT Message;
	ULONG ExtraInformation;
} RAWKEYBOARD,*PRAWKEYBOARD,*LPRAWKEYBOARD;

typedef struct tagRAWHID {
	DWORD dwSizeHid;
	DWORD dwCount;
	BYTE bRawData;
} RAWHID,*PRAWHID,*LPRAWHID;

typedef struct tagRAWINPUT {
	RAWINPUTHEADER header;
	union {
		RAWMOUSE    mouse;
		RAWKEYBOARD keyboard;
		RAWHID      hid;
	} data;
} RAWINPUT,*PRAWINPUT,*LPRAWINPUT;

typedef struct tagRAWINPUTDEVICE {
	USHORT usUsagePage;
	USHORT usUsage;
	DWORD dwFlags;
	HWND hwndTarget;
} RAWINPUTDEVICE,*PRAWINPUTDEVICE,*LPRAWINPUTDEVICE;

typedef const RAWINPUTDEVICE *PCRAWINPUTDEVICE;

typedef struct tagRAWINPUTDEVICELIST {
	HANDLE hDevice;
	DWORD dwType;
} RAWINPUTDEVICELIST,*PRAWINPUTDEVICELIST;

typedef struct tagRID_DEVICE_INFO_MOUSE {
  DWORD dwId;
  DWORD dwNumberOfButtons;
  DWORD dwSampleRate;
  BOOL fHasHorizontalWheel;
} RID_DEVICE_INFO_MOUSE, *PRID_DEVICE_INFO_MOUSE;

typedef struct tagRID_DEVICE_INFO_KEYBOARD {
  DWORD dwType;
  DWORD dwSubType;
  DWORD dwKeyboardMode;
  DWORD dwNumberOfFunctionKeys;
  DWORD dwNumberOfIndicators;
  DWORD dwNumberOfKeysTotal;
} RID_DEVICE_INFO_KEYBOARD, *PRID_DEVICE_INFO_KEYBOARD;

typedef struct tagRID_DEVICE_INFO_HID {
  DWORD dwVendorId;
  DWORD dwProductId;
  DWORD dwVersionNumber;
  USHORT usUsagePage;
  USHORT usUsage;
} RID_DEVICE_INFO_HID, *PRID_DEVICE_INFO_HID;

typedef struct tagRID_DEVICE_INFO {
  DWORD cbSize;
  DWORD dwType;
  union {
    RID_DEVICE_INFO_MOUSE mouse;
    RID_DEVICE_INFO_KEYBOARD keyboard;
    RID_DEVICE_INFO_HID hid;
  } DUMMYUNIONNAME;
} RID_DEVICE_INFO, *PRID_DEVICE_INFO, *LPRID_DEVICE_INFO;

#endif /* (_WIN32_WINNT >= 0x0501) */

#define AnsiToOem CharToOemA
#define OemToAnsi OemToCharA
#define AnsiToOemBuff CharToOemBuffA
#define OemToAnsiBuff OemToCharBuffA
#define AnsiUpper CharUpperA
#define AnsiUpperBuff CharUpperBuffA
#define AnsiLower CharLowerA
#define AnsiLowerBuff CharLowerBuffA
#define AnsiNext CharNextA
#define AnsiPrev CharPrevA
#define MAKELPARAM(l,h) ((LPARAM)MAKELONG(l,h))
#define MAKEWPARAM(l,h) ((WPARAM)MAKELONG(l,h))
#define MAKELRESULT(l,h) ((LRESULT)MAKELONG(l,h))
#define POINTSTOPOINT(p,ps) { \
  (p).x=LOWORD(*(DWORD *)&ps); \
  (p).y=HIWORD(*(DWORD *)&ps); \
}
#define POINTTOPOINTS(p) ((POINTS)MAKELONG((p).x,(p).y))

#if (WINVER >= 0x0601)

typedef enum tagINPUT_MESSAGE_DEVICE_TYPE {
  IMDT_UNAVAILABLE = 0x00,
  IMDT_KEYBOARD = 0x01,
  IMDT_MOUSE = 0x02,
  IMDT_TOUCH = 0x04,
  IMDT_PEN = 0x08,
  IMDT_TOUCHPAD = 0x10
} INPUT_MESSAGE_DEVICE_TYPE;

typedef enum tagINPUT_MESSAGE_ORIGIN_ID {
  IMO_UNAVAILABLE = 0x00,
  IMO_HARDWARE = 0x01,
  IMO_INJECTED = 0x02,
  IMO_SYSTEM = 0x04
} INPUT_MESSAGE_ORIGIN_ID;

typedef struct tagINPUT_MESSAGE_SOURCE {
  INPUT_MESSAGE_DEVICE_TYPE deviceType;
  INPUT_MESSAGE_ORIGIN_ID originId;
} INPUT_MESSAGE_SOURCE;

#endif /* WINVER >= 0x0601 */

#if(WINVER >= 0x0602)

enum tagPOINTER_INPUT_TYPE {
  PT_POINTER = 1,
  PT_TOUCH,
  PT_PEN,
  PT_MOUSE,
  PT_TOUCHPAD
};
typedef DWORD POINTER_INPUT_TYPE;

#endif /* WINVER >= 0x0602 */

HKL WINAPI ActivateKeyboardLayout(_In_ HKL, _In_ UINT);
BOOL WINAPI AdjustWindowRect(_Inout_ LPRECT, _In_ DWORD, _In_ BOOL);
BOOL WINAPI AdjustWindowRectEx(_Inout_ LPRECT, _In_ DWORD, _In_ BOOL, _In_ DWORD);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI AnimateWindow(_In_ HWND, _In_ DWORD, _In_ DWORD);
#endif /* (_WIN32_WINNT >= 0x0500) */
BOOL WINAPI AnyPopup(void);
BOOL WINAPI AppendMenuA(_In_ HMENU, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCSTR);
BOOL WINAPI AppendMenuW(_In_ HMENU, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCWSTR);
UINT WINAPI ArrangeIconicWindows(_In_ HWND);
BOOL WINAPI AttachThreadInput(_In_ DWORD, _In_ DWORD, _In_ BOOL);
HDWP WINAPI BeginDeferWindowPos(_In_ int);
HDC WINAPI BeginPaint(_In_ HWND, _Out_ LPPAINTSTRUCT);
BOOL WINAPI BringWindowToTop(_In_ HWND);
long WINAPI BroadcastSystemMessage(_In_ DWORD, _Inout_opt_ LPDWORD, _In_ UINT, _In_ WPARAM, _In_ LPARAM);

#if (_WIN32_WINNT >= 0x0400)

LONG
WINAPI
BroadcastSystemMessageA(
  _In_ DWORD flags,
  _Inout_opt_ LPDWORD lpInfo,
  _In_ UINT Msg,
  _In_ WPARAM wParam,
  _In_ LPARAM lParam);

LONG
WINAPI
BroadcastSystemMessageW(
  _In_ DWORD flags,
  _Inout_opt_ LPDWORD lpInfo,
  _In_ UINT Msg,
  _In_ WPARAM wParam,
  _In_ LPARAM lParam);

#endif /* (_WIN32_WINNT >= 0x0400) */

#if (_WIN32_WINNT >= 0x0501)

LONG
WINAPI
BroadcastSystemMessageExA(
  _In_ DWORD flags,
  _Inout_opt_ LPDWORD lpInfo,
  _In_ UINT Msg,
  _In_ WPARAM wParam,
  _In_ LPARAM lParam,
  _Out_opt_ PBSMINFO pbsmInfo);

LONG
WINAPI
BroadcastSystemMessageExW(
  _In_ DWORD flags,
  _Inout_opt_ LPDWORD lpInfo,
  _In_ UINT Msg,
  _In_ WPARAM wParam,
  _In_ LPARAM lParam,
  _Out_opt_ PBSMINFO pbsmInfo);

#endif /* (_WIN32_WINNT >= 0x0501) */

void WINAPI CalcChildScroll(HWND, INT);
BOOL WINAPI CallMsgFilterA(_In_ LPMSG, _In_ INT);
BOOL WINAPI CallMsgFilterW(_In_ LPMSG, _In_ INT);
LRESULT WINAPI CallNextHookEx(_In_opt_ HHOOK, _In_ int, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI CallWindowProcA(_In_ WNDPROC, _In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI CallWindowProcW(_In_ WNDPROC, _In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);

WORD
WINAPI
CascadeWindows(
  _In_opt_ HWND hwndParent,
  _In_ UINT wHow,
  _In_opt_ CONST RECT * lpRect,
  _In_ UINT cKids,
  _In_reads_opt_(cKids) const HWND FAR *lpKids);

BOOL WINAPI ChangeClipboardChain(_In_ HWND, _In_ HWND);
#if defined(_WINGDI_) && !defined(NOGDI)
LONG WINAPI ChangeDisplaySettingsA(_In_opt_ PDEVMODEA, _In_ DWORD);
LONG WINAPI ChangeDisplaySettingsW(_In_opt_ PDEVMODEW, _In_ DWORD);
LONG WINAPI ChangeDisplaySettingsExA(_In_opt_ LPCSTR, _In_opt_ LPDEVMODEA, _Reserved_ HWND, _In_ DWORD, _In_opt_ LPVOID);
LONG WINAPI ChangeDisplaySettingsExW(_In_opt_ LPCWSTR, _In_opt_ LPDEVMODEW, _Reserved_ HWND, _In_ DWORD, _In_opt_ LPVOID);
#endif
BOOL WINAPI ChangeMenuA(_In_ HMENU, _In_ UINT, _In_opt_ LPCSTR, _In_ UINT, _In_ UINT);
BOOL WINAPI ChangeMenuW(_In_ HMENU, _In_ UINT, _In_opt_ LPCWSTR, _In_ UINT, _In_ UINT);
LPSTR WINAPI CharLowerA(_Inout_ LPSTR);
LPWSTR WINAPI CharLowerW(_Inout_ LPWSTR);

DWORD
WINAPI
CharLowerBuffA(
  _Inout_updates_(cchLength) LPSTR lpsz,
  _In_ DWORD cchLength);

DWORD
WINAPI
CharLowerBuffW(
  _Inout_updates_(cchLength) LPWSTR lpsz,
  _In_ DWORD cchLength);

LPSTR WINAPI CharNextA(_In_ LPCSTR);
LPWSTR WINAPI CharNextW(_In_ LPCWSTR);

LPSTR WINAPI CharNextExA(_In_ WORD, _In_ LPCSTR, _In_ DWORD);
LPWSTR WINAPI CharNextExW(_In_ WORD, _In_ LPCWSTR, _In_ DWORD);
LPSTR WINAPI CharPrevA(_In_ LPCSTR, _In_ LPCSTR);
LPWSTR WINAPI CharPrevW(_In_ LPCWSTR, _In_ LPCWSTR);
LPSTR WINAPI CharPrevExA(_In_ WORD, _In_ LPCSTR, _In_ LPCSTR, _In_ DWORD);
LPWSTR WINAPI CharPrevExW(_In_ WORD, _In_ LPCWSTR, _In_ LPCWSTR, _In_ DWORD);

BOOL
WINAPI
CharToOemA(
  _In_ LPCSTR pSrc,
  _Out_writes_(_Inexpressible_(strlen(pSrc) + 1)) LPSTR pDst);

BOOL
WINAPI
CharToOemW(
  _In_ LPCWSTR pSrc,
  _Out_writes_(_Inexpressible_(strlen(pSrc) + 1)) LPSTR pDst);

BOOL
WINAPI
CharToOemBuffA(
  _In_ LPCSTR lpszSrc,
  _Out_writes_(cchDstLength) LPSTR lpszDst,
  _In_ DWORD cchDstLength);

BOOL
WINAPI
CharToOemBuffW(
  _In_ LPCWSTR lpszSrc,
  _Out_writes_(cchDstLength) LPSTR lpszDst,
  _In_ DWORD cchDstLength);

LPSTR WINAPI CharUpperA(_Inout_ LPSTR);
LPWSTR WINAPI CharUpperW(_Inout_ LPWSTR);

DWORD
WINAPI
CharUpperBuffA(
  _Inout_updates_(cchLength) LPSTR lpsz,
  _In_ DWORD cchLength);

DWORD
WINAPI
CharUpperBuffW(
  _Inout_updates_(cchLength) LPWSTR lpsz,
  _In_ DWORD cchLength);

BOOL WINAPI CheckDlgButton(_In_ HWND, _In_ int, _In_ UINT);
DWORD WINAPI CheckMenuItem(_In_ HMENU, _In_ UINT, _In_ UINT);
BOOL WINAPI CheckMenuRadioItem(_In_ HMENU, _In_ UINT, _In_ UINT, _In_ UINT, _In_ UINT);
BOOL WINAPI CheckRadioButton(_In_ HWND, _In_ int, _In_ int, _In_ int);
HWND WINAPI ChildWindowFromPoint(_In_ HWND, _In_ POINT);
HWND WINAPI ChildWindowFromPointEx(_In_ HWND, _In_ POINT, _In_ UINT);
BOOL WINAPI ClientToScreen(_In_ HWND, _Inout_ LPPOINT);
BOOL WINAPI ClipCursor(_In_opt_ LPCRECT);
BOOL WINAPI CloseClipboard(void);
BOOL WINAPI CloseDesktop(_In_ HDESK);
BOOL WINAPI CloseWindow(_In_ HWND);
BOOL WINAPI CloseWindowStation(_In_ HWINSTA);

int
WINAPI
CopyAcceleratorTableA(
  _In_ HACCEL hAccelSrc,
  _Out_writes_to_opt_(cAccelEntries, return) LPACCEL lpAccelDst,
  _In_ int cAccelEntries);

int
WINAPI
CopyAcceleratorTableW(
  _In_ HACCEL hAccelSrc,
  _Out_writes_to_opt_(cAccelEntries, return) LPACCEL lpAccelDst,
  _In_ int cAccelEntries);

#define CopyCursor(c) ((HCURSOR)CopyIcon((HICON)(c)))
HICON WINAPI CopyIcon(_In_ HICON);
HANDLE WINAPI CopyImage(_In_ HANDLE, _In_ UINT, _In_ int, _In_ int, _In_ UINT);
BOOL WINAPI CopyRect(_Out_ LPRECT, _In_ LPCRECT);
int WINAPI CountClipboardFormats(void);

HACCEL
WINAPI
CreateAcceleratorTableA(
  _In_reads_(cAccel) LPACCEL paccel,
  _In_ int cAccel);

HACCEL
WINAPI
CreateAcceleratorTableW(
  _In_reads_(cAccel) LPACCEL paccel,
  _In_ int cAccel);

BOOL WINAPI CreateCaret(_In_ HWND, _In_opt_ HBITMAP, _In_ int, _In_ int);
HCURSOR WINAPI CreateCursor(_In_opt_ HINSTANCE, _In_ int, _In_ int, _In_ int, _In_ int, _In_ CONST VOID*, _In_ CONST VOID*);

#if defined(_WINGDI_) && !defined(NOGDI)

HDESK
WINAPI
CreateDesktopA(
  _In_ LPCSTR lpszDesktop,
  _Reserved_ LPCSTR lpszDevice,
  _Reserved_ DEVMODEA* pDevmode,
  _In_ DWORD dwFlags,
  _In_ ACCESS_MASK dwDesiredAccess,
  _In_opt_ LPSECURITY_ATTRIBUTES lpsa);

HDESK
WINAPI
CreateDesktopW(
  _In_ LPCWSTR lpszDesktop,
  _Reserved_ LPCWSTR lpszDevice,
  _Reserved_ DEVMODEW* pDevmode,
  _In_ DWORD dwFlags,
  _In_ ACCESS_MASK dwDesiredAccess,
  _In_opt_ LPSECURITY_ATTRIBUTES lpsa);

#endif

#define CreateDialogA(h,n,w,f) CreateDialogParamA(h,n,w,f,0)
#define CreateDialogW(h,n,w,f) CreateDialogParamW(h,n,w,f,0)
#define CreateDialogIndirectA(h,t,w,f) CreateDialogIndirectParamA(h,t,w,f,0)
#define CreateDialogIndirectW(h,t,w,f) CreateDialogIndirectParamW(h,t,w,f,0)
HWND WINAPI CreateDialogIndirectParamA(_In_opt_ HINSTANCE, _In_ LPCDLGTEMPLATE, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
HWND WINAPI CreateDialogIndirectParamW(_In_opt_ HINSTANCE, _In_ LPCDLGTEMPLATE, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
HWND WINAPI CreateDialogParamA(_In_opt_ HINSTANCE, _In_ LPCSTR, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
HWND WINAPI CreateDialogParamW(_In_opt_ HINSTANCE, _In_ LPCWSTR, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
HICON WINAPI CreateIcon(_In_opt_ HINSTANCE, _In_ int, _In_ int, _In_ BYTE, _In_ BYTE, _In_ const BYTE*, _In_ const BYTE*);

HICON
WINAPI
CreateIconFromResource(
  _In_reads_bytes_(dwResSize) PBYTE presbits,
  _In_ DWORD dwResSize,
  _In_ BOOL fIcon,
  _In_ DWORD dwVer);

HICON
WINAPI
CreateIconFromResourceEx(
  _In_reads_bytes_(dwResSize) PBYTE presbits,
  _In_ DWORD dwResSize,
  _In_ BOOL fIcon,
  _In_ DWORD dwVer,
  _In_ int cxDesired,
  _In_ int cyDesired,
  _In_ UINT Flags);

HICON WINAPI CreateIconIndirect(_In_ PICONINFO);
HWND WINAPI CreateMDIWindowA(_In_ LPCSTR, _In_ LPCSTR, _In_ DWORD, _In_ int, _In_ int, _In_ int, _In_ int, _In_opt_ HWND, _In_opt_ HINSTANCE, _In_ LPARAM);
HWND WINAPI CreateMDIWindowW(_In_ LPCWSTR, _In_ LPCWSTR, _In_ DWORD, _In_ int, _In_ int, _In_ int, _In_ int, _In_opt_ HWND, _In_opt_ HINSTANCE, _In_ LPARAM);
HMENU WINAPI CreateMenu(void);
HMENU WINAPI CreatePopupMenu(void);

#define CreateWindowA(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExA(0,a,b,c,d,e,f,g,h,i,j,k)
#define CreateWindowW(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExW(0,a,b,c,d,e,f,g,h,i,j,k)

HWND
WINAPI
CreateWindowExA(
  _In_ DWORD dwExStyle,
  _In_opt_ LPCSTR lpClassName,
  _In_opt_ LPCSTR lpWindowName,
  _In_ DWORD dwStyle,
  _In_ int X,
  _In_ int Y,
  _In_ int nWidth,
  _In_ int nHeight,
  _In_opt_ HWND hWndParent,
  _In_opt_ HMENU hMenu,
  _In_opt_ HINSTANCE hInstance,
  _In_opt_ LPVOID lpParam);

HWND
WINAPI
CreateWindowExW(
  _In_ DWORD dwExStyle,
  _In_opt_ LPCWSTR lpClassName,
  _In_opt_ LPCWSTR lpWindowName,
  _In_ DWORD dwStyle,
  _In_ int X,
  _In_ int Y,
  _In_ int nWidth,
  _In_ int nHeight,
  _In_opt_ HWND hWndParent,
  _In_opt_ HMENU hMenu,
  _In_opt_ HINSTANCE hInstance,
  _In_opt_ LPVOID lpParam);

#ifndef NOWINDOWSTATION

HWINSTA
WINAPI
CreateWindowStationA(
  _In_opt_ LPCSTR lpwinsta,
  _In_ DWORD dwFlags,
  _In_ ACCESS_MASK dwDesiredAccess,
  _In_opt_ LPSECURITY_ATTRIBUTES lpsa);

HWINSTA
WINAPI
CreateWindowStationW(
  _In_opt_ LPCWSTR lpwinsta,
  _In_ DWORD dwFlags,
  _In_ ACCESS_MASK dwDesiredAccess,
  _In_opt_ LPSECURITY_ATTRIBUTES lpsa);

#endif

LRESULT WINAPI DefDlgProcA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI DefDlgProcW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
HDWP WINAPI DeferWindowPos(_In_ HDWP, _In_ HWND, _In_opt_ HWND, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);
LRESULT WINAPI DefFrameProcA(_In_ HWND, _In_opt_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI DefFrameProcW(_In_ HWND, _In_opt_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
#define DefHookProc(c,p,lp,h) CallNextHookEx((HHOOK)*h,c,p,lp)
LRESULT WINAPI DefMDIChildProcA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI DefMDIChildProcW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);

#if (_WIN32_WINNT >= 0x0501)
LRESULT
WINAPI
DefRawInputProc(
  _In_reads_(nInput) PRAWINPUT *paRawInput,
  _In_ INT nInput,
  _In_ UINT cbSizeHeader);
#endif

LRESULT WINAPI DefWindowProcA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI DefWindowProcW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI DeleteMenu(_In_ HMENU, _In_ UINT, _In_ UINT);
BOOL WINAPI DeregisterShellHookWindow(_In_ HWND);
BOOL WINAPI DestroyAcceleratorTable(_In_ HACCEL);
BOOL WINAPI DestroyCaret(void);
BOOL WINAPI DestroyCursor(_In_ HCURSOR);
BOOL WINAPI DestroyIcon(_In_ HICON);
BOOL WINAPI DestroyMenu(_In_ HMENU);
BOOL WINAPI DestroyWindow(_In_ HWND);
#define DialogBoxA(i,t,p,f) DialogBoxParamA(i,t,p,f,0)
#define DialogBoxW(i,t,p,f) DialogBoxParamW(i,t,p,f,0)
#define DialogBoxIndirectA(i,t,p,f) DialogBoxIndirectParamA(i,t,p,f,0)
#define DialogBoxIndirectW(i,t,p,f) DialogBoxIndirectParamW(i,t,p,f,0)
INT_PTR WINAPI DialogBoxIndirectParamA(_In_opt_ HINSTANCE, _In_ LPCDLGTEMPLATE, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
INT_PTR WINAPI DialogBoxIndirectParamW(_In_opt_ HINSTANCE, _In_ LPCDLGTEMPLATE, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
INT_PTR WINAPI DialogBoxParamA(_In_opt_ HINSTANCE, _In_ LPCSTR, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
INT_PTR WINAPI DialogBoxParamW(_In_opt_ HINSTANCE, _In_ LPCWSTR, _In_opt_ HWND, _In_opt_ DLGPROC, _In_ LPARAM);
LRESULT WINAPI DispatchMessageA(_In_ const MSG*);
LRESULT WINAPI DispatchMessageW(_In_ const MSG*);
int WINAPI DlgDirListA(_In_ HWND, _Inout_ LPSTR, _In_ int, _In_ int, _In_ UINT);
int WINAPI DlgDirListW(_In_ HWND, _Inout_ LPWSTR, _In_ int, _In_ int, _In_ UINT);
int WINAPI DlgDirListComboBoxA(_In_ HWND, _Inout_ LPSTR, _In_ int, _In_ int, _In_ UINT);
int WINAPI DlgDirListComboBoxW(_In_ HWND, _Inout_ LPWSTR, _In_ int, _In_ int, _In_ UINT);

BOOL
WINAPI
DlgDirSelectComboBoxExA(
  _In_ HWND hwndDlg,
  _Out_writes_(cchOut) LPSTR lpString,
  _In_ int cchOut,
  _In_ int idComboBox);

BOOL
WINAPI
DlgDirSelectComboBoxExW(
  _In_ HWND hwndDlg,
  _Out_writes_(cchOut) LPWSTR lpString,
  _In_ int cchOut,
  _In_ int idComboBox);

BOOL
WINAPI
DlgDirSelectExA(
  _In_ HWND hwndDlg,
  _Out_writes_(chCount) LPSTR lpString,
  _In_ int chCount,
  _In_ int idListBox);

BOOL
WINAPI
DlgDirSelectExW(
  _In_ HWND hwndDlg,
  _Out_writes_(chCount) LPWSTR lpString,
  _In_ int chCount,
  _In_ int idListBox);

BOOL WINAPI DragDetect(_In_ HWND, _In_ POINT);
DWORD WINAPI DragObject(_In_ HWND, _In_ HWND, _In_ UINT, _In_ ULONG_PTR, _In_opt_ HCURSOR);
BOOL WINAPI DrawAnimatedRects(_In_opt_ HWND, _In_ int, _In_ LPCRECT, _In_ LPCRECT);
BOOL WINAPI DrawCaption(_In_ HWND, _In_ HDC, _In_ LPCRECT, _In_ UINT);
BOOL WINAPI DrawEdge(_In_ HDC, _Inout_ LPRECT, _In_ UINT, _In_ UINT);
BOOL WINAPI DrawFocusRect(_In_ HDC, _In_ LPCRECT);
BOOL WINAPI DrawFrameControl(_In_ HDC, _Inout_ LPRECT, _In_ UINT, _In_ UINT);
BOOL WINAPI DrawIcon(_In_ HDC, _In_ int, _In_ int, _In_ HICON);
BOOL WINAPI DrawIconEx(_In_ HDC, _In_ int, _In_ int, _In_ HICON, _In_ int, _In_ int, _In_ UINT, _In_opt_ HBRUSH, _In_ UINT);
BOOL WINAPI DrawMenuBar(_In_ HWND);
DWORD WINAPI DrawMenuBarTemp(HWND,HDC,LPRECT,HMENU,HFONT);
BOOL WINAPI DrawStateA(_In_ HDC, _In_opt_ HBRUSH, _In_opt_ DRAWSTATEPROC, _In_ LPARAM, _In_ WPARAM, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);
BOOL WINAPI DrawStateW(_In_ HDC, _In_opt_ HBRUSH, _In_opt_ DRAWSTATEPROC, _In_ LPARAM, _In_ WPARAM, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);

_Success_(return)
int
WINAPI
DrawTextA(
  _In_ HDC hdc,
  _At_((LPSTR)lpchText, _Inout_updates_opt_(cchText)) LPCSTR lpchText,
  _In_ int cchText,
  _Inout_ LPRECT lprc,
  _In_ UINT format);

_Success_(return)
int
WINAPI
DrawTextW(
  _In_ HDC hdc,
  _At_((LPWSTR)lpchText, _Inout_updates_opt_(cchText)) LPCWSTR lpchText,
  _In_ int cchText,
  _Inout_ LPRECT lprc,
  _In_ UINT format);

int
WINAPI
DrawTextExA(
  _In_ HDC hdc,
  _Inout_updates_opt_(cchText) LPSTR lpchText,
  _In_ int cchText,
  _Inout_ LPRECT lprc,
  _In_ UINT format,
  _In_opt_ LPDRAWTEXTPARAMS lpdtp);

int
WINAPI
DrawTextExW(
  _In_ HDC hdc,
  _Inout_updates_opt_(cchText) LPWSTR lpchText,
  _In_ int cchText,
  _Inout_ LPRECT lprc,
  _In_ UINT format,
  _In_opt_ LPDRAWTEXTPARAMS lpdtp);

BOOL WINAPI EmptyClipboard(void);
BOOL WINAPI EnableMenuItem(_In_ HMENU, _In_ UINT, _In_ UINT);
BOOL WINAPI EnableScrollBar(_In_ HWND, _In_ UINT, _In_ UINT);
BOOL WINAPI EnableWindow(_In_ HWND, _In_ BOOL);
BOOL WINAPI EndDeferWindowPos(_In_ HDWP);
BOOL WINAPI EndDialog(_In_ HWND, _In_ INT_PTR);
BOOL WINAPI EndMenu(void);
BOOL WINAPI EndPaint(_In_ HWND, _In_ const PAINTSTRUCT*);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI EndTask(_In_ HWND, _In_ BOOL, _In_ BOOL);
#endif
BOOL WINAPI EnumChildWindows(_In_opt_ HWND, _In_ WNDENUMPROC, _In_ LPARAM);
UINT WINAPI EnumClipboardFormats(_In_ UINT);
BOOL WINAPI EnumDesktopsA(_In_opt_ HWINSTA, _In_ DESKTOPENUMPROCA, _In_ LPARAM);
BOOL WINAPI EnumDesktopsW(_In_opt_ HWINSTA, _In_ DESKTOPENUMPROCW, _In_ LPARAM);
BOOL WINAPI EnumDesktopWindows(_In_opt_ HDESK, _In_ WNDENUMPROC, _In_ LPARAM);
BOOL WINAPI EnumDisplayMonitors(_In_opt_ HDC, _In_opt_ LPCRECT, _In_ MONITORENUMPROC, _In_ LPARAM);
#if defined(_WINGDI_) && !defined(NOGDI)
BOOL WINAPI EnumDisplaySettingsA(_In_opt_ LPCSTR, _In_ DWORD, _Inout_ PDEVMODEA);
BOOL WINAPI EnumDisplaySettingsW(_In_opt_ LPCWSTR, _In_ DWORD, _Inout_ PDEVMODEW);
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
BOOL WINAPI EnumDisplaySettingsExA(_In_opt_ LPCSTR, _In_ DWORD, _Inout_ LPDEVMODEA, _In_ DWORD);
BOOL WINAPI EnumDisplaySettingsExW(_In_opt_ LPCWSTR, _In_ DWORD, _Inout_ LPDEVMODEW, _In_ DWORD);
#endif
BOOL WINAPI EnumDisplayDevicesA(_In_opt_ LPCSTR, _In_ DWORD, _Inout_ PDISPLAY_DEVICEA, _In_ DWORD);
BOOL WINAPI EnumDisplayDevicesW(_In_opt_ LPCWSTR, _In_ DWORD, _Inout_ PDISPLAY_DEVICEW, _In_ DWORD);
#endif
int WINAPI EnumPropsA(_In_ HWND, _In_ PROPENUMPROCA);
int WINAPI EnumPropsW(_In_ HWND, _In_ PROPENUMPROCW);
int WINAPI EnumPropsExA(_In_ HWND, _In_ PROPENUMPROCEXA, _In_ LPARAM lParam);
int WINAPI EnumPropsExW(_In_ HWND, _In_ PROPENUMPROCEXW, _In_ LPARAM lParam);
#define EnumTaskWindows(h,f,p) EnumThreadWindows((DWORD)h,f,p)
BOOL WINAPI EnumThreadWindows(_In_ DWORD, _In_ WNDENUMPROC, _In_ LPARAM);
BOOL WINAPI EnumWindows(_In_ WNDENUMPROC lpEnumFunc, _In_ LPARAM lParam);
BOOL WINAPI EnumWindowStationsA(_In_ WINSTAENUMPROCA, _In_ LPARAM lParam);
BOOL WINAPI EnumWindowStationsW(_In_ WINSTAENUMPROCW, _In_ LPARAM lParam);
BOOL WINAPI EqualRect(_In_ LPCRECT, _In_ LPCRECT);
#define ExitWindows(r,c) ExitWindowsEx(EWX_LOGOFF,0)
BOOL WINAPI ExitWindowsEx(_In_ UINT, _In_ DWORD);
HWND WINAPI FindWindowA(_In_opt_ LPCSTR, _In_opt_ LPCSTR);
HWND WINAPI FindWindowW(_In_opt_ LPCWSTR, _In_opt_ LPCWSTR);
HWND WINAPI FindWindowExA(_In_opt_ HWND, _In_opt_ HWND, _In_opt_ LPCSTR, _In_opt_ LPCSTR);
HWND WINAPI FindWindowExW(_In_opt_ HWND, _In_opt_ HWND, _In_opt_ LPCWSTR, _In_opt_ LPCWSTR);
BOOL WINAPI FlashWindow(_In_ HWND, _In_ BOOL);
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
BOOL WINAPI FlashWindowEx(_In_ PFLASHWINFO);
#endif
int WINAPI FrameRect(_In_ HDC, _In_ LPCRECT, _In_ HBRUSH);
HWND WINAPI GetActiveWindow(void);
HWND WINAPI GetAncestor(_In_ HWND, _In_ UINT);
SHORT WINAPI GetAsyncKeyState(_In_ int);
HWND WINAPI GetCapture(void);
UINT WINAPI GetCaretBlinkTime(void);
BOOL WINAPI GetCaretPos(_Out_ LPPOINT);
BOOL WINAPI GetClassInfoA(_In_opt_ HINSTANCE, _In_ LPCSTR, _Out_ LPWNDCLASSA);
BOOL WINAPI GetClassInfoExA(_In_opt_ HINSTANCE, _In_ LPCSTR, _Out_ LPWNDCLASSEXA);
BOOL WINAPI GetClassInfoW(_In_opt_ HINSTANCE, _In_ LPCWSTR, _Out_ LPWNDCLASSW);
BOOL WINAPI GetClassInfoExW(_In_opt_ HINSTANCE, _In_ LPCWSTR, _Out_ LPWNDCLASSEXW);
DWORD WINAPI GetClassLongA(_In_ HWND, _In_ int);
DWORD WINAPI GetClassLongW(_In_ HWND, _In_ int);
#ifdef _WIN64
ULONG_PTR WINAPI GetClassLongPtrA(_In_ HWND, _In_ int);
ULONG_PTR WINAPI GetClassLongPtrW(_In_ HWND, _In_ int);
#else
#define GetClassLongPtrA GetClassLongA
#define GetClassLongPtrW GetClassLongW
#endif

int
WINAPI
GetClassNameA(
  _In_ HWND hWnd,
  _Out_writes_to_(nMaxCount, return) LPSTR lpClassName,
  _In_ int nMaxCount);

int
WINAPI
GetClassNameW(
  _In_ HWND hWnd,
  _Out_writes_to_(nMaxCount, return) LPWSTR lpClassName,
  _In_ int nMaxCount);

WORD WINAPI GetClassWord(_In_ HWND, _In_ int);
BOOL WINAPI GetClientRect(_In_ HWND, _Out_ LPRECT);
HANDLE WINAPI GetClipboardData(_In_ UINT);

int
WINAPI
GetClipboardFormatNameA(
  _In_ UINT format,
  _Out_writes_(cchMaxCount) LPSTR lpszFormatName,
  _In_ int cchMaxCount);

int
WINAPI
GetClipboardFormatNameW(
  _In_ UINT format,
  _Out_writes_(cchMaxCount) LPWSTR lpszFormatName,
  _In_ int cchMaxCount);

HWND WINAPI GetClipboardOwner(void);
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
DWORD WINAPI GetClipboardSequenceNumber(void);
#endif
HWND WINAPI GetClipboardViewer(void);
BOOL WINAPI GetClipCursor(_Out_ LPRECT);
BOOL WINAPI GetCursorPos(_Out_ LPPOINT);
HDC WINAPI GetDC(_In_opt_ HWND);
HDC WINAPI GetDCEx(_In_opt_ HWND, _In_opt_ HRGN, _In_ DWORD);
HWND WINAPI GetDesktopWindow(void);
LONG WINAPI GetDialogBaseUnits(void);
int WINAPI GetDlgCtrlID(_In_ HWND);
HWND WINAPI GetDlgItem(_In_opt_ HWND, _In_ int);
UINT WINAPI GetDlgItemInt(_In_ HWND, _In_ int, _Out_opt_ PBOOL, _In_ BOOL);

_Ret_range_(0, cchMax)
UINT
WINAPI
GetDlgItemTextA(
  _In_ HWND hDlg,
  _In_ int nIDDlgItem,
  _Out_writes_(cchMax) LPSTR lpString,
  _In_ int cchMax);

_Ret_range_(0, cchMax)
UINT
WINAPI
GetDlgItemTextW(
  _In_ HWND hDlg,
  _In_ int nIDDlgItem,
  _Out_writes_(cchMax) LPWSTR lpString,
  _In_ int cchMax);

UINT WINAPI GetDoubleClickTime(void);
HWND WINAPI GetFocus(void);
HWND WINAPI GetForegroundWindow(void);
#if (_WIN32_WINNT >= 0x0500)
DWORD WINAPI GetGuiResources(_In_ HANDLE, _In_ DWORD);
#endif
BOOL WINAPI GetIconInfo(_In_ HICON, _Out_ PICONINFO);
BOOL WINAPI GetIconInfoExA(_In_ HICON, _Inout_ ICONINFOEXA*);
BOOL WINAPI GetIconInfoExW(_In_ HICON, _Inout_ ICONINFOEXW*);
BOOL WINAPI GetInputState(void);
UINT WINAPI GetKBCodePage(void);
HKL WINAPI GetKeyboardLayout(_In_ DWORD);

UINT
WINAPI
GetKeyboardLayoutList(
  _In_ int nBuff,
  _Out_writes_to_opt_(nBuff, return) HKL FAR *lpList);

BOOL WINAPI GetKeyboardLayoutNameA(_Out_writes_(KL_NAMELENGTH) LPSTR);
BOOL WINAPI GetKeyboardLayoutNameW(_Out_writes_(KL_NAMELENGTH) LPWSTR);

_Check_return_
BOOL
WINAPI
GetKeyboardState(
  _Out_writes_(256) PBYTE lpKeyState);

int WINAPI GetKeyboardType(_In_ int);

int
WINAPI
GetKeyNameTextA(
  _In_ LONG lParam,
  _Out_writes_(cchSize) LPSTR lpString,
  _In_ int cchSize);

int
WINAPI
GetKeyNameTextW(
  _In_ LONG lParam,
  _Out_writes_(cchSize) LPWSTR lpString,
  _In_ int cchSize);

SHORT WINAPI GetKeyState(_In_ int);
HWND WINAPI GetLastActivePopup(_In_ HWND);
HMENU WINAPI GetMenu(_In_ HWND);
LONG WINAPI GetMenuCheckMarkDimensions(void);
DWORD WINAPI GetMenuContextHelpId(_In_ HMENU);
UINT WINAPI GetMenuDefaultItem(_In_ HMENU hMenu, _In_ UINT fByPos, _In_ UINT gmdiFlags);
int WINAPI GetMenuItemCount(_In_opt_ HMENU);
UINT WINAPI GetMenuItemID(_In_ HMENU, _In_ int);
BOOL WINAPI GetMenuItemInfoA(_In_ HMENU, _In_ UINT, _In_ BOOL, _Inout_ LPMENUITEMINFOA);
BOOL WINAPI GetMenuItemInfoW(_In_ HMENU, _In_ UINT, _In_ BOOL, _Inout_ LPMENUITEMINFOW);
BOOL WINAPI GetMenuItemRect(_In_opt_ HWND, _In_ HMENU, _In_ UINT, _Out_ LPRECT);
UINT WINAPI GetMenuState(_In_ HMENU, _In_ UINT, _In_ UINT);

int
WINAPI
GetMenuStringA(
  _In_ HMENU hMenu,
  _In_ UINT uIDItem,
  _Out_writes_opt_(cchMax) LPSTR lpString,
  _In_ int cchMax,
  _In_ UINT flags);

int
WINAPI
GetMenuStringW(
  _In_ HMENU hMenu,
  _In_ UINT uIDItem,
  _Out_writes_opt_(cchMax) LPWSTR lpString,
  _In_ int cchMax,
  _In_ UINT flags);

BOOL WINAPI GetMessageA(_Out_ LPMSG, _In_opt_ HWND, _In_ UINT, _In_ UINT);
BOOL WINAPI GetMessageW(_Out_ LPMSG, _In_opt_ HWND, _In_ UINT, _In_ UINT);

LPARAM WINAPI GetMessageExtraInfo(void);
DWORD WINAPI GetMessagePos(void);
LONG WINAPI GetMessageTime(void);

#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0490)
int
WINAPI
GetMouseMovePointsEx(
  _In_ UINT cbSize,
  _In_ LPMOUSEMOVEPOINT lppt,
  _Out_writes_(nBufPoints) LPMOUSEMOVEPOINT lpptBuf,
  _In_ int nBufPoints,
  _In_ DWORD resolution);
#endif

HWND WINAPI GetNextDlgGroupItem(_In_ HWND, _In_opt_ HWND, _In_ BOOL);
HWND WINAPI GetNextDlgTabItem(_In_ HWND, _In_opt_ HWND, _In_ BOOL);
#define GetNextWindow(h,c) GetWindow(h,c)
HWND WINAPI GetOpenClipboardWindow(void);
HWND WINAPI GetParent(_In_ HWND);

int
WINAPI
GetPriorityClipboardFormat(
  _In_reads_(cFormats) UINT *paFormatPriorityList,
  _In_ int cFormats);

HANDLE WINAPI GetPropA(_In_ HWND, _In_ LPCSTR);
HANDLE WINAPI GetPropW(_In_ HWND, _In_ LPCWSTR);

#if (_WIN32_WINNT >= 0x0501)

UINT
WINAPI
GetRawInputBuffer(
  _Out_writes_bytes_opt_(*pcbSize) PRAWINPUT pData,
  _Inout_ PUINT pcbSize,
  _In_ UINT cbSizeHeader);

UINT
WINAPI
GetRawInputData(
  _In_ HRAWINPUT hRawInput,
  _In_ UINT uiCommand,
  _Out_writes_bytes_to_opt_(*pcbSize, return) LPVOID pData,
  _Inout_ PUINT pcbSize,
  _In_ UINT cbSizeHeader);

UINT
WINAPI
GetRawInputDeviceInfoA(
  _In_opt_ HANDLE hDevice,
  _In_ UINT uiCommand,
  _Inout_updates_bytes_to_opt_(*pcbSize, *pcbSize) LPVOID pData,
  _Inout_ PUINT pcbSize);

UINT
WINAPI
GetRawInputDeviceInfoW(
  _In_opt_ HANDLE hDevice,
  _In_ UINT uiCommand,
  _Inout_updates_bytes_to_opt_(*pcbSize, *pcbSize) LPVOID pData,
  _Inout_ PUINT pcbSize);

UINT
WINAPI
GetRawInputDeviceList(
  _Out_writes_opt_(*puiNumDevices) PRAWINPUTDEVICELIST pRawInputDeviceList,
  _Inout_ PUINT puiNumDevices,
  _In_ UINT cbSize);

UINT
WINAPI
GetRegisteredRawInputDevices(
  _Out_writes_opt_(*puiNumDevices) PRAWINPUTDEVICE pRawInputDevices,
  _Inout_ PUINT puiNumDevices,
  _In_ UINT cbSize);

#endif /* (_WIN32_WINNT >= 0x0501) */

DWORD WINAPI GetQueueStatus(_In_ UINT);
BOOL WINAPI GetScrollInfo(_In_ HWND, _In_ int, _Inout_ LPSCROLLINFO);
int WINAPI GetScrollPos(_In_ HWND, _In_ int);
BOOL WINAPI GetScrollRange(_In_ HWND, _In_ int, _Out_ LPINT, _Out_ LPINT);
#if (_WIN32_WINNT >= 0x0500)
HWND WINAPI GetShellWindow(void);
#endif
HMENU WINAPI GetSubMenu(_In_ HMENU, _In_ int);
DWORD WINAPI GetSysColor(_In_ int);
HBRUSH WINAPI GetSysColorBrush(_In_ int);
#define GetSysModalWindow() (NULL)
HMENU WINAPI GetSystemMenu(_In_ HWND, _In_ BOOL);
int WINAPI GetSystemMetrics(_In_ int);

DWORD
WINAPI
GetTabbedTextExtentA(
  _In_ HDC hdc,
  _In_reads_(chCount) LPCSTR lpString,
  _In_ int chCount,
  _In_ int nTabPositions,
  _In_reads_opt_(nTabPositions) CONST INT *lpnTabStopPositions);

DWORD
WINAPI
GetTabbedTextExtentW(
  _In_ HDC hdc,
  _In_reads_(chCount) LPCWSTR lpString,
  _In_ int chCount,
  _In_ int nTabPositions,
  _In_reads_opt_(nTabPositions) CONST INT *lpnTabStopPositions);

LONG WINAPI GetWindowLongA(_In_ HWND, _In_ int);
LONG WINAPI GetWindowLongW(_In_ HWND, _In_ int);
#ifdef _WIN64
LONG_PTR WINAPI GetWindowLongPtrA(_In_ HWND, _In_ int);
LONG_PTR WINAPI GetWindowLongPtrW(_In_ HWND, _In_ int);
#else
#define GetWindowLongPtrA GetWindowLongA
#define GetWindowLongPtrW GetWindowLongW
#endif
HDESK WINAPI GetThreadDesktop(_In_ DWORD);
HWND WINAPI GetTopWindow(_In_opt_ HWND);
BOOL WINAPI GetUpdateRect(_In_ HWND, _Out_opt_ LPRECT, _In_ BOOL);
int WINAPI GetUpdateRgn(_In_ HWND, _In_ HRGN, _In_ BOOL);

BOOL
WINAPI
GetUserObjectInformationA(
  _In_ HANDLE hObj,
  _In_ int nIndex,
  _Out_writes_bytes_opt_(nLength) PVOID pvInfo,
  _In_ DWORD nLength,
  _Out_opt_ LPDWORD lpnLengthNeeded);

BOOL
WINAPI
GetUserObjectInformationW(
  _In_ HANDLE hObj,
  _In_ int nIndex,
  _Out_writes_bytes_opt_(nLength) PVOID pvInfo,
  _In_ DWORD nLength,
  _Out_opt_ LPDWORD lpnLengthNeeded);

BOOL
WINAPI
GetUserObjectSecurity(
  _In_ HANDLE hObj,
  _In_ PSECURITY_INFORMATION pSIRequested,
  _Out_writes_bytes_opt_(nLength) PSECURITY_DESCRIPTOR pSID,
  _In_ DWORD nLength,
  _Out_ LPDWORD lpnLengthNeeded);

HWND WINAPI GetWindow(_In_ HWND, _In_ UINT);
DWORD WINAPI GetWindowContextHelpId(_In_ HWND);
HDC WINAPI GetWindowDC(_In_opt_ HWND);
BOOL WINAPI GetWindowPlacement(_In_ HWND, _Inout_ WINDOWPLACEMENT*);
BOOL WINAPI GetWindowRect(_In_ HWND, _Out_ LPRECT);
int WINAPI GetWindowRgn(_In_ HWND, _In_ HRGN);
#define GetWindowTask(hWnd) ((HANDLE)GetWindowThreadProcessId(hWnd, NULL))

_Ret_range_(0, nMaxCount)
int
WINAPI
GetWindowTextA(
  _In_ HWND hWnd,
  _Out_writes_(nMaxCount) LPSTR lpString,
  _In_ int nMaxCount);

_Ret_range_(0, nMaxCount)
int
WINAPI
GetWindowTextW(
  _In_ HWND hWnd,
  _Out_writes_(nMaxCount) LPWSTR lpString,
  _In_ int nMaxCount);

int WINAPI GetWindowTextLengthA(_In_ HWND);
int WINAPI GetWindowTextLengthW(_In_ HWND);
WORD WINAPI GetWindowWord(_In_ HWND, _In_ int);

BOOL
WINAPI
GetAltTabInfoA(
  _In_opt_ HWND hwnd,
  _In_ int iItem,
  _Inout_ PALTTABINFO pati,
  _Out_writes_opt_(cchItemText) LPSTR pszItemText,
  _In_ UINT cchItemText);

BOOL
WINAPI
GetAltTabInfoW(
  _In_opt_ HWND hwnd,
  _In_ int iItem,
  _Inout_ PALTTABINFO pati,
  _Out_writes_opt_(cchItemText) LPWSTR pszItemText,
  _In_ UINT cchItemText);

BOOL WINAPI GetComboBoxInfo(_In_ HWND, _Inout_ PCOMBOBOXINFO);
BOOL WINAPI GetCursorInfo(_Inout_ PCURSORINFO);
#if (WINVER >= 0x0500)
BOOL WINAPI GetGUIThreadInfo(_In_ DWORD, _Inout_ LPGUITHREADINFO);
#endif
BOOL WINAPI GetLastInputInfo(_Out_ PLASTINPUTINFO);
DWORD WINAPI GetListBoxInfo(_In_ HWND);
BOOL WINAPI GetMenuBarInfo(_In_ HWND, _In_ LONG, _In_ LONG, _Inout_ PMENUBARINFO);
BOOL WINAPI GetMenuInfo(_In_ HMENU, _Inout_ LPMENUINFO);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI GetProcessDefaultLayout(_Out_ DWORD*);
#endif
BOOL WINAPI GetScrollBarInfo(_In_ HWND, _In_ LONG, _Inout_ PSCROLLBARINFO);
BOOL WINAPI GetTitleBarInfo(_In_ HWND, _Inout_ PTITLEBARINFO);
BOOL WINAPI GetWindowInfo(_In_ HWND, _Inout_ PWINDOWINFO);
BOOL WINAPI GetMonitorInfoA(_In_ HMONITOR, _Inout_ LPMONITORINFO);
BOOL WINAPI GetMonitorInfoW(_In_ HMONITOR, _Inout_ LPMONITORINFO);

#if (_WIN32_WINNT >= _WIN32_WINNT_VISTA)
#define USER_DEFAULT_SCREEN_DPI 96
#endif /* _WIN32_WINNT >= _WIN32_WINNT_VISTA */

#if (_WIN32_WINNT >= 0x0605) /* Windows 10 pre-Threshold */
UINT WINAPI GetDpiForSystem(VOID);
UINT WINAPI GetDpiForWindow(_In_ HWND hwnd);
#endif /* _WIN32_WINNT >= 0x0605 */

UINT
WINAPI
GetWindowModuleFileNameA(
  _In_ HWND hwnd,
  _Out_writes_to_(cchFileNameMax, return) LPSTR pszFileName,
  _In_ UINT cchFileNameMax);

UINT
WINAPI
GetWindowModuleFileNameW(
  _In_ HWND hwnd,
  _Out_writes_to_(cchFileNameMax, return) LPWSTR pszFileName,
  _In_ UINT cchFileNameMax);

BOOL WINAPI GrayStringA(_In_ HDC, _In_opt_ HBRUSH, _In_opt_ GRAYSTRINGPROC, _In_ LPARAM, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI GrayStringW(_In_ HDC, _In_opt_ HBRUSH, _In_opt_ GRAYSTRINGPROC, _In_ LPARAM, _In_ int, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI HideCaret(_In_opt_ HWND);
BOOL WINAPI HiliteMenuItem(_In_ HWND, _In_ HMENU, _In_ UINT, _In_ UINT);
BOOL WINAPI InflateRect(_Inout_ LPRECT, _In_ int, _In_ int);
BOOL WINAPI InSendMessage(void);
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
DWORD WINAPI InSendMessageEx(_Reserved_ LPVOID);
#endif
BOOL WINAPI InsertMenuA(_In_ HMENU, _In_ UINT, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCSTR);
BOOL WINAPI InsertMenuW(_In_ HMENU, _In_ UINT, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCWSTR);
BOOL WINAPI InsertMenuItemA(_In_ HMENU, _In_ UINT, _In_ BOOL, _In_ LPCMENUITEMINFOA);
BOOL WINAPI InsertMenuItemW(_In_ HMENU, _In_ UINT, _In_ BOOL, _In_ LPCMENUITEMINFOW);

INT
WINAPI
InternalGetWindowText(
  _In_ HWND hWnd,
  _Out_writes_to_(cchMaxCount, return + 1) LPWSTR pString,
  _In_ int cchMaxCount);

BOOL WINAPI IntersectRect(_Out_ LPRECT, _In_ LPCRECT, _In_ LPCRECT);
BOOL WINAPI InvalidateRect(_In_opt_ HWND, _In_opt_ LPCRECT, _In_ BOOL);
BOOL WINAPI InvalidateRgn(_In_ HWND, _In_opt_ HRGN, _In_ BOOL);
BOOL WINAPI InvertRect(_In_ HDC, _In_ LPCRECT);
BOOL WINAPI IsCharAlphaA(_In_ CHAR ch);
BOOL WINAPI IsCharAlphaNumericA(_In_ CHAR);
BOOL WINAPI IsCharAlphaNumericW(_In_ WCHAR);
BOOL WINAPI IsCharAlphaW( _In_ WCHAR);
BOOL WINAPI IsCharLowerA(_In_ CHAR);
BOOL WINAPI IsCharLowerW(_In_ WCHAR);
BOOL WINAPI IsCharUpperA(_In_ CHAR);
BOOL WINAPI IsCharUpperW(_In_ WCHAR);
BOOL WINAPI IsChild(_In_ HWND, _In_ HWND);
BOOL WINAPI IsClipboardFormatAvailable(_In_ UINT);
BOOL WINAPI IsDialogMessageA(_In_ HWND, _In_ LPMSG);
BOOL WINAPI IsDialogMessageW(_In_ HWND, _In_ LPMSG);
UINT WINAPI IsDlgButtonChecked(_In_ HWND, _In_ int);
#if(_WIN32_WINNT >= 0x0501)
BOOL WINAPI IsGUIThread(_In_ BOOL);
#endif
#if(_WIN32_WINNT >= 0x0500)
BOOL WINAPI IsHungAppWindow(_In_ HWND);
#endif
BOOL WINAPI IsIconic(_In_ HWND);
BOOL WINAPI IsMenu(_In_ HMENU);
BOOL WINAPI IsRectEmpty(_In_ LPCRECT);
BOOL WINAPI IsWindow(_In_opt_ HWND);
BOOL WINAPI IsWindowEnabled(_In_ HWND);
BOOL WINAPI IsWindowUnicode(_In_ HWND);
BOOL WINAPI IsWindowVisible(_In_ HWND);
#if (_WIN32_WINNT >= 0x0501)
BOOL WINAPI IsWinEventHookInstalled(_In_ DWORD);
#endif
BOOL WINAPI IsZoomed(_In_ HWND);
VOID WINAPI keybd_event(_In_ BYTE, _In_ BYTE, _In_ DWORD, _In_ ULONG_PTR);
BOOL WINAPI KillTimer(_In_opt_ HWND, _In_ UINT_PTR);
BOOL WINAPI KillSystemTimer(HWND,UINT_PTR);
HACCEL WINAPI LoadAcceleratorsA(_In_opt_ HINSTANCE, _In_ LPCSTR);
HACCEL WINAPI LoadAcceleratorsW(_In_opt_ HINSTANCE, _In_ LPCWSTR);
HBITMAP WINAPI LoadBitmapA(_In_opt_ HINSTANCE, _In_ LPCSTR);
HBITMAP WINAPI LoadBitmapW(_In_opt_ HINSTANCE, _In_ LPCWSTR);
HCURSOR WINAPI LoadCursorA(_In_opt_ HINSTANCE, _In_ LPCSTR);
HCURSOR WINAPI LoadCursorW(_In_opt_ HINSTANCE, _In_ LPCWSTR);
HCURSOR WINAPI LoadCursorFromFileA(_In_ LPCSTR);
HCURSOR WINAPI LoadCursorFromFileW(_In_ LPCWSTR);
HICON WINAPI LoadIconA(_In_opt_ HINSTANCE hInstance, _In_ LPCSTR lpIconName);
HICON WINAPI LoadIconW(_In_opt_ HINSTANCE hInstance, _In_ LPCWSTR lpIconName);
HANDLE WINAPI LoadImageA(_In_opt_ HINSTANCE hInst, _In_ LPCSTR name, _In_ UINT type, _In_ int cx, _In_ int cy, _In_ UINT fuLoad);
HANDLE WINAPI LoadImageW(_In_opt_ HINSTANCE hInst, _In_ LPCWSTR name, _In_ UINT type, _In_ int cx, _In_ int cy, _In_ UINT fuLoad);
HKL WINAPI LoadKeyboardLayoutA(_In_ LPCSTR, _In_ UINT);
HKL WINAPI LoadKeyboardLayoutW(_In_ LPCWSTR, _In_ UINT);
HMENU WINAPI LoadMenuA(_In_opt_ HINSTANCE, _In_ LPCSTR);
HMENU WINAPI LoadMenuIndirectA(_In_ const MENUTEMPLATE*);
HMENU WINAPI LoadMenuIndirectW(_In_ const MENUTEMPLATE*);
HMENU WINAPI LoadMenuW(_In_opt_ HINSTANCE, _In_ LPCWSTR);

int
WINAPI
LoadStringA(
  _In_opt_ HINSTANCE hInstance,
  _In_ UINT uID,
  _Out_writes_to_(cchBufferMax, return + 1) LPSTR lpBuffer,
  _In_ int cchBufferMax);

int
WINAPI
LoadStringW(
  _In_opt_ HINSTANCE hInstance,
  _In_ UINT uID,
  _Out_writes_to_(cchBufferMax, return + 1) LPWSTR lpBuffer,
  _In_ int cchBufferMax);

BOOL WINAPI LockWindowUpdate(_In_opt_ HWND);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI LockWorkStation(void);
#endif

typedef struct {
  WORD Reserved;
  WORD ResType;
  WORD ResCount;
} NEWHEADER;

int WINAPI LookupIconIdFromDirectory(_In_reads_bytes_(sizeof(NEWHEADER)) PBYTE, _In_ BOOL);
int WINAPI LookupIconIdFromDirectoryEx(_In_reads_bytes_(sizeof(NEWHEADER)) PBYTE, _In_ BOOL, _In_ int, _In_ int, _In_ UINT);
BOOL WINAPI MapDialogRect(_In_ HWND, _Inout_ LPRECT);
UINT WINAPI MapVirtualKeyA(_In_ UINT, _In_ UINT);
UINT WINAPI MapVirtualKeyExA(_In_ UINT, _In_ UINT, _In_opt_ HKL);
UINT WINAPI MapVirtualKeyExW(_In_ UINT, _In_ UINT, _In_opt_ HKL);
UINT WINAPI MapVirtualKeyW(_In_ UINT, _In_ UINT);

int
WINAPI
MapWindowPoints(
  _In_opt_ HWND hWndFrom,
  _In_opt_ HWND hWndTo,
  _Inout_updates_(cPoints) LPPOINT lpPoints,
  _In_ UINT cPoints);

int WINAPI MenuItemFromPoint(_In_opt_ HWND, _In_ HMENU, _In_ POINT);
BOOL WINAPI MessageBeep(_In_ UINT uType);
int WINAPI MessageBoxA(_In_opt_ HWND hWnd, _In_opt_ LPCSTR lpText, _In_opt_ LPCSTR lpCaption, _In_ UINT uType);
int WINAPI MessageBoxW(_In_opt_ HWND hWnd, _In_opt_ LPCWSTR lpText, _In_opt_ LPCWSTR lpCaption, _In_ UINT uType);
int WINAPI MessageBoxExA(_In_opt_ HWND hWnd, _In_opt_ LPCSTR lpText, _In_opt_ LPCSTR lpCaption, _In_ UINT uType, _In_ WORD wLanguageId);
int WINAPI MessageBoxExW(_In_opt_ HWND hWnd, _In_opt_ LPCWSTR lpText, _In_opt_ LPCWSTR lpCaption, _In_ UINT uType, _In_ WORD wLanguageId);
int WINAPI MessageBoxIndirectA(_In_ CONST MSGBOXPARAMSA* lpmbp);
int WINAPI MessageBoxIndirectW(_In_ CONST MSGBOXPARAMSW* lpmbp);
BOOL WINAPI ModifyMenuA(_In_ HMENU, _In_ UINT, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCSTR);
BOOL WINAPI ModifyMenuW(_In_ HMENU, _In_ UINT, _In_ UINT, _In_ UINT_PTR, _In_opt_ LPCWSTR);
HMONITOR WINAPI MonitorFromPoint(_In_ POINT, _In_ DWORD);
HMONITOR WINAPI MonitorFromRect(_In_ LPCRECT, _In_ DWORD);
HMONITOR WINAPI MonitorFromWindow(_In_ HWND, _In_ DWORD);
void WINAPI mouse_event(_In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ ULONG_PTR);
BOOL WINAPI MoveWindow(_In_ HWND, _In_ int, _In_ int, _In_ int, _In_ int, _In_ BOOL);

DWORD
WINAPI
MsgWaitForMultipleObjects(
  _In_ DWORD nCount,
  _In_reads_opt_(nCount) CONST HANDLE *pHandles,
  _In_ BOOL fWaitAll,
  _In_ DWORD dwMilliseconds,
  _In_ DWORD dwWakeMask);

DWORD
WINAPI
MsgWaitForMultipleObjectsEx(
  _In_ DWORD nCount,
  _In_reads_opt_(nCount) CONST HANDLE *pHandles,
  _In_ DWORD dwMilliseconds,
  _In_ DWORD dwWakeMask,
  _In_ DWORD dwFlags);

#if (WINVER >= 0x0500)
void WINAPI NotifyWinEvent(_In_ DWORD, _In_ HWND, _In_ LONG, _In_ LONG);
#endif
DWORD WINAPI OemKeyScan(_In_ WORD);

BOOL
WINAPI
OemToCharA(
  _In_ LPCSTR pSrc,
  _Out_writes_(_Inexpressible_(strlen(pSrc) + 1)) LPSTR pDst);

BOOL
WINAPI
OemToCharBuffA(
  _In_ LPCSTR lpszSrc,
  _Out_writes_(cchDstLength) LPSTR lpszDst,
  _In_ DWORD cchDstLength);

BOOL
WINAPI
OemToCharBuffW(
  _In_ LPCSTR lpszSrc,
  _Out_writes_(cchDstLength) LPWSTR lpszDst,
  _In_ DWORD cchDstLength);

BOOL
WINAPI
OemToCharW(
  _In_ LPCSTR pSrc,
  _Out_writes_(_Inexpressible_(strlen(pSrc) + 1)) LPWSTR pDst);

BOOL WINAPI OffsetRect(_Inout_ LPRECT, _In_ int, _In_ int);
BOOL WINAPI OpenClipboard(_In_opt_ HWND);
HDESK WINAPI OpenDesktopA(_In_ LPCSTR, _In_ DWORD, _In_ BOOL, _In_ DWORD);
HDESK WINAPI OpenDesktopW(_In_ LPCWSTR, _In_ DWORD, _In_ BOOL, _In_ DWORD);
BOOL WINAPI OpenIcon(_In_ HWND);
HDESK WINAPI OpenInputDesktop(_In_ DWORD, _In_ BOOL, _In_ DWORD);
HWINSTA WINAPI OpenWindowStationA(_In_ LPCSTR, _In_ BOOL, _In_ DWORD);
HWINSTA WINAPI OpenWindowStationW(_In_ LPCWSTR, _In_ BOOL, _In_ DWORD);
BOOL WINAPI PaintDesktop(_In_ HDC);
BOOL WINAPI PeekMessageA(_Out_ LPMSG, _In_opt_ HWND, _In_ UINT, _In_ UINT, _In_ UINT);
BOOL WINAPI PeekMessageW(_Out_ LPMSG, _In_opt_ HWND, _In_ UINT, _In_ UINT, _In_ UINT);
#define PostAppMessageA(t,m,w,l) PostThreadMessageA((DWORD)t,m,w,l)
#define PostAppMessageW(t,m,w,l) PostThreadMessageW((DWORD)t,m,w,l)
BOOL WINAPI PostMessageA(_In_opt_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI PostMessageW(_In_opt_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);

__analysis_noreturn
void WINAPI PostQuitMessage(_In_ int);

BOOL WINAPI PostThreadMessageA(_In_ DWORD, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI PostThreadMessageW(_In_ DWORD, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
#if (_WIN32_WINNT >= 0x0501)
BOOL WINAPI PrintWindow(_In_ HWND, _In_ HDC, _In_ UINT);
#endif

UINT
WINAPI
PrivateExtractIconsA(
  _In_reads_(MAX_PATH) LPCSTR szFileName,
  _In_ int nIconIndex,
  _In_ int cxIcon,
  _In_ int cyIcon,
  _Out_writes_opt_(nIcons) HICON *phicon,
  _Out_writes_opt_(nIcons) UINT *piconid,
  _In_ UINT nIcons,
  _In_ UINT flags);

UINT
WINAPI
PrivateExtractIconsW(
  _In_reads_(MAX_PATH) LPCWSTR szFileName,
  _In_ int nIconIndex,
  _In_ int cxIcon,
  _In_ int cyIcon,
  _Out_writes_opt_(nIcons) HICON *phicon,
  _Out_writes_opt_(nIcons) UINT *piconid,
  _In_ UINT nIcons,
  _In_ UINT flags);

UINT WINAPI WINAPI PrivateExtractIconExA(LPCSTR,int,HICON*,HICON*,UINT);
UINT WINAPI WINAPI PrivateExtractIconExW(LPCWSTR,int,HICON*,HICON*,UINT);
BOOL WINAPI PtInRect(_In_ LPCRECT, _In_ POINT);
HWND WINAPI RealChildWindowFromPoint(_In_ HWND, _In_ POINT);

UINT
WINAPI
RealGetWindowClassA(
  _In_ HWND hwnd,
  _Out_writes_to_(cchClassNameMax, return) LPSTR ptszClassName,
  _In_ UINT cchClassNameMax);

UINT
WINAPI
RealGetWindowClassW(
  _In_ HWND hwnd,
  _Out_writes_to_(cchClassNameMax, return) LPWSTR ptszClassName,
  _In_ UINT cchClassNameMax);

BOOL WINAPI RedrawWindow(_In_opt_ HWND, _In_opt_ LPCRECT, _In_opt_ HRGN, _In_ UINT);
ATOM WINAPI RegisterClassA(_In_ CONST WNDCLASSA*);
ATOM WINAPI RegisterClassW(_In_ CONST WNDCLASSW*);
ATOM WINAPI RegisterClassExA(_In_ CONST WNDCLASSEXA*);
ATOM WINAPI RegisterClassExW(_In_ CONST WNDCLASSEXW*);
#if(_WIN32_WINNT >= 0x0501)
typedef BOOLEAN (WINAPI * PREGISTERCLASSNAMEW)(LPCWSTR);
#endif
UINT WINAPI RegisterClipboardFormatA(_In_ LPCSTR);
UINT WINAPI RegisterClipboardFormatW(_In_ LPCWSTR);
#if (WINVER >= 0x0500)
HDEVNOTIFY WINAPI RegisterDeviceNotificationA(_In_ HANDLE, _In_ LPVOID, _In_ DWORD);
HDEVNOTIFY WINAPI RegisterDeviceNotificationW(_In_ HANDLE, _In_ LPVOID, _In_ DWORD);
#endif
BOOL WINAPI RegisterHotKey(_In_opt_ HWND, _In_ int, _In_ UINT, _In_ UINT);
BOOL WINAPI RegisterLogonProcess(DWORD,BOOL);

#if (_WIN32_WINNT >= 0x0501)
BOOL
WINAPI
RegisterRawInputDevices(
  _In_reads_(uiNumDevices) PCRAWINPUTDEVICE pRawInputDevices,
  _In_ UINT uiNumDevices,
  _In_ UINT cbSize);
#endif

BOOL WINAPI RegisterShellHookWindow(_In_ HWND);
UINT WINAPI RegisterWindowMessageA(_In_ LPCSTR);
UINT WINAPI RegisterWindowMessageW(_In_ LPCWSTR);
BOOL WINAPI ReleaseCapture(void);
int WINAPI ReleaseDC(_In_opt_ HWND, _In_ HDC);
BOOL WINAPI RemoveMenu(_In_ HMENU, _In_ UINT, _In_ UINT);
HANDLE WINAPI RemovePropA(_In_ HWND, _In_ LPCSTR);
HANDLE WINAPI RemovePropW(_In_ HWND, _In_ LPCWSTR);
BOOL WINAPI ReplyMessage(_In_ LRESULT);
BOOL WINAPI ScreenToClient(_In_ HWND, _Inout_ LPPOINT);
VOID WINAPI ScrollChildren(HWND,UINT,WPARAM,LPARAM);
BOOL WINAPI ScrollDC(_In_ HDC, _In_ int, _In_ int, _In_opt_ LPCRECT, _In_opt_ LPCRECT, _In_opt_ HRGN, _Out_opt_ LPRECT);
BOOL WINAPI ScrollWindow(_In_ HWND, _In_ int, _In_ int, _In_opt_ LPCRECT, _In_opt_ LPCRECT);
int WINAPI ScrollWindowEx(_In_ HWND, _In_ int, _In_ int, _In_opt_ LPCRECT, _In_opt_ LPCRECT, _In_opt_ HRGN, _Out_opt_ LPRECT, _In_ UINT);
LRESULT WINAPI SendDlgItemMessageA(_In_ HWND, _In_ int, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
LRESULT WINAPI SendDlgItemMessageW(_In_ HWND, _In_ int, _In_ UINT, _In_ WPARAM, _In_ LPARAM);

#if (_WIN32_WINNT >= 0x0403)
UINT
WINAPI
SendInput(
  _In_ UINT cInputs,
  _In_reads_(cInputs) LPINPUT pInputs,
  _In_ int cbSize);
#endif

LRESULT WINAPI SendMessageA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI SendMessageCallbackA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM, _In_ SENDASYNCPROC, _In_ ULONG_PTR);
BOOL WINAPI SendMessageCallbackW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM, _In_ SENDASYNCPROC, _In_ ULONG_PTR);
LRESULT WINAPI SendMessageTimeoutA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM, _In_ UINT, _In_ UINT, _Out_opt_ PDWORD_PTR);
LRESULT WINAPI SendMessageTimeoutW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM, _In_ UINT, _In_ UINT, _Out_opt_ PDWORD_PTR);
LRESULT WINAPI SendMessageW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI SendNotifyMessageA(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
BOOL WINAPI SendNotifyMessageW(_In_ HWND, _In_ UINT, _In_ WPARAM, _In_ LPARAM);
HWND WINAPI SetActiveWindow(_In_ HWND);
HWND WINAPI SetCapture(_In_ HWND hWnd);
BOOL WINAPI SetCaretBlinkTime(_In_ UINT);
BOOL WINAPI SetCaretPos(_In_ int, _In_ int);
DWORD WINAPI SetClassLongA(_In_ HWND, _In_ int, _In_ LONG);
DWORD WINAPI SetClassLongW(_In_ HWND, _In_ int, _In_ LONG);
#ifdef _WIN64
ULONG_PTR WINAPI SetClassLongPtrA(_In_ HWND, _In_ INT, _In_ LONG_PTR);
ULONG_PTR WINAPI SetClassLongPtrW(_In_ HWND, _In_ INT, _In_ LONG_PTR);
#else
#define SetClassLongPtrA SetClassLongA
#define SetClassLongPtrW SetClassLongW
#endif
WORD WINAPI SetClassWord(_In_ HWND, _In_ int, _In_ WORD);
HANDLE WINAPI SetClipboardData(_In_ UINT, _In_opt_ HANDLE);
HWND WINAPI SetClipboardViewer(_In_ HWND);
HCURSOR WINAPI SetCursor(_In_opt_ HCURSOR);
BOOL WINAPI SetCursorPos(_In_ int, _In_ int);
VOID WINAPI SetDebugErrorLevel(_In_ DWORD);
BOOL WINAPI SetDeskWallPaper(LPCSTR);
BOOL WINAPI SetDlgItemInt(_In_ HWND, _In_ int, _In_ UINT, _In_ BOOL);
BOOL WINAPI SetDlgItemTextA(_In_ HWND, _In_ int, _In_ LPCSTR);
BOOL WINAPI SetDlgItemTextW(_In_ HWND, _In_ int, _In_ LPCWSTR);
BOOL WINAPI SetDoubleClickTime(_In_ UINT);
HWND WINAPI SetFocus(_In_opt_ HWND);
BOOL WINAPI SetForegroundWindow(_In_ HWND);
BOOL WINAPI SetKeyboardState(_In_reads_(256) LPBYTE);
BOOL WINAPI SetMenu(_In_ HWND, _In_opt_ HMENU);
BOOL WINAPI SetMenuContextHelpId(_In_ HMENU, _In_ DWORD);
BOOL WINAPI SetMenuDefaultItem(_In_ HMENU, _In_ UINT, _In_ UINT);
BOOL WINAPI SetMenuInfo(_In_ HMENU, _In_ LPCMENUINFO);
BOOL WINAPI SetMenuItemBitmaps(_In_ HMENU, _In_ UINT, _In_ UINT, _In_opt_ HBITMAP, _In_opt_ HBITMAP);
BOOL WINAPI SetMenuItemInfoA(_In_ HMENU, _In_ UINT, _In_ BOOL, _In_ LPCMENUITEMINFOA);
BOOL WINAPI SetMenuItemInfoW(_In_ HMENU, _In_ UINT, _In_ BOOL, _In_ LPCMENUITEMINFOW);
LPARAM WINAPI SetMessageExtraInfo(_In_ LPARAM);
BOOL WINAPI SetMessageQueue(_In_ int);
HWND WINAPI SetParent(_In_ HWND, _In_opt_ HWND);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI SetProcessDefaultLayout(_In_ DWORD);
#endif /* (_WIN32_WINNT >= 0x0500) */
BOOL WINAPI SetProcessWindowStation(_In_ HWINSTA);
BOOL WINAPI SetPropA(_In_ HWND, _In_ LPCSTR, _In_opt_ HANDLE);
BOOL WINAPI SetPropW(_In_ HWND, _In_ LPCWSTR, _In_opt_ HANDLE);
BOOL WINAPI SetRect(_Out_ LPRECT, _In_ int, _In_ int, _In_ int, _In_ int);
BOOL WINAPI SetRectEmpty(_Out_ LPRECT);
int WINAPI SetScrollInfo(_In_ HWND, _In_ int, _In_ LPCSCROLLINFO, _In_ BOOL);
int WINAPI SetScrollPos(_In_ HWND, _In_ int, _In_ int, _In_ BOOL);
BOOL WINAPI SetScrollRange(_In_ HWND, _In_ int, _In_ int, _In_ int, _In_ BOOL);

BOOL
WINAPI
SetSysColors(
  _In_ int cElements,
  _In_reads_(cElements) CONST INT * lpaElements,
  _In_reads_(cElements) CONST COLORREF * lpaRgbValues);

DWORD_PTR WINAPI SetSysColorsTemp(const COLORREF *, const HBRUSH *, DWORD_PTR);
#define SetSysModalWindow(h) (NULL)
BOOL WINAPI SetSystemCursor(_In_ HCURSOR, _In_ DWORD);
BOOL WINAPI SetSystemMenu(HWND,HMENU);
BOOL WINAPI SetThreadDesktop(_In_ HDESK);
UINT_PTR WINAPI SetTimer(_In_opt_ HWND, _In_ UINT_PTR, _In_ UINT, _In_opt_ TIMERPROC);
UINT_PTR WINAPI SetSystemTimer(HWND,UINT_PTR,UINT,TIMERPROC);

BOOL
WINAPI
SetUserObjectInformationA(
  _In_ HANDLE hObj,
  _In_ int nIndex,
  _In_reads_bytes_(nLength) PVOID pvInfo,
  _In_ DWORD nLength);

BOOL
WINAPI
SetUserObjectInformationW(
  _In_ HANDLE hObj,
  _In_ int nIndex,
  _In_reads_bytes_(nLength) PVOID pvInfo,
  _In_ DWORD nLength);

BOOL WINAPI SetUserObjectSecurity(_In_ HANDLE, _In_ PSECURITY_INFORMATION, _In_ PSECURITY_DESCRIPTOR);
#if (WINVER >= 0x0500)
HWINEVENTHOOK WINAPI SetWinEventHook(_In_ UINT, _In_ UINT, _In_opt_ HMODULE, _In_ WINEVENTPROC, _In_ DWORD, _In_ DWORD, _In_ UINT);
#endif
BOOL WINAPI SetWindowContextHelpId(_In_ HWND, _In_ DWORD);
LONG WINAPI SetWindowLongA(_In_ HWND, _In_ int, _In_ LONG);
LONG WINAPI SetWindowLongW(_In_ HWND, _In_ int, _In_ LONG);
#ifdef _WIN64
LONG_PTR WINAPI SetWindowLongPtrA(_In_ HWND, _In_ int, _In_ LONG_PTR);
LONG_PTR WINAPI SetWindowLongPtrW(_In_ HWND, _In_ int, _In_ LONG_PTR);
#else
#define SetWindowLongPtrA SetWindowLongA
#define SetWindowLongPtrW SetWindowLongW
#endif
BOOL WINAPI SetWindowPlacement(_In_ HWND hWnd, _In_ const WINDOWPLACEMENT*);
BOOL WINAPI SetWindowPos(_In_ HWND, _In_opt_ HWND, _In_ int, _In_ int, _In_ int, _In_ int, _In_ UINT);
int WINAPI SetWindowRgn(_In_ HWND, _In_opt_ HRGN, _In_ BOOL);
HHOOK WINAPI SetWindowsHookA(_In_ int, _In_ HOOKPROC);
HHOOK WINAPI SetWindowsHookW(_In_ int, _In_ HOOKPROC);
HHOOK WINAPI SetWindowsHookExA(_In_ int, _In_ HOOKPROC, _In_opt_ HINSTANCE, _In_ DWORD);
HHOOK WINAPI SetWindowsHookExW(_In_ int, _In_ HOOKPROC, _In_opt_ HINSTANCE, _In_ DWORD);
BOOL WINAPI SetWindowTextA(_In_ HWND, _In_opt_ LPCSTR);
BOOL WINAPI SetWindowTextW(_In_ HWND, _In_opt_ LPCWSTR);
WORD WINAPI SetWindowWord(_In_ HWND, _In_ int, _In_ WORD);
BOOL WINAPI ShowCaret(_In_opt_ HWND);
int WINAPI ShowCursor(_In_ BOOL);
BOOL WINAPI ShowOwnedPopups(_In_ HWND, _In_ BOOL);
BOOL WINAPI ShowScrollBar(_In_ HWND, _In_ int, _In_ BOOL);
BOOL WINAPI ShowWindow(_In_ HWND, _In_ int);
BOOL WINAPI ShowWindowAsync(_In_ HWND, _In_ int);
BOOL WINAPI SubtractRect(_Out_ LPRECT, _In_ LPCRECT, _In_ LPCRECT);
BOOL WINAPI SwapMouseButton(_In_ BOOL);
BOOL WINAPI SwitchDesktop(_In_ HDESK);
#if(_WIN32_WINNT >= 0x0500)
VOID WINAPI SwitchToThisWindow(_In_ HWND, _In_ BOOL);
#endif /* (_WIN32_WINNT >= 0x0500) */
BOOL WINAPI SystemParametersInfoA(_In_ UINT uiAction, _In_ UINT uiParam, _Inout_opt_ PVOID pvParam, _In_ UINT fWinIni);
BOOL WINAPI SystemParametersInfoW(_In_ UINT uiAction, _In_ UINT uiParam, _Inout_opt_ PVOID pvParam, _In_ UINT fWinIni);

LONG
WINAPI
TabbedTextOutA(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_reads_(chCount) LPCSTR lpString,
  _In_ int chCount,
  _In_ int nTabPositions,
  _In_reads_opt_(nTabPositions) CONST INT *lpnTabStopPositions,
  _In_ int nTabOrigin);

LONG
WINAPI
TabbedTextOutW(
  _In_ HDC hdc,
  _In_ int x,
  _In_ int y,
  _In_reads_(chCount) LPCWSTR lpString,
  _In_ int chCount,
  _In_ int nTabPositions,
  _In_reads_opt_(nTabPositions) CONST INT *lpnTabStopPositions,
  _In_ int nTabOrigin);

WORD
WINAPI
TileWindows(
  _In_opt_ HWND hwndParent,
  _In_ UINT wHow,
  _In_opt_ CONST RECT * lpRect,
  _In_ UINT cKids,
  _In_reads_opt_(cKids) const HWND FAR *lpKids);

int WINAPI ToAscii(_In_ UINT, _In_ UINT, _In_reads_opt_(256) CONST BYTE*, _Out_ LPWORD, _In_ UINT);
int WINAPI ToAsciiEx(_In_ UINT, _In_ UINT, _In_reads_opt_(256) CONST BYTE*, _Out_ LPWORD, _In_ UINT, _In_opt_ HKL);

int
WINAPI
ToUnicode(
  _In_ UINT wVirtKey,
  _In_ UINT wScanCode,
  _In_reads_bytes_opt_(256) CONST BYTE *lpKeyState,
  _Out_writes_(cchBuff) LPWSTR pwszBuff,
  _In_ int cchBuff,
  _In_ UINT wFlags);

int
WINAPI
ToUnicodeEx(
  _In_ UINT wVirtKey,
  _In_ UINT wScanCode,
  _In_reads_bytes_(256) CONST BYTE *lpKeyState,
  _Out_writes_(cchBuff) LPWSTR pwszBuff,
  _In_ int cchBuff,
  _In_ UINT wFlags,
  _In_opt_ HKL dwhkl);

BOOL WINAPI TrackMouseEvent(_Inout_ LPTRACKMOUSEEVENT);
BOOL WINAPI TrackPopupMenu(_In_ HMENU, _In_ UINT, _In_ int, _In_ int, _Reserved_ int, _In_ HWND, _Reserved_ LPCRECT);
BOOL WINAPI TrackPopupMenuEx(_In_ HMENU, _In_ UINT, _In_ int, _In_ int, _In_ HWND, _In_opt_ LPTPMPARAMS);
int WINAPI TranslateAcceleratorA(_In_ HWND, _In_ HACCEL, _In_ LPMSG);
int WINAPI TranslateAcceleratorW(_In_ HWND, _In_ HACCEL, _In_ LPMSG);
BOOL WINAPI TranslateMDISysAccel(_In_ HWND, _In_ LPMSG);
BOOL WINAPI TranslateMessage(_In_ const MSG*);
BOOL WINAPI UnhookWindowsHook(_In_ int, _In_ HOOKPROC);
BOOL WINAPI UnhookWindowsHookEx(_In_ HHOOK);
#if (WINVER >= 0x0500)
BOOL WINAPI UnhookWinEvent(_In_ HWINEVENTHOOK);
#endif
BOOL WINAPI UnionRect(_Out_ LPRECT, _In_ LPCRECT, _In_ LPCRECT);
BOOL WINAPI UnloadKeyboardLayout(_In_ HKL);
BOOL WINAPI UnregisterClassA(_In_ LPCSTR,HINSTANCE);
BOOL WINAPI UnregisterClassW(_In_ LPCWSTR,HINSTANCE);
#if (WINVER >= 0x0500)
BOOL WINAPI UnregisterDeviceNotification(_In_ HDEVNOTIFY);
#endif
BOOL WINAPI UnregisterHotKey(_In_opt_ HWND, _In_ int);
BOOL WINAPI UpdateWindow(_In_ HWND);
#if (_WIN32_WINNT >= 0x0500)
BOOL WINAPI UserHandleGrantAccess(_In_ HANDLE, _In_ HANDLE, _In_ BOOL);
#endif
BOOL WINAPI ValidateRect(_In_opt_ HWND, _In_opt_ LPCRECT);
BOOL WINAPI ValidateRgn(_In_ HWND, _In_opt_ HRGN);
SHORT WINAPI VkKeyScanA(_In_ CHAR);
SHORT WINAPI VkKeyScanExA(_In_ CHAR, _In_ HKL);
SHORT WINAPI VkKeyScanExW(_In_ WCHAR, _In_ HKL);
SHORT WINAPI VkKeyScanW(_In_ WCHAR);
DWORD WINAPI WaitForInputIdle(_In_ HANDLE, _In_ DWORD);
BOOL WINAPI WaitMessage(void);
HWND WINAPI WindowFromDC(_In_ HDC hDC);
#if (_WIN32_WINNT >= 0x0600)
HWND WINAPI WindowFromPhysicalPoint(_In_ POINT);
#endif
HWND WINAPI WindowFromPoint(_In_ POINT);
UINT WINAPI WinExec(LPCSTR,UINT);
BOOL WINAPI WinHelpA(_In_opt_ HWND, _In_opt_ LPCSTR, _In_ UINT, _In_ ULONG_PTR);
BOOL WINAPI WinHelpW(_In_opt_ HWND, _In_opt_ LPCWSTR, _In_ UINT, _In_ ULONG_PTR);

int
WINAPIV
wsprintfA(
  _Out_ LPSTR,
  _In_ _Printf_format_string_ LPCSTR,
  ...);

int
WINAPIV
wsprintfW(
  _Out_ LPWSTR,
  _In_ _Printf_format_string_ LPCWSTR,
  ...);

int
WINAPI
wvsprintfA(
  _Out_ LPSTR,
  _In_ _Printf_format_string_ LPCSTR,
  _In_ va_list arglist);

int
WINAPI
wvsprintfW(
  _Out_ LPWSTR,
  _In_ _Printf_format_string_ LPCWSTR,
  _In_ va_list arglist);

#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0490)
BOOL WINAPI AllowSetForegroundWindow(_In_ DWORD);
BOOL WINAPI LockSetForegroundWindow(_In_ UINT);
#endif
#if (_WIN32_WINNT >= 0x0500)

BOOL WINAPI SetLayeredWindowAttributes(_In_ HWND, _In_ COLORREF, _In_ BYTE, _In_ DWORD);

#if defined(_WINGDI_) && !defined(NOGDI)

BOOL
WINAPI
UpdateLayeredWindow(
  _In_ HWND hWnd,
  _In_opt_ HDC hdcDst,
  _In_opt_ POINT* pptDst,
  _In_opt_ SIZE* psize,
  _In_opt_ HDC hdcSrc,
  _In_opt_ POINT* pptSrc,
  _In_ COLORREF crKey,
  _In_opt_ BLENDFUNCTION* pblend,
  _In_ DWORD dwFlags);

typedef struct tagUPDATELAYEREDWINDOWINFO {
  DWORD cbSize;
  HDC hdcDst;
  POINT CONST* pptDst;
  SIZE CONST* psize;
  HDC hdcSrc;
  POINT CONST* pptSrc;
  COLORREF crKey;
  BLENDFUNCTION CONST* pblend;
  DWORD dwFlags;
  RECT CONST* prcDirty;
} UPDATELAYEREDWINDOWINFO, *PUPDATELAYEREDWINDOWINFO;

BOOL WINAPI UpdateLayeredWindowIndirect(_In_ HWND, _In_ const UPDATELAYEREDWINDOWINFO*);

#endif /* defined(_WINGDI_) && !defined(NOGDI) */

#endif /* (_WIN32_WINNT >= 0x0500) */

#if (_WIN32_WINNT >= 0x0501)
BOOL WINAPI GetLayeredWindowAttributes(_In_ HWND, _Out_opt_ COLORREF*, _Out_opt_ BYTE*, _Out_opt_ DWORD*);
#endif
#ifdef UNICODE
#define EDITWORDBREAKPROC EDITWORDBREAKPROCW
#define PROPENUMPROC PROPENUMPROCW
#define PROPENUMPROCEX PROPENUMPROCEXW
#define DESKTOPENUMPROC DESKTOPENUMPROCW
#define WINSTAENUMPROC WINSTAENUMPROCW
#define PROPENUMPROC PROPENUMPROCW
#define PROPENUMPROCEX PROPENUMPROCEXW
typedef WNDCLASSW WNDCLASS,*LPWNDCLASS,*PWNDCLASS;
typedef WNDCLASSEXW WNDCLASSEX,*LPWNDCLASSEX,*PWNDCLASSEX;
typedef MENUITEMINFOW MENUITEMINFO,*LPMENUITEMINFO;
typedef LPCMENUITEMINFOW LPCMENUITEMINFO;
typedef MSGBOXPARAMSW MSGBOXPARAMS,*PMSGBOXPARAMS,*LPMSGBOXPARAMS;
typedef HIGHCONTRASTW HIGHCONTRAST,*LPHIGHCONTRAST;
typedef SERIALKEYSW SERIALKEYS,*LPSERIALKEYS;
typedef SOUNDSENTRYW SOUNDSENTRY,*LPSOUNDSENTRY;
typedef CREATESTRUCTW CREATESTRUCT, *LPCREATESTRUCT;
typedef CBT_CREATEWNDW CBT_CREATEWND, *LPCBT_CREATEWND;
typedef MDICREATESTRUCTW MDICREATESTRUCT,*LPMDICREATESTRUCT;
typedef MULTIKEYHELPW MULTIKEYHELP,*PMULTIKEYHELP,*LPMULTIKEYHELP;
typedef MONITORINFOEXW MONITORINFOEX, *LPMONITORINFOEX;
#define AppendMenu AppendMenuW
#define BroadcastSystemMessage BroadcastSystemMessageW
#define BroadcastSystemMessageEx BroadcastSystemMessageExW
#define CallMsgFilter CallMsgFilterW
#define CallWindowProc CallWindowProcW
#define ChangeMenu ChangeMenuW
#define CharLower CharLowerW
#define CharLowerBuff CharLowerBuffW
#define CharNext CharNextW
#define CharNextEx CharNextExW
#define CharPrev CharPrevW
#define CharPrevEx CharPrevExW
#define CharToOem CharToOemW
#define CharToOemBuff CharToOemBuffW
#define CharUpper CharUpperW
#define CharUpperBuff CharUpperBuffW
#define CopyAcceleratorTable CopyAcceleratorTableW
#define CreateAcceleratorTable CreateAcceleratorTableW
#define CreateDialog CreateDialogW
#define CreateDialogIndirect CreateDialogIndirectW
#define CreateDialogIndirectParam CreateDialogIndirectParamW
#define CreateDialogParam CreateDialogParamW
#define CreateMDIWindow CreateMDIWindowW
#define CreateWindow CreateWindowW
#define CreateWindowEx CreateWindowExW
#define CreateWindowStation CreateWindowStationW
#define DefDlgProc DefDlgProcW
#define DefFrameProc DefFrameProcW
#define DefMDIChildProc DefMDIChildProcW
#define DefWindowProc DefWindowProcW
#define DialogBox DialogBoxW
#define DialogBoxIndirect DialogBoxIndirectW
#define DialogBoxIndirectParam DialogBoxIndirectParamW
#define DialogBoxParam DialogBoxParamW
#define DispatchMessage DispatchMessageW
#define DlgDirList DlgDirListW
#define DlgDirListComboBox DlgDirListComboBoxW
#define DlgDirSelectComboBoxEx DlgDirSelectComboBoxExW
#define DlgDirSelectEx DlgDirSelectExW
#define DrawState DrawStateW
#define DrawText DrawTextW
#define DrawTextEx DrawTextExW
#define EnumDesktops EnumDesktopsW
#define EnumProps EnumPropsW
#define EnumPropsEx EnumPropsExW
#define EnumWindowStations EnumWindowStationsW
#define FindWindow FindWindowW
#define FindWindowEx FindWindowExW
#define GetClassInfo GetClassInfoW
#define GetClassInfoEx GetClassInfoExW
#define GetClassLong GetClassLongW
#define GetClassLongPtr GetClassLongPtrW
#define GetClassName GetClassNameW
#define GetClipboardFormatName GetClipboardFormatNameW
#define GetDlgItemText GetDlgItemTextW
#define GetKeyboardLayoutName GetKeyboardLayoutNameW
#define GetKeyNameText GetKeyNameTextW
#define GetMenuItemInfo GetMenuItemInfoW
#define GetMenuString GetMenuStringW
#define GetMessage GetMessageW
#define GetMonitorInfo GetMonitorInfoW
#define GetProp GetPropW
#define GetRawInputDeviceInfo GetRawInputDeviceInfoW
#define GetTabbedTextExtent GetTabbedTextExtentW
#define GetUserObjectInformation GetUserObjectInformationW
#define GetWindowLong GetWindowLongW
#define GetWindowLongPtr GetWindowLongPtrW
#define GetWindowText GetWindowTextW
#define GetWindowTextLength GetWindowTextLengthW
#define GetAltTabInfo GetAltTabInfoW
#define GetWindowModuleFileName GetWindowModuleFileNameW
#define GrayString GrayStringW
#define InsertMenu InsertMenuW
#define InsertMenuItem InsertMenuItemW
#define IsCharAlpha IsCharAlphaW
#define IsCharAlphaNumeric IsCharAlphaNumericW
#define IsCharLower IsCharLowerW
#define IsCharUpper IsCharUpperW
#define IsDialogMessage IsDialogMessageW
#define LoadAccelerators LoadAcceleratorsW
#define LoadBitmap LoadBitmapW
#define LoadCursor LoadCursorW
#define LoadCursorFromFile LoadCursorFromFileW
#define LoadIcon LoadIconW
#define LoadImage LoadImageW
#define LoadKeyboardLayout LoadKeyboardLayoutW
#define LoadMenu LoadMenuW
#define LoadMenuIndirect LoadMenuIndirectW
#define LoadString LoadStringW
#define MapVirtualKey MapVirtualKeyW
#define MapVirtualKeyEx MapVirtualKeyExW
#define MessageBox MessageBoxW
#define MessageBoxEx MessageBoxExW
#define MessageBoxIndirect MessageBoxIndirectW
#define ModifyMenu ModifyMenuW
#define OemToChar OemToCharW
#define OemToCharBuff OemToCharBuffW
#define OpenDesktop OpenDesktopW
#define OpenWindowStation OpenWindowStationW
#define PeekMessage PeekMessageW
#define PostAppMessage PostAppMessageW
#define PostMessage PostMessageW
#define PostThreadMessage PostThreadMessageW
#define PrivateExtractIcons PrivateExtractIconsW
#define RealGetWindowClass RealGetWindowClassW
#define RegisterClass RegisterClassW
#define RegisterClassEx RegisterClassExW
#define RegisterClipboardFormat RegisterClipboardFormatW
#define RegisterDeviceNotification RegisterDeviceNotificationW
#define RegisterWindowMessage RegisterWindowMessageW
#define RemoveProp RemovePropW
#define SendDlgItemMessage SendDlgItemMessageW
#define SendMessage SendMessageW
#define SendMessageCallback SendMessageCallbackW
#define SendMessageTimeout SendMessageTimeoutW
#define SendNotifyMessage SendNotifyMessageW
#define SetClassLong SetClassLongW
#define SetClassLongPtr SetClassLongPtrW
#define SetDlgItemText SetDlgItemTextW
#define SetMenuItemInfo SetMenuItemInfoW
#define SetProp SetPropW
#define SetUserObjectInformation SetUserObjectInformationW
#define SetWindowLong SetWindowLongW
#define SetWindowLongPtr SetWindowLongPtrW
#define SetWindowsHook SetWindowsHookW
#define SetWindowsHookEx SetWindowsHookExW
#define SetWindowText SetWindowTextW
#define SystemParametersInfo SystemParametersInfoW
#define TabbedTextOut TabbedTextOutW
#define TranslateAccelerator TranslateAcceleratorW
#define UnregisterClass UnregisterClassW
#define VkKeyScan VkKeyScanW
#define VkKeyScanEx VkKeyScanExW
#define WinHelp WinHelpW
#define wsprintf wsprintfW
#define wvsprintf wvsprintfW

#if defined(_WINGDI_) && !defined(NOGDI)
#define ChangeDisplaySettings ChangeDisplaySettingsW
#define ChangeDisplaySettingsEx ChangeDisplaySettingsExW
#define CreateDesktop CreateDesktopW
#define EnumDisplaySettings EnumDisplaySettingsW
#define EnumDisplaySettingsEx EnumDisplaySettingsExW
#define EnumDisplayDevices EnumDisplayDevicesW
#endif /* _WINGDI_ && !NOGDI */
#else /* UNICODE */
#define EDITWORDBREAKPROC EDITWORDBREAKPROCA
#define PROPENUMPROC PROPENUMPROCA
#define PROPENUMPROCEX PROPENUMPROCEXA
#define DESKTOPENUMPROC DESKTOPENUMPROCA
#define WINSTAENUMPROC WINSTAENUMPROCA
#define PROPENUMPROC PROPENUMPROCA
#define PROPENUMPROCEX PROPENUMPROCEXA
typedef WNDCLASSA WNDCLASS,*LPWNDCLASS,*PWNDCLASS;
typedef WNDCLASSEXA WNDCLASSEX,*LPWNDCLASSEX,*PWNDCLASSEX;
typedef MENUITEMINFOA MENUITEMINFO,*LPMENUITEMINFO;
typedef LPCMENUITEMINFOA LPCMENUITEMINFO;
typedef MSGBOXPARAMSA MSGBOXPARAMS,*PMSGBOXPARAMS,*LPMSGBOXPARAMS;
typedef HIGHCONTRASTA HIGHCONTRAST,*LPHIGHCONTRAST;
typedef SERIALKEYSA SERIALKEYS,*LPSERIALKEYS;
typedef SOUNDSENTRYA SOUNDSENTRY,*LPSOUNDSENTRY;
typedef CREATESTRUCTA CREATESTRUCT, *LPCREATESTRUCT;
typedef CBT_CREATEWNDA CBT_CREATEWND, *LPCBT_CREATEWND;
typedef MDICREATESTRUCTA MDICREATESTRUCT,*LPMDICREATESTRUCT;
typedef MULTIKEYHELPA MULTIKEYHELP,*PMULTIKEYHELP,*LPMULTIKEYHELP;
typedef MONITORINFOEXA MONITORINFOEX, *LPMONITORINFOEX;
#define AppendMenu AppendMenuA
#define BroadcastSystemMessage BroadcastSystemMessageA
#define BroadcastSystemMessageEx BroadcastSystemMessageExA
#define CallMsgFilter CallMsgFilterA
#define CallWindowProc CallWindowProcA
#define ChangeMenu ChangeMenuA
#define CharLower CharLowerA
#define CharLowerBuff CharLowerBuffA
#define CharNext CharNextA
#define CharNextEx CharNextExA
#define CharPrev CharPrevA
#define CharPrevEx CharPrevExA
#define CharToOem CharToOemA
#define CharToOemBuff CharToOemBuffA
#define CharUpper CharUpperA
#define CharUpperBuff CharUpperBuffA
#define CopyAcceleratorTable CopyAcceleratorTableA
#define CreateAcceleratorTable CreateAcceleratorTableA
#define CreateDialog CreateDialogA
#define CreateDialogIndirect CreateDialogIndirectA
#define CreateDialogIndirectParam CreateDialogIndirectParamA
#define CreateDialogParam CreateDialogParamA
#define CreateMDIWindow CreateMDIWindowA
#define CreateWindow CreateWindowA
#define CreateWindowEx CreateWindowExA
#define CreateWindowStation CreateWindowStationA
#define DefDlgProc DefDlgProcA
#define DefFrameProc DefFrameProcA
#define DefMDIChildProc DefMDIChildProcA
#define DefWindowProc DefWindowProcA
#define DialogBox DialogBoxA
#define DialogBoxIndirect DialogBoxIndirectA
#define DialogBoxIndirectParam DialogBoxIndirectParamA
#define DialogBoxParam DialogBoxParamA
#define DispatchMessage DispatchMessageA
#define DlgDirList DlgDirListA
#define DlgDirListComboBox DlgDirListComboBoxA
#define DlgDirSelectComboBoxEx DlgDirSelectComboBoxExA
#define DlgDirSelectEx DlgDirSelectExA
#define DrawState DrawStateA
#define DrawText DrawTextA
#define DrawTextEx DrawTextExA
#define EnumDesktops EnumDesktopsA
#define EnumProps EnumPropsA
#define EnumPropsEx EnumPropsExA
#define EnumWindowStations EnumWindowStationsA
#define FindWindow FindWindowA
#define FindWindowEx FindWindowExA
#define GetClassInfo GetClassInfoA
#define GetClassInfoEx GetClassInfoExA
#define GetClassLong GetClassLongA
#define GetClassLongPtr GetClassLongPtrA
#define GetClassName GetClassNameA
#define GetClipboardFormatName GetClipboardFormatNameA
#define GetDlgItemText GetDlgItemTextA
#define GetKeyboardLayoutName GetKeyboardLayoutNameA
#define GetKeyNameText GetKeyNameTextA
#define GetMenuItemInfo GetMenuItemInfoA
#define GetMenuString GetMenuStringA
#define GetMessage GetMessageA
#define GetMonitorInfo GetMonitorInfoA
#define GetProp GetPropA
#define GetRawInputDeviceInfo GetRawInputDeviceInfoA
#define GetTabbedTextExtent GetTabbedTextExtentA
#define GetUserObjectInformation GetUserObjectInformationA
#define GetWindowLong GetWindowLongA
#define GetWindowLongPtr GetWindowLongPtrA
#define GetWindowText GetWindowTextA
#define GetWindowTextLength GetWindowTextLengthA
#define GetAltTabInfo GetAltTabInfoA
#define GetWindowModuleFileName GetWindowModuleFileNameA
#define GrayString GrayStringA
#define InsertMenu InsertMenuA
#define InsertMenuItem InsertMenuItemA
#define IsCharAlpha IsCharAlphaA
#define IsCharAlphaNumeric IsCharAlphaNumericA
#define IsCharLower IsCharLowerA
#define IsCharUpper IsCharUpperA
#define IsDialogMessage IsDialogMessageA
#define LoadAccelerators LoadAcceleratorsA
#define LoadBitmap LoadBitmapA
#define LoadCursor LoadCursorA
#define LoadIcon LoadIconA
#define LoadCursorFromFile LoadCursorFromFileA
#define LoadImage LoadImageA
#define LoadKeyboardLayout LoadKeyboardLayoutA
#define LoadMenu LoadMenuA
#define LoadMenuIndirect LoadMenuIndirectA
#define LoadString LoadStringA
#define MapVirtualKey MapVirtualKeyA
#define MapVirtualKeyEx MapVirtualKeyExA
#define MessageBox MessageBoxA
#define MessageBoxEx MessageBoxExA
#define MessageBoxIndirect MessageBoxIndirectA
#define ModifyMenu ModifyMenuA
#define OemToChar OemToCharA
#define OemToCharBuff OemToCharBuffA
#define OpenDesktop OpenDesktopA
#define OpenWindowStation OpenWindowStationA
#define PeekMessage PeekMessageA
#define PostAppMessage PostAppMessageA
#define PostMessage PostMessageA
#define PostThreadMessage PostThreadMessageA
#define PrivateExtractIcons PrivateExtractIconsA
#define RealGetWindowClass RealGetWindowClassA
#define RegisterClass RegisterClassA
#define RegisterClassEx RegisterClassExA
#define RegisterClipboardFormat RegisterClipboardFormatA
#define RegisterDeviceNotification RegisterDeviceNotificationA
#define RegisterWindowMessage RegisterWindowMessageA
#define RemoveProp RemovePropA
#define SendDlgItemMessage SendDlgItemMessageA
#define SendMessage SendMessageA
#define SendMessageCallback SendMessageCallbackA
#define SendMessageTimeout SendMessageTimeoutA
#define SendNotifyMessage SendNotifyMessageA
#define SetClassLong SetClassLongA
#define SetClassLongPtr SetClassLongPtrA
#define SetDlgItemText SetDlgItemTextA
#define SetMenuItemInfo SetMenuItemInfoA
#define SetProp SetPropA
#define SetUserObjectInformation SetUserObjectInformationA
#define SetWindowLong SetWindowLongA
#define SetWindowLongPtr SetWindowLongPtrA
#define SetWindowsHook SetWindowsHookA
#define SetWindowsHookEx SetWindowsHookExA
#define SetWindowText SetWindowTextA
#define SystemParametersInfo SystemParametersInfoA
#define TabbedTextOut TabbedTextOutA
#define TranslateAccelerator TranslateAcceleratorA
#define UnregisterClass UnregisterClassA
#define VkKeyScan VkKeyScanA
#define VkKeyScanEx VkKeyScanExA
#define WinHelp WinHelpA
#define wsprintf wsprintfA
#define wvsprintf wvsprintfA
#if defined(_WINGDI_) && !defined(NOGDI)
#define ChangeDisplaySettings ChangeDisplaySettingsA
#define ChangeDisplaySettingsEx ChangeDisplaySettingsExA
#define CreateDesktop CreateDesktopA
#define EnumDisplaySettings EnumDisplaySettingsA
#define EnumDisplaySettingsEx EnumDisplaySettingsExA
#define EnumDisplayDevices EnumDisplayDevicesA
#endif /* _WINGDI_ && !NOGDI */
#endif /* UNICODE */
#endif /* RC_INVOKED */

#ifdef _WINE
#include "reactos/undocuser.h"
#endif

#ifdef _MSC_VER
#pragma warning(pop)
#endif

#ifdef __cplusplus
}
#endif
#endif
