/*
	l3_integer_tables.h: Layer3 Constant tables for integer decoders

	copyright 1995-2009 by the mpg123 project - free software under the terms of the LGPL 2.1
	see COPYING and AUTHORS files in distribution or http://mpg123.org
	initially written by Taihei Monma
*/

#ifndef MPG123_L3_INTEGER_TABLES_H
#define MPG123_L3_INTEGER_TABLES_H

#ifdef PRECALC_TABLES
static const real ispow[8207] =
{
	0,8192,20643,35445,52016,70041,89315,109695,131072,153360,
	176491,200407,225060,250408,276414,303048,330281,358087,386444,415331,
	444730,474623,504995,535830,567116,598839,630988,663552,696521,729884,
	763633,797760,832255,867112,902323,937880,973778,1010010,1046569,1083451,
	1120650,1158160,1195976,1234093,1272507,1311213,1350207,1389485,1429042,1468875,
	1508979,1549352,1589990,1630889,1672046,1713458,1755122,1797035,1839193,1881594,
	1924236,1967115,2010229,2053576,2097152,2140956,2184985,2229238,2273710,2318402,
	2363310,2408432,2453767,2499312,2545065,2591025,2637190,2683558,2730126,2776895,
	2823861,2871023,2918379,2965929,3013670,3061600,3109719,3158025,3206517,3255192,
	3304050,3353089,3402309,3451707,3501282,3551033,3600960,3651060,3701332,3751776,
	3802390,3853172,3904123,3955241,4006524,4057972,4109583,4161357,4213293,4265389,
	4317644,4370058,4422630,4475359,4528243,4581282,4634476,4687822,4741320,4794970,
	4848770,4902720,4956819,5011066,5065460,5120000,5174686,5229517,5284492,5339610,
	5394871,5450274,5505818,5561502,5617327,5673290,5729391,5785631,5842007,5898519,
	5955168,6011951,6068869,6125920,6183105,6240422,6297871,6355451,6413162,6471004,
	6528974,6587074,6645302,6703658,6762141,6820751,6879487,6938349,6997336,7056447,
	7115683,7175042,7234524,7294129,7353855,7413703,7473672,7533762,7593972,7654301,
	7714750,7775317,7836002,7896805,7957725,8018762,8079916,8141185,8202570,8264070,
	8325685,8387413,8449256,8511212,8573281,8635462,8697756,8760161,8822678,8885305,
	8948043,9010892,9073850,9136917,9200094,9263379,9326772,9390274,9453882,9517598,
	9581421,9645351,9709386,9773527,9837774,9902125,9966582,10031143,10095807,10160576,
	10225448,10290423,10355500,10420681,10485963,10551347,10616832,10682419,10748106,10813894,
	10879782,10945770,11011857,11078044,11144330,11210715,11277198,11343779,11410458,11477234,
	11544108,11611079,11678147,11745311,11812571,11879927,11947378,12014925,12082567,12150304,
	12218135,12286061,12354081,12422194,12490401,12558701,12627094,12695580,12764158,12832829,
	12901592,12970446,13039392,13108429,13177557,13246776,13316085,13385485,13454975,13524554,
	13594224,13663982,13733830,13803767,13873792,13943906,14014108,14084398,14154776,14225242,
	14295794,14366435,14437162,14507975,14578876,14649862,14720935,14792093,14863337,14934667,
	15006082,15077582,15149167,15220837,15292591,15364429,15436351,15508358,15580448,15652621,
	15724878,15797217,15869640,15942146,16014734,16087404,16160156,16232991,16305907,16378905,
	16451984,16525145,16598386,16671709,16745112,16818596,16892160,16965804,17039528,17113332,
	17187216,17261179,17335222,17409343,17483544,17557824,17632182,17706618,17781133,17855726,
	17930397,18005146,18079973,18154877,18229858,18304917,18380052,18455265,18530554,18605920,
	18681362,18756880,18832475,18908145,18983891,19059713,19135610,19211583,19287630,19363753,
	19439951,19516223,19592571,19668992,19745488,19822058,19898702,19975420,20052211,20129076,
	20206015,20283027,20360112,20437270,20514501,20591805,20669181,20746630,20824151,20901745,
	20979410,21057148,21134957,21212838,21290791,21368815,21446910,21525076,21603314,21681622,
	21760001,21838451,21916971,21995561,22074222,22152953,22231754,22310625,22389566,22468576,
	22547656,22626806,22706024,22785312,22864669,22944094,23023589,23103152,23182783,23262484,
	23342252,23422089,23501993,23581966,23662007,23742115,23822291,23902534,23982845,24063223,
	24143669,24224181,24304761,24385407,24466120,24546899,24627745,24708658,24789637,24870682,
	24951793,25032970,25114213,25195521,25276895,25358335,25439841,25521411,25603047,25684748,
	25766514,25848345,25930241,26012201,26094226,26176316,26258469,26340688,26422970,26505317,
	26587727,26670202,26752740,26835342,26918008,27000737,27083530,27166386,27249305,27332287,
	27415332,27498440,27581611,27664845,27748142,27831501,27914922,27998406,28081952,28165561,
	28249231,28332963,28416758,28500614,28584532,28668511,28752552,28836655,28920819,29005044,
	29089330,29173677,29258086,29342555,29427085,29511676,29596328,29681040,29765813,29850646,
	29935539,30020493,30105507,30190581,30275714,30360908,30446162,30531475,30616848,30702280,
	30787772,30873323,30958934,31044604,31130332,31216120,31301967,31387873,31473838,31559862,
	31645944,31732084,31818284,31904541,31990857,32077231,32163664,32250154,32336703,32423309,
	32509974,32596696,32683476,32770313,32857208,32944161,33031171,33118238,33205363,33292544,
	33379783,33467079,33554432,33641842,33729308,33816832,33904412,33992048,34079741,34167491,
	34255297,34343159,34431078,34519052,34607083,34695170,34783312,34871511,34959765,35048075,
	35136441,35224862,35313339,35401872,35490459,35579102,35667801,35756554,35845363,35934226,
	36023145,36112118,36201147,36290230,36379367,36468560,36557807,36647108,36736464,36825875,
	36915339,37004858,37094431,37184058,37273739,37363474,37453263,37543106,37633003,37722953,
	37812957,37903015,37993126,38083291,38173509,38263780,38354105,38444483,38534914,38625398,
	38715935,38806525,38897168,38987864,39078612,39169414,39260268,39351174,39442133,39533145,
	39624209,39715325,39806494,39897714,39988987,40080312,40171690,40263119,40354600,40446133,
	40537718,40629354,40721042,40812782,40904574,40996417,41088311,41180257,41272254,41364303,
	41456402,41548553,41640755,41733008,41825313,41917668,42010074,42102530,42195038,42287596,
	42380205,42472865,42565575,42658336,42751147,42844009,42936921,43029883,43122895,43215958,
	43309070,43402233,43495446,43588709,43682022,43775384,43868797,43962259,44055771,44149332,
	44242943,44336604,44430314,44524073,44617882,44711741,44805648,44899605,44993611,45087666,
	45181770,45275923,45370126,45464377,45558677,45653025,45747423,45841869,45936364,46030908,
	46125500,46220141,46314830,46409567,46504353,46599187,46694070,46789001,46883980,46979007,
	47074082,47169205,47264376,47359595,47454862,47550177,47645540,47740950,47836408,47931914,
	48027467,48123068,48218716,48314412,48410155,48505945,48601783,48697668,48793601,48889580,
	48985607,49081681,49177802,49273969,49370184,49466446,49562754,49659109,49755511,49851960,
	49948456,50044998,50141586,50238222,50334903,50431631,50528406,50625227,50722094,50819007,
	50915967,51012973,51110025,51207123,51304267,51401457,51498694,51595976,51693304,51790677,
	51888097,51985562,52083073,52180630,52278232,52375880,52473573,52571312,52669097,52766926,
	52864801,52962722,53060688,53158699,53256755,53354856,53453002,53551194,53649430,53747712,
	53846038,53944410,54042826,54141287,54239793,54338344,54436939,54535579,54634263,54732993,
	54831766,54930585,55029447,55128354,55227306,55326302,55425342,55524426,55623555,55722728,
	55821945,55921206,56020511,56119860,56219253,56318690,56418171,56517696,56617265,56716877,
	56816534,56916234,57015977,57115764,57215595,57315470,57415388,57515349,57615354,57715403,
	57815494,57915629,58015808,58116029,58216294,58316602,58416954,58517348,58617785,58718266,
	58818789,58919356,59019965,59120617,59221312,59322050,59422831,59523654,59624521,59725429,
	59826381,59927375,60028412,60129491,60230613,60331777,60432983,60534232,60635524,60736857,
	60838233,60939651,61041112,61142614,61244159,61345746,61447375,61549046,61650759,61752513,
	61854310,61956149,62058030,62159952,62261916,62363922,62465970,62568059,62670191,62772363,
	62874578,62976833,63079131,63181470,63283850,63386272,63488735,63591239,63693785,63796372,
	63899001,64001670,64104381,64207133,64309926,64412760,64515636,64618552,64721509,64824507,
	64927546,65030627,65133747,65236909,65340112,65443355,65546639,65649964,65753329,65856735,
	65960182,66063669,66167197,66270765,66374374,66478023,66581713,66685443,66789213,66893024,
	66996875,67100766,67204698,67308669,67412681,67516733,67620825,67724957,67829130,67933342,
	68037594,68141886,68246218,68350590,68455002,68559454,68663945,68768476,68873047,68977658,
	69082308,69186998,69291728,69396497,69501306,69606154,69711042,69815969,69920936,70025942,
	70130987,70236072,70341196,70446360,70551562,70656804,70762085,70867406,70972765,71078164,
	71183601,71289078,71394594,71500149,71605742,71711375,71817046,71922757,72028506,72134294,
	72240121,72345987,72451891,72557835,72663817,72769837,72875896,72981994,73088130,73194305,
	73300519,73406770,73513061,73619389,73725757,73832162,73938606,74045088,74151609,74258168,
	74364765,74471400,74578073,74684785,74791535,74898323,75005149,75112012,75218914,75325854,
	75432832,75539848,75646902,75753994,75861123,75968291,76075496,76182739,76290020,76397338,
	76504694,76612088,76719520,76826989,76934495,77042040,77149622,77257241,77364898,77472592,
	77580324,77688093,77795899,77903743,78011625,78119543,78227499,78335492,78443522,78551590,
	78659695,78767836,78876015,78984232,79092485,79200775,79309102,79417467,79525868,79634306,
	79742781,79851293,79959842,80068428,80177050,80285710,80394406,80503139,80611908,80720715,
	80829558,80938438,81047354,81156307,81265296,81374322,81483385,81592484,81701620,81810792,
	81920000,82029245,82138526,82247844,82357198,82466588,82576014,82685477,82794976,82904512,
	83014083,83123691,83233334,83343014,83452730,83562482,83672271,83782095,83891955,84001851,
	84111783,84221751,84331755,84441795,84551870,84661982,84772129,84882312,84992531,85102786,
	85213076,85323402,85433764,85544161,85654594,85765063,85875567,85986107,86096682,86207293,
	86317939,86428621,86539338,86650091,86760879,86871702,86982561,87093455,87204384,87315349,
	87426349,87537384,87648455,87759560,87870701,87981877,88093088,88204334,88315616,88426932,
	88538283,88649670,88761091,88872548,88984039,89095565,89207126,89318723,89430353,89542019,
	89653720,89765455,89877226,89989030,90100870,90212745,90324654,90436598,90548576,90660589,
	90772637,90884719,90996836,91108987,91221173,91333394,91445648,91557938,91670262,91782620,
	91895012,92007439,92119901,92232396,92344926,92457491,92570089,92682722,92795389,92908090,
	93020826,93133595,93246399,93359237,93472109,93585015,93697955,93810929,93923937,94036980,
	94150056,94263166,94376310,94489488,94602700,94715946,94829225,94942539,95055886,95169267,
	95282682,95396131,95509613,95623129,95736679,95850263,95963880,96077530,96191215,96304933,
	96418684,96532470,96646288,96760140,96874026,96987945,97101898,97215884,97329904,97443956,
	97558043,97672162,97786315,97900502,98014721,98128974,98243260,98357580,98471933,98586318,
	98700737,98815190,98929675,99044194,99158745,99273330,99387948,99502598,99617282,99731999,
	99846749,99961532,100076348,100191197,100306078,100420993,100535940,100650921,100765934,100880980,
	100996059,101111170,101226315,101341492,101456702,101571944,101687220,101802528,101917868,102033241,
	102148647,102264086,102379557,102495061,102610597,102726166,102841767,102957401,103073067,103188765,
	103304497,103420260,103536056,103651884,103767745,103883638,103999563,104115521,104231511,104347533,
	104463588,104579675,104695794,104811945,104928128,105044344,105160592,105276871,105393183,105509527,
	105625904,105742312,105858752,105975224,106091729,106208265,106324833,106441433,106558066,106674730,
	106791426,106908154,107024913,107141705,107258528,107375384,107492271,107609190,107726140,107843123,
	107960137,108077182,108194260,108311369,108428510,108545683,108662887,108780122,108897390,109014689,
	109132019,109249381,109366775,109484200,109601656,109719144,109836664,109954215,110071797,110189411,
	110307056,110424733,110542441,110660180,110777950,110895752,111013585,111131450,111249346,111367273,
	111485231,111603220,111721241,111839292,111957375,112075489,112193635,112311811,112430018,112548257,
	112666526,112784827,112903159,113021521,113139915,113258339,113376795,113495282,113613799,113732347,
	113850927,113969537,114088178,114206850,114325552,114444286,114563050,114681845,114800671,114919528,
	115038415,115157333,115276282,115395262,115514272,115633313,115752384,115871486,115990619,116109783,
	116228976,116348201,116467456,116586742,116706058,116825404,116944781,117064189,117183627,117303095,
	117422594,117542124,117661683,117781273,117900894,118020545,118140226,118259937,118379679,118499451,
	118619253,118739086,118858948,118978842,119098765,119218718,119338702,119458716,119578759,119698834,
	119818938,119939072,120059236,120179431,120299655,120419910,120540194,120660509,120780854,120901228,
	121021633,121142067,121262532,121383026,121503550,121624105,121744689,121865303,121985946,122106620,
	122227323,122348057,122468820,122589613,122710435,122831287,122952170,123073081,123194023,123314994,
	123435995,123557025,123678085,123799175,123920295,124041444,124162622,124283830,124405068,124526335,
	124647632,124768959,124890314,125011700,125133114,125254559,125376032,125497536,125619068,125740630,
	125862221,125983842,126105492,126227171,126348880,126470618,126592386,126714182,126836008,126957863,
	127079748,127201661,127323604,127445576,127567578,127689608,127811668,127933756,128055874,128178021,
	128300197,128422403,128544637,128666900,128789193,128911514,129033865,129156244,129278652,129401090,
	129523556,129646052,129768576,129891129,130013711,130136323,130258963,130381631,130504329,130627056,
	130749811,130872595,130995408,131118250,131241120,131364020,131486948,131609905,131732890,131855904,
	131978947,132102019,132225119,132348248,132471406,132594592,132717807,132841050,132964323,133087623,
	133210952,133334310,133457696,133581111,133704554,133828026,133951527,134075055,134198613,134322198,
	134445812,134569455,134693126,134816825,134940553,135064309,135188094,135311906,135435747,135559617,
	135683515,135807441,135931395,136055378,136179388,136303427,136427495,136551590,136675714,136799866,
	136924046,137048254,137172490,137296755,137421048,137545368,137669717,137794094,137918499,138042932,
	138167393,138291882,138416400,138540945,138665518,138790119,138914748,139039405,139164090,139288803,
	139413544,139538313,139663110,139787934,139912787,140037667,140162575,140287511,140412475,140537467,
	140662486,140787533,140912608,141037711,141162842,141288000,141413186,141538399,141663641,141788910,
	141914207,142039531,142164883,142290263,142415670,142541105,142666567,142792057,142917575,143043120,
	143168693,143294294,143419921,143545577,143671260,143796970,143922708,144048473,144174266,144300086,
	144425934,144551809,144677712,144803641,144929599,145055583,145181595,145307635,145433701,145559795,
	145685917,145812065,145938241,146064445,146190675,146316933,146443218,146569530,146695869,146822236,
	146948630,147075051,147201499,147327974,147454477,147581007,147707563,147834147,147960758,148087396,
	148214061,148340754,148467473,148594219,148720993,148847793,148974620,149101475,149228356,149355264,
	149482200,149609162,149736151,149863167,149990210,150117280,150244377,150371501,150498652,150625829,
	150753033,150880265,151007523,151134807,151262119,151389457,151516823,151644215,151771633,151899079,
	152026551,152154050,152281576,152409128,152536707,152664313,152791945,152919604,153047290,153175002,
	153302741,153430507,153558299,153686118,153813963,153941835,154069734,154197659,154325610,154453588,
	154581593,154709624,154837682,154965766,155093876,155222013,155350177,155478367,155606583,155734826,
	155863095,155991391,156119713,156248061,156376436,156504837,156633264,156761718,156890198,157018704,
	157147237,157275796,157404381,157532993,157661630,157790294,157918985,158047701,158176444,158305212,
	158434008,158562829,158691676,158820550,158949449,159078375,159207327,159336305,159465310,159594340,
	159723396,159852479,159981587,160110722,160239882,160369069,160498282,160627520,160756785,160886076,
	161015392,161144735,161274103,161403498,161532918,161662365,161791837,161921335,162050859,162180409,
	162309985,162439587,162569215,162698868,162828547,162958252,163087983,163217740,163347523,163477331,
	163607165,163737025,163866910,163996822,164126759,164256722,164386710,164516724,164646764,164776830,
	164906921,165037038,165167181,165297349,165427543,165557762,165688007,165818278,165948574,166078896,
	166209243,166339616,166470015,166600439,166730888,166861363,166991864,167122390,167252942,167383519,
	167514122,167644750,167775403,167906082,168036786,168167516,168298271,168429052,168559858,168690689,
	168821546,168952428,169083335,169214268,169345226,169476210,169607219,169738253,169869312,170000397,
	170131507,170262642,170393802,170524988,170656199,170787435,170918696,171049983,171181295,171312632,
	171443994,171575381,171706793,171838231,171969694,172101182,172232695,172364233,172495796,172627384,
	172758997,172890636,173022299,173153988,173285702,173417440,173549204,173680993,173812806,173944645,
	174076509,174208397,174340311,174472249,174604213,174736201,174868215,175000253,175132316,175264404,
	175396517,175528655,175660818,175793005,175925218,176057455,176189717,176322004,176454316,176586653,
	176719014,176851400,176983811,177116247,177248708,177381193,177513703,177646237,177778797,177911381,
	178043990,178176624,178309282,178441965,178574672,178707405,178840162,178972943,179105749,179238580,
	179371435,179504316,179637220,179770149,179903103,180036082,180169084,180302112,180435164,180568240,
	180701342,180834467,180967617,181100792,181233991,181367214,181500462,181633735,181767032,181900353,
	182033699,182167069,182300464,182433883,182567326,182700794,182834286,182967803,183101344,183234909,
	183368499,183502113,183635751,183769414,183903101,184036812,184170548,184304307,184438092,184571900,
	184705732,184839589,184973470,185107376,185241305,185375259,185509237,185643239,185777266,185911316,
	186045391,186179490,186313613,186447760,186581931,186716126,186850346,186984590,187118857,187253149,
	187387465,187521805,187656169,187790557,187924969,188059405,188193866,188328350,188462858,188597390,
	188731946,188866527,189001131,189135759,189270411,189405087,189539787,189674511,189809259,189944031,
	190078827,190213646,190348490,190483357,190618249,190753164,190888103,191023066,191158052,191293063,
	191428097,191563155,191698237,191833343,191968473,192103626,192238803,192374004,192509229,192644477,
	192779749,192915045,193050365,193185708,193321075,193456466,193591881,193727319,193862781,193998266,
	194133775,194269308,194404864,194540444,194676048,194811675,194947326,195083001,195218699,195354421,
	195490166,195625935,195761727,195897543,196033383,196169246,196305132,196441042,196576976,196712933,
	196848914,196984918,197120945,197256996,197393071,197529169,197665290,197801435,197937603,198073795,
	198210010,198346249,198482510,198618796,198755104,198891437,199027792,199164171,199300573,199436998,
	199573447,199709919,199846415,199982934,200119476,200256041,200392630,200529242,200665877,200802535,
	200939217,201075922,201212650,201349402,201486176,201622974,201759795,201896639,202033507,202170398,
	202307311,202444248,202581209,202718192,202855198,202992228,203129281,203266357,203403456,203540578,
	203677723,203814891,203952082,204089297,204226534,204363795,204501078,204638385,204775715,204913067,
	205050443,205187842,205325264,205462708,205600176,205737667,205875180,206012717,206150277,206287859,
	206425465,206563093,206700745,206838419,206976116,207113836,207251579,207389345,207527134,207664946,
	207802780,207940638,208078518,208216421,208354347,208492295,208630267,208768261,208906279,209044319,
	209182381,209320467,209458575,209596706,209734860,209873037,210011236,210149458,210287703,210425971,
	210564261,210702574,210840910,210979268,211117649,211256053,211394480,211532929,211671400,211809895,
	211948412,212086952,212225514,212364099,212502706,212641337,212779989,212918665,213057363,213196083,
	213334826,213473592,213612380,213751191,213890024,214028880,214167758,214306659,214445582,214584528,
	214723497,214862488,215001501,215140537,215279595,215418676,215557779,215696904,215836053,215975223,
	216114416,216253631,216392869,216532129,216671412,216810717,216950044,217089394,217228766,217368160,
	217507577,217647016,217786477,217925961,218065467,218204996,218344546,218484119,218623715,218763332,
	218902972,219042634,219182319,219322026,219461754,219601506,219741279,219881075,220020893,220160733,
	220300595,220440479,220580386,220720315,220860266,221000239,221140235,221280252,221420292,221560354,
	221700438,221840544,221980672,222120823,222260995,222401190,222541406,222681645,222821906,222962189,
	223102494,223242821,223383170,223523541,223663934,223804350,223944787,224085246,224225728,224366231,
	224506756,224647303,224787873,224928464,225069077,225209712,225350370,225491049,225631750,225772473,
	225913218,226053985,226194773,226335584,226476417,226617271,226758148,226899046,227039966,227180908,
	227321872,227462858,227603865,227744895,227885946,228027019,228168114,228309231,228450369,228591529,
	228732712,228873916,229015141,229156389,229297658,229438949,229580262,229721596,229862953,230004331,
	230145730,230287152,230428595,230570060,230711546,230853055,230994585,231136136,231277709,231419304,
	231560921,231702559,231844219,231985901,232127604,232269329,232411076,232552844,232694633,232836445,
	232978278,233120132,233262008,233403906,233545825,233687766,233829728,233971712,234113717,234255744,
	234397793,234539863,234681954,234824068,234966202,235108358,235250536,235392735,235534955,235677197,
	235819461,235961746,236104052,236246380,236388729,236531100,236673492,236815905,236958340,237100797,
	237243274,237385774,237528294,237670836,237813399,237955984,238098590,238241217,238383866,238526536,
	238669228,238811940,238954674,239097430,239240207,239383005,239525824,239668664,239811526,239954409,
	240097314,240240240,240383187,240526155,240669144,240812155,240955187,241098240,241241314,241384410,
	241527527,241670665,241813824,241957005,242100206,242243429,242386673,242529938,242673224,242816532,
	242959860,243103210,243246581,243389973,243533386,243676820,243820276,243963752,244107249,244250768,
	244394308,244537869,244681450,244825053,244968677,245112322,245255989,245399676,245543384,245687113,
	245830863,245974635,246118427,246262240,246406074,246549930,246693806,246837703,246981621,247125560,
	247269521,247413502,247557504,247701527,247845571,247989635,248133721,248277828,248421956,248566104,
	248710273,248854464,248998675,249142907,249287160,249431434,249575729,249720044,249864381,250008738,
	250153116,250297515,250441935,250586375,250730837,250875319,251019822,251164346,251308890,251453456,
	251598042,251742649,251887277,252031925,252176594,252321284,252465995,252610727,252755479,252900252,
	253045045,253189860,253334695,253479551,253624427,253769324,253914242,254059181,254204140,254349120,
	254494121,254639142,254784184,254929246,255074329,255219433,255364558,255509703,255654868,255800054,
	255945261,256090489,256235737,256381006,256526295,256671605,256816935,256962286,257107657,257253049,
	257398462,257543895,257689349,257834823,257980318,258125833,258271369,258416925,258562502,258708099,
	258853717,258999355,259145014,259290693,259436392,259582112,259727853,259873614,260019395,260165197,
	260311019,260456862,260602725,260748609,260894513,261040437,261186382,261332347,261478333,261624339,
	261770365,261916411,262062478,262208566,262354674,262500802,262646950,262793119,262939308,263085517,
	263231747,263377997,263524267,263670558,263816869,263963200,264109551,264255923,264402315,264548728,
	264695160,264841613,264988086,265134579,265281093,265427627,265574181,265720755,265867349,266013964,
	266160599,266307254,266453929,266600625,266747340,266894076,267040832,267187608,267334404,267481221,
	267628057,267774914,267921791,268068688,268215605,268362542,268509500,268656477,268803475,268950493,
	269097530,269244588,269391666,269538764,269685882,269833021,269980179,270127357,270274555,270421774,
	270569012,270716271,270863549,271010848,271158166,271305505,271452863,271600242,271747640,271895059,
	272042497,272189956,272337434,272484933,272632451,272779990,272927548,273075126,273222724,273370342,
	273517981,273665639,273813316,273961014,274108732,274256470,274404227,274552005,274699802,274847619,
	274995456,275143313,275291190,275439087,275587003,275734940,275882896,276030872,276178868,276326884,
	276474919,276622975,276771050,276919145,277067260,277215394,277363549,277511723,277659917,277808130,
	277956364,278104617,278252890,278401183,278549496,278697828,278846180,278994552,279142943,279291354,
	279439785,279588236,279736706,279885196,280033706,280182236,280330785,280479353,280627942,280776550,
	280925178,281073825,281222493,281371179,281519886,281668612,281817358,281966123,282114908,282263713,
	282412537,282561381,282710244,282859127,283008030,283156952,283305894,283454855,283603836,283752836,
	283901856,284050896,284199955,284349034,284498132,284647250,284796387,284945544,285094721,285243917,
	285393132,285542367,285691621,285840895,285990189,286139502,286288834,286438186,286587557,286736948,
	286886358,287035788,287185237,287334706,287484194,287633701,287783228,287932774,288082340,288231925,
	288381530,288531154,288680797,288830460,288980142,289129844,289279565,289429305,289579065,289728844,
	289878642,290028460,290178297,290328153,290478029,290627924,290777839,290927773,291077726,291227698,
	291377690,291527701,291677731,291827781,291977850,292127938,292278045,292428172,292578318,292728484,
	292878668,293028872,293179095,293329337,293479599,293629880,293780180,293930499,294080837,294231195,
	294381572,294531968,294682383,294832818,294983272,295133744,295284237,295434748,295585278,295735828,
	295886396,296036984,296187591,296338218,296488863,296639527,296790211,296940914,297091636,297242377,
	297393137,297543916,297694714,297845532,297996368,298147224,298298098,298448992,298599905,298750837,
	298901788,299052758,299203747,299354755,299505782,299656829,299807894,299958978,300110081,300261204,
	300412345,300563505,300714685,300865883,301017101,301168337,301319592,301470867,301622160,301773472,
	301924804,302076154,302227523,302378911,302530318,302681744,302833189,302984653,303136136,303287638,
	303439159,303590698,303742257,303893834,304045431,304197046,304348680,304500333,304652005,304803696,
	304955405,305107134,305258881,305410648,305562433,305714237,305866060,306017901,306169762,306321641,
	306473539,306625456,306777392,306929347,307081320,307233312,307385323,307537353,307689402,307841469,
	307993555,308145660,308297784,308449927,308602088,308754268,308906467,309058684,309210921,309363176,
	309515449,309667742,309820053,309972383,310124732,310277099,310429485,310581890,310734313,310886755,
	311039216,311191696,311344194,311496711,311649247,311801801,311954374,312106965,312259575,312412204,
	312564852,312717518,312870203,313022906,313175628,313328369,313481128,313633906,313786703,313939518,
	314092351,314245204,314398074,314550964,314703872,314856799,315009744,315162708,315315690,315468691,
	315621710,315774748,315927805,316080880,316233973,316387086,316540216,316693365,316846533,316999719,
	317152924,317306147,317459389,317612649,317765928,317919225,318072541,318225875,318379228,318532599,
	318685988,318839396,318992823,319146268,319299731,319453213,319606713,319760232,319913769,320067324,
	320220898,320374491,320528101,320681731,320835378,320989044,321142729,321296431,321450153,321603892,
	321757650,321911426,322065221,322219034,322372865,322526715,322680583,322834470,322988374,323142297,
	323296239,323450199,323604177,323758173,323912188,324066221,324220272,324374342,324528430,324682536,
	324836660,324990803,325144964,325299144,325453341,325607557,325761791,325916044,326070314,326224603,
	326378910,326533236,326687579,326841941,326996321,327150720,327305136,327459571,327614024,327768495,
	327922984,328077492,328232018,328386562,328541124,328695704,328850302,329004919,329159554,329314207,
	329468878,329623567,329778275,329933000,330087744,330242506,330397286,330552084,330706900,330861735,
	331016587,331171458,331326347,331481254,331636178,331791121,331946083,332101062,332256059,332411074,
	332566108,332721159,332876229,333031317,333186422,333341546,333496688,333651848,333807026,333962221,
	334117435,334272667,334427917,334583185,334738471,334893776,335049098,335204438,335359796,335515172,
	335670566,335825978,335981408,336136856,336292322,336447806,336603308,336758828,336914365,337069921,
	337225495,337381087,337536696,337692324,337847969,338003633,338159314,338315013,338470730,338626465,
	338782218,338937989,339093778,339249585,339405409,339561252,339717112,339872990,340028886,340184800,
	340340732,340496682,340652650,340808635,340964638,341120659,341276698,341432755,341588830,341744922,
	341901032,342057161,342213306,342369470,342525652,342681851,342838068,342994303,343150556,343306826,
	343463115,343619421,343775745,343932086,344088446,344244823,344401218,344557631,344714061,344870509,
	345026975,345183459,345339960,345496480,345653016,345809571,345966143,346122733,346279341,346435967,
	346592610,346749271,346905949,347062646,347219359,347376091,347532840,347689607,347846392,348003194,
	348160014,348316852,348473707,348630580,348787471,348944379,349101305,349258249,349415210,349572189,
	349729185,349886199,350043231,350200280,350357347,350514432,350671534,350828653,350985791,351142946,
	351300118,351457308,351614516,351771741,351928984,352086244,352243522,352400817,352558130,352715461,
	352872809,353030175,353187558,353344959,353502377,353659813,353817266,353974737,354132225,354289731,
	354447254,354604795,354762354,354919929,355077523,355235134,355392762,355550408,355708071,355865752,
	356023450,356181166,356338899,356496649,356654418,356812203,356970006,357127826,357285664,357443520,
	357601392,357759282,357917190,358075115,358233057,358391017,358548994,358706989,358865001,359023030,
	359181077,359339141,359497223,359655322,359813438,359971572,360129723,360287891,360446077,360604280,
	360762501,360920738,361078994,361237266,361395556,361553863,361712188,361870530,362028889,362187265,
	362345659,362504070,362662499,362820944,362979407,363137888,363296385,363454900,363613432,363771982,
	363930549,364089133,364247734,364406353,364564988,364723642,364882312,365041000,365199704,365358426,
	365517166,365675922,365834696,365993487,366152296,366311121,366469964,366628824,366787701,366946595,
	367105507,367264435,367423381,367582344,367741325,367900322,368059337,368218369,368377418,368536484,
	368695567,368854668,369013785,369172920,369332072,369491241,369650428,369809631,369968852,370128089,
	370287344,370446616,370605905,370765211,370924535,371083875,371243232,371402607,371561999,371721408,
	371880833,372040276,372199737,372359214,372518708,372678219,372837748,372997293,373156856,373316435,
	373476032,373635645,373795276,373954924,374114589,374274270,374433969,374593685,374753418,374913168,
	375072935,375232719,375392520,375552338,375712173,375872025,376031894,376191780,376351683,376511603,
	376671540,376831494,376991465,377151453,377311458,377471479,377631518,377791574,377951647,378111736,
	378271843,378431966,378592107,378752264,378912439,379072630,379232838,379393063,379553305,379713564,
	379873840,380034133,380194443,380354769,380515113,380675473,380835850,380996244,381156655,381317083,
	381477528,381637990,381798468,381958964,382119476,382280005,382440551,382601114,382761694,382922290,
	383082903,383243534,383404181,383564844,383725525,383886223,384046937,384207668,384368416,384529181,
	384689962,384850761,385011576,385172408,385333256,385494122,385655004,385815903,385976819,386137752,
	386298701,386459667,386620650,386781650,386942667,387103700,387264750,387425816,387586900,387748000,
	387909117,388070251,388231401,388392568,388553752,388714952,388876170,389037404,389198654,389359922,
	389521206,389682507,389843824,390005158,390166509,390327877,390489261,390650662,390812079,390973513,
	391134964,391296432,391457916,391619417,391780934,391942469,392104019,392265587,392427171,392588772,
	392750389,392912023,393073674,393235341,393397025,393558725,393720442,393882176,394043926,394205693,
	394367477,394529277,394691093,394852927,395014776,395176643,395338526,395500425,395662342,395824274,
	395986224,396148189,396310172,396472171,396634186,396796218,396958267,397120332,397282414,397444512,
	397606627,397768758,397930906,398093070,398255251,398417448,398579662,398741892,398904139,399066402,
	399228682,399390979,399553291,399715621,399877966,400040329,400202707,400365103,400527514,400689943,
	400852387,401014848,401177326,401339820,401502330,401664857,401827400,401989960,402152536,402315129,
	402477738,402640363,402803005,402965664,403128338,403291030,403453737,403616461,403779201,403941958,
	404104731,404267521,404430327,404593149,404755988,404918843,405081715,405244602,405407507,405570427,
	405733364,405896317,406059287,406222273,406385275,406548294,406711329,406874381,407037448,407200532,
	407363633,407526750,407689883,407853032,408016198,408179380,408342578,408505793,408669024,408832271,
	408995534,409158814,409322110,409485423,409648751,409812096,409975457,410138835,410302229,410465639,
	410629065,410792508,410955967,411119442,411282933,411446441,411609964,411773505,411937061,412100633,
	412264222,412427827,412591449,412755086,412918740,413082410,413246096,413409798,413573517,413737251,
	413901002,414064769,414228553,414392352,414556168,414720000,414883848,415047712,415211593,415375489,
	415539402,415703331,415867276,416031238,416195215,416359209,416523218,416687244,416851286,417015344,
	417179419,417343509,417507616,417671738,417835877,418000032,418164203,418328390,418492594,418656813,
	418821048,418985300,419149568,419313852,419478151,419642467,419806800,419971148,420135512,420299892,
	420464289,420628701,420793130,420957574,421122035,421286511,421451004,421615513,421780038,421944579,
	422109136,422273709,422438298,422602903,422767524,422932161,423096814,423261483,423426168,423590870,
	423755587,423920320,424085069,424249834,424414616,424579413,424744226,424909055,425073900,425238762,
	425403639,425568532,425733441,425898366,426063307,426228264,426393237,426558226,426723231,426888252,
	427053288,427218341,427383410,427548494,427713595,427878711,428043844,428208992,428374156,428539337,
	428704533,428869745,429034973,429200217,429365476,429530752,429696043,429861351,430026674,430192013,
	430357369,430522740,430688126,430853529,431018948,431184382,431349833,431515299,431680781,431846279,
	432011793,432177323,432342868,432508430,432674007,432839600,433005209,433170834,433336474,433502131,
	433667803,433833491,433999195,434164914,434330650,434496401,434662168,434827951,434993750,435159565,
	435325395,435491241,435657103,435822981,435988874,436154784,436320709,436486650,436652606,436818579,
	436984567,437150571,437316590,437482626,437648677,437814744,437980827,438146925,438313039,438479169,
	438645315,438811476,438977653,439143846,439310055,439476279,439642519,439808775,439975046,440141333,
	440307636,440473955,440640289,440806639,440973005,441139386,441305783,441472196,441638624,441805068,
	441971528,442138004,442304495,442471002,442637524,442804062,442970616,443137185,443303770,443470371,
	443636988,443803620,443970267,444136931,444303610,444470304,444637014,444803740,444970482,445137239,
	445304012,445470800,445637604,445804423,445971259,446138109,446304976,446471858,446638755,446805668,
	446972597,447139542,447306501,447473477,447640468,447807475,447974497,448141535,448308588,448475657,
	448642742,448809842,448976957,449144088,449311235,449478397,449645575,449812768,449979977,450147202,
	450314442,450481697,450648968,450816255,450983557,451150874,451318207,451485556,451652920,451820300,
	451987695,452155105,452322531,452489973,452657430,452824903,452992391,453159894,453327413,453494948,
	453662498,453830063,453997644,454165240,454332852,454500480,454668122,454835781,455003454,455171143,
	455338848,455506568,455674303,455842054,456009821,456177602,456345399,456513212,456681040,456848884,
	457016742,457184617,457352506,457520411,457688332,457856268,458024219,458192186,458360168,458528165,
	458696178,458864207,459032250,459200309,459368384,459536474,459704579,459872699,460040835,460208986,
	460377153,460545335,460713532,460881745,461049973,461218216,461386475,461554749,461723039,461891343,
	462059663,462227999,462396350,462564716,462733097,462901494,463069906,463238333,463406776,463575234,
	463743707,463912196,464080699,464249219,464417753,464586303,464754868,464923448,465092044,465260655,
	465429281,465597922,465766579,465935251,466103938,466272641,466441358,466610091,466778840,466947603,
	467116382,467285176,467453985,467622810,467791650,467960505,468129375,468298260,468467161,468636077,
	468805008,468973954,469142916,469311893,469480885,469649892,469818914,469987952,470157005,470326073,
	470495156,470664254,470833368,471002497,471171641,471340800,471509974,471679164,471848368,472017588,
	472186823,472356073,472525339,472694619,472863915,473033226,473202552,473371893,473541249,473710620,
	473880007,474049409,474218825,474388257,474557704,474727167,474896644,475066136,475235644,475405167,
	475574704,475744257,475913825,476083408,476253007,476422620,476592248,476761892,476931550,477101224,
	477270913,477440617,477610336,477780070,477949819,478119583,478289362,478459157,478628966,478798790,
	478968630,479138484,479308354,479478239,479648138,479818053,479987983,480157928,480327888,480497863,
	480667853,480837858,481007878,481177913,481347963,481518028,481688108,481858203,482028313,482198438,
	482368578,482538734,482708904,482879089,483049289,483219504,483389734,483559979,483730240,483900515,
	484070805,484241110,484411430,484581765,484752115,484922480,485092860,485263254,485433664,485604089,
	485774529,485944983,486115453,486285938,486456437,486626952,486797481,486968025,487138585,487309159,
	487479748,487650352,487820971,487991605,488162254,488332917,488503596,488674290,488844998,489015721,
	489186460,489357213,489527981,489698764,489869562,490040374,490211202,490382044,490552902,490723774,
	490894661,491065563,491236480,491407412,491578358,491749320,491920296,492091287,492262294,492433314,
	492604350,492775401,492946466,493117547,493288642,493459752,493630876,493802016,493973171,494144340,
	494315524,494486723,494657937,494829165,495000409,495171667,495342940,495514228,495685530,495856848,
	496028180,496199527,496370889,496542265,496713657,496885063,497056484,497227919,497399370,497570835,
	497742315,497913810,498085320,498256844,498428383,498599937,498771506,498943089,499114687,499286300,
	499457928,499629570,499801227,499972899,500144586,500316287,500488003,500659734,500831480,501003240,
	501175015,501346805,501518609,501690428,501862262,502034111,502205974,502377852,502549745,502721652,
	502893574,503065511,503237462,503409429,503581409,503753405,503925415,504097440,504269480,504441534,
	504613603,504785686,504957785,505129897,505302025,505474167,505646324,505818496,505990682,506162883,
	506335098,506507328,506679573,506851833,507024107,507196395,507368699,507541017,507713349,507885697,
	508058058,508230435,508402826,508575232,508747652,508920087,509092536,509265000,509437479,509609972,
	509782480,509955003,510127540,510300092,510472658,510645239,510817834,510990444,511163069,511335708,
	511508362,511681030,511853713,512026411,512199123,512371849,512544590,512717346,512890116,513062901,
	513235701,513408514,513581343,513754186,513927043,514099916,514272802,514445703,514618619,514791549,
	514964494,515137453,515310427,515483415,515656418,515829435,516002467,516175513,516348574,516521649,
	516694739,516867844,517040962,517214096,517387243,517560406,517733582,517906774,518079979,518253200,
	518426434,518599683,518772947,518946225,519119518,519292825,519466146,519639482,519812833,519986197,
	520159577,520332970,520506379,520679801,520853238,521026690,521200156,521373636,521547131,521720640,
	521894164,522067702,522241255,522414822,522588403,522761999,522935609,523109234,523282873,523456526,
	523630194,523803876,523977573,524151284,524325009,524498749,524672503,524846272,525020055,525193852,
	525367664,525541490,525715330,525889185,526063054,526236938,526410836,526584748,526758675,526932616,
	527106571,527280541,527454525,527628524,527802536,527976563,528150605,528324661,528498731,528672815,
	528846914,529021027,529195155,529369297,529543453,529717623,529891808,530066007,530240220,530414448,
	530588690,530762946,530937217,531111502,531285801,531460115,531634442,531808785,531983141,532157512,
	532331897,532506296,532680709,532855137,533029579,533204036,533378506,533552991,533727490,533902004,
	534076531,534251073,534425630,534600200,534774785,534949384,535123997,535298624,535473266,535647922,
	535822592,535997276,536171975,536346688,536521415,536696156,536870912,537045682,537220466,537395264,
	537570076,537744903,537919744,538094599,538269468,538444352,538619249,538794161,538969087,539144028,
	539318982,539493951,539668934,539843931,540018942,540193967,540369007,540544060,540719128,540894210,
	541069307,541244417,541419542,541594680,541769833,541945000,542120182,542295377,542470587,542645810,
	542821048,542996300,543171566,543346846,543522141,543697449,543872772,544048109,544223460,544398825,
	544574204,544749597,544925004,545100426,545275862,545451311,545626775,545802253,545977745,546153251,
	546328772,546504306,546679854,546855417,547030994,547206584,547382189,547557808,547733441,547909088,
	548084749,548260425,548436114,548611817,548787535,548963266,549139012,549314771,549490545,549666333,
	549842135,550017950,550193780,550369624,550545482,550721354,550897241,551073141,551249055,551424983,
	551600925,551776882,551952852,552128836,552304835,552480847,552656873,552832914,553008968,553185037,
	553361119,553537215,553713326,553889450,554065589,554241741,554417908,554594088,554770283,554946491,
	555122714,555298950,555475201,555651465,555827743,556004036,556180342,556356662,556532997,556709345,
	556885707,557062083,557238473,557414877,557591295,557767727,557944173,558120633,558297107,558473595,
	558650097,558826612,559003142,559179686,559356243,559532814,559709400,559885999,560062612,560239240,
	560415881,560592536,560769205,560945887,561122584,561299295,561476019,561652758,561829510,562006276,
	562183057,562359851,562536659,562713480,562890316,563067166,563244029,563420907,563597798,563774703,
	563951622,564128555,564305502,564482463,564659437,564836426,565013428,565190444,565367474,565544518,
	565721576,565898647,566075733,566252832,566429945,566607072,566784213,566961368,567138536,567315719,
	567492915,567670125,567847349,568024586,568201838,568379103,568556382,568733675,568910982,569088303,
	569265637,569442985,569620347,569797723,569975113,570152516,570329933,570507365,570684809,570862268,
	571039740,571217227,571394727,571572240,571749768,571927309,572104865,572282433,572460016,572637613,
	572815223,572992847,573170485,573348136,573525802,573703481,573881173,574058880,574236600,574414334,
	574592082,574769844,574947619,575125408,575303211,575481028,575658858,575836702,576014560,576192431,
	576370316,576548215,576726128,576904054,577081994,577259948,577437916,577615897,577793892,577971901,
	578149923,578327959,578506009,578684072,578862149,579040240,579218345,579396463,579574595,579752741,
	579930900,580109073,580287260,580465460,580643674,580821902,581000143,581178399,581356667,581534950,
	581713246,581891555,582069879,582248216,582426567,582604931,582783309,582961701,583140106,583318525,
	583496958,583675404,583853864,584032337,584210825,584389325,584567840,584746368,584924910,585103465,
	585282034,585460616,585639213,585817822,585996446,586175083,586353733,586532398,586711076,586889767,
	587068472,587247191,587425923,587604669,587783428,587962201,588140988,588319788,588498602,588677429,
	588856270,589035125,589213993,589392875,589571770,589750679,589929601,590108537,590287487,590466450,
	590645427,590824417,591003421,591182438,591361469,591540513,591719571,591898643,592077728,592256827,
	592435939,592615065,592794204,592973357,593152523,593331703,593510896,593690103,593869324,594048558,
	594227805,594407066,594586341,594765629,594944930,595124245,595303574,595482916,595662271,595841640,
	596021023,596200419,596379829,596559252,596738688,596918138,597097602,597277079,597456569,597636073,
	597815591,597995122,598174666,598354224,598533795,598713380,598892979,599072590,599252216,599431854,
	599611506,599791172,599970851,600150544,600330250,600509969,600689702,600869448,601049208,601228981,
	601408768,601588568,601768381,601948208,602128049,602307902,602487770,602667650,602847544,603027452,
	603207373,603387307,603567255,603747216,603927191,604107179,604287180,604467195,604647223,604827265,
	605007320,605187388,605367470,605547565,605727674,605907796,606087931,606268080,606448242,606628417,
	606808606,606988808,607169024,607349253,607529496,607709751,607890020,608070303,608250599,608430908,
	608611231,608791566,608971916,609152278,609332654,609513044,609693446,609873862,610054292,610234735,
	610415191,610595660,610776143,610956639,611137148,611317671,611498207,611678756,611859319,612039895,
	612220484,612401087,612581703,612762332,612942975,613123631,613304300,613484983,613665679,613846388,
	614027110,614207846,614388595,614569357,614750133,614930922,615111724,615292540,615473368,615654210,
	615835066,616015934,616196816,616377712,616558620,616739542,616920477,617101425,617282386,617463361,
	617644349,617825351,618006365,618187393,618368434,618549488,618730556,618911637,619092731,619273838,
	619454959,619636093,619817240,619998400,620179573,620360760,620541960,620723173,620904400,621085639,
	621266892,621448158,621629438,621810730,621992036,622173355,622354687,622536032,622717391,622898763,
	623080148,623261546,623442957,623624382,623805820,623987271,624168735,624350212,624531703,624713207,
	624894724,625076254,625257797,625439354,625620923,625802506,625984102,626165711,626347334,626528969,
	626710618,626892280,627073955,627255643,627437344,627619058,627800786,627982527,628164281,628346048,
	628527828,628709621,628891428,629073248,629255080,629436926,629618785,629800658,629982543,630164441,
	630346353,630528278,630710215,630892166,631074130,631256108,631438098,631620101,631802118,631984147,
	632166190,632348246,632530315,632712397,632894492,633076600,633258722,633440856,633623004,633805164,
	633987338,634169525,634351725,634533938,634716164,634898403,635080655,635262921,635445199,635627490,
	635809795,635992113,636174443,636356787,636539144,636721514,636903896,637086292,637268701,637451123,
	637633559,637816007,637998468,638180942,638363430,638545930,638728443,638910970,639093509,639276062,
	639458627,639641206,639823797,640006402,640189020,640371650,640554294,640736951,640919621,641102303,
	641284999,641467708,641650430,641833165,642015912,642198673,642381447,642564234,642747034,642929846,
	643112672,643295511,643478363,643661228,643844105,644026996,644209900,644392817,644575746,644758689,
	644941645,645124613,645307595,645490590,645673597,645856618,646039651,646222698,646405757,646588830,
	646771915,646955013,647138125,647321249,647504386,647687536,647870699,648053875,648237064,648420266,
	648603481,648786709,648969949,649153203,649336470,649519749,649703042,649886347,650069665,650252997,
	650436341,650619698,650803068,650986451,651169847,651353255,651536677,651720112,651903559,652087020,
	652270493,652453979,652637478,652820990,653004515,653188053,653371604,653555167,653738744,653922333,
	654105935,654289550,654473178,654656819,654840473,655024140,655207819,655391512,655575217,655758935,
	655942666,656126410,656310167,656493936,656677719,656861514,657045322,657229143,657412977,657596824,
	657780683,657964556,658148441,658332339,658516250,658700174,658884111,659068060,659252023,659435998,
	659619986,659803987,659988000,660172027,660356066,660540118,660724183,660908261,661092351,661276455,
	661460571,661644700,661828842,662012997,662197164,662381344,662565538,662749743,662933962,663118194,
	663302438,663486695,663670965,663855247,664039543,664223851,664408172,664592506,664776853,664961212,
	665145584,665329969,665514367,665698777,665883200,666067636,666252085,666436547,666621021,666805508,
	666990008,667174521,667359046,667543584,667728135,667912699,668097275,668281864,668466466,668651081,
	668835708,669020348,669205001,669389667,669574345,669759036,669943740,670128456,670313185,670497927,
	670682682,670867450,671052230,671237023,671421828,671606647,671791478,671976321,672161178,672346047,
	672530929,672715823,672900731,673085651,673270583,673455529,673640487,673825458,674010441,674195437,
	674380446,674565468,674750502,674935549,675120609,675305681,675490766,675675863,675860974,676046097,
	676231232,676416381,676601542,676786716,676971902,677157101,677342313,677527537,677712774,677898024,
	678083286,678268561,678453849,678639149,678824462,679009787,679195126,679380477,679565840,679751216,
	679936605,680122006,680307421,680492847,680678287,680863739,681049203,681234680,681420170,681605673,
	681791188,681976716,682162256,682347809,682533374,682718953,682904543,683090147,683275763,683461391,
	683647033,683832687,684018353,684204032,684389724,684575428,684761145,684946874,685132616,685318371,
	685504138,685689918,685875710,686061515,686247332,686433163,686619005,686804861,686990728,687176609,
	687362502,687548407,687734325,687920256,688106199,688292155,688478123,688664104,688850098,689036104,
	689222122,689408154,689594197,689780254,689966322,690152404,690338498,690524604,690710723,690896854,
	691082998,691269155,691455324,691641506,691827700,692013907,692200126,692386358,692572602,692758859,
	692945128,693131410,693317704,693504011,693690330,693876662,694063007,694249364,694435733,694622115,
	694808509,694994916,695181336,695367768,695554212,695740669,695927138,696113620,696300115,696486621,
	696673141,696859673,697046217,697232774,697419343,697605925,697792519,697979126,698165745,698352377,
	698539021,698725677,698912347,699099028,699285722,699472429,699659147,699845879,700032623,700219379,
	700406148,700592929,700779723,700966529,701153347,701340178,701527022,701713878,701900746,702087627,
	702274520,702461425,702648343,702835274,703022217,703209172,703396140,703583120,703770113,703957118,
	704144135,704331165,704518208,704705262,704892329,705079409,705266501,705453605,705640722,705827851,
	706014993,706202147,706389313,706576492,706763683,706950887,707138103,707325331,707512572,707699825,
	707887090,708074368,708261659,708448961,708636276,708823604,709010944,709198296,709385660,709573037,
	709760427,709947828,710135242,710322669,710510107,710697559,710885022,711072498,711259986,711447487,
	711635000,711822525,712010063,712197613,712385175,712572750,712760337,712947936,713135548,713323172,
	713510808,713698457,713886118,714073791,714261477,714449175,714636885,714824608,715012343,715200090,
	715387850,715575622,715763406,715951203,716139012,716326833,716514667,716702513,716890371,717078242,
	717266124,717454019,717641927,717829847,718017779,718205723,718393680,718581648,718769630,718957623,
	719145629,719333647,719521677,719709720,719897775,720085842,720273922,720462013,720650117,720838234,
	721026362,721214503,721402656,721590822,721778999,721967189,722155392,722343606,722531833,722720072,
	722908323,723096587,723284862,723473150,723661451,723849763,724038088,724226425,724414774,724603136,
	724791509,724979895,725168294,725356704,725545127,725733562,725922009,726110468,726298940,726487424,
	726675920,726864428,727052949,727241481,727430026,727618583,727807153,727995734,728184328,728372934,
	728561553,728750183,728938826,729127480,729316148,729504827,729693518,729882222,730070938,730259666,
	730448406,730637159,730825923,731014700,731203489,731392290,731581104,731769929,731958767,732147617,
	732336479,732525353,732714240,732903139,733092049,733280972,733469908,733658855,733847814,734036786,
	734225770,734414766,734603774,734792794,734981827,735170871,735359928,735548997,735738078,735927171,
	736116277,736305394,736494524,736683666,736872820,737061986,737251164,737440354,737629557,737818771,
	738007998,738197237,738386488,738575751,738765026,738954314,739143613,739332925,739522249,739711585,
	739900933,740090293,740279665,740469049,740658446,740847854,741037275,741226708,741416152,741605609,
	741795078,741984560,742174053,742363558,742553076,742742605,742932147,743121701,743311266,743500844,
	743690434,743880036,744069651,744259277,744448915,744638566,744828228,745017903,745207589,745397288,
	745586999,745776721,745966456,746156203,746345962,746535733,746725517,746915312,747105119,747294938,
	747484770,747674613,747864469,748054336,748244216,748434107,748624011,748813927,749003855,749193794,
	749383746,749573710,749763686,749953674,750143674,750333686,750523710,750713746,750903794,751093854,
	751283926,751474011,751664107,751854215,752044335,752234467,752424612,752614768,752804936,752995117,
	753185309,753375513,753565729,753755958,753946198,754136450,754326715,754516991,754707279,754897580,
	755087892,755278216,755468553,755658901,755849261,756039633,756230018,756420414,756610822,756801242,
	756991675,757182119,757372575,757563043,757753523,757944015,758134519,758325035,758515563,758706103,
	758896655,759087219,759277794,759468382,759658982,759849593,760040217,760230853,760421500,760612160,
	760802831,760993514,761184210,761374917,761565636,761756367,761947110,762137866,762328632,762519411,
	762710202,762901005,763091820,763282646,763473485,763664335,763855198,764046072,764236958,764427856,
	764618767,764809689,765000622,765191568,765382526,765573496,765764477,765955471,766146476,766337493,
	766528523,766719564,766910617,767101682,767292758,767483847,767674948,767866060,768057185,768248321,
	768439469,768630629,768821801,769012985,769204180,769395388,769586607,769777839,769969082,770160337,
	770351604,770542883,770734174,770925476,771116791,771308117,771499455,771690805,771882167,772073541,
	772264926,772456324,772647733,772839155,773030588,773222032,773413489,773604958,773796438,773987931,
	774179435,774370951,774562479,774754018,774945570,775137133,775328708,775520295,775711894,775903505,
	776095127,776286762,776478408,776670066,776861736,777053417,777245111,777436816,777628533,777820262,
	778012003,778203755,778395520,778587296,778779084,778970884,779162695,779354519,779546354,779738201,
	779930060,780121930,780313813,780505707,780697613,780889531,781081460,781273402,781465355,781657320,
	781849297,782041285,782233285,782425297,782617321,782809357,783001404,783193464,783385535,783577617,
	783769712,783961818,784153936,784346066,784538208,784730361,784922526,785114703,785306892,785499092,
	785691304,785883528,786075764,786268012,786460271,786652542,786844824,787037119,787229425,787421743,
	787614073,787806414,787998767,788191132,788383509,788575897,788768297,788960709,789153133,789345568,
	789538015,789730474,789922944,790115426,790307920,790500426,790692943,790885472,791078013,791270566,
	791463130,791655706,791848294,792040893,792233504,792426127,792618762,792811408,793004066,793196735,
	793389417,793582110,793774814,793967531,794160259,794352999,794545750,794738513,794931288,795124075,
	795316873,795509683,795702505,795895338,796088183,796281039,796473908,796666788,796859680,797052583,
	797245498,797438425,797631363,797824313,798017275,798210248,798403233,798596230,798789238,798982258,
	799175290,799368333,799561388,799754455,799947533,800140623,800333725,800526838,800719963,800913099,
	801106248,801299407,801492579,801685762,801878957,802072163,802265381,802458611,802651852,802845105,
	803038370,803231646,803424934,803618233,803811544,804004867,804198201,804391547,804584905,804778274,
	804971654,805165047,805358451,805551866,805745294,805938733,806132183,806325645,806519119,806712604,
	806906101,807099609,807293129,807486661,807680204,807873759,808067326,808260904,808454493,808648094,
	808841707,809035332,809228968,809422615,809616274,809809945,810003627,810197321,810391027,810584744,
	810778472,810972213,811165964,811359728,811553503,811747289,811941087,812134897,812328718,812522551,
	812716395,812910251,813104118,813297997,813491888,813685790,813879703,814073628,814267565,814461513,
	814655473,814849445,815043427,815237422,815431428,815625445,815819475,816013515,816207567,816401631,
	816595706,816789793,816983891,817178001,817372122,817566255,817760400,817954555,818148723,818342902,
	818537092,818731294,818925508,819119733,819313969,819508217,819702477,819896748,820091031,820285325,
	820479630,820673947,820868276,821062616,821256968,821451331,821645705,821840091,822034489,822228898,
	822423319,822617751,822812194,823006649,823201116,823395594,823590083,823784584,823979097,824173621,
	824368156,824562703,824757261,824951831,825146413,825341005,825535610,825730225,825924853,826119491,
	826314141,826508803,826703476,826898160,827092856,827287564,827482283,827677013,827871755,828066508,
	828261273,828456049,828650837,828845636,829040446,829235268,829430102,829624946,829819803,830014670,
	830209550,830404440,830599342,830794256,830989181,831184117,831379065,831574024,831768994,831963976,
	832158970,832353975,832548991,832744019,832939058,833134109,833329170,833524244,833719329,833914425,
	834109533,834304652,834499782,834694924,834890077,835085242,835280418,835475605,835670804,835866015,
	836061236,836256469,836451714,836646970,836842237,837037516,837232806,837428107,837623420,837818744,
	838014080,838209427,838404785,838600155,838795536,838990928,839186332,839381747,839577174,839772612,
	839968061,840163522,840358994,840554478,840749972,840945479,841140996,841336525,841532065,841727617,
	841923180,842118754,842314340,842509937,842705546,842901165,843096797,843292439,843488093,843683758,
	843879435,844075122,844270822,844466532,844662254,844857987,845053732,845249488,845445255,845641034,
	845836823,846032625,846228437,846424261,846620096,846815943,847011801,847207670,847403550,847599442,
	847795345,847991260,848187186,848383123,848579071,848775031,848971002,849166984,849362978,849558983,
	849754999,849951027,850147065,850343116,850539177,850735250,850931334,851127429,851323536,851519654,
	851715783,851911924,852108076,852304239,852500413,852696599,852892796,853089004,853285224,853481454,
	853677697,853873950,854070215,854266491,854462778,854659076,854855386,855051707,855248039,855444383,
	855640738,855837104,856033481,856229870,856426270,856622681,856819103,857015537,857211982,857408438,
	857604905,857801384,857997874,858194375,858390888,858587411,858783946,858980492,859177050,859373619,
	859570198,859766790,859963392,860160006,860356630,860553267,860749914,860946572,861143242,861339923,
	861536615,861733319,861930034,862126760,862323497,862520245,862717005,862913775,863110557,863307351,
	863504155,863700971,863897798,864094636,864291485,864488346,864685217,864882100,865078994,865275900,
	865472816,865669744,865866683,866063633,866260595,866457567,866654551,866851546,867048552,867245569,
	867442598,867639637,867836688,868033750,868230823,868427908,868625004,868822110,869019228,869216357,
	869413498,869610649,869807812,870004986,870202171,870399367,870596574,870793793,870991023,871188264,
	871385516,871582779,871780053,871977339,872174635,872371943,872569262,872766592,872963934,873161286,
	873358650,873556024,873753410,873950807,874148216,874345635,874543065,874740507,874937960,875135424,
	875332899,875530385,875727882,875925391,876122910,876320441,876517983,876715536,876913100,877110675,
	877308262,877505859,877703468,877901088,878098719,878296361,878494014,878691678,878889353,879087040,
	879284737,879482446,879680166,879877897,880075639,880273392,880471156,880668932,880866718,881064516,
	881262324,881460144,881657975,881855817,882053670,882251534,882449409,882647296,882845193,883043102,
	883241021,883438952,883636894,883834847,884032811,884230786,884428772,884626769,884824777,885022797,
	885220827,885418869,885616921,885814985,886013060,886211145,886409242,886607350,886805469,887003599,
	887201741,887399893,887598056,887796230,887994416,888192612,888390820,888589038,888787268,888985509,
	889183760,889382023,889580297,889778582,889976878,890175185,890373503,890571832,890770172,890968523,
	891166885,891365258,891563643,891762038,891960444,892158862,892357290,892555729,892754180,892952641,
	893151114,893349597,893548092,893746597,893945114,894143642,894342180,894540730,894739291,894937862,
	895136445,895335039,895533644,895732259,895930886,896129524,896328173,896526833,896725503,896924185,
	897122878,897321582,897520297,897719022,897917759,898116507,898315266,898514036,898712816,898911608,
	899110411,899309225,899508050,899706885,899905732,900104590,900303458,900502338,900701229,900900130,
	901099043,901297967,901496901,901695847,901894803,902093771,902292749,902491739,902690739,902889750,
	903088773,903287806,903486850,903685906,903884972,904084049,904283137,904482236,904681346,904880467,
	905079599,905278742,905477896,905677061,905876237,906075423,906274621,906473829,906673049,906872279,
	907071521,907270773,907470037,907669311,907868596,908067892,908267199,908466517,908665846,908865186,
	909064537,909263899,909463271,909662655,909862049,910061455,910260871,910460298,910659737,910859186,
	911058646,911258117,911457599,911657091,911856595,912056110,912255635,912455172,912654719,912854277,
	913053846,913253426,913453017,913652619,913852232,914051856,914251490,914451136,914650792,914850459,
	915050138,915249827,915449527,915649237,915848959,916048692,916248435,916448190,916647955,916847731,
	917047518,917247316,917447125,917646945,917846775,918046617,918246469,918446332,918646206,918846091,
	919045987,919245894,919445811,919645740,919845679,920045629,920245590,920445562,920645545,920845538,
	921045543,921245558,921445584,921645621,921845669,922045728,922245797,922445878,922645969,922846071,
	923046184,923246308,923446443,923646588,923846745,924046912,924247090,924447279,924647479,924847689,
	925047911,925248143,925448386,925648640,925848904,926049180,926249466,926449764,926650072,926850391,
	927050720,927251061,927451412,927651774,927852147,928052531,928252926,928453331,928653747,928854174,
	929054612,929255061,929455521,929655991,929856472,930056964,930257467,930457980,930658504,930859040,
	931059586,931260142,931460710,931661288,931861877,932062477,932263088,932463709,932664342,932864985,
	933065639,933266303,933466979,933667665,933868362,934069070,934269789,934470518,934671258,934872009,
	935072771,935273543,935474326,935675120,935875925,936076741,936277567,936478404,936679252,936880111,
	937080980,937281861,937482751,937683653,937884566,938085489,938286423,938487368,938688323,938889289,
	939090266,939291254,939492253,939693262,939894282,940095313,940296354,940497407,940698470,940899543,
	941100628,941301723,941502829,941703946,941905073,942106212,942307361,942508520,942709691,942910872,
	943112064,943313266,943514480,943715704,943916938,944118184,944319440,944520707,944721985,944923273,
	945124572,945325882,945527203,945728534,945929876,946131229,946332592,946533966,946735351,946936747,
	947138153,947339570,947540998,947742436,947943885,948145345,948346815,948548297,948749789,948951291,
	949152804,949354328,949555863,949757409,949958965,950160531,950362109,950563697,950765296,950966905,
	951168526,951370156,951571798,951773450,951975113,952176787,952378471,952580166,952781872,952983588,
	953185315,953387053,953588801,953790560,953992330,954194110,954395901,954597703,954799515,955001338,
	955203172,955405016,955606871,955808737,956010613,956212500,956414398,956616306,956818225,957020155,
	957222095,957424046,957626008,957827980,958029963,958231956,958433960,958635975,958838001,959040037,
	959242083,959444141,959646209,959848287,960050377,960252477,960454587,960656708,960858840,961060983,
	961263136,961465299,961667474,961869659,962071854,962274060,962476277,962678505,962880743,963082991,
	963285251,963487521,963689801,963892092,964094394,964296707,964499030,964701363,964903707,965106062,
	965308428,965510804,965713190,965915588,966117995,966320414,966522843,966725283,966927733,967130194,
	967332665,967535147,967737640,967940143,968142657,968345181,968547716,968750262,968952818,969155385,
	969357962,969560550,969763149,969965758,970168378,970371008,970573649,970776300,970978962,971181635,
	971384318,971587011,971789716,971992431,972195156,972397892,972600639,972803396,973006163,973208942,
	973411731,973614530,973817340,974020160,974222991,974425833,974628685,974831548,975034421,975237305,
	975440200,975643105,975846020,976048946,976251883,976454830,976657788,976860756,977063735,977266724,
	977469724,977672734,977875755,978078787,978281829,978484881,978687944,978891018,979094102,979297197,
	979500302,979703418,979906544,980109681,980312828,980515986,980719154,980922333,981125523,981328723,
	981531933,981735154,981938386,982141628,982344880,982548143,982751417,982954701,983157995,983361300,
	983564616,983767942,983971279,984174626,984377983,984581352,984784730,984988119,985191519,985394929,
	985598350,985801781,986005222,986208675,986412137,986615610,986819094,987022588,987226092,987429608,
	987633133,987836669,988040216,988243773,988447340,988650918,988854506,989058105,989261715,989465335,
	989668965,989872606,990076257,990279919,990483591,990687274,990890967,991094671,991298385,991502109,
	991705844,991909590,992113346,992317112,992520889,992724677,992928475,993132283,993336102,993539931,
	993743770,993947620,994151481,994355352,994559234,994763125,994967028,995170941,995374864,995578798,
	995782742,995986696,996190661,996394637,996598623,996802619,997006626,997210643,997414671,997618709,
	997822757,998026816,998230886,998434965,998639056,998843156,999047267,999251389,999455521,999659663,
	999863816,1000067979,1000272153,1000476337,1000680531,1000884736,1001088952,1001293177,1001497413,1001701660,
	1001905917,1002110184,1002314462,1002518750,1002723049,1002927358,1003131677,1003336007,1003540347,1003744698,
	1003949059,1004153430,1004357812,1004562204,1004766607,1004971020,1005175443,1005379877,1005584321,1005788776,
	1005993241,1006197716,1006402202,1006606698,1006811205,1007015722,1007220249,1007424787,1007629335,1007833893,
	1008038462,1008243041,1008447631,1008652231,1008856841,1009061462,1009266093,1009470734,1009675386,1009880048,
	1010084721,1010289404,1010494097,1010698801,1010903515,1011108239,1011312974,1011517719,1011722475,1011927241,
	1012132017,1012336803,1012541600,1012746407,1012951225,1013156053,1013360891,1013565740,1013770599,1013975469,
	1014180348,1014385238,1014590139,1014795050,1014999971,1015204902,1015409844,1015614796,1015819759,1016024732,
	1016229715,1016434708,1016639712,1016844726,1017049751,1017254786,1017459831,1017664886,1017869952,1018075028,
	1018280115,1018485212,1018690319,1018895436,1019100564,1019305702,1019510851,1019716009,1019921179,1020126358,
	1020331548,1020536748,1020741958,1020947179,1021152410,1021357651,1021562903,1021768165,1021973437,1022178719,
	1022384012,1022589315,1022794629,1022999953,1023205287,1023410631,1023615986,1023821351,1024026726,1024232111,
	1024437507,1024642913,1024848330,1025053757,1025259194,1025464641,1025670099,1025875566,1026081045,1026286533,
	1026492032,1026697541,1026903060,1027108590,1027314130,1027519680,1027725240,1027930811,1028136392,1028341984,
	1028547585,1028753197,1028958819,1029164451,1029370094,1029575747,1029781410,1029987084,1030192768,1030398462,
	1030604166,1030809880,1031015605,1031221340,1031427086,1031632841,1031838607,1032044383,1032250170,1032455966,
	1032661773,1032867590,1033073418,1033279255,1033485103,1033690961,1033896830,1034102708,1034308597,1034514496,
	1034720406,1034926325,1035132255,1035338195,1035544146,1035750106,1035956077,1036162058,1036368050,1036574051,
	1036780063,1036986085,1037192117,1037398160,1037604212,1037810275,1038016348,1038222432,1038428526,1038634629,
	1038840743,1039046868,1039253002,1039459147,1039665302,1039871467,1040077643,1040283828,1040490024,1040696230,
	1040902446,1041108673,1041314910,1041521157,1041727414,1041933681,1042139959,1042346246,1042552544,1042758852,
	1042965171,1043171499,1043377838,1043584187,1043790546,1043996916,1044203295,1044409685,1044616085,1044822495,
	1045028916,1045235346,1045441787,1045648238,1045854699,1046061170,1046267652,1046474144,1046680645,1046887158,
	1047093680,1047300212,1047506755,1047713308,1047919871,1048126444,1048333027,1048539621,1048746224,1048952838,
	1049159462,1049366097,1049572741,1049779396,1049986060,1050192735,1050399420,1050606116,1050812821,1051019537,
	1051226262,1051432998,1051639744,1051846500,1052053267,1052260043,1052466830,1052673627,1052880434,1053087251,
	1053294079,1053500916,1053707764,1053914622,1054121489,1054328368,1054535256,1054742154,1054949063,1055155981,
	1055362910,1055569849,1055776798,1055983758,1056190727,1056397707,1056604696,1056811696,1057018706,1057225726,
	1057432756,1057639797,1057846847,1058053908,1058260979,1058468059,1058675150,1058882252,1059089363,1059296484,
	1059503616,1059710757,1059917909,1060125071,1060332243,1060539425,1060746617,1060953820,1061161032,1061368255,
	1061575488,1061782730,1061989983,1062197246,1062404520,1062611803,1062819096,1063026400,1063233713,1063441037,
	1063648371,1063855715,1064063069,1064270433,1064477807,1064685192,1064892586,1065099990,1065307405,1065514830,
	1065722265,1065929709,1066137164,1066344630,1066552105,1066759590,1066967085,1067174591,1067382106,1067589632,
	1067797168,1068004714,1068212269,1068419835,1068627411,1068834998,1069042594,1069250200,1069457816,1069665443,
	1069873079,1070080726,1070288383,1070496049,1070703726,1070911413,1071119110,1071326817,1071534534,1071742261,
	1071949998,1072157746,1072365503,1072573270,1072781048,1072988835,1073196633,1073404441,1073612258,1073820086,
	1074027924,1074235772,1074443630,1074651498,1074859376,1075067264,1075275162,1075483070,1075690988,1075898917,
	1076106855,1076314803,1076522762,1076730730,1076938709,1077146697,1077354696,1077562705,1077770723,1077978752,
	1078186791,1078394839,1078602898,1078810967,1079019046,1079227135,1079435234,1079643343,1079851462,1080059591,
	1080267730,1080475879,1080684038,1080892207,1081100386,1081308576,1081516775,1081724984,1081933203,1082141432,
	1082349672,1082557921,1082766180,1082974450,1083182729,1083391018,1083599318,1083807627,1084015947,1084224276,
	1084432615,1084640965,1084849324,1085057694,1085266073,1085474462,1085682862,1085891271,1086099691,1086308120,
	1086516560,1086725009,1086933468,1087141938,1087350417,1087558907,1087767406,1087975915,1088184435,1088392964,
	1088601503,1088810053,1089018612,1089227181,1089435761,1089644350,1089852949,1090061559,1090270178,1090478807,
	1090687446,1090896095,1091104754,1091313424,1091522103,1091730792,1091939491,1092148200,1092356919,1092565648,
	1092774387,1092983136,1093191894,1093400663,1093609442,1093818231,1094027030,1094235838,1094444657,1094653486,
	1094862324,1095071173,1095280031,1095488900,1095697778,1095906666,1096115565,1096324473,1096533391,1096742319,
	1096951257,1097160206,1097369164,1097578132,1097787109,1097996097,1098205095,1098414103,1098623121,1098832148,
	1099041186,1099250233,1099459291,1099668358,1099877435,1100086523,1100295620,1100504727,1100713844,1100922971,
	1101132108,1101341255,1101550412,1101759578,1101968755,1102177942,1102387138,1102596345,1102805561,1103014787,
	1103224023,1103433270,1103642526,1103851792,1104061067,1104270353,1104479649,1104688955,1104898270,1105107596,
	1105316931,1105526276,1105735631,1105944997,1106154372,1106363756,1106573151,1106782556,1106991971,1107201395,
	1107410830,1107620274,1107829728,1108039192,1108248667,1108458150,1108667644,1108877148,1109086662,1109296185,
	1109505719,1109715262,1109924815,1110134378,1110343951,1110553534,1110763127,1110972730,1111182342,1111391965,
	1111601597,1111811239,1112020891,1112230553,1112440225,1112649907,1112859598,1113069300,1113279011,1113488733,
	1113698464,1113908205,1114117956,1114327716,1114537487,1114747267,1114957058,1115166858,1115376668,1115586488,
	1115796318,1116006157,1116216007,1116425866,1116635736,1116845615,1117055504,1117265403,1117475311,1117685230,
	1117895158,1118105097,1118315045,1118525003,1118734971,1118944948,1119154936,1119364933,1119574941,1119784958,
	1119994985,1120205022,1120415068,1120625125,1120835191,1121045267,1121255353,1121465449,1121675555,1121885670,
	1122095796,1122305931,1122516076,1122726231,1122936396,1123146570,1123356755,1123566949,1123777153,1123987367,
	1124197590,1124407824,1124618067,1124828321,1125038584,1125248856,1125459139,1125669432,1125879734,1126090046,
	1126300368,1126510700,1126721041,1126931393,1127141754,1127352125,1127562506,1127772897,1127983297,1128193707,
	1128404127,1128614557,1128824997,1129035447,1129245906,1129456375,1129666854,1129877343,1130087841,1130298350,
	1130508868,1130719396,1130929934,1131140481,1131351039,1131561606,1131772183,1131982769,1132193366,1132403972,
	1132614588,1132825214,1133035850,1133246496,1133457151,1133667816,1133878491,1134089176,1134299870,1134510574,
	1134721288,1134932012,1135142746,1135353489,1135564242,1135775005,1135985778,1136196560,1136407352,1136618154,
	1136828966,1137039788,1137250619,1137461460,1137672311,1137883172,1138094042,1138304922,1138515812,1138726712,
	1138937622,1139148541,1139359470,1139570409,1139781357,1139992315,1140203284,1140414261,1140625249,1140836246,
	1141047253,1141258270,1141469297,1141680333,1141891379,1142102435,1142313501,1142524576,1142735661,1142946756,
	1143157861,1143368975,1143580099,1143791233,1144002377,1144213530,1144424693,1144635866,1144847048,1145058241,
	1145269443,1145480655,1145691876,1145903107,1146114348,1146325599,1146536859,1146748130,1146959410,1147170699,
	1147381999,1147593308,1147804626,1148015955,1148227293,1148438641,1148649999,1148861367,1149072744,1149284131,
	1149495527,1149706934,1149918350,1150129775,1150341211,1150552656,1150764111,1150975576,1151187050,1151398534,
	1151610028,1151821531,1152033044,1152244567,1152456100,1152667642,1152879194,1153090756,1153302327,1153513909,
	1153725499,1153937100,1154148710,1154360330,1154571960,1154783599,1154995248,1155206907,1155418575,1155630253,
	1155841941,1156053639,1156265346,1156477063,1156688789,1156900526,1157112272,1157324027,1157535793,1157747568,
	1157959352,1158171147,1158382951,1158594765,1158806588,1159018421,1159230264,1159442116,1159653979,1159865850,
	1160077732,1160289623,1160501524,1160713435,1160925355,1161137285,1161349224,1161561173,1161773132,1161985101,
	1162197079,1162409067,1162621064,1162833072,1163045089,1163257115,1163469151,1163681197,1163893253,1164105318,
	1164317393,1164529477,1164741571,1164953675,1165165789,1165377912,1165590045,1165802187,1166014339,1166226501,
	1166438672,1166650853,1166863044,1167075244,1167287454,1167499674,1167711903,1167924142,1168136390,1168348649,
	1168560916,1168773194,1168985481,1169197778,1169410084,1169622400,1169834726,1170047061,1170259406,1170471761,
	1170684125,1170896499,1171108882,1171321275,1171533678,1171746090,1171958512,1172170944,1172383385,1172595836,
	1172808296,1173020766,1173233246,1173445735,1173658234,1173870743,1174083261,1174295789,1174508326,1174720873,
	1174933430,1175145996,1175358572,1175571158,1175783753,1175996357,1176208972,1176421596,1176634229,1176846872,
	1177059525,1177272187,1177484859,1177697541,1177910232,1178122933,1178335643,1178548363,1178761093,1178973832,
	1179186581,1179399339,1179612107,1179824884,1180037672,1180250468,1180463275,1180676090,1180888916,1181101751,
	1181314596,1181527450,1181740314,1181953187,1182166070,1182378963,1182591865,1182804777,1183017698,1183230629,
	1183443570,1183656520,1183869480,1184082449,1184295428,1184508416,1184721414,1184934422,1185147439,1185360465,
	1185573502,1185786548,1185999603,1186212668,1186425743,1186638827,1186851920,1187065024,1187278136,1187491259,
	1187704391,1187917532,1188130683,1188343844,1188557014,1188770194,1188983383,1189196582,1189409790,1189623008,
	1189836236,1190049473,1190262720,1190475976,1190689242,1190902517,1191115802,1191329096,1191542400,1191755713,
	1191969036,1192182369,1192395711,1192609063,1192822424,1193035795,1193249175,1193462565,1193675964,1193889373,
	1194102791,1194316219,1194529657,1194743104,1194956561,1195170027,1195383502,1195596987,1195810482,1196023986,
	1196237500,1196451023,1196664556,1196878099,1197091650,1197305212,1197518783,1197732363,1197945953,1198159553,
	1198373162,1198586780,1198800408,1199014046,1199227693,1199441349,1199655015,1199868691,1200082376,1200296071,
	1200509775,1200723489,1200937212,1201150944,1201364687,1201578438,1201792200,1202005970,1202219750,1202433540,
	1202647339,1202861148,1203074966,1203288794,1203502631,1203716478,1203930334,1204144200,1204358075,1204571960,
	1204785854,1204999758,1205213671,1205427594,1205641526,1205855467,1206069419,1206283379,1206497349,1206711329,
	1206925318,1207139317,1207353325,1207567342,1207781369,1207995406,1208209452,1208423507,1208637572,1208851647,
	1209065731,1209279824,1209493927,1209708039,1209922161,1210136293,1210350433,1210564584,1210778743,1210992912,
	1211207091,1211421279,1211635477,1211849684,1212063900,1212278126,1212492362,1212706607,1212920861,1213135125,
	1213349398,1213563681,1213777973,1213992275,1214206586,1214420907,1214635237,1214849576,1215063925,1215278284,
	1215492652,1215707029,1215921416,1216135812,1216350218,1216564633,1216779057,1216993491,1217207935,1217422388,
	1217636850,1217851322,1218065803,1218280294,1218494794,1218709304,1218923823,1219138351,1219352889,1219567436,
	1219781993,1219996559,1220211135,1220425720,1220640314,1220854918,1221069532,1221284154,1221498787,1221713428,
	1221928079,1222142740,1222357410,1222572089,1222786778,1223001476,1223216184,1223430901,1223645627,1223860363,
	1224075109,1224289863,1224504627,1224719401,1224934184,1225148976,1225363778,1225578589,1225793410,1226008240,
	1226223080,1226437928,1226652787,1226867654,1227082531,1227297418,1227512314,1227727219,1227942134,1228157058,
	1228371992,1228586934,1228801887,1229016849,1229231820,1229446800,1229661790,1229876789,1230091798,1230306816,
	1230521844,1230736881,1230951927,1231166983,1231382048,1231597122,1231812206,1232027299,1232242402,1232457514,
	1232672636,1232887766,1233102907,1233318056,1233533215,1233748383,1233963561,1234178748,1234393945,1234609151,
	1234824366,1235039590,1235254824,1235470068,1235685321,1235900583,1236115854,1236331135,1236546425,1236761725,
	1236977034,1237192352,1237407680,1237623017,1237838364,1238053719,1238269085,1238484459,1238699843,1238915236,
	1239130639,1239346051,1239561472,1239776903,1239992343,1240207793,1240423251,1240638720,1240854197,1241069684,
	1241285180,1241500686,1241716201,1241931725,1242147259,1242362802,1242578354,1242793916,1243009487,1243225067,
	1243440657,1243656256,1243871864,1244087482,1244303109,1244518745,1244734391,1244950046,1245165711,1245381385,
	1245597068,1245812760,1246028462,1246244173,1246459894,1246675623,1246891363,1247107111,1247322869,1247538636,
	1247754413,1247970198,1248185993,1248401798,1248617612,1248833435,1249049267,1249265109,1249480960,1249696820,
	1249912690,1250128569,1250344458,1250560355,1250776262,1250992179,1251208104,1251424039,1251639983,1251855937,
	1252071900,1252287872,1252503854,1252719845,1252935845,1253151854,1253367873,1253583901,1253799938,1254015985,
	1254232041,1254448106,1254664181,1254880265,1255096358,1255312461,1255528572,1255744693,1255960824,1256176964,
	1256393113,1256609271,1256825438,1257041615,1257257802,1257473997,1257690202,1257906416,1258122639,1258338872,
	1258555114,1258771365,1258987626,1259203895,1259420174,1259636463,1259852760,1260069067,1260285384,1260501709,
	1260718044,1260934388,1261150741,1261367104,1261583476,1261799857,1262016248,1262232647,1262449056,1262665475,
	1262881902,1263098339,1263314785,1263531241,1263747705,1263964179,1264180662,1264397155,1264613657,1264830168,
	1265046688,1265263217,1265479756,1265696304,1265912861,1266129428,1266346004,1266562589,1266779183,1266995787,
	1267212400,1267429022,1267645653,1267862294,1268078944,1268295603,1268512271,1268728949,1268945636,1269162332,
	1269379038,1269595752,1269812476,1270029209,1270245952,1270462703,1270679464,1270896234,1271113014,1271329802,
	1271546600,1271763407,1271980224,1272197049,1272413884,1272630728,1272847582,1273064444,1273281316,1273498197,
	1273715087,1273931987,1274148895,1274365813,1274582740,1274799677,1275016622,1275233577,1275450541,1275667515,
	1275884497,1276101489,1276318490,1276535500,1276752520,1276969548,1277186586,1277403633,1277620690,1277837755,
	1278054830,1278271914,1278489007,1278706110,1278923221,1279140342,1279357472,1279574611,1279791760,1280008918,
	1280226085,1280443261,1280660446,1280877641,1281094844,1281312057,1281529279,1281746511,1281963751,1282181001,
	1282398260,1282615528,1282832806,1283050092,1283267388,1283484693,1283702007,1283919331,1284136663,1284354005,
	1284571356,1284788716,1285006085,1285223464,1285440852,1285658249,1285875655,1286093070,1286310494,1286527928,
	1286745371,1286962823,1287180284,1287397755,1287615234,1287832723,1288050221,1288267728,1288485245,1288702770,
	1288920305,1289137849,1289355402,1289572964,1289790535,1290008116,1290225706,1290443305,1290660913,1290878530,
	1291096157,1291313792,1291531437,1291749091,1291966754,1292184426,1292402108,1292619799,1292837498,1293055207,
	1293272925,1293490653,1293708389,1293926135,1294143890,1294361654,1294579427,1294797209,1295015000,1295232801,
	1295450611,1295668430,1295886258,1296104095,1296321941,1296539797,1296757661,1296975535,1297193418,1297411310,
	1297629211,1297847122,1298065041,1298282970,1298500908,1298718855,1298936811,1299154776,1299372751,1299590734,
	1299808727,1300026729,1300244740,1300462760,1300680789,1300898828,1301116875,1301334932,1301552998,1301771072,
	1301989157,1302207250,1302425352,1302643464,1302861584,1303079714,1303297853,1303516001,1303734158,1303952324,
	1304170499,1304388684,1304606878,1304825080,1305043292,1305261513,1305479743,1305697982,1305916231,1306134488,
	1306352755,1306571030,1306789315,1307007609,1307225912,1307444224,1307662546,1307880876,1308099216,1308317564,
	1308535922,1308754289,1308972665,1309191050,1309409444,1309627847,1309846259,1310064681,1310283112,1310501551,
	1310720000,1310938458,1311156925,1311375401,1311593886,1311812380,1312030884,1312249396,1312467918,1312686449,
	1312904988,1313123537,1313342095,1313560662,1313779238,1313997824,1314216418,1314435021,1314653634,1314872255,
	1315090886,1315309526,1315528175,1315746833,1315965500,1316184176,1316402861,1316621555,1316840259,1317058971,
	1317277693,1317496423,1317715163,1317933912,1318152669,1318371436,1318590212,1318808997,1319027792,1319246595,
	1319465407,1319684228,1319903059,1320121898,1320340747,1320559605,1320778471,1320997347,1321216232,1321435126,
	1321654029,1321872941,1322091862,1322310792,1322529731,1322748679,1322967637,1323186603,1323405579,1323624563,
	1323843557,1324062559,1324281571,1324500592,1324719622,1324938661,1325157708,1325376765,1325595831,1325814906,
	1326033991,1326253084,1326472186,1326691297,1326910418,1327129547,1327348685,1327567833,1327786989,1328006155,
	1328225329,1328444513,1328663706,1328882907,1329102118,1329321338,1329540567,1329759804,1329979051,1330198307,
	1330417572,1330636846,1330856129,1331075421,1331294722,1331514033,1331733352,1331952680,1332172017,1332391363,
	1332610719,1332830083,1333049456,1333268839,1333488230,1333707630,1333927040,1334146458,1334365886,1334585322,
	1334804768,1335024222,1335243686,1335463158,1335682640,1335902131,1336121630,1336341139,1336560657,1336780183,
	1336999719,1337219264,1337438817,1337658380,1337877952,1338097532,1338317122,1338536721,1338756329,1338975945,
	1339195571,1339415206,1339634850,1339854503,1340074164,1340293835,1340513515,1340733204,1340952901,1341172608,
	1341392324,1341612049,1341831783,1342051525,1342271277,1342491038,1342710808,1342930586,1343150374,1343370171,
	1343589977,1343809791,1344029615,1344249448,1344469289,1344689140,1344909000,1345128868,1345348746,1345568633,
	1345788528,1346008433,1346228346,1346448269,1346668200,1346888141,1347108090,1347328049,1347548016,1347767993,
	1347987978,1348207972,1348427976,1348647988,1348868009,1349088040,1349308079,1349528127,1349748184,1349968250,
	1350188326,1350408410,1350628503,1350848605,1351068716,1351288836,1351508965,1351729102,1351949249,1352169405,
	1352389570,1352609744,1352829926,1353050118,1353270318,1353490528,1353710747,1353930974,1354151210,1354371456,
	1354591710,1354811973,1355032246,1355252527,1355472817,1355693116,1355913424,
};

static real aa_cs[8] =
{
	14386344,14793176,15932125,16497281,16702017,16763133,16775525,16777101
};

static real aa_ca[8] =
{
	-8631806,-7914349,-5257601,-3051997,-1586692,-687288,-238212,-62075
};

static real win[4][36] =
{
	{
		541609,1798624,3379171,5462936,8388608,12881122,20824265,39123649,129925287,-141788570,-50986933,-32687548,
		-24744405,-20251891,-17326219,-15242454,-13661907,-12404893,-11366990,-10483150,-9710514,-9019459,-8388608,-7801881,
		-7246655,-6712557,-6190623,-5672661,-5150726,-4616628,-4061402,-3474675,-2843824,-2152769,-1380133,-496293
	},
	{
		541609,1798624,3379171,5462936,8388608,12881122,20824265,39123649,129925287,-141788570,-50986933,-32687548,
		-24744405,-20251891,-17326219,-15242454,-13661907,-12404893,-11377819,-10573609,-9946281,-9457165,-9079764,-8795700,
		-8518771,-7816938,-6661470,-5111526,-3237882,-1121518,
	},
	{
		1798624,8388608,39123649,-50986933,-20251891,-13661907,-10483150,-8388608,-6712557,-5150726,-3474675,-1380133,
	},
	{
		0,0,0,0,0,0,5058839,24594154,117073194,-152572757,-59375541,-38425694,
		-27896396,-21920489,-18167045,-15612533,-13779795,-12416710,-11366990,-10483150,-9710514,-9019459,-8388608,-7801881,
		-7246655,-6712557,-6190623,-5672661,-5150726,-4616628,-4061402,-3474675,-2843824,-2152769,-1380133,-496293
	}
};

const real COS9[9] =
{
	16777216,16522332,15765426,14529495,12852093,10784187,8388608,5738146,2913333
};

static const real COS6_1 = 14529495;

static const real COS6_2 = 8388608;

const real tfcos36[9] =
{
	8420651,8684526,9255805,10240599,11863283,14625092,19849138,32411092,96248483
};

static const real tfcos12[3] =
{
	8684526,11863283,32411092
};

#ifdef NEW_DCT9
static const real cos9[3] =
{
	15765426,-2913333,-12852093
};

static const real cos18[3] =
{
	16522332,-5738146,-10784187
};
#endif

static const real tan1_1[16] =
{
	0,6925,11994,16384,20774,25843,32768,44762,77530,2147483647,-44762,-11994,0,6925,11994,16384
};

static const real tan2_1[16] =
{
	32768,25843,20774,16384,11994,6925,0,-11994,-44762,2147483647,77530,44762,32768,25843,20774,16384
};

static const real tan1_2[16] =
{
	0,9793,16962,23170,29379,36548,46341,63303,109644,2147483647,-63303,-16962,0,9793,16962,23170
};

static real tan2_2[16] =
{
	46341,36548,29379,23170,16962,9793,0,-16962,-63303,2147483647,109644,63303,46341,36548,29379,23170
};

static const real pow1_1[2][16] =
{
	{32768,27554,32768,23170,32768,19484,32768,16384,32768,13777,32768,11585,32768,9742,32768,8192},
	{32768,23170,32768,16384,32768,11585,32768,8192,32768,5793,32768,4096,32768,2896,32768,2048}
};

static const real pow2_1[2][16] =
{
	{32768,32768,27554,32768,23170,32768,19484,32768,16384,32768,13777,32768,11585,32768,9742,32768},
	{32768,32768,23170,32768,16384,32768,11585,32768,8192,32768,5793,32768,4096,32768,2896,32768}
};

static const real pow1_2[2][16] =
{
	{46341,38968,46341,32768,46341,27554,46341,23170,46341,19484,46341,16384,46341,13777,46341,11585},
	{46341,32768,46341,23170,46341,16384,46341,11585,46341,8192,46341,5793,46341,4096,46341,2896}
};

static const real pow2_2[2][16] =
{
	{46341,46341,38968,46341,32768,46341,27554,46341,23170,46341,19484,46341,16384,46341,13777,46341},
	{46341,46341,32768,46341,23170,46341,16384,46341,11585,46341,8192,46341,5793,46341,4096,46341}
};

static const real gainpow2[256+118+4] =
{
	1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,
	1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,
	1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,
	1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,
	1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,
	1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,1518500250,1276901417,1073741824,1805811301,
	1518500250,1276901417,1073741824,902905651,759250125,638450708,536870912,451452825,379625062,319225354,
	268435456,225726413,189812531,159612677,134217728,112863206,94906266,79806339,67108864,56431603,
	47453133,39903169,33554432,28215802,23726566,19951585,16777216,14107901,11863283,9975792,
	8388608,7053950,5931642,4987896,4194304,3526975,2965821,2493948,2097152,1763488,
	1482910,1246974,1048576,881744,741455,623487,524288,440872,370728,311744,
	262144,220436,185364,155872,131072,110218,92682,77936,65536,55109,
	46341,38968,32768,27554,23170,19484,16384,13777,11585,9742,
	8192,6889,5793,4871,4096,3444,2896,2435,2048,1722,
	1448,1218,1024,861,724,609,512,431,362,304,
	256,215,181,152,128,108,91,76,64,54,
	45,38,32,27,23,19,16,13,11,10,
	8,7,6,5,4,3,3,2,2,2,
	1,1,1,1,1,1,1,
};

#else
static real ispow[8207];
static real aa_ca[8],aa_cs[8];
static real win[4][36];
static real win1[4][36];
real COS9[9]; /* dct36_3dnow wants to use that */
static real COS6_1,COS6_2;
real tfcos36[9]; /* dct36_3dnow wants to use that */
static real tfcos12[3];
#ifdef NEW_DCT9
static real cos9[3],cos18[3];
static real tan1_1[16],tan2_1[16],tan1_2[16],tan2_2[16];
static real pow1_1[2][16],pow2_1[2][16],pow1_2[2][16],pow2_2[2][16];
#endif
#endif

static real win1[4][36];

static const char gainpow2_scale[256+118+4+1] =
{
	19,19,19,20,20,20,20,21,21,21,21,22,22,22,22,23,23,23,23,24,24,24,24,25,25,25,25,26,26,26,26,27,
	27,27,27,28,28,28,28,29,29,29,29,30,30,30,30,31,31,31,31,32,32,32,32,33,33,33,33,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,0
};

#endif
