/*++

Copyright (c) Microsoft Corporation.  All rights reserved.

_WdfVersionBuild_

Module Name:

    WdfInstaller.h

Abstract:

    Contains prototypes for the WDF installer support.

Author:

Environment:

    kernel mode only

Revision History:

--*/

//
// NOTE: This header is generated by stubwork.  Please make any
//       modifications to the corresponding template files
//       (.x or .y) and use stubwork to regenerate the header
//

#ifndef _WDFINSTALLER_H_
#define _WDFINSTALLER_H_

#ifndef WDF_EXTERN_C
  #ifdef __cplusplus
    #define WDF_EXTERN_C       extern "C"
    #define WDF_EXTERN_C_START extern "C" {
    #define WDF_EXTERN_C_END   }
  #else
    #define WDF_EXTERN_C
    #define WDF_EXTERN_C_START
    #define WDF_EXTERN_C_END
  #endif
#endif

WDF_EXTERN_C_START



#if (NTDDI_VERSION >= NTDDI_WIN2K)



typedef struct _WDF_COINSTALLER_INSTALL_OPTIONS {
    ULONG  Size;
    BOOL   ShowRebootPrompt;
} WDF_COINSTALLER_INSTALL_OPTIONS, *PWDF_COINSTALLER_INSTALL_OPTIONS;

FORCEINLINE
VOID
WDF_COINSTALLER_INSTALL_OPTIONS_INIT(
    _Out_ PWDF_COINSTALLER_INSTALL_OPTIONS ClientOptions
    )
{
    RtlZeroMemory(ClientOptions, sizeof(WDF_COINSTALLER_INSTALL_OPTIONS));

    ClientOptions->Size = sizeof(WDF_COINSTALLER_INSTALL_OPTIONS);
}


//----------------------------------------------------------------------------
// To be called before (your) WDF driver is installed.
//----------------------------------------------------------------------------
ULONG
WINAPI
WdfPreDeviceInstall(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

typedef
ULONG
(WINAPI *PFN_WDFPREDEVICEINSTALL)(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

ULONG
WINAPI
WdfPreDeviceInstallEx(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName,
    _In_ PWDF_COINSTALLER_INSTALL_OPTIONS ClientOptions
    );

typedef
ULONG
(WINAPI *PFN_WDFPREDEVICEINSTALLEX)(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName,
    _In_ PWDF_COINSTALLER_INSTALL_OPTIONS ClientOptions
    );

//----------------------------------------------------------------------------
// To be called after (your) WDF driver is installed.
//----------------------------------------------------------------------------
ULONG
WINAPI
WdfPostDeviceInstall(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

typedef
ULONG
(WINAPI *PFN_WDFPOSTDEVICEINSTALL)(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

//----------------------------------------------------------------------------
// To be called before (your) WDF driver is removed.
//----------------------------------------------------------------------------
ULONG
WINAPI
WdfPreDeviceRemove(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName

    );

typedef
ULONG
(WINAPI *PFN_WDFPREDEVICEREMOVE)(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

//----------------------------------------------------------------------------
// To be called after (your) WDF driver is removed.
//----------------------------------------------------------------------------
ULONG
WINAPI
WdfPostDeviceRemove(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName
    );

typedef
ULONG
(WINAPI *PFN_WDFPOSTDEVICEREMOVE)(
    _In_ LPCWSTR  InfPath,
    _In_opt_ LPCWSTR  InfSectionName

    );



#endif // (NTDDI_VERSION >= NTDDI_WIN2K)


WDF_EXTERN_C_END

#endif // _WDFINSTALLER_H_

