/*++ BUILD Version: 0005    // Increment this if a change has global effects

Copyright (c) Microsoft Corporation.  All rights reserved.

Module Name:

    wdfstatus.h

Abstract:

    Constant definitions for the WDFSTATUS values.

Revision History:

Notes:

    This file is generated by the MC tool from the wdfstatus.mc file.

--*/

#ifndef _WDFSTATUS_H_
#define _WDFSTATUS_H_

/////////////////////////////////////////////////////////////////////////
//
// Standard Success values match the NTSTATUS values
//
//
/////////////////////////////////////////////////////////////////////////


#define FACILITY_DRIVER_FRAMEWORK        0x20

//
//  Values are 32 bit values laid out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: STATUS_WDF_QUEUED
//
// MessageText:
//
// The request was queued internally and not immediately submitted to its target.
//
#define STATUS_WDF_QUEUED                ((NTSTATUS)0x40200000L)

//
// MessageId: STATUS_WDF_POSTED
//
// MessageText:
//
// The request was posted to a worker thread.
//
#define STATUS_WDF_POSTED                ((NTSTATUS)0x40200002L)

//
// MessageId: STATUS_WDF_NO_PACKAGE
//
// MessageText:
//
// No package of the selected type has been defined.
//
#define STATUS_WDF_NO_PACKAGE            ((NTSTATUS)0xC0200200L)

//
// MessageId: STATUS_WDF_INTERNAL_ERROR
//
// MessageText:
//
// An internal error has occured.
//
#define STATUS_WDF_INTERNAL_ERROR        ((NTSTATUS)0xC0200201L)

//
// MessageId: STATUS_WDF_PAUSED
//
// MessageText:
//
// The object is in a paused state.
//
#define STATUS_WDF_PAUSED                ((NTSTATUS)0xC0200203L)

//
// MessageId: STATUS_WDF_BUSY
//
// MessageText:
//
// The object is busy with previous requests.
//
#define STATUS_WDF_BUSY                  ((NTSTATUS)0xC0200204L)

//
// MessageId: STATUS_WDF_IO_TIMEOUT_NOT_SENT
//
// MessageText:
//
// The request timed out and was never sent to its target.
//
#define STATUS_WDF_IO_TIMEOUT_NOT_SENT   ((NTSTATUS)0xC0200205L)

//
// MessageId: STATUS_WDF_DEVICE_REMOVED_NOT_SENT
//
// MessageText:
//
// The request was never sent to its target and is now failed because the device has been removed.
//
#define STATUS_WDF_DEVICE_REMOVED_NOT_SENT ((NTSTATUS)0xC0200206L)

//
// MessageId: STATUS_WDF_REQUEST_ALREADY_PENDING
//
// MessageText:
//
// A request that was already pending with a IO target was submitted to a IO target.
//
#define STATUS_WDF_REQUEST_ALREADY_PENDING ((NTSTATUS)0xC0200207L)

//
// MessageId: STATUS_WDF_REQUEST_INVALID_STATE
//
// MessageText:
//
// An invalid operation was attempted on a request based on its currents state.
//
#define STATUS_WDF_REQUEST_INVALID_STATE ((NTSTATUS)0xC0200208L)

//
// MessageId: STATUS_WDF_OBJECT_ATTRIBUTES_INVALID
//
// MessageText:
//
// An invalid WDF_OBJECT_ATTRIBUTES parameter was passed.
//
#define STATUS_WDF_OBJECT_ATTRIBUTES_INVALID ((NTSTATUS)0xC0200209L)

//
// MessageId: STATUS_WDF_TOO_FRAGMENTED
//
// MessageText:
//
// The DMA Request's MDL has more SCATTER_GATHER_ELEMENTS that DMA Object's MaximumFragments allows.
//
#define STATUS_WDF_TOO_FRAGMENTED        ((NTSTATUS)0xC020020AL)

//
// MessageId: STATUS_WDF_NO_CALLBACK
//
// MessageText:
//
// A required Event Callback has not been registered.
//
#define STATUS_WDF_NO_CALLBACK           ((NTSTATUS)0xC020020BL)

//
// MessageId: STATUS_WDF_INCOMPATIBLE_EXECUTION_LEVEL
//
// MessageText:
//
// The object does not support the specified WDF_EXECUTION_LEVEL.
//
#define STATUS_WDF_INCOMPATIBLE_EXECUTION_LEVEL ((NTSTATUS)0xC020020CL)

//
// MessageId: STATUS_WDF_PARENT_ALREADY_ASSIGNED
//
// MessageText:
//
// The object already has a parent assigned.
//
#define STATUS_WDF_PARENT_ALREADY_ASSIGNED ((NTSTATUS)0xC020020DL)

//
// MessageId: STATUS_WDF_PARENT_IS_SELF
//
// MessageText:
//
// The object can not be its own parent.
//
#define STATUS_WDF_PARENT_IS_SELF        ((NTSTATUS)0xC020020EL)

//
// MessageId: STATUS_WDF_PARENT_ASSIGNMENT_NOT_ALLOWED
//
// MessageText:
//
// The object can not have a driver specified parent assignment.
//
#define STATUS_WDF_PARENT_ASSIGNMENT_NOT_ALLOWED ((NTSTATUS)0xC020020FL)

//
// MessageId: STATUS_WDF_SYNCHRONIZATION_SCOPE_INVALID
//
// MessageText:
//
// The object does not support the specified WDF_SYNCHRONIZATION_SCOPE.
//
#define STATUS_WDF_SYNCHRONIZATION_SCOPE_INVALID ((NTSTATUS)0xC0200210L)

//
// MessageId: STATUS_WDF_EXECUTION_LEVEL_INVALID
//
// MessageText:
//
// The object does not support the specified WDF_EXECUTION_LEVEL.
//
#define STATUS_WDF_EXECUTION_LEVEL_INVALID ((NTSTATUS)0xC0200211L)

//
// MessageId: STATUS_WDF_PARENT_NOT_SPECIFIED
//
// MessageText:
//
// A required parent object was not specified in WDF_OBJECT_ATTRIBUTES.
//
#define STATUS_WDF_PARENT_NOT_SPECIFIED  ((NTSTATUS)0xC0200212L)

#endif // _WDFSTATUS_H_
