/*++

Copyright (c) Microsoft Corporation.  All rights reserved.

_WdfVersionBuild_

Module Name: WdfTraceEnums.h

Abstract:
    Generated trace enums

Environment:
    kernel mode only

--*/

#ifndef _WDFTRACEENUMS_H_
#define _WDFTRACEENUMS_H_

#ifndef WDF_EXTERN_C
  #ifdef __cplusplus
    #define WDF_EXTERN_C       extern "C"
    #define WDF_EXTERN_C_START extern "C" {
    #define WDF_EXTERN_C_END   }
  #else
    #define WDF_EXTERN_C
    #define WDF_EXTERN_C_START
    #define WDF_EXTERN_C_END
  #endif
#endif

WDF_EXTERN_C_START

// begin_wpp config
// CUSTOM_TYPE(WDF_BUGCHECK_CODES, ItemEnum(_WDF_BUGCHECK_CODES));
// CUSTOM_TYPE(WDF_REQUEST_FATAL_ERROR_CODES, ItemEnum(_WDF_REQUEST_FATAL_ERROR_CODES));
// CUSTOM_TYPE(WDF_CHILD_LIST_RETRIEVE_DEVICE_STATUS, ItemEnum(_WDF_CHILD_LIST_RETRIEVE_DEVICE_STATUS));
// CUSTOM_TYPE(WDF_RETRIEVE_CHILD_FLAGS, ItemEnum(_WDF_RETRIEVE_CHILD_FLAGS));
// CUSTOM_TYPE(WDF_DEVICE_SHUTDOWN_FLAGS, ItemEnum(_WDF_DEVICE_SHUTDOWN_FLAGS));
// CUSTOM_TYPE(WDF_DEVICE_STATE_FLAGS, ItemEnum(_WDF_DEVICE_STATE_FLAGS));
// CUSTOM_TYPE(WDF_DEVICE_PNP_STATE, ItemEnum(_WDF_DEVICE_PNP_STATE));
// CUSTOM_TYPE(WDF_DEVICE_POWER_STATE, ItemEnum(_WDF_DEVICE_POWER_STATE));
// CUSTOM_TYPE(WDF_DEVICE_POWER_POLICY_STATE, ItemEnum(_WDF_DEVICE_POWER_POLICY_STATE));
// CUSTOM_TYPE(WDF_STATE_NOTIFICATION_TYPE, ItemEnum(_WDF_STATE_NOTIFICATION_TYPE));
// CUSTOM_TYPE(WDF_POWER_POLICY_S0_IDLE_CAPABILITIES, ItemEnum(_WDF_POWER_POLICY_S0_IDLE_CAPABILITIES));
// CUSTOM_TYPE(WDF_POWER_POLICY_S0_IDLE_USER_CONTROL, ItemEnum(_WDF_POWER_POLICY_S0_IDLE_USER_CONTROL));
// CUSTOM_TYPE(WDF_POWER_POLICY_IDLE_TIMEOUT_CONSTANTS, ItemEnum(_WDF_POWER_POLICY_IDLE_TIMEOUT_CONSTANTS));
// CUSTOM_TYPE(WDF_POWER_POLICY_SX_WAKE_USER_CONTROL, ItemEnum(_WDF_POWER_POLICY_SX_WAKE_USER_CONTROL));
// CUSTOM_TYPE(WDF_POWER_DEVICE_STATE, ItemEnum(_WDF_POWER_DEVICE_STATE));
// CUSTOM_TYPE(WDF_DISPATCH_IRP_TO_IO_QUEUE_FLAGS, ItemEnum(_WDF_DISPATCH_IRP_TO_IO_QUEUE_FLAGS));
// CUSTOM_TYPE(WDF_SPECIAL_FILE_TYPE, ItemEnum(_WDF_SPECIAL_FILE_TYPE));
// CUSTOM_TYPE(WDF_DEVICE_IO_TYPE, ItemEnum(_WDF_DEVICE_IO_TYPE));
// CUSTOM_TYPE(WDF_FILEOBJECT_CLASS, ItemEnum(_WDF_FILEOBJECT_CLASS));
// CUSTOM_TYPE(WDF_DEVICE_FAILED_ACTION, ItemEnum(_WDF_DEVICE_FAILED_ACTION));
// CUSTOM_TYPE(WDF_RELEASE_HARDWARE_ORDER_ON_FAILURE, ItemEnum(_WDF_RELEASE_HARDWARE_ORDER_ON_FAILURE));
// CUSTOM_TYPE(WDF_DMA_PROFILE, ItemEnum(_WDF_DMA_PROFILE));
// CUSTOM_TYPE(WDF_DMA_DIRECTION, ItemEnum(_WDF_DMA_DIRECTION));
// CUSTOM_TYPE(WDF_DRIVER_INIT_FLAGS, ItemEnum(_WDF_DRIVER_INIT_FLAGS));
// CUSTOM_TYPE(WDF_INTERRUPT_POLARITY, ItemEnum(_WDF_INTERRUPT_POLARITY));
// CUSTOM_TYPE(WDF_INTERRUPT_POLICY, ItemEnum(_WDF_INTERRUPT_POLICY));
// CUSTOM_TYPE(WDF_INTERRUPT_PRIORITY, ItemEnum(_WDF_INTERRUPT_PRIORITY));
// CUSTOM_TYPE(WDF_IO_QUEUE_DISPATCH_TYPE, ItemEnum(_WDF_IO_QUEUE_DISPATCH_TYPE));
// CUSTOM_TYPE(WDF_IO_QUEUE_STATE, ItemEnum(_WDF_IO_QUEUE_STATE));
// CUSTOM_TYPE(WDF_IO_TARGET_STATE, ItemEnum(_WDF_IO_TARGET_STATE));
// CUSTOM_TYPE(WDF_IO_TARGET_OPEN_TYPE, ItemEnum(_WDF_IO_TARGET_OPEN_TYPE));
// CUSTOM_TYPE(WDF_IO_TARGET_SENT_IO_ACTION, ItemEnum(_WDF_IO_TARGET_SENT_IO_ACTION));
// CUSTOM_TYPE(WDF_IO_TARGET_PURGE_IO_ACTION, ItemEnum(_WDF_IO_TARGET_PURGE_IO_ACTION));
// CUSTOM_TYPE(WDF_MEMORY_DESCRIPTOR_TYPE, ItemEnum(_WDF_MEMORY_DESCRIPTOR_TYPE));
// CUSTOM_TYPE(WDF_EXECUTION_LEVEL, ItemEnum(_WDF_EXECUTION_LEVEL));
// CUSTOM_TYPE(WDF_SYNCHRONIZATION_SCOPE, ItemEnum(_WDF_SYNCHRONIZATION_SCOPE));
// CUSTOM_TYPE(WDF_REQUEST_TYPE, ItemEnum(_WDF_REQUEST_TYPE));
// CUSTOM_TYPE(WDF_REQUEST_REUSE_FLAGS, ItemEnum(_WDF_REQUEST_REUSE_FLAGS));
// CUSTOM_TYPE(WDF_REQUEST_STOP_ACTION_FLAGS, ItemEnum(_WDF_REQUEST_STOP_ACTION_FLAGS));
// CUSTOM_TYPE(WDF_REQUEST_SEND_OPTIONS_FLAGS, ItemEnum(_WDF_REQUEST_SEND_OPTIONS_FLAGS));
// CUSTOM_TYPE(WDF_TRI_STATE, ItemEnum(_WDF_TRI_STATE));
// CUSTOM_TYPE(WDF_USB_REQUEST_TYPE, ItemEnum(_WDF_USB_REQUEST_TYPE));
// CUSTOM_TYPE(WDF_USB_BMREQUEST_DIRECTION, ItemEnum(_WDF_USB_BMREQUEST_DIRECTION));
// CUSTOM_TYPE(WDF_USB_BMREQUEST_TYPE, ItemEnum(_WDF_USB_BMREQUEST_TYPE));
// CUSTOM_TYPE(WDF_USB_BMREQUEST_RECIPIENT, ItemEnum(_WDF_USB_BMREQUEST_RECIPIENT));
// CUSTOM_TYPE(WDF_USB_PIPE_TYPE, ItemEnum(_WDF_USB_PIPE_TYPE));
// CUSTOM_TYPE(WdfUsbTargetDeviceSelectConfigType, ItemEnum(_WdfUsbTargetDeviceSelectConfigType));
// CUSTOM_TYPE(WdfUsbTargetDeviceSelectSettingType, ItemEnum(_WdfUsbTargetDeviceSelectSettingType));
// CUSTOM_TYPE(WDF_USB_DEVICE_TRAITS, ItemEnum(_WDF_USB_DEVICE_TRAITS));
// CUSTOM_TYPE(WDF_WMI_PROVIDER_CONTROL, ItemEnum(_WDF_WMI_PROVIDER_CONTROL));
// CUSTOM_TYPE(WDF_WMI_PROVIDER_FLAGS, ItemEnum(_WDF_WMI_PROVIDER_FLAGS));
// end_wpp

WDF_EXTERN_C_END

#endif // _WDFTRACEENUMS_H_

