/*
 * MIT License
 * -----------
 *
 * Copyright (c) 2002-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this Software and associated documentaon files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **
 ** Defines __log10_128_lead and __log10_128_tail tables
 ** Used by log and pow
 **
 */

#include <crtdefs.h>

const unsigned int _CRT_ALIGN(16) __log10_128_lead[] =
{
    0x00000000,
    0x3b5d4000,
    0x3bdc8000,
    0x3c24c000,
    0x3c5ac000,
    0x3c884000,
    0x3ca2c000,
    0x3cbd4000,
    0x3cd78000,
    0x3cf1c000,
    0x3d05c000,
    0x3d128000,
    0x3d1f4000,
    0x3d2c0000,
    0x3d388000,
    0x3d450000,
    0x3d518000,
    0x3d5dc000,
    0x3d6a0000,
    0x3d760000,
    0x3d810000,
    0x3d870000,
    0x3d8d0000,
    0x3d92c000,
    0x3d98c000,
    0x3d9e8000,
    0x3da44000,
    0x3daa0000,
    0x3dafc000,
    0x3db58000,
    0x3dbb4000,
    0x3dc0c000,
    0x3dc64000,
    0x3dcc0000,
    0x3dd18000,
    0x3dd6c000,
    0x3ddc4000,
    0x3de1c000,
    0x3de70000,
    0x3dec8000,
    0x3df1c000,
    0x3df70000,
    0x3dfc4000,
    0x3e00c000,
    0x3e034000,
    0x3e05c000,
    0x3e088000,
    0x3e0b0000,
    0x3e0d8000,
    0x3e100000,
    0x3e128000,
    0x3e150000,
    0x3e178000,
    0x3e1a0000,
    0x3e1c8000,
    0x3e1ec000,
    0x3e214000,
    0x3e23c000,
    0x3e260000,
    0x3e288000,
    0x3e2ac000,
    0x3e2d4000,
    0x3e2f8000,
    0x3e31c000,
    0x3e344000,
    0x3e368000,
    0x3e38c000,
    0x3e3b0000,
    0x3e3d4000,
    0x3e3fc000,
    0x3e420000,
    0x3e440000,
    0x3e464000,
    0x3e488000,
    0x3e4ac000,
    0x3e4d0000,
    0x3e4f4000,
    0x3e514000,
    0x3e538000,
    0x3e55c000,
    0x3e57c000,
    0x3e5a0000,
    0x3e5c0000,
    0x3e5e4000,
    0x3e604000,
    0x3e624000,
    0x3e648000,
    0x3e668000,
    0x3e688000,
    0x3e6ac000,
    0x3e6cc000,
    0x3e6ec000,
    0x3e70c000,
    0x3e72c000,
    0x3e74c000,
    0x3e76c000,
    0x3e78c000,
    0x3e7ac000,
    0x3e7cc000,
    0x3e7ec000,
    0x3e804000,
    0x3e814000,
    0x3e824000,
    0x3e834000,
    0x3e840000,
    0x3e850000,
    0x3e860000,
    0x3e870000,
    0x3e880000,
    0x3e88c000,
    0x3e89c000,
    0x3e8ac000,
    0x3e8bc000,
    0x3e8c8000,
    0x3e8d8000,
    0x3e8e8000,
    0x3e8f4000,
    0x3e904000,
    0x3e914000,
    0x3e920000,
    0x3e930000,
    0x3e93c000,
    0x3e94c000,
    0x3e958000,
    0x3e968000,
    0x3e978000,
    0x3e984000,
    0x3e994000,
    0x3e9a0000,
};

const unsigned int _CRT_ALIGN(16) __log10_128_tail[] =
{
    0x00000000,
    0x367a8e44,
    0x368ed49f,
    0x36c21451,
    0x375211d6,
    0x3720ea11,
    0x37e9eb59,
    0x37b87be7,
    0x37bf2560,
    0x33d597a0,
    0x37806a05,
    0x3820581f,
    0x38223334,
    0x378e3bac,
    0x3810684f,
    0x37feb7ae,
    0x36a9d609,
    0x37a68163,
    0x376a8b27,
    0x384c8fd6,
    0x3885183e,
    0x3874a760,
    0x380d1154,
    0x38ea42bd,
    0x384c1571,
    0x38ba66b8,
    0x38e7da3b,
    0x38eee632,
    0x38d00911,
    0x388bbede,
    0x378a0512,
    0x3894c7a0,
    0x38e30710,
    0x36db2829,
    0x3729d609,
    0x38fa0e82,
    0x38bc9a75,
    0x383a9297,
    0x38dc83c8,
    0x37eac335,
    0x38706ac3,
    0x389574c2,
    0x3892d068,
    0x38615032,
    0x3917acf4,
    0x3967a126,
    0x38217840,
    0x38b420ab,
    0x38f9c7b2,
    0x391103bd,
    0x39169a6b,
    0x390dd194,
    0x38eda471,
    0x38a38950,
    0x37f6844a,
    0x395e1cdb,
    0x390fcffc,
    0x38503e9d,
    0x394b00fd,
    0x38a9910a,
    0x39518a31,
    0x3882d2c2,
    0x392488e4,
    0x397b0aff,
    0x388a22d8,
    0x3902bd5e,
    0x39342f85,
    0x39598811,
    0x3972e6b1,
    0x34d53654,
    0x360ca25e,
    0x39785cc0,
    0x39630710,
    0x39424ed7,
    0x39165101,
    0x38be5421,
    0x37e7b0c0,
    0x394fd0c3,
    0x38efaaaa,
    0x37a8f566,
    0x3927c744,
    0x383fa4d5,
    0x392d9e39,
    0x3803feae,
    0x390a268c,
    0x39692b80,
    0x38789b4f,
    0x3909307d,
    0x394a601c,
    0x35e67edc,
    0x383e386d,
    0x38a7743d,
    0x38dccec3,
    0x38ff57e0,
    0x39079d8b,
    0x390651a6,
    0x38f7bad9,
    0x38d0ab82,
    0x38979e7d,
    0x381978ee,
    0x397816c8,
    0x39410cb2,
    0x39015384,
    0x3863fa28,
    0x39f41065,
    0x39c7668a,
    0x39968afa,
    0x39430db9,
    0x38a18cf3,
    0x39eb2907,
    0x39a9e10c,
    0x39492800,
    0x385a53d1,
    0x39ce0cf7,
    0x3979c7b2,
    0x389f5d99,
    0x39ceefcb,
    0x39646a39,
    0x380d7a9b,
    0x39ad6650,
    0x390ac3b8,
    0x39d9a9a8,
    0x39548a99,
    0x39f73c4b,
    0x3980960e,
    0x374b3d5a,
    0x39888f1e,
    0x37679a07,
    0x39826a13,
};
