/*
 * MIT License
 * -----------
 *
 * Copyright (c) 2002-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this Software and associated documentaon files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **
 ** Defines __log10_256_lead and __log10_256_tail tables
 ** Used by log and pow
 **
 */

#include <crtdefs.h>

const unsigned long long _CRT_ALIGN(16) __log10_256_lead[] =
{
    0x0000000000000000ull,
    0x3f5bbd9e90000000ull,
    0x3f6bafd470000000ull,
    0x3f74b99560000000ull,
    0x3f7b9476a0000000ull,
    0x3f81344da0000000ull,
    0x3f849b0850000000ull,
    0x3f87fe71c0000000ull,
    0x3f8b5e9080000000ull,
    0x3f8ebb6af0000000ull,
    0x3f910a83a0000000ull,
    0x3f92b5b5e0000000ull,
    0x3f945f4f50000000ull,
    0x3f96075300000000ull,
    0x3f97adc3d0000000ull,
    0x3f9952a4f0000000ull,
    0x3f9af5f920000000ull,
    0x3f9c97c370000000ull,
    0x3f9e3806a0000000ull,
    0x3f9fd6c5b0000000ull,
    0x3fa0ba01a0000000ull,
    0x3fa187e120000000ull,
    0x3fa25502c0000000ull,
    0x3fa32167c0000000ull,
    0x3fa3ed1190000000ull,
    0x3fa4b80180000000ull,
    0x3fa58238e0000000ull,
    0x3fa64bb910000000ull,
    0x3fa7148340000000ull,
    0x3fa7dc98c0000000ull,
    0x3fa8a3fad0000000ull,
    0x3fa96aaac0000000ull,
    0x3faa30a9d0000000ull,
    0x3faaf5f920000000ull,
    0x3fabba9a00000000ull,
    0x3fac7e8d90000000ull,
    0x3fad41d510000000ull,
    0x3fae0471a0000000ull,
    0x3faec66470000000ull,
    0x3faf87aeb0000000ull,
    0x3fb02428c0000000ull,
    0x3fb08426f0000000ull,
    0x3fb0e3d290000000ull,
    0x3fb1432c30000000ull,
    0x3fb1a23440000000ull,
    0x3fb200eb60000000ull,
    0x3fb25f5210000000ull,
    0x3fb2bd68e0000000ull,
    0x3fb31b3050000000ull,
    0x3fb378a8e0000000ull,
    0x3fb3d5d330000000ull,
    0x3fb432afa0000000ull,
    0x3fb48f3ed0000000ull,
    0x3fb4eb8120000000ull,
    0x3fb5477730000000ull,
    0x3fb5a32160000000ull,
    0x3fb5fe8040000000ull,
    0x3fb6599440000000ull,
    0x3fb6b45df0000000ull,
    0x3fb70eddb0000000ull,
    0x3fb7691400000000ull,
    0x3fb7c30160000000ull,
    0x3fb81ca630000000ull,
    0x3fb8760300000000ull,
    0x3fb8cf1830000000ull,
    0x3fb927e640000000ull,
    0x3fb9806d90000000ull,
    0x3fb9d8aea0000000ull,
    0x3fba30a9d0000000ull,
    0x3fba885fa0000000ull,
    0x3fbadfd070000000ull,
    0x3fbb36fcb0000000ull,
    0x3fbb8de4d0000000ull,
    0x3fbbe48930000000ull,
    0x3fbc3aea40000000ull,
    0x3fbc910870000000ull,
    0x3fbce6e410000000ull,
    0x3fbd3c7da0000000ull,
    0x3fbd91d580000000ull,
    0x3fbde6ec00000000ull,
    0x3fbe3bc1a0000000ull,
    0x3fbe9056b0000000ull,
    0x3fbee4aba0000000ull,
    0x3fbf38c0c0000000ull,
    0x3fbf8c9680000000ull,
    0x3fbfe02d30000000ull,
    0x3fc019c2a0000000ull,
    0x3fc0434f70000000ull,
    0x3fc06cbd60000000ull,
    0x3fc0960c80000000ull,
    0x3fc0bf3d00000000ull,
    0x3fc0e84f10000000ull,
    0x3fc11142f0000000ull,
    0x3fc13a18a0000000ull,
    0x3fc162d080000000ull,
    0x3fc18b6a90000000ull,
    0x3fc1b3e710000000ull,
    0x3fc1dc4630000000ull,
    0x3fc2048810000000ull,
    0x3fc22cace0000000ull,
    0x3fc254b4d0000000ull,
    0x3fc27c9ff0000000ull,
    0x3fc2a46e80000000ull,
    0x3fc2cc20b0000000ull,
    0x3fc2f3b690000000ull,
    0x3fc31b3050000000ull,
    0x3fc3428e20000000ull,
    0x3fc369d020000000ull,
    0x3fc390f680000000ull,
    0x3fc3b80160000000ull,
    0x3fc3def0e0000000ull,
    0x3fc405c530000000ull,
    0x3fc42c7e70000000ull,
    0x3fc4531cd0000000ull,
    0x3fc479a070000000ull,
    0x3fc4a00970000000ull,
    0x3fc4c65800000000ull,
    0x3fc4ec8c30000000ull,
    0x3fc512a640000000ull,
    0x3fc538a630000000ull,
    0x3fc55e8c50000000ull,
    0x3fc5845890000000ull,
    0x3fc5aa0b40000000ull,
    0x3fc5cfa470000000ull,
    0x3fc5f52440000000ull,
    0x3fc61a8ad0000000ull,
    0x3fc63fd850000000ull,
    0x3fc6650cd0000000ull,
    0x3fc68a2880000000ull,
    0x3fc6af2b80000000ull,
    0x3fc6d415e0000000ull,
    0x3fc6f8e7d0000000ull,
    0x3fc71da170000000ull,
    0x3fc74242e0000000ull,
    0x3fc766cc40000000ull,
    0x3fc78b3da0000000ull,
    0x3fc7af9730000000ull,
    0x3fc7d3d910000000ull,
    0x3fc7f80350000000ull,
    0x3fc81c1620000000ull,
    0x3fc8401190000000ull,
    0x3fc863f5c0000000ull,
    0x3fc887c2e0000000ull,
    0x3fc8ab7900000000ull,
    0x3fc8cf1830000000ull,
    0x3fc8f2a0a0000000ull,
    0x3fc9161270000000ull,
    0x3fc9396db0000000ull,
    0x3fc95cb280000000ull,
    0x3fc97fe100000000ull,
    0x3fc9a2f950000000ull,
    0x3fc9c5fb70000000ull,
    0x3fc9e8e7b0000000ull,
    0x3fca0bbdf0000000ull,
    0x3fca2e7e80000000ull,
    0x3fca512960000000ull,
    0x3fca73bea0000000ull,
    0x3fca963e70000000ull,
    0x3fcab8a8f0000000ull,
    0x3fcadafe20000000ull,
    0x3fcafd3e30000000ull,
    0x3fcb1f6930000000ull,
    0x3fcb417f40000000ull,
    0x3fcb638070000000ull,
    0x3fcb856cf0000000ull,
    0x3fcba744b0000000ull,
    0x3fcbc907f0000000ull,
    0x3fcbeab6c0000000ull,
    0x3fcc0c5130000000ull,
    0x3fcc2dd750000000ull,
    0x3fcc4f4950000000ull,
    0x3fcc70a740000000ull,
    0x3fcc91f130000000ull,
    0x3fccb32740000000ull,
    0x3fccd44980000000ull,
    0x3fccf55810000000ull,
    0x3fcd165300000000ull,
    0x3fcd373a60000000ull,
    0x3fcd580e60000000ull,
    0x3fcd78cf00000000ull,
    0x3fcd997c70000000ull,
    0x3fcdba16a0000000ull,
    0x3fcdda9dd0000000ull,
    0x3fcdfb11f0000000ull,
    0x3fce1b7330000000ull,
    0x3fce3bc1a0000000ull,
    0x3fce5bfd50000000ull,
    0x3fce7c2660000000ull,
    0x3fce9c3ce0000000ull,
    0x3fcebc40e0000000ull,
    0x3fcedc3280000000ull,
    0x3fcefc11d0000000ull,
    0x3fcf1bdee0000000ull,
    0x3fcf3b99d0000000ull,
    0x3fcf5b42a0000000ull,
    0x3fcf7ad980000000ull,
    0x3fcf9a5e70000000ull,
    0x3fcfb9d190000000ull,
    0x3fcfd932f0000000ull,
    0x3fcff882a0000000ull,
    0x3fd00be050000000ull,
    0x3fd01b76a0000000ull,
    0x3fd02b0430000000ull,
    0x3fd03a8910000000ull,
    0x3fd04a0540000000ull,
    0x3fd05978e0000000ull,
    0x3fd068e3f0000000ull,
    0x3fd0784670000000ull,
    0x3fd087a080000000ull,
    0x3fd096f210000000ull,
    0x3fd0a63b30000000ull,
    0x3fd0b57bf0000000ull,
    0x3fd0c4b450000000ull,
    0x3fd0d3e460000000ull,
    0x3fd0e30c30000000ull,
    0x3fd0f22bc0000000ull,
    0x3fd1014310000000ull,
    0x3fd1105240000000ull,
    0x3fd11f5940000000ull,
    0x3fd12e5830000000ull,
    0x3fd13d4f00000000ull,
    0x3fd14c3dd0000000ull,
    0x3fd15b24a0000000ull,
    0x3fd16a0370000000ull,
    0x3fd178da50000000ull,
    0x3fd187a940000000ull,
    0x3fd1967060000000ull,
    0x3fd1a52fa0000000ull,
    0x3fd1b3e710000000ull,
    0x3fd1c296c0000000ull,
    0x3fd1d13eb0000000ull,
    0x3fd1dfdef0000000ull,
    0x3fd1ee7770000000ull,
    0x3fd1fd0860000000ull,
    0x3fd20b91a0000000ull,
    0x3fd21a1350000000ull,
    0x3fd2288d70000000ull,
    0x3fd2370010000000ull,
    0x3fd2456b30000000ull,
    0x3fd253ced0000000ull,
    0x3fd2622b00000000ull,
    0x3fd2707fd0000000ull,
    0x3fd27ecd40000000ull,
    0x3fd28d1360000000ull,
    0x3fd29b5220000000ull,
    0x3fd2a989a0000000ull,
    0x3fd2b7b9e0000000ull,
    0x3fd2c5e2e0000000ull,
    0x3fd2d404b0000000ull,
    0x3fd2e21f50000000ull,
    0x3fd2f032c0000000ull,
    0x3fd2fe3f20000000ull,
    0x3fd30c4470000000ull,
    0x3fd31a42b0000000ull,
    0x3fd32839e0000000ull,
    0x3fd3362a10000000ull,
    0x3fd3441350000000ull,
};

const unsigned long long _CRT_ALIGN(16) __log10_256_tail[] =
{
    0x0000000000000000ull,
    0x3db20abc22b2208full,
    0x3db10f69332e0dd4ull,
    0x3dce950de87ed257ull,
    0x3dd3f3443b626d69ull,
    0x3df45aeaa5363e57ull,
    0x3dc443683ce1bf0bull,
    0x3df989cd60c6a511ull,
    0x3dfd626f201f2e9full,
    0x3de94f8bb8dabdcdull,
    0x3e0088d8ef423015ull,
    0x3e080413a62b79adull,
    0x3e059717c0eed3c4ull,
    0x3dad4a77add44902ull,
    0x3e0e763ff037300eull,
    0x3de162d74706f6c3ull,
    0x3e0601cc1f4dbc14ull,
    0x3deaf3e051f6e5bfull,
    0x3e097a0b1e1af3ebull,
    0x3dc0a38970c002c7ull,
    0x3e102e000057c751ull,
    0x3e155b00eecd6e0eull,
    0x3ddf86297003b5afull,
    0x3e1057b9b336a36dull,
    0x3e134bc84a06ea4full,
    0x3e1643da9ea1bcadull,
    0x3e1d66a7b4f7ea2aull,
    0x3df6b2e038f7fcefull,
    0x3df3e954c670f088ull,
    0x3e047209093acab3ull,
    0x3e1d708fe7275da7ull,
    0x3e1fdf9e7771b9e7ull,
    0x3e0827bfa70a0660ull,
    0x3e1601cc1f4dbc14ull,
    0x3e0637f6106a5e5bull,
    0x3e126a13f17c624bull,
    0x3e093eb2ce80623aull,
    0x3e1430d1e91594deull,
    0x3e1d6b10108fa031ull,
    0x3e16879c0bbaf241ull,
    0x3dff08015ea6bc2bull,
    0x3e29b63dcdc6676cull,
    0x3e2b022cbcc4ab2cull,
    0x3df917d07ddd6544ull,
    0x3e1540605703379eull,
    0x3e0cd18b947a1b60ull,
    0x3e17ad65277ca97eull,
    0x3e11884dc59f5fa9ull,
    0x3e1711c46006d082ull,
    0x3e2f092e3c3108f8ull,
    0x3e1714c5e32be13aull,
    0x3e26bba7fd734f9aull,
    0x3dfdf48fb5e08483ull,
    0x3e232f9bc74d0b95ull,
    0x3df973e848790c13ull,
    0x3e1eccbc08c6586eull,
    0x3e2115e9f9524a98ull,
    0x3e2f1740593131b8ull,
    0x3e1bcf8b25643835ull,
    0x3e1f5fa81d8bed80ull,
    0x3e244a4df929d9e4ull,
    0x3e129820d8220c94ull,
    0x3e2a0b489304e309ull,
    0x3e1f4d56aba665feull,
    0x3e210c9019365163ull,
    0x3df80f78fe592736ull,
    0x3e10528825c81ccaull,
    0x3de095537d6d746aull,
    0x3e1827bfa70a0660ull,
    0x3e06b0a8ec45933cull,
    0x3e105af81bf5dba9ull,
    0x3e17e2fa2655d515ull,
    0x3e0d59ecbfaee4bfull,
    0x3e1d8b2fda683fa3ull,
    0x3e24b8ddfd3a3737ull,
    0x3e13827e61ae1204ull,
    0x3e2c8c7b49e90f9full,
    0x3e29eaf01597591dull,
    0x3e19aaa66e317b36ull,
    0x3e2e725609720655ull,
    0x3e261c33fc7aac54ull,
    0x3e29662bcf61a252ull,
    0x3e1843c811c42730ull,
    0x3e2064bb0b5acb36ull,
    0x3e0a340c842701a4ull,
    0x3e1a8e55b58f79d6ull,
    0x3de92d219c5e9d9aull,
    0x3e3f63e60d7ffd6aull,
    0x3e2e9b0ed9516314ull,
    0x3e2923901962350cull,
    0x3e326f8838785e81ull,
    0x3e3b5b6a4caba6afull,
    0x3df0226adc8e761cull,
    0x3e3c4ad7313a1aedull,
    0x3e1564e87c738d17ull,
    0x3e338fecf18a6618ull,
    0x3e3d929ef5777666ull,
    0x3e39483bf08da0b8ull,
    0x3e3bdd0eeeaa5826ull,
    0x3e39c4dd590237baull,
    0x3e1af3e9e0ebcac7ull,
    0x3e35ce5382270dacull,
    0x3e394f74532ab9baull,
    0x3e07342795888654ull,
    0x3e0c5a000be34bf0ull,
    0x3e2711c46006d082ull,
    0x3e250025b4ed8cf8ull,
    0x3e2ed18bcef2d2a0ull,
    0x3e21282e0c0a7554ull,
    0x3e0d70f33359a7caull,
    0x3e2b7f7e13a84025ull,
    0x3e33306ec321891eull,
    0x3e3fc7f8038b7550ull,
    0x3e3eb0358cd71d64ull,
    0x3e3a76c822859474ull,
    0x3e3d0ec652de86e3ull,
    0x3e2fa4cce08658afull,
    0x3e3b84a2d2c00a9eull,
    0x3e20a5b0f2c25bd1ull,
    0x3e3dd660225bf699ull,
    0x3e08b10f859bf037ull,
    0x3e3e8823b590cbe1ull,
    0x3e361311f31e96f6ull,
    0x3e2e1f875ca20f9aull,
    0x3e2c95724939b9a5ull,
    0x3e3805957a3e58e2ull,
    0x3e2ff126ea9f0334ull,
    0x3e3953f5598e5609ull,
    0x3e36c16ff856c448ull,
    0x3e24cb220ff261f4ull,
    0x3e35e120d53d53a2ull,
    0x3e3a527f6189f256ull,
    0x3e3856fcffd49c0full,
    0x3e300c2e8228d7daull,
    0x3df113d09444dfe0ull,
    0x3e2510630eea59a6ull,
    0x3e262e780f32d711ull,
    0x3ded3ed91a10f8cfull,
    0x3e23654a7e4bcd85ull,
    0x3e055b784980ad21ull,
    0x3e212f2dd4b16e64ull,
    0x3e37c4add939f50cull,
    0x3e281784627180fcull,
    0x3dea5162c7e14961ull,
    0x3e310c9019365163ull,
    0x3e373c4d2ba17688ull,
    0x3e2ae8a5e0e93d81ull,
    0x3e2ab0c6f01621afull,
    0x3e301e8b74dd5b66ull,
    0x3e2d206fecbb5494ull,
    0x3df0b48b724fcc00ull,
    0x3e3f831f0b61e229ull,
    0x3df81a97c407bcafull,
    0x3e3e286c1ccbb7aaull,
    0x3e28630b49220a93ull,
    0x3dff0b15c1a22c5cull,
    0x3e355445e71c0946ull,
    0x3e3be630f8066d85ull,
    0x3e2599dff0d96c39ull,
    0x3e36cc85b18fb081ull,
    0x3e34476d001ea8c8ull,
    0x3e373f889e16d31full,
    0x3e3357100d792a87ull,
    0x3e3bd179ae6101f6ull,
    0x3e0ca31056c3f6e2ull,
    0x3e3d2870629c08fbull,
    0x3e3aba3880d2673full,
    0x3e2c3633cb297da6ull,
    0x3e21843899efea02ull,
    0x3e3bccc99d2008e6ull,
    0x3e38000544bdd350ull,
    0x3e2b91c226606ae1ull,
    0x3e2a7adf26b62bdfull,
    0x3e18764fc8826ec9ull,
    0x3e1f4f3de50f68f0ull,
    0x3df760ca757995e3ull,
    0x3dfc667ed3805147ull,
    0x3e3733f6196adf6full,
    0x3e2fb710f33e836bull,
    0x3e39886eba641013ull,
    0x3dfb5368d0af8c1aull,
    0x3e358c691b8d2971ull,
    0x3dfe9465226d08fbull,
    0x3e33587e063f0097ull,
    0x3e3618e702129f18ull,
    0x3e361c33fc7aac54ull,
    0x3e3f07a68408604aull,
    0x3e3c34bfe4945421ull,
    0x3e38b1f00e41300bull,
    0x3e3f434284d61b63ull,
    0x3e3a63095e397436ull,
    0x3e34428656b919deull,
    0x3e36ca9201b2d9a6ull,
    0x3e2738823a2a931cull,
    0x3e3c11880e179230ull,
    0x3e313ddc8d6d52feull,
    0x3e33eed58922e917ull,
    0x3e295992846bdd50ull,
    0x3e0ddb4d5f2e278bull,
    0x3df1a5f12a0635c4ull,
    0x3e4642f0882c3c34ull,
    0x3e2aee9ba7f6475eull,
    0x3e264b7f834a60e4ull,
    0x3e290d42e243792eull,
    0x3e4c272008134f01ull,
    0x3e4a782e16d6cf5bull,
    0x3e44505c79da6648ull,
    0x3e4ca9d4ea4dcd21ull,
    0x3e297d3d627cd5bcull,
    0x3e20b15cf9bcaa13ull,
    0x3e315b2063cf76ddull,
    0x3e2983e6f3aa2748ull,
    0x3e3f4c64f4ffe994ull,
    0x3e46beba7ce85a0full,
    0x3e3b9c69fd4ea6b8ull,
    0x3e2b6aa5835fa4abull,
    0x3e43ccc3790fedd1ull,
    0x3e29c04cc4404fe0ull,
    0x3e40734b7a75d89dull,
    0x3e1b4404c4e01612ull,
    0x3e40c565c2ce4894ull,
    0x3e33c71441d935cdull,
    0x3d72a492556b3b4eull,
    0x3e20fa090341dc43ull,
    0x3e2e8f7009e3d9f4ull,
    0x3e4b1bf68b048a45ull,
    0x3e3eee52dffaa956ull,
    0x3e456b0900e465bdull,
    0x3e4d929ef5777666ull,
    0x3e486ea28637e260ull,
    0x3e4665aff10ca2f0ull,
    0x3e2f11fdaf48ec74ull,
    0x3e4cbe1b86a4d1c7ull,
    0x3e25b05bfea87665ull,
    0x3e41cec20a1a4a1dull,
    0x3e41cd5f0a409b9full,
    0x3e453656c8265070ull,
    0x3e377ed835282260ull,
    0x3e2417bc3040b9d2ull,
    0x3e408eef7b79eff2ull,
    0x3e4dc76f39dc57e9ull,
    0x3e4c0493a70cf457ull,
    0x3e4a83d6cea5a60cull,
    0x3e30d6700dc557baull,
    0x3e44c96c12e8bd0aull,
    0x3e3d2c1993e32315ull,
    0x3e22c721135f8242ull,
    0x3e279a3e4dda747dull,
    0x3dfcf89f6941a72bull,
    0x3e2149a702f10831ull,
    0x3e4ead4b7c8175dbull,
    0x3e4e6930fe63e70aull,
    0x3e41e106bed9ee2full,
    0x3e2d682b82f11c92ull,
    0x3e3a07f188dba47cull,
    0x3e40f9342dc172f6ull,
    0x3e03ef3fde623e25ull,
};
