/*
 * MIT License
 * -----------
 *
 * Copyright (c) 2002-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this Software and associated documentaon files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **
 ** Defines __log_128_lead and __log_128_tail tables
 ** Used by log and pow
 **
 */

#include <crtdefs.h>

const unsigned int _CRT_ALIGN(16) __log_128_lead[] =
{
    0x000000000,
    0x03bff0000,
    0x03c7e0000,
    0x03cbdc000,
    0x03cfc1000,
    0x03d1cf000,
    0x03d3ba000,
    0x03d5a1000,
    0x03d785000,
    0x03d8b2000,
    0x03d9a0000,
    0x03da8d000,
    0x03db78000,
    0x03dc61000,
    0x03dd49000,
    0x03de2f000,
    0x03df13000,
    0x03dff6000,
    0x03e06b000,
    0x03e0db000,
    0x03e14a000,
    0x03e1b8000,
    0x03e226000,
    0x03e293000,
    0x03e2ff000,
    0x03e36b000,
    0x03e3d5000,
    0x03e43f000,
    0x03e4a9000,
    0x03e511000,
    0x03e579000,
    0x03e5e1000,
    0x03e647000,
    0x03e6ae000,
    0x03e713000,
    0x03e778000,
    0x03e7dc000,
    0x03e820000,
    0x03e851000,
    0x03e882000,
    0x03e8b3000,
    0x03e8e4000,
    0x03e914000,
    0x03e944000,
    0x03e974000,
    0x03e9a3000,
    0x03e9d3000,
    0x03ea02000,
    0x03ea30000,
    0x03ea5f000,
    0x03ea8d000,
    0x03eabb000,
    0x03eae8000,
    0x03eb16000,
    0x03eb43000,
    0x03eb70000,
    0x03eb9c000,
    0x03ebc9000,
    0x03ebf5000,
    0x03ec21000,
    0x03ec4d000,
    0x03ec78000,
    0x03eca3000,
    0x03ecce000,
    0x03ecf9000,
    0x03ed24000,
    0x03ed4e000,
    0x03ed78000,
    0x03eda2000,
    0x03edcc000,
    0x03edf5000,
    0x03ee1e000,
    0x03ee47000,
    0x03ee70000,
    0x03ee99000,
    0x03eec1000,
    0x03eeea000,
    0x03ef12000,
    0x03ef3a000,
    0x03ef61000,
    0x03ef89000,
    0x03efb0000,
    0x03efd7000,
    0x03effe000,
    0x03f012000,
    0x03f025000,
    0x03f039000,
    0x03f04c000,
    0x03f05f000,
    0x03f072000,
    0x03f084000,
    0x03f097000,
    0x03f0aa000,
    0x03f0bc000,
    0x03f0cf000,
    0x03f0e1000,
    0x03f0f4000,
    0x03f106000,
    0x03f118000,
    0x03f12a000,
    0x03f13c000,
    0x03f14e000,
    0x03f160000,
    0x03f172000,
    0x03f183000,
    0x03f195000,
    0x03f1a7000,
    0x03f1b8000,
    0x03f1c9000,
    0x03f1db000,
    0x03f1ec000,
    0x03f1fd000,
    0x03f20e000,
    0x03f21f000,
    0x03f230000,
    0x03f241000,
    0x03f252000,
    0x03f263000,
    0x03f273000,
    0x03f284000,
    0x03f295000,
    0x03f2a5000,
    0x03f2b5000,
    0x03f2c6000,
    0x03f2d6000,
    0x03f2e6000,
    0x03f2f7000,
    0x03f307000,
    0x03f317000
};

const unsigned int _CRT_ALIGN(16) __log_128_tail[] =
{
    0x000000000,
    0x03429ac41,
    0x035a8b0fc,
    0x0368d83ea,
    0x0361b0e78,
    0x03687b9fe,
    0x03631ec65,
    0x036dd7119,
    0x035c30045,
    0x0379b7751,
    0x037ebcb0d,
    0x037839f83,
    0x037528ae5,
    0x037a2eb18,
    0x036da7495,
    0x036a91eb7,
    0x03783b715,
    0x0371131db,
    0x0383f3e68,
    0x038156a97,
    0x038297c0f,
    0x0387e100f,
    0x03815b665,
    0x037e5e3a1,
    0x038183853,
    0x035fe719d,
    0x038448108,
    0x038503290,
    0x0373539e8,
    0x0385e0ff1,
    0x03864a740,
    0x03786742d,
    0x0387be3cd,
    0x03685ad3e,
    0x03803b715,
    0x037adcbdc,
    0x0380c36af,
    0x0371652d3,
    0x038927139,
    0x038c5fcd7,
    0x038ae55d5,
    0x03818c169,
    0x038a0fde7,
    0x038ad09ef,
    0x03862bae1,
    0x038eecd4c,
    0x03798aad2,
    0x037421a1a,
    0x038c5e10e,
    0x037bf2aee,
    0x0382d872d,
    0x037ee2e8a,
    0x038dedfac,
    0x03802f2b9,
    0x038481e9b,
    0x0380eaa2b,
    0x038ebfb5d,
    0x038255fdd,
    0x038783b82,
    0x03851da1e,
    0x0374e1b05,
    0x0388f439b,
    0x038ca0e10,
    0x038cac08b,
    0x03891f65f,
    0x0378121cb,
    0x0386c9a9a,
    0x038949923,
    0x038777bcc,
    0x037b12d26,
    0x038a6ced3,
    0x038ebd3e6,
    0x038fbe3cd,
    0x038d785c2,
    0x0387e7e00,
    0x038f392c5,
    0x037d40983,
    0x038081a7c,
    0x03784c3ad,
    0x038cce923,
    0x0380f5faf,
    0x03891fd38,
    0x038ac47bc,
    0x03897042b,
    0x0392952d2,
    0x0396fced4,
    0x037f97073,
    0x0385e9eae,
    0x03865c84a,
    0x038130ba3,
    0x03979cf16,
    0x03938cac9,
    0x038c3d2f4,
    0x039755dec,
    0x038e6b467,
    0x0395c0fb8,
    0x0383ebce0,
    0x038dcd192,
    0x039186bdf,
    0x0392de74c,
    0x0392f0944,
    0x0391bff61,
    0x038e9ed44,
    0x038686dc8,
    0x0396b99a7,
    0x039099c89,
    0x037a27673,
    0x0390bdaa3,
    0x0397069ab,
    0x0388449ff,
    0x039013538,
    0x0392dc268,
    0x03947f423,
    0x0394ff17c,
    0x03945e10e,
    0x03929e8f5,
    0x038f85db0,
    0x038735f99,
    0x0396c08db,
    0x03909e600,
    0x037b4996f,
    0x0391233cc,
    0x0397cead9,
    0x038adb5cd,
    0x03920261a,
    0x03958ee36,
    0x035aa4905,
    0x037cbd11e,
    0x03805fdf4
};
