/*
 * MIT License
 * -----------
 *
 * Copyright (c) 2002-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this Software and associated documentaon files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **
 ** Defines __log_256_lead and __log_256_tail tables
 ** Used by log and pow
 **
 */

#include <crtdefs.h>

const unsigned long long _CRT_ALIGN(16) __log_256_lead[] =
{
    0x0000000000000000ull,
    0x3f6ff00aa0000000ull,
    0x3f7fe02a60000000ull,
    0x3f87dc4750000000ull,
    0x3f8fc0a8b0000000ull,
    0x3f93cea440000000ull,
    0x3f97b91b00000000ull,
    0x3f9b9fc020000000ull,
    0x3f9f829b00000000ull,
    0x3fa1b0d980000000ull,
    0x3fa39e87b0000000ull,
    0x3fa58a5ba0000000ull,
    0x3fa77458f0000000ull,
    0x3fa95c8300000000ull,
    0x3fab42dd70000000ull,
    0x3fad276b80000000ull,
    0x3faf0a30c0000000ull,
    0x3fb0759830000000ull,
    0x3fb16536e0000000ull,
    0x3fb253f620000000ull,
    0x3fb341d790000000ull,
    0x3fb42edcb0000000ull,
    0x3fb51b0730000000ull,
    0x3fb60658a0000000ull,
    0x3fb6f0d280000000ull,
    0x3fb7da7660000000ull,
    0x3fb8c345d0000000ull,
    0x3fb9ab4240000000ull,
    0x3fba926d30000000ull,
    0x3fbb78c820000000ull,
    0x3fbc5e5480000000ull,
    0x3fbd4313d0000000ull,
    0x3fbe270760000000ull,
    0x3fbf0a30c0000000ull,
    0x3fbfec9130000000ull,
    0x3fc0671510000000ull,
    0x3fc0d77e70000000ull,
    0x3fc1478580000000ull,
    0x3fc1b72ad0000000ull,
    0x3fc2266f10000000ull,
    0x3fc29552f0000000ull,
    0x3fc303d710000000ull,
    0x3fc371fc20000000ull,
    0x3fc3dfc2b0000000ull,
    0x3fc44d2b60000000ull,
    0x3fc4ba36f0000000ull,
    0x3fc526e5e0000000ull,
    0x3fc59338d0000000ull,
    0x3fc5ff3070000000ull,
    0x3fc66acd40000000ull,
    0x3fc6d60fe0000000ull,
    0x3fc740f8f0000000ull,
    0x3fc7ab8900000000ull,
    0x3fc815c0a0000000ull,
    0x3fc87fa060000000ull,
    0x3fc8e928d0000000ull,
    0x3fc9525a90000000ull,
    0x3fc9bb3620000000ull,
    0x3fca23bc10000000ull,
    0x3fca8becf0000000ull,
    0x3fcaf3c940000000ull,
    0x3fcb5b5190000000ull,
    0x3fcbc28670000000ull,
    0x3fcc296850000000ull,
    0x3fcc8ff7c0000000ull,
    0x3fccf63540000000ull,
    0x3fcd5c2160000000ull,
    0x3fcdc1bca0000000ull,
    0x3fce270760000000ull,
    0x3fce8c0250000000ull,
    0x3fcef0adc0000000ull,
    0x3fcf550a50000000ull,
    0x3fcfb91860000000ull,
    0x3fd00e6c40000000ull,
    0x3fd0402590000000ull,
    0x3fd071b850000000ull,
    0x3fd0a324e0000000ull,
    0x3fd0d46b50000000ull,
    0x3fd1058bf0000000ull,
    0x3fd1368700000000ull,
    0x3fd1675ca0000000ull,
    0x3fd1980d20000000ull,
    0x3fd1c898c0000000ull,
    0x3fd1f8ff90000000ull,
    0x3fd22941f0000000ull,
    0x3fd2596010000000ull,
    0x3fd2895a10000000ull,
    0x3fd2b93030000000ull,
    0x3fd2e8e2b0000000ull,
    0x3fd31871c0000000ull,
    0x3fd347dd90000000ull,
    0x3fd3772660000000ull,
    0x3fd3a64c50000000ull,
    0x3fd3d54fa0000000ull,
    0x3fd4043080000000ull,
    0x3fd432ef20000000ull,
    0x3fd4618bc0000000ull,
    0x3fd4900680000000ull,
    0x3fd4be5f90000000ull,
    0x3fd4ec9730000000ull,
    0x3fd51aad80000000ull,
    0x3fd548a2c0000000ull,
    0x3fd5767710000000ull,
    0x3fd5a42ab0000000ull,
    0x3fd5d1bdb0000000ull,
    0x3fd5ff3070000000ull,
    0x3fd62c82f0000000ull,
    0x3fd659b570000000ull,
    0x3fd686c810000000ull,
    0x3fd6b3bb20000000ull,
    0x3fd6e08ea0000000ull,
    0x3fd70d42e0000000ull,
    0x3fd739d7f0000000ull,
    0x3fd7664e10000000ull,
    0x3fd792a550000000ull,
    0x3fd7bede00000000ull,
    0x3fd7eaf830000000ull,
    0x3fd816f410000000ull,
    0x3fd842d1d0000000ull,
    0x3fd86e9190000000ull,
    0x3fd89a3380000000ull,
    0x3fd8c5b7c0000000ull,
    0x3fd8f11e80000000ull,
    0x3fd91c67e0000000ull,
    0x3fd9479410000000ull,
    0x3fd972a340000000ull,
    0x3fd99d9580000000ull,
    0x3fd9c86b00000000ull,
    0x3fd9f323e0000000ull,
    0x3fda1dc060000000ull,
    0x3fda484090000000ull,
    0x3fda72a490000000ull,
    0x3fda9cec90000000ull,
    0x3fdac718c0000000ull,
    0x3fdaf12930000000ull,
    0x3fdb1b1e00000000ull,
    0x3fdb44f770000000ull,
    0x3fdb6eb590000000ull,
    0x3fdb985890000000ull,
    0x3fdbc1e080000000ull,
    0x3fdbeb4d90000000ull,
    0x3fdc149ff0000000ull,
    0x3fdc3dd7a0000000ull,
    0x3fdc66f4e0000000ull,
    0x3fdc8ff7c0000000ull,
    0x3fdcb8e070000000ull,
    0x3fdce1af00000000ull,
    0x3fdd0a63a0000000ull,
    0x3fdd32fe70000000ull,
    0x3fdd5b7f90000000ull,
    0x3fdd83e720000000ull,
    0x3fddac3530000000ull,
    0x3fddd46a00000000ull,
    0x3fddfc8590000000ull,
    0x3fde248810000000ull,
    0x3fde4c71a0000000ull,
    0x3fde744260000000ull,
    0x3fde9bfa60000000ull,
    0x3fdec399d0000000ull,
    0x3fdeeb20c0000000ull,
    0x3fdf128f50000000ull,
    0x3fdf39e5b0000000ull,
    0x3fdf6123f0000000ull,
    0x3fdf884a30000000ull,
    0x3fdfaf5880000000ull,
    0x3fdfd64f20000000ull,
    0x3fdffd2e00000000ull,
    0x3fe011fab0000000ull,
    0x3fe02552a0000000ull,
    0x3fe0389ee0000000ull,
    0x3fe04bdf90000000ull,
    0x3fe05f14b0000000ull,
    0x3fe0723e50000000ull,
    0x3fe0855c80000000ull,
    0x3fe0986f40000000ull,
    0x3fe0ab76b0000000ull,
    0x3fe0be72e0000000ull,
    0x3fe0d163c0000000ull,
    0x3fe0e44980000000ull,
    0x3fe0f72410000000ull,
    0x3fe109f390000000ull,
    0x3fe11cb810000000ull,
    0x3fe12f7190000000ull,
    0x3fe1422020000000ull,
    0x3fe154c3d0000000ull,
    0x3fe1675ca0000000ull,
    0x3fe179eab0000000ull,
    0x3fe18c6e00000000ull,
    0x3fe19ee6b0000000ull,
    0x3fe1b154b0000000ull,
    0x3fe1c3b810000000ull,
    0x3fe1d610f0000000ull,
    0x3fe1e85f50000000ull,
    0x3fe1faa340000000ull,
    0x3fe20cdcd0000000ull,
    0x3fe21f0bf0000000ull,
    0x3fe23130d0000000ull,
    0x3fe2434b60000000ull,
    0x3fe2555bc0000000ull,
    0x3fe2676200000000ull,
    0x3fe2795e10000000ull,
    0x3fe28b5000000000ull,
    0x3fe29d37f0000000ull,
    0x3fe2af15f0000000ull,
    0x3fe2c0e9e0000000ull,
    0x3fe2d2b400000000ull,
    0x3fe2e47430000000ull,
    0x3fe2f62a90000000ull,
    0x3fe307d730000000ull,
    0x3fe3197a00000000ull,
    0x3fe32b1330000000ull,
    0x3fe33ca2b0000000ull,
    0x3fe34e2890000000ull,
    0x3fe35fa4e0000000ull,
    0x3fe37117b0000000ull,
    0x3fe38280f0000000ull,
    0x3fe393e0d0000000ull,
    0x3fe3a53730000000ull,
    0x3fe3b68440000000ull,
    0x3fe3c7c7f0000000ull,
    0x3fe3d90260000000ull,
    0x3fe3ea3390000000ull,
    0x3fe3fb5b80000000ull,
    0x3fe40c7a40000000ull,
    0x3fe41d8fe0000000ull,
    0x3fe42e9c60000000ull,
    0x3fe43f9fe0000000ull,
    0x3fe4509a50000000ull,
    0x3fe4618bc0000000ull,
    0x3fe4727430000000ull,
    0x3fe48353d0000000ull,
    0x3fe4942a80000000ull,
    0x3fe4a4f850000000ull,
    0x3fe4b5bd60000000ull,
    0x3fe4c679a0000000ull,
    0x3fe4d72d30000000ull,
    0x3fe4e7d810000000ull,
    0x3fe4f87a30000000ull,
    0x3fe50913c0000000ull,
    0x3fe519a4c0000000ull,
    0x3fe52a2d20000000ull,
    0x3fe53aad00000000ull,
    0x3fe54b2460000000ull,
    0x3fe55b9350000000ull,
    0x3fe56bf9d0000000ull,
    0x3fe57c57f0000000ull,
    0x3fe58cadb0000000ull,
    0x3fe59cfb20000000ull,
    0x3fe5ad4040000000ull,
    0x3fe5bd7d30000000ull,
    0x3fe5cdb1d0000000ull,
    0x3fe5ddde50000000ull,
    0x3fe5ee02a0000000ull,
    0x3fe5fe1ed0000000ull,
    0x3fe60e32f0000000ull,
    0x3fe61e3ef0000000ull,
    0x3fe62e42e0000000ull,
    0x0000000000000000ull
};

const unsigned long long _CRT_ALIGN(16) __log_256_tail[] =
{
    0x0000000000000000ull,
    0x3db5885e0250435aull,
    0x3de620cf11f86ed2ull,
    0x3dff0214edba4a25ull,
    0x3dbf807c79f3db4eull,
    0x3dea352ba779a52bull,
    0x3dff56c46aa49fd5ull,
    0x3dfebe465fef5196ull,
    0x3e0cf0660099f1f8ull,
    0x3e1247b2ff85945dull,
    0x3e13fd7abf5202b6ull,
    0x3e1f91c9a918d51eull,
    0x3e08cb73f118d3caull,
    0x3e1d91c7d6fad074ull,
    0x3de1971bec28d14cull,
    0x3e15b616a423c78aull,
    0x3da162a6617cc971ull,
    0x3e166391c4c06d29ull,
    0x3e2d46f5c1d0c4b8ull,
    0x3e2e14282df1f6d3ull,
    0x3e186f47424a660dull,
    0x3e2d4c8de077753eull,
    0x3e2e0c307ed24f1cull,
    0x3e226ea18763bdd3ull,
    0x3e25cad69737c933ull,
    0x3e2af62599088901ull,
    0x3e18c66c83d6b2d0ull,
    0x3e1880ceb36fb30full,
    0x3e2495aac6ca17a4ull,
    0x3e2761db4210878cull,
    0x3e2eb78e862bac2full,
    0x3e19b2cd75790dd9ull,
    0x3e2c55e5cbd3d50full,
    0x3db162a6617cc971ull,
    0x3dfdbeabaaa2e519ull,
    0x3e1652cb7150c647ull,
    0x3e39a11cb2cd2ee2ull,
    0x3e219d0ab1a28813ull,
    0x3e24bd9e80a41811ull,
    0x3e3214b596faa3dfull,
    0x3e303fea46980bb8ull,
    0x3e31c8ffa5fd28c7ull,
    0x3dce8f743bcd96c5ull,
    0x3dfd98c5395315c6ull,
    0x3e3996fa3ccfa7b2ull,
    0x3e1cd2af2ad13037ull,
    0x3e1d0da1bd17200eull,
    0x3e3330410ba68b75ull,
    0x3df4f27a790e7c41ull,
    0x3e13956a86f6ff1bull,
    0x3e2c6748723551d9ull,
    0x3e2500de9326cdfcull,
    0x3e1086c848df1b59ull,
    0x3e04357ead6836ffull,
    0x3e24832442408024ull,
    0x3e3d10da8154b13dull,
    0x3e39e8ad68ec8260ull,
    0x3e3cfbf706abaf18ull,
    0x3e3fc56ac6326e23ull,
    0x3e39105e3185cf21ull,
    0x3e3d017fe5b19cc0ull,
    0x3e3d1f6b48dd13feull,
    0x3e20b63358a7e73aull,
    0x3e263063028c211cull,
    0x3e2e6a6886b09760ull,
    0x3e3c138bb891cd03ull,
    0x3e369f7722b7221aull,
    0x3df57d8fac1a628cull,
    0x3e3c55e5cbd3d50full,
    0x3e1552d2ff48fe2eull,
    0x3e37b8b26ca431bcull,
    0x3e292decdc1c5f6dull,
    0x3e3abc7c551aaa8cull,
    0x3e36b540731a354bull,
    0x3e32d341036b89efull,
    0x3e4f9ab21a3a2e0full,
    0x3e239c871afb9fbdull,
    0x3e3e6add2c81f640ull,
    0x3e435c95aa313f41ull,
    0x3e249d4582f6cc53ull,
    0x3e47574c1c07398full,
    0x3e4ba846dece9e8dull,
    0x3e16999fafbc68e7ull,
    0x3e4c9145e51b0103ull,
    0x3e479ef2cb44850aull,
    0x3e0beec73de11275ull,
    0x3e2ef4351af5a498ull,
    0x3e45713a493b4a50ull,
    0x3e45c23a61385992ull,
    0x3e42a88309f57299ull,
    0x3e4530faa9ac8aceull,
    0x3e25fec2d792a758ull,
    0x3e35a517a71cbcd7ull,
    0x3e3707dc3e1cd9a3ull,
    0x3e3a1a9f8ef43049ull,
    0x3e4409d0276b3674ull,
    0x3e20e2f613e85bd9ull,
    0x3df0027433001e5full,
    0x3e35dde2836d3265ull,
    0x3e2300134d7aaf04ull,
    0x3e3cb7e0b42724f5ull,
    0x3e2d6e93167e6308ull,
    0x3e3d1569b1526adbull,
    0x3e0e99fc338a1a41ull,
    0x3e4eb01394a11b1cull,
    0x3e04f27a790e7c41ull,
    0x3e25ce3ca97b7af9ull,
    0x3e281f0f940ed857ull,
    0x3e4d36295d88857cull,
    0x3e21aca1ec4af526ull,
    0x3e445743c7182726ull,
    0x3e23c491aead337eull,
    0x3e3aef401a738931ull,
    0x3e21cede76092a29ull,
    0x3e4fba8f44f82bb4ull,
    0x3e446f5f7f3c3e1aull,
    0x3e47055f86c9674bull,
    0x3e4b41a92b6b6e1aull,
    0x3e443d162e927628ull,
    0x3e4466174013f9b1ull,
    0x3e3b05096ad69c62ull,
    0x3e40b169150faa58ull,
    0x3e3cd98b1df85da7ull,
    0x3e468b507b0f8fa8ull,
    0x3e48422df57499baull,
    0x3e11351586970274ull,
    0x3e117e08acba92eeull,
    0x3e26e04314dd0229ull,
    0x3e497f3097e56d1aull,
    0x3e3356e655901286ull,
    0x3e0cb761457f94d6ull,
    0x3e39af67a85a9dacull,
    0x3e453410931a909full,
    0x3e22c587206058f5ull,
    0x3e223bc358899c22ull,
    0x3e4d7bf8b6d223cbull,
    0x3e47991ec5197ddbull,
    0x3e4a79e6bb3a9219ull,
    0x3e3a4c43ed663ec5ull,
    0x3e461b5a1484f438ull,
    0x3e4b4e36f7ef0c3aull,
    0x3e115f026acd0d1bull,
    0x3e3f36b535cecf05ull,
    0x3e2ffb7fbf3eb5c6ull,
    0x3e3e6a6886b09760ull,
    0x3e3135eb27f5bbc3ull,
    0x3e470be7d6f6fa57ull,
    0x3e4ce43cc84ab338ull,
    0x3e4c01d7aac3bd91ull,
    0x3e45c58d07961060ull,
    0x3e3628bcf941456eull,
    0x3e4c58b2a8461cd2ull,
    0x3e33071282fb989aull,
    0x3e420dab6a80f09cull,
    0x3e44f8d84c397b1eull,
    0x3e40d0ee08599e48ull,
    0x3e1d68787e37da36ull,
    0x3e366187d591bafcull,
    0x3e22346600bae772ull,
    0x3e390377d0d61b8eull,
    0x3e4f5e0dd966b907ull,
    0x3e49023cb79a00e2ull,
    0x3e44e05158c28ad8ull,
    0x3e3bfa7b08b18ae4ull,
    0x3e4ef1e63db35f67ull,
    0x3e0ec2ae39493d4full,
    0x3e40afe930ab2fa0ull,
    0x3e225ff8a1810dd4ull,
    0x3e469743fb1a71a5ull,
    0x3e5f9cc676785571ull,
    0x3e5b524da4cbf982ull,
    0x3e5a4c8b381535b8ull,
    0x3e5839be809caf2cull,
    0x3e50968a1cb82c13ull,
    0x3e5eae6a41723fb5ull,
    0x3e5d9c29a380a4dbull,
    0x3e4094aa0ada625eull,
    0x3e5973ad6fc108caull,
    0x3e4747322fdbab97ull,
    0x3e593692fa9d4221ull,
    0x3e5c5a992dfbc7d9ull,
    0x3e4e1f33e102387aull,
    0x3e464fbef14c048cull,
    0x3e4490f513ca5e3bull,
    0x3e37a6af4d4c799dull,
    0x3e57574c1c07398full,
    0x3e57b133417f8c1cull,
    0x3e5feb9e0c176514ull,
    0x3e419f25bb3172f7ull,
    0x3e45f68a7bbfb852ull,
    0x3e5ee278497929f1ull,
    0x3e5ccee006109d58ull,
    0x3e5ce081a07bd8b3ull,
    0x3e570e12981817b8ull,
    0x3e292ab6d93503d0ull,
    0x3e58cb7dd7c3b61eull,
    0x3e4efafd0a0b78daull,
    0x3e5e907267c4288eull,
    0x3e5d31ef96780875ull,
    0x3e23430dfcd2ad50ull,
    0x3e344d88d75bc1f9ull,
    0x3e5bec0f055e04fcull,
    0x3e5d85611590b9adull,
    0x3df320568e583229ull,
    0x3e5a891d1772f538ull,
    0x3e22edc9dabba74dull,
    0x3e4b9009a1015086ull,
    0x3e52a12a8c5b1a19ull,
    0x3e3a7885f0fdac85ull,
    0x3e5f4ffcd43ac691ull,
    0x3e52243ae2640aadull,
    0x3e546513299035d3ull,
    0x3e5b39c3a62dd725ull,
    0x3e5ba6dd40049f51ull,
    0x3e451d1ed7177409ull,
    0x3e5cb0f2fd7f5216ull,
    0x3e3ab150cd4e2213ull,
    0x3e5cfd7bf3193844ull,
    0x3e53fff8455f1dbdull,
    0x3e5fee640b905fc9ull,
    0x3e54e2adf548084cull,
    0x3e3b597adc1ecdd2ull,
    0x3e4345bd096d3a75ull,
    0x3e5101b9d2453c8bull,
    0x3e508ce55cc8c979ull,
    0x3e5bbf017e595f71ull,
    0x3e37ce733bd393dcull,
    0x3e233bb0a503f8a1ull,
    0x3e30e2f613e85bd9ull,
    0x3e5e67555a635b3cull,
    0x3e2ea88df73d5e8bull,
    0x3e3d17e03bda18a8ull,
    0x3e5b607d76044f7eull,
    0x3e52adc4e71bc2fcull,
    0x3e5f99dc7362d1d9ull,
    0x3e5473fa008e6a6aull,
    0x3e2b75bb09cb0985ull,
    0x3e5ea04dd10b9abaull,
    0x3e5802d0d6979674ull,
    0x3e174688ccd99094ull,
    0x3e496f16abb9df22ull,
    0x3e46e66df2aa374full,
    0x3e4e66525ea4550aull,
    0x3e42d02f34f20cbdull,
    0x3e46cfce65047188ull,
    0x3e39b78c842d58b8ull,
    0x3e4735e624c24bc9ull,
    0x3e47eba1f7dd1adfull,
    0x3e586b3e59f65355ull,
    0x3e1ce38e637f1b4dull,
    0x3e58d82ec919edc7ull,
    0x3e4c52648ddcfa37ull,
    0x3e52482ceae1ac12ull,
    0x3e55a312311aba4full,
    0x3e411e236329f225ull,
    0x3e5b48c8cd2f246cull,
    0x3e6efa39ef35793cull,
    0x0000000000000000ull
};
