/*

    dxguid.c - DirectX GUIDs

    Base on Filp Navara <xnavara@volny.cz> dxguid for mingw
    updated by Magnus Olsen (magnus@greatlord.com)

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

#define INITGUID
#include <basetyps.h>
#include <guiddef.h>

/* FIXME - find a better place for these, needed for dsound */
DEFINE_GUID(CLSID_DirectSoundPrivate, 0x11ab3ec0, 0x25ec, 0x11d1, 0xa4, 0xd8, 0x0, 0xc0, 0x4f, 0xc2, 0x8a, 0xca);
DEFINE_GUID(DSPROPSETID_DirectSoundDevice, 0x84624f82, 0x25ec, 0x11d1, 0xa4, 0xd8, 0x0, 0xc0, 0x4f, 0xc2, 0x8a, 0xca);

/* Hack Getting ddraw to compile with kernel interface u can not mix dxguid and striims */
DEFINE_GUID(IID_IDirectDrawKernel, 0x8D56C120, 0x6A08, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(IID_IDirectDrawSurfaceKernel, 0x60755DA0, 0x6A40, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);

/* These GUIDs do not exist in ms dxsdk 2004 dec in dxguid, tested by Magnus Olsen */
DEFINE_GUID(CLSID_AudioVBScript,0x4ee17959,0x931e,0x49e4,0xa2,0xc6,0x97,0x7e,0xcf,0x36,0x28,0xf3);
DEFINE_GUID(CLSID_DirectMusicAuditionTrack,0xd2ac2897,0xb39b,0x11d1,0x87,0x04,0x00,0x60,0x08,0x93,0xb1,0xbd);
DEFINE_GUID(CLSID_DirectMusicMelodyFormulationTrack,0xb0684266,0xb57f,0x11d2,0x97,0xf9,0x0,0xc0,0x4f,0xa3,0x6e,0x58);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpAudioPathConfig,0x1cebde3e,0x6b91,0x484a,0xaf,0x48,0x5e,0x4f,0x4e,0xd6,0xb1,0xe1);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpAudioPath,0x2c5f9b72,0x7148,0x4d97,0xbf,0xc9,0x68,0xa0,0xe0,0x76,0xbe,0xbd);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpPerformance,0xa861c6e2,0xfcfc,0x11d2,0x8b,0xc9,0x00,0x60,0x08,0x93,0xb1,0xb6);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpSegment,0x4062c116,0x0270,0x11d3,0x8b,0xcb,0x00,0x60,0x08,0x93,0xb1,0xb6);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpSegmentState,0xebf2320a,0x2502,0x11d3,0x8b,0xd1,0x00,0x60,0x08,0x93,0xb1,0xb6);
DEFINE_GUID(CLSID_DirectMusicScriptAutoImpSong,0xa16f1761,0xb6d8,0x42eb,0x8d,0x57,0x4a,0x44,0xfe,0xdd,0x3b,0xd2);
DEFINE_GUID(CLSID_DirectMusicScriptSourceCodeLoader,0xc70eb77f,0xefd4,0x4678,0xa2,0x7b,0xbf,0x16,0x48,0xf3,0x0d,0x04);
DEFINE_GUID(CLSID_DirectMusicSection,0x3f037241,0x414e,0x11d1,0xa7,0xce,0x00,0xa0,0xc9,0x13,0xf7,0x3c);
DEFINE_GUID(CLSID_DirectMusicSegTriggerTrack,0xbae4d665,0x4ea1,0x11d3,0x8b,0xda,0x00,0x60,0x08,0x93,0xb1,0xb6);
DEFINE_GUID(CLSID_DirectMusicSynthSink,0xaec17ce3,0xa514,0x11d1,0xaf,0xa6,0x00,0xaa,0x00,0x24,0xd8,0xb6);
DEFINE_GUID(CLSID_DirectMusicTemplate,0xd30bcc65,0x60e8,0x11d1,0xa7,0xce,0x00,0xa0,0xc9,0x13,0xf7,0x3c);
DEFINE_GUID(CLSID_DirectMusicSong,0xaed5f0a5,0xd972,0x483d,0xa3,0x84,0x64,0x9d,0xfe,0xb9,0xc1,0x81);
DEFINE_GUID(GUID_DMUS_PROP_SetSynthSink,0x0a3a5ba5,0x37b6,0x11d2,0xb9,0xf9,0x00,0x00,0xf8,0x75,0xac,0x12);
DEFINE_GUID(GUID_DMUS_PROP_SinkUsesDSound,0xbe208857,0x8952,0x11d2,0xba,0x1c,0x00,0x00,0xf8,0x75,0xac,0x12);
DEFINE_GUID(GUID_Clear_All_MelodyFragments,0x8509fee6,0xb617,0x11d2,0x97,0xfa,0x0,0xc0,0x4f,0xa3,0x6e,0x58);
DEFINE_GUID(GUID_MelodyFragment,0xb291c7f2,0xb616,0x11d2,0x97,0xfa,0x0,0xc0,0x4f,0xa3,0x6e,0x58);
DEFINE_GUID(IID_ID3DXAnimationController,0x3a714d34,0xff61,0x421e,0x90,0x9f,0x63,0x9f,0x38,0x35,0x67,0x8);
DEFINE_GUID(IID_ID3DXAnimationMixer,0x5eec992b,0x1046,0x44f6,0x92,0x4b,0xd1,0x75,0x96,0xb0,0x48,0x3e);
DEFINE_GUID(IID_ID3DXAnimationSet,0x54b569ac,0xaef,0x473e,0x97,0x4,0x3f,0xef,0x31,0x7f,0x64,0xab);
DEFINE_GUID(IID_ID3DXBaseMesh,0x2a835771,0xbf4d,0x43f4,0x8e,0x14,0x82,0xa8,0x9,0xf1,0x7d,0x8a);
DEFINE_GUID(IID_ID3DXBuffer,0x932e6a7e,0xc68e,0x45dd,0xa7,0xbf,0x53,0xd1,0x9c,0x86,0xdb,0x1f);
DEFINE_GUID(IID_ID3DXEffect,0x648b1ceb,0x8d4e,0x4d66,0xb6,0xfa,0xe4,0x49,0x69,0xe8,0x2e,0x89);
DEFINE_GUID(IID_ID3DXEffectCompiler,0xf8ee90d3,0xfcc6,0x4f14,0x8a,0xe8,0x63,0x74,0xae,0x96,0x8e,0x33);
DEFINE_GUID(IID_ID3DXEffectPool,0x53ca7768,0xc0d0,0x4664,0x8e,0x79,0xd1,0x56,0xe4,0xf5,0xb7,0xe0);
DEFINE_GUID(IID_ID3DXInterpolator,0xade2c06d,0x3747,0x4b9f,0xa5,0x14,0x34,0x40,0xb8,0x28,0x49,0x80);
DEFINE_GUID(IID_ID3DXKeyFrameInterpolator,0x6caa71f8,0x972,0x4cdb,0xa5,0x5b,0x43,0xb9,0x68,0x99,0x75,0x15);
DEFINE_GUID(IID_ID3DXMatrixStack,0xe3357330,0xcc5e,0x11d2,0xa4,0x34,0x0,0xa0,0xc9,0x6,0x29,0xa8);
DEFINE_GUID(IID_ID3DXMesh,0xccae5c3b,0x4dd1,0x4d0f,0x99,0x7e,0x46,0x84,0xca,0x64,0x55,0x7f);
DEFINE_GUID(IID_ID3DXPMesh,0x19fbe386,0xc282,0x4659,0x97,0xbd,0xcb,0x86,0x9b,0x8,0x4a,0x6c);
DEFINE_GUID(IID_ID3DXSkinMesh,0x8db06ecc,0xebfc,0x408a,0x94,0x4,0x30,0x74,0xb4,0x77,0x35,0x15);
DEFINE_GUID(IID_ID3DXSPMesh,0x4e3ca05c,0xd4ff,0x4d11,0x8a,0x2,0x16,0x45,0x9e,0x8,0xf6,0xf4);
DEFINE_GUID(IID_ID3DXTechnique,0xa00f378d,0xaf79,0x4917,0x90,0x7e,0x4d,0x63,0x5e,0xe6,0x38,0x44);
DEFINE_GUID(IID_IDirectDraw3, 0x618F8AD4,0x8b7A,0x11D0,0x8F,0xCC,0x00,0xC0,0x4F,0xd9,0x18,0x9D);
DEFINE_GUID(IID_IDirectMusicSong,0xa862b2ec,0x3676,0x4982,0x85,0xa,0x78,0x42,0x77,0x5e,0x1d,0x86);
DEFINE_GUID(IID_IDirectMusicSynth,0x09823661,0x5c85,0x11d2,0xaf,0xa6,0x00,0xaa,0x00,0x24,0xd8,0xb6);
DEFINE_GUID(IID_IDirectMusicSynth8,0x53cab625,0x2711,0x4c9f,0x9d,0xe7,0x1b,0x7f,0x92,0x5f,0x6f,0xc8);
DEFINE_GUID(IID_IDirectMusicSynthSink,0x09823663,0x5c85,0x11d2,0xaf,0xa6,0x00,0xaa,0x00,0x24,0xd8,0xb6);
DEFINE_GUID(IID_IKsFastClock,0xc9902485,0xc180,0x11d2,0x84,0x73,0xd4,0x23,0x94,0x45,0x9e,0x5e);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_PCM, 0x00000001, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_IEEE_FLOAT, 0x00000003, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);

/* Match ms dxsdk 2004 dec these guids exist in dxguid, tested by Magnus Olsen */
DEFINE_GUID(CLSID_DirectMusicAudioPathConfig,       0xEE0B9CA0, 0xA81E, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(CLSID_CDirect3DRM,                      0x4516EC41, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMAnimation,             0x4FA35698, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMAnimationSet,          0x4FA35699, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMClippedVisual,         0x5434E72D, 0x6D66, 0x11D1, 0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A);
DEFINE_GUID(CLSID_CDirect3DRMDevice,                0x4FA3568E, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMFace,                  0x4FA35693, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMFrame,                 0x4FA35690, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMFrameInterpolator,     0x0DE9EAA2, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMLight,                 0x4FA35694, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMLightInterpolator,     0x0DE9EAA6, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMMaterial,              0x4FA35697, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMMaterialInterpolator,  0x0DE9EAA7, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMMesh,                  0x4FA35691, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMMeshBuilder,           0x4FA35692, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMMeshInterpolator,      0x0DE9EAA3, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMProgressiveMesh,       0x4516EC40, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMShadow,                0x4FA3569B, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMTexture,               0x4FA35695, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMTextureInterpolator,   0x0DE9EAA8, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMUserVisual,            0x4FA3569A, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMViewport,              0x4FA3568F, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirect3DRMViewportInterpolator,  0x0DE9EAA1, 0x3B84, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_CDirect3DRMWrap,                  0x4FA35696, 0x623F, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(CLSID_CDirectXFile,                     0x4516EC43, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(CLSID_DirectDraw,                       0xD7B70EE0, 0x4340, 0x11CF, 0xB0, 0x63, 0x00, 0x20, 0xAF, 0xC2, 0xCD, 0x35);
DEFINE_GUID(CLSID_DirectDraw7,                      0x3C305196, 0x50DB, 0x11D3, 0x9C, 0xFE, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(CLSID_DirectDrawClipper,                0x593817A0, 0x7DB3, 0x11CF, 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(CLSID_DirectDrawFactory2,               0xB9DC4790, 0x4AF1, 0x11D1, 0x8C, 0x4C, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(CLSID_DirectInput,                      0x25E609E0, 0xB259, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(CLSID_DirectInput8,                     0x25E609E4, 0xB259, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(CLSID_DirectInputDevice,                0x25E609E1, 0xB259, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(CLSID_DirectInputDevice8,               0x25E609E5, 0xB259, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(CLSID_DirectMusic,                      0x636B9F10, 0x0C7D, 0x11D1, 0x95, 0xB2, 0x00, 0x20, 0xAF, 0xDC, 0x74, 0x21);
DEFINE_GUID(CLSID_DirectMusicAudioPath,             0xEE0B9CA0, 0xA81E, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(CLSID_DirectMusicBand,                  0x79BA9E00, 0xB6EE, 0x11D1, 0x86, 0xBE, 0x00, 0xC0, 0x4F, 0xBF, 0x8F, 0xEF);
DEFINE_GUID(CLSID_DirectMusicBandTrack,             0xD2AC2894, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicChordMap,              0xD2AC288F, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicChordMapTrack,         0xD2AC2896, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicChordTrack,            0xD2AC288B, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicCollection,            0x480FF4B0, 0x28B2, 0x11D1, 0xBE, 0xF7, 0x00, 0xC0, 0x4F, 0xBF, 0x8F, 0xEF);
DEFINE_GUID(CLSID_DirectMusicCommandTrack,          0xD2AC288C, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicComposer,              0xD2AC2890, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicContainer,             0x9301E380, 0x1F22, 0x11D3, 0x82, 0x26, 0xD2, 0xFA, 0x76, 0x25, 0x5D, 0x47);
DEFINE_GUID(CLSID_DirectMusicGraph,                 0xD2AC2884, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicLoader,                0xD2AC2892, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicLyricsTrack,           0x995C1CF5, 0x54FF, 0x11D3, 0x8B, 0xDA, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(CLSID_DirectMusicMarkerTrack,           0x55A8FD00, 0x4288, 0x11D3, 0x9B, 0xD1, 0x8A, 0x0D, 0x61, 0xC8, 0x88, 0x35);
DEFINE_GUID(CLSID_DirectMusicMotifTrack,            0xD2AC288E, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicMuteTrack,             0xD2AC2898, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicParamControlTrack,     0x4BE0537B, 0x5C19, 0x11D3, 0x8B, 0xDC, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(CLSID_DirectMusicPatternTrack,          0xD2AC2897, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicPerformance,           0xD2AC2881, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicScript,                0x810B5013, 0xE88D, 0x11D2, 0x8B, 0xC1, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(CLSID_DirectMusicScriptTrack,           0x4108FA85, 0x3586, 0x11D3, 0x8B, 0xD7, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(CLSID_DirectMusicSegment,               0xD2AC2882, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicSegmentState,          0xD2AC2883, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicSegmentTriggerTrack,   0xBAE4D665, 0x4EA1, 0x11D3, 0x8B, 0xDA, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(CLSID_DirectMusicSeqTrack,              0xD2AC2886, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicSignPostTrack,         0xF17E8672, 0xC3B4, 0x11D1, 0x87, 0x0B, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicStyle,                 0xD2AC288A, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicStyleTrack,            0xD2AC288D, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicSynth,                 0x58C2B4D0, 0x46E7, 0x11D1, 0x89, 0xAC, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(CLSID_DirectMusicSysExTrack,            0xD2AC2887, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicTempoTrack,            0xD2AC2885, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicTimeSigTrack,          0xD2AC2888, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(CLSID_DirectMusicWaveTrack,             0xEED36461, 0x9EA5, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(CLSID_DirectPlay,                       0xD1EB6D20, 0x8923, 0x11D0, 0x9D, 0x97, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB);
DEFINE_GUID(CLSID_DirectPlay8Address,               0x934A9523, 0xA3CA, 0x4BC5, 0xAD, 0xA0, 0xD6, 0xD9, 0x5D, 0x97, 0x94, 0x21);
DEFINE_GUID(CLSID_DirectPlay8Client,                0x743F1DC6, 0x5ABA, 0x429F, 0x8B, 0xDF, 0xC5, 0x4D, 0x03, 0x25, 0x3D, 0xC2);
DEFINE_GUID(CLSID_DirectPlay8LobbiedApplication,    0x667955AD, 0x6B3B, 0x43CA, 0xB9, 0x49, 0xBC, 0x69, 0xB5, 0xBA, 0xFF, 0x7F);
DEFINE_GUID(CLSID_DirectPlay8LobbyClient,           0x3B2B6775, 0x70B6, 0x45AF, 0x8D, 0xEA, 0xA2, 0x09, 0xC6, 0x95, 0x59, 0xF3);
DEFINE_GUID(CLSID_DirectPlay8NATResolver,           0xE4C1D9A2, 0xCBF7, 0x48BD, 0x9A, 0x69, 0x34, 0xA5, 0x5E, 0x0D, 0x89, 0x41);
DEFINE_GUID(CLSID_DirectPlay8Peer,                  0x286F484D, 0x375E, 0x4458, 0xA2, 0x72, 0xB1, 0x38, 0xE2, 0xF8, 0x0A, 0x6A);
DEFINE_GUID(CLSID_DirectPlay8Server,                0xDA825E1B, 0x6830, 0x43D7, 0x83, 0x5D, 0x0B, 0x5A, 0xD8, 0x29, 0x56, 0xA2);
DEFINE_GUID(CLSID_DirectPlay8ThreadPool,            0xFC47060E, 0x6153, 0x4B34, 0xB9, 0x75, 0x8E, 0x41, 0x21, 0xEB, 0x7F, 0x3C);
DEFINE_GUID(CLSID_DirectPlayLobby,                  0x2FE8F810, 0xB2A5, 0x11D0, 0xA7, 0x87, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(CLSID_DirectPlayVoiceClient,            0xB9F3EB85, 0xB781, 0x4AC1, 0x8D, 0x90, 0x93, 0xA0, 0x5E, 0xE3, 0x7D, 0x7D);
DEFINE_GUID(CLSID_DirectPlayVoiceServer,            0xD3F5B8E6, 0x9B78, 0x4A4C, 0x94, 0xEA, 0xCA, 0x23, 0x97, 0xB6, 0x63, 0xD3);
DEFINE_GUID(CLSID_DirectPlayVoiceTest,              0x0F0F094B, 0xB01C, 0x4091, 0xA1, 0x4D, 0xDD, 0x0C, 0xD8, 0x07, 0x71, 0x1A);
DEFINE_GUID(CLSID_DirectSound,                      0x47D4D946, 0x62E8, 0x11CF, 0x93, 0xBC, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(CLSID_DirectSound8,                     0x3901CC3F, 0x84B5, 0x4FA4, 0xBA, 0x35, 0xAA, 0x81, 0x72, 0xB8, 0xA0, 0x9B);
DEFINE_GUID(CLSID_DirectSoundCapture,               0xB0210780, 0x89CD, 0x11D0, 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16);
DEFINE_GUID(CLSID_DirectSoundCapture8,              0xE4BCAC13, 0x7F99, 0x4908, 0x9A, 0x8E, 0x74, 0xE3, 0xBF, 0x24, 0xB6, 0xE1);
DEFINE_GUID(CLSID_DirectSoundFullDuplex,            0xFEA4300C, 0x7959, 0x4147, 0xB2, 0x6A, 0x23, 0x77, 0xB9, 0xE7, 0xA9, 0x1D);
DEFINE_GUID(CLSID_DirectSoundWave,                  0x8A667154, 0xF9CB, 0x11D2, 0xAD, 0x8A, 0x00, 0x60, 0xB0, 0x57, 0x5A, 0xBC);
DEFINE_GUID(CLSID_DP8SP_BLUETOOTH,                  0x995513AF, 0x3027, 0x4B9A, 0x95, 0x6E, 0xC7, 0x72, 0xB3, 0xF7, 0x80, 0x06);
DEFINE_GUID(CLSID_DP8SP_IPX,                        0x53934290, 0x628D, 0x11D2, 0xAE, 0x0F, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(CLSID_DP8SP_MODEM,                      0x6D4A3650, 0x628D, 0x11D2, 0xAE, 0x0F, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(CLSID_DP8SP_SERIAL,                     0x743B5D60, 0x628D, 0x11D2, 0xAE, 0x0F, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(CLSID_DP8SP_TCPIP,                      0xEBFE7BA0, 0x628D, 0x11D2, 0xAE, 0x0F, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(DDVPTYPE_BROOKTREE,                     0x1352A560, 0xDA61, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_CCIR656,                       0xFCA326A0, 0xDA60, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_E_HREFH_VREFH,                 0x54F39980, 0xDA60, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_E_HREFH_VREFL,                 0x92783220, 0xDA60, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_E_HREFL_VREFH,                 0xA07A02E0, 0xDA60, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_E_HREFL_VREFL,                 0xE09C77E0, 0xDA60, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DDVPTYPE_PHILIPS,                       0x332CF160, 0xDA61, 0x11CF, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(DPLPROPERTY_LobbyGuid,                  0xF56920A0, 0xD218, 0x11D0, 0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67);
DEFINE_GUID(IID_IDirect3DSwapChain8,                0x928C088B, 0x76B9, 0x4C6B, 0xA5, 0x36, 0xA5, 0x90, 0x85, 0x38, 0x76, 0xCD);
DEFINE_GUID(DPAID_ComPort,                          0xF2F0CE00, 0xE0AF, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_INet,                             0xC4A54DA0, 0xE0AF, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_INetPort,                         0xE4524541, 0x8EA5, 0x11D1, 0x8A, 0x96, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(DPAID_INetW,                            0xE63232A0, 0x9DBF, 0x11D0, 0x9C, 0xC1, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_LobbyProvider,                    0x59B95640, 0x9667, 0x11D0, 0xA7, 0x7D, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(DPAID_Modem,                            0xF6DCC200, 0xA2FE, 0x11D0, 0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_ModemW,                           0x01FD92E0, 0xA2FF, 0x11D0, 0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_Phone,                            0x78EC89A0, 0xE0AF, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_PhoneW,                           0xBA5A7A70, 0x9DBF, 0x11D0, 0x9C, 0xC1, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_ServiceProvider,                  0x07D916C0, 0xE0AF, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPAID_TotalSize,                        0x1318F560, 0x912C, 0x11D0, 0x9D, 0xAA, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB);
DEFINE_GUID(DPLPROPERTY_MessagesSupported,          0x762CCDA1, 0xD916, 0x11D0, 0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67);
DEFINE_GUID(DPLPROPERTY_PlayerGuid,                 0xB4319322, 0xD20D, 0x11D0, 0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67);
DEFINE_GUID(DPLPROPERTY_PlayerScore,                0x48784000, 0xD219, 0x11D0, 0xBA, 0x39, 0x00, 0xC0, 0x4F, 0xD7, 0xED, 0x67);
DEFINE_GUID(DPSPGUID_IPX,                           0x685BC400, 0x9D2C, 0x11CF, 0xA9, 0xCD, 0x00, 0xAA, 0x00, 0x68, 0x86, 0xE3);
DEFINE_GUID(DPSPGUID_MODEM,                         0x44EAA760, 0xCB68, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPSPGUID_SERIAL,                        0x0F1D6860, 0x88D9, 0x11CF, 0x9C, 0x4E, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(DPSPGUID_TCPIP,                         0x36E95EE0, 0x8577, 0x11CF, 0x96, 0x0C, 0x00, 0x80, 0xC7, 0x53, 0x4E, 0x82);
DEFINE_GUID(DPVCTGUID_ADPCM,                        0x699B52C1, 0xA885, 0x46A8, 0xA3, 0x08, 0x97, 0x17, 0x24, 0x19, 0xAD, 0xC7);
DEFINE_GUID(DPVCTGUID_GSM,                          0x24768C60, 0x5A0D, 0x11D3, 0x9B, 0xE4, 0x52, 0x54, 0x00, 0xD9, 0x85, 0xE7);
DEFINE_GUID(DPVCTGUID_NONE,                         0x8DE12FD4, 0x7CB3, 0x48CE, 0xA7, 0xE8, 0x9C, 0x47, 0xA2, 0x2E, 0x8A, 0xC5);
DEFINE_GUID(DPVCTGUID_SC03,                         0x7D82A29B, 0x2242, 0x4F82, 0x8F, 0x39, 0x5D, 0x11, 0x53, 0xDF, 0x3E, 0x41);
DEFINE_GUID(DPVCTGUID_SC06,                         0x53DEF900, 0x7168, 0x4633, 0xB4, 0x7F, 0xD1, 0x43, 0x91, 0x6A, 0x13, 0xC7);
DEFINE_GUID(DPVCTGUID_TRUESPEECH,                   0xD7954361, 0x5A0B, 0x11D3, 0x9B, 0xE4, 0x52, 0x54, 0x00, 0xD9, 0x85, 0xE7);
DEFINE_GUID(DPVCTGUID_VR12,                         0xFE44A9FE, 0x8ED4, 0x48BF, 0x9D, 0x66, 0x1B, 0x1A, 0xDF, 0xF9, 0xFF, 0x6D);
DEFINE_GUID(DS3DALG_HRTF_FULL,                      0xC2413340, 0x1C1B, 0x11D2, 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA);
DEFINE_GUID(DS3DALG_HRTF_LIGHT,                     0xC2413342, 0x1C1B, 0x11D2, 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA);
DEFINE_GUID(DS3DALG_NO_VIRTUALIZATION,              0xC241333F, 0x1C1B, 0x11D2, 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA);
DEFINE_GUID(DSDEVID_DefaultCapture,                 0xDEF00001, 0x9C6D, 0x47ED, 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03);
DEFINE_GUID(DSDEVID_DefaultPlayback,                0xDEF00000, 0x9C6D, 0x47ED, 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03);
DEFINE_GUID(DSDEVID_DefaultVoiceCapture,            0xDEF00003, 0x9C6D, 0x47ED, 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03);
DEFINE_GUID(DSDEVID_DefaultVoicePlayback,           0xDEF00002, 0x9C6D, 0x47ED, 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03);
DEFINE_GUID(GUID_All_Objects,                       0xAA114DE5, 0xC262, 0x4169, 0xA1, 0xC8, 0x23, 0xD6, 0x98, 0xCC, 0x73, 0xB5);
DEFINE_GUID(GUID_BandParam,                         0x02BB1938, 0xCB8B, 0x11D2, 0x8B, 0xB9, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xB6);
DEFINE_GUID(GUID_Buffer_3D_Dry,                     0x186CC546, 0xDB29, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(GUID_Buffer_EnvReverb,                  0x186CC542, 0xDB29, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(GUID_Buffer_Mono,                       0x186CC547, 0xDB29, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(GUID_Buffer_Reverb,                     0x186CC541, 0xDB29, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(GUID_Buffer_Stereo,                     0x186CC545, 0xDB29, 0x11D3, 0x9B, 0xD1, 0x00, 0x80, 0xC7, 0x15, 0x0A, 0x74);
DEFINE_GUID(GUID_Button,                            0xA36D02F0, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_ChordParam,                        0xD2AC289E, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_Clear_All_Bands,                   0xD2AC28AB, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_ColorControlCallbacks,             0xEFD60CC2, 0x49E7, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(GUID_CommandParam,                      0xD2AC289D, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_CommandParam2,                     0x28F97EF7, 0x9538, 0x11D2, 0x97, 0xA9, 0x00, 0xC0, 0x4F, 0xA3, 0x6E, 0x58);
DEFINE_GUID(GUID_CommandParamNext,                  0x472AFE7A, 0x281B, 0x11D3, 0x81, 0x7D, 0x00, 0xC0, 0x4F, 0xA3, 0x6E, 0x58);
DEFINE_GUID(GUID_ConnectToDLSCollection,            0x1DB1AE6B, 0xE92E, 0x11D1, 0xA8, 0xC5, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0x6E);
DEFINE_GUID(GUID_ConstantForce,                     0x13541C20, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_CustomForce,                       0x13541C2B, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_D3DCallbacks2,                     0x0BA584E1, 0x70B6, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(GUID_D3DCallbacks3,                     0xDDF41230, 0xEC0A, 0x11D0, 0xA9, 0xB6, 0x00, 0xAA, 0x00, 0xC0, 0x99, 0x3E);
DEFINE_GUID(GUID_D3DExtendedCaps,                   0x7DE41F80, 0x9D93, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(GUID_D3DParseUnknownCommandCallback,    0x2E04FFA0, 0x98E4, 0x11D1, 0x8C, 0xE1, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(GUID_Damper,                            0x13541C28, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_DDMoreCaps,                        0x880BAF30, 0xB030, 0x11D0, 0x8E, 0xA7, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B);
DEFINE_GUID(GUID_DDMoreSurfaceCaps,                 0x3B8A0466, 0xF269, 0x11D1, 0x88, 0x0B, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(GUID_DDStereoMode,                      0xF828169C, 0xA8E8, 0x11D2, 0xA1, 0xF2, 0x00, 0xA0, 0xC9, 0x83, 0xEA, 0xF6);
DEFINE_GUID(GUID_DefaultGMCollection,               0xF17E8673, 0xC3B4, 0x11D1, 0x87, 0x0B, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DirectDrawPaletteStream,           0x730C7FFC, 0x5347, 0x11D1, 0x8C, 0x4D, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(GUID_DirectDrawSurfaceStream,           0xE043BC46, 0x5317, 0x11D1, 0x8C, 0x4D, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(GUID_DirectMusicAllTypes,               0xD2AC2893, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_Disable_Auto_Download,             0xD2AC28AA, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DisableTempo,                      0x45FC707D, 0x1DB4, 0x11D2, 0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_DisableTimeSig,                    0x45FC707B, 0x1DB4, 0x11D2, 0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_DMUS_PROP_DLS1,                    0x178F2F27, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_DLS2,                    0xF14599E5, 0x4689, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_Effects,                 0xCDA8D611, 0x684A, 0x11D2, 0x87, 0x1E, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DMUS_PROP_GM_Hardware,             0x178F2F24, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_GS_Capable,              0x6496ABA2, 0x61B0, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_GS_Hardware,             0x178F2F25, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_INSTRUMENT2,             0x865FD372, 0x9F67, 0x11D2, 0x87, 0x2A, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DMUS_PROP_LegacyCaps,              0xCFA7CDC2, 0x00A1, 0x11D2, 0xAA, 0xD5, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_MemorySize,              0x178F2F28, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_SampleMemorySize,        0x178F2F28, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_SamplePlaybackRate,      0x2A91F713, 0xA4BF, 0x11D2, 0xBB, 0xDF, 0x00, 0x60, 0x08, 0x33, 0xDB, 0xD8);
DEFINE_GUID(GUID_DMUS_PROP_SynthSink_DSOUND,        0x0AA97844, 0xC877, 0x11D1, 0x87, 0x0C, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DMUS_PROP_SynthSink_WAVE,          0x0AA97845, 0xC877, 0x11D1, 0x87, 0x0C, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DMUS_PROP_WavesReverb,             0x04CB5622, 0x32E5, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_Volume,                  0xFEDFAE25, 0xE46E, 0x11D1, 0xAA, 0xCE, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_DMUS_PROP_WriteLatency,            0x268A0FA0, 0x60F2, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_WritePeriod,             0x268A0FA1, 0x60F2, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_XG_Capable,              0x6496ABA1, 0x61B0, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(GUID_DMUS_PROP_XG_Hardware,             0x178F2F26, 0xC364, 0x11D1, 0xA7, 0x60, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(GUID_Download,                          0xD2AC28A7, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_DownloadToAudioPath,               0x9F2C0341, 0xC5C4, 0x11D3, 0x9B, 0xD1, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_DSCFX_CLASS_AEC,                   0xBF963D80, 0xC559, 0x11D0, 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1);
DEFINE_GUID(GUID_DSCFX_CLASS_NS,                    0xE07F903F, 0x62FD, 0x4E60, 0x8C, 0xDD, 0xDE, 0xA7, 0x23, 0x66, 0x65, 0xB5);
DEFINE_GUID(GUID_DSCFX_MS_AEC,                      0xCDEBB919, 0x379A, 0x488A, 0x87, 0x65, 0xF5, 0x3C, 0xFD, 0x36, 0xDE, 0x40);
DEFINE_GUID(GUID_DSCFX_MS_NS,                       0x11C5C73B, 0x66E9, 0x4BA1, 0xA0, 0xBA, 0xE8, 0x14, 0xC6, 0xEE, 0xD9, 0x2D);
DEFINE_GUID(GUID_DSCFX_SYSTEM_AEC,                  0x1C22C56D, 0x9879, 0x4F5B, 0xA3, 0x89, 0x27, 0x99, 0x6D, 0xDC, 0x28, 0x10);
DEFINE_GUID(GUID_DSCFX_SYSTEM_NS,                   0x5AB0882E, 0x7274, 0x4516, 0x87, 0x7D, 0x4E, 0xEE, 0x99, 0xBA, 0x4F, 0xD0);
DEFINE_GUID(GUID_DSFX_STANDARD_CHORUS,              0xEFE6629C, 0x81F7, 0x4281, 0xBD, 0x91, 0xC9, 0xD6, 0x04, 0xA9, 0x5A, 0xF6);
DEFINE_GUID(GUID_DSFX_STANDARD_COMPRESSOR,          0xEF011F79, 0x4000, 0x406D, 0x87, 0xAF, 0xBF, 0xFB, 0x3F, 0xC3, 0x9D, 0x57);
DEFINE_GUID(GUID_DSFX_STANDARD_DISTORTION,          0xEF114C90, 0xCD1D, 0x484E, 0x96, 0xE5, 0x09, 0xCF, 0xAF, 0x91, 0x2A, 0x21);
DEFINE_GUID(GUID_DSFX_STANDARD_ECHO,                0xEF3E932C, 0xD40B, 0x4F51, 0x8C, 0xCF, 0x3F, 0x98, 0xF1, 0xB2, 0x9D, 0x5D);
DEFINE_GUID(GUID_DSFX_STANDARD_FLANGER,             0xEFCA3D92, 0xDFD8, 0x4672, 0xA6, 0x03, 0x74, 0x20, 0x89, 0x4B, 0xAD, 0x98);
DEFINE_GUID(GUID_DSFX_STANDARD_GARGLE,              0xDAFD8210, 0x5711, 0x4B91, 0x9F, 0xE3, 0xF7, 0x5B, 0x7A, 0xE2, 0x79, 0xBF);
DEFINE_GUID(GUID_DSFX_STANDARD_I3DL2REVERB,         0xEF985E71, 0xD5C7, 0x42D4, 0xBA, 0x4D, 0x2D, 0x07, 0x3E, 0x2E, 0x96, 0xF4);
DEFINE_GUID(GUID_DSFX_STANDARD_PARAMEQ,             0x120CED89, 0x3BF4, 0x4173, 0xA1, 0x32, 0x3C, 0xB4, 0x06, 0xCF, 0x32, 0x31);
DEFINE_GUID(GUID_DSFX_WAVES_REVERB,                 0x87FC0268, 0x9A55, 0x4360, 0x95, 0xAA, 0x00, 0x4A, 0x1D, 0x9D, 0xE2, 0x6C);
DEFINE_GUID(GUID_Enable_Auto_Download,              0xD2AC28A9, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_EnableTempo,                       0x45FC707E, 0x1DB4, 0x11D2, 0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_EnableTimeSig,                     0x45FC707C, 0x1DB4, 0x11D2, 0xBC, 0xAC, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_Friction,                          0x13541C2A, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_HIDClass,                          0x745A17A0, 0x74D3, 0x11D0, 0xB6, 0xFE, 0x00, 0xA0, 0xC9, 0x0F, 0x57, 0xDA);
DEFINE_GUID(GUID_IDirectMusicBand,                  0xD2AC28AC, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_IDirectMusicChordMap,              0xD2AC28AD, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_IDirectMusicStyle,                 0xD2AC28A1, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_Inertia,                           0x13541C29, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_Joystick,                          0x6F1D2B70, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_KernelCallbacks,                   0x80863800, 0x6B06, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(GUID_KernelCaps,                        0xFFAA7540, 0x7AA8, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(GUID_Key,                               0x55728220, 0xD33C, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_KeyboardClass,                     0x4D36E96B, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);
DEFINE_GUID(GUID_MediaClass,                        0x4D36E96C, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);
DEFINE_GUID(GUID_Miscellaneous2Callbacks,           0x406B2F00, 0x3E5A, 0x11D1, 0xB6, 0x40, 0x00, 0xAA, 0x00, 0xA1, 0xF9, 0x6A);
DEFINE_GUID(GUID_MiscellaneousCallbacks,            0xEFD60CC0, 0x49E7, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(GUID_MotionCompCallbacks,               0xB1122B40, 0x5DA5, 0x11D1, 0x8F, 0xCF, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E);
DEFINE_GUID(GUID_MouseClass,                        0x4D36E96F, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);
DEFINE_GUID(GUID_MuteParam,                         0xD2AC28AF, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_NonLocalVidMemCaps,                0x86C4FA80, 0x8D84, 0x11D0, 0x94, 0xE8, 0x00, 0xC0, 0x4F, 0xC3, 0x41, 0x37);
DEFINE_GUID(GUID_NOTIFICATION_CHORD,                0xD2AC289B, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_NOTIFICATION_COMMAND,              0xD2AC289C, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_NOTIFICATION_MEASUREANDBEAT,       0xD2AC289A, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_NOTIFICATION_PERFORMANCE,          0x81F75BC5, 0x4E5D, 0x11D2, 0xBC, 0xC7, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_NOTIFICATION_RECOMPOSE,            0xD348372B, 0x945B, 0x45AE, 0xA5, 0x22, 0x45, 0x0F, 0x12, 0x5B, 0x84, 0xA5);
DEFINE_GUID(GUID_NOTIFICATION_SEGMENT,              0xD2AC2899, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_NTCallbacks,                       0x6FE9ECDE, 0xDF89, 0x11D1, 0x9D, 0xB0, 0x00, 0x60, 0x08, 0x27, 0x71, 0xBA);
DEFINE_GUID(GUID_OptSurfaceKmodeInfo,               0xE05C8472, 0x51D4, 0x11D1, 0x8C, 0xCE, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(GUID_OptSurfaceUmodeInfo,               0x9D792804, 0x5FA8, 0x11D1, 0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(GUID_PerfAutoDownload,                  0xFB09565B, 0x3631, 0x11D2, 0xBC, 0xB8, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(GUID_PerfMasterGrooveLevel,             0xD2AC28B2, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_PerfMasterTempo,                   0xD2AC28B0, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_PerfMasterVolume,                  0xD2AC28B1, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_Play_Marker,                       0xD8761A41, 0x801A, 0x11D3, 0x9B, 0xD1, 0xDA, 0xF7, 0xE1, 0xC3, 0xD8, 0x34);
DEFINE_GUID(GUID_POV,                               0xA36D02F2, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_RampForce,                         0x13541C21, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_RhythmParam,                       0xD2AC289F, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_RxAxis,                            0xA36D02F4, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_RyAxis,                            0xA36D02F5, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_RzAxis,                            0xA36D02E3, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SawtoothDown,                      0x13541C26, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_SawtoothUp,                        0x13541C25, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_SeedVariations,                    0x65B76FA5, 0xFF37, 0x11D2, 0x81, 0x4E, 0x00, 0xC0, 0x4F, 0xA3, 0x6E, 0x58);
DEFINE_GUID(GUID_Sine,                              0x13541C23, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_Slider,                            0xA36D02E4, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_Spring,                            0x13541C27, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_Square,                            0x13541C22, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_StandardMIDIFile,                  0x06621075, 0xE92E, 0x11D1, 0xA8, 0xC5, 0x00, 0xC0, 0x4F, 0xA3, 0x72, 0x6E);
DEFINE_GUID(GUID_Synth_Default,                     0x26BB9432, 0x45FE, 0x48D3, 0xA3, 0x75, 0x24, 0x72, 0xC5, 0xE3, 0xE7, 0x86);
DEFINE_GUID(GUID_SysKeyboard,                       0x6F1D2B61, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SysKeyboardEm,                     0x6F1D2B82, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SysKeyboardEm2,                    0x6F1D2B83, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SysMouse,                          0x6F1D2B60, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SysMouseEm,                        0x6F1D2B80, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_SysMouseEm2,                       0x6F1D2B81, 0xD5A0, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_TempoParam,                        0xD2AC28A5, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_TimeSignature,                     0xD2AC28A4, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_Triangle,                          0x13541C24, 0x8E33, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(GUID_Unknown,                           0xA36D02F3, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_Unload,                            0xD2AC28A8, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(GUID_UnloadFromAudioPath,               0x9F2C0342, 0xC5C4, 0x11D3, 0x9B, 0xD1, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_UserModeDriverInfo,                0xF0B0E8E2, 0x5F97, 0x11D1, 0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(GUID_UserModeDriverPassword,            0x97F861B6, 0x60A1, 0x11D1, 0x8C, 0xD0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(GUID_Valid_Start_Time,                  0x7F6B1760, 0x1FDB, 0x11D3, 0x82, 0x26, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_Variations,                        0x11F72CCE, 0x26E6, 0x4ECD, 0xAF, 0x2E, 0xD6, 0x68, 0xE6, 0x67, 0x07, 0xD8);
DEFINE_GUID(GUID_VideoPortCallbacks,                0xEFD60CC1, 0x49E7, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(GUID_VideoPortCaps,                     0xEFD60CC3, 0x49E7, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(GUID_XAxis,                             0xA36D02E0, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_YAxis,                             0xA36D02E1, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_ZAxis,                             0xA36D02E2, 0xC9F3, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(GUID_ZPixelFormats,                     0x93869880, 0x36CF, 0x11D1, 0x9B, 0x1B, 0x00, 0xAA, 0x00, 0xBB, 0xB8, 0xAE);
DEFINE_GUID(IID_HelperName,                         0xE4A36723, 0xFDFE, 0x4B22, 0xB1, 0x46, 0x3C, 0x04, 0xC0, 0x7F, 0x4C, 0xC8);
DEFINE_GUID(IID_IDDVideoPortContainer,              0x6C142760, 0xA733, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirect3D,                          0x3BBA0080, 0x2421, 0x11CF, 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirect3D2,                         0x6AAE1EC1, 0x662A, 0x11D0, 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A);
DEFINE_GUID(IID_IDirect3D3,                         0xBB223240, 0xE72B, 0x11D0, 0xA9, 0xB4, 0x00, 0xAA, 0x00, 0xC0, 0x99, 0x3E);
DEFINE_GUID(IID_IDirect3D7,                         0xF5049E77, 0x4861, 0x11D2, 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirect3D8,                         0x1DD9E8DA, 0x1C77, 0x4D40, 0xB0, 0xCF, 0x98, 0xFE, 0xFD, 0xFF, 0x95, 0x12);
DEFINE_GUID(IID_IDirect3D9,                         0x81BDCBCA, 0x64D4, 0x426D, 0xAE, 0x8D, 0xAD, 0x01, 0x47, 0xF4, 0x27, 0x5C);
DEFINE_GUID(IID_IDirect3DBaseTexture8,              0xB4211CFA, 0x51B9, 0x4A9F, 0xAB, 0x78, 0xDB, 0x99, 0xB2, 0xBB, 0x67, 0x8E);
DEFINE_GUID(IID_IDirect3DBaseTexture9,              0x580CA87E, 0x1D3C, 0x4D54, 0x99, 0x1D, 0xB7, 0xD3, 0xE3, 0xC2, 0x98, 0xCE);
DEFINE_GUID(IID_IDirect3DCubeTexture8,              0x3EE5B968, 0x2ACA, 0x4C34, 0x8B, 0xB5, 0x7E, 0x0C, 0x3D, 0x19, 0xB7, 0x50);
DEFINE_GUID(IID_IDirect3DCubeTexture9,              0xFFF32F81, 0xD953, 0x473A, 0x92, 0x23, 0x93, 0xD6, 0x52, 0xAB, 0xA9, 0x3F);
DEFINE_GUID(IID_IDirect3DDevice,                    0x64108800, 0x957D, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DDevice2,                   0x93281501, 0x8CF8, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DDevice3,                   0xB0AB3B60, 0x33D7, 0x11D1, 0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74);
DEFINE_GUID(IID_IDirect3DDevice7,                   0xF5049E79, 0x4861, 0x11D2, 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirect3DDevice8,                   0x7385E5DF, 0x8FE8, 0x41D5, 0x86, 0xB6, 0xD7, 0xB4, 0x85, 0x47, 0xB6, 0xCF);
DEFINE_GUID(IID_IDirect3DDevice9,                   0xD0223B96, 0xBF7A, 0x43FD, 0x92, 0xBD, 0xA4, 0x3B, 0x0D, 0x82, 0xB9, 0xEB);
DEFINE_GUID(IID_IDirect3DExecuteBuffer,             0x4417C145, 0x33AD, 0x11CF, 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E);
DEFINE_GUID(IID_IDirect3DHALDevice,                 0x84E63DE0, 0x46AA, 0x11CF, 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E);
DEFINE_GUID(IID_IDirect3DIndexBuffer8,              0x0E689C9A, 0x053D, 0x44A0, 0x9D, 0x92, 0xDB, 0x0E, 0x3D, 0x75, 0x0F, 0x86);
DEFINE_GUID(IID_IDirect3DIndexBuffer9,              0x7C9DD65E, 0xD3F7, 0x4529, 0xAC, 0xEE, 0x78, 0x58, 0x30, 0xAC, 0xDE, 0x35);
DEFINE_GUID(IID_IDirect3DLight,                     0x4417C142, 0x33AD, 0x11CF, 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E);
DEFINE_GUID(IID_IDirect3DMaterial,                  0x4417C144, 0x33AD, 0x11CF, 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E);
DEFINE_GUID(IID_IDirect3DMaterial2,                 0x93281503, 0x8CF8, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DMaterial3,                 0xCA9C46F4, 0xD3C5, 0x11D1, 0xB7, 0x5A, 0x00, 0x60, 0x08, 0x52, 0xB3, 0x12);
DEFINE_GUID(IID_IDirect3DMMXDevice,                 0x881949A1, 0xD6F3, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DNullDevice,                0x8767DF22, 0xBACC, 0x11D1, 0x89, 0x69, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirect3DPixelShader9,              0x0D3BDBDC, 0x5B02, 0x4415, 0xB8, 0x52, 0xCE, 0x5E, 0x8B, 0xCC, 0xB2, 0x89);
DEFINE_GUID(IID_IDirect3DQuery9,                    0xD9771460, 0xA695, 0x4F26, 0xBB, 0xD3, 0x27, 0xB8, 0x40, 0xB5, 0x41, 0xCC);
DEFINE_GUID(IID_IDirect3DRampDevice,                0xF2086B20, 0x259F, 0x11CF, 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirect3DRefDevice,                 0x50936643, 0x13E9, 0x11D1, 0x89, 0xAA, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DResource8,                 0x1B36BB7B, 0x09B7, 0x410A, 0xB4, 0x45, 0x7D, 0x14, 0x30, 0xD7, 0xB3, 0x3F);
DEFINE_GUID(IID_IDirect3DResource9,                 0x05EEC05D, 0x8F7D, 0x4362, 0xB9, 0x99, 0xD1, 0xBA, 0xF3, 0x57, 0xC7, 0x04);
DEFINE_GUID(IID_IDirect3DRGBDevice,                 0xA4665C60, 0x2673, 0x11CF, 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirect3DRM,                        0x2BC49361, 0x8327, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRM2,                       0x4516ECC8, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRM3,                       0x4516EC83, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMAnimation,               0xEB16CB0D, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMAnimation2,              0xFF6B7F77, 0xA40E, 0x11D1, 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66);
DEFINE_GUID(IID_IDirect3DRMAnimationArray,          0xD5F1CAE0, 0x4BD7, 0x11D1, 0xB9, 0x74, 0x00, 0x60, 0x08, 0x3E, 0x45, 0xF3);
DEFINE_GUID(IID_IDirect3DRMAnimationSet,            0xEB16CB0E, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMAnimationSet2,           0xFF6B7F79, 0xA40E, 0x11D1, 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66);
DEFINE_GUID(IID_IDirect3DRMClippedVisual,           0x5434E733, 0x6D66, 0x11D1, 0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A);
DEFINE_GUID(IID_IDirect3DRMDevice,                  0xE9E19280, 0x6E05, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMDevice2,                 0x4516EC78, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMDevice3,                 0x549F498B, 0xBFEB, 0x11D1, 0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82);
DEFINE_GUID(IID_IDirect3DRMDeviceArray,             0xEB16CB10, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMFace,                    0xEB16CB07, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMFace2,                   0x4516EC81, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMFaceArray,               0xEB16CB17, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMFrame,                   0xEB16CB03, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMFrame2,                  0xC3DFBD60, 0x3988, 0x11D0, 0x9E, 0xC2, 0x00, 0x00, 0xC0, 0x29, 0x1A, 0xC3);
DEFINE_GUID(IID_IDirect3DRMFrame3,                  0xFF6B7F70, 0xA40E, 0x11D1, 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66);
DEFINE_GUID(IID_IDirect3DRMFrameArray,              0xEB16CB12, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMInterpolator,            0x242F6BC1, 0x3849, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMLight,                   0xEB16CB08, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMLightArray,              0xEB16CB14, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMMaterial,                0xEB16CB0B, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMMaterial2,               0xFF6B7F75, 0xA40E, 0x11D1, 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66);
DEFINE_GUID(IID_IDirect3DRMMesh,                    0xA3A80D01, 0x6E12, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMMeshBuilder,             0xA3A80D02, 0x6E12, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMMeshBuilder2,            0x4516EC77, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMMeshBuilder3,            0x4516EC82, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMObject,                  0xEB16CB00, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMObject2,                 0x4516EC7C, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMObjectArray,             0x242F6BC2, 0x3849, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMPicked2Array,            0x4516EC7B, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMPickedArray,             0xEB16CB16, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMProgressiveMesh,         0x4516EC79, 0x8F20, 0x11D0, 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3);
DEFINE_GUID(IID_IDirect3DRMShadow,                  0xAF359780, 0x6BA3, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMShadow2,                 0x86B44E25, 0x9C82, 0x11D1, 0xBB, 0x0B, 0x00, 0xA0, 0xC9, 0x81, 0xA0, 0xA6);
DEFINE_GUID(IID_IDirect3DRMTexture,                 0xEB16CB09, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMTexture2,                0x120F30C0, 0x1629, 0x11D0, 0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B);
DEFINE_GUID(IID_IDirect3DRMTexture3,                0xFF6B7F73, 0xA40E, 0x11D1, 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66);
DEFINE_GUID(IID_IDirect3DRMUserVisual,              0x59163DE0, 0x6D43, 0x11CF, 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMViewport,                0xEB16CB02, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMViewport2,               0x4A1B1BE6, 0xBFED, 0x11D1, 0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82);
DEFINE_GUID(IID_IDirect3DRMViewportArray,           0xEB16CB11, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMWinDevice,               0xC5016CC0, 0xD273, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMVisual,                  0xEB16CB04, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMVisualArray,             0xEB16CB13, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DRMWrap,                    0xEB16CB0A, 0xD271, 0x11CE, 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1);
DEFINE_GUID(IID_IDirect3DStateBlock9,               0xB07C4FE5, 0x310D, 0x4BA8, 0xA2, 0x3C, 0x4F, 0x0F, 0x20, 0x6F, 0x21, 0x8B);
DEFINE_GUID(IID_IDirect3DSurface8,                  0xB96EEBCA, 0xB326, 0x4EA5, 0x88, 0x2F, 0x2F, 0xF5, 0xBA, 0xE0, 0x21, 0xDD);
DEFINE_GUID(IID_IDirect3DSurface9,                  0x0CFBAF3A, 0x9FF6, 0x429A, 0x99, 0xB3, 0xA2, 0x79, 0x6A, 0xF8, 0xB8, 0x9B);
DEFINE_GUID(IID_IDirect3DSwapChain9,                0x794950F2, 0xADFC, 0x458A, 0x90, 0x5E, 0x10, 0xA1, 0x0B, 0x0B, 0x50, 0x3B);
DEFINE_GUID(IID_IDirect3DTexture,                   0x2CDCD9E0, 0x25A0, 0x11CF, 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirect3DTexture2,                  0x93281502, 0x8CF8, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DTexture8,                  0xE4CDD575, 0x2866, 0x4F01, 0xB1, 0x2E, 0x7E, 0xEC, 0xE1, 0xEC, 0x93, 0x58);
DEFINE_GUID(IID_IDirect3DTexture9,                  0x85C31227, 0x3DE5, 0x4F00, 0x9B, 0x3A, 0xF1, 0x1A, 0xC3, 0x8C, 0x18, 0xB5);
DEFINE_GUID(IID_IDirect3DTnLHalDevice,              0xF5049E78, 0x4861, 0x11D2, 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirect3DVertexBuffer,              0x7A503555, 0x4A83, 0x11D1, 0xA5, 0xDB, 0x00, 0xA0, 0xC9, 0x03, 0x67, 0xF8);
DEFINE_GUID(IID_IDirect3DVertexBuffer7,             0xF5049E7D, 0x4861, 0x11D2, 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirect3DVertexBuffer8,             0x8AEEEAC7, 0x05F9, 0x44D4, 0xB5, 0x91, 0x00, 0x0B, 0x0D, 0xF1, 0xCB, 0x95);
DEFINE_GUID(IID_IDirect3DVertexBuffer9,             0xB64BB1B5, 0xFD70, 0x4DF6, 0xBF, 0x91, 0x19, 0xD0, 0xA1, 0x02, 0x55, 0xE3);
DEFINE_GUID(IID_IDirect3DVertexDeclaration9,        0xDD13C59C, 0x36FA, 0x4098, 0xA8, 0xFB, 0xC7, 0xED, 0x39, 0xDC, 0x85, 0x46);
DEFINE_GUID(IID_IDirect3DVertexShader9,             0xEFC5557E, 0x6265, 0x4613, 0x8A, 0x94, 0x43, 0x85, 0x78, 0x89, 0xEB, 0x36);
DEFINE_GUID(IID_IDirect3DViewport,                  0x4417C146, 0x33AD, 0x11CF, 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E);
DEFINE_GUID(IID_IDirect3DViewport2,                 0x93281500, 0x8CF8, 0x11D0, 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29);
DEFINE_GUID(IID_IDirect3DViewport3,                 0xB0AB3B61, 0x33D7, 0x11D1, 0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74);
DEFINE_GUID(IID_IDirect3DVolume8,                   0xBD7349F5, 0x14F1, 0x42E4, 0x9C, 0x79, 0x97, 0x23, 0x80, 0xDB, 0x40, 0xC0);
DEFINE_GUID(IID_IDirect3DVolume9,                   0x24F416E6, 0x1F67, 0x4AA7, 0xB8, 0x8E, 0xD3, 0x3F, 0x6F, 0x31, 0x28, 0xA1);
DEFINE_GUID(IID_IDirect3DVolumeTexture8,            0x4B8AAAFA, 0x140F, 0x42BA, 0x91, 0x31, 0x59, 0x7E, 0xAF, 0xAA, 0x2E, 0xAD);
DEFINE_GUID(IID_IDirect3DVolumeTexture9,            0x2518526C, 0xE789, 0x4111, 0xA7, 0xB9, 0x47, 0xEF, 0x32, 0x8D, 0x13, 0xE6);
DEFINE_GUID(IID_IDirectDraw,                        0x6C14DB80, 0xA733, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectDraw2,                       0xB3A6F3E0, 0x2B43, 0x11CF, 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirectDraw4,                       0x9C59509A, 0x39BD, 0x11D1, 0x8C, 0x4A, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(IID_IDirectDraw7,                       0x15E65EC0, 0x3B9C, 0x11D2, 0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B);
DEFINE_GUID(IID_IDirectDrawClipper,                 0x6C14DB85, 0xA733, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectDrawColorControl,            0x4B9F0EE0, 0x0D7E, 0x11D0, 0x9B, 0x06, 0x00, 0xA0, 0xC9, 0x03, 0xA3, 0xB8);
DEFINE_GUID(IID_IDirectDrawFactory2,                0x89B2C488, 0x4AF4, 0x11D1, 0x8C, 0x4C, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(IID_IDirectDrawGammaControl,            0x69C11C3E, 0xB46B, 0x11D1, 0xAD, 0x7A, 0x00, 0xC0, 0x4F, 0xC2, 0x9B, 0x4E);
DEFINE_GUID(IID_IDirectDrawOptSurface,              0x51191F1E, 0x4F2B, 0x11D1, 0x8C, 0xC3, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8);
DEFINE_GUID(IID_IDirectDrawPalette,                 0x6C14DB84, 0xA733, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectDrawPalette2,                0xC03C477E, 0x6519, 0x11D1, 0x8C, 0x52, 0x00, 0xC0, 0x4F, 0xD9, 0x30, 0xC5);
DEFINE_GUID(IID_IDirectDrawSurface,                 0x6C14DB81, 0xA733, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectDrawSurface2,                0x57805885, 0x6EEC, 0x11CF, 0x94, 0x41, 0xA8, 0x23, 0x03, 0xC1, 0x0E, 0x27);
DEFINE_GUID(IID_IDirectDrawSurface3,                0xDA044E00, 0x69B2, 0x11D0, 0xA1, 0xD5, 0x00, 0xAA, 0x00, 0xB8, 0xDF, 0xBB);
DEFINE_GUID(IID_IDirectDrawSurface4,                0x0B2B8630, 0xAD35, 0x11D0, 0x8E, 0xA6, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B);
DEFINE_GUID(IID_IDirectDrawSurface7,                0x06675A80, 0x3B9B, 0x11D2, 0xB9, 0x2F, 0x00, 0x60, 0x97, 0x97, 0xEA, 0x5B);
DEFINE_GUID(IID_IDirectDrawSurfaceNew,              0x1BAB8E96, 0x9CFE, 0x4CE3, 0xBC, 0x72, 0xD7, 0xE9, 0xE9, 0x9A, 0x21, 0x75);
DEFINE_GUID(IID_IDirectDrawVideoPort,               0xB36D93E0, 0x2B43, 0x11CF, 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56);
DEFINE_GUID(IID_IDirectDrawVideoPortNotify,         0xA655FB94, 0x0589, 0x4E57, 0xB3, 0x33, 0x56, 0x7A, 0x89, 0x46, 0x8C, 0x88);
DEFINE_GUID(IID_IDirectInput2A,                     0x5944E662, 0xAA8A, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInput2W,                     0x5944E663, 0xAA8A, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInput7A,                     0x9A4CB684, 0x236D, 0x11D3, 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE);
DEFINE_GUID(IID_IDirectInput7W,                     0x9A4CB685, 0x236D, 0x11D3, 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE);
DEFINE_GUID(IID_IDirectInput8A,                     0xBF798030, 0x483A, 0x4DA2, 0xAA, 0x99, 0x5D, 0x64, 0xED, 0x36, 0x97, 0x00);
DEFINE_GUID(IID_IDirectInput8W,                     0xBF798031, 0x483A, 0x4DA2, 0xAA, 0x99, 0x5D, 0x64, 0xED, 0x36, 0x97, 0x00);
DEFINE_GUID(IID_IDirectInputA,                      0x89521360, 0xAA8A, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputDevice2A,               0x5944E682, 0xC92E, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputDevice2W,               0x5944E683, 0xC92E, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputDevice7A,               0x57D7C6BC, 0x2356, 0x11D3, 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE);
DEFINE_GUID(IID_IDirectInputDevice7W,               0x57D7C6BD, 0x2356, 0x11D3, 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE);
DEFINE_GUID(IID_IDirectInputDevice8A,               0x54D41080, 0xDC15, 0x4833, 0xA4, 0x1B, 0x74, 0x8F, 0x73, 0xA3, 0x81, 0x79);
DEFINE_GUID(IID_IDirectInputDevice8W,               0x54D41081, 0xDC15, 0x4833, 0xA4, 0x1B, 0x74, 0x8F, 0x73, 0xA3, 0x81, 0x79);
DEFINE_GUID(IID_IDirectInputDeviceA,                0x5944E680, 0xC92E, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputDeviceW,                0x5944E681, 0xC92E, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputEffect,                 0xE7E1F7C0, 0x88D2, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(IID_IDirectInputEffectDriver,           0x02538130, 0x898F, 0x11D0, 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35);
DEFINE_GUID(IID_IDirectInputJoyConfig,              0x1DE12AB1, 0xC9F5, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectInputJoyConfig8,             0xEB0D7DFA, 0x1990, 0x4F27, 0xB4, 0xD6, 0xED, 0xF2, 0xEE, 0xC4, 0xA4, 0x4C);
DEFINE_GUID(IID_IDirectInputPIDDriver,              0xEEC6993A, 0xB3FD, 0x11D2, 0xA9, 0x16, 0x00, 0xC0, 0x4F, 0xB9, 0x86, 0x38);
DEFINE_GUID(IID_IDirectInputW,                      0x89521361, 0xAA8A, 0x11CF, 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDirectMusic,                       0x6536115A, 0x7B2D, 0x11D2, 0xBA, 0x18, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(IID_IDirectMusic2,                      0x6FC2CAE1, 0xBC78, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(IID_IDirectMusic8,                      0x2D3629F7, 0x813D, 0x4939, 0x85, 0x08, 0xF0, 0x5C, 0x6B, 0x75, 0xFD, 0x97);
DEFINE_GUID(IID_IDirectMusicAudioPath,              0xC87631F5, 0x23BE, 0x4986, 0x88, 0x36, 0x05, 0x83, 0x2F, 0xCC, 0x48, 0xF9);
DEFINE_GUID(IID_IDirectMusicBand,                   0xD2AC28C0, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicBuffer,                 0xD2AC2878, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicChordMap,               0xD2AC28BE, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicCollection,             0xD2AC287C, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicComposer,               0xD2AC28BF, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicContainer,              0x9301E386, 0x1F22, 0x11D3, 0x82, 0x26, 0xD2, 0xFA, 0x76, 0x25, 0x5D, 0x47);
DEFINE_GUID(IID_IDirectMusicDownload,               0xD2AC287B, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicDownloadedInstrument,   0xD2AC287E, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicGetLoader,              0x68A04844, 0xD13D, 0x11D1, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(IID_IDirectMusicGraph,                  0x2BEFC277, 0x5497, 0x11D2, 0xBC, 0xCB, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(IID_IDirectMusicInstrument,             0xD2AC287D, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicLoader,                 0x2FFAACA2, 0x5DCA, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(IID_IDirectMusicLoader8,                0x19E7C08C, 0x0A44, 0x4E6A, 0xA1, 0x16, 0x59, 0x5A, 0x7C, 0xD5, 0xDE, 0x8C);
DEFINE_GUID(IID_IDirectMusicObject,                 0xD2AC28B5, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicPatternTrack,           0x51C22E10, 0xB49F, 0x46FC, 0xBE, 0xC2, 0xE6, 0x28, 0x8F, 0xB9, 0xED, 0xE6);
DEFINE_GUID(IID_IDirectMusicPerformance,            0x07D43D03, 0x6523, 0x11D2, 0x87, 0x1D, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicPerformance2,           0x6FC2CAE0, 0xBC78, 0x11D2, 0xAF, 0xA6, 0x00, 0xAA, 0x00, 0x24, 0xD8, 0xB6);
DEFINE_GUID(IID_IDirectMusicPerformance8,           0x679C4137, 0xC62E, 0x4147, 0xB2, 0xB4, 0x9D, 0x56, 0x9A, 0xCB, 0x25, 0x4C);
DEFINE_GUID(IID_IDirectMusicPort,                   0x08F2D8C9, 0x37C2, 0x11D2, 0xB9, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(IID_IDirectMusicPortDownload,           0xD2AC287A, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicScript,                 0x2252373A, 0x5814, 0x489B, 0x82, 0x09, 0x31, 0xFE, 0xDE, 0xBA, 0xF1, 0x37);
DEFINE_GUID(IID_IDirectMusicSegment,                0xF96029A2, 0x4282, 0x11D2, 0x87, 0x17, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicSegment2,               0xD38894D1, 0xC052, 0x11D2, 0x87, 0x2F, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicSegment8,               0xC6784488, 0x41A3, 0x418F, 0xAA, 0x15, 0xB3, 0x50, 0x93, 0xBA, 0x42, 0xD4);
DEFINE_GUID(IID_IDirectMusicSegmentState,           0xA3AFDCC7, 0xD3EE, 0x11D1, 0xBC, 0x8D, 0x00, 0xA0, 0xC9, 0x22, 0xE6, 0xEB);
DEFINE_GUID(IID_IDirectMusicSegmentState8,          0xA50E4730, 0x0AE4, 0x48A7, 0x98, 0x39, 0xBC, 0x04, 0xBF, 0xE0, 0x77, 0x72);
DEFINE_GUID(IID_IDirectMusicStyle,                  0xD2AC28BD, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicStyle8,                 0xFD24AD8A, 0xA260, 0x453D, 0xBF, 0x50, 0x6F, 0x93, 0x84, 0xF7, 0x09, 0x85);
DEFINE_GUID(IID_IDirectMusicThru,                   0xCED153E7, 0x3606, 0x11D2, 0xB9, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0xAC, 0x12);
DEFINE_GUID(IID_IDirectMusicTool,                   0xD2AC28BA, 0xB39B, 0x11D1, 0x87, 0x04, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicTool8,                  0x0E674303, 0x3B05, 0x11D3, 0x9B, 0xD1, 0xF9, 0xE7, 0xF0, 0xA0, 0x15, 0x36);
DEFINE_GUID(IID_IDirectMusicTrack,                  0xF96029A1, 0x4282, 0x11D2, 0x87, 0x17, 0x00, 0x60, 0x08, 0x93, 0xB1, 0xBD);
DEFINE_GUID(IID_IDirectMusicTrack8,                 0x0E674304, 0x3B05, 0x11D3, 0x9B, 0xD1, 0xF9, 0xE7, 0xF0, 0xA0, 0x15, 0x36);
DEFINE_GUID(IID_IDirectPlay,                        0x5454E9A0, 0xDB65, 0x11CE, 0x92, 0x1C, 0x00, 0xAA, 0x00, 0x6C, 0x49, 0x72);
DEFINE_GUID(IID_IDirectPlay2,                       0x2B74F7C0, 0x9154, 0x11CF, 0xA9, 0xCD, 0x00, 0xAA, 0x00, 0x68, 0x86, 0xE3);
DEFINE_GUID(IID_IDirectPlay2A,                      0x9D460580, 0xA822, 0x11CF, 0x96, 0x0C, 0x00, 0x80, 0xC7, 0x53, 0x4E, 0x82);
DEFINE_GUID(IID_IDirectPlay3,                       0x133EFE40, 0x32DC, 0x11D0, 0x9C, 0xFB, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB);
DEFINE_GUID(IID_IDirectPlay3A,                      0x133EFE41, 0x32DC, 0x11D0, 0x9C, 0xFB, 0x00, 0xA0, 0xC9, 0x0A, 0x43, 0xCB);
DEFINE_GUID(IID_IDirectPlay4,                       0x0AB1C530, 0x4745, 0x11D1, 0xA7, 0xA1, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(IID_IDirectPlay4A,                      0x0AB1C531, 0x4745, 0x11D1, 0xA7, 0xA1, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(IID_IDirectPlay8Address,                0x83783300, 0x4063, 0x4C8A, 0x9D, 0xB3, 0x82, 0x83, 0x0A, 0x7F, 0xEB, 0x31);
DEFINE_GUID(IID_IDirectPlay8AddressIP,              0xE5A0E990, 0x2BAD, 0x430B, 0x87, 0xDA, 0xA1, 0x42, 0xCF, 0x75, 0xDE, 0x58);
DEFINE_GUID(IID_IDirectPlay8Client,                 0x5102DACD, 0x241B, 0x11D3, 0xAE, 0xA7, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(IID_IDirectPlay8LobbiedApplication,     0x819074A3, 0x016C, 0x11D3, 0xAE, 0x14, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(IID_IDirectPlay8LobbyClient,            0x819074A2, 0x016C, 0x11D3, 0xAE, 0x14, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(IID_IDirectPlay8NATResolver,            0xA9E213F2, 0x9A60, 0x486F, 0xBF, 0x3B, 0x53, 0x40, 0x8B, 0x6D, 0x1C, 0xBB);
DEFINE_GUID(IID_IDirectPlay8Peer,                   0x5102DACF, 0x241B, 0x11D3, 0xAE, 0xA7, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(IID_IDirectPlay8Server,                 0x5102DACE, 0x241B, 0x11D3, 0xAE, 0xA7, 0x00, 0x60, 0x97, 0xB0, 0x14, 0x11);
DEFINE_GUID(IID_IDirectPlay8ThreadPool,             0x0D22EE73, 0x4A46, 0x4A0D, 0x89, 0xB2, 0x04, 0x5B, 0x4D, 0x66, 0x64, 0x25);
DEFINE_GUID(IID_IDirectPlayLobby,                   0xAF465C71, 0x9588, 0x11CF, 0xA0, 0x20, 0x00, 0xAA, 0x00, 0x61, 0x57, 0xAC);
DEFINE_GUID(IID_IDirectPlayLobby2,                  0x0194C220, 0xA303, 0x11D0, 0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(IID_IDirectPlayLobby2A,                 0x1BB4AF80, 0xA303, 0x11D0, 0x9C, 0x4F, 0x00, 0xA0, 0xC9, 0x05, 0x42, 0x5E);
DEFINE_GUID(IID_IDirectPlayLobby3,                  0x2DB72490, 0x652C, 0x11D1, 0xA7, 0xA8, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(IID_IDirectPlayLobby3A,                 0x2DB72491, 0x652C, 0x11D1, 0xA7, 0xA8, 0x00, 0x00, 0xF8, 0x03, 0xAB, 0xFC);
DEFINE_GUID(IID_IDirectPlayLobbyA,                  0x26C66A70, 0xB367, 0x11CF, 0xA0, 0x24, 0x00, 0xAA, 0x00, 0x61, 0x57, 0xAC);
DEFINE_GUID(IID_IDirectPlayVoiceClient,             0x1DFDC8EA, 0xBCF7, 0x41D6, 0xB2, 0x95, 0xAB, 0x64, 0xB3, 0xB2, 0x33, 0x06);
DEFINE_GUID(IID_IDirectPlayVoiceServer,             0xFAA1C173, 0x0468, 0x43B6, 0x8A, 0x2A, 0xEA, 0x8A, 0x4F, 0x20, 0x76, 0xC9);
DEFINE_GUID(IID_IDirectPlayVoiceTest,               0xD26AF734, 0x208B, 0x41DA, 0x82, 0x24, 0xE0, 0xCE, 0x79, 0x81, 0x0B, 0xE1);
DEFINE_GUID(IID_IDirectSound,                       0x279AFA83, 0x4981, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectSound3DBuffer,               0x279AFA86, 0x4981, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectSound3DListener,             0x279AFA84, 0x4981, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectSound8,                      0xC50A7E93, 0xF395, 0x4834, 0x9E, 0xF6, 0x7F, 0xA9, 0x9D, 0xE5, 0x09, 0x66);
DEFINE_GUID(IID_IDirectSoundBuffer,                 0x279AFA85, 0x4981, 0x11CE, 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60);
DEFINE_GUID(IID_IDirectSoundBuffer8,                0x6825A449, 0x7524, 0x4D82, 0x92, 0x0F, 0x50, 0xE3, 0x6A, 0xB3, 0xAB, 0x1E);
DEFINE_GUID(IID_IDirectSoundCapture,                0xB0210781, 0x89CD, 0x11D0, 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16);
DEFINE_GUID(IID_IDirectSoundCaptureBuffer,          0xB0210782, 0x89CD, 0x11D0, 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16);
DEFINE_GUID(IID_IDirectSoundCaptureBuffer8,         0x00990DF4, 0x0DBB, 0x4872, 0x83, 0x3E, 0x6D, 0x30, 0x3E, 0x80, 0xAE, 0xB6);
DEFINE_GUID(IID_IDirectSoundCaptureFXAec,           0xAD74143D, 0x903D, 0x4AB7, 0x80, 0x66, 0x28, 0xD3, 0x63, 0x03, 0x6D, 0x65);
DEFINE_GUID(IID_IDirectSoundCaptureFXNoiseSuppress, 0xED311E41, 0xFBAE, 0x4175, 0x96, 0x25, 0xCD, 0x08, 0x54, 0xF6, 0x93, 0xCA);
DEFINE_GUID(IID_IDirectSoundFullDuplex,             0xEDCB4C7A, 0xDAAB, 0x4216, 0xA4, 0x2E, 0x6C, 0x50, 0x59, 0x6D, 0xDC, 0x1D);
DEFINE_GUID(IID_IDirectSoundFXChorus,               0x880842E3, 0x145F, 0x43E6, 0xA9, 0x34, 0xA7, 0x18, 0x06, 0xE5, 0x05, 0x47);
DEFINE_GUID(IID_IDirectSoundFXCompressor,           0x4BBD1154, 0x62F6, 0x4E2C, 0xA1, 0x5C, 0xD3, 0xB6, 0xC4, 0x17, 0xF7, 0xA0);
DEFINE_GUID(IID_IDirectSoundFXDistortion,           0x8ECF4326, 0x455F, 0x4D8B, 0xBD, 0xA9, 0x8D, 0x5D, 0x3E, 0x9E, 0x3E, 0x0B);
DEFINE_GUID(IID_IDirectSoundFXEcho,                 0x8BD28EDF, 0x50DB, 0x4E92, 0xA2, 0xBD, 0x44, 0x54, 0x88, 0xD1, 0xED, 0x42);
DEFINE_GUID(IID_IDirectSoundFXFlanger,              0x903E9878, 0x2C92, 0x4072, 0x9B, 0x2C, 0xEA, 0x68, 0xF5, 0x39, 0x67, 0x83);
DEFINE_GUID(IID_IDirectSoundFXGargle,               0xD616F352, 0xD622, 0x11CE, 0xAA, 0xC5, 0x00, 0x20, 0xAF, 0x0B, 0x99, 0xA3);
DEFINE_GUID(IID_IDirectSoundFXI3DL2Reverb,          0x4B166A6A, 0x0D66, 0x43F3, 0x80, 0xE3, 0xEE, 0x62, 0x80, 0xDE, 0xE1, 0xA4);
DEFINE_GUID(IID_IDirectSoundFXParamEq,              0xC03CA9FE, 0xFE90, 0x4204, 0x80, 0x78, 0x82, 0x33, 0x4C, 0xD1, 0x77, 0xDA);
DEFINE_GUID(IID_IDirectSoundFXWavesReverb,          0x46858C3A, 0x0DC6, 0x45E3, 0xB7, 0x60, 0xD4, 0xEE, 0xF1, 0x6C, 0xB3, 0x25);
DEFINE_GUID(IID_IDirectSoundNotify,                 0xB0210783, 0x89CD, 0x11D0, 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16);
DEFINE_GUID(IID_IDirectXFile,                       0x3D82AB40, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileBinary,                 0x3D82AB46, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileData,                   0x3D82AB44, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileDataReference,          0x3D82AB45, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileEnumObject,             0x3D82AB41, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileObject,                 0x3D82AB43, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IDirectXFileSaveObject,             0x3D82AB42, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(IID_IKsControl,                         0x28F54685, 0x06FD, 0x11D2, 0xB2, 0x7A, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96);
DEFINE_GUID(IID_IKsPropertySet,                     0x31EFAC30, 0x515C, 0x11D0, 0xA9, 0xAA, 0x00, 0xAA, 0x00, 0x61, 0xBE, 0x93);
DEFINE_GUID(IID_IReferenceClock,                    0x56A86897, 0x0AD4, 0x11CE, 0xB0, 0x3A, 0x00, 0x20, 0xAF, 0x0B, 0xA7, 0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DIRECTMUSIC,       0x1A82F8BC, 0x3F8B, 0x11D2, 0xB7, 0x74, 0x00, 0x60, 0x08, 0x33, 0x16, 0xC1);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MIDI,              0x1D262760, 0xE957, 0x11CF, 0xA5, 0xD6, 0x28, 0xDB, 0x04, 0xC1, 0x00, 0x00);
DEFINE_GUID(TID_D3DRMAnimation,                     0x3D82AB4F, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMAnimationKey,                  0x10DD46A8, 0x775B, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMAnimationOptions,              0xE2BF56C0, 0x840F, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMAnimationSet,                  0x3D82AB50, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMAppData,                       0xE5745280, 0xB24F, 0x11CF, 0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F);
DEFINE_GUID(TID_D3DRMBoolean,                       0x537DA6A0, 0xCA37, 0x11D0, 0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B);
DEFINE_GUID(TID_D3DRMBoolean2d,                     0x4885AE63, 0x78E8, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMCamera,                        0x3D82AB51, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMColorRGB,                      0xD3E16E81, 0x7835, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMColorRGBA,                     0x35FF44E0, 0x6C7C, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMCoords2d,                      0xF6F23F44, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMExternalVisual,                0x98116AA0, 0xBDBA, 0x11D1, 0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71);
DEFINE_GUID(TID_D3DRMFloatKeys,                     0x10DD46A9, 0x775B, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMFrame,                         0x3D82AB46, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMFramePosition,                 0xE2BF56C1, 0x840F, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMFrameRotation,                 0xE2BF56C3, 0x840F, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMFrameTransformMatrix,          0xF6F23F41, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMFrameVelocity,                 0xE2BF56C2, 0x840F, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMGuid,                          0xA42790E0, 0x7810, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMIndexedColor,                  0x1630B820, 0x7842, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMInfo,                          0x2B957100, 0x9E9A, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMInlineData,                    0x3A23EEA0, 0x94B1, 0x11D0, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMLight,                         0x3D82AB4A, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMLightAttenuation,              0xA8A98BA0, 0xC5E5, 0x11CF, 0xB9, 0x41, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B);
DEFINE_GUID(TID_D3DRMLightPenumbra,                 0xAED22741, 0xB31F, 0x11CF, 0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F);
DEFINE_GUID(TID_D3DRMLightRange,                    0xAED22742, 0xB31F, 0x11CF, 0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F);
DEFINE_GUID(TID_D3DRMLightUmbra,                    0xAED22740, 0xB31F, 0x11CF, 0x9D, 0xD5, 0x00, 0xAA, 0x00, 0xA7, 0x1A, 0x2F);
DEFINE_GUID(TID_D3DRMMaterial,                      0x3D82AB4D, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMMaterialAmbientColor,          0x01411840, 0x7786, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialArray,                 0x35FF44E1, 0x6C7C, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialDiffuseColor,          0x01411841, 0x7786, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialEmissiveColor,         0xD3E16E80, 0x7835, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialPower,                 0x01411843, 0x7786, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialSpecularColor,         0x01411842, 0x7786, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMaterialWrap,                  0x4885AE60, 0x78E8, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMatrix4x4,                     0xF6F23F45, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMesh,                          0x3D82AB44, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMMeshFace,                      0x3D82AB5F, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMMeshFaceWraps,                 0xED1EC5C0, 0xC0A8, 0x11D0, 0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B);
DEFINE_GUID(TID_D3DRMMeshMaterialList,              0xF6F23F42, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMeshNormals,                   0xF6F23F43, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMeshTextureCoords,             0xF6F23F40, 0x7686, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMMeshVertexColors,              0x1630B821, 0x7842, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMProgressiveMesh,               0x8A63C360, 0x997D, 0x11D0, 0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B);
DEFINE_GUID(TID_D3DRMPropertyBag,                   0x7F0F21E1, 0xBFE1, 0x11D1, 0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71);
DEFINE_GUID(TID_D3DRMRightHanded,                   0x7F5D5EA0, 0xD53A, 0x11D1, 0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71);
DEFINE_GUID(TID_D3DRMStringProperty,                0x7F0F21E0, 0xBFE1, 0x11D1, 0x82, 0xC0, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x71);
DEFINE_GUID(TID_D3DRMTextureFilename,               0xA42790E1, 0x7810, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMTextureReference,              0xA42790E2, 0x7810, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMTimedFloatKeys,                0xF406B180, 0x7B3B, 0x11CF, 0x8F, 0x52, 0x00, 0x40, 0x33, 0x35, 0x94, 0xA3);
DEFINE_GUID(TID_D3DRMUrl,                           0x3A23EEA1, 0x94B1, 0x11D0, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_D3DRMVector,                        0x3D82AB5E, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
DEFINE_GUID(TID_DXFILEHeader,                       0x3D82AB43, 0x62DA, 0x11CF, 0xAB, 0x39, 0x00, 0x20, 0xAF, 0x71, 0xE4, 0x33);
