/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomeTexture;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeEnvironment
extends HomeObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean observerCameraElevationAdjusted = true;
    private int groundColor;
    private HomeTexture groundTexture;
    private boolean backgroundImageVisibleOnGround3D;
    private int skyColor;
    private HomeTexture skyTexture;
    private int lightColor;
    private int ceilingLightColor;
    private float wallsAlpha;
    private DrawingMode drawingMode;
    private float subpartSizeUnderLight;
    private boolean allLevelsVisible;
    private int photoWidth;
    private int photoHeight;
    private transient AspectRatio photoAspectRatio;
    private String photoAspectRatioName;
    private int photoQuality;
    private int videoWidth;
    private transient AspectRatio videoAspectRatio;
    private String videoAspectRatioName;
    private int videoQuality;
    private float videoSpeed;
    private int videoFrameRate;
    private List<Camera> cameraPath;

    public HomeEnvironment() {
        this(HomeObject.createId("environment"));
    }

    public HomeEnvironment(String string) {
        this(string, 0xA8A8A8, null, 13427964, null, 0xD0D0D0, 0.0f);
    }

    public HomeEnvironment(int n, HomeTexture homeTexture, int n2, int n3, float f) {
        this(n, homeTexture, n2, null, n3, f);
    }

    public HomeEnvironment(int n, HomeTexture homeTexture, int n2, HomeTexture homeTexture2, int n3, float f) {
        this(HomeObject.createId("environment"), n, homeTexture, n2, homeTexture2, n3, f);
    }

    public HomeEnvironment(String string, int n, HomeTexture homeTexture, int n2, HomeTexture homeTexture2, int n3, float f) {
        super(string);
        this.groundColor = n;
        this.groundTexture = homeTexture;
        this.skyColor = n2;
        this.skyTexture = homeTexture2;
        this.lightColor = n3;
        this.ceilingLightColor = 0xD0D0D0;
        this.wallsAlpha = f;
        this.drawingMode = DrawingMode.FILL;
        this.photoWidth = 400;
        this.photoHeight = 300;
        this.photoAspectRatio = AspectRatio.VIEW_3D_RATIO;
        this.videoWidth = 320;
        this.videoAspectRatio = AspectRatio.RATIO_4_3;
        this.videoSpeed = 0.6666667f;
        this.videoFrameRate = 25;
        this.cameraPath = Collections.emptyList();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.ceilingLightColor = 0xD0D0D0;
        this.photoWidth = 400;
        this.photoHeight = 300;
        this.photoAspectRatio = AspectRatio.VIEW_3D_RATIO;
        this.videoWidth = 320;
        this.videoAspectRatio = AspectRatio.RATIO_4_3;
        this.videoSpeed = 0.6666667f;
        this.videoFrameRate = 25;
        this.cameraPath = Collections.emptyList();
        objectInputStream.defaultReadObject();
        try {
            if (this.photoAspectRatioName != null) {
                this.photoAspectRatio = AspectRatio.valueOf(this.photoAspectRatioName);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (this.videoAspectRatioName != null) {
                this.videoAspectRatio = AspectRatio.valueOf(this.videoAspectRatioName);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public boolean isObserverCameraElevationAdjusted() {
        return this.observerCameraElevationAdjusted;
    }

    public void setObserverCameraElevationAdjusted(boolean bl) {
        if (this.observerCameraElevationAdjusted != bl) {
            this.observerCameraElevationAdjusted = bl;
            this.firePropertyChange(Property.OBSERVER_CAMERA_ELEVATION_ADJUSTED.name(), !bl, bl);
        }
    }

    public int getGroundColor() {
        return this.groundColor;
    }

    public void setGroundColor(int n) {
        if (n != this.groundColor) {
            int n2 = this.groundColor;
            this.groundColor = n;
            this.firePropertyChange(Property.GROUND_COLOR.name(), n2, n);
        }
    }

    public HomeTexture getGroundTexture() {
        return this.groundTexture;
    }

    public void setGroundTexture(HomeTexture homeTexture) {
        if (homeTexture != this.groundTexture) {
            HomeTexture homeTexture2 = this.groundTexture;
            this.groundTexture = homeTexture;
            this.firePropertyChange(Property.GROUND_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public boolean isBackgroundImageVisibleOnGround3D() {
        return this.backgroundImageVisibleOnGround3D;
    }

    public void setBackgroundImageVisibleOnGround3D(boolean bl) {
        if (this.backgroundImageVisibleOnGround3D != bl) {
            this.backgroundImageVisibleOnGround3D = bl;
            this.firePropertyChange(Property.BACKGROUND_IMAGE_VISIBLE_ON_GROUND_3D.name(), !bl, bl);
        }
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public void setSkyColor(int n) {
        if (n != this.skyColor) {
            int n2 = this.skyColor;
            this.skyColor = n;
            this.firePropertyChange(Property.SKY_COLOR.name(), n2, n);
        }
    }

    public HomeTexture getSkyTexture() {
        return this.skyTexture;
    }

    public void setSkyTexture(HomeTexture homeTexture) {
        if (homeTexture != this.skyTexture) {
            HomeTexture homeTexture2 = this.skyTexture;
            this.skyTexture = homeTexture;
            this.firePropertyChange(Property.SKY_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(int n) {
        if (n != this.lightColor) {
            int n2 = this.lightColor;
            this.lightColor = n;
            this.firePropertyChange(Property.LIGHT_COLOR.name(), n2, n);
        }
    }

    public int getCeillingLightColor() {
        return this.ceilingLightColor;
    }

    public void setCeillingLightColor(int n) {
        if (n != this.ceilingLightColor) {
            int n2 = this.ceilingLightColor;
            this.ceilingLightColor = n;
            this.firePropertyChange(Property.CEILING_LIGHT_COLOR.name(), n2, n);
        }
    }

    public float getWallsAlpha() {
        return this.wallsAlpha;
    }

    public void setWallsAlpha(float f) {
        if (f != this.wallsAlpha) {
            float f2 = this.wallsAlpha;
            this.wallsAlpha = f;
            this.firePropertyChange(Property.WALLS_ALPHA.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    public void setDrawingMode(DrawingMode drawingMode) {
        if (drawingMode != this.drawingMode) {
            DrawingMode drawingMode2 = this.drawingMode;
            this.drawingMode = drawingMode;
            this.firePropertyChange(Property.DRAWING_MODE.name(), (Object)drawingMode2, (Object)drawingMode);
        }
    }

    public float getSubpartSizeUnderLight() {
        return this.subpartSizeUnderLight;
    }

    public void setSubpartSizeUnderLight(float f) {
        if (f != this.subpartSizeUnderLight) {
            float f2 = this.subpartSizeUnderLight;
            this.subpartSizeUnderLight = f;
            this.firePropertyChange(Property.SUBPART_SIZE_UNDER_LIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isAllLevelsVisible() {
        return this.allLevelsVisible;
    }

    public void setAllLevelsVisible(boolean bl) {
        if (bl != this.allLevelsVisible) {
            this.allLevelsVisible = bl;
            this.firePropertyChange(Property.ALL_LEVELS_VISIBLE.name(), !bl, bl);
        }
    }

    public int getPhotoWidth() {
        return this.photoWidth;
    }

    public void setPhotoWidth(int n) {
        if (this.photoWidth != n) {
            int n2 = this.photoWidth;
            this.photoWidth = n;
            this.firePropertyChange(Property.PHOTO_WIDTH.name(), n2, n);
        }
    }

    public int getPhotoHeight() {
        return this.photoHeight;
    }

    public void setPhotoHeight(int n) {
        if (this.photoHeight != n) {
            int n2 = this.photoHeight;
            this.photoHeight = n;
            this.firePropertyChange(Property.PHOTO_HEIGHT.name(), n2, n);
        }
    }

    public AspectRatio getPhotoAspectRatio() {
        return this.photoAspectRatio;
    }

    public void setPhotoAspectRatio(AspectRatio aspectRatio) {
        if (this.photoAspectRatio != aspectRatio) {
            AspectRatio aspectRatio2 = this.photoAspectRatio;
            this.photoAspectRatio = aspectRatio;
            this.photoAspectRatioName = this.photoAspectRatio.name();
            this.firePropertyChange(Property.PHOTO_ASPECT_RATIO.name(), (Object)aspectRatio2, (Object)aspectRatio);
        }
    }

    public int getPhotoQuality() {
        return this.photoQuality;
    }

    public void setPhotoQuality(int n) {
        if (this.photoQuality != n) {
            int n2 = this.photoQuality;
            this.photoQuality = n;
            this.firePropertyChange(Property.PHOTO_QUALITY.name(), n2, n);
        }
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public void setVideoWidth(int n) {
        if (this.videoWidth != n) {
            int n2 = this.videoWidth;
            this.videoWidth = n;
            this.firePropertyChange(Property.VIDEO_WIDTH.name(), n2, n);
        }
    }

    public int getVideoHeight() {
        return Math.round((float)this.getVideoWidth() / this.getVideoAspectRatio().getValue().floatValue());
    }

    public AspectRatio getVideoAspectRatio() {
        return this.videoAspectRatio;
    }

    public void setVideoAspectRatio(AspectRatio aspectRatio) {
        if (this.videoAspectRatio != aspectRatio) {
            if (aspectRatio.getValue() == null) {
                throw new IllegalArgumentException("Unsupported aspect ratio " + (Object)((Object)aspectRatio));
            }
            AspectRatio aspectRatio2 = this.videoAspectRatio;
            this.videoAspectRatio = aspectRatio;
            this.videoAspectRatioName = this.videoAspectRatio.name();
            this.firePropertyChange(Property.VIDEO_ASPECT_RATIO.name(), (Object)aspectRatio2, (Object)aspectRatio);
        }
    }

    public int getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(int n) {
        if (this.videoQuality != n) {
            int n2 = this.videoQuality;
            this.videoQuality = n;
            this.firePropertyChange(Property.VIDEO_QUALITY.name(), n2, n);
        }
    }

    public float getVideoSpeed() {
        return this.videoSpeed;
    }

    public void setVideoSpeed(float f) {
        if (this.videoSpeed != f) {
            float f2 = this.videoSpeed;
            this.videoSpeed = f;
            this.firePropertyChange(Property.VIDEO_SPEED.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public int getVideoFrameRate() {
        return this.videoFrameRate;
    }

    public void setVideoFrameRate(int n) {
        if (this.videoFrameRate != n) {
            int n2 = this.videoFrameRate;
            this.videoFrameRate = n;
            this.firePropertyChange(Property.VIDEO_FRAME_RATE.name(), n2, n);
        }
    }

    public List<Camera> getVideoCameraPath() {
        return Collections.unmodifiableList(this.cameraPath);
    }

    public void setVideoCameraPath(List<Camera> list) {
        if (this.cameraPath != list) {
            List<Camera> list2 = this.cameraPath;
            this.cameraPath = list != null ? new ArrayList<Camera>(list) : Collections.emptyList();
            this.firePropertyChange(Property.VIDEO_CAMERA_PATH.name(), list2, list);
        }
    }

    @Override
    public HomeEnvironment clone() {
        HomeEnvironment homeEnvironment = (HomeEnvironment)super.clone();
        homeEnvironment.cameraPath = new ArrayList<Camera>(this.cameraPath.size());
        for (Camera camera : this.cameraPath) {
            homeEnvironment.cameraPath.add(camera.clone());
        }
        return homeEnvironment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DrawingMode {
        FILL,
        OUTLINE,
        FILL_AND_OUTLINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        OBSERVER_CAMERA_ELEVATION_ADJUSTED,
        GROUND_COLOR,
        GROUND_TEXTURE,
        BACKGROUND_IMAGE_VISIBLE_ON_GROUND_3D,
        SKY_COLOR,
        SKY_TEXTURE,
        LIGHT_COLOR,
        CEILING_LIGHT_COLOR,
        WALLS_ALPHA,
        DRAWING_MODE,
        SUBPART_SIZE_UNDER_LIGHT,
        ALL_LEVELS_VISIBLE,
        PHOTO_WIDTH,
        PHOTO_HEIGHT,
        PHOTO_ASPECT_RATIO,
        PHOTO_QUALITY,
        VIDEO_WIDTH,
        VIDEO_ASPECT_RATIO,
        VIDEO_QUALITY,
        VIDEO_SPEED,
        VIDEO_FRAME_RATE,
        VIDEO_CAMERA_PATH;

    }
}

