/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class HomeLight
extends HomePieceOfFurniture
implements Light {
    private static final long serialVersionUID = 1L;
    private LightSource[] lightSources;
    private String[] lightSourceMaterialNames;
    private float power;

    public HomeLight(Light light) {
        this(light, EMPTY_PROPERTY_ARRAY);
    }

    public HomeLight(Light light, String[] stringArray) {
        this(HomeLight.createId("light"), light, stringArray);
    }

    public HomeLight(String string, Light light) {
        this(string, light, EMPTY_PROPERTY_ARRAY);
    }

    public HomeLight(String string, Light light, String[] stringArray) {
        super(string, light, stringArray);
        this.lightSources = light.getLightSources();
        this.lightSourceMaterialNames = light.getLightSourceMaterialNames();
        this.power = 0.5f;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.lightSourceMaterialNames = new String[0];
        objectInputStream.defaultReadObject();
    }

    public LightSource[] getLightSources() {
        if (this.lightSources.length == 0) {
            return this.lightSources;
        }
        return (LightSource[])this.lightSources.clone();
    }

    public void setLightSources(LightSource[] lightSourceArray) {
        if (!Arrays.equals(lightSourceArray, this.lightSources)) {
            LightSource[] lightSourceArray2 = this.lightSources.length == 0 ? this.lightSources : (LightSource[])this.lightSources.clone();
            this.lightSources = lightSourceArray.length == 0 ? lightSourceArray : (LightSource[])lightSourceArray.clone();
            this.firePropertyChange(Property.LIGHT_SOURCES.name(), lightSourceArray2, lightSourceArray);
        }
    }

    public String[] getLightSourceMaterialNames() {
        if (this.lightSourceMaterialNames.length == 0) {
            return this.lightSourceMaterialNames;
        }
        return (String[])this.lightSourceMaterialNames.clone();
    }

    public void setLightSourceMaterialNames(String[] stringArray) {
        if (!Arrays.equals(stringArray, this.lightSourceMaterialNames)) {
            String[] stringArray2 = this.lightSourceMaterialNames.length == 0 ? this.lightSourceMaterialNames : (String[])this.lightSourceMaterialNames.clone();
            this.lightSourceMaterialNames = stringArray.length == 0 ? stringArray : (String[])stringArray.clone();
            this.firePropertyChange(Property.LIGHT_SOURCE_MATERIAL_NAMES.name(), stringArray2, stringArray);
        }
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        if (f != this.power) {
            float f2 = this.power;
            this.power = f;
            this.firePropertyChange(Property.POWER.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public HomeLight clone() {
        return (HomeLight)super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        POWER,
        LIGHT_SOURCES,
        LIGHT_SOURCE_MATERIAL_NAMES;

    }
}

