/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ObjectProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayedName;
    private transient Type type;
    private final String typeName;
    private final boolean displayable;
    private final boolean modifiable;
    private final boolean exportable;

    public ObjectProperty(String string) {
        this(string, null);
    }

    public ObjectProperty(String string, Type type) {
        this(string, null, type, true, true, true);
    }

    public ObjectProperty(String string, Type type, boolean bl, boolean bl2, boolean bl3) {
        this(string, null, type, true, true, true);
    }

    public ObjectProperty(String string, String string2, Type type, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.displayedName = string2;
        this.type = type;
        this.typeName = type != null ? type.name() : null;
        this.displayable = bl;
        this.modifiable = bl2;
        this.exportable = bl3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.type = null;
        objectInputStream.defaultReadObject();
        try {
            if (this.typeName != null) {
                this.type = Type.valueOf(this.typeName);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static ObjectProperty fromDescription(String string) {
        String[] stringArray;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Description empty");
        }
        int n = string.indexOf(58);
        String string2 = string.substring(0, n > 0 ? n : string.length()).trim();
        Type type = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string3 = null;
        if (n > 0 && (stringArray = string.substring(n + 1).trim().split(" ")).length > 0) {
            type = Type.valueOf(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("displayable=")) {
                    bl = "true".equalsIgnoreCase(stringArray[i].substring("displayable=".length() + 1));
                    continue;
                }
                if (stringArray[i].startsWith("modifiable=")) {
                    bl2 = "true".equalsIgnoreCase(stringArray[i].substring("modifiable=".length() + 1));
                    continue;
                }
                if (stringArray[i].startsWith("exportable=")) {
                    bl3 = "true".equalsIgnoreCase(stringArray[i].substring("exportable=".length() + 1));
                    continue;
                }
                if (!stringArray[i].startsWith("displayedName=")) continue;
                string3 = string.substring(string.indexOf("displayedName=") + "displayedName=".length());
            }
        }
        return new ObjectProperty(string2, string3, type, bl, bl2, bl3);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public String getDisplayedName() {
        if (this.displayedName != null) {
            return this.displayedName;
        }
        String string = this.name.replace('_', ' ').toLowerCase();
        return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ObjectProperty) {
            return this.name.equals(((ObjectProperty)object).name);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ANY,
        STRING,
        BOOLEAN,
        INTEGER,
        NUMBER,
        PRICE,
        LENGTH,
        PERCENTAGE,
        DATE,
        CONTENT;

    }
}

