/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogItem;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class CatalogItemToolTip
extends JToolTip {
    private static final int ICON_SIZE = Math.round(128.0f * SwingTools.getResolutionScale());
    private final DisplayedInformation displayedInformation;
    private final UserPreferences preferences;
    private final JLabel itemIconLabel;
    private CatalogItem catalogItem;

    public CatalogItemToolTip(boolean bl, UserPreferences userPreferences) {
        this(bl ? DisplayedInformation.ICON_NAME_AUTHOR : DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY, userPreferences);
    }

    public CatalogItemToolTip(DisplayedInformation displayedInformation, UserPreferences userPreferences) {
        this.displayedInformation = displayedInformation;
        this.preferences = userPreferences;
        this.itemIconLabel = new JLabel();
        this.itemIconLabel.setPreferredSize(new Dimension(ICON_SIZE, ICON_SIZE));
        this.itemIconLabel.setMinimumSize(this.itemIconLabel.getPreferredSize());
        this.itemIconLabel.setHorizontalAlignment(0);
        this.itemIconLabel.setVerticalAlignment(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.itemIconLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalogItem(CatalogItem catalogItem) {
        if (catalogItem != this.catalogItem) {
            Iterator<ImageReader> iterator;
            Object object;
            String string;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (this.preferences != null) {
                string = catalogItem.getCreator();
                if (string != null && string.length() > 0) {
                    string2 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipCreator", string);
                }
                Format format = this.preferences.getLengthUnit().getFormatWithUnit();
                if (catalogItem instanceof CatalogPieceOfFurniture) {
                    object = (CatalogPieceOfFurniture)catalogItem;
                    string4 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipPieceOfFurnitureDimensions", format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getWidth())), format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getDepth())), format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getHeight())));
                    if (((CatalogPieceOfFurniture)object).getModelSize() != null && ((CatalogPieceOfFurniture)object).getModelSize() > 0L) {
                        string3 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipModelSize", NumberFormat.getIntegerInstance().format(Math.max(1, (int)Math.round((double)((CatalogPieceOfFurniture)object).getModelSize().longValue() / 1000.0))));
                    }
                    if ((string5 = ((CatalogPieceOfFurniture)object).getDescription()) != null) {
                        if (Boolean.getBoolean("com.eteks.sweethome3d.descriptionIgnoredInCatalogToolTip")) {
                            string5 = null;
                        } else {
                            int n = string5.length();
                            int n2 = Math.max(string4.length(), ((CatalogPieceOfFurniture)object).getName() != null ? ((CatalogPieceOfFurniture)object).getName().length() : 0);
                            if (n > 200 || string5.indexOf(32) < 0 && n > n2 || string5.indexOf(32) >= n2) {
                                string5 = string5.substring(0, n > 200 ? 200 : n2) + "...";
                            }
                            if (string5.indexOf("<br>") < 0 && n > n2) {
                                String[] stringArray = string5.split(" ");
                                string5 = "";
                                int n3 = 0;
                                while (n3 < stringArray.length) {
                                    iterator = stringArray[n3++];
                                    while (n3 < stringArray.length && ((String)((Object)iterator)).length() < n2) {
                                        iterator = (String)((Object)iterator) + " " + stringArray[n3++];
                                    }
                                    if (string5.length() > 0) {
                                        string5 = string5 + "<br>";
                                    }
                                    string5 = string5 + (String)((Object)iterator);
                                }
                            }
                        }
                    }
                } else if (catalogItem instanceof CatalogTexture) {
                    object = (CatalogTexture)catalogItem;
                    string4 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipTextureDimensions", format.format(Float.valueOf(((CatalogTexture)object).getWidth())), format.format(Float.valueOf(((CatalogTexture)object).getHeight())));
                }
            }
            boolean bl = false;
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = "<html><center>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string5 != null) {
                        string = string + "<br>" + string5 + "</table>";
                    }
                    if (string4 != null) {
                        string = string + "<br>" + string4;
                    }
                    if (string3 != null) {
                        string = string + "<br>" + string3;
                    }
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</center>";
                } else {
                    string = "";
                }
            } else if (this.isTipTextComplete()) {
                bl = true;
                string = "<html><table>";
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = string + "<tr><td align='center'>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string5 != null) {
                        string = string + "<br>" + string5;
                    }
                    if (string4 != null) {
                        string = string + "<br>" + string4;
                    }
                    if (string3 != null) {
                        string = string + "<br>" + string3;
                    }
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</td></tr>";
                }
            } else if (this.displayedInformation != DisplayedInformation.ICON) {
                string = catalogItem.getName();
                if (string2 != null) {
                    string = string + " " + string2;
                }
            } else {
                string = null;
            }
            this.itemIconLabel.setIcon(null);
            if (catalogItem.getIcon() instanceof URLContent) {
                object = null;
                try {
                    int n;
                    object = new BufferedInputStream(catalogItem.getIcon().openStream());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray2));
                    iterator = ImageIO.getImageReaders(imageInputStream);
                    if (iterator.hasNext()) {
                        ImageReader imageReader = iterator.next();
                        imageReader.setInput(imageInputStream);
                        int n4 = imageReader.getWidth(imageReader.getMinIndex());
                        int n5 = imageReader.getHeight(imageReader.getMinIndex());
                        int n6 = Math.round((float)ICON_SIZE * Math.min(1.0f, (float)n4 / (float)n5));
                        int n7 = Math.round((float)n6 * (float)n5 / (float)n4);
                        if (bl) {
                            string = string + "<tr><td width='" + ICON_SIZE + "' height='" + ICON_SIZE + "' align='center' valign='middle'><img width='" + n6 + "' height='" + n7 + "' src='" + ((URLContent)catalogItem.getIcon()).getURL() + "'></td></tr>";
                        } else {
                            ImageIcon imageIcon = new ImageIcon(byArray2);
                            if (n5 != n7) {
                                imageIcon.setImage(imageIcon.getImage().getScaledInstance(n6, n7, imageReader.getNumImages(true) > 1 ? 1 : 4));
                            }
                            this.itemIconLabel.setIcon(imageIcon);
                        }
                        imageReader.dispose();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (bl) {
                string = string + "</table>";
            }
            this.setTipText(string);
            this.catalogItem = catalogItem;
        }
    }

    public boolean isTipTextComplete() {
        return !OperatingSystem.isJavaVersionGreaterOrEqual("1.6") && OperatingSystem.isMacOSX();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.itemIconLabel.getIcon() != null) {
            if (OperatingSystem.isWindows() && OperatingSystem.isJavaVersionBetween("10", "16")) {
                dimension.width += 8;
            }
            dimension.width = Math.max(dimension.width, ICON_SIZE + Math.round(8.0f * SwingTools.getResolutionScale()));
            dimension.height += ICON_SIZE + Math.round(8.0f * SwingTools.getResolutionScale());
        }
        return dimension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayedInformation {
        ICON,
        ICON_NAME_AUTHOR,
        ICON_NAME_AUTHOR_CATEGORY;

    }
}

