/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeShelfUnit;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.LocatedTransferHandler;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.View3D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component3DTransferHandler
extends LocatedTransferHandler {
    private final Home home;
    private final HomeController homeController;
    private List<Selectable> copiedItems;

    public Component3DTransferHandler(Home home, HomeController homeController) {
        this.home = home;
        this.homeController = homeController;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        this.copiedItems = this.home.getSelectedItems();
        return new HomeTransferableList(this.copiedItems);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            this.homeController.cut(this.copiedItems);
        }
        this.copiedItems = null;
        this.homeController.enablePasteAction();
    }

    @Override
    protected boolean canImportFlavor(DataFlavor[] dataFlavorArray) {
        Level level = this.home.getSelectedLevel();
        List<DataFlavor> list = Arrays.asList(dataFlavorArray);
        return (level == null || level.isViewable()) && list.contains(HomeTransferableList.HOME_FLAVOR) && !SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), (JComponent)((Object)this.homeController.getFurnitureController().getView()));
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImportFlavor(transferable.getTransferDataFlavors())) {
            try {
                List<DataFlavor> list = Arrays.asList(transferable.getTransferDataFlavors());
                return this.importHomeTransferableList(jComponent, (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
        return false;
    }

    private boolean importHomeTransferableList(JComponent jComponent, List<Selectable> list) {
        if (this.isDrop()) {
            Level level = this.getDropModelLevel(jComponent);
            float[] fArray = this.getDropModelLocation(jComponent, list, level);
            this.homeController.drop(list, this.homeController.getHomeController3D().getView(), level, fArray[0], fArray[1], fArray.length == 3 ? Float.valueOf(fArray[2]) : null);
        } else {
            this.homeController.paste(list);
        }
        return true;
    }

    private Level getDropModelLevel(JComponent jComponent) {
        if (jComponent instanceof View3D) {
            View3D view3D = (View3D)((Object)jComponent);
            Point point = this.getDropLocation();
            SwingUtilities.convertPointFromScreen(point, jComponent);
            Selectable selectable = view3D.getClosestSelectableItemAt(point.x, point.y);
            Level level = this.home.getSelectedLevel();
            if (selectable != null && selectable instanceof Elevatable && !((Elevatable)((Object)selectable)).isAtLevel(level)) {
                return ((Elevatable)((Object)selectable)).getLevel();
            }
        }
        return this.home.getSelectedLevel();
    }

    private float[] getDropModelLocation(JComponent jComponent, List<Selectable> list, Level level) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        if (jComponent instanceof View3D) {
            View3D view3D = (View3D)((Object)jComponent);
            Point point = this.getDropLocation();
            SwingUtilities.convertPointFromScreen(point, jComponent);
            Selectable selectable = view3D.getClosestSelectableItemAt(point.x, point.y);
            float f = 0.0f;
            if (level != null) {
                f = level.getElevation();
            }
            if (selectable instanceof HomePieceOfFurniture) {
                HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)selectable;
                fArray = new float[]{homePieceOfFurniture.getX(), homePieceOfFurniture.getY()};
                if (list.size() == 1 && list.get(0) instanceof PieceOfFurniture) {
                    float f2;
                    float[] fArray2 = view3D.getVirtualWorldPointAt(point.x, point.y, f);
                    float[] fArray3 = this.computeIntersection(fArray2[0], fArray2[1], this.home.getCamera().getX(), this.home.getCamera().getY(), fArray[0], fArray[1], fArray[0] + (float)Math.cos(homePieceOfFurniture.getAngle()), fArray[1] + (float)Math.sin(homePieceOfFurniture.getAngle()));
                    if (Point2D.distance(fArray3[0], fArray3[1], homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) < (double)(homePieceOfFurniture.getWidth() / 2.0f)) {
                        fArray = fArray3;
                    }
                    PieceOfFurniture pieceOfFurniture = (PieceOfFurniture)((Object)list.get(0));
                    fArray[0] = fArray[0] - pieceOfFurniture.getWidth() / 2.0f;
                    fArray[1] = fArray[1] - pieceOfFurniture.getDepth() / 2.0f;
                    if (selectable instanceof HomeShelfUnit) {
                        Camera camera = this.home.getCamera();
                        float f3 = (float)Point2D.distance(fArray2[0], fArray2[1], camera.getX(), camera.getY());
                        float f4 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[0], fArray[1]);
                        f2 = (camera.getZ() - (this.home.getSelectedLevel() != null ? this.home.getSelectedLevel().getElevation() : 0.0f)) / f3 * f4;
                    } else {
                        f2 = homePieceOfFurniture.isHorizontallyRotated() ? homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeightInPlan() : (homePieceOfFurniture.getDropOnTopElevation() >= 0.0f ? homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeight() * homePieceOfFurniture.getDropOnTopElevation() : 0.0f);
                    }
                    fArray = new float[]{fArray[0], fArray[1], f2};
                }
            } else if (selectable instanceof Wall && ((Wall)selectable).getArcExtent() == null && list.size() == 1) {
                float[] fArray4 = view3D.getVirtualWorldPointAt(point.x, point.y, f);
                Wall wall = (Wall)selectable;
                float[][] fArray5 = wall.getPoints();
                float[] fArray6 = this.computeIntersection(fArray4[0], fArray4[1], this.home.getCamera().getX(), this.home.getCamera().getY(), fArray5[0][0], fArray5[0][1], fArray5[1][0], fArray5[1][1]);
                float[] fArray7 = this.computeIntersection(fArray4[0], fArray4[1], this.home.getCamera().getX(), this.home.getCamera().getY(), fArray5[3][0], fArray5[3][1], fArray5[2][0], fArray5[2][1]);
                fArray = Point2D.distanceSq(this.home.getCamera().getX(), this.home.getCamera().getY(), fArray6[0], fArray6[1]) < Point2D.distanceSq(this.home.getCamera().getX(), this.home.getCamera().getY(), fArray7[0], fArray7[1]) ? fArray6 : fArray7;
                if (list.get(0) instanceof PieceOfFurniture) {
                    PieceOfFurniture pieceOfFurniture = (PieceOfFurniture)((Object)list.get(0));
                    double d = Math.atan((wall.getYEnd() - wall.getYStart()) / (wall.getXEnd() - wall.getXStart()));
                    fArray[0] = (float)((double)fArray[0] - (double)(pieceOfFurniture.getWidth() / 2.0f) * Math.cos(d));
                    fArray[1] = (float)((double)fArray[1] - (double)(pieceOfFurniture.getWidth() / 2.0f) * Math.sin(d));
                }
            } else if (!this.home.isEmpty()) {
                fArray = view3D.getVirtualWorldPointAt(point.x, point.y, f);
                fArray = new float[]{fArray[0], fArray[1]};
                if (list.size() == 1 && list.get(0) instanceof PieceOfFurniture) {
                    PieceOfFurniture pieceOfFurniture = (PieceOfFurniture)((Object)list.get(0));
                    fArray[0] = fArray[0] - pieceOfFurniture.getWidth() / 2.0f;
                    fArray[1] = fArray[1] - pieceOfFurniture.getDepth() / 2.0f;
                }
            }
        }
        return fArray;
    }

    private float[] computeIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        block6: {
            float f11;
            float f12;
            block9: {
                boolean bl;
                block8: {
                    block7: {
                        f10 = f3;
                        f9 = f4;
                        f12 = (f4 - f2) / (f3 - f);
                        f11 = (f8 - f6) / (f7 - f5);
                        if (f12 == f11) break block6;
                        if (!(Math.abs(f12) > 4000.0f)) break block7;
                        if (Math.abs(f11) < 4000.0f) {
                            f10 = f;
                            float f13 = f8 - f11 * f7;
                            f9 = f11 * f10 + f13;
                        }
                        break block6;
                    }
                    if (!(Math.abs(f11) > 4000.0f)) break block8;
                    if (Math.abs(f12) < 4000.0f) {
                        f10 = f5;
                        float f14 = f4 - f12 * f3;
                        f9 = f12 * f10 + f14;
                    }
                    break block6;
                }
                boolean bl2 = bl = Math.signum(f12) == Math.signum(f11);
                if (!((double)Math.abs(f12 - f11) > 1.0E-5)) break block6;
                if (!bl) break block9;
                float f15 = Math.abs(f12) > Math.abs(f11) ? f12 / f11 : f11 / f12;
                if (!((double)f15 > 1.004)) break block6;
            }
            float f16 = f4 - f12 * f3;
            float f17 = f8 - f11 * f7;
            f10 = (f17 - f16) / (f12 - f11);
            f9 = f12 * f10 + f16;
        }
        return new float[]{f10, f9};
    }
}

