/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.eteks.sweethome3d.HomeFrameController;
import com.eteks.sweethome3d.MacOSXConfiguration;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.Timer;

public class HomeFramePane
extends JRootPane
implements View {
    private static final String FRAME_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameX";
    private static final String FRAME_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameY";
    private static final String FRAME_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameWidth";
    private static final String FRAME_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameHeight";
    private static final String FRAME_MAXIMIZED_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameMaximized";
    private static final String SCREEN_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenWidth";
    private static final String SCREEN_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenHeight";
    private final Home home;
    private final HomeApplication application;
    private final ContentManager contentManager;
    private final HomeFrameController controller;
    private static int newHomeCount;
    private int newHomeNumber;

    public HomeFramePane(Home home, HomeApplication homeApplication, ContentManager contentManager, HomeFrameController homeFrameController) {
        this.home = home;
        this.controller = homeFrameController;
        this.application = homeApplication;
        this.contentManager = contentManager;
        if (home.getName() == null) {
            this.newHomeNumber = ++newHomeCount;
        }
        HomeView homeView = this.controller.getHomeController().getView();
        this.setContentPane((JComponent)((Object)homeView));
    }

    public void displayView() {
        final JFrameWithRootPane jFrameWithRootPane = new JFrameWithRootPane(this);
        ArrayList<Image> arrayList = new ArrayList<Image>(3);
        arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon.png")).getImage());
        arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon32x32.png")).getImage());
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon128x128.png")).getImage());
        }
        try {
            jFrameWithRootPane.getClass().getMethod("setIconImages", List.class).invoke((Object)jFrameWithRootPane, arrayList);
        }
        catch (Exception exception) {
            jFrameWithRootPane.setIconImage((Image)arrayList.get(0));
        }
        this.updateFrameTitle(jFrameWithRootPane, this.home, this.application);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        if (OperatingSystem.isMacOSXLionOrSuperior()) {
            MacOSXConfiguration.installToolBar(this);
        }
        this.computeFrameBounds(this.home, jFrameWithRootPane);
        this.getToolkit().setDynamicLayout(true);
        HomeView homeView = this.controller.getHomeController().getView();
        if (homeView instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)((Object)homeView);
            this.setJMenuBar(jRootPane.getJMenuBar());
            jRootPane.setJMenuBar(null);
        }
        this.addListeners(this.home, this.application, this.controller.getHomeController(), jFrameWithRootPane);
        jFrameWithRootPane.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                HomeFramePane.this.addWindowStateListener(HomeFramePane.this.home, HomeFramePane.this.application, HomeFramePane.this.controller.getHomeController(), jFrameWithRootPane);
                jFrameWithRootPane.toFront();
            }
        });
    }

    private void addListeners(final Home home, final HomeApplication homeApplication, final HomeController homeController, final JFrame jFrame) {
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setHomeProperty(HomeFramePane.FRAME_WIDTH_VISUAL_PROPERTY, String.valueOf(jFrame.getWidth()));
                    homeController.setHomeProperty(HomeFramePane.FRAME_HEIGHT_VISUAL_PROPERTY, String.valueOf(jFrame.getHeight()));
                }
                Dimension dimension = HomeFramePane.this.getUserScreenSize();
                homeController.setHomeProperty(HomeFramePane.SCREEN_WIDTH_VISUAL_PROPERTY, String.valueOf(dimension.width));
                homeController.setHomeProperty(HomeFramePane.SCREEN_HEIGHT_VISUAL_PROPERTY, String.valueOf(dimension.height));
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setHomeProperty(HomeFramePane.FRAME_X_VISUAL_PROPERTY, String.valueOf(jFrame.getX()));
                    homeController.setHomeProperty(HomeFramePane.FRAME_Y_VISUAL_PROPERTY, String.valueOf(jFrame.getY()));
                }
            }
        };
        jFrame.addComponentListener(componentAdapter);
        jFrame.setDefaultCloseOperation(0);
        final WindowAdapter windowAdapter = new WindowAdapter(){
            private Component mostRecentFocusOwner;

            public void windowClosing(WindowEvent windowEvent) {
                homeController.close();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                Component component = jFrame.getMostRecentFocusOwner();
                if (!(component instanceof JFrame) && component != null) {
                    this.mostRecentFocusOwner = component;
                }
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (this.mostRecentFocusOwner != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            mostRecentFocusOwner.requestFocusInWindow();
                        }
                    });
                }
            }
        };
        jFrame.addWindowListener(windowAdapter);
        homeApplication.getUserPreferences().addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(jFrame, this));
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFramePane.this.updateFrameTitle(jFrame, home, homeApplication);
            }
        };
        home.addPropertyChangeListener(Home.Property.NAME, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.MODIFIED, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.RECOVERED, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.REPAIRED, propertyChangeListener);
        homeApplication.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    homeApplication.removeHomesListener(this);
                    jFrame.removeWindowListener(windowAdapter);
                    jFrame.removeComponentListener(componentAdapter);
                    home.removePropertyChangeListener(Home.Property.NAME, propertyChangeListener);
                    home.removePropertyChangeListener(Home.Property.MODIFIED, propertyChangeListener);
                    home.removePropertyChangeListener(Home.Property.RECOVERED, propertyChangeListener);
                    home.removePropertyChangeListener(Home.Property.REPAIRED, propertyChangeListener);
                    jFrame.dispose();
                    ((JFrameWithRootPane)jFrame).resetRootPane();
                }
            }
        });
    }

    private void addWindowStateListener(final Home home, final HomeApplication homeApplication, final HomeController homeController, final JFrame jFrame) {
        final WindowStateListener windowStateListener = new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                homeController.setHomeProperty(HomeFramePane.FRAME_MAXIMIZED_VISUAL_PROPERTY, String.valueOf((jFrame.getExtendedState() & 6) == 6));
            }
        };
        jFrame.addWindowStateListener(windowStateListener);
        homeApplication.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    homeApplication.removeHomesListener(this);
                    jFrame.removeWindowStateListener(windowStateListener);
                }
            }
        });
    }

    private void computeFrameBounds(Home home, final JFrame jFrame) {
        Number number = home.getNumericProperty(FRAME_X_VISUAL_PROPERTY);
        Number number2 = home.getNumericProperty(FRAME_Y_VISUAL_PROPERTY);
        Number number3 = home.getNumericProperty(FRAME_WIDTH_VISUAL_PROPERTY);
        Number number4 = home.getNumericProperty(FRAME_HEIGHT_VISUAL_PROPERTY);
        boolean bl = Boolean.parseBoolean(home.getProperty(FRAME_MAXIMIZED_VISUAL_PROPERTY));
        Number number5 = home.getNumericProperty(SCREEN_WIDTH_VISUAL_PROPERTY);
        Number number6 = home.getNumericProperty(SCREEN_HEIGHT_VISUAL_PROPERTY);
        final Dimension dimension = this.getUserScreenSize();
        if (number != null && number2 != null && number3 != null && number4 != null && number5 != null && number6 != null && number5.intValue() <= dimension.width && number6.intValue() <= dimension.height) {
            final Rectangle rectangle = new Rectangle(number.intValue(), number2.intValue(), number3.intValue(), number4.intValue());
            if (bl) {
                Object object;
                if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                    object = jFrame.getInsets();
                    jFrame.setSize(dimension.width + ((Insets)object).left + ((Insets)object).right, dimension.height + ((Insets)object).bottom);
                    jFrame.setExtendedState(6);
                } else if (OperatingSystem.isLinux()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            jFrame.setExtendedState(6);
                        }
                    });
                } else {
                    jFrame.setExtendedState(6);
                }
                object = new WindowAdapter(){

                    public void windowStateChanged(WindowEvent windowEvent) {
                        if ((windowEvent.getOldState() == 6 || OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7") && windowEvent.getOldState() == 0) && windowEvent.getNewState() == 0) {
                            if (!SwingTools.isRectangleVisibleAtScreen(rectangle)) {
                                rectangle.setBounds(0, 0, dimension.width * 4 / 5, dimension.height * 4 / 5);
                            } else if (OperatingSystem.isMacOSXLionOrSuperior()) {
                                new Timer(20, new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (jFrame.getHeight() < 40) {
                                            ((Timer)actionEvent.getSource()).stop();
                                            jFrame.setBounds(rectangle);
                                        }
                                    }
                                }).start();
                            } else {
                                jFrame.setBounds(rectangle);
                            }
                            jFrame.removeWindowStateListener(this);
                        }
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        jFrame.removeWindowListener(this);
                        jFrame.removeWindowStateListener(this);
                    }
                };
                jFrame.addWindowStateListener((WindowStateListener)object);
                jFrame.addWindowListener((WindowListener)object);
            } else {
                jFrame.setBounds(rectangle);
                jFrame.setLocationByPlatform(!SwingTools.isRectangleVisibleAtScreen(rectangle));
            }
        } else {
            jFrame.setLocationByPlatform(true);
            jFrame.pack();
            jFrame.setSize(Math.min(dimension.width * 4 / 5, jFrame.getWidth()), Math.min(dimension.height * 4 / 5, jFrame.getHeight()));
            if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionBetween("1.7", "1.9")) {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MAX_VALUE;
                int n3 = Integer.MIN_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (Frame frame : Frame.getFrames()) {
                    if (!frame.isShowing() || frame.getBackground().getAlpha() == 0) continue;
                    n = Math.min(n, frame.getX());
                    n2 = Math.min(n2, frame.getY());
                    n3 = Math.max(n3, frame.getX());
                    n4 = Math.max(n4, frame.getY());
                }
                number = n == Integer.MAX_VALUE || n >= 23 ? Integer.valueOf(0) : Integer.valueOf(n3 + 23);
                number2 = n2 == Integer.MAX_VALUE || n2 >= 23 ? Integer.valueOf(0) : Integer.valueOf(n4 + 23);
                jFrame.setLocation(number.intValue(), number2.intValue());
            }
        }
    }

    private Dimension getUserScreenSize() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        return dimension;
    }

    private void updateFrameTitle(JFrame jFrame, Home home, HomeApplication homeApplication) {
        String string;
        String string2 = home.getName();
        if (string2 == null) {
            string = homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "untitled", new Object[0]);
            if (this.newHomeNumber > 1) {
                string = string + " " + this.newHomeNumber;
            }
        } else {
            string = this.contentManager.getPresentationName(string2, ContentManager.ContentType.SWEET_HOME_3D);
        }
        if (home.isRecovered()) {
            string = string + " " + homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "recovered", new Object[0]);
        }
        if (home.isRepaired()) {
            string = string + " " + homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "repaired", new Object[0]);
        }
        String string3 = string;
        if (OperatingSystem.isMacOSX()) {
            Boolean bl = home.isModified() || home.isRecovered();
            this.putClientProperty("windowModified", bl);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                File file;
                this.putClientProperty("Window.documentModified", bl);
                if (string2 != null && (file = new File(string2)).exists()) {
                    this.putClientProperty("Window.documentFile", file);
                }
            }
            if (!jFrame.isVisible() && OperatingSystem.isMacOSXLionOrSuperior()) {
                try {
                    Class.forName("com.apple.eawt.FullScreenUtilities").getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(null, jFrame, true);
                }
                catch (Exception exception) {}
            }
        } else {
            string3 = string3 + " - " + homeApplication.getName();
            if (home.isModified() || home.isRecovered()) {
                string3 = "* " + string3;
            }
        }
        jFrame.setTitle(string3);
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<JFrame> frame;
        private WeakReference<HomeFramePane> homeFramePane;

        public LanguageChangeListener(JFrame jFrame, HomeFramePane homeFramePane) {
            this.frame = new WeakReference<JFrame>(jFrame);
            this.homeFramePane = new WeakReference<HomeFramePane>(homeFramePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JFrame jFrame = (JFrame)this.frame.get();
            HomeFramePane homeFramePane = (HomeFramePane)this.homeFramePane.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (jFrame == null || homeFramePane == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                jFrame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                homeFramePane.updateFrameTitle(jFrame, homeFramePane.home, homeFramePane.application);
            }
        }
    }

    private static class JFrameWithRootPane
    extends JFrame {
        public JFrameWithRootPane(JRootPane jRootPane) {
            super.setRootPane(jRootPane);
        }

        public void resetRootPane() {
            super.setRootPane(new JRootPane());
        }
    }
}

