/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.plugin;

import com.eteks.sweethome3d.tools.ResourceURLContent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class PluginAction {
    private final Map<Property, Object> propertyValues = new HashMap<Property, Object>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PluginAction() {
    }

    public PluginAction(String string, String string2, ClassLoader classLoader) {
        this(string, string2, classLoader, false);
    }

    public PluginAction(String string, String string2, ClassLoader classLoader, boolean bl) {
        this.readActionPropertyValues(string, string2, classLoader);
        this.setEnabled(bl);
    }

    private void readActionPropertyValues(String string, String string2, ClassLoader classLoader) {
        String string3;
        String string4;
        ResourceBundle resourceBundle = classLoader != null ? ResourceBundle.getBundle(string, Locale.getDefault(), classLoader) : ResourceBundle.getBundle(string, Locale.getDefault());
        String string5 = string2 + ".";
        this.putPropertyValue(Property.NAME, this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.NAME)));
        this.putPropertyValue(Property.SHORT_DESCRIPTION, this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.SHORT_DESCRIPTION)));
        String string6 = this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.SMALL_ICON));
        if (string6 != null) {
            if (string6.startsWith("/")) {
                string6 = string6.substring(1);
            }
            this.putPropertyValue(Property.SMALL_ICON, new ResourceURLContent(classLoader, string6));
        }
        if ((string4 = this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.MNEMONIC))) != null) {
            this.putPropertyValue(Property.MNEMONIC, Character.valueOf(string4.charAt(0)));
        }
        if ((string3 = this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.TOOL_BAR))) != null) {
            this.putPropertyValue(Property.TOOL_BAR, Boolean.valueOf(string3));
        }
        this.putPropertyValue(Property.MENU, this.getOptionalString(resourceBundle, string5 + (Object)((Object)Property.MENU)));
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Object getPropertyValue(Property property) {
        return this.propertyValues.get((Object)property);
    }

    public void putPropertyValue(Property property, Object object) {
        Object object2 = this.propertyValues.get((Object)property);
        if (object != object2 || object != null && !object.equals(object2)) {
            this.propertyValues.put(property, object);
            this.propertyChangeSupport.firePropertyChange(property.name(), object2, object);
        }
    }

    public void setEnabled(boolean bl) {
        this.putPropertyValue(Property.ENABLED, bl);
    }

    public boolean isEnabled() {
        Boolean bl = (Boolean)this.getPropertyValue(Property.ENABLED);
        return bl != null && bl != false;
    }

    public abstract void execute();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        SHORT_DESCRIPTION,
        SMALL_ICON,
        MNEMONIC,
        TOOL_BAR,
        MENU,
        ENABLED;

    }
}

