/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.io.DefaultLibrary;
import com.eteks.sweethome3d.io.DefaultTexturesCatalog;
import com.eteks.sweethome3d.io.DefaultUserPreferences;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUserPreferences
extends UserPreferences {
    private static final String LANGUAGE = "language";
    private static final String UNIT = "unit";
    private static final String EXTENSIBLE_UNIT = "extensibleUnit";
    private static final String CURRENCY = "currency";
    private static final String VALUE_ADDED_TAX_ENABLED = "valueAddedTaxEnabled";
    private static final String DEFAULT_VALUE_ADDED_TAX_PERCENTAGE = "defaultValueAddedTaxPercentage";
    private static final String FURNITURE_CATALOG_VIEWED_IN_TREE = "furnitureCatalogViewedInTree";
    private static final String NAVIGATION_PANEL_VISIBLE = "navigationPanelVisible";
    private static final String EDITING_IN_3D_VIEW_ENABLED = "editingIn3DViewEnabled";
    private static final String AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED = "aerialViewCenteredOnSelectionEnabled";
    private static final String OBSERVER_CAMERA_SELECTED_AT_CHANGE = "observerCameraSelectedAtChange";
    private static final String MAGNETISM_ENABLED = "magnetismEnabled";
    private static final String RULERS_VISIBLE = "rulersVisible";
    private static final String GRID_VISIBLE = "gridVisible";
    private static final String DEFAULT_FONT_NAME = "defaultFontName";
    private static final String FURNITURE_VIEWED_FROM_TOP = "furnitureViewedFromTop";
    private static final String FURNITURE_MODEL_ICON_SIZE = "furnitureModelIconSize";
    private static final String ROOM_FLOOR_COLORED_OR_TEXTURED = "roomFloorColoredOrTextured";
    private static final String WALL_PATTERN = "wallPattern";
    private static final String NEW_WALL_PATTERN = "newWallPattern";
    private static final String NEW_WALL_THICKNESS = "newWallThickness";
    private static final String NEW_WALL_HEIGHT = "newHomeWallHeight";
    private static final String NEW_WALL_BASEBOARD_THICKNESS = "newWallBaseboardThickness";
    private static final String NEW_WALL_BASEBOARD_HEIGHT = "newWallBaseboardHeight";
    private static final String NEW_ROOM_FLOOR_COLOR = "newRoomFloorColor";
    private static final String NEW_FLOOR_THICKNESS = "newFloorThickness";
    private static final String CHECK_UPDATES_ENABLED = "checkUpdatesEnabled";
    private static final String UPDATES_MINIMUM_DATE = "updatesMinimumDate";
    private static final String AUTO_SAVE_DELAY_FOR_RECOVERY = "autoSaveDelayForRecovery";
    private static final String AUTO_COMPLETION_PROPERTY = "autoCompletionProperty#";
    private static final String AUTO_COMPLETION_STRINGS = "autoCompletionStrings#";
    private static final String RECENT_COLORS = "recentColors";
    private static final String RECENT_TEXTURE_NAME = "recentTextureName#";
    private static final String RECENT_TEXTURE_CREATOR = "recentTextureCreator#";
    private static final String RECENT_TEXTURE_IMAGE = "recentTextureImage#";
    private static final String RECENT_TEXTURE_WIDTH = "recentTextureWidth#";
    private static final String RECENT_TEXTURE_HEIGHT = "recentTextureHeight#";
    private static final String RECENT_HOMES = "recentHomes#";
    private static final String IGNORED_ACTION_TIP = "ignoredActionTip#";
    private static final String PHOTO_RENDERER = "photoRenderer";
    private static final String FURNITURE_NAME = "furnitureName#";
    private static final String FURNITURE_CREATOR = "furnitureCreator#";
    private static final String FURNITURE_CATEGORY = "furnitureCategory#";
    private static final String FURNITURE_ICON = "furnitureIcon#";
    private static final String FURNITURE_MODEL = "furnitureModel#";
    private static final String FURNITURE_WIDTH = "furnitureWidth#";
    private static final String FURNITURE_DEPTH = "furnitureDepth#";
    private static final String FURNITURE_HEIGHT = "furnitureHeight#";
    private static final String FURNITURE_MOVABLE = "furnitureMovable#";
    private static final String FURNITURE_DOOR_OR_WINDOW = "furnitureDoorOrWindow#";
    private static final String FURNITURE_ELEVATION = "furnitureElevation#";
    private static final String FURNITURE_COLOR = "furnitureColor#";
    private static final String FURNITURE_MODEL_ROTATION = "furnitureModelRotation#";
    private static final String FURNITURE_MODEL_FLAGS = "furnitureModelFlags#";
    private static final String FURNITURE_MODEL_SIZE = "furnitureModelSize#";
    private static final String FURNITURE_STAIRCASE_CUT_OUT_SHAPE = "furnitureStaircaseCutOutShape#";
    private static final String FURNITURE_BACK_FACE_SHOWN = "furnitureBackFaceShown#";
    private static final String FURNITURE_ICON_YAW = "furnitureIconYaw#";
    private static final String FURNITURE_ICON_PITCH = "furnitureIconPitch#";
    private static final String FURNITURE_ICON_SCALE = "furnitureIconScale#";
    private static final String FURNITURE_PROPORTIONAL = "furnitureProportional#";
    private static final String TEXTURE_NAME = "textureName#";
    private static final String TEXTURE_CREATOR = "textureCreator#";
    private static final String TEXTURE_CATEGORY = "textureCategory#";
    private static final String TEXTURE_IMAGE = "textureImage#";
    private static final String TEXTURE_WIDTH = "textureWidth#";
    private static final String TEXTURE_HEIGHT = "textureHeight#";
    private static final String FURNITURE_CONTENT_PREFIX = "Furniture-3-";
    private static final String TEXTURE_CONTENT_PREFIX = "Texture-3-";
    private static final String LANGUAGE_LIBRARIES_PLUGIN_SUB_FOLDER = "languages";
    private static final String FURNITURE_LIBRARIES_PLUGIN_SUB_FOLDER = "furniture";
    private static final String TEXTURES_LIBRARIES_PLUGIN_SUB_FOLDER = "textures";
    private static final PreferencesURLContent MISSING_CONTENT;
    private final Map<String, Boolean> ignoredActionTips = new HashMap<String, Boolean>();
    private List<ClassLoader> resourceClassLoaders;
    private final File preferencesFolder;
    private final File[] applicationFolders;
    private Preferences preferences;
    private Executor catalogsLoader;
    private Executor updater;
    private List<Library> libraries;
    private Map<Content, PreferencesURLContent> copiedContentsCache = new WeakHashMap<Content, PreferencesURLContent>();
    public static final String PLUGIN_LANGUAGE_LIBRARY_FAMILY = "PluginLanguageLibrary";

    public FileUserPreferences() {
        this(null, null);
    }

    public FileUserPreferences(File file, File[] fileArray) {
        this(file, fileArray, null);
    }

    public FileUserPreferences(File file, File[] fileArray, Executor executor) {
        String string7;
        int n;
        String string2;
        this.libraries = new ArrayList<Library>();
        this.preferencesFolder = file;
        this.applicationFolders = fileArray;
        Executor executor2 = new Executor(){

            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
        if (executor == null) {
            this.catalogsLoader = this.updater = executor2;
        } else {
            this.catalogsLoader = Executors.newSingleThreadExecutor();
            this.updater = executor;
        }
        this.updateSupportedLanguages();
        PortablePreferences portablePreferences = new PortablePreferences();
        Preferences preferences = !portablePreferences.exist() && file == null ? this.getPreferences() : portablePreferences;
        String string3 = preferences.get(LANGUAGE, this.getLanguage());
        if (!Arrays.asList(this.getSupportedLanguages()).contains(string3)) {
            string3 = Locale.ENGLISH.getLanguage();
        }
        this.setLanguage(string3);
        this.setFurnitureCatalog(new FurnitureCatalog());
        this.updateFurnitureDefaultCatalog(executor2, executor2);
        this.readModifiableFurnitureCatalog(preferences);
        this.setTexturesCatalog(new TexturesCatalog());
        this.updateTexturesDefaultCatalog(executor2, executor2);
        this.readModifiableTexturesCatalog(preferences);
        DefaultUserPreferences defaultUserPreferences = new DefaultUserPreferences(false, this);
        PatternsCatalog patternsCatalog = defaultUserPreferences.getPatternsCatalog();
        this.setPatternsCatalog(patternsCatalog);
        LengthUnit lengthUnit = defaultUserPreferences.getLengthUnit();
        try {
            string2 = preferences.get(EXTENSIBLE_UNIT, null);
            if (string2 != null) {
                this.setUnit(LengthUnit.valueOf(string2));
            } else {
                this.setUnit(LengthUnit.valueOf(preferences.get(UNIT, lengthUnit.name())));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setUnit(lengthUnit);
        }
        this.setCurrency(preferences.get(CURRENCY, defaultUserPreferences.getCurrency()));
        this.setValueAddedTaxEnabled(preferences.getBoolean(VALUE_ADDED_TAX_ENABLED, defaultUserPreferences.isValueAddedTaxEnabled()));
        string2 = preferences.get(DEFAULT_VALUE_ADDED_TAX_PERCENTAGE, null);
        BigDecimal bigDecimal = defaultUserPreferences.getDefaultValueAddedTaxPercentage();
        if (string2 != null) {
            try {
                bigDecimal = new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setDefaultValueAddedTaxPercentage(bigDecimal);
        this.setFurnitureCatalogViewedInTree(preferences.getBoolean(FURNITURE_CATALOG_VIEWED_IN_TREE, defaultUserPreferences.isFurnitureCatalogViewedInTree()));
        this.setNavigationPanelVisible(preferences.getBoolean(NAVIGATION_PANEL_VISIBLE, defaultUserPreferences.isNavigationPanelVisible()));
        this.setEditingIn3DViewEnabled(preferences.getBoolean(EDITING_IN_3D_VIEW_ENABLED, defaultUserPreferences.isEditingIn3DViewEnabled()));
        this.setAerialViewCenteredOnSelectionEnabled(preferences.getBoolean(AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, defaultUserPreferences.isAerialViewCenteredOnSelectionEnabled()));
        this.setObserverCameraSelectedAtChange(preferences.getBoolean(OBSERVER_CAMERA_SELECTED_AT_CHANGE, defaultUserPreferences.isObserverCameraSelectedAtChange()));
        this.setMagnetismEnabled(preferences.getBoolean(MAGNETISM_ENABLED, true));
        this.setRulersVisible(preferences.getBoolean(RULERS_VISIBLE, defaultUserPreferences.isRulersVisible()));
        this.setGridVisible(preferences.getBoolean(GRID_VISIBLE, defaultUserPreferences.isGridVisible()));
        this.setDefaultFontName(preferences.get(DEFAULT_FONT_NAME, defaultUserPreferences.getDefaultFontName()));
        this.setFurnitureViewedFromTop(preferences.getBoolean(FURNITURE_VIEWED_FROM_TOP, defaultUserPreferences.isFurnitureViewedFromTop()));
        this.setFurnitureModelIconSize(preferences.getInt(FURNITURE_MODEL_ICON_SIZE, defaultUserPreferences.getFurnitureModelIconSize()));
        this.setFloorColoredOrTextured(preferences.getBoolean(ROOM_FLOOR_COLORED_OR_TEXTURED, defaultUserPreferences.isRoomFloorColoredOrTextured()));
        try {
            this.setWallPattern(patternsCatalog.getPattern(preferences.get(WALL_PATTERN, defaultUserPreferences.getWallPattern().getName())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setWallPattern(defaultUserPreferences.getWallPattern());
        }
        try {
            if (defaultUserPreferences.getNewWallPattern() != null) {
                this.setNewWallPattern(patternsCatalog.getPattern(preferences.get(NEW_WALL_PATTERN, defaultUserPreferences.getNewWallPattern().getName())));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setNewWallThickness(preferences.getFloat(NEW_WALL_THICKNESS, defaultUserPreferences.getNewWallThickness()));
        this.setNewWallHeight(preferences.getFloat(NEW_WALL_HEIGHT, defaultUserPreferences.getNewWallHeight()));
        this.setNewWallBaseboardThickness(preferences.getFloat(NEW_WALL_BASEBOARD_THICKNESS, defaultUserPreferences.getNewWallBaseboardThickness()));
        this.setNewWallBaseboardHeight(preferences.getFloat(NEW_WALL_BASEBOARD_HEIGHT, defaultUserPreferences.getNewWallBaseboardHeight()));
        String string4 = preferences.get(NEW_ROOM_FLOOR_COLOR, null);
        if (string4 != null) {
            this.setNewRoomFloorColor(Integer.decode(string4) | 0xFF000000);
        } else {
            this.setNewRoomFloorColor(defaultUserPreferences.getNewRoomFloorColor());
        }
        this.setNewFloorThickness(preferences.getFloat(NEW_FLOOR_THICKNESS, defaultUserPreferences.getNewFloorThickness()));
        this.setCheckUpdatesEnabled(preferences.getBoolean(CHECK_UPDATES_ENABLED, defaultUserPreferences.isCheckUpdatesEnabled()));
        if (preferences.get(UPDATES_MINIMUM_DATE, null) != null) {
            this.setUpdatesMinimumDate(preferences.getLong(UPDATES_MINIMUM_DATE, 0L));
        }
        this.setAutoSaveDelayForRecovery(preferences.getInt(AUTO_SAVE_DELAY_FOR_RECOVERY, defaultUserPreferences.getAutoSaveDelayForRecovery()));
        String[] stringArray = preferences.get(RECENT_COLORS, "").split(",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        for (String string5 : stringArray) {
            if (string5.length() <= 0) continue;
            arrayList.add(Integer.decode(string5) | 0xFF000000);
        }
        this.setRecentColors(arrayList);
        this.readRecentTextures(preferences);
        ArrayList arrayList2 = new ArrayList();
        for (n = 1; n <= this.getRecentHomesMaxCount(); ++n) {
            String string6 = preferences.get(RECENT_HOMES + n, null);
            if (string6 == null) continue;
            arrayList2.add(string6);
        }
        this.setRecentHomes(arrayList2);
        n = 1;
        while ((string7 = preferences.get(IGNORED_ACTION_TIP + n, "")).length() != 0) {
            this.ignoredActionTips.put(string7, true);
            ++n;
        }
        for (String string7 : defaultUserPreferences.getAutoCompletedProperties()) {
            this.setAutoCompletionStrings(string7, defaultUserPreferences.getAutoCompletionStrings(string7));
        }
        int n2 = 1;
        while (true) {
            String string5;
            string7 = preferences.get(AUTO_COMPLETION_PROPERTY + n2, null);
            string5 = preferences.get(AUTO_COMPLETION_STRINGS + n2, null);
            if (string7 == null || string5 == null) break;
            this.setAutoCompletionStrings(string7, Arrays.asList(string5.split(",")));
            ++n2;
        }
        this.setPhotoRenderer(preferences.get(PHOTO_RENDERER, defaultUserPreferences.getPhotoRenderer()));
        this.setHomeExamples(defaultUserPreferences.getHomeExamples());
        this.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FileUserPreferences.this.updateFurnitureDefaultCatalog(FileUserPreferences.this.catalogsLoader, FileUserPreferences.this.updater);
                FileUserPreferences.this.updateTexturesDefaultCatalog(FileUserPreferences.this.catalogsLoader, FileUserPreferences.this.updater);
                FileUserPreferences.this.updateAutoCompletionStrings();
                FileUserPreferences.this.setHomeExamples(new DefaultUserPreferences(false, FileUserPreferences.this).getHomeExamples());
            }
        });
        this.preferences = preferences != portablePreferences ? portablePreferences : preferences;
    }

    private void updateSupportedLanguages() {
        this.removeLibraries("Language library");
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        String[] stringArray = this.getDefaultSupportedLanguages();
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        File[] fileArray = this.getLanguageLibrariesPluginFolders();
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    try {
                        DefaultLibrary defaultLibrary;
                        Set<String> set = this.getLanguages(file2);
                        if (set.isEmpty()) continue;
                        treeSet.addAll(set);
                        URL uRL = file2.toURI().toURL();
                        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
                        arrayList.add(uRLClassLoader);
                        try {
                            defaultLibrary = new DefaultLibrary(file2.getCanonicalPath(), "Language library", ResourceBundle.getBundle(PLUGIN_LANGUAGE_LIBRARY_FAMILY, Locale.getDefault(), uRLClassLoader));
                        }
                        catch (MissingResourceException missingResourceException) {
                            defaultLibrary = new DefaultLibrary(file2.getCanonicalPath(), "Language library", null, this.getLanguageLibraryDefaultName(set), null, this.getDefaultVersion(file2), null, null);
                        }
                        this.libraries.add(0, defaultLibrary);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        arrayList.addAll(super.getResourceClassLoaders());
        this.resourceClassLoaders = Collections.unmodifiableList(arrayList);
        if (stringArray.length < treeSet.size()) {
            this.setSupportedLanguages(treeSet.toArray(new String[treeSet.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getLanguages(File file) throws IOException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ZipInputStream zipInputStream = null;
        try {
            Cloneable cloneable;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((cloneable = zipInputStream.getNextEntry()) != null) {
                int n;
                String string = cloneable.getName();
                int n2 = string.indexOf(95);
                if (n2 == -1 || (n = string.lastIndexOf(".properties")) == -1 || n2 >= n - 2) continue;
                String string2 = string.substring(n2 + 1, n);
                int n3 = string2.indexOf(95);
                if (n3 == 2 && string2.length() == 5) {
                    linkedHashSet.add(string2);
                    continue;
                }
                if (string2.length() != 2) continue;
                linkedHashSet.add(string2);
            }
            cloneable = linkedHashSet;
            return cloneable;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    private String getLanguageLibraryDefaultName(Set<String> set) {
        String string = "";
        for (String string2 : set) {
            int n;
            if (string.length() > 0) {
                string = string + ", ";
            }
            Locale locale = (n = string2.indexOf(95)) < 0 ? new Locale(string2) : new Locale(string2.substring(0, n), string2.substring(n + 1));
            string = string + locale.getDisplayLanguage(Locale.ENGLISH);
            if (n < 0) continue;
            string = string + " (" + locale.getDisplayCountry(Locale.ENGLISH) + ")";
        }
        string = set.size() > 1 ? string + " languages support" : string + " language support";
        return string;
    }

    private String getDefaultVersion(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(45);
        if (n > 0) {
            String string2;
            int n2 = string.lastIndexOf(46);
            if (n2 < 0) {
                n2 = string.length();
            }
            if ((string2 = string.substring(n + 1, n2)).matches("[\\d\\.]+")) {
                return string2;
            }
        }
        return null;
    }

    @Override
    public List<ClassLoader> getResourceClassLoaders() {
        return this.resourceClassLoaders;
    }

    private void updateFurnitureDefaultCatalog(Executor executor, final Executor executor2) {
        final FurnitureCatalog furnitureCatalog = this.getFurnitureCatalog();
        executor.execute(new Runnable(){

            public void run() {
                executor2.execute(new Runnable(){

                    public void run() {
                        for (FurnitureCategory furnitureCategory : furnitureCatalog.getCategories()) {
                            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                                if (catalogPieceOfFurniture.isModifiable()) continue;
                                furnitureCatalog.delete(catalogPieceOfFurniture);
                            }
                        }
                    }
                });
                final FurnitureCatalog furnitureCatalog2 = FileUserPreferences.this.readFurnitureCatalogFromResource(FileUserPreferences.this.getFurnitureLibrariesPluginFolders());
                for (final FurnitureCategory furnitureCategory : furnitureCatalog2.getCategories()) {
                    for (final CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                        executor2.execute(new Runnable(){

                            public void run() {
                                furnitureCatalog.add(furnitureCategory, catalogPieceOfFurniture);
                            }
                        });
                    }
                }
                if (furnitureCatalog2 instanceof DefaultFurnitureCatalog) {
                    executor2.execute(new Runnable(){

                        public void run() {
                            FileUserPreferences.this.removeLibraries("Furniture library");
                            FileUserPreferences.this.libraries.addAll(((DefaultFurnitureCatalog)furnitureCatalog2).getLibraries());
                        }
                    });
                }
            }
        });
    }

    protected FurnitureCatalog readFurnitureCatalogFromResource(File[] fileArray) {
        return new DefaultFurnitureCatalog((UserPreferences)this, fileArray);
    }

    private void removeLibraries(String string) {
        Iterator<Library> iterator = this.libraries.iterator();
        while (iterator.hasNext()) {
            Library library = iterator.next();
            if (library.getType() != string) continue;
            iterator.remove();
        }
    }

    private void updateTexturesDefaultCatalog(Executor executor, final Executor executor2) {
        final TexturesCatalog texturesCatalog = this.getTexturesCatalog();
        executor.execute(new Runnable(){

            public void run() {
                executor2.execute(new Runnable(){

                    public void run() {
                        for (TexturesCategory texturesCategory : texturesCatalog.getCategories()) {
                            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                                if (catalogTexture.isModifiable()) continue;
                                texturesCatalog.delete(catalogTexture);
                            }
                        }
                    }
                });
                final TexturesCatalog texturesCatalog2 = FileUserPreferences.this.readTexturesCatalogFromResource(FileUserPreferences.this.getTexturesLibrariesPluginFolders());
                for (final TexturesCategory texturesCategory : texturesCatalog2.getCategories()) {
                    for (final CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                        executor2.execute(new Runnable(){

                            public void run() {
                                texturesCatalog.add(texturesCategory, catalogTexture);
                            }
                        });
                    }
                }
                if (texturesCatalog2 instanceof DefaultTexturesCatalog) {
                    executor2.execute(new Runnable(){

                        public void run() {
                            FileUserPreferences.this.removeLibraries("Textures library");
                            FileUserPreferences.this.libraries.addAll(((DefaultTexturesCatalog)texturesCatalog2).getLibraries());
                        }
                    });
                }
            }
        });
    }

    protected TexturesCatalog readTexturesCatalogFromResource(File[] fileArray) {
        return new DefaultTexturesCatalog((UserPreferences)this, fileArray);
    }

    private void updateAutoCompletionStrings() {
        DefaultUserPreferences defaultUserPreferences = new DefaultUserPreferences(false, this);
        for (String string : defaultUserPreferences.getAutoCompletedProperties()) {
            for (String string2 : defaultUserPreferences.getAutoCompletionStrings(string)) {
                this.addAutoCompletionString(string, string2);
            }
        }
    }

    private void readRecentTextures(Preferences preferences) {
        String string;
        File file;
        try {
            file = this.getPreferencesFolder();
        }
        catch (IOException iOException) {
            return;
        }
        ArrayList<TextureImage> arrayList = new ArrayList<TextureImage>();
        int n = 1;
        while ((string = preferences.get(RECENT_TEXTURE_NAME + n, null)) != null) {
            PreferencesURLContent preferencesURLContent = this.getContent(preferences, RECENT_TEXTURE_IMAGE + n, file);
            if (preferencesURLContent != MISSING_CONTENT) {
                float f = preferences.getFloat(RECENT_TEXTURE_WIDTH + n, -1.0f);
                float f2 = preferences.getFloat(RECENT_TEXTURE_HEIGHT + n, -1.0f);
                String string2 = preferences.get(RECENT_TEXTURE_CREATOR + n, null);
                arrayList.add(new CatalogTexture(null, string, preferencesURLContent, f, f2, string2));
            }
            ++n;
        }
        this.setRecentTextures(arrayList);
    }

    private void readModifiableFurnitureCatalog(Preferences preferences) {
        CatalogPieceOfFurniture catalogPieceOfFurniture;
        File file;
        try {
            file = this.getPreferencesFolder();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        int n = 1;
        while ((catalogPieceOfFurniture = this.readModifiablePieceOfFurniture(preferences, n, file)) != null) {
            if (catalogPieceOfFurniture.getIcon() != MISSING_CONTENT && catalogPieceOfFurniture.getModel() != MISSING_CONTENT) {
                FurnitureCategory furnitureCategory = this.readModifiableFurnitureCategory(preferences, n);
                this.getFurnitureCatalog().add(furnitureCategory, catalogPieceOfFurniture);
            }
            ++n;
        }
    }

    protected CatalogPieceOfFurniture readModifiablePieceOfFurniture(Preferences preferences, int n, File file) {
        String string = preferences.get(FURNITURE_NAME + n, null);
        if (string == null) {
            return null;
        }
        PreferencesURLContent preferencesURLContent = this.getContent(preferences, FURNITURE_ICON + n, file);
        PreferencesURLContent preferencesURLContent2 = this.getContent(preferences, FURNITURE_MODEL + n, file);
        float f = preferences.getFloat(FURNITURE_WIDTH + n, 0.1f);
        float f2 = preferences.getFloat(FURNITURE_DEPTH + n, 0.1f);
        float f3 = preferences.getFloat(FURNITURE_HEIGHT + n, 0.1f);
        float f4 = preferences.getFloat(FURNITURE_ELEVATION + n, 0.0f);
        boolean bl = preferences.getBoolean(FURNITURE_MOVABLE + n, false);
        boolean bl2 = preferences.getBoolean(FURNITURE_DOOR_OR_WINDOW + n, false);
        String string2 = preferences.get(FURNITURE_STAIRCASE_CUT_OUT_SHAPE + n, null);
        String string3 = preferences.get(FURNITURE_COLOR + n, null);
        Integer n2 = string3 != null ? Integer.valueOf(string3) : null;
        float[][] fArray = this.getModelRotation(preferences, FURNITURE_MODEL_ROTATION + n);
        boolean bl3 = preferences.getBoolean(FURNITURE_BACK_FACE_SHOWN + n, false);
        int n3 = preferences.getInt(FURNITURE_MODEL_FLAGS + n, bl3 ? 1 : 0);
        String string4 = preferences.get(FURNITURE_MODEL_SIZE + n, null);
        Long l = string4 != null ? Long.valueOf(string4).longValue() : preferencesURLContent2.getSize();
        String string5 = preferences.get(FURNITURE_CREATOR + n, null);
        float f5 = preferences.getFloat(FURNITURE_ICON_YAW + n, 0.0f);
        float f6 = preferences.getFloat(FURNITURE_ICON_PITCH + n, -0.19634955f);
        float f7 = preferences.getFloat(FURNITURE_ICON_SCALE + n, 1.0f);
        boolean bl4 = preferences.getBoolean(FURNITURE_PROPORTIONAL + n, true);
        if (bl2) {
            return new CatalogDoorOrWindow(string, preferencesURLContent, preferencesURLContent2, f, f2, f3, f4, bl, 1.0f, 0.0f, new Sash[0], n2, fArray, n3, l, string5, f5, f6, f7, bl4);
        }
        return new CatalogPieceOfFurniture(string, preferencesURLContent, preferencesURLContent2, f, f2, f3, f4, bl, string2, n2, fArray, n3, l, string5, f5, f6, f7, bl4);
    }

    protected FurnitureCategory readModifiableFurnitureCategory(Preferences preferences, int n) {
        String string = preferences.get(FURNITURE_CATEGORY + n, "");
        return new FurnitureCategory(string);
    }

    private float[][] getModelRotation(Preferences preferences, String string) {
        String string2 = preferences.get(string, null);
        if (string2 == null) {
            return PieceOfFurniture.IDENTITY_ROTATION;
        }
        String[] stringArray = string2.split(" ", 9);
        if (stringArray.length != 9) {
            return PieceOfFurniture.IDENTITY_ROTATION;
        }
        try {
            return new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])}, {Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])}, {Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7]), Float.parseFloat(stringArray[8])}};
        }
        catch (NumberFormatException numberFormatException) {
            return PieceOfFurniture.IDENTITY_ROTATION;
        }
    }

    private PreferencesURLContent getContent(Preferences preferences, String string, File file) {
        String string2 = preferences.get(string, null);
        if (string2 != null) {
            try {
                URL uRL;
                String string3 = file.toURI().toURL().toString();
                URL uRL2 = string2.startsWith(string3) || string2.startsWith("jar:" + string3) ? new URL(string2) : new URL(string2.replace("file:", string3));
                PreferencesURLContent preferencesURLContent = new PreferencesURLContent(uRL2);
                if (preferencesURLContent.isJAREntry() ? "file".equals((uRL = preferencesURLContent.getJAREntryURL()).getProtocol()) && !new File(uRL.toURI()).exists() : "file".equals(uRL2.getProtocol()) && !new File(uRL2.toURI()).exists()) {
                    return MISSING_CONTENT;
                }
                return preferencesURLContent;
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return MISSING_CONTENT;
    }

    private void readModifiableTexturesCatalog(Preferences preferences) {
        CatalogTexture catalogTexture;
        File file;
        try {
            file = this.getPreferencesFolder();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        int n = 1;
        while ((catalogTexture = this.readModifiableTexture(preferences, n, file)) != null) {
            if (catalogTexture.getImage() != MISSING_CONTENT) {
                TexturesCategory texturesCategory = this.readModifiableTextureCategory(preferences, n);
                this.getTexturesCatalog().add(texturesCategory, catalogTexture);
            }
            ++n;
        }
    }

    protected CatalogTexture readModifiableTexture(Preferences preferences, int n, File file) {
        String string = preferences.get(TEXTURE_NAME + n, null);
        if (string == null) {
            return null;
        }
        PreferencesURLContent preferencesURLContent = this.getContent(preferences, TEXTURE_IMAGE + n, file);
        float f = preferences.getFloat(TEXTURE_WIDTH + n, 0.1f);
        float f2 = preferences.getFloat(TEXTURE_HEIGHT + n, 0.1f);
        String string2 = preferences.get(TEXTURE_CREATOR + n, null);
        return new CatalogTexture(null, string, preferencesURLContent, f, f2, string2, true);
    }

    protected TexturesCategory readModifiableTextureCategory(Preferences preferences, int n) {
        String string = preferences.get(TEXTURE_CATEGORY + n, "");
        return new TexturesCategory(string);
    }

    @Override
    public void write() throws RecorderException {
        int n;
        Preferences preferences = this.getPreferences();
        this.writeModifiableFurnitureCatalog(preferences);
        this.writeRecentAndModifiableTexturesCatalog(preferences);
        preferences.put(LANGUAGE, this.getLanguage());
        preferences.put(EXTENSIBLE_UNIT, this.getLengthUnit().name());
        String string = this.getCurrency();
        if (string == null) {
            preferences.remove(CURRENCY);
        } else {
            preferences.put(CURRENCY, string);
        }
        preferences.putBoolean(VALUE_ADDED_TAX_ENABLED, this.isValueAddedTaxEnabled());
        BigDecimal bigDecimal = this.getDefaultValueAddedTaxPercentage();
        if (bigDecimal == null) {
            preferences.remove(DEFAULT_VALUE_ADDED_TAX_PERCENTAGE);
        } else {
            preferences.put(DEFAULT_VALUE_ADDED_TAX_PERCENTAGE, bigDecimal.toPlainString());
        }
        preferences.putBoolean(FURNITURE_CATALOG_VIEWED_IN_TREE, this.isFurnitureCatalogViewedInTree());
        preferences.putBoolean(NAVIGATION_PANEL_VISIBLE, this.isNavigationPanelVisible());
        preferences.putBoolean(EDITING_IN_3D_VIEW_ENABLED, this.isEditingIn3DViewEnabled());
        preferences.putBoolean(AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, this.isAerialViewCenteredOnSelectionEnabled());
        preferences.putBoolean(OBSERVER_CAMERA_SELECTED_AT_CHANGE, this.isObserverCameraSelectedAtChange());
        preferences.putBoolean(MAGNETISM_ENABLED, this.isMagnetismEnabled());
        preferences.putBoolean(RULERS_VISIBLE, this.isRulersVisible());
        preferences.putBoolean(GRID_VISIBLE, this.isGridVisible());
        String string2 = this.getDefaultFontName();
        if (string2 == null) {
            preferences.remove(DEFAULT_FONT_NAME);
        } else {
            preferences.put(DEFAULT_FONT_NAME, string2);
        }
        preferences.putBoolean(FURNITURE_VIEWED_FROM_TOP, this.isFurnitureViewedFromTop());
        preferences.putInt(FURNITURE_MODEL_ICON_SIZE, this.getFurnitureModelIconSize());
        preferences.putBoolean(ROOM_FLOOR_COLORED_OR_TEXTURED, this.isRoomFloorColoredOrTextured());
        preferences.put(WALL_PATTERN, this.getWallPattern().getName());
        TextureImage textureImage = this.getNewWallPattern();
        if (textureImage != null) {
            preferences.put(NEW_WALL_PATTERN, textureImage.getName());
        }
        preferences.putFloat(NEW_WALL_THICKNESS, this.getNewWallThickness());
        preferences.putFloat(NEW_WALL_HEIGHT, this.getNewWallHeight());
        preferences.putFloat(NEW_WALL_BASEBOARD_THICKNESS, this.getNewWallBaseboardThickness());
        preferences.putFloat(NEW_WALL_BASEBOARD_HEIGHT, this.getNewWallBaseboardHeight());
        Integer n2 = this.getNewRoomFloorColor();
        if (n2 != null) {
            preferences.put(NEW_ROOM_FLOOR_COLOR, String.format("#%6X", n2 & 0xFFFFFF).replace(' ', '0'));
        } else {
            preferences.remove(NEW_ROOM_FLOOR_COLOR);
        }
        preferences.putFloat(NEW_FLOOR_THICKNESS, this.getNewFloorThickness());
        preferences.putBoolean(CHECK_UPDATES_ENABLED, this.isCheckUpdatesEnabled());
        Long l = this.getUpdatesMinimumDate();
        if (l != null) {
            preferences.putLong(UPDATES_MINIMUM_DATE, l);
        }
        preferences.putInt(AUTO_SAVE_DELAY_FOR_RECOVERY, this.getAutoSaveDelayForRecovery());
        Object object = this.getRecentHomes().iterator();
        for (n = 1; object.hasNext() && n <= this.getRecentHomesMaxCount(); ++n) {
            preferences.put(RECENT_HOMES + n, (String)object.next());
        }
        while (n <= this.getRecentHomesMaxCount()) {
            preferences.remove(RECENT_HOMES + n);
            ++n;
        }
        object = new StringBuilder();
        Iterator<Integer> iterator = this.getRecentColors().iterator();
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            if (i > 0) {
                ((StringBuilder)object).append(",");
            }
            ((StringBuilder)object).append(String.format("#%6X", iterator.next() & 0xFFFFFF).replace(' ', '0'));
        }
        preferences.put(RECENT_COLORS, ((StringBuilder)object).toString());
        n = 1;
        for (Map.Entry<String, Boolean> entry : this.ignoredActionTips.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            preferences.put(IGNORED_ACTION_TIP + n++, entry.getKey());
        }
        while (n <= this.ignoredActionTips.size()) {
            preferences.remove(IGNORED_ACTION_TIP + n);
            ++n;
        }
        n = 1;
        for (String string3 : this.getAutoCompletedProperties()) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator2 = this.getAutoCompletionStrings(string3).iterator();
            for (int i = 0; i < 1000 && iterator2.hasNext(); ++i) {
                String string4 = iterator2.next();
                if (string4.indexOf(44) >= 0 || stringBuilder.length() + string4.length() + 1 > 8192) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string4);
            }
            preferences.put(AUTO_COMPLETION_PROPERTY + n, string3);
            preferences.put(AUTO_COMPLETION_STRINGS + n++, stringBuilder.toString());
        }
        while (preferences.get(AUTO_COMPLETION_PROPERTY + n, null) != null) {
            preferences.remove(AUTO_COMPLETION_PROPERTY + n);
            preferences.remove(AUTO_COMPLETION_STRINGS + n);
            ++n;
        }
        String string4 = this.getPhotoRenderer();
        if (string4 != null) {
            preferences.put(PHOTO_RENDERER, string4);
        } else {
            preferences.remove(PHOTO_RENDERER);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RecorderException("Couldn't write preferences", backingStoreException);
        }
    }

    private void writeModifiableFurnitureCatalog(Preferences preferences) throws RecorderException {
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 1;
        for (FurnitureCategory furnitureCategory : this.getFurnitureCatalog().getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                if (!catalogPieceOfFurniture.isModifiable()) continue;
                preferences.put(FURNITURE_NAME + n, catalogPieceOfFurniture.getName());
                preferences.put(FURNITURE_CATEGORY + n, furnitureCategory.getName());
                this.putContent(preferences, FURNITURE_ICON + n, catalogPieceOfFurniture.getIcon(), FURNITURE_CONTENT_PREFIX, hashSet);
                this.putContent(preferences, FURNITURE_MODEL + n, catalogPieceOfFurniture.getModel(), FURNITURE_CONTENT_PREFIX, hashSet);
                preferences.putFloat(FURNITURE_WIDTH + n, catalogPieceOfFurniture.getWidth());
                preferences.putFloat(FURNITURE_DEPTH + n, catalogPieceOfFurniture.getDepth());
                preferences.putFloat(FURNITURE_HEIGHT + n, catalogPieceOfFurniture.getHeight());
                preferences.putFloat(FURNITURE_ELEVATION + n, catalogPieceOfFurniture.getElevation());
                preferences.putBoolean(FURNITURE_MOVABLE + n, catalogPieceOfFurniture.isMovable());
                preferences.putBoolean(FURNITURE_DOOR_OR_WINDOW + n, catalogPieceOfFurniture.isDoorOrWindow());
                if (catalogPieceOfFurniture.getStaircaseCutOutShape() != null) {
                    preferences.put(FURNITURE_STAIRCASE_CUT_OUT_SHAPE + n, catalogPieceOfFurniture.getStaircaseCutOutShape());
                } else {
                    preferences.remove(FURNITURE_STAIRCASE_CUT_OUT_SHAPE + n);
                }
                if (catalogPieceOfFurniture.getColor() != null) {
                    preferences.put(FURNITURE_COLOR + n, String.valueOf(catalogPieceOfFurniture.getColor()));
                } else {
                    preferences.remove(FURNITURE_COLOR + n);
                }
                float[][] fArray = catalogPieceOfFurniture.getModelRotation();
                preferences.put(FURNITURE_MODEL_ROTATION + n, this.floatToString(fArray[0][0]) + " " + this.floatToString(fArray[0][1]) + " " + this.floatToString(fArray[0][2]) + " " + this.floatToString(fArray[1][0]) + " " + this.floatToString(fArray[1][1]) + " " + this.floatToString(fArray[1][2]) + " " + this.floatToString(fArray[2][0]) + " " + this.floatToString(fArray[2][1]) + " " + this.floatToString(fArray[2][2]));
                preferences.put(FURNITURE_MODEL_FLAGS + n, String.valueOf(catalogPieceOfFurniture.getModelFlags()));
                preferences.putBoolean(FURNITURE_BACK_FACE_SHOWN + n, catalogPieceOfFurniture.isBackFaceShown());
                if (catalogPieceOfFurniture.getModelSize() != null) {
                    preferences.putLong(FURNITURE_MODEL_SIZE + n, catalogPieceOfFurniture.getModelSize());
                } else {
                    preferences.remove(FURNITURE_MODEL_SIZE + n);
                }
                if (catalogPieceOfFurniture.getCreator() != null) {
                    preferences.put(FURNITURE_CREATOR + n, catalogPieceOfFurniture.getCreator());
                } else {
                    preferences.remove(FURNITURE_CREATOR + n);
                }
                preferences.putFloat(FURNITURE_ICON_YAW + n, catalogPieceOfFurniture.getIconYaw());
                preferences.putFloat(FURNITURE_ICON_PITCH + n, catalogPieceOfFurniture.getIconPitch());
                preferences.putFloat(FURNITURE_ICON_SCALE + n, catalogPieceOfFurniture.getIconScale());
                preferences.putBoolean(FURNITURE_PROPORTIONAL + n, catalogPieceOfFurniture.isProportional());
                ++n;
            }
        }
        while (preferences.get(FURNITURE_NAME + n, null) != null) {
            preferences.remove(FURNITURE_NAME + n);
            preferences.remove(FURNITURE_CATEGORY + n);
            preferences.remove(FURNITURE_ICON + n);
            preferences.remove(FURNITURE_MODEL + n);
            preferences.remove(FURNITURE_WIDTH + n);
            preferences.remove(FURNITURE_DEPTH + n);
            preferences.remove(FURNITURE_HEIGHT + n);
            preferences.remove(FURNITURE_ELEVATION + n);
            preferences.remove(FURNITURE_MOVABLE + n);
            preferences.remove(FURNITURE_DOOR_OR_WINDOW + n);
            preferences.remove(FURNITURE_STAIRCASE_CUT_OUT_SHAPE + n);
            preferences.remove(FURNITURE_COLOR + n);
            preferences.remove(FURNITURE_MODEL_ROTATION + n);
            preferences.remove(FURNITURE_MODEL_FLAGS + n);
            preferences.remove(FURNITURE_BACK_FACE_SHOWN + n);
            preferences.remove(FURNITURE_MODEL_SIZE + n);
            preferences.remove(FURNITURE_CREATOR + n);
            preferences.remove(FURNITURE_ICON_YAW + n);
            preferences.remove(FURNITURE_ICON_PITCH + n);
            preferences.remove(FURNITURE_ICON_SCALE + n);
            preferences.remove(FURNITURE_PROPORTIONAL + n);
            ++n;
        }
        this.deleteObsoleteContent(hashSet, FURNITURE_CONTENT_PREFIX);
    }

    private String floatToString(float f) {
        if ((double)Math.abs(f) < 1.0E-6) {
            return "0";
        }
        if ((double)Math.abs(f - 1.0f) < 1.0E-6) {
            return "1";
        }
        if ((double)Math.abs(f + 1.0f) < 1.0E-6) {
            return "-1";
        }
        return String.valueOf(f);
    }

    private void writeRecentAndModifiableTexturesCatalog(Preferences preferences) throws RecorderException {
        HashSet<URL> hashSet = new HashSet<URL>();
        int n = 1;
        for (TextureImage object : this.getRecentTextures()) {
            preferences.put(RECENT_TEXTURE_NAME + n, object.getName());
            this.putContent(preferences, RECENT_TEXTURE_IMAGE + n, object.getImage(), TEXTURE_CONTENT_PREFIX, hashSet);
            if (object.getWidth() != -1.0f) {
                preferences.putFloat(RECENT_TEXTURE_WIDTH + n, object.getWidth());
            } else {
                preferences.remove(RECENT_TEXTURE_WIDTH + n);
            }
            if (object.getHeight() != -1.0f) {
                preferences.putFloat(RECENT_TEXTURE_HEIGHT + n, object.getHeight());
            } else {
                preferences.remove(RECENT_TEXTURE_HEIGHT + n);
            }
            if (object.getCreator() != null) {
                preferences.put(RECENT_TEXTURE_CREATOR + n, object.getCreator());
            } else {
                preferences.remove(RECENT_TEXTURE_CREATOR + n);
            }
            ++n;
        }
        while (preferences.get(RECENT_TEXTURE_NAME + n, null) != null) {
            preferences.remove(RECENT_TEXTURE_NAME + n);
            preferences.remove(RECENT_TEXTURE_IMAGE + n);
            preferences.remove(RECENT_TEXTURE_WIDTH + n);
            preferences.remove(RECENT_TEXTURE_HEIGHT + n);
            preferences.remove(RECENT_TEXTURE_CREATOR + n);
            ++n;
        }
        n = 1;
        for (TexturesCategory texturesCategory : this.getTexturesCatalog().getCategories()) {
            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                if (!catalogTexture.isModifiable()) continue;
                preferences.put(TEXTURE_NAME + n, catalogTexture.getName());
                preferences.put(TEXTURE_CATEGORY + n, texturesCategory.getName());
                this.putContent(preferences, TEXTURE_IMAGE + n, catalogTexture.getImage(), TEXTURE_CONTENT_PREFIX, hashSet);
                preferences.putFloat(TEXTURE_WIDTH + n, catalogTexture.getWidth());
                preferences.putFloat(TEXTURE_HEIGHT + n, catalogTexture.getHeight());
                if (catalogTexture.getCreator() != null) {
                    preferences.put(TEXTURE_CREATOR + n, catalogTexture.getCreator());
                } else {
                    preferences.remove(TEXTURE_CREATOR + n);
                }
                ++n;
            }
        }
        while (preferences.get(TEXTURE_NAME + n, null) != null) {
            preferences.remove(TEXTURE_NAME + n);
            preferences.remove(TEXTURE_CATEGORY + n);
            preferences.remove(TEXTURE_IMAGE + n);
            preferences.remove(TEXTURE_WIDTH + n);
            preferences.remove(TEXTURE_HEIGHT + n);
            preferences.remove(TEXTURE_CREATOR + n);
            ++n;
        }
        this.deleteObsoleteContent(hashSet, TEXTURE_CONTENT_PREFIX);
    }

    private void putContent(Preferences preferences, String string, Content content, String string2, Set<URL> set) throws RecorderException {
        if (content instanceof PreferencesURLContent) {
            PreferencesURLContent preferencesURLContent = (PreferencesURLContent)content;
            try {
                preferences.put(string, preferencesURLContent.getURL().toString().replace(this.getPreferencesFolder().toURI().toURL().toString(), "file:"));
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't save content", iOException);
            }
            if (preferencesURLContent.isJAREntry()) {
                set.add(preferencesURLContent.getJAREntryURL());
            } else {
                set.add(preferencesURLContent.getURL());
            }
        } else {
            PreferencesURLContent preferencesURLContent = this.copiedContentsCache.get(content);
            if (preferencesURLContent == null) {
                if (content instanceof TemporaryURLContent && ((TemporaryURLContent)content).isJAREntry()) {
                    URLContent uRLContent = (URLContent)content;
                    try {
                        PreferencesURLContent preferencesURLContent2 = this.copyToPreferencesURLContent(new URLContent(uRLContent.getJAREntryURL()), string2);
                        preferencesURLContent = new PreferencesURLContent(new URL("jar:" + preferencesURLContent2.getURL() + "!/" + uRLContent.getJAREntryName()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new RecorderException("Can't build URL", malformedURLException);
                    }
                } else {
                    preferencesURLContent = this.copyToPreferencesURLContent(content, string2);
                }
                this.copiedContentsCache.put(content, preferencesURLContent);
            }
            this.putContent(preferences, string, preferencesURLContent, string2, set);
        }
    }

    private PreferencesURLContent copyToPreferencesURLContent(Content content, String string) throws RecorderException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            File file = this.createPreferencesFile(string);
            inputStream = content.openStream();
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            PreferencesURLContent preferencesURLContent = new PreferencesURLContent(file.toURI().toURL());
            return preferencesURLContent;
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save content", iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RecorderException("Can't close files", iOException);
            }
        }
    }

    protected File[] getLanguageLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(LANGUAGE_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected File[] getFurnitureLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(FURNITURE_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected File[] getTexturesLibrariesPluginFolders() {
        try {
            return this.getApplicationSubfolders(TEXTURES_LIBRARIES_PLUGIN_SUB_FOLDER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public File getApplicationFolder() throws IOException {
        File[] fileArray = this.getApplicationFolders();
        if (fileArray.length == 0) {
            throw new IOException("No application folder defined");
        }
        return fileArray[0];
    }

    public File[] getApplicationFolders() throws IOException {
        if (this.applicationFolders != null) {
            return this.applicationFolders;
        }
        return new File[]{OperatingSystem.getDefaultApplicationFolder()};
    }

    public File[] getApplicationSubfolders(String string) throws IOException {
        File[] fileArray = this.getApplicationFolders();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i] = new File(fileArray[i], string);
        }
        return fileArray2;
    }

    private File createPreferencesFile(String string) throws IOException {
        this.checkPreferencesFolder();
        return File.createTempFile(string, ".pref", this.getPreferencesFolder());
    }

    private void checkPreferencesFolder() throws IOException {
        File file = this.getPreferencesFolder();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Couldn't create " + file);
        }
        this.checkPreferencesSubFolder(this.getLanguageLibrariesPluginFolders());
        this.checkPreferencesSubFolder(this.getFurnitureLibrariesPluginFolders());
        this.checkPreferencesSubFolder(this.getTexturesLibrariesPluginFolders());
    }

    private void checkPreferencesSubFolder(File[] fileArray) {
        if (fileArray != null && fileArray.length > 0 && !fileArray[0].exists()) {
            fileArray[0].mkdirs();
        }
    }

    private void deleteObsoleteContent(final Set<URL> set, final String string) throws RecorderException {
        File file;
        try {
            file = this.getPreferencesFolder();
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't access to application folder");
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                try {
                    URL uRL = file.toURI().toURL();
                    return file.getName().startsWith(string) && !set.contains(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                file2.deleteOnExit();
            }
        }
    }

    private File getPreferencesFolder() throws IOException {
        if (this.preferencesFolder != null) {
            return this.preferencesFolder;
        }
        return OperatingSystem.getDefaultApplicationFolder();
    }

    protected Preferences getPreferences() {
        if (this.preferences != null) {
            return this.preferences;
        }
        return Preferences.userNodeForPackage(FileUserPreferences.class);
    }

    @Override
    public void setActionTipIgnored(String string) {
        this.ignoredActionTips.put(string, true);
        super.setActionTipIgnored(string);
    }

    @Override
    public boolean isActionTipIgnored(String string) {
        Boolean bl = this.ignoredActionTips.get(string);
        return bl != null && bl != false;
    }

    @Override
    public void resetIgnoredActionTips() {
        for (Map.Entry<String, Boolean> entry : this.ignoredActionTips.entrySet()) {
            entry.setValue(false);
        }
        super.resetIgnoredActionTips();
    }

    @Override
    public boolean languageLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getLanguageLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to language libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addLanguageLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getLanguageLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to language libraries plugin folder");
            }
            this.copyToLibraryFolder(new File(string), fileArray[0]);
            this.updateSupportedLanguages();
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in language libraries plugin folder", iOException);
        }
    }

    @Override
    public boolean furnitureLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getFurnitureLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to furniture libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addFurnitureLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getFurnitureLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to furniture libraries plugin folder");
            }
            this.copyToLibraryFolder(new File(string), fileArray[0]);
            this.updateFurnitureDefaultCatalog(this.catalogsLoader, this.updater);
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in furniture libraries plugin folder", iOException);
        }
    }

    @Override
    public boolean texturesLibraryExists(String string) throws RecorderException {
        File[] fileArray = this.getTexturesLibrariesPluginFolders();
        if (fileArray == null || fileArray.length == 0) {
            throw new RecorderException("Can't access to textures libraries plugin folder");
        }
        String string2 = new File(string).getName();
        return new File(fileArray[0], string2).exists();
    }

    @Override
    public void addTexturesLibrary(String string) throws RecorderException {
        try {
            File[] fileArray = this.getTexturesLibrariesPluginFolders();
            if (fileArray == null || fileArray.length == 0) {
                throw new RecorderException("Can't access to textures libraries plugin folder");
            }
            this.copyToLibraryFolder(new File(string), fileArray[0]);
            this.updateTexturesDefaultCatalog(this.catalogsLoader, this.updater);
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in textures libraries plugin folder", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToLibraryFolder(File file, File file2) throws IOException {
        String string = file.getName();
        File file3 = new File(file2, string);
        if (file3.exists()) {
            file3.delete();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            file2.mkdirs();
            outputStream = new FileOutputStream(file3);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    public List<Library> getLibraries() {
        return Collections.unmodifiableList(new ArrayList<Library>(this.libraries));
    }

    public void deleteLibraries(List<Library> list) throws RecorderException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Library library : list) {
            if (!new File(library.getLocation()).delete()) {
                throw new RecorderException("Couldn't delete file " + library.getLocation());
            }
            if ("Furniture library".equals(library.getType())) {
                bl = true;
                continue;
            }
            if ("Textures library".equals(library.getType())) {
                bl2 = true;
                continue;
            }
            if (!"Language library".equals(library.getType())) continue;
            bl3 = true;
        }
        if (bl) {
            this.updateFurnitureDefaultCatalog(this.catalogsLoader, this.updater);
        }
        if (bl2) {
            this.updateTexturesDefaultCatalog(this.catalogsLoader, this.updater);
        }
        if (bl3) {
            this.updateSupportedLanguages();
        }
    }

    public boolean isLibraryDeletable(Library library) {
        return new File(library.getLocation()).canWrite();
    }

    static {
        PreferencesURLContent preferencesURLContent = null;
        try {
            preferencesURLContent = new PreferencesURLContent(new URL("file:/missingSweetHome3DContent"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        MISSING_CONTENT = preferencesURLContent;
    }

    private class PortablePreferences
    extends AbstractPreferences {
        private static final String PREFERENCES_FILE = "preferences.xml";
        private Properties preferencesProperties;
        private boolean exist;

        private PortablePreferences() {
            super(null, "");
            this.preferencesProperties = new Properties();
            this.exist = this.readPreferences();
        }

        public boolean exist() {
            return this.exist;
        }

        protected void syncSpi() throws BackingStoreException {
            this.preferencesProperties.clear();
            this.exist = this.readPreferences();
        }

        protected void removeSpi(String string) {
            this.preferencesProperties.remove(string);
        }

        protected void putSpi(String string, String string2) {
            this.preferencesProperties.put(string, string2);
        }

        protected String[] keysSpi() throws BackingStoreException {
            return this.preferencesProperties.keySet().toArray(new String[0]);
        }

        protected String getSpi(String string) {
            return (String)this.preferencesProperties.get(string);
        }

        protected void flushSpi() throws BackingStoreException {
            try {
                this.writePreferences();
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readPreferences() {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(FileUserPreferences.this.getPreferencesFolder(), PREFERENCES_FILE));
                this.preferencesProperties.loadFromXML(inputStream);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        private void writePreferences() throws IOException {
            OutputStream outputStream = null;
            try {
                FileUserPreferences.this.checkPreferencesFolder();
                outputStream = new FileOutputStream(new File(FileUserPreferences.this.getPreferencesFolder(), PREFERENCES_FILE));
                this.preferencesProperties.storeToXML(outputStream, "Portable user preferences 3.0");
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                    this.exist = true;
                }
            }
        }
    }

    private static class PreferencesURLContent
    extends URLContent {
        public PreferencesURLContent(URL uRL) {
            super(uRL);
        }
    }
}

