/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.AbstractPhotoRenderer;
import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJMaterial;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.light.SunSkyLight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YafarayRenderer
extends AbstractPhotoRenderer {
    private static String pluginsFolder;
    private final Object3DFactory object3dFactory;
    private int homeLightColor;
    private boolean useSunSky;
    private boolean useSunskyLight;
    private long environment;
    private long scene;
    private final Map<Selectable, String[]> homeItemsNames = new HashMap<Selectable, String[]>();
    private final Map<AbstractPhotoRenderer.TransparentTextureKey, String> texturesCache = new HashMap<AbstractPhotoRenderer.TransparentTextureKey, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToFolder(File file, File file2) throws IOException {
        File file3 = new File(file2, file.getName());
        file3.deleteOnExit();
        if (!file3.exists()) {
            FileInputStream fileInputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                outputStream = new FileOutputStream(file3);
                byte[] byArray = new byte[8192];
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public YafarayRenderer(Home home, Object3DFactory object3DFactory, AbstractPhotoRenderer.Quality quality) throws IOException {
        super(home, quality);
        if (object3DFactory == null) {
            object3DFactory = new AbstractPhotoRenderer.PhotoObject3DFactory();
        }
        this.object3dFactory = object3DFactory;
    }

    @Override
    public boolean isAvailable() {
        return pluginsFolder != null;
    }

    @Override
    public String getName() {
        return "YafaRay";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void init() throws IOException {
        block21: {
            if (this.environment == 0L) {
                var1_1 = YafarayRenderer.class;
                // MONITORENTER : com.eteks.sweethome3d.j3d.YafarayRenderer.class
                this.environment = this.createEnvironment(YafarayRenderer.pluginsFolder, "disabled");
                // MONITOREXIT : var1_1
            }
            this.scene = this.createScene();
            var1_1 = this.getHome();
            var2_2 = var1_1.getEnvironment();
            this.homeLightColor = var1_1.getEnvironment().getLightColor();
            this.useSunskyLight = var1_1.getCamera() instanceof ObserverCamera == false;
            var3_3 = this.isSilkShaderUsed(this.getQuality());
            var4_4 = var2_2.getSubpartSizeUnderLight();
            var2_2.setSubpartSizeUnderLight(0.0f);
            var5_5 = new ArrayList<HomeLight>();
            var6_6 /* !! */  = var1_1.getSelectableViewableItems().iterator();
            while (true) {
                if (var6_6 /* !! */ .hasNext()) {
                    var7_7 = var6_6 /* !! */ .next();
                    this.checkCurrentThreadIsntInterrupted();
                    if (!(var7_7 instanceof HomeFurnitureGroup)) {
                        var8_8 = (Node)this.object3dFactory.createObject3D((Home)var1_1, var7_7, true);
                        if (var8_8 == null) continue;
                        if (var7_7 instanceof HomeLight) {
                            var10_15 = (HomeLight)var7_7;
                            var5_5.add((HomeLight)var10_15);
                            var9_11 = this.exportNode(var8_8, false, var3_3, var10_15.getPower(), var10_15.getLightSourceMaterialNames());
                        } else {
                            var9_12 = this.exportNode(var8_8, var7_7 instanceof Wall != false || var7_7 instanceof Room != false, var3_3);
                        }
                        this.homeItemsNames.put(var7_7, (String[])var9_13);
                        continue;
                    }
                } else {
                    this.checkCurrentThreadIsntInterrupted();
                    var6_6 /* !! */  = new Ground3D((Home)var1_1, -5000000.0f, -5000000.0f, 1.0E7f, 1.0E7f, true);
                    var7_7 = new Transform3D();
                    var7_7.setTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
                    var8_8 = new TransformGroup((Transform3D)var7_7);
                    var8_8.addChild(var6_6 /* !! */ );
                    this.exportNode(var8_8, true, var3_3);
                    var2_2.setSubpartSizeUnderLight(var4_4);
                    this.checkCurrentThreadIsntInterrupted();
                    var9_14 = new HashMap<String, Object>();
                    var10_15 = var2_2.getSkyTexture();
                    v0 = this.useSunSky = var10_15 == null || this.useSunskyLight != false;
                    if (!this.useSunSky) {
                        var11_16 = var10_15.getImage();
                        var12_18 = var11_16.openStream();
                        var13_19 = ImageIO.read((InputStream)var12_18);
                        var12_18.close();
                        var14_23 = new BufferedImage(var13_19.getWidth(), var13_19.getHeight() * 2, 5);
                        var15_28 = (Graphics2D)var14_23.getGraphics();
                        var16_30 = AffineTransform.getScaleInstance(1.0, -1.0);
                        var16_30.translate((float)var13_19.getWidth() * var10_15.getXOffset(), -2 * var13_19.getHeight());
                        var15_28.drawRenderedImage(var13_19, var16_30);
                        var15_28.drawRenderedImage(var13_19, AffineTransform.getTranslateInstance((float)var13_19.getWidth() * var10_15.getXOffset(), 0.0));
                        var15_28.drawRenderedImage(var13_19, AffineTransform.getTranslateInstance((float)var13_19.getWidth() * (var10_15.getXOffset() - 1.0f), 0.0));
                        var15_28.dispose();
                        var9_14.put("type", "image");
                        var9_14.put("color_space", "sRGB");
                        var9_14.put("width", var14_23.getWidth());
                        var9_14.put("height", var14_23.getHeight());
                        var17_32 = ((DataBufferByte)var14_23.getRaster().getDataBuffer()).getData();
                        var9_14.put("channels", var17_32.length / (var14_23.getWidth() * var14_23.getHeight()));
                        this.createTexture("backgroundImage", var17_32, var9_14);
                        var9_14.put("type", "textureback");
                        var9_14.put("mapping", "sphere");
                        var9_14.put("texture", "backgroundImage");
                        var9_14.put("ibl", false);
                        this.createBackground("background", var9_14);
                    }
                    this.checkCurrentThreadIsntInterrupted();
                    var11_17 = var2_2.getCeillingLightColor();
                    if (var11_17 > 0) {
                        break;
                    }
                    break block21;
                }
                var8_8 = ((HomeFurnitureGroup)var7_7).getAllFurniture().iterator();
                while (true) {
                    if (!var8_8.hasNext()) ** break;
                    var9_10 = (HomePieceOfFurniture)var8_8.next();
                    if (var9_10 instanceof HomeFurnitureGroup || (var10_15 = (Node)this.object3dFactory.createObject3D((Home)var1_1, var9_10, true)) == null) continue;
                    if (var9_10 instanceof HomeLight) {
                        var11_16 = (HomeLight)var9_10;
                        var5_5.add((HomeLight)var11_16);
                        this.homeItemsNames.put(var9_10, this.exportNode((Node)var10_15, false, var3_3, var11_16.getPower(), var11_16.getLightSourceMaterialNames()));
                        continue;
                    }
                    this.homeItemsNames.put(var9_10, this.exportNode((Node)var10_15, false, var3_3));
                }
                break;
            }
            var12_18 = var1_1.getRooms().iterator();
            while (true) {
                block23: {
                    block24: {
                        block22: {
                            if (!var12_18.hasNext()) break block22;
                            var13_21 = var12_18.next();
                            var14_25 = var13_21.getLevel();
                            if (!var13_21.isCeilingVisible() || var14_25 != null && !var14_25.isViewableAndVisible()) continue;
                            var15_29 = var13_21.getXCenter();
                            var16_31 = var13_21.getYCenter();
                            var17_33 = Infinity;
                            var19_34 = var14_25 != null ? var14_25.getElevation() : 0.0f;
                            var20_35 = var19_34 + (var14_25 == null ? var1_1.getWallHeight() : var14_25.getHeight());
                            var21_36 = var1_1.getLevels();
                            if (var14_25 != null && var21_36.indexOf(var14_25) != var21_36.size() - 1) break block23;
                            var22_37 = var1_1.getWalls().iterator();
                            break block24;
                        }
                        this.checkCurrentThreadIsntInterrupted();
                        break;
                    }
                    while (var22_37.hasNext()) {
                        var23_38 = var22_37.next();
                        if (var23_38.getLevel() != null && !var23_38.getLevel().isViewable() || !var23_38.isAtLevel(var14_25)) continue;
                        var24_39 = var23_38.getLevel() == null ? 0.0f : var23_38.getLevel().getElevation();
                        var25_40 = var23_38.getHeight();
                        var26_41 = var23_38.getPoints();
                        for (var27_42 = 0; var27_42 < var26_41.length; ++var27_42) {
                            var28_43 = Point2D.distanceSq(var26_41[var27_42][0], var26_41[var27_42][1], var15_29, var16_31);
                            if (!(var28_43 < var17_33)) continue;
                            var17_33 = var28_43;
                            var20_35 = var27_42 == 0 || var27_42 == var26_41.length - 1 ? (var25_40 != null ? var25_40.floatValue() : var1_1.getWallHeight()) : (var23_38.isTrapezoidal() != false ? var23_38.getHeightAtEnd().floatValue() : (var25_40 != null ? var25_40.floatValue() : var1_1.getWallHeight()));
                            var20_35 += var24_39;
                        }
                    }
                }
                var9_14.clear();
                var9_14.put("type", "spherelight");
                var9_14.put("color", new float[]{(float)(var11_17 >> 16) / 208.0f * (float)(this.homeLightColor >> 16) / 255.0f, (float)(var11_17 >> 8 & 255) / 208.0f * (float)(this.homeLightColor >> 8 & 255) / 255.0f, (float)(var11_17 & 255) / 208.0f * (float)(this.homeLightColor & 255) / 255.0f, 1.0f});
                var9_14.put("power", Math.sqrt(var13_21.getArea()) / 3.0);
                var9_14.put("from", new float[]{var15_29, -var16_31, var20_35 - 25.0f});
                var9_14.put("radius", Float.valueOf(20.0f));
                var9_14.put("samples", 4);
                this.createLight(UUID.randomUUID().toString(), var9_14);
            }
        }
        var12_18 = ModelManager.getInstance();
        var13_22 = var5_5.iterator();
        while (true) {
            if (!var13_22.hasNext()) {
                var9_14.clear();
                var9_14.put("type", "none");
                this.createIntegrator("volintegrator", var9_14);
                return;
            }
            var14_27 = (HomeLight)var13_22.next();
            var15_28 = var14_27.getLevel();
            if (var14_27.getPower() > 0.0f && var14_27.getLightSourceMaterialNames().length == 0 && (var15_28 == null || var15_28.isViewableAndVisible())) {
                if (var14_27.isHorizontallyRotated() || var14_27.getModelTransformations() != null) {
                    var12_18.loadModel(var14_27.getModel(), true, new ModelManager.ModelObserver((ModelManager)var12_18){
                        final /* synthetic */ ModelManager val$modelManager;
                        {
                            this.val$modelManager = modelManager;
                        }

                        public void modelUpdated(BranchGroup branchGroup) {
                            float[][] fArray = var14_27.getModelRotation();
                            Transformation[] transformationArray = var14_27.getModelTransformations();
                            Transform3D transform3D = null;
                            Node node = null;
                            if (transformationArray != null) {
                                node = this.val$modelManager.cloneNode((Node)branchGroup);
                                transform3D = this.val$modelManager.getNormalizedTransform((Node)branchGroup, fArray, 1.0f, var14_27.isModelCenteredAtOrigin());
                                transform3D.invert();
                                YafarayRenderer.this.updateModelTransformations((Node)branchGroup, transformationArray);
                            }
                            Transform3D transform3D2 = this.val$modelManager.getNormalizedTransform((Node)branchGroup, fArray, 1.0f, var14_27.isModelCenteredAtOrigin());
                            TransformGroup transformGroup = new TransformGroup(transform3D2);
                            transformGroup.addChild((Node)branchGroup);
                            Transform3D transform3D3 = this.val$modelManager.getPieceOfFurnitureNormalizedModelTransformation(var14_27, (Node)transformGroup);
                            if (transformationArray != null) {
                                for (LightSource lightSource : var14_27.getLightSources()) {
                                    int n;
                                    for (n = 0; n < transformationArray.length; ++n) {
                                        Transformation transformation = transformationArray[n];
                                        Point3f point3f = YafarayRenderer.this.getNormalizedLightSourceLocation(lightSource);
                                        transform3D.transform(point3f);
                                        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(point3f), (double)YafarayRenderer.this.getLightSourceRadius(var14_27, lightSource));
                                        String string = transformation.getName() + "_transformation";
                                        if (!YafarayRenderer.this.intersectsDeformedNode(node, (Bounds)boundingSphere, string)) continue;
                                        Transform3D transform3D4 = new Transform3D(transform3D3);
                                        transform3D4.mul(transform3D2);
                                        Transform3D transform3D5 = YafarayRenderer.this.getDeformation((Node)branchGroup, new Transform3D(), string);
                                        transform3D4.mul(transform3D5);
                                        transform3D4.mul(transform3D);
                                        YafarayRenderer.this.exportLightSource(var14_27, lightSource, transform3D4);
                                        break;
                                    }
                                    if (n != transformationArray.length) continue;
                                    YafarayRenderer.this.exportLightSource(var14_27, lightSource, transform3D3);
                                }
                            } else {
                                YafarayRenderer.this.exportLightSources(var14_27, transform3D3);
                            }
                        }

                        public void modelError(Exception exception) {
                        }
                    });
                } else {
                    var16_30 = var12_18.getPieceOfFurnitureNormalizedModelTransformation(var14_27, null);
                    this.exportLightSources(var14_27, (Transform3D)var16_30);
                }
            }
            this.checkCurrentThreadIsntInterrupted();
        }
    }

    private void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("Current thread interrupted");
        }
    }

    @Override
    public void render(BufferedImage bufferedImage, Camera camera, List<? extends Selectable> list, ImageObserver imageObserver) throws IOException {
        float f;
        Object object;
        Object object2;
        if (Thread.currentThread().isInterrupted() || !this.isAvailable()) {
            return;
        }
        if (this.scene == 0L) {
            this.init();
        } else if (list != null && !list.isEmpty()) {
            this.clearAll();
            this.homeItemsNames.clear();
            this.texturesCache.clear();
            this.init();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.useSunSky) {
            this.deleteBackground("background");
        }
        this.deleteLight("sun");
        Compass compass = this.getHome().getCompass();
        float[] fArray = this.getSunDirection(compass, Camera.convertTimeToTimeZone(camera.getTime(), compass.getTimeZone()));
        float[] fArray2 = null;
        if (fArray[1] > -0.075f) {
            object2 = new SunSkyLight();
            object = new ParameterList();
            object.addVectors("up", ParameterList.InterpolationType.NONE, new float[]{0.0f, 1.0f, 0.0f});
            object.addVectors("east", ParameterList.InterpolationType.NONE, new float[]{(float)Math.sin(compass.getNorthDirection()), 0.0f, (float)Math.cos(compass.getNorthDirection())});
            object.addVectors("sundir", ParameterList.InterpolationType.NONE, new float[]{fArray[0], fArray[1], fArray[2]});
            object2.update((ParameterList)object, new SunflowAPI());
            fArray2 = object2.getSunColor().getRGB();
            if (this.useSunSky) {
                hashMap.put("type", "sunsky");
                hashMap.put("from", new float[]{fArray[0], -fArray[2], fArray[1]});
                hashMap.put("turbidity", Float.valueOf(6.0f));
                hashMap.put("power", Float.valueOf(1.5f));
                hashMap.put("light_samples", 12);
                hashMap.put("background_light", this.useSunskyLight);
                this.createBackground("background", hashMap);
            }
            f = this.useSunskyLight ? 20.0f : 40.0f;
            hashMap.clear();
            hashMap.put("type", "spherelight");
            hashMap.put("color", new float[]{(float)(this.homeLightColor >> 16) * (float)Math.sqrt(fArray2[0]), (float)(this.homeLightColor >> 8 & 0xFF) * (float)Math.sqrt(fArray2[1]), (float)(this.homeLightColor & 0xFF) * (float)Math.sqrt(fArray2[2]), 1.0f});
            hashMap.put("power", Float.valueOf(f));
            hashMap.put("from", new float[]{1000000.0f * fArray[0], -1000000.0f * fArray[2], 1000000.0f * fArray[1]});
            hashMap.put("radius", Float.valueOf(10000.0f));
            hashMap.put("samples", 4);
            this.createLight("sun", hashMap);
        }
        object2 = this.getRenderingParameterValue("lightingMethod");
        this.deleteIntegrator("integrator");
        hashMap.clear();
        hashMap.put("type", object2);
        hashMap.put("raydepth", 16);
        hashMap.put("shadowDepth", 4);
        hashMap.put("transpShad", true);
        if ("pathtracing".equals(object2)) {
            hashMap.put("bounces", Integer.parseInt(this.getRenderingParameterValue("diffusedBounces")));
        }
        object = new Integer(this.getRenderingParameterValue("causticsPhotons"));
        if ("pathtracing".equals(object2)) {
            hashMap.put("caustic_type", (Integer)object > 0 ? "photon" : "none");
            hashMap.put("photons", object);
        } else {
            hashMap.put("caustics", (Integer)object > 0);
            hashMap.put("photons", object);
        }
        if (!this.useSunskyLight && fArray[1] > -0.075f && "directlighting".equals(object2)) {
            hashMap.put("AO_color", new float[]{(fArray2[1] + fArray2[2]) / 100.0f, (fArray2[0] + fArray2[2]) / 100.0f, (fArray2[0] + fArray2[1]) / 100.0f, 1.0f});
            hashMap.put("AO_distance", Float.valueOf(1.0f));
            hashMap.put("AO_samples", 4);
            hashMap.put("do_AO", true);
        }
        this.createIntegrator("integrator", hashMap);
        f = camera.getYaw();
        float f2 = camera.getLens() == Camera.Lens.SPHERICAL ? 0.0f : camera.getPitch();
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ((double)f);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotX((double)(-f2));
        transform3D.mul(transform3D2);
        Point3f point3f = new Point3f(0.0f, 100.0f, 0.0f);
        transform3D.transform(point3f);
        Point3f point3f2 = new Point3f(0.0f, 0.0f, 100.0f);
        transform3D.transform(point3f2);
        this.deleteCamera("camera");
        hashMap.clear();
        hashMap.put("from", new float[]{camera.getX(), -camera.getY(), camera.getZ()});
        hashMap.put("to", new float[]{camera.getX() + point3f.x, -camera.getY() - point3f.y, camera.getZ() + point3f.z});
        hashMap.put("up", new float[]{camera.getX() + point3f2.x, -camera.getY() - point3f2.y, camera.getZ() + point3f2.z});
        hashMap.put("resx", bufferedImage.getWidth());
        hashMap.put("resy", bufferedImage.getHeight());
        switch (camera.getLens()) {
            case SPHERICAL: {
                hashMap.put("type", "equirectangular");
                break;
            }
            case FISHEYE: {
                hashMap.put("type", "angular");
                hashMap.put("angle", Float.valueOf(90.0f));
                hashMap.put("mirrored", true);
                hashMap.put("projection", "orthographic");
                hashMap.put("circular", true);
                break;
            }
            case NORMAL: {
                hashMap.put("dof_distance", new Float(this.getRenderingParameterValue("normalLens.focusDistance")));
                hashMap.put("aperture", new Float(this.getRenderingParameterValue("normalLens.radius")));
            }
            default: {
                hashMap.put("type", "perspective");
                hashMap.put("focal", Float.valueOf((float)(0.5 / Math.tan((double)camera.getFieldOfView() / 2.0))));
            }
        }
        this.createCamera("camera", hashMap);
        hashMap.clear();
        hashMap.put("width", bufferedImage.getWidth());
        hashMap.put("height", bufferedImage.getHeight());
        hashMap.put("xstart", 0);
        hashMap.put("ystart", 0);
        hashMap.put("filter_type", this.getRenderingParameterValue("filter"));
        if (camera.getLens() == Camera.Lens.NORMAL) {
            hashMap.put("AA_minsamples", Integer.parseInt(this.getRenderingParameterValue("antiAliasingNormalLens.min")));
        } else {
            hashMap.put("AA_minsamples", Integer.parseInt(this.getRenderingParameterValue("antiAliasingOtherLens.min")));
        }
        hashMap.put("color_space", "sRGB");
        hashMap.put("tile_size", 32);
        hashMap.put("camera_name", "camera");
        hashMap.put("integrator_name", "integrator");
        hashMap.put("volintegrator_name", "volintegrator");
        hashMap.put("background_name", "background");
        hashMap.put("adv_auto_shadow_bias_enabled", false);
        hashMap.put("adv_shadow_bias_value", Float.valueOf(0.005f));
        this.render(new BufferedImageOutput(imageObserver, bufferedImage), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        if (this.scene == 0L) return;
        Class<YafarayRenderer> clazz = YafarayRenderer.class;
        synchronized (YafarayRenderer.class) {
            this.abort();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void dispose() {
        this.texturesCache.clear();
    }

    private boolean isSilkShaderUsed(AbstractPhotoRenderer.Quality quality) {
        boolean bl = !this.useSunskyLight && quality == AbstractPhotoRenderer.Quality.HIGH;
        String string = this.getRenderingParameterValue("shininessShader");
        if ("glossy".equals(string)) {
            bl = false;
        } else if ("silk".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private String[] exportNode(Node node, boolean bl, boolean bl2) throws IOException {
        return this.exportNode(node, bl, bl2, 0.0f, null);
    }

    private String[] exportNode(Node node, boolean bl, boolean bl2, float f, String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.exportNode(node, bl, bl2, f, stringArray, arrayList, new Transform3D());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void exportNode(Node node, boolean bl, boolean bl2, float f, String[] stringArray, List<String> list, Transform3D transform3D) throws IOException {
        block21: {
            block22: {
                block20: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block20;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.exportNode((Node)enumeration.nextElement(), bl, bl2, f, stringArray, list, transform3D);
                    }
                    break block21;
                }
                if (!(node instanceof Link)) break block22;
                this.exportNode((Node)((Link)node).getSharedGroup(), bl, bl2, f, stringArray, list, transform3D);
                break block21;
            }
            if (!(node instanceof Shape3D)) break block21;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            boolean bl3 = transparencyAttributes != null && transparencyAttributes.getTransparency() == 1.0f;
            boolean bl4 = false;
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    try {
                        if (!string2.equals(appearance.getName())) continue;
                        bl4 = true;
                        break;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
            }
            if (!(renderingAttributes != null && !renderingAttributes.getVisible() || bl3 && !bl4)) {
                String[] stringArray2;
                String string;
                String string2;
                String string3 = (String)shape3D.getUserData();
                String string4 = UUID.randomUUID().toString();
                String string5 = "default";
                string2 = null;
                Transform3D transform3D2 = new Transform3D();
                int n = 1;
                boolean bl5 = false;
                Color3f color3f = null;
                if (appearance != null) {
                    Material material;
                    PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
                    if (polygonAttributes != null) {
                        n = polygonAttributes.getCullFace();
                        bl5 = polygonAttributes.getBackFaceNormalFlip();
                    }
                    string5 = "material" + string4;
                    if (bl4 && f > 0.0f) {
                        material = appearance.getMaterial();
                        string = new Color3f();
                        if (material != null) {
                            material.getDiffuseColor((Color3f)string);
                        } else {
                            stringArray2 = appearance.getColoringAttributes();
                            if (stringArray2 != null) {
                                stringArray2.getColor((Color3f)string);
                            }
                        }
                        color3f = new Color3f(string.getX() * (float)(this.homeLightColor >> 16), string.getY() * (float)(this.homeLightColor >> 8 & 0xFF), string.getZ() * (float)(this.homeLightColor & 0xFF));
                        if (bl3) {
                            stringArray2 = new HashMap();
                            stringArray2.put("type", "glass");
                            stringArray2.put("visibility", "invisible");
                            this.createMaterial(string5, (Map<String, Object>)stringArray2, new ArrayList<Map<String, Object>>());
                        } else {
                            stringArray2 = new Appearance();
                            stringArray2.setColoringAttributes(new ColoringAttributes((Color3f)string, 3));
                            this.exportAppearance((Appearance)stringArray2, string5, false, false, false, f);
                        }
                        list.add(string5);
                    } else if (!bl3) {
                        string2 = appearance.getTexCoordGeneration();
                        material = appearance.getTextureAttributes();
                        if (material != null) {
                            material.getTextureTransform(transform3D2);
                        }
                        boolean bl6 = string3 != null && string3.startsWith("sweethome3d_window_mirror");
                        this.exportAppearance(appearance, string5, bl6, bl, bl2, -1.0f);
                        list.add(string5);
                    }
                }
                int n2 = shape3D.numGeometries();
                for (int i = 0; i < n2; ++i) {
                    string = "object" + string4 + "-" + i;
                    stringArray2 = this.exportNodeGeometry(shape3D.getGeometry(i), transform3D, (TexCoordGeneration)string2, transform3D2, n, bl5, string, string5, bl3, color3f, f);
                    if (stringArray2 == null) continue;
                    for (String string6 : stringArray2) {
                        list.add(string6);
                    }
                }
            }
        }
    }

    private String[] exportNodeGeometry(Geometry geometry, Transform3D transform3D, TexCoordGeneration texCoordGeneration, Transform3D transform3D2, int n, boolean bl, String string, String string2, boolean bl2, Color3f color3f, float f) {
        if (geometry instanceof GeometryArray) {
            IndexedTriangleStripArray indexedTriangleStripArray;
            GeometryArray geometryArray = (GeometryArray)geometry;
            int[] nArray = null;
            int[] nArray2 = null;
            if (geometryArray instanceof IndexedGeometryArray) {
                if (geometryArray instanceof IndexedLineArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedTriangleArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedQuadArray) {
                    nArray = new int[((IndexedQuadArray)geometryArray).getIndexCount() * 3 / 2];
                } else if (geometryArray instanceof IndexedGeometryStripArray) {
                    indexedTriangleStripArray = (IndexedTriangleStripArray)geometryArray;
                    nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                    indexedTriangleStripArray.getStripIndexCounts(nArray2);
                    nArray = geometryArray instanceof IndexedLineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
                }
            } else if (geometryArray instanceof LineArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof TriangleArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof QuadArray) {
                nArray = new int[((QuadArray)geometryArray).getVertexCount() * 3 / 2];
            } else if (geometryArray instanceof GeometryStripArray) {
                indexedTriangleStripArray = (GeometryStripArray)geometryArray;
                nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                indexedTriangleStripArray.getStripVertexCounts(nArray2);
                nArray = geometryArray instanceof LineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
            }
            if (nArray != null) {
                int n2;
                int n3;
                int[] nArray3;
                int n4;
                int n5;
                int n6;
                boolean bl3 = geometryArray instanceof IndexedLineArray || geometryArray instanceof IndexedLineStripArray || geometryArray instanceof LineArray || geometryArray instanceof LineStripArray;
                float[] fArray = new float[geometryArray.getVertexCount() * 3];
                float[] fArray2 = !bl3 && (geometryArray.getVertexFormat() & 2) != 0 ? new float[geometryArray.getVertexCount() * 3] : null;
                HashSet<AbstractPhotoRenderer.Triangle> hashSet = bl3 ? null : new HashSet<AbstractPhotoRenderer.Triangle>(geometryArray.getVertexCount());
                boolean bl4 = false;
                Vector4f vector4f = null;
                Vector4f vector4f2 = null;
                if (!bl3 && texCoordGeneration != null) {
                    boolean bl5 = bl4 = texCoordGeneration.getGenMode() == 0 && texCoordGeneration.getEnable();
                    if (bl4) {
                        vector4f = new Vector4f();
                        vector4f2 = new Vector4f();
                        texCoordGeneration.getPlaneS(vector4f);
                        texCoordGeneration.getPlaneT(vector4f2);
                    }
                }
                Object object = bl4 || (geometryArray.getVertexFormat() & 0x20) != 0 ? new float[geometryArray.getVertexCount() * 2] : null;
                if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                    Point3f point3f;
                    if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                        float[] fArray3 = geometryArray.getInterleavedVertices();
                        int n7 = fArray3.length / geometryArray.getVertexCount();
                        n6 = 0;
                        n5 = n7 - 3;
                        n4 = geometryArray.getVertexCount();
                        while (n6 < n4) {
                            point3f = new Point3f(fArray3[n5], fArray3[n5 + 1], fArray3[n5 + 2]);
                            this.exportVertex(transform3D, point3f, n6, fArray);
                            ++n6;
                            n5 += n7;
                        }
                        if (fArray2 != null) {
                            n6 = 0;
                            n5 = n7 - 6;
                            n4 = geometryArray.getVertexCount();
                            while (n6 < n4) {
                                point3f = new Vector3f(fArray3[n5], fArray3[n5 + 1], fArray3[n5 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n6, fArray2, bl);
                                ++n6;
                                n5 += n7;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl4) {
                                n6 = 0;
                                n5 = n7 - 3;
                                n4 = geometryArray.getVertexCount();
                                while (n6 < n4) {
                                    point3f = this.generateTextureCoordinates(fArray3[n5], fArray3[n5 + 1], fArray3[n5 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n6, (float[])object);
                                    ++n6;
                                    n5 += n7;
                                }
                            }
                        } else if (object != null) {
                            n6 = 0;
                            n5 = 0;
                            n4 = geometryArray.getVertexCount();
                            while (n6 < n4) {
                                point3f = new TexCoord2f(fArray3[n5], fArray3[n5 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n6, (float[])object);
                                ++n6;
                                n5 += n7;
                            }
                        }
                    } else {
                        float[] fArray4 = geometryArray.getCoordRefFloat();
                        int n8 = 0;
                        int n9 = 0;
                        int n10 = geometryArray.getVertexCount();
                        while (n8 < n10) {
                            Point3f point3f2 = new Point3f(fArray4[n9], fArray4[n9 + 1], fArray4[n9 + 2]);
                            this.exportVertex(transform3D, point3f2, n8, fArray);
                            ++n8;
                            n9 += 3;
                        }
                        if (fArray2 != null) {
                            float[] fArray5 = geometryArray.getNormalRefFloat();
                            n9 = 0;
                            n10 = 0;
                            int n11 = geometryArray.getVertexCount();
                            while (n9 < n11) {
                                point3f = new Vector3f(fArray5[n10], fArray5[n10 + 1], fArray5[n10 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n9, fArray2, bl);
                                ++n9;
                                n10 += 3;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl4) {
                                int n12 = 0;
                                n9 = 0;
                                n10 = geometryArray.getVertexCount();
                                while (n12 < n10) {
                                    TexCoord2f texCoord2f = this.generateTextureCoordinates(fArray4[n9], fArray4[n9 + 1], fArray4[n9 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates(texCoord2f, transform3D2, n12, (float[])object);
                                    ++n12;
                                    n9 += 3;
                                }
                            }
                        } else if (object != null) {
                            float[] fArray6 = geometryArray.getTexCoordRefFloat(0);
                            n9 = 0;
                            n10 = 0;
                            int n13 = geometryArray.getVertexCount();
                            while (n9 < n13) {
                                point3f = new TexCoord2f(fArray6[n10], fArray6[n10 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n9, (float[])object);
                                ++n9;
                                n10 += 2;
                            }
                        }
                    }
                } else {
                    Point3f point3f;
                    int n14;
                    int n15 = geometryArray.getVertexCount();
                    for (n14 = 0; n14 < n15; ++n14) {
                        point3f = new Point3f();
                        geometryArray.getCoordinate(n14, point3f);
                        this.exportVertex(transform3D, point3f, n14, fArray);
                    }
                    if (fArray2 != null) {
                        n15 = geometryArray.getVertexCount();
                        for (n14 = 0; n14 < n15; ++n14) {
                            point3f = new Vector3f();
                            geometryArray.getNormal(n14, (Vector3f)point3f);
                            this.exportNormal(transform3D, (Vector3f)point3f, n14, fArray2, bl);
                        }
                    }
                    if (texCoordGeneration != null) {
                        if (bl4) {
                            n15 = geometryArray.getVertexCount();
                            for (n14 = 0; n14 < n15; ++n14) {
                                point3f = new Point3f();
                                geometryArray.getCoordinate(n14, point3f);
                                TexCoord2f texCoord2f = this.generateTextureCoordinates(point3f.x, point3f.y, point3f.z, vector4f, vector4f2);
                                this.exportTextureCoordinates(texCoord2f, transform3D2, n14, (float[])object);
                            }
                        }
                    } else if (object != null) {
                        n15 = geometryArray.getVertexCount();
                        for (n14 = 0; n14 < n15; ++n14) {
                            point3f = new TexCoord2f();
                            geometryArray.getTextureCoordinate(0, n14, (TexCoord2f)point3f);
                            this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n14, (float[])object);
                        }
                    }
                }
                int[] nArray4 = nArray3 = object != null ? new int[nArray.length] : null;
                if (geometryArray instanceof IndexedGeometryArray) {
                    int n16;
                    int[] nArray5;
                    int[] nArray6 = nArray5 = fArray2 != null ? new int[nArray.length] : null;
                    if (geometryArray instanceof IndexedLineArray) {
                        IndexedLineArray indexedLineArray = (IndexedLineArray)geometryArray;
                        n4 = indexedLineArray.getIndexCount();
                        for (n5 = 0; n5 < n4; n5 += 2) {
                            this.exportIndexedLine((IndexedGeometryArray)indexedLineArray, n5, n5 + 1, nArray, n5);
                        }
                    } else if (geometryArray instanceof IndexedTriangleArray) {
                        IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                        n4 = indexedTriangleArray.getIndexCount();
                        int n17 = 0;
                        for (n5 = 0; n5 < n4; n5 += 3) {
                            n17 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleArray, n5, n5 + 1, n5 + 2, nArray, nArray5, nArray3, n17, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof IndexedQuadArray) {
                        IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                        n4 = indexedQuadArray.getIndexCount();
                        int n18 = 0;
                        for (n5 = 0; n5 < n4; n5 += 4) {
                            n18 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n5, n5 + 1, n5 + 2, nArray, nArray5, nArray3, n18, fArray, hashSet, n);
                            n18 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n5, n5 + 2, n5 + 3, nArray, nArray5, nArray3, n18, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof IndexedLineStripArray) {
                        IndexedLineStripArray indexedLineStripArray = (IndexedLineStripArray)geometryArray;
                        n5 = 0;
                        n4 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n3 = n5;
                            n2 = n5 + nArray2[i] - 1;
                            while (n3 < n2) {
                                this.exportIndexedLine((IndexedGeometryArray)indexedLineStripArray, n3, n3 + 1, nArray, n4);
                                ++n3;
                                n4 += 2;
                            }
                            n5 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleStripArray) {
                        IndexedTriangleStripArray indexedTriangleStripArray2 = (IndexedTriangleStripArray)geometryArray;
                        n5 = 0;
                        n4 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n3 = n5;
                            n2 = n5 + nArray2[i] - 2;
                            n16 = 0;
                            while (n3 < n2) {
                                n4 = n16 % 2 == 0 ? this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n3, n3 + 1, n3 + 2, nArray, nArray5, nArray3, n4, fArray, hashSet, n) : this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n3, n3 + 2, n3 + 1, nArray, nArray5, nArray3, n4, fArray, hashSet, n);
                                ++n3;
                                ++n16;
                            }
                            n5 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleFanArray) {
                        IndexedTriangleFanArray indexedTriangleFanArray = (IndexedTriangleFanArray)geometryArray;
                        n5 = 0;
                        n4 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n2 = n5 + nArray2[i] - 2;
                            for (n3 = n5; n3 < n2; ++n3) {
                                n4 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleFanArray, n5, n3 + 1, n3 + 2, nArray, nArray5, nArray3, n4, fArray, hashSet, n);
                            }
                            n5 += nArray2[i];
                        }
                    }
                    if (nArray5 != null && !Arrays.equals(nArray, nArray5)) {
                        float[] fArray7 = new float[nArray.length * 3];
                        float[] fArray8 = nArray5 != null ? new float[nArray.length * 3] : null;
                        float[] fArray9 = nArray3 != null ? new float[nArray.length * 2] : null;
                        int n19 = 0;
                        n3 = 0;
                        n2 = 0;
                        for (n16 = 0; n16 < nArray.length; ++n16) {
                            int n20 = nArray[n16] * 3;
                            fArray7[n19++] = fArray[n20++];
                            fArray7[n19++] = fArray[n20++];
                            fArray7[n19++] = fArray[n20++];
                            if (nArray5 != null) {
                                n20 = nArray5[n16] * 3;
                                fArray8[n3++] = fArray2[n20++];
                                fArray8[n3++] = fArray2[n20++];
                                fArray8[n3++] = fArray2[n20++];
                            }
                            if (nArray3 != null) {
                                n20 = nArray3[n16] * 2;
                                fArray9[n2++] = object[n20++];
                                fArray9[n2++] = object[n20++];
                                nArray3[n16] = n16;
                            }
                            nArray[n16] = n16;
                        }
                        fArray = fArray7;
                        fArray2 = fArray8;
                        object = fArray9;
                    }
                } else {
                    if (geometryArray instanceof LineArray) {
                        LineArray lineArray = (LineArray)geometryArray;
                        n5 = lineArray.getVertexCount();
                        for (n6 = 0; n6 < n5; n6 += 2) {
                            this.exportLine((GeometryArray)lineArray, n6, n6 + 1, nArray, n6);
                        }
                    } else if (geometryArray instanceof TriangleArray) {
                        TriangleArray triangleArray = (TriangleArray)geometryArray;
                        n5 = triangleArray.getVertexCount();
                        n4 = 0;
                        for (n6 = 0; n6 < n5; n6 += 3) {
                            n4 = this.exportTriangle((GeometryArray)triangleArray, n6, n6 + 1, n6 + 2, nArray, n4, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof QuadArray) {
                        QuadArray quadArray = (QuadArray)geometryArray;
                        n5 = quadArray.getVertexCount();
                        n4 = 0;
                        for (n6 = 0; n6 < n5; n6 += 4) {
                            n4 = this.exportTriangle((GeometryArray)quadArray, n6, n6 + 1, n6 + 2, nArray, n4, fArray, hashSet, n);
                            n4 = this.exportTriangle((GeometryArray)quadArray, n6 + 2, n6 + 3, n6, nArray, n4, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof LineStripArray) {
                        LineStripArray lineStripArray = (LineStripArray)geometryArray;
                        n6 = 0;
                        n5 = 0;
                        for (n4 = 0; n4 < nArray2.length; ++n4) {
                            int n21 = n6;
                            n3 = n6 + nArray2[n4] - 1;
                            while (n21 < n3) {
                                this.exportLine((GeometryArray)lineStripArray, n21, n21 + 1, nArray, n5);
                                ++n21;
                                n5 += 2;
                            }
                            n6 += nArray2[n4];
                        }
                    } else if (geometryArray instanceof TriangleStripArray) {
                        TriangleStripArray triangleStripArray = (TriangleStripArray)geometryArray;
                        n6 = 0;
                        n5 = 0;
                        for (n4 = 0; n4 < nArray2.length; ++n4) {
                            int n22 = n6;
                            n3 = n6 + nArray2[n4] - 2;
                            n2 = 0;
                            while (n22 < n3) {
                                n5 = n2 % 2 == 0 ? this.exportTriangle((GeometryArray)triangleStripArray, n22, n22 + 1, n22 + 2, nArray, n5, fArray, hashSet, n) : this.exportTriangle((GeometryArray)triangleStripArray, n22, n22 + 2, n22 + 1, nArray, n5, fArray, hashSet, n);
                                ++n22;
                                ++n2;
                            }
                            n6 += nArray2[n4];
                        }
                    } else if (geometryArray instanceof TriangleFanArray) {
                        TriangleFanArray triangleFanArray = (TriangleFanArray)geometryArray;
                        n6 = 0;
                        n5 = 0;
                        for (n4 = 0; n4 < nArray2.length; ++n4) {
                            n3 = n6 + nArray2[n4] - 2;
                            for (int i = n6; i < n3; ++i) {
                                n5 = this.exportTriangle((GeometryArray)triangleFanArray, n6, i + 1, i + 2, nArray, n5, fArray, hashSet, n);
                            }
                            n6 += nArray2[n4];
                        }
                    }
                    if (nArray3 != null) {
                        for (int i = 0; i < nArray3.length; ++i) {
                            nArray3[i] = nArray[i];
                        }
                    }
                }
                if (bl3) {
                    if (!bl2) {
                        float[] fArray10 = new float[nArray.length * 3];
                        int n23 = 0;
                        int n24 = 0;
                        while (n23 < nArray.length) {
                            int n25 = 3 * nArray[n23];
                            int n26 = 3 * nArray[n23 + 1];
                            Vector3f vector3f = new Vector3f(fArray[n26] - fArray[n25], fArray[n26 + 1] - fArray[n25 + 1], fArray[n26 + 2] - fArray[n25 + 2]);
                            Vector3f vector3f2 = vector3f.z == 0.0f ? new Vector3f(-vector3f.y, vector3f.x, 0.0f) : (vector3f.y == 0.0f ? new Vector3f(-vector3f.z, 0.0f, vector3f.x) : new Vector3f(-vector3f.y, vector3f.z, 0.0f));
                            vector3f2.normalize();
                            vector3f2.scale(0.15f);
                            fArray10[n24] = fArray[n25] + vector3f2.x;
                            fArray10[n24 + 1] = fArray[n25 + 1] + vector3f2.y;
                            fArray10[n24 + 2] = fArray[n25 + 2] + vector3f2.z;
                            fArray10[n24 + 3] = fArray[n26] + vector3f2.x;
                            fArray10[n24 + 4] = fArray[n26 + 1] + vector3f2.y;
                            fArray10[n24 + 5] = fArray[n26 + 2] + vector3f2.z;
                            n23 += 2;
                            n24 += 6;
                        }
                        this.startGeometry();
                        n23 = fArray.length / 3;
                        this.startTriMesh(-1L, n23 + nArray.length, nArray.length, false, false, 0, 0);
                        for (n24 = 0; n24 < fArray.length; n24 += 3) {
                            this.addVertex(fArray[n24], fArray[n24 + 1], fArray[n24 + 2]);
                        }
                        for (n24 = 0; n24 < fArray10.length; n24 += 3) {
                            this.addVertex(fArray10[n24], fArray10[n24 + 1], fArray10[n24 + 2]);
                        }
                        for (n24 = 0; n24 < nArray.length; n24 += 2) {
                            this.addTriangle(n23 + n24, n23 + n24 + 1, nArray[n24], string2);
                            this.addTriangle(nArray[n24], nArray[n24 + 1], n23 + n24 + 1, string2);
                        }
                        this.endTriMesh();
                        this.endGeometry();
                        this.startGeometry();
                        this.smoothMesh(0L, 180.0f);
                        this.endGeometry();
                        return new String[]{string};
                    }
                } else {
                    if (color3f != null) {
                        this.startGeometry();
                        long l = this.startTriMesh(-1L, fArray.length / 3, nArray.length / 3, false, false, 0, 0);
                        this.addTriangles(fArray, null, null, nArray, null, string2);
                        this.endTriMesh();
                        this.endGeometry();
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("type", "meshlight");
                        hashMap.put("object", l);
                        hashMap.put("color", new float[]{color3f.getX(), color3f.getY(), color3f.getZ(), 1.0f});
                        hashMap.put("power", Float.valueOf(10.0f * f * f));
                        hashMap.put("samples", 64);
                        this.createLight(string, hashMap);
                        return new String[]{string};
                    }
                    if (!bl2) {
                        boolean bl6;
                        boolean bl7 = bl6 = fArray2 != null;
                        if (fArray2 != null) {
                            for (float f2 : fArray2) {
                                if (!Float.isNaN(f2)) continue;
                                bl6 = false;
                                break;
                            }
                        }
                        this.startGeometry();
                        this.startTriMesh(-1L, fArray.length / 3, nArray.length / 3, false, object != null, 0, 0);
                        this.addTriangles(fArray, fArray2, (float[])object, nArray, nArray, string2);
                        this.endTriMesh();
                        this.endGeometry();
                        if (!bl6) {
                            this.startGeometry();
                            this.smoothMesh(0L, 90.0f);
                            this.endGeometry();
                        }
                        return new String[]{string};
                    }
                }
            }
        }
        return null;
    }

    @Override
    void exportVertex(Transform3D transform3D, Point3f point3f, int n, float[] fArray) {
        transform3D.transform(point3f);
        n *= 3;
        fArray[n++] = point3f.x;
        fArray[n++] = -point3f.z;
        fArray[n] = point3f.y;
    }

    @Override
    void exportNormal(Transform3D transform3D, Vector3f vector3f, int n, float[] fArray, boolean bl) {
        if (bl) {
            vector3f.negate();
        }
        transform3D.transform(vector3f);
        int n2 = n * 3;
        fArray[n2++] = vector3f.x;
        fArray[n2++] = -vector3f.z;
        fArray[n2] = vector3f.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportAppearance(Appearance appearance, String string, boolean bl, boolean bl2, boolean bl3, float f) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Texture texture = appearance.getTexture();
        if (bl) {
            hashMap.put("type", "shinydiffusemat");
            Material material = appearance.getMaterial();
            Color3f color3f = new Color3f(0.9f, 0.9f, 0.9f);
            if (material != null) {
                material.getDiffuseColor(color3f);
            }
            hashMap.put("mirror_color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
            hashMap.put("specular_reflect", Float.valueOf(1.0f));
            this.createMaterial(string, hashMap, new ArrayList<Map<String, Object>>());
        } else if (texture != null) {
            HashMap<String, Object> hashMap2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            float f2 = transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2 ? 1.0f - transparencyAttributes.getTransparency() : 1.0f;
            AbstractPhotoRenderer.TransparentTextureKey transparentTextureKey = new AbstractPhotoRenderer.TransparentTextureKey(texture, f2);
            String string2 = this.texturesCache.get(transparentTextureKey);
            if (string2 == null) {
                Object object5;
                Object object6;
                string2 = "texture-" + string;
                if (texture.getUserData() instanceof URL && f2 == 1.0f) {
                    object4 = (URL)texture.getUserData();
                    object6 = new URLContent((URL)object4);
                    object3 = null;
                    try {
                        object3 = ((URLContent)object6).openStream();
                        object5 = ImageIO.read((InputStream)object3);
                        if (((BufferedImage)object5).getTransparency() != 1) {
                            string2 = "transparent-" + string2;
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                    if (((BufferedImage)object5).getType() != 6 && ((BufferedImage)object5).getType() != 5 && ((BufferedImage)object5).getType() != 10) {
                        object2 = new BufferedImage(((BufferedImage)object5).getWidth(), ((BufferedImage)object5).getHeight(), ((BufferedImage)object5).getTransparency() != 1 ? 6 : 5);
                        object = (Graphics2D)((BufferedImage)object2).getGraphics();
                        ((Graphics2D)object).drawRenderedImage((RenderedImage)object5, null);
                        ((Graphics)object).dispose();
                        object5 = object2;
                    }
                } else {
                    object4 = (ImageComponent2D)texture.getImage(0);
                    object6 = object4.getRenderedImage();
                    object5 = new BufferedImage(object6.getWidth(), object6.getHeight(), f2 < 1.0f || object6.getColorModel().hasAlpha() ? 6 : 5);
                    object3 = (Graphics2D)((BufferedImage)object5).getGraphics();
                    if (f2 < 1.0f) {
                        ((Graphics2D)object3).setComposite(AlphaComposite.getInstance(3, f2));
                    }
                    ((Graphics2D)object3).drawRenderedImage((RenderedImage)object6, null);
                    ((Graphics)object3).dispose();
                    if (((BufferedImage)object5).getColorModel().hasAlpha()) {
                        string2 = "transparent-" + string2;
                    }
                }
                hashMap.put("type", "image");
                hashMap.put("color_space", "sRGB");
                hashMap.put("width", ((BufferedImage)object5).getWidth());
                hashMap.put("height", ((BufferedImage)object5).getHeight());
                object4 = ((DataBufferByte)((BufferedImage)object5).getRaster().getDataBuffer()).getData();
                hashMap.put("channels", ((Material)object4).length / (((BufferedImage)object5).getWidth() * ((BufferedImage)object5).getHeight()));
                this.checkCurrentThreadIsntInterrupted();
                this.createTexture(string2, (byte[])object4, hashMap);
                this.texturesCache.put(transparentTextureKey, string2);
            }
            hashMap.clear();
            hashMap.put("type", "shinydiffusemat");
            boolean bl4 = string2.startsWith("transparent-");
            object4 = appearance.getMaterial();
            object3 = string;
            if (object4 != null) {
                float f3;
                float f4 = object4.getShininess();
                if (f3 > 1.0f && !bl4) {
                    if (bl3) {
                        object2 = new HashMap();
                        ((HashMap)object2).put("type", "glossy");
                        ((HashMap)object2).put("glossy_reflect", Float.valueOf(f4 /= 128.0f));
                        this.createMaterial(string + "-glossy", (Map<String, Object>)object2, (List<Map<String, Object>>)new ArrayList<Map<String, Object>>());
                        object3 = (String)object3 + "-diffuse";
                    } else {
                        hashMap.put("specular_reflect", Float.valueOf(f4 /= 512.0f));
                        hashMap.put("mirror_color", new float[]{f4, f4, f4, 1.0f});
                    }
                }
            }
            hashMap.put("diffuse_shader", "diffuse_layer");
            object2 = new HashMap<String, Object>();
            object2.put("element", "shader_node");
            object2.put("name", "diffuse_layer");
            object2.put("type", "layer");
            object2.put("input", "textureMap");
            object = new HashMap<String, String>();
            object.put("element", "shader_node");
            object.put("name", "textureMap");
            object.put("type", "texture_mapper");
            object.put("texco", "uv");
            object.put("texture", string2);
            if (bl4) {
                hashMap.put("transparency_shader", "transparency_layer");
                object2.put("upper_color", new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                hashMap2 = new HashMap();
                hashMap2.put("element", "shader_node");
                hashMap2.put("name", "transparency_layer");
                hashMap2.put("type", "layer");
                hashMap2.put("input", "transparencyMap");
                hashMap2.put("negative", true);
                hashMap2.put("use_alpha", true);
                hashMap2.put("do_scalar", true);
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                hashMap3.put("element", "shader_node");
                hashMap3.put("name", "transparencyMap");
                hashMap3.put("type", "texture_mapper");
                hashMap3.put("texco", "uv");
                hashMap3.put("texture", string2);
                this.createMaterial((String)object3, hashMap, Arrays.asList(object2, object, hashMap2, hashMap3));
            } else {
                this.createMaterial((String)object3, hashMap, Arrays.asList(object2, object));
            }
            if (!string.equals(object3)) {
                hashMap2 = new HashMap<String, Object>();
                hashMap2.put("type", "blend_mat");
                hashMap2.put("material1", string + "-diffuse");
                hashMap2.put("material2", string + "-glossy");
                this.createMaterial(string, hashMap2, new ArrayList<Map<String, Object>>());
            }
        } else {
            Material material = appearance.getMaterial();
            if (material != null) {
                Color3f color3f = new Color3f();
                material.getDiffuseColor(color3f);
                TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
                if (transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2) {
                    float f5;
                    if (material instanceof OBJMaterial && ((OBJMaterial)material).isOpticalDensitySet()) {
                        f5 = ((OBJMaterial)material).getOpticalDensity();
                        hashMap.put("IOR", Float.valueOf(f5 <= 1.0f ? 1.55f : f5));
                    } else {
                        hashMap.put("IOR", Float.valueOf(1.55f));
                    }
                    f5 = 1.0f - transparencyAttributes.getTransparency();
                    hashMap.put("type", "glass");
                    hashMap.put("fake_shadows", true);
                    hashMap.put("filter_color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                    hashMap.put("transmit_filter", Float.valueOf(f5));
                } else if (material.getLightingEnable()) {
                    float f6 = material.getShininess();
                    if (f6 > 1.0f) {
                        if (bl3) {
                            hashMap.put("diffuse_color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                            hashMap.put("diffuse_reflect", Float.valueOf(1.5f));
                            material.getSpecularColor(color3f);
                            hashMap.put("color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                            hashMap.put("glossy_reflect", Float.valueOf(f6 / 256.0f));
                            hashMap.put("exponent", Float.valueOf(100.0f));
                            hashMap.put("type", "glossy");
                        } else {
                            hashMap.put("color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                            hashMap.put("specular_reflect", Float.valueOf(f6 / 512.0f));
                            hashMap.put("mirror_color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                            hashMap.put("type", "shinydiffusemat");
                        }
                    } else {
                        hashMap.put("color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                        hashMap.put("type", "shinydiffusemat");
                    }
                } else {
                    hashMap.put("type", "light_mat");
                    hashMap.put("color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                    if (f >= 0.0f) {
                        hashMap.put("power", Float.valueOf(f * 100.0f));
                    }
                }
                this.createMaterial(string, hashMap, new ArrayList<Map<String, Object>>());
            } else {
                hashMap.put("type", "light_mat");
                ColoringAttributes coloringAttributes = appearance.getColoringAttributes();
                if (coloringAttributes != null) {
                    Color3f color3f = new Color3f();
                    coloringAttributes.getColor(color3f);
                    hashMap.put("color", new float[]{color3f.x, color3f.y, color3f.z, 1.0f});
                } else {
                    hashMap.put("color", new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                }
                if (f >= 0.0f) {
                    hashMap.put("power", Float.valueOf(f * 100.0f));
                }
                this.createMaterial(string, hashMap, new ArrayList<Map<String, Object>>());
            }
        }
    }

    private void exportLightSources(HomeLight homeLight, Transform3D transform3D) {
        for (LightSource lightSource : homeLight.getLightSources()) {
            this.exportLightSource(homeLight, lightSource, transform3D);
        }
    }

    private void exportLightSource(HomeLight homeLight, LightSource lightSource, Transform3D transform3D) {
        float f = homeLight.getPower();
        float f2 = this.getLightSourceRadius(homeLight, lightSource);
        float f3 = 5.0f * f * f / (f2 * f2);
        int n = lightSource.getColor();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", "spherelight");
        hashMap.put("color", new float[]{(n >> 16) * (this.homeLightColor >> 16), (n >> 8 & 0xFF) * (this.homeLightColor >> 8 & 0xFF), (n & 0xFF) * (this.homeLightColor & 0xFF), 1.0f});
        hashMap.put("power", Float.valueOf(f3));
        Point3f point3f = this.getNormalizedLightSourceLocation(lightSource);
        transform3D.transform(point3f);
        hashMap.put("from", new float[]{point3f.getX(), -point3f.getZ(), point3f.getY()});
        hashMap.put("radius", Float.valueOf(f2));
        hashMap.put("samples", 4);
        this.createLight(UUID.randomUUID().toString(), hashMap);
    }

    private float getLightSourceRadius(HomeLight homeLight, LightSource lightSource) {
        return lightSource.getDiameter() != null ? lightSource.getDiameter().floatValue() * homeLight.getWidth() / 2.0f : 3.25f;
    }

    private Point3f getNormalizedLightSourceLocation(LightSource lightSource) {
        return new Point3f(lightSource.getX() - 0.5f, lightSource.getZ() - 0.5f, 0.5f - lightSource.getY());
    }

    private native long createEnvironment(String var1, String var2);

    private native void createMaterial(String var1, Map<String, Object> var2, List<Map<String, Object>> var3);

    private native void createTexture(String var1, byte[] var2, Map<String, Object> var3);

    private native void createLight(String var1, Map<String, Object> var2);

    private native boolean deleteLight(String var1);

    private native void createBackground(String var1, Map<String, Object> var2);

    private native boolean deleteBackground(String var1);

    private native void createCamera(String var1, Map<String, Object> var2);

    private native boolean deleteCamera(String var1);

    private native void createIntegrator(String var1, Map<String, Object> var2);

    private native boolean deleteIntegrator(String var1);

    private native long createScene();

    private native void abort();

    private native void clearAll();

    private native void startGeometry();

    private native void endGeometry();

    private native long startTriMesh(long var1, int var3, int var4, boolean var5, boolean var6, int var7, int var8);

    private native void endTriMesh();

    private native void addVertex(float var1, float var2, float var3);

    private native void addNormal(float var1, float var2, float var3);

    private native void addUV(float var1, float var2);

    private native void addTriangle(int var1, int var2, int var3, String var4);

    private native void addTriangle(int var1, int var2, int var3, int var4, int var5, int var6, String var7);

    private native void addTriangles(float[] var1, float[] var2, float[] var3, int[] var4, int[] var5, String var6);

    private native void smoothMesh(long var1, float var3);

    private native void render(ImageOutput var1, Map<String, Object> var2);

    protected native void finalize();

    static {
        try {
            pluginsFolder = System.getProperty("com.eteks.sweethome3d.j3d.YafarayPluginsFolder");
            String string = null;
            if (pluginsFolder == null) {
                String string2;
                Object object;
                String string3 = System.getProperty("java.library.path", "");
                String[] stringArray = string3.split(System.getProperty("path.separator"));
                block4: for (int i = 0; i < stringArray.length && pluginsFolder == null; ++i) {
                    object = new File(stringArray[i]).listFiles();
                    if (object == null) continue;
                    for (File file : object) {
                        if (file.isDirectory() || file.getName().indexOf("yafaray") < 0) continue;
                        pluginsFolder = new File(stringArray[i], "yafaray-plugins").getAbsolutePath();
                        string = new File(pluginsFolder).getParent();
                        continue block4;
                    }
                }
                if (string != null && OperatingSystem.isWindows() && !Charset.forName("US-ASCII").newEncoder().canEncode(string) && "file".equals(((URL)(object = new URL((string2 = YafarayRenderer.class.getResource(YafarayRenderer.class.getSimpleName() + ".class").getFile()).substring(0, string2.indexOf("!/"))))).getProtocol())) {
                    File file;
                    File file2 = new File(((URL)object).toURI());
                    long l = file2.lastModified();
                    long l2 = file2.length();
                    if (l != 0L && l2 != 0L) {
                        File[] fileArray = new File(System.getProperty("java.io.tmpdir"));
                        file = new File((File)fileArray, "sweethome3d-cache-yafaray-plugins-" + System.getProperty("sun.arch.data.model") + "-" + l2 + "-" + l / 1000L);
                        if (!file.exists() && !file.mkdirs()) {
                            file = null;
                        }
                    } else {
                        file = File.createTempFile("yafaray-plugins", "tmp");
                        file.delete();
                        if (!file.mkdirs()) {
                            file = null;
                        }
                    }
                    if (file != null) {
                        file.deleteOnExit();
                        for (File file3 : new File(pluginsFolder).listFiles()) {
                            if (file3.isDirectory()) continue;
                            YafarayRenderer.copyFileToFolder(file3, file);
                        }
                        pluginsFolder = file.getAbsolutePath();
                    } else {
                        pluginsFolder = null;
                        System.err.println("Couldn't extract YafaRay plugins");
                    }
                }
            } else {
                string = new File(pluginsFolder).getParent();
            }
            if (pluginsFolder != null) {
                if (OperatingSystem.isWindows()) {
                    System.load(string + "\\libwinpthread-1.dll");
                    System.load(string + ("64".equals(System.getProperty("sun.arch.data.model")) ? "\\libgcc_s_seh-1.dll" : "\\libgcc_s_dw2-1.dll"));
                    System.load(string + "\\libstdc++-6.dll");
                    System.load(string + "\\libyafaray_v3_core.dll");
                    System.load(string + "\\libyafarayjni.dll");
                } else {
                    System.loadLibrary("yafaray_v3_core");
                    System.loadLibrary("yafarayjni");
                }
            } else {
                System.err.println("Couldn't locate YafaRay library");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            pluginsFolder = null;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (IOException iOException) {
            pluginsFolder = null;
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            pluginsFolder = null;
            uRISyntaxException.printStackTrace();
        }
    }

    private static interface ImageOutput {
        public void setPixel(int var1, int var2, float var3, float var4, float var5, float var6, boolean var7);

        public void flushArea(int var1, int var2, int var3, int var4);

        public void flush();

        public void highlightArea(int var1, int var2, int var3, int var4);
    }

    private static final class BufferedImageOutput
    implements ImageOutput {
        private static final int BASE_INFO_FLAGS = 7;
        private static final int[] BORDERS = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.YELLOW.getRGB(), Color.CYAN.getRGB(), Color.MAGENTA.getRGB(), new Color(1.0f, 0.5f, 0.0f).getRGB(), new Color(0.5f, 1.0f, 0.0f).getRGB()};
        private final ImageObserver observer;
        private final BufferedImage image;
        private int areaNumber;

        private BufferedImageOutput(ImageObserver imageObserver, BufferedImage bufferedImage) {
            this.observer = imageObserver;
            this.image = bufferedImage;
        }

        public void setPixel(int n, int n2, float f, float f2, float f3, float f4, boolean bl) {
            this.image.setRGB(n, n2, new Color(Math.min(1.0f, f), Math.min(1.0f, f2), Math.min(1.0f, f3), f4).getRGB());
        }

        public void flushArea(int n, int n2, int n3, int n4) {
            this.notifyObserver(15, n, n2, n3 - n, n4 - n2);
        }

        public void flush() {
            this.notifyObserver(23, 0, 0, this.image.getWidth(), this.image.getHeight());
        }

        public void highlightArea(int n, int n2, int n3, int n4) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            int n7 = BORDERS[this.areaNumber++ % BORDERS.length] | 0xFF000000;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    if (j < 2 || j > n5 - 3) {
                        if (5 * i >= n6 && 5 * (n6 - i - 1) >= n6) continue;
                        this.image.setRGB(n + j, n2 + i, n7);
                        continue;
                    }
                    if (i >= 2 && i <= n6 - 3 || 5 * j >= n5 && 5 * (n5 - j - 1) >= n5) continue;
                    this.image.setRGB(n + j, n2 + i, n7);
                }
            }
            this.notifyObserver(15, n, n2, n5, n6);
        }

        private void notifyObserver(final int n, final int n2, final int n3, final int n4, final int n5) {
            if (this.observer != null) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BufferedImageOutput.this.observer.imageUpdate(BufferedImageOutput.this.image, n, n2, n3, n4, n5);
                    }
                });
            }
        }
    }
}

