/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DimensionLine
extends HomeObject
implements Selectable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private float xStart;
    private float yStart;
    private float elevationStart;
    private float xEnd;
    private float yEnd;
    private float elevationEnd;
    private float offset;
    private float endMarkSize;
    private float pitch;
    private TextStyle lengthStyle;
    private Integer color;
    private boolean visibleIn3D;
    private Level level;
    private transient Shape shapeCache;

    public DimensionLine(float f, float f2, float f3, float f4, float f5) {
        this(f, f2, 0.0f, f3, f4, 0.0f, f5);
    }

    public DimensionLine(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this(DimensionLine.createId("dimensionLine"), f, f2, f3, f4, f5, f6, f7);
    }

    public DimensionLine(String string, float f, float f2, float f3, float f4, float f5) {
        this(string, f, f2, 0.0f, f3, f4, 0.0f, f5);
    }

    public DimensionLine(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        super(string);
        this.xStart = f;
        this.yStart = f2;
        this.elevationStart = f3;
        this.xEnd = f4;
        this.yEnd = f5;
        this.elevationEnd = f6;
        this.offset = f7;
        this.endMarkSize = 10.0f;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.endMarkSize = 10.0f;
        objectInputStream.defaultReadObject();
    }

    public float getXStart() {
        return this.xStart;
    }

    public void setXStart(float f) {
        if (f != this.xStart) {
            float f2 = this.xStart;
            this.xStart = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.X_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYStart() {
        return this.yStart;
    }

    public void setYStart(float f) {
        if (f != this.yStart) {
            float f2 = this.yStart;
            this.yStart = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.Y_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getElevationStart() {
        return this.elevationStart;
    }

    public void setElevationStart(float f) {
        if (f != this.elevationStart) {
            float f2 = this.elevationStart;
            this.elevationStart = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.ELEVATION_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getXEnd() {
        return this.xEnd;
    }

    public void setXEnd(float f) {
        if (f != this.xEnd) {
            float f2 = this.xEnd;
            this.xEnd = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.X_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYEnd() {
        return this.yEnd;
    }

    public void setYEnd(float f) {
        if (f != this.yEnd) {
            float f2 = this.yEnd;
            this.yEnd = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.Y_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getElevationEnd() {
        return this.elevationEnd;
    }

    public void setElevationEnd(float f) {
        if (f != this.elevationEnd) {
            float f2 = this.elevationEnd;
            this.elevationEnd = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.ELEVATION_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isElevationDimensionLine() {
        return this.xStart == this.xEnd && this.yStart == this.yEnd && this.elevationStart != this.elevationEnd;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float f) {
        if (f != this.offset) {
            float f2 = this.offset;
            this.offset = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.OFFSET.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f) {
        if (f != this.pitch) {
            float f2 = this.pitch;
            this.pitch = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.PITCH.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getLength() {
        float f = this.xEnd - this.xStart;
        float f2 = this.yEnd - this.yStart;
        float f3 = this.elevationEnd - this.elevationStart;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public TextStyle getLengthStyle() {
        return this.lengthStyle;
    }

    public void setLengthStyle(TextStyle textStyle) {
        if (textStyle != this.lengthStyle) {
            TextStyle textStyle2 = this.lengthStyle;
            this.lengthStyle = textStyle;
            this.firePropertyChange(Property.LENGTH_STYLE.name(), textStyle2, textStyle);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public float getEndMarkSize() {
        return this.endMarkSize;
    }

    public void setEndMarkSize(float f) {
        if (f != this.endMarkSize) {
            float f2 = this.endMarkSize;
            this.endMarkSize = f;
            this.shapeCache = null;
            this.firePropertyChange(Property.END_MARK_SIZE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isVisibleIn3D() {
        return this.visibleIn3D;
    }

    public void setVisibleIn3D(boolean bl) {
        if (bl != this.visibleIn3D) {
            this.visibleIn3D = bl;
            this.firePropertyChange(Property.VISIBLE_IN_3D.name(), !bl, bl);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    public boolean isAtLevel(Level level) {
        if (this.level == level) {
            return true;
        }
        if (this.level != null && level != null) {
            float f;
            float f2 = this.level.getElevation();
            return f2 == (f = level.getElevation()) && this.level.getElevationIndex() < level.getElevationIndex() || f2 < f && f2 + Math.max(this.elevationStart, this.elevationEnd) > f;
        }
        return false;
    }

    public float[][] getPoints() {
        double d = this.isElevationDimensionLine() ? (double)this.pitch : Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        float f = (float)(-Math.sin(d)) * this.offset;
        float f2 = (float)Math.cos(d) * this.offset;
        return new float[][]{{this.xStart, this.yStart}, {this.xStart + f, this.yStart + f2}, {this.xEnd + f, this.yEnd + f2}, {this.xEnd, this.yEnd}};
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        return this.containsShapeAtWithMargin(this.getShape(), f, f2, f3);
    }

    public boolean isMiddlePointAt(float f, float f2, float f3) {
        if (this.elevationStart == this.elevationEnd) {
            double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
            float f4 = (float)(-Math.sin(d)) * this.offset;
            float f5 = (float)Math.cos(d) * this.offset;
            float f6 = (this.xStart + this.xEnd) / 2.0f + f4;
            float f7 = (this.yStart + this.yEnd) / 2.0f + f5;
            return Math.abs(f - f6) <= f3 && Math.abs(f2 - f7) <= f3;
        }
        return false;
    }

    public boolean containsStartExtensionLinetAt(float f, float f2, float f3) {
        if (this.elevationStart == this.elevationEnd) {
            double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
            Line2D.Float float_ = new Line2D.Float(this.xStart, this.yStart, this.xStart + (float)(-Math.sin(d)) * this.offset, this.yStart + (float)Math.cos(d) * this.offset);
            return this.containsShapeAtWithMargin(float_, f, f2, f3);
        }
        return false;
    }

    public boolean containsEndExtensionLineAt(float f, float f2, float f3) {
        if (this.elevationStart == this.elevationEnd) {
            double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
            Line2D.Float float_ = new Line2D.Float(this.xEnd, this.yEnd, this.xEnd + (float)(-Math.sin(d)) * this.offset, this.yEnd + (float)Math.cos(d) * this.offset);
            return this.containsShapeAtWithMargin(float_, f, f2, f3);
        }
        return false;
    }

    public boolean isTopPointAt(float f, float f2, float f3) {
        if (this.elevationStart != this.elevationEnd) {
            double d = this.yEnd != this.yStart || this.xEnd != this.xStart ? Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart) : (double)this.pitch;
            float f4 = (float)(-Math.sin(d)) * (this.offset - this.endMarkSize / 2.0f * (Math.signum(this.offset) == 0.0f ? -1.0f : Math.signum(this.offset)));
            float f5 = (float)Math.cos(d) * (this.offset - this.endMarkSize / 2.0f * (Math.signum(this.offset) == 0.0f ? -1.0f : Math.signum(this.offset)));
            double d2 = Point2D.distanceSq(f, f2, this.xStart + f4, this.yStart + f5);
            return d2 <= (double)(f3 * f3);
        }
        return false;
    }

    public boolean isRightPointAt(float f, float f2, float f3) {
        if (this.elevationStart != this.elevationEnd) {
            double d = this.yEnd != this.yStart || this.xEnd != this.xStart ? Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart) : (double)this.pitch;
            float f4 = (float)Math.sin(d);
            float f5 = (float)Math.cos(d);
            float f6 = -f4 * this.offset + f5 * this.endMarkSize / 2.0f;
            float f7 = f5 * this.offset + f4 * this.endMarkSize / 2.0f;
            double d2 = Point2D.distanceSq(f, f2, this.xStart + f6, this.yStart + f7);
            return d2 <= (double)(f3 * f3);
        }
        return false;
    }

    public boolean isBottomPointAt(float f, float f2, float f3) {
        if (this.elevationStart != this.elevationEnd) {
            double d = this.yEnd != this.yStart || this.xEnd != this.xStart ? Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart) : (double)this.pitch;
            float f4 = (float)(-Math.sin(d)) * (this.offset + this.endMarkSize / 2.0f * (Math.signum(this.offset) == 0.0f ? -1.0f : Math.signum(this.offset)));
            float f5 = (float)Math.cos(d) * (this.offset + this.endMarkSize / 2.0f * (Math.signum(this.offset) == 0.0f ? -1.0f : Math.signum(this.offset)));
            double d2 = Point2D.distanceSq(f, f2, this.xStart + f4, this.yStart + f5);
            return d2 <= (double)(f3 * f3);
        }
        return false;
    }

    public boolean isLeftPointAt(float f, float f2, float f3) {
        if (this.elevationStart != this.elevationEnd) {
            double d = this.yEnd != this.yStart || this.xEnd != this.xStart ? Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart) : (double)this.pitch;
            float f4 = (float)Math.sin(d);
            float f5 = (float)Math.cos(d);
            float f6 = -f4 * this.offset - f5 * this.endMarkSize / 2.0f;
            float f7 = f5 * this.offset - f4 * this.endMarkSize / 2.0f;
            double d2 = Point2D.distanceSq(f, f2, this.xStart + f6, this.yStart + f7);
            return d2 <= (double)(f3 * f3);
        }
        return false;
    }

    private boolean containsShapeAtWithMargin(Shape shape, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape.contains(f, f2);
        }
        return shape.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getShape() {
        if (this.shapeCache == null) {
            double d = this.yEnd != this.yStart || this.xEnd != this.xStart ? Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart) : (double)this.pitch;
            boolean bl = this.elevationStart == this.elevationEnd;
            float f = (float)(-Math.sin(d)) * this.offset;
            float f2 = (float)Math.cos(d) * this.offset;
            GeneralPath generalPath = new GeneralPath();
            if (bl) {
                generalPath.append(new Line2D.Float(this.xStart + f, this.yStart + f2, this.xEnd + f, this.yEnd + f2), false);
                generalPath.append(new Line2D.Float(this.xEnd, this.yEnd, this.xEnd + f, this.yEnd + f2), false);
            } else {
                generalPath.append(new Ellipse2D.Float(this.xStart + f - this.endMarkSize / 2.0f, this.yStart + f2 - this.endMarkSize / 2.0f, this.endMarkSize, this.endMarkSize), false);
            }
            generalPath.append(new Line2D.Float(this.xStart, this.yStart, this.xStart + f, this.yStart + f2), false);
            this.shapeCache = generalPath;
        }
        return this.shapeCache;
    }

    public void move(float f, float f2) {
        this.setXStart(this.getXStart() + f);
        this.setYStart(this.getYStart() + f2);
        this.setXEnd(this.getXEnd() + f);
        this.setYEnd(this.getYEnd() + f2);
    }

    public DimensionLine clone() {
        DimensionLine dimensionLine = (DimensionLine)super.clone();
        dimensionLine.level = null;
        return dimensionLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X_START,
        Y_START,
        ELEVATION_START,
        X_END,
        Y_END,
        ELEVATION_END,
        OFFSET,
        END_MARK_SIZE,
        PITCH,
        LENGTH_STYLE,
        COLOR,
        VISIBLE_IN_3D,
        LEVEL;

    }
}

