/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.parser.CalculatorParser;
import com.eteks.parser.CompilationException;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.sweethome3d.model.LengthUnit;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;

class CalculatorFormat
extends DecimalFormat {
    private DecimalFormat numberFormat;
    private LengthUnit lengthUnit;

    public CalculatorFormat(DecimalFormat decimalFormat, LengthUnit lengthUnit) {
        super(decimalFormat.toPattern());
        this.numberFormat = decimalFormat;
        this.lengthUnit = lengthUnit;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        String string2 = string.substring(parsePosition.getIndex());
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number == null || parsePosition.getIndex() != string.length()) {
            CalculatorParser calculatorParser = new CalculatorParser((Syntax)new CalculatorSyntax());
            try {
                number = (Number)calculatorParser.computeExpression(string2, (Interpreter)new CalculatorInterpreter());
                if (number != null && this.lengthUnit != null) {
                    number = Float.valueOf(this.lengthUnit.unitToCentimeter(number.floatValue()));
                }
                parsePosition.setIndex(string.length());
            }
            catch (CompilationException compilationException) {
                // empty catch block
            }
        }
        return number;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.numberFormat.format(d, stringBuffer, fieldPosition);
    }

    private static class CalculatorInterpreter
    implements Interpreter {
        private CalculatorInterpreter() {
        }

        public Object getLiteralValue(Object object) {
            return object;
        }

        public Object getParameterValue(Object object) {
            return null;
        }

        public Object getConstantValue(Object object) {
            return null;
        }

        public Double getUnaryOperatorValue(Object object, Object object2) {
            if (object.equals("-")) {
                return -((Number)object2).doubleValue();
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Double getBinaryOperatorValue(Object object, Object object2, Object object3) {
            if (object.equals("+")) {
                return ((Number)object2).doubleValue() + ((Number)object3).doubleValue();
            }
            if (object.equals("-")) {
                return ((Number)object2).doubleValue() - ((Number)object3).doubleValue();
            }
            if (object.equals("/")) {
                return ((Number)object2).doubleValue() / ((Number)object3).doubleValue();
            }
            if (object.equals("*")) {
                return ((Number)object2).doubleValue() * ((Number)object3).doubleValue();
            }
            if (object.equals("^")) {
                return Math.pow(((Number)object2).doubleValue(), ((Number)object3).doubleValue());
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Double getCommonFunctionValue(Object object, Object object2) {
            if (object.equals("LN")) {
                return Math.log(((Number)object2).doubleValue());
            }
            if (object.equals("LOG")) {
                return Math.log(((Number)object2).doubleValue()) / Math.log(10.0);
            }
            if (object.equals("EXP")) {
                return Math.exp(((Number)object2).doubleValue());
            }
            if (object.equals("SQR")) {
                return ((Number)object2).doubleValue() * ((Number)object2).doubleValue();
            }
            if (object.equals("SQRT")) {
                return Math.sqrt(((Number)object2).doubleValue());
            }
            if (object.equals("COS")) {
                return Math.cos(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("SIN")) {
                return Math.sin(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("TAN")) {
                return Math.tan(Math.toRadians(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCCOS")) {
                return Math.toDegrees(Math.acos(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCSIN")) {
                return Math.toDegrees(Math.asin(((Number)object2).doubleValue()));
            }
            if (object.equals("ARCTAN")) {
                return Math.toDegrees(Math.atan(((Number)object2).doubleValue()));
            }
            throw new IllegalArgumentException("Not implemented");
        }

        public Object getConditionValue(Object object, Object object2, Object object3) {
            return null;
        }

        public boolean isTrue(Object object) {
            return false;
        }

        public boolean supportsRecursiveCall() {
            return false;
        }

        public Object getFunctionValue(Function function, Object[] objectArray, boolean bl) {
            return null;
        }
    }

    private class CalculatorSyntax
    implements Syntax {
        private CalculatorSyntax() {
        }

        public Object getLiteral(String string, StringBuffer stringBuffer) {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = CalculatorFormat.this.numberFormat.parse(string, parsePosition);
            if (number != null && CalculatorFormat.this.lengthUnit != null) {
                number = Float.valueOf(CalculatorFormat.this.lengthUnit.centimeterToUnit(number.floatValue()));
            }
            stringBuffer.append(string, 0, parsePosition.getIndex());
            return number;
        }

        public Object getConstantKey(String string) {
            return null;
        }

        public Object getUnaryOperatorKey(String string) {
            if ("-".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getBinaryOperatorKey(String string) {
            if ("+".equals(string) || "-".equals(string) || "/".equals(string) || "*".equals(string) || "^".equals(string)) {
                return string;
            }
            return null;
        }

        public Object getConditionPartKey(String string) {
            return null;
        }

        public int getConditionPartCount() {
            return 0;
        }

        public Object getCommonFunctionKey(String string) {
            if ("LN".equals(string = string.toUpperCase()) || "LOG".equals(string) || "EXP".equals(string) || "SQR".equals(string) || "SQRT".equals(string) || "COS".equals(string) || "SIN".equals(string) || "TAN".equals(string) || "ARCCOS".equals(string) || "ARCSIN".equals(string) || "ARCTAN".equals(string)) {
                return string;
            }
            return null;
        }

        public Function getFunction(String string) {
            return null;
        }

        public int getBinaryOperatorPriority(Object object) {
            if ("+".equals(object) || "-".equals(object)) {
                return 1;
            }
            if ("/".equals(object) || "*".equals(object)) {
                return 2;
            }
            if ("^".equals(object)) {
                return 3;
            }
            throw new IllegalArgumentException();
        }

        public String getAssignmentOperator() {
            return null;
        }

        public String getWhiteSpaceCharacters() {
            return " \t\n\r";
        }

        public char getOpeningBracket() {
            return '(';
        }

        public char getClosingBracket() {
            return ')';
        }

        public char getParameterSeparator() {
            return '\u0000';
        }

        public String getDelimiters() {
            return " \t\n\r-+*/^().";
        }

        public boolean isCaseSensitive() {
            return false;
        }

        public boolean isShortSyntax() {
            return true;
        }

        public boolean isValidIdentifier(String string) {
            return false;
        }
    }
}

