/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FileContentManager;
import com.eteks.sweethome3d.swing.PhotoSizeAndQualityPanel;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.ScaledImageComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.eteks.sweethome3d.viewcontroller.PhotosController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotosPanel
extends JPanel
implements DialogView {
    private static final String PHOTOS_DIALOG_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.PhotosPanel.PhotoDialogX";
    private static final String PHOTOS_DIALOG_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.PhotosPanel.PhotoDialogY";
    private static final String TIP_CARD = "tip";
    private static final String PROGRESS_CARD = "progress";
    private static final String END_CARD = "end";
    private final Home home;
    private final UserPreferences preferences;
    private final Object3DFactory object3dFactory;
    private final PhotosController controller;
    private JLabel selectedCamerasLabel;
    private JList selectedCamerasList;
    private CardLayout statusLayout;
    private JPanel statusPanel;
    private JLabel tipLabel;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JLabel endLabel;
    private ScaledImageComponent photoComponent;
    private PhotoSizeAndQualityPanel sizeAndQualityPanel;
    private JLabel fileFormatLabel;
    private JComboBox fileFormatComboBox;
    private String dialogTitle;
    private ExecutorService photosCreationExecutor;
    private JButton startStopButton;
    private JButton closeButton;
    private static PhotosPanel currentPhotosPanel;

    public PhotosPanel(Home home, UserPreferences userPreferences, PhotosController photosController) {
        this(home, userPreferences, null, photosController);
    }

    public PhotosPanel(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, PhotosController photosController) {
        super(new GridBagLayout());
        this.home = home;
        this.preferences = userPreferences;
        this.object3dFactory = object3DFactory;
        this.controller = photosController;
        this.createActions(userPreferences);
        this.createComponents(home, userPreferences, photosController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void createActions(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.START_PHOTOS_CREATION, new ResourceAction(userPreferences, PhotosPanel.class, ActionType.START_PHOTOS_CREATION.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotosPanel.this.startPhotosCreation();
            }
        });
        actionMap.put((Object)ActionType.STOP_PHOTOS_CREATION, new ResourceAction(userPreferences, PhotosPanel.class, ActionType.STOP_PHOTOS_CREATION.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotosPanel.this.stopPhotosCreation();
            }
        });
        actionMap.put((Object)ActionType.CLOSE, new ResourceAction(userPreferences, PhotosPanel.class, ActionType.CLOSE.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotosPanel.this.close();
            }
        });
    }

    private void createComponents(Home home, final UserPreferences userPreferences, final PhotosController photosController) {
        this.selectedCamerasLabel = new JLabel();
        this.selectedCamerasList = new JList(new CamerasListModel());
        this.selectedCamerasList.setCellRenderer(new ListCellRenderer(){
            private JCheckBox cameraCheckBox = new JCheckBox();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.cameraCheckBox.setText(((Camera)object).getName());
                this.cameraCheckBox.setSelected(photosController.getSelectedCameras().contains(object));
                this.cameraCheckBox.setOpaque(true);
                if (bl && jList.hasFocus()) {
                    this.cameraCheckBox.setBackground(jList.getSelectionBackground());
                    this.cameraCheckBox.setForeground(jList.getSelectionForeground());
                } else {
                    this.cameraCheckBox.setBackground(jList.getBackground());
                    this.cameraCheckBox.setForeground(jList.getForeground());
                }
                return this.cameraCheckBox;
            }
        });
        this.selectedCamerasList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (PhotosPanel.this.selectedCamerasList.isEnabled() && (n = PhotosPanel.this.selectedCamerasList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    PhotosPanel.this.toggleCameraSelection((Camera)PhotosPanel.this.selectedCamerasList.getModel().getElementAt(n), photosController);
                }
            }
        });
        this.selectedCamerasList.getInputMap().put(KeyStroke.getKeyStroke("pressed SPACE"), "toggleSelection");
        this.selectedCamerasList.getActionMap().put("toggleSelection", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Camera camera;
                if (PhotosPanel.this.selectedCamerasList.isEnabled() && (camera = (Camera)PhotosPanel.this.selectedCamerasList.getSelectedValue()) != null) {
                    PhotosPanel.this.toggleCameraSelection(camera, photosController);
                }
            }
        });
        this.selectedCamerasList.setSelectionMode(0);
        this.selectedCamerasList.setSelectedIndex(0);
        photosController.addPropertyChangeListener(PhotosController.Property.SELECTED_CAMERAS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotosPanel.this.selectedCamerasList.repaint();
                PhotosPanel.this.getActionMap().get((Object)ActionType.START_PHOTOS_CREATION).setEnabled(!((List)propertyChangeEvent.getNewValue()).isEmpty());
                if (PhotosPanel.this.startStopButton.getAction() == PhotosPanel.this.getActionMap().get((Object)ActionType.START_PHOTOS_CREATION)) {
                    PhotosPanel.this.statusLayout.show(PhotosPanel.this.statusPanel, PhotosPanel.TIP_CARD);
                }
            }
        });
        photosController.addPropertyChangeListener(PhotosController.Property.CAMERAS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotosPanel.this.selectedCamerasList.repaint();
            }
        });
        this.tipLabel = new JLabel();
        Font font = UIManager.getFont("ToolTip.font");
        this.tipLabel.setFont(font);
        this.progressLabel = new JLabel();
        this.progressLabel.setFont(font);
        this.progressLabel.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = PhotosPanel.this.progressBar.getValue();
                PhotosPanel.this.progressBar.setIndeterminate(n < 0);
                if (n >= 0) {
                    PhotosPanel.this.progressLabel.setText(userPreferences.getLocalizedString(PhotosPanel.class, "progressLabel.format", n + 1, PhotosPanel.this.progressBar.getMaximum()));
                }
            }
        });
        this.endLabel = new JLabel();
        this.endLabel.setFont(font);
        this.endLabel.setHorizontalAlignment(0);
        this.photoComponent = new ScaledImageComponent();
        this.photoComponent.setPreferredSize(new Dimension(font.getSize() * 5, font.getSize() * 5));
        this.sizeAndQualityPanel = new PhotoSizeAndQualityPanel(home, userPreferences, photosController);
        this.fileFormatLabel = new JLabel();
        this.fileFormatComboBox = new JComboBox<Object>(new Object[]{"PNG", "JPEG 0.3", "JPEG 0.5", "JPEG 0.7", "JPEG 0.9"});
        this.fileFormatComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                String string2 = "";
                if ("PNG".equals(string)) {
                    string2 = userPreferences.getLocalizedString(PhotosPanel.class, "fileFormatComboBox.png.text", new Object[0]);
                } else if (string.startsWith("JPEG")) {
                    float f = Float.parseFloat(string.substring(string.lastIndexOf(32) + 1));
                    string2 = userPreferences.getLocalizedString(PhotosPanel.class, "fileFormatComboBox.jpeg.text", Math.round(f * 100.0f));
                }
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
        });
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)PhotosPanel.this.fileFormatComboBox.getSelectedItem();
                if (string.startsWith("JPEG")) {
                    photosController.setFileFormat("JPEG");
                    photosController.setFileCompressionQuality(new Float(string.substring(string.lastIndexOf(32) + 1)));
                } else {
                    photosController.setFileFormat("PNG");
                    photosController.setFileCompressionQuality(null);
                }
            }
        };
        this.fileFormatComboBox.addItemListener(itemListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PhotosPanel.this.fileFormatComboBox.setSelectedItem(photosController.getFileFormat() + (photosController.getFileCompressionQuality() != null ? " " + photosController.getFileCompressionQuality() : ""));
            }
        };
        photosController.addPropertyChangeListener(PhotosController.Property.FILE_FORMAT, propertyChangeListener);
        photosController.addPropertyChangeListener(PhotosController.Property.FILE_COMPRESSION_QUALITY, propertyChangeListener);
        if (photosController.getFileFormat() != null) {
            propertyChangeListener.propertyChange(null);
        } else {
            itemListener.itemStateChanged(null);
        }
        JComponent jComponent = (JComponent)((Object)photosController.get3DView());
        photosController.set3DViewAspectRatio((float)jComponent.getWidth() / (float)jComponent.getHeight());
        ActionMap actionMap = this.getActionMap();
        this.startStopButton = new JButton(actionMap.get((Object)ActionType.START_PHOTOS_CREATION));
        this.closeButton = new JButton(actionMap.get((Object)ActionType.CLOSE));
        this.setComponentTexts(userPreferences);
    }

    private void toggleCameraSelection(Camera camera, PhotosController photosController) {
        ArrayList<Camera> arrayList = new ArrayList<Camera>(photosController.getSelectedCameras());
        if (arrayList.contains(camera)) {
            arrayList.remove(camera);
        } else {
            arrayList.add(camera);
        }
        photosController.setSelectedCameras(arrayList);
    }

    private void setComponentTexts(UserPreferences userPreferences) {
        this.tipLabel.setText(userPreferences.getLocalizedString(PhotosPanel.class, "tipLabel.text", new Object[0]));
        this.endLabel.setText(userPreferences.getLocalizedString(PhotosPanel.class, "endLabel.text", new Object[0]));
        this.selectedCamerasLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotosPanel.class, "selectedCamerasLabel.text", new Object[0]));
        this.fileFormatLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, PhotosPanel.class, "fileFormatLabel.text", new Object[0]));
        this.dialogTitle = userPreferences.getLocalizedString(PhotosPanel.class, "createPhotos.title", new Object[0]);
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            ((JDialog)window).setTitle(this.dialogTitle);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.selectedCamerasLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotosPanel.class, "selectedCamerasLabel.mnemonic", new Object[0])).getKeyCode());
            this.selectedCamerasLabel.setLabelFor(this.selectedCamerasList);
            this.fileFormatLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PhotosPanel.class, "fileFormatLabel.mnemonic", new Object[0])).getKeyCode());
            this.fileFormatLabel.setLabelFor(this.fileFormatComboBox);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 11 : 10;
        this.statusLayout = new CardLayout();
        this.statusPanel = new JPanel(this.statusLayout);
        this.statusPanel.add((Component)this.tipLabel, TIP_CARD);
        this.tipLabel.setMinimumSize(this.tipLabel.getPreferredSize());
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        jPanel.add((Component)this.photoComponent, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.progressBar, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(0, n2, n2, 0), 0, 0));
        jPanel.add((Component)this.progressLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, n2, 0, 0), 0, 0));
        this.statusPanel.add((Component)jPanel, PROGRESS_CARD);
        this.statusPanel.add((Component)this.endLabel, END_CARD);
        this.endLabel.setMinimumSize(this.endLabel.getPreferredSize());
        this.add((Component)this.selectedCamerasLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)SwingTools.createScrollPane(this.selectedCamerasList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)this.statusPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.sizeAndQualityPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.fileFormatLabel);
        jPanel2.add(this.fileFormatComboBox);
        this.fileFormatLabel.setHorizontalAlignment(n);
        this.add((Component)jPanel2, new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    @Override
    public void displayView(View view) {
        if (currentPhotosPanel == this) {
            SwingUtilities.getWindowAncestor(this).toFront();
        } else {
            if (currentPhotosPanel != null) {
                currentPhotosPanel.close();
            }
            final JOptionPane jOptionPane = new JOptionPane(this, -1, 2, null, new Object[]{this.startStopButton, this.closeButton}, this.startStopButton);
            final JDialog jDialog = jOptionPane.createDialog(SwingUtilities.getRootPane((Component)((Object)view)), this.dialogTitle);
            jDialog.applyComponentOrientation(view != null ? ((JComponent)((Object)view)).getComponentOrientation() : ComponentOrientation.getOrientation(Locale.getDefault()));
            jDialog.setModal(false);
            Component component = SwingUtilities.getRoot((Component)((Object)view));
            Point point = null;
            if (component != null) {
                Number number = this.home.getNumericProperty(PHOTOS_DIALOG_X_VISUAL_PROPERTY);
                Number number2 = this.home.getNumericProperty(PHOTOS_DIALOG_Y_VISUAL_PROPERTY);
                int n = component.getX() + component.getWidth();
                Dimension dimension = this.getToolkit().getScreenSize();
                Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
                int n2 = dimension.width - insets.right;
                int n3 = dimension.height - insets.top - insets.bottom;
                if (OperatingSystem.isLinux() && n3 == dimension.height) {
                    n3 -= 30;
                }
                int n4 = dimension.height - insets.bottom;
                int n5 = jDialog.getWidth();
                if (jDialog.getHeight() > n3) {
                    jDialog.setSize(n5, n3);
                }
                int n6 = jDialog.getHeight();
                if (number != null && number2 != null && number.intValue() + n5 <= n2 && number2.intValue() + n6 <= n4) {
                    point = new Point(number.intValue(), number2.intValue());
                } else if (n2 - n > n5 / 2 || n6 == n3) {
                    point = new Point(Math.min(n + 5, n2 - n5), Math.max(Math.min(component.getY(), dimension.height - n6 - insets.bottom), insets.top));
                }
            }
            if (point != null && SwingTools.isRectangleVisibleAtScreen(new Rectangle(point, jDialog.getSize()))) {
                jDialog.setLocationByPlatform(false);
                jDialog.setLocation(point);
            } else {
                jDialog.setLocationByPlatform(true);
            }
            jDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    PhotosPanel.this.stopPhotosCreation();
                    currentPhotosPanel = null;
                }
            });
            jDialog.setDefaultCloseOperation(2);
            jDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                    if (jOptionPane.getValue() != null && jOptionPane.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                        PhotosPanel.this.close();
                    }
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    PhotosPanel.this.controller.setHomeProperty(PhotosPanel.PHOTOS_DIALOG_X_VISUAL_PROPERTY, String.valueOf(jDialog.getX()));
                    PhotosPanel.this.controller.setHomeProperty(PhotosPanel.PHOTOS_DIALOG_Y_VISUAL_PROPERTY, String.valueOf(jDialog.getY()));
                }
            });
            jDialog.setVisible(true);
            currentPhotosPanel = this;
        }
    }

    private void startPhotosCreation() {
        String string = this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(PhotosPanel.class, "selectPhotosFolderDialog.title", new Object[0]), ContentManager.ContentType.PHOTOS_DIRECTORY, this.home.getName());
        if (string != null) {
            final LinkedHashMap<Camera, File> linkedHashMap = new LinkedHashMap<Camera, File>();
            List<Camera> list = this.controller.getSelectedCameras();
            ContentManager contentManager = this.controller.getContentManager();
            boolean bl = false;
            for (Camera object2 : this.controller.getCameras()) {
                if (!list.contains(object2)) continue;
                String string2 = "";
                if (this.home.getName() != null) {
                    string2 = string2 + contentManager.getPresentationName(this.home.getName(), ContentManager.ContentType.SWEET_HOME_3D);
                    if (contentManager instanceof FileContentManager) {
                        string2 = string2.substring(0, string2.length() - ((FileContentManager)contentManager).getDefaultFileExtension(ContentManager.ContentType.SWEET_HOME_3D).length());
                    }
                    string2 = string2 + " - ";
                }
                string2 = string2 + object2.getName();
                string2 = string2.replaceAll("/|\\\\|:|;", "-").replace(File.pathSeparatorChar, '-').replace(File.separatorChar, '-');
                if (contentManager instanceof FileContentManager) {
                    string2 = string2 + ((FileContentManager)contentManager).getDefaultFileExtension(ContentManager.ContentType.valueOf(this.controller.getFileFormat()));
                }
                File file = new File(string, string2);
                if (!bl && file.exists()) {
                    if (JOptionPane.showConfirmDialog(this, this.preferences.getLocalizedString(PhotosPanel.class, "confirmOverwrite.message", string), this.preferences.getLocalizedString(PhotosPanel.class, "confirmOverwrite.title", new Object[0]), 0) == 1) {
                        return;
                    }
                    bl = true;
                }
                linkedHashMap.put(object2, file);
            }
            this.photoComponent.setImage(null);
            this.selectedCamerasList.setEnabled(false);
            this.sizeAndQualityPanel.setEnabled(false);
            this.fileFormatComboBox.setEnabled(false);
            this.getRootPane().setDefaultButton(this.startStopButton);
            this.startStopButton.setAction(this.getActionMap().get((Object)ActionType.STOP_PHOTOS_CREATION));
            this.statusLayout.show(this.statusPanel, PROGRESS_CARD);
            this.progressBar.setMinimum(-1);
            this.progressBar.setValue(-1);
            this.progressLabel.setText("");
            this.photoComponent.setImage(null);
            final Home home = this.home.clone();
            List list2 = Collections.emptyList();
            home.setSelectedItems(list2);
            this.photosCreationExecutor = Executors.newSingleThreadExecutor();
            this.photosCreationExecutor.execute(new Runnable(){

                public void run() {
                    PhotosPanel.this.computePhotos(home, linkedHashMap);
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    private void computePhotos(Home var1_1, Map<Camera, File> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateProgressBar(final int n, final int n2) {
        final BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                boundedRangeModel.setMinimum(0);
                boundedRangeModel.setMaximum(n2);
                boundedRangeModel.setValue(n);
            }
        });
    }

    private void showPhotoSaveError(final Throwable throwable) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    String string = PhotosPanel.this.preferences.getLocalizedString(PhotosPanel.class, "savePhotosError.message", new Object[0]);
                    SwingTools.showMessageDialog(PhotosPanel.this, String.format(string, throwable.getMessage()), PhotosPanel.this.preferences.getLocalizedString(PhotosPanel.class, "savePhotosError.title", new Object[0]), 0);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public void showPhotosComputingError(Throwable throwable) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String string = PhotosPanel.this.preferences.getLocalizedString(PhotosPanel.class, "error.title", new Object[0]);
                String string2 = PhotosPanel.this.preferences.getLocalizedString(PhotosPanel.class, "error.message", new Object[0]);
                SwingTools.showMessageDialog(PhotosPanel.this, string2, string, 0);
            }
        });
    }

    private void stopPhotosCreation() {
        if (this.photosCreationExecutor != null) {
            this.photosCreationExecutor.shutdownNow();
            this.photosCreationExecutor = null;
            this.startStopButton.setAction(this.getActionMap().get((Object)ActionType.START_PHOTOS_CREATION));
        }
    }

    private void savePhoto(BufferedImage bufferedImage, File file) throws IOException {
        String string = this.controller.getFileFormat();
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if ("JPEG".equals(string)) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(this.controller.getFileCompressionQuality().floatValue());
        }
        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
        imageWriter.setOutput(fileImageOutputStream);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        fileImageOutputStream.close();
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window.isDisplayable()) {
            window.dispose();
        }
    }

    private final class CamerasListModel
    extends AbstractListModel {
        private List<Camera> cameras;

        public CamerasListModel() {
            this.cameras = PhotosPanel.this.controller.getCameras();
            PhotosPanel.this.controller.addPropertyChangeListener(PhotosController.Property.CAMERAS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CamerasListModel.this.cameras = PhotosPanel.this.controller.getCameras();
                    CamerasListModel.this.fireContentsChanged(this, 0, CamerasListModel.this.cameras.size());
                }
            });
        }

        public int getSize() {
            return this.cameras.size();
        }

        public Object getElementAt(int n) {
            return this.cameras.get(n);
        }
    }

    public static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<PhotosPanel> photoPanel;

        public LanguageChangeListener(PhotosPanel photosPanel) {
            this.photoPanel = new WeakReference<PhotosPanel>(photosPanel);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotosPanel photosPanel = (PhotosPanel)this.photoPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (photosPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                photosPanel.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                photosPanel.setComponentTexts(userPreferences);
                photosPanel.setMnemonics(userPreferences);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        START_PHOTOS_CREATION,
        STOP_PHOTOS_CREATION,
        CLOSE;

    }
}

