/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.AbstractPhotoController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotosController
extends AbstractPhotoController {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView photoView;
    private List<Camera> cameras;
    private List<Camera> selectedCameras;
    private String fileFormat;
    private Float fileCompressionQuality;

    public PhotosController(Home home, UserPreferences userPreferences, View view, ViewFactory viewFactory, ContentManager contentManager) {
        super(home, userPreferences, view, contentManager);
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.cameras = Collections.emptyList();
        this.selectedCameras = Collections.emptyList();
        home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, (PropertyChangeListener)new HomeStoredCamerasChangeListener(this));
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.photoView == null) {
            this.photoView = this.viewFactory.createPhotosView(this.home, this.preferences, this);
        }
        return this.photoView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    @Override
    protected void updateProperties() {
        if (this.home != null) {
            super.updateProperties();
            this.setCameras(this.home.getStoredCameras());
            this.setSelectedCameras(this.home.getStoredCameras());
        }
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }

    private void setCameras(List<Camera> list) {
        if (!list.equals(this.cameras)) {
            List<Camera> list2 = this.cameras;
            this.cameras = new ArrayList<Camera>(list);
            this.propertyChangeSupport.firePropertyChange(Property.CAMERAS.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public List<Camera> getSelectedCameras() {
        return this.selectedCameras;
    }

    public void setSelectedCameras(List<Camera> list) {
        if (!list.equals(this.selectedCameras)) {
            List<Camera> list2 = this.selectedCameras;
            this.selectedCameras = new ArrayList<Camera>(list);
            this.propertyChangeSupport.firePropertyChange(Property.SELECTED_CAMERAS.name(), Collections.unmodifiableList(list2), Collections.unmodifiableList(list));
        }
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String string) {
        if (string != this.fileFormat) {
            String string2 = this.fileFormat;
            this.fileFormat = string;
            this.propertyChangeSupport.firePropertyChange(Property.FILE_FORMAT.name(), string2, string);
        }
    }

    public Float getFileCompressionQuality() {
        return this.fileCompressionQuality;
    }

    public void setFileCompressionQuality(Float f) {
        if (f != this.fileCompressionQuality) {
            Float f2 = this.fileCompressionQuality;
            this.fileCompressionQuality = f;
            this.propertyChangeSupport.firePropertyChange(Property.FILE_COMPRESSION_QUALITY.name(), f2, f);
        }
    }

    private static class HomeStoredCamerasChangeListener
    implements PropertyChangeListener {
        private WeakReference<PhotosController> photosController;

        public HomeStoredCamerasChangeListener(PhotosController photosController) {
            this.photosController = new WeakReference<PhotosController>(photosController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractPhotoController abstractPhotoController = (AbstractPhotoController)this.photosController.get();
            if (abstractPhotoController == null) {
                ((Home)propertyChangeEvent.getSource()).removePropertyChangeListener(Home.Property.STORED_CAMERAS, (PropertyChangeListener)this);
            } else {
                abstractPhotoController.updateProperties();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        CAMERAS,
        SELECTED_CAMERAS,
        FILE_FORMAT,
        FILE_COMPRESSION_QUALITY;

    }
}

