/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.DefaultLibrary;
import com.eteks.sweethome3d.io.ResourceBundleTools;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTexturesCatalog
extends TexturesCatalog {
    public static final String PLUGIN_TEXTURES_CATALOG_FAMILY = "PluginTexturesCatalog";
    private static final String ADDITIONAL_TEXTURES_CATALOG_FAMILY = "AdditionalTexturesCatalog";
    private List<Library> libraries;
    private static final Map<File, URL> pluginTexturesCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultTexturesCatalog() {
        this((File)null);
    }

    public DefaultTexturesCatalog(File file) {
        this(null, file);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultTexturesCatalog(UserPreferences userPreferences, File[] fileArray) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readDefaultTexturesCatalogs(userPreferences, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    this.readPluginTexturesCatalog(file2, arrayList);
                }
            }
        }
    }

    public DefaultTexturesCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultTexturesCatalog(URL[] uRLArray, URL uRL) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL2 : uRLArray) {
            try {
                ResourceBundle resourceBundle = ResourceBundleTools.getBundle(uRL2, PLUGIN_TEXTURES_CATALOG_FAMILY);
                this.libraries.add(0, new DefaultLibrary(uRL2.toExternalForm(), "Textures library", resourceBundle));
                this.readTextures(resourceBundle, uRL2, uRL, arrayList);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    private void readPluginTexturesCatalog(File file, List<String> list) {
        try {
            URL uRL;
            Object object;
            long l = file.lastModified();
            URL uRL2 = pluginTexturesCatalogUrlUpdates.get(file);
            if (file.canWrite() && (uRL2 == null || uRL2.openConnection().getLastModified() < l)) {
                object = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(file.toURI().toURL()));
                URL uRL3 = ((URLContent)object).getURL();
                pluginTexturesCatalogUrlUpdates.put(file, uRL3);
                uRL = uRL3;
            } else {
                uRL = uRL2 != null ? uRL2 : file.toURI().toURL();
            }
            object = ResourceBundleTools.getBundle(uRL, PLUGIN_TEXTURES_CATALOG_FAMILY);
            this.libraries.add(0, new DefaultLibrary(file.getCanonicalPath(), "Textures library", (ResourceBundle)object));
            this.readTextures((ResourceBundle)object, uRL, null, list);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readDefaultTexturesCatalogs(UserPreferences userPreferences, List<String> list) {
        String string = DefaultTexturesCatalog.class.getName();
        this.readTexturesCatalog(string, userPreferences, list);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readTexturesCatalog(string2 + "." + ADDITIONAL_TEXTURES_CATALOG_FAMILY, userPreferences, list);
    }

    private void readTexturesCatalog(final String string, final UserPreferences userPreferences, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readTextures(resourceBundle, null, null, list);
    }

    private void readTextures(ResourceBundle resourceBundle, URL uRL, URL uRL2, List<String> list) {
        int n = 0;
        while (true) {
            CatalogTexture catalogTexture;
            String string;
            try {
                string = resourceBundle.getString("ignored#" + ++n);
            }
            catch (MissingResourceException missingResourceException) {
                string = null;
            }
            if (string != null && Boolean.parseBoolean(string)) continue;
            CatalogTexture catalogTexture2 = catalogTexture = string == null ? this.readTexture(resourceBundle, n, uRL, uRL2) : null;
            if (catalogTexture == null) break;
            if (catalogTexture.getId() != null) {
                if (list.contains(catalogTexture.getId())) continue;
                list.add(catalogTexture.getId());
            }
            TexturesCategory texturesCategory = this.readTexturesCategory(resourceBundle, n);
            this.add(texturesCategory, catalogTexture);
        }
    }

    protected CatalogTexture readTexture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        String string = null;
        try {
            string = resourceBundle.getString(PropertyKey.NAME.getKey(n));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        Content content = this.getContent(resourceBundle, PropertyKey.IMAGE.getKey(n), PropertyKey.IMAGE_DIGEST.getKey(n), uRL, uRL2);
        float f = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
        float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
        String string2 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n), null);
        String string3 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n), null);
        return new CatalogTexture(string3, string, content, f, f2, string2);
    }

    protected TexturesCategory readTexturesCategory(ResourceBundle resourceBundle, int n) {
        String string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
        return new TexturesCategory(string);
    }

    private Content getContent(ResourceBundle resourceBundle, String string, String string2, URL uRL, URL uRL2) {
        URLContent uRLContent;
        Object object;
        String string3 = resourceBundle.getString(string);
        try {
            object = uRL2 == null ? new URL(string3) : (string3.startsWith("?") ? new URL(uRL2 + string3) : new URL(uRL2, string3));
            uRLContent = new URLContent((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                uRLContent = new ResourceURLContent(DefaultTexturesCatalog.class, string3);
            }
            try {
                uRLContent = new ResourceURLContent(new URL("jar:" + uRL + "!" + string3), false);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
        object = ResourceBundleTools.getOptionalString(resourceBundle, string2, null);
        if (object != null && ((String)object).length() > 0) {
            try {
                ContentDigestManager.getInstance().setContentDigest(uRLContent, Base64.decode((String)object));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uRLContent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        CATEGORY("category"),
        IMAGE("image"),
        IMAGE_DIGEST("imageDigest"),
        WIDTH("width"),
        HEIGHT("height"),
        CREATOR("creator");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }
    }
}

