/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.eteks.furniturelibraryeditor.io.FileFurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.io.FurnitureLibraryFileRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.swing.SwingEditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorController;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorView;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FileContentManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.QuitStrategy;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class FurnitureLibraryEditor {
    private FurnitureLibraryFileRecorder furnitureLibraryRecorder;
    private FileFurnitureLibraryUserPreferences userPreferences;
    private EditorViewFactory viewFactory;
    private ContentManager contentManager;

    public FurnitureLibraryRecorder getFurnitureLibraryRecorder() {
        if (this.furnitureLibraryRecorder == null) {
            this.furnitureLibraryRecorder = new FurnitureLibraryFileRecorder();
        }
        return this.furnitureLibraryRecorder;
    }

    public FurnitureLibraryUserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = new FileFurnitureLibraryUserPreferences();
        }
        return this.userPreferences;
    }

    protected ContentManager getContentManager() {
        if (this.contentManager == null) {
            this.contentManager = new FileContentManager(this.getUserPreferences()){
                private final String JSON_EXTENSION = ".json";
                private File modelsDirectory;
                {
                    this.JSON_EXTENSION = ".json";
                }

                public String showOpenDialog(View view, String string, ContentManager.ContentType contentType) {
                    if (contentType == ContentManager.ContentType.USER_DEFINED) {
                        JFileChooser jFileChooser = new JFileChooser();
                        if (this.modelsDirectory != null) {
                            jFileChooser.setCurrentDirectory(this.modelsDirectory);
                        }
                        jFileChooser.setDialogTitle(string);
                        jFileChooser.setMultiSelectionEnabled(true);
                        if (jFileChooser.showOpenDialog((JComponent)((Object)view)) == 0) {
                            this.modelsDirectory = jFileChooser.getCurrentDirectory();
                            String string2 = "";
                            for (File file : jFileChooser.getSelectedFiles()) {
                                if (string2.length() > 0) {
                                    string2 = string2 + File.pathSeparator;
                                }
                                string2 = string2 + file;
                            }
                            return string2;
                        }
                        return null;
                    }
                    return super.showOpenDialog(view, string, contentType);
                }

                public String showSaveDialog(View view, String string, ContentManager.ContentType contentType, String string2) {
                    String string3 = super.showSaveDialog(view, string, contentType, string2);
                    if (contentType == ContentManager.ContentType.USER_DEFINED && string3 != null) {
                        File file;
                        String string4 = this.getDefaultFileExtension(ContentManager.ContentType.FURNITURE_LIBRARY);
                        if (string3.toLowerCase().endsWith(".json" + string4) && (file = new File(string3 = string3.substring(0, string3.lastIndexOf(string4)))).exists() && !OperatingSystem.isMacOSX() && !this.confirmOverwrite(view, file.getName())) {
                            return this.showSaveDialog(view, string, contentType, string3);
                        }
                    }
                    return string3;
                }

                protected FileFilter[] getFileFilter(ContentManager.ContentType contentType) {
                    if (contentType == ContentManager.ContentType.FURNITURE_LIBRARY) {
                        FileFilter[] fileFilterArray = super.getFileFilter(contentType);
                        FileFilter[] fileFilterArray2 = new FileFilter[fileFilterArray.length + 1];
                        System.arraycopy(fileFilterArray, 0, fileFilterArray2, 0, fileFilterArray.length);
                        fileFilterArray2[fileFilterArray2.length - 1] = new FileFilter(){

                            public String getDescription() {
                                return "Default library";
                            }

                            public boolean accept(File file) {
                                return file.isDirectory() || FurnitureLibraryEditor.this.getFurnitureLibraryRecorder().isDefaultFurnitureLibrary(file.getAbsolutePath());
                            }
                        };
                        return fileFilterArray2;
                    }
                    if (contentType == ContentManager.ContentType.USER_DEFINED) {
                        FileFilter[] fileFilterArray = super.getFileFilter(ContentManager.ContentType.FURNITURE_LIBRARY);
                        FileFilter[] fileFilterArray3 = new FileFilter[fileFilterArray.length + 1];
                        System.arraycopy(fileFilterArray, 0, fileFilterArray3, 0, fileFilterArray.length);
                        fileFilterArray3[fileFilterArray3.length - 1] = new FileFilter(){

                            public boolean accept(File file) {
                                return file.isDirectory() || file.getName().toLowerCase().endsWith(".json");
                            }

                            public String getDescription() {
                                return "JSON";
                            }
                        };
                        return fileFilterArray3;
                    }
                    return super.getFileFilter(contentType);
                }

                protected String[] getFileExtensions(ContentManager.ContentType contentType) {
                    String[] stringArray = super.getFileExtensions(contentType);
                    if (contentType == ContentManager.ContentType.USER_DEFINED) {
                        String[] stringArray2 = new String[stringArray.length + 1];
                        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                        stringArray2[stringArray2.length - 1] = ".json";
                        return stringArray2;
                    }
                    return stringArray;
                }

                public String getDefaultFileExtension(ContentManager.ContentType contentType) {
                    return super.getDefaultFileExtension(contentType == ContentManager.ContentType.USER_DEFINED ? ContentManager.ContentType.FURNITURE_LIBRARY : contentType);
                }
            };
        }
        return this.contentManager;
    }

    protected EditorViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new SwingEditorViewFactory();
        }
        return this.viewFactory;
    }

    private String getName() {
        return this.getUserPreferences().getLocalizedString(FurnitureLibraryEditor.class, "applicationName", new Object[0]);
    }

    protected EditorController createEditorController(FurnitureLibrary furnitureLibrary) {
        return new EditorController(furnitureLibrary, this.getFurnitureLibraryRecorder(), this.getUserPreferences(), this.getViewFactory(), this.getContentManager());
    }

    public static void main(String[] stringArray) {
        new FurnitureLibraryEditor().init(stringArray);
    }

    protected void init(final String[] stringArray) {
        this.initSystemProperties();
        this.initLookAndFeel();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FurnitureLibraryEditor.this.run(stringArray);
            }
        });
    }

    private void initSystemProperties() {
        if (OperatingSystem.isMacOSX()) {
            String string = FurnitureLibraryEditor.class.getName();
            string = string.substring(0, string.lastIndexOf("."));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + ".package");
            String string2 = resourceBundle.getString("FurnitureLibraryEditor.applicationName");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string2);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        if (System.getProperty("j3d.implicitAntialiasing") == null) {
            System.setProperty("j3d.implicitAntialiasing", "true");
        }
    }

    private void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(System.getProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName()));
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                UIManager.put("TitledBorder.border", UIManager.getBorder("TitledBorder.aquaVariant"));
            }
            SwingTools.updateSwingResourceLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void run(String[] stringArray) {
        String string = stringArray.length == 2 && "-open".equals(stringArray[0]) ? stringArray[1] : null;
        final FurnitureLibrary furnitureLibrary = new FurnitureLibrary();
        final EditorController editorController = this.createEditorController(furnitureLibrary);
        final EditorView editorView = editorController.getView();
        final JFrame jFrame = new JFrame(){
            {
                if (editorView instanceof JRootPane) {
                    this.setRootPane((JRootPane)((Object)editorView));
                } else {
                    this.add((JComponent)((Object)editorView));
                }
            }
        };
        Image[] imageArray = new Image[]{new ImageIcon(FurnitureLibraryEditor.class.getResource("resources/frameIcon.png")).getImage(), new ImageIcon(FurnitureLibraryEditor.class.getResource("resources/frameIcon32x32.png")).getImage()};
        try {
            jFrame.getClass().getMethod("setIconImages", List.class).invoke((Object)jFrame, Arrays.asList(imageArray));
        }
        catch (Exception exception) {
            jFrame.setIconImage(imageArray[0]);
        }
        jFrame.setLocationByPlatform(true);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(0);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                editorController.exit();
            }
        });
        if (jFrame.getJMenuBar() == null) {
            this.installAccelerators(jFrame, editorController);
        }
        if (OperatingSystem.isMacOSX()) {
            MacOSXConfiguration.bindToApplicationMenu(editorController);
        }
        if (string != null) {
            editorController.open(string);
        }
        this.updateFrameTitle(jFrame, furnitureLibrary, this.getUserPreferences(), this.getContentManager());
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.LOCATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryEditor.this.updateFrameTitle(jFrame, furnitureLibrary, FurnitureLibraryEditor.this.getUserPreferences(), FurnitureLibraryEditor.this.getContentManager());
            }
        });
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.MODIFIED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryEditor.this.updateFrameTitle(jFrame, furnitureLibrary, FurnitureLibraryEditor.this.getUserPreferences(), FurnitureLibraryEditor.this.getContentManager());
            }
        });
    }

    private void installAccelerators(JFrame jFrame, EditorController editorController) {
        JComponent jComponent = (JComponent)((Object)editorController.getView());
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        for (Object object : actionMap.allKeys()) {
            if (!(object instanceof EditorView.ActionType)) continue;
            inputMap.put((KeyStroke)actionMap.get(object).getValue("AcceleratorKey"), object);
        }
    }

    private void updateFrameTitle(JFrame jFrame, FurnitureLibrary furnitureLibrary, UserPreferences userPreferences, ContentManager contentManager) {
        String string = furnitureLibrary.getLocation();
        String string2 = string == null ? userPreferences.getLocalizedString(FurnitureLibraryEditor.class, "untitled", new Object[0]) : contentManager.getPresentationName(string, ContentManager.ContentType.FURNITURE_LIBRARY);
        String string3 = string2;
        if (OperatingSystem.isMacOSX()) {
            Boolean bl = furnitureLibrary.isModified();
            jFrame.getRootPane().putClientProperty("windowModified", bl);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                File file;
                jFrame.getRootPane().putClientProperty("Window.documentModified", bl);
                if (string != null && (file = new File(string)).exists()) {
                    jFrame.getRootPane().putClientProperty("Window.documentFile", file);
                }
            }
        } else {
            string3 = string3 + " - " + this.getName();
            if (furnitureLibrary.isModified()) {
                string3 = "* " + string3;
            }
        }
        jFrame.setTitle(string3);
    }

    private static class MacOSXApplicationListener
    extends ApplicationAdapter {
        private final EditorController controller;

        public MacOSXApplicationListener(EditorController editorController) {
            this.controller = editorController;
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleQuit(this.controller);
        }

        public void handleAbout(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleAbout(this.controller);
            applicationEvent.setHandled(true);
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handlePreferences(this.controller);
            applicationEvent.setHandled(true);
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleOpenFile(this.controller, applicationEvent.getFilename());
        }

        public void handleReOpenApplication(ApplicationEvent applicationEvent) {
            MacOSXConfiguration.handleReOpenApplication(this.controller);
        }
    }

    private static class MacOSXConfiguration {
        private MacOSXConfiguration() {
        }

        public static void bindToApplicationMenu(final EditorController editorController) {
            Object object;
            Application application = Application.getApplication();
            boolean bl = false;
            try {
                application.getClass().getMethod("addApplicationListener", Class.forName("com.apple.eawt.ApplicationListener")).invoke((Object)application, MacOSXApplicationListener.class.getConstructor(EditorController.class).newInstance(editorController));
                application.setEnabledAboutMenu(true);
                application.setEnabledPreferencesMenu(true);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            if (!bl && OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
                try {
                    object = Class.forName("java.awt.Desktop");
                    Object object2 = ((Class)object).getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    QuitHandler quitHandler = new QuitHandler(){

                        public void handleQuitRequestWith(QuitEvent quitEvent, QuitResponse quitResponse) {
                            MacOSXConfiguration.handleQuit(editorController);
                            quitResponse.cancelQuit();
                        }
                    };
                    ((Class)object).getMethod("setQuitHandler", QuitHandler.class).invoke(object2, quitHandler);
                    AboutHandler aboutHandler = new AboutHandler(){

                        public void handleAbout(AboutEvent aboutEvent) {
                            MacOSXConfiguration.handleAbout(editorController);
                        }
                    };
                    ((Class)object).getMethod("setAboutHandler", AboutHandler.class).invoke(object2, aboutHandler);
                    PreferencesHandler preferencesHandler = new PreferencesHandler(){

                        public void handlePreferences(PreferencesEvent preferencesEvent) {
                            MacOSXConfiguration.handlePreferences(editorController);
                        }
                    };
                    ((Class)object).getMethod("setPreferencesHandler", PreferencesHandler.class).invoke(object2, preferencesHandler);
                    OpenFilesHandler openFilesHandler = new OpenFilesHandler(){

                        public void openFiles(OpenFilesEvent openFilesEvent) {
                            for (File file : openFilesEvent.getFiles()) {
                                MacOSXConfiguration.handleOpenFile(editorController, file.getAbsolutePath());
                            }
                        }
                    };
                    ((Class)object).getMethod("setOpenFileHandler", OpenFilesHandler.class).invoke(object2, openFilesHandler);
                    ((Class)object).getMethod("setQuitStrategy", QuitStrategy.class).invoke(object2, new Object[]{QuitStrategy.CLOSE_ALL_WINDOWS});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (!"true".equalsIgnoreCase(System.getProperty("furniturelibraryeditor.bundle", "false"))) {
                try {
                    object = ImageIO.read(MacOSXConfiguration.class.getResource("swing/resources/aboutIcon.png"));
                    application.setDockIconImage((Image)object);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static void handleQuit(EditorController editorController) {
            editorController.exit();
        }

        protected static void handleAbout(EditorController editorController) {
            editorController.about();
        }

        private static void handlePreferences(EditorController editorController) {
            editorController.editPreferences();
        }

        private static void handleOpenFile(EditorController editorController, String string) {
            editorController.open(string);
        }

        private static void handleReOpenApplication(EditorController editorController) {
            SwingUtilities.getWindowAncestor((JComponent)((Object)editorController.getView())).toFront();
        }
    }
}

