/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.io;

import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.RecorderException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFurnitureLibraryUserPreferences
extends FurnitureLibraryUserPreferences {
    private static final String LANGUAGE = "language";
    private static final String UNIT = "unit";
    private static final String DEFAULT_CREATOR = "defaultCreator";
    private static final String OFFLINE_FURNITURE_LIBRARY = "offlineFurnitureLibrary";
    private static final String FURNITURE_RESOURCES_LOCAL_DIRECTORY = "furnitureResourcesLocalDirectory";
    private static final String FURNITURE_RESOURCES_REMOTE_URL_BASE = "furnitureResourcesRemoteUrlBase";
    private static final String FURNITURE_ID_EDITABLE = "furnitureIdEditable";
    private static final String CONTENT_MATCHING_FURNITURE_NAME = "contentMatchingFurnitureName";
    private static final String FURNITURE_NAME_EQUAL_TO_IMPORTED_MODEL_FILE_NAME = "furnitureNameEqualToImportedModelFileName";
    private static final String FURNITURE_PROPERTY_NAME = "furniturePropertyName#";
    private static final String FURNITURE_PROPERTY_TYPE = "furniturePropertyType#";
    private static final String FURNITURE_PROPERTY_MODIFIABLE = "furniturePropertyModifiable#";
    private static final String FURNITURE_PROPERTY_DISPLAYED = "furniturePropertyDisplayed#";

    public FileFurnitureLibraryUserPreferences() {
        String string;
        Preferences preferences = this.getPreferences();
        this.setLanguage(preferences.get(LANGUAGE, this.getLanguage()));
        this.setUnit(LengthUnit.valueOf(preferences.get(UNIT, this.getLengthUnit().name())));
        this.setDefaultCreator(preferences.get(DEFAULT_CREATOR, this.getDefaultCreator()));
        boolean bl = preferences.getBoolean(OFFLINE_FURNITURE_LIBRARY, this.isFurnitureLibraryOffline());
        if (this.isOnlineFurnitureLibrarySupported()) {
            this.setFurnitureLibraryOffline(bl);
            this.setFurnitureResourcesLocalDirectory(preferences.get(FURNITURE_RESOURCES_LOCAL_DIRECTORY, this.getFurnitureResourcesLocalDirectory()));
            this.setFurnitureResourcesRemoteURLBase(preferences.get(FURNITURE_RESOURCES_REMOTE_URL_BASE, this.getFurnitureResourcesRemoteURLBase()));
        }
        this.setFurnitureIdEditable(preferences.getBoolean(FURNITURE_ID_EDITABLE, this.isFurnitureIdEditable()));
        this.setContentMatchingFurnitureName(preferences.getBoolean(CONTENT_MATCHING_FURNITURE_NAME, this.isContentMatchingFurnitureName()));
        this.setFurnitureNameEqualToImportedModelFileName(preferences.getBoolean(FURNITURE_NAME_EQUAL_TO_IMPORTED_MODEL_FILE_NAME, this.isFurnitureNameEqualToImportedModelFileName()));
        FurnitureProperty[] furniturePropertyArray = this.getFurnitureProperties();
        ArrayList<FurnitureProperty> arrayList = new ArrayList<FurnitureProperty>(Arrays.asList(furniturePropertyArray));
        int n = 1;
        while ((string = preferences.get(FURNITURE_PROPERTY_NAME + n, null)) != null) {
            Object object;
            int n2;
            for (n2 = 0; n2 < furniturePropertyArray.length; ++n2) {
                object = furniturePropertyArray[n2];
                if (!string.equals(((ObjectProperty)object).getName())) continue;
                object = ((FurnitureProperty)object).deriveModifiableProperty(preferences.getBoolean(FURNITURE_PROPERTY_MODIFIABLE + n, false)).deriveDisplayedProperty(preferences.getBoolean(FURNITURE_PROPERTY_DISPLAYED + n, false));
                arrayList.set(n2, (FurnitureProperty)object);
                break;
            }
            if (n2 == furniturePropertyArray.length) {
                ObjectProperty.Type type;
                object = preferences.get(FURNITURE_PROPERTY_TYPE + n, null);
                try {
                    type = object != null ? ObjectProperty.Type.valueOf((String)object) : null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    type = null;
                }
                arrayList.add(new FurnitureProperty(string, type).deriveModifiableProperty(preferences.getBoolean(FURNITURE_PROPERTY_MODIFIABLE + n, true)).deriveDisplayedProperty(preferences.getBoolean(FURNITURE_PROPERTY_DISPLAYED + n, true)));
            }
            ++n;
        }
        this.setFurnitureProperties(arrayList.toArray(new FurnitureProperty[arrayList.size()]));
    }

    @Override
    public void write() throws RecorderException {
        int n;
        Preferences preferences = this.getPreferences();
        preferences.put(LANGUAGE, this.getLanguage());
        preferences.put(UNIT, this.getLengthUnit().name());
        if (this.getDefaultCreator() != null) {
            preferences.put(DEFAULT_CREATOR, this.getDefaultCreator());
        } else {
            preferences.remove(DEFAULT_CREATOR);
        }
        preferences.putBoolean(OFFLINE_FURNITURE_LIBRARY, this.isFurnitureLibraryOffline());
        if (this.getFurnitureResourcesLocalDirectory() != null) {
            preferences.put(FURNITURE_RESOURCES_LOCAL_DIRECTORY, this.getFurnitureResourcesLocalDirectory());
        } else {
            preferences.remove(FURNITURE_RESOURCES_LOCAL_DIRECTORY);
        }
        if (this.getFurnitureResourcesRemoteURLBase() != null) {
            preferences.put(FURNITURE_RESOURCES_REMOTE_URL_BASE, this.getFurnitureResourcesRemoteURLBase());
        } else {
            preferences.remove(FURNITURE_RESOURCES_REMOTE_URL_BASE);
        }
        preferences.putBoolean(FURNITURE_ID_EDITABLE, this.isFurnitureIdEditable());
        preferences.putBoolean(CONTENT_MATCHING_FURNITURE_NAME, this.isContentMatchingFurnitureName());
        preferences.putBoolean(FURNITURE_NAME_EQUAL_TO_IMPORTED_MODEL_FILE_NAME, this.isFurnitureNameEqualToImportedModelFileName());
        FurnitureProperty[] furniturePropertyArray = this.getFurnitureProperties();
        for (n = 1; n <= furniturePropertyArray.length; ++n) {
            FurnitureProperty furnitureProperty = furniturePropertyArray[n - 1];
            preferences.put(FURNITURE_PROPERTY_NAME + n, furnitureProperty.getName());
            if (furnitureProperty.getDefaultPropertyKeyName() == null) {
                if (furnitureProperty.getType() != null && furnitureProperty.getType() != ObjectProperty.Type.ANY) {
                    preferences.put(FURNITURE_PROPERTY_TYPE + n, furnitureProperty.getType().name());
                } else {
                    preferences.remove(FURNITURE_PROPERTY_TYPE + n);
                }
            }
            preferences.putBoolean(FURNITURE_PROPERTY_MODIFIABLE + n, furnitureProperty.isModifiable());
            preferences.putBoolean(FURNITURE_PROPERTY_DISPLAYED + n, furnitureProperty.isDisplayed());
        }
        while (preferences.get(FURNITURE_PROPERTY_NAME + n, null) != null) {
            preferences.remove(FURNITURE_PROPERTY_NAME + n);
            preferences.remove(FURNITURE_PROPERTY_TYPE + n);
            preferences.remove(FURNITURE_PROPERTY_MODIFIABLE + n);
            preferences.remove(FURNITURE_PROPERTY_DISPLAYED + n);
            ++n;
        }
        try {
            preferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RecorderException("Couldn't write preferences", backingStoreException);
        }
    }

    protected Preferences getPreferences() {
        return Preferences.userNodeForPackage(FileFurnitureLibraryUserPreferences.class);
    }

    @Override
    public void addFurnitureLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLanguageLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTexturesLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean furnitureLibraryExists(String string) throws RecorderException {
        return new File(string).exists();
    }

    @Override
    public boolean languageLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean texturesLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Library> getLibraries() {
        throw new UnsupportedOperationException();
    }
}

