/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.io;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.model.BoxBounds;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.ShelfUnit;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibraryFileRecorder
implements FurnitureLibraryRecorder {
    private static final String DEFAULT_FURNITURE_LIBRARY = "Furniture.jar";
    private static final String[] IGNORED_EXTENSIONS = new String[]{".gsm", ".max", ".lwo", ".dxf"};
    private static final Locale DEFAULT_LOCALE = new Locale("");
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("0.#####", new DecimalFormatSymbols(Locale.US));
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String LICENSE = "license";
    private static final String PROVIDER = "provider";

    @Override
    public void readFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.readFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences, false);
    }

    @Override
    public void mergeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.readFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences, true);
    }

    @Override
    public boolean isDefaultFurnitureLibrary(String string) {
        return DEFAULT_FURNITURE_LIBRARY.equals(new File(string).getName());
    }

    private void readFurnitureLibrary(final FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, final boolean bl) throws RecorderException {
        try {
            String string2;
            Object object;
            Cloneable cloneable2;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Locale locale = Locale.getDefault();
            Locale.setDefault(DEFAULT_LOCALE);
            File file = File.createTempFile("furniture", ".sh3f");
            file.deleteOnExit();
            if (this.isDefaultFurnitureLibrary(string)) {
                object6 = DefaultFurnitureCatalog.class.getName().replace('.', '/');
                object5 = new File(string).toURI().toURL();
                object4 = this.getZipEntries((URL)object5);
                object3 = null;
                try {
                    object3 = new ZipOutputStream(new FileOutputStream(file));
                    ((ZipOutputStream)object3).setLevel(0);
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        cloneable2 = object2.next();
                        object = ((ZipEntry)cloneable2).getName();
                        if (((String)object).startsWith((String)object6) && ((String)object).endsWith(".properties")) {
                            object = ((String)object).replace((CharSequence)object6, "PluginFurnitureCatalog");
                        }
                        this.writeZipEntry((ZipOutputStream)object3, new URLContent(new URL("jar:" + object5 + "!/" + ((ZipEntry)cloneable2).getName())), (String)object);
                    }
                }
                catch (IOException iOException) {
                    throw new RecorderException("Can't copy library file " + string, iOException);
                }
                finally {
                    if (object3 != null) {
                        try {
                            ((ZipOutputStream)object3).close();
                        }
                        catch (IOException iOException) {
                            throw new RecorderException("Can't copy library file " + string, iOException);
                        }
                    }
                }
            }
            this.copyFile(new File(string), file);
            object6 = file.toURI().toURL();
            object5 = furnitureLibraryUserPreferences.getFurnitureResourcesLocalDirectory();
            if (furnitureLibraryUserPreferences.isFurnitureLibraryOffline()) {
                object4 = null;
            } else {
                if (object5 == null) {
                    object5 = new File(string).getParent();
                } else if (!new File((String)object5).isAbsolute()) {
                    object5 = new File(new File(string).getParent(), (String)object5).toString();
                }
                object4 = new File((String)object5).toURI().toURL();
            }
            object3 = new ArrayList();
            new DefaultFurnitureCatalog(new URL[]{object6}, (URL)object4, (List)object3){
                final /* synthetic */ List val$furniture;
                {
                    this.val$furniture = list;
                    super(uRLArray, uRL);
                }

                protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture;
                    if (n == 1 && !bl) {
                        furnitureLibrary.setId(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.ID));
                        furnitureLibrary.setName(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.NAME));
                        furnitureLibrary.setDescription(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.DESCRIPTION));
                        furnitureLibrary.setVersion(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.VERSION));
                        furnitureLibrary.setLicense(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.LICENSE));
                        furnitureLibrary.setProvider(this.getOptionalString(resourceBundle, FurnitureLibraryFileRecorder.PROVIDER));
                    }
                    if ((catalogPieceOfFurniture = super.readPieceOfFurniture(resourceBundle, n, uRL, uRL2)) != null) {
                        FurnitureCategory furnitureCategory = super.readFurnitureCategory(resourceBundle, n);
                        new FurnitureCatalog().add(furnitureCategory, catalogPieceOfFurniture);
                        this.val$furniture.add(catalogPieceOfFurniture);
                    }
                    return catalogPieceOfFurniture;
                }

                private String getOptionalString(ResourceBundle resourceBundle, String string) {
                    try {
                        return resourceBundle.getString(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return null;
                    }
                }
            };
            object2 = this.getZipEntries((URL)object6);
            cloneable2 = new HashSet();
            object = object2.iterator();
            while (object.hasNext()) {
                ZipEntry cloneable3 = (ZipEntry)object.next();
                string2 = cloneable3.getName();
                if (!string2.startsWith("PluginFurnitureCatalog") || !string2.endsWith(".properties")) continue;
                cloneable2.add(this.getLocale(string2));
            }
            if (!bl) {
                for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
                    furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
                }
            }
            object = cloneable2.iterator();
            while (object.hasNext()) {
                Locale locale2 = (Locale)object.next();
                if ("".equals(locale2.toString())) continue;
                Locale.setDefault(locale2);
                string2 = locale2.toString();
                new DefaultFurnitureCatalog(new URL[]{object6}, (URL)object4, (List)object3, furnitureLibrary, string2){
                    final /* synthetic */ List val$furniture;
                    final /* synthetic */ FurnitureLibrary val$furnitureLibrary;
                    final /* synthetic */ String val$language;
                    {
                        this.val$furniture = list;
                        this.val$furnitureLibrary = furnitureLibrary;
                        this.val$language = string;
                        super(uRLArray, uRL);
                    }

                    protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = super.readPieceOfFurniture(resourceBundle, n, uRL, uRL2);
                        if (catalogPieceOfFurniture != null) {
                            FurnitureCategory furnitureCategory = super.readFurnitureCategory(resourceBundle, n);
                            CatalogPieceOfFurniture catalogPieceOfFurniture2 = (CatalogPieceOfFurniture)this.val$furniture.get(n - 1);
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_NAME_PROPERTY, catalogPieceOfFurniture.getName());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY, catalogPieceOfFurniture.getDescription());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY, catalogPieceOfFurniture.getInformation());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_TAGS_PROPERTY, catalogPieceOfFurniture.getTags());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, furnitureCategory.getName());
                            this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, FurnitureLibrary.FURNITURE_LICENSE_PROPERTY, catalogPieceOfFurniture.getLicense());
                            for (String string : catalogPieceOfFurniture.getPropertyNames()) {
                                Object object;
                                if (catalogPieceOfFurniture.isContentProperty(string)) {
                                    object = catalogPieceOfFurniture.getContentProperty(string);
                                    if (object.equals(catalogPieceOfFurniture2.getContentProperty(string))) continue;
                                    this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, string, object);
                                    continue;
                                }
                                object = catalogPieceOfFurniture.getProperty(string);
                                if (((String)object).equals(catalogPieceOfFurniture2.getProperty(string))) continue;
                                this.val$furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, this.val$language, string, object);
                            }
                        }
                        return catalogPieceOfFurniture;
                    }
                };
            }
            Locale.setDefault(locale);
            object = object3.iterator();
            while (object.hasNext()) {
                CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object.next();
                furnitureLibrary.addPieceOfFurniture(catalogPieceOfFurniture);
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Invalid furniture library file " + string, iOException);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RecorderException("Invalid furniture library file " + string, missingResourceException);
        }
    }

    private Locale getLocale(String string) {
        String string2 = string.substring("PluginFurnitureCatalog".length(), string.lastIndexOf(".properties"));
        if (string2.matches("_\\w{2}")) {
            return new Locale(string2.substring(1));
        }
        if (string2.matches("_\\w{2}_\\w{2}")) {
            return new Locale(string2.substring(1, 3), string2.substring(4));
        }
        return DEFAULT_LOCALE;
    }

    @Override
    public void writeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences) throws RecorderException {
        this.writeFurnitureLibrary(furnitureLibrary, string, furnitureLibraryUserPreferences.getFurnitureProperties(), furnitureLibraryUserPreferences.isFurnitureLibraryOffline(), furnitureLibraryUserPreferences.isContentMatchingFurnitureName(), furnitureLibraryUserPreferences.getFurnitureResourcesLocalDirectory(), furnitureLibraryUserPreferences.getFurnitureResourcesRemoteURLBase());
    }

    private void writeFurnitureLibrary(FurnitureLibrary furnitureLibrary, String string, FurnitureProperty[] furniturePropertyArray, boolean bl, boolean bl2, String string2, String string3) throws RecorderException {
        HashSet<String> hashSet;
        String string4;
        URL uRL;
        boolean bl3;
        File file;
        block28: {
            file = new File(string);
            bl3 = string.endsWith(".json");
            uRL = null;
            string4 = null;
            hashSet = new HashSet<String>();
            if (!bl || bl3) {
                if (string2 == null) {
                    string2 = file.getParent();
                } else if (!new File(string2).isAbsolute()) {
                    string2 = new File(file.getParent(), string2).toString();
                }
                if (string3 != null) {
                    try {
                        uRL = new URL(string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        int n = string3.lastIndexOf(47);
                        if (n != 1) {
                            string4 = string3.substring(0, n + 1);
                            string2 = new File(string2, string3).toString();
                            break block28;
                        }
                        string4 = "";
                    }
                } else {
                    string4 = "";
                }
            }
        }
        OutputStream outputStream = null;
        try {
            HashMap<Content, String> hashMap = new HashMap<Content, String>();
            ZipOutputStream zipOutputStream = null;
            File file2 = null;
            if (bl3) {
                outputStream = new FileOutputStream(string);
            } else {
                file2 = File.createTempFile("temp", ".sh3f");
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
                zipOutputStream.putNextEntry(new ZipEntry("PluginFurnitureCatalog.properties"));
                outputStream = zipOutputStream;
            }
            this.writeFurnitureLibraryProperties(outputStream, furnitureLibrary, bl3, furniturePropertyArray, bl, bl2, uRL, string4, !bl || bl3, hashMap, hashSet);
            if (bl3) {
                outputStream.close();
            } else {
                zipOutputStream.closeEntry();
            }
            for (String string5 : furnitureLibrary.getSupportedLanguages()) {
                if ("".equals(string5)) continue;
                if (bl3) {
                    outputStream = new FileOutputStream(string.replace(".json", "_" + string5 + ".json"));
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry("PluginFurnitureCatalog_" + string5 + ".properties"));
                }
                this.writeFurnitureLibraryLocalizedProperties(outputStream, furnitureLibrary, string5, bl3, furniturePropertyArray, bl, bl2, uRL, string4, hashMap, hashSet);
                if (bl3) {
                    outputStream.close();
                    continue;
                }
                zipOutputStream.closeEntry();
            }
            this.writeContents(zipOutputStream, !bl || bl3, string2, hashMap);
            if (zipOutputStream != null) {
                zipOutputStream.finish();
                zipOutputStream.close();
                zipOutputStream = null;
                this.copyFile(file2, file);
                file2.delete();
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't save furniture library file " + string, iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new RecorderException("Can't close furniture library file " + string, iOException);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void writeFurnitureLibraryProperties(OutputStream outputStream, FurnitureLibrary furnitureLibrary, boolean bl, FurnitureProperty[] furniturePropertyArray, boolean bl2, boolean bl3, URL uRL, String string, boolean bl4, Map<Content, String> map, Set<String> set) throws IOException {
        BufferedWriter bufferedWriter;
        boolean bl5 = !bl2 && uRL == null && string == null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringWriter stringWriter = null;
        if (bl) {
            stringWriter = new StringWriter();
            bufferedWriter = new BufferedWriter(stringWriter);
            bufferedWriter.write("{");
        } else {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
            bufferedWriter.write(String.format("#\n# PluginFurnitureCatalog.properties %tc\n# Generated by Furniture Library Editor\n#\n", new Date()));
        }
        bufferedWriter.newLine();
        this.writeProperty(bufferedWriter, bl, ID, furnitureLibrary.getId());
        this.writeProperty(bufferedWriter, bl, NAME, furnitureLibrary.getName());
        this.writeProperty(bufferedWriter, bl, DESCRIPTION, furnitureLibrary.getDescription());
        this.writeProperty(bufferedWriter, bl, VERSION, furnitureLibrary.getVersion());
        this.writeProperty(bufferedWriter, bl, LICENSE, furnitureLibrary.getLicense());
        this.writeProperty(bufferedWriter, bl, PROVIDER, furnitureLibrary.getProvider());
        int n = 1;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
            int n2;
            Object object;
            Object object2;
            String string2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Content content;
            Long l;
            bufferedWriter.newLine();
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.ID, n, catalogPieceOfFurniture.getId());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.NAME, n, catalogPieceOfFurniture.getName());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DESCRIPTION, n, catalogPieceOfFurniture.getDescription());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.INFORMATION, n, catalogPieceOfFurniture.getInformation());
            String string3 = Arrays.toString(catalogPieceOfFurniture.getTags());
            if (string3.length() > 2) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.TAGS, n, string3.substring(1, string3.length() - 1));
            }
            if ((l = catalogPieceOfFurniture.getCreationDate()) != null) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.CREATION_DATE, n, simpleDateFormat.format(new Date(catalogPieceOfFurniture.getCreationDate())));
            }
            if (catalogPieceOfFurniture.getGrade() != null) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.GRADE, n, catalogPieceOfFurniture.getGrade());
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.CATEGORY, n, catalogPieceOfFurniture.getCategory().getName());
            String string4 = this.getContentBaseName(catalogPieceOfFurniture, bl3);
            Content content2 = catalogPieceOfFurniture.getIcon();
            String string5 = map.get(content2);
            if (string5 == null && (string5 = this.getContentEntry(content2, string4 + ".png", bl5, set)) != null) {
                map.put(content2, string5);
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.ICON, n, this.getContentProperty(content2, string5, bl, bl2, uRL, string));
            if (bl4) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.ICON_DIGEST, n, Base64.encodeBytes(ContentDigestManager.getInstance().getContentDigest(content2)));
            }
            if ((content = catalogPieceOfFurniture.getPlanIcon()) != null) {
                object7 = map.get(content);
                if (object7 == null && (object7 = this.getContentEntry(content, string4 + "PlanIcon.png", bl5, set)) != null) {
                    map.put(content, (String)object7);
                }
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.PLAN_ICON, n, this.getContentProperty(content, (String)object7, bl, bl2, uRL, string));
                if (bl4) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.PLAN_ICON_DIGEST, n, Base64.encodeBytes(ContentDigestManager.getInstance().getContentDigest(content)));
                }
            }
            boolean bl6 = (object7 = catalogPieceOfFurniture.getModel()) instanceof ResourceURLContent && ((ResourceURLContent)object7).isMultiPartResource() || !(object7 instanceof ResourceURLContent) && object7 instanceof URLContent && ((URLContent)object7).isJAREntry();
            String string6 = map.get(object7);
            if (string6 == null) {
                if (bl || bl6) {
                    object6 = ((URLContent)object7).getJAREntryName().replace("%20", " ");
                    string6 = this.getContentEntry((Content)object7, object7 instanceof TemporaryURLContent ? string4 + "/" + (String)object6 : string4 + "/" + ((String)object6).substring(((String)object6).lastIndexOf(47) + 1), bl5, set);
                } else {
                    string6 = this.getContentEntry((Content)object7, string4 + ".obj", bl5, set);
                }
                if (string6 != null) {
                    map.put((Content)object7, string6);
                }
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MODEL, n, this.getContentProperty((Content)object7, string6, bl, bl2, uRL, string));
            if (bl4) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MODEL_DIGEST, n, Base64.encodeBytes(ContentDigestManager.getInstance().getContentDigest((Content)object7)));
            }
            if (bl6) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MULTI_PART_MODEL, n, "true");
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.WIDTH, n, Float.valueOf(catalogPieceOfFurniture.getWidth()));
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DEPTH, n, Float.valueOf(catalogPieceOfFurniture.getDepth()));
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.HEIGHT, n, Float.valueOf(catalogPieceOfFurniture.getHeight()));
            if (Math.abs(catalogPieceOfFurniture.getDropOnTopElevation() - 1.0f) > 1.0E-6f) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION, n, Float.valueOf(catalogPieceOfFurniture.getDropOnTopElevation() * catalogPieceOfFurniture.getHeight()));
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MOVABLE, n, catalogPieceOfFurniture.isMovable());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW, n, catalogPieceOfFurniture.isDoorOrWindow());
            if (catalogPieceOfFurniture.isDoorOrWindow()) {
                object6 = (DoorOrWindow)((Object)catalogPieceOfFurniture);
                if (object6.getCutOutShape() != null) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_CUT_OUT_SHAPE, n, object6.getCutOutShape());
                }
                if (object6.getWallThickness() != 1.0f) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS, n, Float.valueOf(object6.getWallThickness() * object6.getDepth()));
                }
                if (object6.getWallDistance() != 0.0f) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE, n, Float.valueOf(object6.getWallDistance() * object6.getDepth()));
                }
                if (!object6.isWallCutOutOnBothSides()) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES, n, object6.isWallCutOutOnBothSides());
                }
                if (!object6.isWidthDepthDeformable()) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE, n, object6.isWidthDepthDeformable());
                }
                if (((LightSource[])(object5 = object6.getSashes())).length > 0) {
                    object4 = "";
                    object3 = "";
                    string2 = "";
                    object2 = "";
                    object = "";
                    for (n2 = 0; n2 < ((LightSource[])object5).length; ++n2) {
                        if (n2 > 0) {
                            object4 = (String)object4 + " ";
                            object3 = (String)object3 + " ";
                            string2 = string2 + " ";
                            object2 = (String)object2 + " ";
                            object = (String)object + " ";
                        }
                        object4 = (String)object4 + DECIMAL_FORMAT.format(((Sash)((Object)object5[n2])).getXAxis() * object6.getWidth());
                        object3 = (String)object3 + DECIMAL_FORMAT.format(((Sash)((Object)object5[n2])).getYAxis() * object6.getDepth());
                        string2 = string2 + DECIMAL_FORMAT.format(((Sash)((Object)object5[n2])).getWidth() * object6.getWidth());
                        object2 = (String)object2 + Math.round(Math.toDegrees(((Sash)((Object)object5[n2])).getStartAngle()) * 100.0) / 100L;
                        object = (String)object + Math.round(Math.toDegrees(((Sash)((Object)object5[n2])).getEndAngle()) * 100.0) / 100L;
                    }
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS, n, object4);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS, n, object3);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH, n, string2);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE, n, object2);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE, n, object);
                }
            }
            if (catalogPieceOfFurniture instanceof Light) {
                object6 = (Light)((Object)catalogPieceOfFurniture);
                object5 = object6.getLightSources();
                if (((LightSource[])object5).length > 0) {
                    object4 = "";
                    object3 = "";
                    string2 = "";
                    object2 = "";
                    object = null;
                    for (n2 = 0; n2 < ((LightSource[])object5).length; ++n2) {
                        if (n2 > 0) {
                            object4 = (String)object4 + " ";
                            object3 = (String)object3 + " ";
                            string2 = string2 + " ";
                            object2 = (String)object2 + " ";
                            if (object != null) {
                                object = (String)object + " ";
                            }
                        }
                        object4 = (String)object4 + DECIMAL_FORMAT.format(object5[n2].getX() * object6.getWidth());
                        object3 = (String)object3 + DECIMAL_FORMAT.format(object5[n2].getY() * object6.getDepth());
                        string2 = string2 + DECIMAL_FORMAT.format(object5[n2].getZ() * object6.getHeight());
                        object2 = (String)object2 + "#" + String.format("%06X", object5[n2].getColor());
                        if (object5[n2].getDiameter() == null) continue;
                        if (object == null) {
                            object = "";
                        }
                        object = (String)object + DECIMAL_FORMAT.format(object5[n2].getDiameter().floatValue() * object6.getWidth());
                    }
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_X, n, object4);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y, n, object3);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z, n, string2);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR, n, object2);
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER, n, object);
                }
                if (((String[])(object4 = object6.getLightSourceMaterialNames())).length > 0) {
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_MATERIAL_NAME, n, object4);
                }
            }
            if (catalogPieceOfFurniture.getElevation() > 0.0f) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.ELEVATION, n, Float.valueOf(catalogPieceOfFurniture.getElevation()));
            }
            if (catalogPieceOfFurniture instanceof ShelfUnit) {
                object6 = (ShelfUnit)((Object)catalogPieceOfFurniture);
                object5 = object6.getShelfElevations();
                if (((LightSource[])object5).length > 0) {
                    object4 = "";
                    for (int i = 0; i < ((LightSource[])object5).length; ++i) {
                        if (i > 0) {
                            object4 = (String)object4 + " ";
                        }
                        object4 = (String)object4 + DECIMAL_FORMAT.format((double)(object5[i] * object6.getHeight()));
                    }
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.SHELF_ELEVATIONS, n, object4);
                }
                if (((String[])(object4 = object6.getShelfBoxes())).length > 0) {
                    String string7 = "";
                    for (int i = 0; i < ((String[])object4).length; ++i) {
                        if (i > 0) {
                            string7 = string7 + "   ";
                        }
                        string7 = string7 + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getXLower() * object6.getWidth()) + " " + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getYLower() * object6.getDepth()) + " " + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getZLower() * object6.getHeight()) + " " + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getXUpper() * object6.getWidth()) + " " + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getYUpper() * object6.getDepth()) + " " + DECIMAL_FORMAT.format(((BoxBounds)((Object)object4[i])).getZUpper() * object6.getHeight());
                    }
                    this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.SHELF_BOXES, n, string7);
                }
            }
            if (!"1 0 0 0 1 0 0 0 1".equals(object5 = this.floatToString((float)(object6 = (Object)catalogPieceOfFurniture.getModelRotation())[0][0]) + " " + this.floatToString((float)object6[0][1]) + " " + this.floatToString((float)object6[0][2]) + " " + this.floatToString((float)object6[1][0]) + " " + this.floatToString((float)object6[1][1]) + " " + this.floatToString((float)object6[1][2]) + " " + this.floatToString((float)object6[2][0]) + " " + this.floatToString((float)object6[2][1]) + " " + this.floatToString((float)object6[2][2]))) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MODEL_ROTATION, n, object5);
            }
            if (catalogPieceOfFurniture.getModelFlags() != 0) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MODEL_FLAGS, n, catalogPieceOfFurniture.getModelFlags());
            }
            if (catalogPieceOfFurniture.getStaircaseCutOutShape() != null) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE, n, catalogPieceOfFurniture.getStaircaseCutOutShape());
            }
            if (catalogPieceOfFurniture.getModelSize() != null) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.MODEL_SIZE, n, catalogPieceOfFurniture.getModelSize());
            }
            if (!catalogPieceOfFurniture.isResizable()) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.RESIZABLE, n, catalogPieceOfFurniture.isResizable());
            }
            if (!catalogPieceOfFurniture.isDeformable()) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.DEFORMABLE, n, catalogPieceOfFurniture.isDeformable());
            }
            if (!catalogPieceOfFurniture.isTexturable()) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.TEXTURABLE, n, catalogPieceOfFurniture.isTexturable());
            }
            if (!catalogPieceOfFurniture.isHorizontallyRotatable()) {
                this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.HORIZONTALLY_ROTATABLE, n, catalogPieceOfFurniture.isHorizontallyRotatable());
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.PRICE, n, catalogPieceOfFurniture.getPrice());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.VALUE_ADDED_TAX_PERCENTAGE, n, catalogPieceOfFurniture.getValueAddedTaxPercentage());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.CURRENCY, n, catalogPieceOfFurniture.getCurrency());
            object4 = new ArrayList<String>(catalogPieceOfFurniture.getPropertyNames());
            Collections.sort(object4);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                String string8 = (String)object3.next();
                if (catalogPieceOfFurniture.isContentProperty(string8)) {
                    object2 = catalogPieceOfFurniture.getContentProperty(string8);
                    object = map.get(object2);
                    if (object == null && (object = this.getContentEntry((Content)object2, string4 + Character.toUpperCase(string8.charAt(0)) + string8.substring(1, string8.length()) + ".png", bl5, set)) != null) {
                        map.put((Content)object2, (String)object);
                    }
                    this.writeProperty(bufferedWriter, bl, string8 + "#" + n + ":" + ObjectProperty.Type.CONTENT.name(), this.getContentProperty((Content)object2, (String)object, bl, bl2, uRL, string));
                    continue;
                }
                object2 = catalogPieceOfFurniture.getProperty(string8);
                if (object2 == null) continue;
                object = null;
                for (FurnitureProperty furnitureProperty : furniturePropertyArray) {
                    if (!string8.equals(furnitureProperty.getName())) continue;
                    object = furnitureProperty.getType();
                }
                Object object8 = Boolean.getBoolean("com.eteks.furniturelibraryeditor.writePropertyType") && object != null && object != ObjectProperty.Type.ANY ? ":" + ((Enum)object).name() : "";
                this.writeProperty(bufferedWriter, bl, string8 + "#" + n + (String)object8, object2);
            }
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.CREATOR, n, catalogPieceOfFurniture.getCreator());
            this.writeProperty(bufferedWriter, bl, DefaultFurnitureCatalog.PropertyKey.LICENSE, n, catalogPieceOfFurniture.getLicense());
            ++n;
        }
        bufferedWriter.flush();
        if (bl) {
            Object object = stringWriter.toString();
            int n3 = ((String)object).lastIndexOf(44);
            if (n3 > 0) {
                object = ((String)object).substring(0, n3);
            }
            outputStream.write(((String)object + "\n}\n").getBytes("UTF-8"));
        }
    }

    private String floatToString(float f) {
        if ((double)Math.abs(f) < 1.0E-6) {
            return "0";
        }
        if ((double)Math.abs(f - 1.0f) < 1.0E-6) {
            return "1";
        }
        if ((double)Math.abs(f + 1.0f) < 1.0E-6) {
            return "-1";
        }
        return String.valueOf(f);
    }

    private void writeFurnitureLibraryLocalizedProperties(OutputStream outputStream, FurnitureLibrary furnitureLibrary, String string, boolean bl, FurnitureProperty[] furniturePropertyArray, boolean bl2, boolean bl3, URL uRL, String string2, Map<Content, String> map, Set<String> set) throws IOException {
        Object object;
        BufferedWriter bufferedWriter;
        boolean bl4 = !bl2 && uRL == null && string2 == null;
        StringWriter stringWriter = null;
        if (bl) {
            stringWriter = new StringWriter();
            bufferedWriter = new BufferedWriter(stringWriter);
            bufferedWriter.write("{");
        } else {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
            object = "#\n# PluginFurnitureCatalog_" + string + ".properties %tc\n# Generated by Furniture Library Editor\n#\n";
            bufferedWriter.write(String.format((String)object, new Date()));
        }
        object = new LinkedHashMap<String, DefaultFurnitureCatalog.PropertyKey>();
        object.put(FurnitureLibrary.FURNITURE_NAME_PROPERTY, DefaultFurnitureCatalog.PropertyKey.NAME);
        object.put(FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY, DefaultFurnitureCatalog.PropertyKey.DESCRIPTION);
        object.put(FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY, DefaultFurnitureCatalog.PropertyKey.INFORMATION);
        object.put(FurnitureLibrary.FURNITURE_TAGS_PROPERTY, DefaultFurnitureCatalog.PropertyKey.TAGS);
        object.put(FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, DefaultFurnitureCatalog.PropertyKey.CATEGORY);
        object.put(FurnitureLibrary.FURNITURE_LICENSE_PROPERTY, DefaultFurnitureCatalog.PropertyKey.LICENSE);
        int n = 1;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureLibrary.getFurniture()) {
            Object object2;
            Map.Entry entry22;
            bufferedWriter.newLine();
            for (Map.Entry entry22 : object.entrySet()) {
                object2 = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, (String)entry22.getKey());
                if (object2 == null) continue;
                this.writeProperty(bufferedWriter, bl, (DefaultFurnitureCatalog.PropertyKey)((Object)entry22.getValue()), n, object2);
            }
            ArrayList<String> arrayList = new ArrayList<String>(catalogPieceOfFurniture.getPropertyNames());
            Collections.sort(arrayList);
            entry22 = arrayList.iterator();
            while (entry22.hasNext()) {
                Object object4;
                Object object5;
                object2 = (String)entry22.next();
                Object object6 = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, (String)object2);
                if (object6 == null) continue;
                if (catalogPieceOfFurniture.isContentProperty((String)object2)) {
                    String string3;
                    object5 = (Content)object6;
                    object4 = map.get(object5);
                    if (object4 == null && (object4 = this.getContentEntry((Content)object5, (string3 = this.getContentBaseName(catalogPieceOfFurniture, bl3)) + Character.toUpperCase(((String)object2).charAt(0)) + ((String)object2).substring(1, ((String)object2).length()) + "_" + string + ".png", bl4, set)) != null) {
                        map.put((Content)object5, (String)object4);
                    }
                    this.writeProperty(bufferedWriter, bl, (String)object2 + "#" + n + ":" + ObjectProperty.Type.CONTENT.name(), this.getContentProperty((Content)object5, (String)object4, bl, bl2, uRL, string2));
                    continue;
                }
                object5 = (String)object6;
                object4 = null;
                for (FurnitureProperty furnitureProperty : furniturePropertyArray) {
                    if (!((String)object2).equals(furnitureProperty.getName())) continue;
                    object4 = furnitureProperty.getType();
                }
                String string4 = Boolean.getBoolean("com.eteks.furniturelibraryeditor.writePropertyType") && object4 != null && object4 != ObjectProperty.Type.ANY ? ":" + ((Enum)object4).name() : "";
                this.writeProperty(bufferedWriter, bl, (String)object2 + "#" + n + string4, object5);
            }
            ++n;
        }
        bufferedWriter.flush();
        if (bl) {
            Object object7 = stringWriter.toString();
            int n2 = ((String)object7).lastIndexOf(44);
            if (n2 > 0) {
                object7 = ((String)object7).substring(0, n2);
            }
            outputStream.write(((String)object7 + "\n}\n").getBytes("UTF-8"));
        }
    }

    private String getContentBaseName(CatalogPieceOfFurniture catalogPieceOfFurniture, boolean bl) {
        String string;
        Content content = catalogPieceOfFurniture.getModel();
        if (bl || !(content instanceof URLContent) || ((URLContent)content).getURL().getFile().toString().endsWith("model.obj")) {
            string = catalogPieceOfFurniture.getName().replace('/', '-');
        } else {
            String string2 = ((URLContent)content).getURL().getFile();
            if (string2.lastIndexOf(47) != -1) {
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
            }
            if (string2.lastIndexOf(46) != -1) {
                string2 = string2.substring(0, string2.lastIndexOf(46));
            }
            string = string2;
        }
        return string.replace('%', '_').replace('#', '_');
    }

    private String getContentEntry(Content content, String string, boolean bl, Set<String> set) throws IOException {
        if (content instanceof TemporaryURLContent || content instanceof ResourceURLContent) {
            int n = string.indexOf(47);
            if (n == -1) {
                if (set.contains(string.toLowerCase())) {
                    int n2;
                    int n3 = 2;
                    String string2 = string;
                    while (set.contains((string = string2.substring(0, n2 = string2.lastIndexOf(46)) + n3++ + string2.substring(n2)).toLowerCase())) {
                    }
                }
            } else {
                String string3 = string.substring(0, n + 1);
                int n4 = 2;
                while (true) {
                    boolean bl2 = false;
                    String string4 = string3.toLowerCase();
                    for (String string5 : set) {
                        if (!string5.startsWith(string4)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) break;
                    string3 = string.substring(0, n) + n4++ + "/";
                }
                string = string3 + string.substring(n + 1);
            }
            set.add(string.toLowerCase());
            return string;
        }
        if (content instanceof URLContent) {
            if (bl) {
                return null;
            }
            URLContent uRLContent = (URLContent)content;
            if (uRLContent.isJAREntry()) {
                String string6 = uRLContent.getJAREntryURL().getFile();
                int n = (string6 = string6.substring(string6.lastIndexOf(47) + 1)).lastIndexOf(".zip");
                if (n == -1) {
                    return null;
                }
                string6 = string6.substring(0, n);
                string = string6 + "/" + uRLContent.getJAREntryName();
            } else {
                String string7 = uRLContent.getURL().getFile();
                string = string7.substring(string7.lastIndexOf(47) + 1);
            }
            set.add(string.toLowerCase());
            return string;
        }
        throw new IOException("Unexpected content class: " + content.getClass().getName());
    }

    private String getContentProperty(Content content, String string, boolean bl, boolean bl2, URL uRL, String string2) throws IOException {
        if (!bl && (bl2 || uRL == null && string2 == null)) {
            return "/" + string;
        }
        if (content instanceof TemporaryURLContent || content instanceof ResourceURLContent || uRL != null || string2 != null || bl) {
            int n = string.indexOf(47);
            if (n == -1) {
                if (uRL != null) {
                    return new URL(uRL, string).toString();
                }
                return string2 + string;
            }
            String string3 = URLEncoder.encode(string.substring(n + 1), "UTF-8").replace("+", "%20").replace("%2F", "/");
            if (uRL != null) {
                return "jar:" + new URL(uRL, string.substring(0, n) + ".zip") + "!/" + string3;
            }
            return string2 + string.substring(0, n) + ".zip!/" + string3;
        }
        return ((URLContent)content).getURL().toString();
    }

    private void writeProperty(BufferedWriter bufferedWriter, boolean bl, DefaultFurnitureCatalog.PropertyKey propertyKey, int n, Object object) throws IOException {
        this.writeProperty(bufferedWriter, bl, propertyKey.getKey(n), object);
    }

    private void writeProperty(BufferedWriter bufferedWriter, boolean bl, String string, Object object) throws IOException {
        if (object != null) {
            String string2;
            bufferedWriter.write(bl ? " \"" + string.replace("\\", "\\\\").replace("\"", "\\\"") : string.replace(":", "\\:").replace("=", "\\=").replace(" ", "\\ "));
            bufferedWriter.write(bl ? "\": \"" : "=");
            if (object.getClass().isArray()) {
                string2 = Arrays.toString((Object[])object);
                string2 = string2.substring(1, string2.length() - 1);
            } else {
                string2 = object instanceof Float ? DECIMAL_FORMAT.format(object) : object.toString();
            }
            CharsetEncoder charsetEncoder = Charset.forName(bl ? "UTF-8" : "ISO-8859-1").newEncoder();
            block5: for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case '\\': {
                        bufferedWriter.write(92);
                        bufferedWriter.write(92);
                        continue block5;
                    }
                    case '\t': {
                        bufferedWriter.write(92);
                        bufferedWriter.write(116);
                        continue block5;
                    }
                    case '\"': {
                        if (bl) {
                            bufferedWriter.write(92);
                            bufferedWriter.write(34);
                            continue block5;
                        }
                    }
                    default: {
                        if (charsetEncoder.canEncode(c)) {
                            bufferedWriter.write(c);
                            continue block5;
                        }
                        bufferedWriter.write(92);
                        bufferedWriter.write(117);
                        bufferedWriter.write(Integer.toHexString(c >> 12 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c >> 8 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c >> 4 & 0xF));
                        bufferedWriter.write(Integer.toHexString(c & 0xF));
                    }
                }
            }
            if (bl) {
                bufferedWriter.write("\",");
            }
            bufferedWriter.newLine();
        }
    }

    private void writeContents(ZipOutputStream zipOutputStream, boolean bl, String string, Map<Content, String> map) throws IOException, InterruptedRecorderException {
        Serializable serializable;
        if (bl && string != null) {
            serializable = new File(string);
            if (!((File)serializable).exists()) {
                if (!((File)serializable).mkdirs()) {
                    throw new IOException("Can't create directory " + serializable);
                }
            } else if (!((File)serializable).isDirectory()) {
                throw new IOException(serializable + " isn't a directory");
            }
        }
        serializable = new HashMap();
        for (Map.Entry<Content, String> entry : map.entrySet()) {
            Content content = entry.getKey();
            if (content instanceof URLContent) {
                URLContent uRLContent = (URLContent)content;
                String string2 = entry.getValue();
                if (string2.indexOf(47) != -1) {
                    this.writeZipEntries(zipOutputStream, bl, string, uRLContent, string2, (Map<String, List<ZipEntry>>)((Object)serializable));
                } else if (!bl || string == null) {
                    this.writeZipEntry(zipOutputStream, uRLContent, string2);
                } else {
                    File file = new File(string, string2);
                    if (!file.exists()) {
                        this.copyContent(uRLContent, file);
                    }
                }
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptedRecorderException();
        }
    }

    private void writeZipEntries(ZipOutputStream zipOutputStream, boolean bl, String string, URLContent uRLContent, String string2, Map<String, List<ZipEntry>> map) throws IOException {
        int n;
        Object object;
        String string3 = string2.substring(0, string2.indexOf(47));
        if (bl && string != null) {
            object = new File(string, string3 + ".zip");
            if (((File)object).exists()) {
                return;
            }
            zipOutputStream = new ZipOutputStream(new FileOutputStream((File)object));
            string3 = "";
        } else {
            string3 = string3 + "/";
        }
        object = "";
        if (uRLContent instanceof ResourceURLContent && (n = ((String)(object = URLDecoder.decode(uRLContent.getJAREntryName().replace("+", "%2B"), "UTF-8"))).lastIndexOf(47)) != -1) {
            object = ((String)object).substring(0, n + 1);
        }
        if (uRLContent instanceof ResourceURLContent && !((ResourceURLContent)uRLContent).isMultiPartResource() && bl) {
            this.writeZipEntry(zipOutputStream, uRLContent, string2.substring(string2.indexOf(47) + 1));
        } else {
            URL uRL = uRLContent.getJAREntryURL();
            List<ZipEntry> list = map.get(uRL.toString());
            if (list == null) {
                list = this.getZipEntries(uRL);
                map.put(uRL.toString(), list);
            }
            for (ZipEntry zipEntry : list) {
                String string4 = zipEntry.getName();
                URLContent uRLContent2 = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                if (((String)object).length() == 0) {
                    boolean bl2 = true;
                    for (String string5 : IGNORED_EXTENSIONS) {
                        if (!string4.toLowerCase().endsWith(string5)) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    this.writeZipEntry(zipOutputStream, uRLContent2, string3 + string4);
                    continue;
                }
                if (!string4.startsWith((String)object)) continue;
                this.writeZipEntry(zipOutputStream, uRLContent2, string3 + string4.substring(((String)object).length()));
            }
        }
        if (bl && string != null) {
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZipEntry> getZipEntries(URL uRL) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            Cloneable cloneable;
            ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
            zipInputStream = new ZipInputStream(uRL.openStream());
            while ((cloneable = zipInputStream.getNextEntry()) != null) {
                arrayList.add((ZipEntry)cloneable);
            }
            cloneable = arrayList;
            return cloneable;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, URLContent uRLContent, String string) throws IOException {
        byte[] byArray = new byte[8096];
        InputStream inputStream = null;
        try {
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            inputStream = uRLContent.openStream();
            while ((n = inputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void copyContent(Content content, File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = content.openStream();
            this.copyContentToFile(inputStream, file);
        }
        catch (IOException iOException) {
            throw new IOException("Can't copy content " + content + " to " + file);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.copyContentToFile(fileInputStream, file2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't copy file " + file + " to " + file2);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContentToFile(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't close file " + file);
            }
        }
    }
}

