/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.model;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.UserPreferences;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FurnitureLibraryUserPreferences
extends UserPreferences {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String[] editedProperties = new String[]{FurnitureLibrary.FURNITURE_MODEL_PROPERTY, FurnitureLibrary.FURNITURE_ICON_PROPERTY, FurnitureLibrary.FURNITURE_NAME_PROPERTY, FurnitureLibrary.FURNITURE_TAGS_PROPERTY, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, FurnitureLibrary.FURNITURE_CREATOR_PROPERTY, FurnitureLibrary.FURNITURE_WIDTH_PROPERTY, FurnitureLibrary.FURNITURE_DEPTH_PROPERTY, FurnitureLibrary.FURNITURE_HEIGHT_PROPERTY, FurnitureLibrary.FURNITURE_ELEVATION_PROPERTY, FurnitureLibrary.FURNITURE_MOVABLE_PROPERTY, FurnitureLibrary.FURNITURE_DOOR_OR_WINDOW_PROPERTY, FurnitureLibrary.FURNITURE_DOOR_OR_WINDOW_CUT_OUT_SHAPE_PROPERTY, FurnitureLibrary.FURNITURE_STAIRCASE_CUT_OUT_SHAPE_PROPERTY, FurnitureLibrary.FURNITURE_MODEL_ROTATION_PROPERTY};
    private FurnitureProperty[] furnitureProperties;
    private String defaultCreator;
    private boolean offlineFurnitureLibrary;
    private String furnitureResourcesLocalDirectory;
    private String furnitureResourcesRemoteUrlBase;
    private boolean furnitureIdEditable;
    private boolean contentMatchingFurnitureName;
    private boolean furnitureNameEqualToImportedModelFileName;

    public FurnitureLibraryUserPreferences() {
        this.setUnit(LengthUnit.CENTIMETER);
        this.offlineFurnitureLibrary = true;
        this.contentMatchingFurnitureName = true;
    }

    public String[] getSupportedLanguages() {
        return new String[]{"en", "fr"};
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public String getFurnitureDefaultLanguage() {
        return this.getLanguage();
    }

    public String[] getEditedProperties() {
        return this.editedProperties;
    }

    public FurnitureProperty[] getFurnitureProperties() {
        if (this.furnitureProperties == null) {
            DefaultFurnitureCatalog.PropertyKey[] propertyKeyArray;
            ArrayList<FurnitureProperty> arrayList = new ArrayList<FurnitureProperty>();
            Object[] objectArray = (String[])this.getEditedProperties().clone();
            Arrays.sort(objectArray);
            for (DefaultFurnitureCatalog.PropertyKey propertyKey : propertyKeyArray = new DefaultFurnitureCatalog.PropertyKey[]{DefaultFurnitureCatalog.PropertyKey.ID, DefaultFurnitureCatalog.PropertyKey.ICON, DefaultFurnitureCatalog.PropertyKey.PLAN_ICON, DefaultFurnitureCatalog.PropertyKey.MODEL, DefaultFurnitureCatalog.PropertyKey.NAME, DefaultFurnitureCatalog.PropertyKey.DESCRIPTION, DefaultFurnitureCatalog.PropertyKey.INFORMATION, DefaultFurnitureCatalog.PropertyKey.TAGS, DefaultFurnitureCatalog.PropertyKey.CATEGORY, DefaultFurnitureCatalog.PropertyKey.CREATOR, DefaultFurnitureCatalog.PropertyKey.LICENSE, DefaultFurnitureCatalog.PropertyKey.CREATION_DATE, DefaultFurnitureCatalog.PropertyKey.MODEL_SIZE, DefaultFurnitureCatalog.PropertyKey.MODEL_ROTATION, DefaultFurnitureCatalog.PropertyKey.MODEL_FLAGS, DefaultFurnitureCatalog.PropertyKey.HORIZONTALLY_ROTATABLE, DefaultFurnitureCatalog.PropertyKey.GRADE, DefaultFurnitureCatalog.PropertyKey.WIDTH, DefaultFurnitureCatalog.PropertyKey.DEPTH, DefaultFurnitureCatalog.PropertyKey.HEIGHT, DefaultFurnitureCatalog.PropertyKey.ELEVATION, DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION, DefaultFurnitureCatalog.PropertyKey.MOVABLE, DefaultFurnitureCatalog.PropertyKey.RESIZABLE, DefaultFurnitureCatalog.PropertyKey.DEFORMABLE, DefaultFurnitureCatalog.PropertyKey.TEXTURABLE, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_CUT_OUT_SHAPE, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE, DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_X, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER, DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_MATERIAL_NAME, DefaultFurnitureCatalog.PropertyKey.SHELF_ELEVATIONS, DefaultFurnitureCatalog.PropertyKey.SHELF_BOXES, DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE, DefaultFurnitureCatalog.PropertyKey.PRICE, DefaultFurnitureCatalog.PropertyKey.CURRENCY, DefaultFurnitureCatalog.PropertyKey.VALUE_ADDED_TAX_PERCENTAGE}) {
                boolean bl;
                boolean bl2;
                ObjectProperty.Type type;
                switch (propertyKey) {
                    case ICON: 
                    case PLAN_ICON: 
                    case MODEL: {
                        type = ObjectProperty.Type.CONTENT;
                        break;
                    }
                    case CREATION_DATE: {
                        type = ObjectProperty.Type.DATE;
                    }
                    case MOVABLE: 
                    case DOOR_OR_WINDOW: 
                    case RESIZABLE: 
                    case DEFORMABLE: 
                    case TEXTURABLE: 
                    case HORIZONTALLY_ROTATABLE: 
                    case DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES: 
                    case DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE: {
                        type = ObjectProperty.Type.BOOLEAN;
                        break;
                    }
                    case MODEL_FLAGS: 
                    case MODEL_SIZE: {
                        type = ObjectProperty.Type.INTEGER;
                        break;
                    }
                    case GRADE: {
                        type = ObjectProperty.Type.NUMBER;
                        break;
                    }
                    case PRICE: {
                        type = ObjectProperty.Type.PRICE;
                        break;
                    }
                    case VALUE_ADDED_TAX_PERCENTAGE: {
                        type = ObjectProperty.Type.PERCENTAGE;
                        break;
                    }
                    case WIDTH: 
                    case DEPTH: 
                    case HEIGHT: 
                    case ELEVATION: 
                    case DROP_ON_TOP_ELEVATION: 
                    case DOOR_OR_WINDOW_WALL_THICKNESS: 
                    case DOOR_OR_WINDOW_WALL_DISTANCE: {
                        type = ObjectProperty.Type.LENGTH;
                        break;
                    }
                    default: {
                        type = ObjectProperty.Type.STRING;
                    }
                }
                switch (propertyKey) {
                    case ID: {
                        bl2 = this.isFurnitureIdEditable();
                        break;
                    }
                    case MODEL_SIZE: {
                        bl2 = false;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                switch (propertyKey) {
                    case MODEL: 
                    case HORIZONTALLY_ROTATABLE: 
                    case DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES: 
                    case DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE: 
                    case DROP_ON_TOP_ELEVATION: 
                    case DOOR_OR_WINDOW_WALL_THICKNESS: 
                    case DOOR_OR_WINDOW_WALL_DISTANCE: 
                    case ICON_DIGEST: 
                    case PLAN_ICON_DIGEST: 
                    case MODEL_DIGEST: 
                    case MODEL_ROTATION: 
                    case DOOR_OR_WINDOW_CUT_OUT_SHAPE: 
                    case DOOR_OR_WINDOW_SASH_X_AXIS: 
                    case DOOR_OR_WINDOW_SASH_Y_AXIS: 
                    case DOOR_OR_WINDOW_SASH_WIDTH: 
                    case DOOR_OR_WINDOW_SASH_START_ANGLE: 
                    case DOOR_OR_WINDOW_SASH_END_ANGLE: 
                    case LIGHT_SOURCE_X: 
                    case LIGHT_SOURCE_Y: 
                    case LIGHT_SOURCE_Z: 
                    case LIGHT_SOURCE_DIAMETER: 
                    case LIGHT_SOURCE_COLOR: 
                    case LIGHT_SOURCE_MATERIAL_NAME: 
                    case SHELF_ELEVATIONS: 
                    case SHELF_BOXES: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                boolean bl3 = Arrays.binarySearch(objectArray, propertyKey.name()) >= 0 || propertyKey == DefaultFurnitureCatalog.PropertyKey.ID && this.isFurnitureIdEditable();
                arrayList.add(new FurnitureProperty(propertyKey.getKeyPrefix(), type, propertyKey.name(), bl, bl3 && bl || propertyKey == DefaultFurnitureCatalog.PropertyKey.ICON, bl2, bl3 && propertyKey != DefaultFurnitureCatalog.PropertyKey.ICON));
            }
            this.furnitureProperties = arrayList.toArray(new FurnitureProperty[arrayList.size()]);
        }
        return (FurnitureProperty[])this.furnitureProperties.clone();
    }

    public void setFurnitureProperties(FurnitureProperty[] furniturePropertyArray) {
        if (furniturePropertyArray != this.furnitureProperties) {
            FurnitureProperty[] furniturePropertyArray2 = this.furnitureProperties;
            Boolean bl = null;
            for (int i = 0; i < furniturePropertyArray.length; ++i) {
                FurnitureProperty furnitureProperty = furniturePropertyArray[i];
                if (!DefaultFurnitureCatalog.PropertyKey.ID.name().equals(furnitureProperty.getDefaultPropertyKeyName()) || furniturePropertyArray[i].isEditable() == furniturePropertyArray[i].isEditable()) continue;
                bl = furniturePropertyArray[i].isEditable();
                break;
            }
            this.furnitureProperties = (FurnitureProperty[])furniturePropertyArray.clone();
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_PROPERTIES.name(), furniturePropertyArray2, furniturePropertyArray);
            if (bl != null) {
                this.setFurnitureIdEditable(bl, false);
            }
        }
    }

    public boolean isModelContentAlwaysConvertedToOBJFormat() {
        return false;
    }

    public String getDefaultCreator() {
        return this.defaultCreator;
    }

    public void setDefaultCreator(String string) {
        if (!(string == this.defaultCreator || string != null && string.equals(this.defaultCreator))) {
            String string2 = this.defaultCreator;
            this.defaultCreator = string;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_CREATOR.name(), string2, string);
        }
    }

    public boolean isOnlineFurnitureLibrarySupported() {
        return false;
    }

    public boolean isFurnitureLibraryOffline() {
        return this.offlineFurnitureLibrary;
    }

    public void setFurnitureLibraryOffline(boolean bl) {
        if (!this.isOnlineFurnitureLibrarySupported() && !bl) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (bl != this.offlineFurnitureLibrary) {
            this.offlineFurnitureLibrary = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OFFLINE_FURNITURE_LIBRARY.name(), !bl, bl);
        }
    }

    public String getFurnitureResourcesLocalDirectory() {
        return this.furnitureResourcesLocalDirectory;
    }

    public void setFurnitureResourcesLocalDirectory(String string) {
        if (!this.isOnlineFurnitureLibrarySupported()) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (!(string == this.furnitureResourcesLocalDirectory || string != null && string.equals(this.furnitureResourcesLocalDirectory))) {
            String string2 = this.furnitureResourcesLocalDirectory;
            this.furnitureResourcesLocalDirectory = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_LOCAL_DIRECTORY.name(), string2, string);
        }
    }

    public String getFurnitureResourcesRemoteURLBase() {
        return this.furnitureResourcesRemoteUrlBase;
    }

    public void setFurnitureResourcesRemoteURLBase(String string) {
        if (!this.isOnlineFurnitureLibrarySupported()) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (!(string == this.furnitureResourcesRemoteUrlBase || string != null && string.equals(this.furnitureResourcesRemoteUrlBase))) {
            String string2 = this.furnitureResourcesRemoteUrlBase;
            this.furnitureResourcesRemoteUrlBase = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_REMOTE_URL_BASE.name(), string2, string);
        }
    }

    public boolean isFurnitureIdEditable() {
        return this.furnitureIdEditable;
    }

    public void setFurnitureIdEditable(boolean bl) {
        this.setFurnitureIdEditable(bl, true);
    }

    private void setFurnitureIdEditable(boolean bl, boolean bl2) {
        if (bl != this.furnitureIdEditable) {
            this.furnitureIdEditable = bl;
            FurnitureProperty[] furniturePropertyArray = this.getFurnitureProperties();
            for (int i = 0; i < furniturePropertyArray.length; ++i) {
                FurnitureProperty furnitureProperty = furniturePropertyArray[i];
                if (!DefaultFurnitureCatalog.PropertyKey.ID.name().equals(furnitureProperty.getDefaultPropertyKeyName())) continue;
                furniturePropertyArray[i] = new FurnitureProperty(furnitureProperty.getName(), furnitureProperty.getType(), furnitureProperty.getDefaultPropertyKeyName(), furnitureProperty.isDisplayed(), furnitureProperty.isDisplayable(), bl, bl);
            }
            this.setFurnitureProperties(furniturePropertyArray);
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_ID_EDITABLE.name(), !bl, bl);
        }
    }

    public boolean isContentMatchingFurnitureName() {
        return this.contentMatchingFurnitureName;
    }

    public void setContentMatchingFurnitureName(boolean bl) {
        if (bl != this.contentMatchingFurnitureName) {
            this.contentMatchingFurnitureName = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CONTENT_MATCHING_FURNITURE_NAME.name(), !bl, bl);
        }
    }

    public boolean isFurnitureNameEqualToImportedModelFileName() {
        return this.furnitureNameEqualToImportedModelFileName;
    }

    public void setFurnitureNameEqualToImportedModelFileName(boolean bl) {
        if (bl != this.furnitureNameEqualToImportedModelFileName) {
            this.furnitureNameEqualToImportedModelFileName = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_NAME_EQUAL_TO_IMPORTED_MODEL_FILE_NAME.name(), !bl, bl);
        }
    }

    public boolean isCheckUpdatesEnabled() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        FURNITURE_PROPERTIES,
        DEFAULT_CREATOR,
        OFFLINE_FURNITURE_LIBRARY,
        FURNITURE_RESOURCES_LOCAL_DIRECTORY,
        FURNITURE_RESOURCES_REMOTE_URL_BASE,
        FURNITURE_ID_EDITABLE,
        CONTENT_MATCHING_FURNITURE_NAME,
        FURNITURE_NAME_EQUAL_TO_IMPORTED_MODEL_FILE_NAME;

    }
}

