/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLibraryController;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.CatalogItemToolTip;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibraryTable
extends JTable
implements View {
    private ListSelectionListener tableSelectionListener;
    private CatalogItemToolTip toolTip;

    public FurnitureLibraryTable(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLibraryController furnitureLibraryController, FurnitureLanguageController furnitureLanguageController) {
        super(new FurnitureLibraryTableModel(furnitureLibrary, furnitureLanguageController), new FurnitureLibraryTableColumnModel(furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController));
        this.toolTip = new CatalogItemToolTip(CatalogItemToolTip.DisplayedInformation.ICON, (UserPreferences)furnitureLibraryUserPreferences);
        float f = SwingTools.getResolutionScale();
        if (f != 1.0f) {
            this.setRowHeight(Math.round((float)this.getRowHeight() * f));
        }
        this.addTableHeaderListener();
        this.setAutoResizeMode(0);
        this.updateTableColumnsWidth();
        if (furnitureLibraryController != null) {
            this.addSelectionListeners(furnitureLibraryController);
            this.addMouseListener(furnitureLibraryController);
            this.addFurnitureLanguageListener(furnitureLibrary, furnitureLanguageController);
            this.setTransferHandler(new TableTransferHandler(furnitureLibraryController));
        }
        this.addUserPreferencesListener(furnitureLibraryUserPreferences, furnitureLibrary, furnitureLanguageController);
    }

    private void addUserPreferencesListener(FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
        UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this, furnitureLibrary, furnitureLanguageController);
        furnitureLibraryUserPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, (PropertyChangeListener)userPreferencesChangeListener);
        furnitureLibraryUserPreferences.addPropertyChangeListener(FurnitureLibraryUserPreferences.Property.FURNITURE_ID_EDITABLE, (PropertyChangeListener)userPreferencesChangeListener);
        furnitureLibraryUserPreferences.addPropertyChangeListener(FurnitureLibraryUserPreferences.Property.FURNITURE_PROPERTIES, (PropertyChangeListener)userPreferencesChangeListener);
    }

    private void addSelectionListeners(final FurnitureLibraryController furnitureLibraryController) {
        final SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureLibraryTable.this.setSelectedFurniture(furnitureLibraryController.getSelectedFurniture());
            }
        };
        this.tableSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    furnitureLibraryController.removeSelectionListener(selectionListener);
                    int[] nArray = FurnitureLibraryTable.this.getSelectedRows();
                    ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>(nArray.length);
                    TableModel tableModel = FurnitureLibraryTable.this.getModel();
                    for (int n : nArray) {
                        arrayList.add((CatalogPieceOfFurniture)tableModel.getValueAt(n, 0));
                    }
                    furnitureLibraryController.setSelectedFurniture(arrayList);
                    furnitureLibraryController.addSelectionListener(selectionListener);
                }
            }
        };
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        furnitureLibraryController.addSelectionListener(selectionListener);
    }

    private void addMouseListener(final FurnitureLibraryController furnitureLibraryController) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    furnitureLibraryController.modifySelectedFurniture();
                }
            }
        });
    }

    private void addTableHeaderListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)FurnitureLibraryTable.this.getModel();
                ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
                for (int n : FurnitureLibraryTable.this.getSelectedRows()) {
                    arrayList.add((CatalogPieceOfFurniture)furnitureLibraryTableModel.getValueAt(n, 0));
                }
                int n = FurnitureLibraryTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                Object object = FurnitureLibraryTable.this.getColumnModel().getColumn(n).getIdentifier();
                if (object instanceof FurnitureProperty) {
                    FurnitureProperty furnitureProperty = (FurnitureProperty)object;
                    if (object.equals(furnitureLibraryTableModel.getSortProperty())) {
                        if (furnitureLibraryTableModel.isDescendingOrder()) {
                            furnitureLibraryTableModel.setSortProperty(null);
                        } else {
                            furnitureLibraryTableModel.setDescendingOrder(true);
                        }
                    } else if (furnitureLibraryTableModel.getFurnitureComparator(furnitureProperty) != null) {
                        furnitureLibraryTableModel.setSortProperty(furnitureProperty);
                        furnitureLibraryTableModel.setDescendingOrder(false);
                    }
                }
                FurnitureLibraryTable.this.getTableHeader().repaint();
                FurnitureLibraryTable.this.setSelectedFurniture(arrayList);
            }
        });
    }

    private void setSelectedFurniture(List<CatalogPieceOfFurniture> list) {
        this.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.clearSelection();
        FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)this.getModel();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
            int n3;
            if (!(catalogPieceOfFurniture instanceof CatalogPieceOfFurniture) || (n3 = furnitureLibraryTableModel.getPieceOfFurnitureIndex(catalogPieceOfFurniture)) == -1) continue;
            this.addRowSelectionInterval(n3, n3);
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        if (n != Integer.MIN_VALUE) {
            this.makeRowsVisible(n, n2);
        }
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    private void makeRowsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (n != n2) {
            rectangle = rectangle.union(this.getCellRect(n2, 0, true));
        }
        if (this.getAutoResizeMode() == 0) {
            int n3 = this.getColumnCount() - 1;
            rectangle = rectangle.union(this.getCellRect(n, n3, true));
            if (n != n2) {
                rectangle = rectangle.union(this.getCellRect(n2, n3, true));
            }
        }
        this.scrollRectToVisible(rectangle);
    }

    private void addFurnitureLanguageListener(FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
            private boolean sorting = false;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!this.sorting) {
                    this.sorting = true;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)FurnitureLibraryTable.this.getModel();
                            ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
                            for (int n : FurnitureLibraryTable.this.getSelectedRows()) {
                                arrayList.add((CatalogPieceOfFurniture)furnitureLibraryTableModel.getValueAt(n, 0));
                            }
                            furnitureLibraryTableModel.sortFurniture();
                            FurnitureLibraryTable.this.setSelectedFurniture(arrayList);
                            sorting = false;
                        }
                    });
                }
            }
        };
        furnitureLanguageController.addPropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, propertyChangeListener);
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.LOCALIZED_DATA, propertyChangeListener);
    }

    private void updateTableColumnsWidth() {
        int n = this.getIntercellSpacing().width;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableModel tableModel = this.getModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = this.convertColumnIndexToModel(i);
            int n4 = tableColumn.getPreferredWidth();
            n4 = Math.max(n4, tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
            int n5 = tableModel.getRowCount();
            for (int j = 0; j < n5; ++j) {
                n4 = Math.max(n4, tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this, (Object)tableModel.getValueAt((int)j, (int)n3), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
            }
            tableColumn.setPreferredWidth(n4 + n);
            tableColumn.setWidth(n4 + n);
        }
    }

    @Override
    public JToolTip createToolTip() {
        if (this.toolTip.isTipTextComplete()) {
            return super.createToolTip();
        }
        this.toolTip.setComponent(this);
        return this.toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n2 != -1 && DefaultFurnitureCatalog.PropertyKey.ICON.getKeyPrefix().equals(((FurnitureProperty)this.getColumnModel().getColumn(n2).getIdentifier()).getName()) && (n = this.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.toolTip.setCatalogItem((CatalogPieceOfFurniture)this.getModel().getValueAt(n, this.convertColumnIndexToModel(n2)));
            return this.toolTip.getTipText();
        }
        return null;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, 400);
    }

    private class TableTransferHandler
    extends TransferHandler {
        private final FurnitureLibraryController furnitureController;

        public TableTransferHandler(FurnitureLibraryController furnitureLibraryController) {
            this.furnitureController = furnitureLibraryController;
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return this.furnitureController != null && Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    final ArrayList<String> arrayList = new ArrayList<String>();
                    for (File file : list) {
                        if (file.isDirectory()) continue;
                        String string = file.getAbsolutePath();
                        arrayList.add(string);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            TableTransferHandler.this.furnitureController.importFurniture(arrayList.toArray(new String[arrayList.size()]));
                        }
                    });
                    return !arrayList.isEmpty();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    throw new RuntimeException("Can't import", unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Can't access to data", iOException);
                }
            }
            return false;
        }
    }

    private static class FurnitureLibraryTableColumnModel
    extends DefaultTableColumnModel {
        public FurnitureLibraryTableColumnModel(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController) {
            this.createColumns(furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController);
            this.addLanguageListener(furnitureLibraryUserPreferences);
        }

        private void createColumns(FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController) {
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer();
            ArrayList<FurnitureProperty> arrayList = new ArrayList<FurnitureProperty>();
            for (FurnitureProperty furnitureProperty : furnitureLibraryUserPreferences.getFurnitureProperties()) {
                if (!furnitureProperty.isDisplayed()) continue;
                arrayList.add(furnitureProperty);
            }
            for (FurnitureProperty furnitureProperty : arrayList) {
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(furnitureProperty);
                tableColumn.setHeaderValue(this.getColumnName(furnitureProperty, furnitureLibraryUserPreferences));
                tableColumn.setPreferredWidth(this.getColumnPreferredWidth(furnitureProperty));
                tableColumn.setCellRenderer(this.getColumnRenderer(furnitureProperty, furnitureLibrary, furnitureLibraryUserPreferences, furnitureLanguageController));
                tableColumn.setHeaderRenderer(tableCellRenderer);
                this.addColumn(tableColumn);
            }
        }

        private void addLanguageListener(UserPreferences userPreferences) {
            userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
        }

        private String getColumnName(FurnitureProperty furnitureProperty, UserPreferences userPreferences) {
            if (furnitureProperty.getDefaultPropertyKeyName() != null) {
                try {
                    return userPreferences.getLocalizedString(FurnitureLibraryTable.class, furnitureProperty.getName() + "Column", new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return furnitureProperty.getName();
        }

        private int getColumnPreferredWidth(FurnitureProperty furnitureProperty) {
            String string = furnitureProperty.getName();
            if (DefaultFurnitureCatalog.PropertyKey.ID.getKeyPrefix().equals(string)) {
                return 120;
            }
            if (DefaultFurnitureCatalog.PropertyKey.DESCRIPTION.getKeyPrefix().equals(string) || DefaultFurnitureCatalog.PropertyKey.INFORMATION.getKeyPrefix().equals(string) || DefaultFurnitureCatalog.PropertyKey.TAGS.getKeyPrefix().equals(string)) {
                return 150;
            }
            if (DefaultFurnitureCatalog.PropertyKey.CATEGORY.getKeyPrefix().equals(string) || DefaultFurnitureCatalog.PropertyKey.LICENSE.getKeyPrefix().equals(string)) {
                return 70;
            }
            if (DefaultFurnitureCatalog.PropertyKey.PRICE.getKeyPrefix().equals(string)) {
                return 70;
            }
            if (DefaultFurnitureCatalog.PropertyKey.ICON.getKeyPrefix().equals(string) || DefaultFurnitureCatalog.PropertyKey.PLAN_ICON.getKeyPrefix().equals(string)) {
                return 50;
            }
            if (DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKeyPrefix().equals(string)) {
                return 20;
            }
            if (furnitureProperty.getType() != null) {
                switch (furnitureProperty.getType()) {
                    case BOOLEAN: {
                        return 20;
                    }
                    case DATE: 
                    case INTEGER: 
                    case PERCENTAGE: 
                    case PRICE: 
                    case CONTENT: {
                        return 50;
                    }
                    case LENGTH: 
                    case NUMBER: {
                        return 45;
                    }
                }
                return 100;
            }
            return 70;
        }

        private TableCellRenderer getColumnRenderer(final FurnitureProperty furnitureProperty, FurnitureLibrary furnitureLibrary, UserPreferences userPreferences, FurnitureLanguageController furnitureLanguageController) {
            if (DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKeyPrefix().equals(furnitureProperty.getName())) {
                return this.getBooleanRenderer(furnitureProperty);
            }
            if (furnitureProperty.getType() != null && furnitureProperty.getType() != ObjectProperty.Type.ANY) {
                switch (furnitureProperty.getType()) {
                    case BOOLEAN: {
                        return this.getBooleanRenderer(furnitureProperty);
                    }
                    case DATE: {
                        return this.getDateRenderer(furnitureProperty);
                    }
                    case INTEGER: {
                        return this.getIntegerRenderer(furnitureProperty);
                    }
                    case PERCENTAGE: {
                        return this.getPercentageRenderer(furnitureProperty);
                    }
                    case CONTENT: {
                        return this.getIconRenderer(furnitureProperty);
                    }
                    case LENGTH: {
                        return this.getLengthRenderer(furnitureProperty, userPreferences);
                    }
                    case NUMBER: {
                        return this.getNumberRenderer(furnitureProperty);
                    }
                    case PRICE: {
                        return this.getPriceRenderer(furnitureProperty, userPreferences);
                    }
                }
                return this.getStringRenderer(furnitureProperty, furnitureLibrary, furnitureLanguageController);
            }
            return new DefaultTableCellRenderer(){
                private TableCellRenderer booleanRenderer;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    String string;
                    block4: {
                        string = ((CatalogPieceOfFurniture)object).getProperty(furnitureProperty.getName());
                        if (string != null) {
                            try {
                                super.getTableCellRendererComponent(jTable, NumberFormat.getInstance().format(new BigDecimal(string)), bl, bl2, n, n2);
                                this.setHorizontalAlignment(4);
                                return this;
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) break block4;
                                if (this.booleanRenderer == null) {
                                    this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                                }
                                return this.booleanRenderer.getTableCellRendererComponent(jTable, Boolean.parseBoolean(string), bl, bl2, n, n2);
                            }
                        }
                    }
                    super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                    this.setHorizontalAlignment(2);
                    return this;
                }
            };
        }

        private TableCellRenderer getStringRenderer(final FurnitureProperty furnitureProperty, final FurnitureLibrary furnitureLibrary, final FurnitureLanguageController furnitureLanguageController) {
            final String string = furnitureProperty.getName();
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    if (DefaultFurnitureCatalog.PropertyKey.ID.getKeyPrefix().equals(string)) {
                        object = catalogPieceOfFurniture.getId();
                    } else if (DefaultFurnitureCatalog.PropertyKey.NAME.getKeyPrefix().equals(string)) {
                        object = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getName());
                    } else if (DefaultFurnitureCatalog.PropertyKey.DESCRIPTION.getKeyPrefix().equals(string)) {
                        object = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getDescription());
                    } else if (DefaultFurnitureCatalog.PropertyKey.INFORMATION.getKeyPrefix().equals(string)) {
                        object = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getInformation());
                    } else if (DefaultFurnitureCatalog.PropertyKey.CREATOR.getKeyPrefix().equals(string)) {
                        object = catalogPieceOfFurniture.getCreator();
                    } else if (DefaultFurnitureCatalog.PropertyKey.LICENSE.getKeyPrefix().equals(string)) {
                        object = furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getLicense());
                    } else if (DefaultFurnitureCatalog.PropertyKey.TAGS.getKeyPrefix().equals(string)) {
                        String string2 = Arrays.toString((String[])furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getTags()));
                        object = string2.substring(1, string2.length() - 1);
                    } else {
                        object = DefaultFurnitureCatalog.PropertyKey.CATEGORY.getKeyPrefix().equals(string) ? furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getCategory().getName()) : (DefaultFurnitureCatalog.PropertyKey.CURRENCY.getKeyPrefix().equals(string) ? catalogPieceOfFurniture.getCurrency() : (String)furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, furnitureLanguageController.getFurnitureLangauge(), string, catalogPieceOfFurniture.getProperty(string)));
                    }
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getIconRenderer(FurnitureProperty furnitureProperty) {
            final String string = furnitureProperty.getName();
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    object = DefaultFurnitureCatalog.PropertyKey.ICON.getKeyPrefix().equals(string) ? catalogPieceOfFurniture.getIcon() : (DefaultFurnitureCatalog.PropertyKey.PLAN_ICON.getKeyPrefix().equals(string) ? catalogPieceOfFurniture.getPlanIcon() : catalogPieceOfFurniture.getContentProperty(string));
                    if (object != null) {
                        jLabel.setIcon(IconManager.getInstance().getIcon((Content)object, jTable.getRowHeight() - 1, jTable));
                        jLabel.setHorizontalAlignment(0);
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getDateRenderer(final FurnitureProperty furnitureProperty) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    try {
                        CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                        object = DefaultFurnitureCatalog.PropertyKey.CREATION_DATE.getKeyPrefix().equals(furnitureProperty.getName()) ? catalogPieceOfFurniture.getCreationDate() : new SimpleDateFormat("yyyy-MM-dd").parse(catalogPieceOfFurniture.getProperty(furnitureProperty.getName()));
                    }
                    catch (NullPointerException nullPointerException) {
                        object = null;
                    }
                    catch (ParseException parseException) {
                        object = null;
                    }
                    object = object != null ? DateFormat.getDateInstance(3).format(object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getIntegerRenderer(final FurnitureProperty furnitureProperty) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    if (DefaultFurnitureCatalog.PropertyKey.MODEL_SIZE.getKeyPrefix().equals(furnitureProperty.getName())) {
                        object = catalogPieceOfFurniture.getModelSize();
                    } else if (DefaultFurnitureCatalog.PropertyKey.MODEL_FLAGS.getKeyPrefix().equals(furnitureProperty.getName())) {
                        object = catalogPieceOfFurniture.getModelFlags();
                    } else {
                        try {
                            object = Long.parseLong(catalogPieceOfFurniture.getProperty(furnitureProperty.getName()));
                        }
                        catch (NullPointerException nullPointerException) {
                            object = null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = null;
                        }
                    }
                    object = object != null ? NumberFormat.getIntegerInstance().format(object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getNumberRenderer(final FurnitureProperty furnitureProperty) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    if (DefaultFurnitureCatalog.PropertyKey.GRADE.getKeyPrefix().equals(furnitureProperty.getName())) {
                        object = catalogPieceOfFurniture.getGrade();
                    } else {
                        try {
                            object = Float.valueOf(Float.parseFloat(catalogPieceOfFurniture.getProperty(furnitureProperty.getName())));
                        }
                        catch (NullPointerException nullPointerException) {
                            object = null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = null;
                        }
                    }
                    object = object != null ? NumberFormat.getNumberInstance().format(object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getLengthRenderer(FurnitureProperty furnitureProperty, final UserPreferences userPreferences) {
            final String string = furnitureProperty.getName();
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    if (DefaultFurnitureCatalog.PropertyKey.WIDTH.getKeyPrefix().equals(string)) {
                        object = Float.valueOf(catalogPieceOfFurniture.getWidth());
                    } else if (DefaultFurnitureCatalog.PropertyKey.DEPTH.getKeyPrefix().equals(string)) {
                        object = Float.valueOf(catalogPieceOfFurniture.getDepth());
                    } else if (DefaultFurnitureCatalog.PropertyKey.HEIGHT.getKeyPrefix().equals(string)) {
                        object = Float.valueOf(catalogPieceOfFurniture.getHeight());
                    } else if (DefaultFurnitureCatalog.PropertyKey.ELEVATION.getKeyPrefix().equals(string)) {
                        object = Float.valueOf(catalogPieceOfFurniture.getElevation());
                    } else if (DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION.getKeyPrefix().equals(string)) {
                        object = Float.valueOf(catalogPieceOfFurniture.getDropOnTopElevation());
                    } else {
                        try {
                            object = Float.valueOf(Float.parseFloat(catalogPieceOfFurniture.getProperty(string)));
                        }
                        catch (NullPointerException nullPointerException) {
                            object = null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = null;
                        }
                    }
                    object = object != null ? userPreferences.getLengthUnit().getFormat().format((Float)object) : "";
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getPriceRenderer(final FurnitureProperty furnitureProperty, final UserPreferences userPreferences) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    try {
                        object = DefaultFurnitureCatalog.PropertyKey.PRICE.getKeyPrefix().equals(furnitureProperty.getName()) ? catalogPieceOfFurniture.getPrice() : new BigDecimal(catalogPieceOfFurniture.getProperty(furnitureProperty.getName()));
                    }
                    catch (NullPointerException nullPointerException) {
                        object = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = null;
                    }
                    if (object != null) {
                        NumberFormat numberFormat;
                        String string;
                        String string2 = string = catalogPieceOfFurniture.getCurrency() != null ? catalogPieceOfFurniture.getCurrency() : userPreferences.getCurrency();
                        if (string != null) {
                            numberFormat = NumberFormat.getCurrencyInstance();
                            Currency currency = Currency.getInstance(string);
                            numberFormat.setCurrency(currency);
                            numberFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
                        } else {
                            numberFormat = new DecimalFormat("##0.00");
                        }
                        object = numberFormat.format(object);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getPercentageRenderer(final FurnitureProperty furnitureProperty) {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    BigDecimal bigDecimal;
                    Cloneable cloneable;
                    try {
                        cloneable = (CatalogPieceOfFurniture)object;
                        bigDecimal = DefaultFurnitureCatalog.PropertyKey.VALUE_ADDED_TAX_PERCENTAGE.getKeyPrefix().equals(furnitureProperty.getName()) ? ((CatalogPieceOfFurniture)cloneable).getValueAddedTaxPercentage() : new BigDecimal(((CatalogPieceOfFurniture)cloneable).getProperty(furnitureProperty.getName()));
                    }
                    catch (NullPointerException nullPointerException) {
                        bigDecimal = null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bigDecimal = null;
                    }
                    if (bigDecimal != null) {
                        cloneable = NumberFormat.getPercentInstance();
                        ((NumberFormat)cloneable).setMinimumFractionDigits(bigDecimal.scale() - 2);
                        object = ((Format)cloneable).format(bigDecimal);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getBooleanRenderer(FurnitureProperty furnitureProperty) {
            final String string = furnitureProperty.getName();
            return new TableCellRenderer(){
                private TableCellRenderer booleanRenderer;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.booleanRenderer == null) {
                        this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                    }
                    CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
                    object = DefaultFurnitureCatalog.PropertyKey.MOVABLE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isMovable()) : (DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isDoorOrWindow()) : (DefaultFurnitureCatalog.PropertyKey.RESIZABLE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isResizable()) : (DefaultFurnitureCatalog.PropertyKey.DEFORMABLE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isDeformable()) : (DefaultFurnitureCatalog.PropertyKey.TEXTURABLE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isTexturable()) : (DefaultFurnitureCatalog.PropertyKey.HORIZONTALLY_ROTATABLE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.isHorizontallyRotatable()) : (DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKeyPrefix().equals(string) ? Boolean.valueOf(catalogPieceOfFurniture.getStaircaseCutOutShape() != null) : Boolean.valueOf(Boolean.parseBoolean(catalogPieceOfFurniture.getProperty(string)))))))));
                    JComponent jComponent = (JComponent)this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    jComponent.setEnabled(false);
                    return jComponent;
                }
            };
        }

        private TableCellRenderer getHeaderRenderer() {
            return new TableCellRenderer(){
                private TableCellRenderer headerRenderer;
                private ImageIcon ascendingSortIcon = new ImageIcon(this.getClass().getResource("resources/ascending.png"));
                private ImageIcon descendingSortIcon = new ImageIcon(this.getClass().getResource("resources/descending.png"));

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.headerRenderer == null) {
                        this.headerRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    JLabel jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    FurnitureLibraryTableModel furnitureLibraryTableModel = (FurnitureLibraryTableModel)jTable.getModel();
                    if (FurnitureLibraryTableColumnModel.this.getColumn(n2).getIdentifier().equals(furnitureLibraryTableModel.getSortProperty())) {
                        jLabel.setHorizontalTextPosition(10);
                        if (furnitureLibraryTableModel.isDescendingOrder()) {
                            jLabel.setIcon(this.descendingSortIcon);
                        } else {
                            jLabel.setIcon(this.ascendingSortIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private static class LanguageChangeListener
        implements PropertyChangeListener {
            private WeakReference<FurnitureLibraryTableColumnModel> furnitureTableColumnModel;

            public LanguageChangeListener(FurnitureLibraryTableColumnModel furnitureLibraryTableColumnModel) {
                this.furnitureTableColumnModel = new WeakReference<FurnitureLibraryTableColumnModel>(furnitureLibraryTableColumnModel);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryTableColumnModel furnitureLibraryTableColumnModel = (FurnitureLibraryTableColumnModel)this.furnitureTableColumnModel.get();
                UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
                if (furnitureLibraryTableColumnModel == null) {
                    userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
                } else {
                    for (int i = 0; i < furnitureLibraryTableColumnModel.getColumnCount(); ++i) {
                        TableColumn tableColumn = furnitureLibraryTableColumnModel.getColumn(i);
                        Object object = tableColumn.getIdentifier();
                        if (!(object instanceof FurnitureProperty)) continue;
                        try {
                            tableColumn.setHeaderValue(furnitureLibraryTableColumnModel.getColumnName((FurnitureProperty)object, userPreferences));
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureLibraryTableModel
    extends AbstractTableModel {
        private final FurnitureLibrary furnitureLibrary;
        private final FurnitureLanguageController controller;
        private List<CatalogPieceOfFurniture> sortedFurniture;
        private FurnitureProperty sortProperty;
        private boolean descendingOrder;

        public FurnitureLibraryTableModel(FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
            this.furnitureLibrary = furnitureLibrary;
            this.controller = furnitureLanguageController;
            this.addFurnitureLibraryListener(furnitureLibrary);
            this.sortFurniture();
        }

        private void addFurnitureLibraryListener(final FurnitureLibrary furnitureLibrary) {
            furnitureLibrary.addListener(new CollectionListener<CatalogPieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = collectionEvent.getItem();
                    int n = collectionEvent.getIndex();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            int n2 = this.getPieceOfFurnitureInsertionIndex(catalogPieceOfFurniture, furnitureLibrary, n);
                            if (n2 == -1) break;
                            FurnitureLibraryTableModel.this.sortedFurniture.add(n2, catalogPieceOfFurniture);
                            FurnitureLibraryTableModel.this.fireTableRowsInserted(n2, n2);
                            break;
                        }
                        case DELETE: {
                            int n3 = this.getPieceOfFurnitureDeletionIndex(catalogPieceOfFurniture, furnitureLibrary, n);
                            if (n3 == -1) break;
                            FurnitureLibraryTableModel.this.sortedFurniture.remove(n3);
                            FurnitureLibraryTableModel.this.fireTableRowsDeleted(n3, n3);
                        }
                    }
                }

                private int getPieceOfFurnitureInsertionIndex(CatalogPieceOfFurniture catalogPieceOfFurniture, FurnitureLibrary furnitureLibrary2, int n) {
                    if (FurnitureLibraryTableModel.this.sortProperty == null) {
                        return n;
                    }
                    int n2 = Collections.binarySearch(FurnitureLibraryTableModel.this.sortedFurniture, catalogPieceOfFurniture, FurnitureLibraryTableModel.this.getFurnitureComparator(FurnitureLibraryTableModel.this.sortProperty));
                    if (n2 >= 0) {
                        return n2;
                    }
                    return -(n2 + 1);
                }

                private int getPieceOfFurnitureDeletionIndex(CatalogPieceOfFurniture catalogPieceOfFurniture, FurnitureLibrary furnitureLibrary2, int n) {
                    if (FurnitureLibraryTableModel.this.sortProperty == null) {
                        return n;
                    }
                    return FurnitureLibraryTableModel.this.getPieceOfFurnitureIndex(catalogPieceOfFurniture);
                }
            });
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.sortedFurniture.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.sortedFurniture.get(n);
        }

        public int getPieceOfFurnitureIndex(CatalogPieceOfFurniture catalogPieceOfFurniture) {
            int n = this.sortedFurniture.size();
            for (int i = 0; i < n; ++i) {
                CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.sortedFurniture.get(i);
                if (catalogPieceOfFurniture != catalogPieceOfFurniture2) continue;
                return i;
            }
            return -1;
        }

        public void sortFurniture() {
            int n = this.sortedFurniture != null ? this.sortedFurniture.size() : 0;
            List<CatalogPieceOfFurniture> list = this.furnitureLibrary.getFurniture();
            this.sortedFurniture = new ArrayList<CatalogPieceOfFurniture>(list);
            if (this.sortProperty != null) {
                Comparator<CatalogPieceOfFurniture> comparator = this.getFurnitureComparator(this.sortProperty);
                Collections.sort(this.sortedFurniture, comparator);
            }
            if (n != this.sortedFurniture.size()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        }

        public Comparator<CatalogPieceOfFurniture> getFurnitureComparator(final FurnitureProperty furnitureProperty) {
            final Collator collator = Collator.getInstance();
            Comparator<CatalogPieceOfFurniture> comparator = null;
            final String string = furnitureProperty.getName();
            if (DefaultFurnitureCatalog.PropertyKey.ID.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getId() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getId() == null) {
                            return 1;
                        }
                        return collator.compare(catalogPieceOfFurniture.getId(), catalogPieceOfFurniture2.getId());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.NAME.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getName());
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getName());
                        return collator.compare(string, string2);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.DESCRIPTION.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getDescription());
                        if (string == null) {
                            return -1;
                        }
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getDescription());
                        if (string2 == null) {
                            return 1;
                        }
                        return collator.compare(string, string2);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.CREATOR.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return collator.compare(catalogPieceOfFurniture.getCreator(), catalogPieceOfFurniture2.getCreator());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.LICENSE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getLicense());
                        if (string == null) {
                            return -1;
                        }
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getLicense());
                        if (string2 == null) {
                            return 1;
                        }
                        return collator.compare(string, string2);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.TAGS.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        Object[] objectArray = (String[])FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getTags());
                        if (objectArray == null) {
                            return -1;
                        }
                        Object[] objectArray2 = (String[])FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getTags());
                        if (objectArray2 == null) {
                            return 1;
                        }
                        return collator.compare(Arrays.toString(objectArray), Arrays.toString(objectArray2));
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.INFORMATION.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getInformation());
                        if (string == null) {
                            return -1;
                        }
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getInformation());
                        if (string2 == null) {
                            return 1;
                        }
                        return collator.compare(string, string2);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.CREATION_DATE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getCreationDate() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getCreationDate() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getCreationDate().compareTo(catalogPieceOfFurniture2.getCreationDate());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.GRADE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getGrade() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getGrade() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getGrade().compareTo(catalogPieceOfFurniture2.getGrade());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.CATEGORY.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture.getCategory().getName());
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), furnitureProperty.getDefaultPropertyKeyName(), catalogPieceOfFurniture2.getCategory().getName());
                        return collator.compare(string, string2);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.PRICE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getPrice() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getPrice() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getPrice().compareTo(catalogPieceOfFurniture2.getPrice());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.VALUE_ADDED_TAX_PERCENTAGE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getValueAddedTaxPercentage() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getValueAddedTaxPercentage() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getValueAddedTaxPercentage().compareTo(catalogPieceOfFurniture2.getValueAddedTaxPercentage());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.WIDTH.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.getWidth() < catalogPieceOfFurniture2.getWidth() ? -1 : (catalogPieceOfFurniture.getWidth() == catalogPieceOfFurniture2.getWidth() ? 0 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.DEPTH.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.getDepth() < catalogPieceOfFurniture2.getDepth() ? -1 : (catalogPieceOfFurniture.getDepth() == catalogPieceOfFurniture2.getDepth() ? 0 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.HEIGHT.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.getHeight() < catalogPieceOfFurniture2.getHeight() ? -1 : (catalogPieceOfFurniture.getHeight() == catalogPieceOfFurniture2.getHeight() ? 0 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.MOVABLE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.isMovable() == catalogPieceOfFurniture2.isMovable() ? 0 : (catalogPieceOfFurniture.isMovable() ? -1 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.isDoorOrWindow() == catalogPieceOfFurniture2.isDoorOrWindow() ? 0 : (catalogPieceOfFurniture.isDoorOrWindow() ? -1 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getStaircaseCutOutShape() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getStaircaseCutOutShape() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getStaircaseCutOutShape().compareTo(catalogPieceOfFurniture2.getStaircaseCutOutShape());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.ELEVATION.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.getElevation() < catalogPieceOfFurniture2.getElevation() ? -1 : (catalogPieceOfFurniture.getElevation() == catalogPieceOfFurniture2.getElevation() ? 0 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.getDropOnTopElevation() < catalogPieceOfFurniture2.getDropOnTopElevation() ? -1 : (catalogPieceOfFurniture.getDropOnTopElevation() == catalogPieceOfFurniture2.getDropOnTopElevation() ? 0 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.MODEL_SIZE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        if (catalogPieceOfFurniture.getModelSize() == null) {
                            return -1;
                        }
                        if (catalogPieceOfFurniture2.getModelSize() == null) {
                            return 1;
                        }
                        return catalogPieceOfFurniture.getModelSize().compareTo(catalogPieceOfFurniture2.getModelSize());
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.RESIZABLE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.isResizable() == catalogPieceOfFurniture2.isResizable() ? 0 : (catalogPieceOfFurniture.isResizable() ? -1 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.DEFORMABLE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.isDeformable() == catalogPieceOfFurniture2.isDeformable() ? 0 : (catalogPieceOfFurniture.isDeformable() ? -1 : 1);
                    }
                };
            } else if (DefaultFurnitureCatalog.PropertyKey.TEXTURABLE.getKeyPrefix().equals(string)) {
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        return catalogPieceOfFurniture.isTexturable() == catalogPieceOfFurniture2.isTexturable() ? 0 : (catalogPieceOfFurniture.isTexturable() ? -1 : 1);
                    }
                };
            } else {
                final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                comparator = new Comparator<CatalogPieceOfFurniture>(){

                    @Override
                    public int compare(CatalogPieceOfFurniture catalogPieceOfFurniture, CatalogPieceOfFurniture catalogPieceOfFurniture2) {
                        String string3 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture.getProperty(string));
                        String string2 = (String)FurnitureLibraryTableModel.this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, FurnitureLibraryTableModel.this.controller.getFurnitureLangauge(), string, catalogPieceOfFurniture2.getProperty(string));
                        if (string3 == null) {
                            if (string2 == null) {
                                return collator.compare(catalogPieceOfFurniture.getName(), catalogPieceOfFurniture2.getName());
                            }
                            return -1;
                        }
                        if (string2 == null) {
                            return 1;
                        }
                        ObjectProperty.Type type = furnitureProperty.getType();
                        if (type == null) {
                            type = ObjectProperty.Type.ANY;
                        }
                        switch (type) {
                            case BOOLEAN: {
                                return Boolean.parseBoolean(string3) == Boolean.parseBoolean(string2) ? 0 : (Boolean.parseBoolean(string3) ? 1 : -1);
                            }
                            case DATE: {
                                try {
                                    Date date = simpleDateFormat.parse(string3);
                                    Date date2 = simpleDateFormat.parse(string2);
                                    int n = date.compareTo(date2);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return collator.compare(catalogPieceOfFurniture.getName(), catalogPieceOfFurniture2.getName());
                                }
                                catch (ParseException parseException) {
                                    int n = collator.compare(string3, string2);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return collator.compare(catalogPieceOfFurniture.getName(), catalogPieceOfFurniture2.getName());
                                }
                            }
                            case ANY: 
                            case INTEGER: 
                            case PERCENTAGE: 
                            case LENGTH: 
                            case NUMBER: 
                            case PRICE: {
                                try {
                                    double d = Double.parseDouble(string3);
                                    double d2 = Double.parseDouble(string2);
                                    int n = Double.compare(d, d2);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return collator.compare(catalogPieceOfFurniture.getName(), catalogPieceOfFurniture2.getName());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    int n = collator.compare(string3, string2);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return collator.compare(catalogPieceOfFurniture.getName(), catalogPieceOfFurniture2.getName());
                                }
                            }
                        }
                        return collator.compare(string3, string2);
                    }
                };
            }
            if (this.descendingOrder) {
                comparator = Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        public FurnitureProperty getSortProperty() {
            return this.sortProperty;
        }

        public void setSortProperty(FurnitureProperty furnitureProperty) {
            this.sortProperty = furnitureProperty;
            this.sortFurniture();
        }

        public boolean isDescendingOrder() {
            return this.descendingOrder;
        }

        public void setDescendingOrder(boolean bl) {
            this.descendingOrder = bl;
            this.sortFurniture();
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureLibraryTable> furnitureLibraryTable;
        private WeakReference<FurnitureLibrary> furnitureLibrary;
        private WeakReference<FurnitureLanguageController> furnitureLanguageController;

        public UserPreferencesChangeListener(FurnitureLibraryTable furnitureLibraryTable, FurnitureLibrary furnitureLibrary, FurnitureLanguageController furnitureLanguageController) {
            this.furnitureLibraryTable = new WeakReference<FurnitureLibraryTable>(furnitureLibraryTable);
            this.furnitureLibrary = new WeakReference<FurnitureLibrary>(furnitureLibrary);
            this.furnitureLanguageController = new WeakReference<FurnitureLanguageController>(furnitureLanguageController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureLibraryTable furnitureLibraryTable = (FurnitureLibraryTable)this.furnitureLibraryTable.get();
            FurnitureLibrary furnitureLibrary = (FurnitureLibrary)this.furnitureLibrary.get();
            FurnitureLanguageController furnitureLanguageController = (FurnitureLanguageController)this.furnitureLanguageController.get();
            if (furnitureLibraryTable == null) {
                ((FurnitureLibraryUserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), (PropertyChangeListener)this);
            } else if (UserPreferences.Property.UNIT.name().equals(propertyChangeEvent.getPropertyName())) {
                furnitureLibraryTable.repaint();
                furnitureLibraryTable.getTableHeader().repaint();
            } else {
                furnitureLibraryTable.setColumnModel(new FurnitureLibraryTableColumnModel(furnitureLibrary, (FurnitureLibraryUserPreferences)propertyChangeEvent.getSource(), furnitureLanguageController));
                furnitureLibraryTable.updateTableColumnsWidth();
            }
        }
    }
}

