/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.vecmath.Matrix3f;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;

public class FurniturePanel
extends JPanel
implements DialogView {
    private final FurnitureController controller;
    private JLabel idLabel;
    private JTextField idTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JLabel informationLabel;
    private JTextField informationTextField;
    private JLabel tagsLabel;
    private JTextField tagsTextField;
    private JLabel creatorLabel;
    private JTextField creatorTextField;
    private JLabel licenseLabel;
    private JTextField licenseTextField;
    private JLabel categoryLabel;
    private JComboBox categoryComboBox;
    private JLabel creationDateLabel;
    private JSpinner creationDateSpinner;
    private JLabel gradeLabel;
    private JSpinner gradeSpinner;
    private IconPreviewComponent iconComponent;
    private JButton changeModelButton;
    private JButton turnLeftButton;
    private JButton turnRightButton;
    private JButton turnUpButton;
    private JButton turnDownButton;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private JButton enlargeTenTimesButton;
    private JButton reduceTenTimesButton;
    private JButton enlargeInchTimesButton;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private NullableCheckBox movableCheckBox;
    private NullableCheckBox doorOrWindowCheckBox;
    private JCheckBox doorOrWindowCustomizedCutOutShapeCheckBox;
    private JTextField doorOrWindowCustomizedCutOutShapeTextField;
    private NullableCheckBox staircaseCheckBox;
    private JLabel staircaseCutOutShapeLabel;
    private JTextField staircaseCutOutShapeTextField;
    private NullableCheckBox backFaceShownCheckBox;
    private NullableCheckBox edgeColorMaterialHiddenCheckBox;
    private NullableCheckBox resizableCheckBox;
    private NullableCheckBox deformableCheckBox;
    private NullableCheckBox texturableCheckBox;
    private JLabel priceLabel;
    private JSpinner priceSpinner;
    private JLabel valueAddedTaxPercentageLabel;
    private JSpinner valueAddedTaxPercentageSpinner;
    private JLabel additionalPropertiesLabel;
    private JTable additionalPropertiesTable;
    private String dialogTitle;

    public FurniturePanel(UserPreferences userPreferences, FurnitureController furnitureController) {
        super(new GridBagLayout());
        this.controller = furnitureController;
        this.createComponents(userPreferences, furnitureController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(final UserPreferences userPreferences, final FurnitureController furnitureController) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = userPreferences.getLengthUnit().getName();
        if (this.controller.isPropertyEditable(FurnitureController.Property.ID)) {
            this.idLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "idLabel.text", new Object[0]));
            this.idTextField = new JTextField(furnitureController.getId(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.idTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.idTextField.setText(furnitureController.getId());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.ID, (PropertyChangeListener)object4);
            this.idTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$idChangeListener;
                {
                    this.val$idChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.ID, this.val$idChangeListener);
                    String string = FurniturePanel.this.idTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setId(null);
                    } else {
                        furnitureController.setId(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.ID, this.val$idChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.NAME)) {
            this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "nameLabel.text", new Object[0]));
            this.nameTextField = new JTextField(furnitureController.getName(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.nameTextField.setText(furnitureController.getName());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.NAME, (PropertyChangeListener)object4);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$nameChangeListener;
                {
                    this.val$nameChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.NAME, this.val$nameChangeListener);
                    String string = FurniturePanel.this.nameTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setName(null);
                    } else {
                        furnitureController.setName(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.NAME, this.val$nameChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DESCRIPTION)) {
            this.descriptionLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "descriptionLabel.text", new Object[0]));
            this.descriptionTextField = new JTextField(furnitureController.getDescription(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.descriptionTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.descriptionTextField.setText(furnitureController.getDescription());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.DESCRIPTION, (PropertyChangeListener)object4);
            this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$descriptionChangeListener;
                {
                    this.val$descriptionChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                    String string = FurniturePanel.this.descriptionTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setDescription(null);
                    } else {
                        furnitureController.setDescription(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.INFORMATION)) {
            this.informationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "informationLabel.text", new Object[0]));
            this.informationTextField = new JTextField(furnitureController.getInformation(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.informationTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.informationTextField.setText(furnitureController.getInformation());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.INFORMATION, (PropertyChangeListener)object4);
            this.informationTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$informationChangeListener;
                {
                    this.val$informationChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.INFORMATION, this.val$informationChangeListener);
                    String string = FurniturePanel.this.informationTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setInformation(null);
                    } else {
                        furnitureController.setInformation(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.INFORMATION, this.val$informationChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.TAGS)) {
            this.tagsLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "tagsLabel.text", new Object[0]));
            object4 = null;
            if (furnitureController.getTags() != null) {
                object4 = Arrays.toString(furnitureController.getTags());
                object4 = ((String)object4).substring(1, ((String)object4).length() - 1);
            }
            this.tagsTextField = new JTextField((String)object4, 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.tagsTextField);
            }
            object3 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = null;
                    if (furnitureController.getTags() != null) {
                        string = Arrays.toString(furnitureController.getTags());
                        string = string.substring(1, string.length() - 1);
                    }
                    FurniturePanel.this.tagsTextField.setText(string);
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.TAGS, (PropertyChangeListener)object3);
            this.tagsTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object3){
                final /* synthetic */ PropertyChangeListener val$tagsChangeListener;
                {
                    this.val$tagsChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.TAGS, this.val$tagsChangeListener);
                    String string = FurniturePanel.this.tagsTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setTags(null);
                    } else {
                        furnitureController.setTags(string.split("\\s*,\\s*"));
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.TAGS, this.val$tagsChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CREATOR)) {
            this.creatorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "creatorLabel.text", new Object[0]));
            this.creatorTextField = new JTextField(furnitureController.getCreator(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.creatorTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.creatorTextField.setText(furnitureController.getCreator());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.CREATOR, (PropertyChangeListener)object4);
            this.creatorTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$creatorChangeListener;
                {
                    this.val$creatorChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.CREATOR, this.val$creatorChangeListener);
                    String string = FurniturePanel.this.creatorTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setCreator(null);
                    } else {
                        furnitureController.setCreator(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.CREATOR, this.val$creatorChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.LICENSE)) {
            this.licenseLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "licenseLabel.text", new Object[0]));
            this.licenseTextField = new JTextField(furnitureController.getLicense(), 10);
            if (!OperatingSystem.isMacOSX()) {
                SwingTools.addAutoSelectionOnFocusGain(this.licenseTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.licenseTextField.setText(furnitureController.getLicense());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.LICENSE, (PropertyChangeListener)object4);
            this.licenseTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$licenseChangeListener;
                {
                    this.val$licenseChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.LICENSE, this.val$licenseChangeListener);
                    String string = FurniturePanel.this.licenseTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setLicense(null);
                    } else {
                        furnitureController.setLicense(string);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.LICENSE, this.val$licenseChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CATEGORY)) {
            boolean bl;
            this.categoryLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "categoryLabel.text", new Object[0]));
            object4 = furnitureController.getAvailableCategories();
            object3 = new ArrayList(object4);
            boolean bl2 = bl = furnitureController.getCategory() == null;
            if (bl) {
                object3.add(0, null);
            }
            this.categoryComboBox = new JComboBox<Object>(object3.toArray());
            this.categoryComboBox.setEditable(true);
            object2 = this.categoryComboBox.getEditor();
            this.categoryComboBox.setEditor(new ComboBoxEditor((ComboBoxEditor)object2, bl, furnitureController, (List)object4){
                final /* synthetic */ ComboBoxEditor val$defaultEditor;
                final /* synthetic */ boolean val$nullableComboBox;
                final /* synthetic */ FurnitureController val$controller;
                final /* synthetic */ List val$categories;
                {
                    this.val$defaultEditor = comboBoxEditor;
                    this.val$nullableComboBox = bl;
                    this.val$controller = furnitureController;
                    this.val$categories = list;
                }

                public Object getItem() {
                    String string = (String)this.val$defaultEditor.getItem();
                    if ((string = string.trim()).length() == 0) {
                        if (this.val$nullableComboBox) {
                            this.val$controller.setCategory(null);
                            return null;
                        }
                        Object object = FurniturePanel.this.categoryComboBox.getSelectedItem();
                        this.setItem(object);
                        return object;
                    }
                    FurnitureCategory furnitureCategory = new FurnitureCategory(string);
                    int n = Collections.binarySearch(this.val$categories, furnitureCategory);
                    if (n >= 0) {
                        return this.val$categories.get(n);
                    }
                    return furnitureCategory;
                }

                public void setItem(Object object) {
                    if (object != null) {
                        this.val$defaultEditor.setItem(((FurnitureCategory)object).getName());
                    }
                }

                public void addActionListener(ActionListener actionListener) {
                    this.val$defaultEditor.addActionListener(actionListener);
                }

                public Component getEditorComponent() {
                    return this.val$defaultEditor.getEditorComponent();
                }

                public void removeActionListener(ActionListener actionListener) {
                    this.val$defaultEditor.removeActionListener(actionListener);
                }

                public void selectAll() {
                    this.val$defaultEditor.selectAll();
                }
            });
            this.categoryComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    object = object == null ? " " : ((FurnitureCategory)object).getName();
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.categoryComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    furnitureController.setCategory((FurnitureCategory)itemEvent.getItem());
                }
            });
            furnitureController.addPropertyChangeListener(FurnitureController.Property.CATEGORY, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurnitureCategory furnitureCategory = furnitureController.getCategory();
                    if (furnitureCategory != null) {
                        FurniturePanel.this.categoryComboBox.setSelectedItem(furnitureCategory);
                    }
                }
            });
            if (this.categoryComboBox.getItemCount() > 0) {
                this.categoryComboBox.setSelectedItem(furnitureController.getCategory());
            }
            this.categoryComboBox.setMaximumRowCount(15);
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CREATION_DATE)) {
            this.creationDateLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "creationDateLabel.text", new Object[0]));
            object4 = new NullableSpinner.NullableSpinnerDateModel();
            if (furnitureController.getCreationDate() != null) {
                object3 = new Date(Camera.convertTimeToTimeZone(furnitureController.getCreationDate(), TimeZone.getDefault().getID()));
                ((NullableSpinner.NullableSpinnerDateModel)object4).setValue(object3);
            } else {
                ((NullableSpinner.NullableSpinnerDateModel)object4).setNullable(true);
                ((NullableSpinner.NullableSpinnerDateModel)object4).setValue(null);
            }
            this.creationDateSpinner = new AutoCommitSpinner((SpinnerModel)object4);
            object3 = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
            if (((String)object3).indexOf("yyyy") == -1) {
                object3 = ((String)object3).replace("yy", "yyyy");
            }
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.creationDateSpinner, (String)object3);
            this.creationDateSpinner.setEditor(dateEditor);
            SwingTools.addAutoSelectionOnFocusGain(dateEditor.getTextField());
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerDateModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerDateModel val$creationDateSpinnerModel;
                {
                    this.val$creationDateSpinnerModel = nullableSpinnerDateModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (furnitureController.getCreationDate() != null) {
                        Date date = new Date(Camera.convertTimeToTimeZone(furnitureController.getCreationDate(), TimeZone.getDefault().getID()));
                        this.val$creationDateSpinnerModel.setNullable(false);
                        this.val$creationDateSpinnerModel.setValue(date);
                    } else {
                        this.val$creationDateSpinnerModel.setNullable(true);
                        this.val$creationDateSpinnerModel.setValue(null);
                    }
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.CREATION_DATE, (PropertyChangeListener)object2);
            object = new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerDateModel)object4){
                final /* synthetic */ PropertyChangeListener val$dateChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerDateModel val$creationDateSpinnerModel;
                {
                    this.val$dateChangeListener = propertyChangeListener;
                    this.val$creationDateSpinnerModel = nullableSpinnerDateModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.CREATION_DATE, this.val$dateChangeListener);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    if (this.val$creationDateSpinnerModel.getValue() != null) {
                        gregorianCalendar.setTime((Date)this.val$creationDateSpinnerModel.getValue());
                        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        gregorianCalendar2.set(1, gregorianCalendar.get(1));
                        gregorianCalendar2.set(2, gregorianCalendar.get(2));
                        gregorianCalendar2.set(5, gregorianCalendar.get(5));
                        furnitureController.setCreationDate(gregorianCalendar2.getTimeInMillis());
                    } else {
                        furnitureController.setCreationDate(null);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.CREATION_DATE, this.val$dateChangeListener);
                }
            };
            ((AbstractSpinnerModel)object4).addChangeListener((ChangeListener)object);
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.GRADE)) {
            this.gradeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "gradeLabel.text", string));
            object4 = new NullableSpinner.NullableSpinnerNumberModel(0.0f, 0.0f, 100.0f, 0.1f);
            this.gradeSpinner = new AutoCommitSpinner((SpinnerModel)object4);
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$gradeSpinnerModel;
                {
                    this.val$gradeSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = furnitureController.getGrade();
                    this.val$gradeSpinnerModel.setNullable(f == null);
                    this.val$gradeSpinnerModel.setValue(f);
                    if (f != null) {
                        this.val$gradeSpinnerModel.setMinimum(Float.valueOf(Math.min(f.floatValue(), 0.0f)));
                    }
                }
            };
            object3.propertyChange(null);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.GRADE, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ PropertyChangeListener val$gradeChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$gradeSpinnerModel;
                {
                    this.val$gradeChangeListener = propertyChangeListener;
                    this.val$gradeSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.GRADE, this.val$gradeChangeListener);
                    furnitureController.setGrade(Float.valueOf(((Number)this.val$gradeSpinnerModel.getValue()).floatValue()));
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.GRADE, this.val$gradeChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.PRICE)) {
            this.priceLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "priceLabel.text", new Object[0]));
            object4 = new NullableSpinner.NullableSpinnerNumberModel(1.0f, 0.00999f, 1000000.0f, 1.0f);
            this.priceSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(furnitureController.getPrice() == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(furnitureController.getPrice());
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$priceSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$priceSpinnerModel.setValue((Float)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.PRICE, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ PropertyChangeListener val$priceChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceChangeListener = propertyChangeListener;
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.PRICE, this.val$priceChangeListener);
                    Object object = this.val$priceSpinnerModel.getValue();
                    furnitureController.setPrice(object != null ? new BigDecimal(((Float)object).floatValue()).setScale(2, 4) : (BigDecimal)object);
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.PRICE, this.val$priceChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE)) {
            this.valueAddedTaxPercentageLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "valueAddedTaxPercentageLabel.text", new Object[0]));
            object4 = new NullableSpinner.NullableSpinnerNumberModel(0.0f, 0.0f, 100.0f, 0.1f);
            this.valueAddedTaxPercentageSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(furnitureController.getValueAddedTaxPercentage() == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(furnitureController.getValueAddedTaxPercentage() == null ? null : Float.valueOf(furnitureController.getValueAddedTaxPercentage().floatValue() * 100.0f));
            object3 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$valueAddedTaxPercentageSpinnerModel;
                {
                    this.val$valueAddedTaxPercentageSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$valueAddedTaxPercentageSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$valueAddedTaxPercentageSpinnerModel.setValue(propertyChangeEvent.getNewValue() == null ? null : Float.valueOf(((Float)propertyChangeEvent.getNewValue()).floatValue() * 100.0f));
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, (PropertyChangeListener)object3);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object3, (NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ PropertyChangeListener val$valueAddedTaxPercentageChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$valueAddedTaxPercentageSpinnerModel;
                {
                    this.val$valueAddedTaxPercentageChangeListener = propertyChangeListener;
                    this.val$valueAddedTaxPercentageSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, this.val$valueAddedTaxPercentageChangeListener);
                    Object object = this.val$valueAddedTaxPercentageSpinnerModel.getValue();
                    furnitureController.setValueAddedTaxPercentage(object != null ? new BigDecimal(((Float)object).floatValue() / 100.0f).setScale(3, 4) : (BigDecimal)object);
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE, this.val$valueAddedTaxPercentageChangeListener);
                }
            });
        }
        final float f = userPreferences.getLengthUnit().getMinimumLength();
        float f2 = userPreferences.getLengthUnit().getMaximumLength();
        if (this.controller.isPropertyEditable(FurnitureController.Property.WIDTH)) {
            this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "widthLabel.text", string));
            final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, f2);
            this.widthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f2 = furnitureController.getWidth();
                    nullableSpinnerLengthModel.setNullable(f2 == null);
                    nullableSpinnerLengthModel.setLength(f2);
                    if (f2 != null) {
                        nullableSpinnerLengthModel.setMinimumLength(Math.min(f2.floatValue(), f));
                    }
                }
            };
            object2.propertyChange(null);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.WIDTH, (PropertyChangeListener)object2);
            nullableSpinnerLengthModel.addChangeListener(new ChangeListener((PropertyChangeListener)object2, nullableSpinnerLengthModel){
                final /* synthetic */ PropertyChangeListener val$widthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$widthSpinnerModel;
                {
                    this.val$widthChangeListener = propertyChangeListener;
                    this.val$widthSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.WIDTH, this.val$widthChangeListener);
                    furnitureController.setWidth(this.val$widthSpinnerModel.getLength());
                    if (!furnitureController.isProportional()) {
                        FurniturePanel.this.resetIcon(false);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.WIDTH, this.val$widthChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DEPTH)) {
            this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "depthLabel.text", string));
            final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, f2);
            this.depthSpinner = new NullableSpinner(nullableSpinnerLengthModel);
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f2 = furnitureController.getDepth();
                    nullableSpinnerLengthModel.setNullable(f2 == null);
                    nullableSpinnerLengthModel.setLength(f2);
                    if (f2 != null) {
                        nullableSpinnerLengthModel.setMinimumLength(Math.min(f2.floatValue(), f));
                    }
                }
            };
            object2.propertyChange(null);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.DEPTH, (PropertyChangeListener)object2);
            nullableSpinnerLengthModel.addChangeListener(new ChangeListener((PropertyChangeListener)object2, nullableSpinnerLengthModel){
                final /* synthetic */ PropertyChangeListener val$depthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$depthSpinnerModel;
                {
                    this.val$depthChangeListener = propertyChangeListener;
                    this.val$depthSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.DEPTH, this.val$depthChangeListener);
                    furnitureController.setDepth(this.val$depthSpinnerModel.getLength());
                    if (!furnitureController.isProportional()) {
                        FurniturePanel.this.resetIcon(false);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.DEPTH, this.val$depthChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.HEIGHT)) {
            this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "heightLabel.text", string));
            final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, f2);
            this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel);
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f2 = furnitureController.getHeight();
                    nullableSpinnerLengthModel.setNullable(f2 == null);
                    nullableSpinnerLengthModel.setLength(f2);
                    if (f2 != null) {
                        nullableSpinnerLengthModel.setMinimumLength(Math.min(f2.floatValue(), f));
                    }
                }
            };
            object2.propertyChange(null);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.HEIGHT, (PropertyChangeListener)object2);
            nullableSpinnerLengthModel.addChangeListener(new ChangeListener((PropertyChangeListener)object2, nullableSpinnerLengthModel){
                final /* synthetic */ PropertyChangeListener val$heightChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                {
                    this.val$heightChangeListener = propertyChangeListener;
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                    furnitureController.setHeight(this.val$heightSpinnerModel.getLength());
                    if (!furnitureController.isProportional()) {
                        FurniturePanel.this.resetIcon(false);
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.PROPORTIONAL)) {
            this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "keepProportionsCheckBox.text", new Object[0]), furnitureController.isProportional());
            this.keepProportionsCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    furnitureController.setProportional(FurniturePanel.this.keepProportionsCheckBox.isSelected());
                }
            });
            furnitureController.addPropertyChangeListener(FurnitureController.Property.PROPORTIONAL, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.keepProportionsCheckBox.setSelected(furnitureController.isProportional());
                }
            });
            this.enlargeTenTimesButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "ENLARGE_TEN_TIMES", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    furnitureController.multiplySize(10.0f);
                }
            });
            this.reduceTenTimesButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "REDUCE_TEN_TIMES", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    furnitureController.multiplySize(0.1f);
                }
            });
            this.enlargeInchTimesButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "ENLARGE_INCH_TIMES", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    furnitureController.multiplySize(2.54f);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.ELEVATION)) {
            this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "elevationLabel.text", string));
            final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
            this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel);
            nullableSpinnerLengthModel.setNullable(furnitureController.getElevation() == null);
            nullableSpinnerLengthModel.setLength(furnitureController.getElevation());
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.ELEVATION, (PropertyChangeListener)object2);
            nullableSpinnerLengthModel.addChangeListener(new ChangeListener((PropertyChangeListener)object2, nullableSpinnerLengthModel){
                final /* synthetic */ PropertyChangeListener val$elevationChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationChangeListener = propertyChangeListener;
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                    furnitureController.setElevation(this.val$elevationSpinnerModel.getLength());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.MOVABLE)) {
            this.movableCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "movableCheckBox.text", new Object[0]));
            this.movableCheckBox.setNullable(furnitureController.getMovable() == null);
            this.movableCheckBox.setValue(furnitureController.getMovable());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.movableCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.movableCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.MOVABLE, propertyChangeListener);
            this.movableCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.MOVABLE, propertyChangeListener);
                    furnitureController.setMovable(FurniturePanel.this.movableCheckBox.getValue());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.MOVABLE, propertyChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DOOR_OR_WINDOW)) {
            this.doorOrWindowCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "doorOrWindowCheckBox.text", new Object[0]));
            this.doorOrWindowCheckBox.setNullable(furnitureController.getDoorOrWindow() == null);
            this.doorOrWindowCheckBox.setValue(furnitureController.getDoorOrWindow());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.doorOrWindowCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.doorOrWindowCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                    if (FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox != null) {
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox.setEnabled(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setEnabled(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && furnitureController.getDoorOrWindowCutOutShape() != null);
                    }
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW, propertyChangeListener);
            this.doorOrWindowCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW, propertyChangeListener);
                    furnitureController.setDoorOrWindow(FurniturePanel.this.doorOrWindowCheckBox.getValue());
                    if (FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox != null) {
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox.setEnabled(Boolean.TRUE.equals(FurniturePanel.this.doorOrWindowCheckBox.getValue()));
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setEnabled(Boolean.TRUE.equals(FurniturePanel.this.doorOrWindowCheckBox.getValue()) && furnitureController.getDoorOrWindowCutOutShape() != null);
                    }
                    if (FurniturePanel.this.additionalPropertiesTable != null) {
                        FurniturePanel.this.additionalPropertiesTable.removeEditor();
                        FurniturePanel.this.additionalPropertiesTable.repaint();
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW, propertyChangeListener);
                }
            });
            if (this.controller.isPropertyEditable(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE)) {
                this.doorOrWindowCustomizedCutOutShapeCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "doorOrWindowCustomizedCutOutShapeCheckBox.text", new Object[0]));
                this.doorOrWindowCustomizedCutOutShapeCheckBox.setEnabled(Boolean.TRUE.equals(furnitureController.getDoorOrWindow()));
                this.doorOrWindowCustomizedCutOutShapeCheckBox.setSelected(furnitureController.getDoorOrWindowCutOutShape() != null);
                object2 = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox.setSelected(furnitureController.getDoorOrWindowCutOutShape() != null);
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setText(furnitureController.getDoorOrWindowCutOutShape());
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setEnabled(furnitureController.getDoorOrWindowCutOutShape() != null);
                    }
                };
                furnitureController.addPropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE, (PropertyChangeListener)object2);
                this.doorOrWindowCustomizedCutOutShapeCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                    final /* synthetic */ PropertyChangeListener val$customizedCutOutShapeChangeListener;
                    {
                        this.val$customizedCutOutShapeChangeListener = propertyChangeListener;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        furnitureController.removePropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE, this.val$customizedCutOutShapeChangeListener);
                        FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setEnabled(FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox.isSelected());
                        if (FurniturePanel.this.doorOrWindowCustomizedCutOutShapeCheckBox.isSelected()) {
                            String string = FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.getText();
                            furnitureController.setDoorOrWindowCutOutShape(string != null && string.trim().length() > 0 ? string : null);
                        } else {
                            furnitureController.setDoorOrWindowCutOutShape(null);
                        }
                        furnitureController.addPropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE, this.val$customizedCutOutShapeChangeListener);
                    }
                });
                this.doorOrWindowCustomizedCutOutShapeTextField = new JTextField(furnitureController.getDoorOrWindowCutOutShape(), 15);
                this.doorOrWindowCustomizedCutOutShapeTextField.setEnabled(furnitureController.getDoorOrWindowCutOutShape() != null);
                object = this.doorOrWindowCustomizedCutOutShapeTextField.getForeground();
                this.doorOrWindowCustomizedCutOutShapeTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object2, (Color)object){
                    final /* synthetic */ PropertyChangeListener val$customizedCutOutShapeChangeListener;
                    final /* synthetic */ Color val$defaultTextFieldColor;
                    {
                        this.val$customizedCutOutShapeChangeListener = propertyChangeListener;
                        this.val$defaultTextFieldColor = color;
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        furnitureController.removePropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE, this.val$customizedCutOutShapeChangeListener);
                        String string = FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.getText();
                        if (string == null || string.trim().length() == 0) {
                            furnitureController.setDoorOrWindowCutOutShape(null);
                        } else {
                            furnitureController.setDoorOrWindowCutOutShape(string);
                            try {
                                PathParser pathParser = new PathParser();
                                pathParser.setPathHandler((PathHandler)new AWTPathProducer());
                                pathParser.parse(string);
                                FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setForeground(this.val$defaultTextFieldColor);
                            }
                            catch (ParseException parseException) {
                                FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setForeground(Color.RED);
                            }
                            catch (NullPointerException nullPointerException) {
                                FurniturePanel.this.doorOrWindowCustomizedCutOutShapeTextField.setForeground(Color.RED);
                            }
                        }
                        furnitureController.addPropertyChangeListener(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE, this.val$customizedCutOutShapeChangeListener);
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changedUpdate(documentEvent);
                    }
                });
            }
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.STAIRCASE_CUT_OUT_SHAPE)) {
            this.staircaseCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "staircaseCheckBox.text", new Object[0]));
            this.staircaseCheckBox.setNullable(furnitureController.getStaircase() == null);
            this.staircaseCheckBox.setValue(furnitureController.getStaircase());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.staircaseCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.staircaseCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.STAIRCASE, propertyChangeListener);
            this.staircaseCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.STAIRCASE, propertyChangeListener);
                    Boolean bl = FurniturePanel.this.staircaseCheckBox.getValue();
                    FurniturePanel.this.staircaseCutOutShapeLabel.setEnabled(!Boolean.FALSE.equals(bl));
                    FurniturePanel.this.staircaseCutOutShapeTextField.setEnabled(!Boolean.FALSE.equals(bl));
                    furnitureController.setStaircase(bl);
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.STAIRCASE, propertyChangeListener);
                }
            });
            this.staircaseCutOutShapeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "staircaseCutOutShapeLabel.text", new Object[0]));
            this.staircaseCutOutShapeLabel.setEnabled(!Boolean.FALSE.equals(furnitureController.getStaircase()));
            this.staircaseCutOutShapeTextField = new JTextField(furnitureController.getStaircaseCutOutShape(), 15);
            this.staircaseCutOutShapeTextField.setEnabled(!Boolean.FALSE.equals(furnitureController.getStaircase()));
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.staircaseCutOutShapeTextField.setText(furnitureController.getStaircaseCutOutShape());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.STAIRCASE_CUT_OUT_SHAPE, (PropertyChangeListener)object2);
            object = this.staircaseCutOutShapeTextField.getForeground();
            this.staircaseCutOutShapeTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object2, (Color)object){
                final /* synthetic */ PropertyChangeListener val$staircaseCutOutShapeChangeListener;
                final /* synthetic */ Color val$defaultTextFieldColor;
                {
                    this.val$staircaseCutOutShapeChangeListener = propertyChangeListener;
                    this.val$defaultTextFieldColor = color;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.STAIRCASE_CUT_OUT_SHAPE, this.val$staircaseCutOutShapeChangeListener);
                    String string = FurniturePanel.this.staircaseCutOutShapeTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        furnitureController.setStaircaseCutOutShape(null);
                    } else {
                        furnitureController.setStaircaseCutOutShape(string);
                        try {
                            PathParser pathParser = new PathParser();
                            pathParser.setPathHandler((PathHandler)new AWTPathProducer());
                            pathParser.parse(string);
                            FurniturePanel.this.staircaseCutOutShapeTextField.setForeground(this.val$defaultTextFieldColor);
                        }
                        catch (ParseException parseException) {
                            FurniturePanel.this.staircaseCutOutShapeTextField.setForeground(Color.RED);
                        }
                        catch (NullPointerException nullPointerException) {
                            FurniturePanel.this.staircaseCutOutShapeTextField.setForeground(Color.RED);
                        }
                    }
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.STAIRCASE_CUT_OUT_SHAPE, this.val$staircaseCutOutShapeChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.BACK_FACE_SHOWN)) {
            this.backFaceShownCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "backFaceShownCheckBox.text", new Object[0]));
            this.backFaceShownCheckBox.setNullable(furnitureController.getBackFaceShown() == null);
            this.backFaceShownCheckBox.setValue(furnitureController.getBackFaceShown());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.backFaceShownCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.backFaceShownCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.BACK_FACE_SHOWN, propertyChangeListener);
            this.backFaceShownCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.BACK_FACE_SHOWN, propertyChangeListener);
                    furnitureController.setBackFaceShown(FurniturePanel.this.backFaceShownCheckBox.getValue());
                    FurniturePanel.this.resetIcon(false);
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.BACK_FACE_SHOWN, propertyChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN)) {
            this.edgeColorMaterialHiddenCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "edgeColorMaterialHiddenCheckBox.text", new Object[0]));
            this.edgeColorMaterialHiddenCheckBox.setNullable(furnitureController.getEdgeColorMaterialHidden() == null);
            this.edgeColorMaterialHiddenCheckBox.setValue(furnitureController.getEdgeColorMaterialHidden());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.edgeColorMaterialHiddenCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.edgeColorMaterialHiddenCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN, propertyChangeListener);
            this.edgeColorMaterialHiddenCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN, propertyChangeListener);
                    furnitureController.setEdgeColorMaterialHidden(FurniturePanel.this.edgeColorMaterialHiddenCheckBox.getValue());
                    FurniturePanel.this.resetIcon(false);
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN, propertyChangeListener);
                }
            });
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModelManager.getInstance().loadModel(furnitureController.getModel(), new ModelManager.ModelObserver(){

                        public void modelUpdated(BranchGroup branchGroup) {
                            FurniturePanel.this.edgeColorMaterialHiddenCheckBox.setVisible(false);
                            for (HomeMaterial homeMaterial : ModelManager.getInstance().getMaterials((Node)branchGroup)) {
                                if (!homeMaterial.getName().startsWith("edge_color")) continue;
                                FurniturePanel.this.edgeColorMaterialHiddenCheckBox.setVisible(true);
                            }
                        }

                        public void modelError(Exception exception) {
                        }
                    });
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.MODEL, (PropertyChangeListener)object2);
            object2.propertyChange(null);
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.RESIZABLE)) {
            this.resizableCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "resizableCheckBox.text", new Object[0]));
            this.resizableCheckBox.setNullable(furnitureController.getResizable() == null);
            this.resizableCheckBox.setValue(furnitureController.getResizable());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.resizableCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.resizableCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.RESIZABLE, propertyChangeListener);
            this.resizableCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.RESIZABLE, propertyChangeListener);
                    furnitureController.setResizable(FurniturePanel.this.resizableCheckBox.getValue());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.RESIZABLE, propertyChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DEFORMABLE)) {
            this.deformableCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "deformableCheckBox.text", new Object[0]));
            this.deformableCheckBox.setNullable(furnitureController.getDeformable() == null);
            this.deformableCheckBox.setValue(furnitureController.getDeformable());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.deformableCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.deformableCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.DEFORMABLE, propertyChangeListener);
            this.deformableCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.DEFORMABLE, propertyChangeListener);
                    furnitureController.setDeformable(FurniturePanel.this.deformableCheckBox.getValue());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.DEFORMABLE, propertyChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.TEXTURABLE)) {
            this.texturableCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "texturableCheckBox.text", new Object[0]));
            this.texturableCheckBox.setNullable(furnitureController.getTexturable() == null);
            this.texturableCheckBox.setValue(furnitureController.getTexturable());
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurniturePanel.this.texturableCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    FurniturePanel.this.texturableCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.TEXTURABLE, propertyChangeListener);
            this.texturableCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.TEXTURABLE, propertyChangeListener);
                    furnitureController.setTexturable(FurniturePanel.this.texturableCheckBox.getValue());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.TEXTURABLE, propertyChangeListener);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL) || this.controller.isPropertyEditable(FurnitureController.Property.MODEL_ROTATION) || this.controller.isPropertyEditable(FurnitureController.Property.ICON)) {
            this.iconComponent = new IconPreviewComponent(furnitureController, userPreferences);
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL_ROTATION)) {
            this.turnLeftButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "TURN_LEFT", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    Transform3D transform3D = FurniturePanel.this.getModelRotationTransform();
                    Transform3D transform3D2 = new Transform3D();
                    transform3D2.rotY(-1.5707963267948966);
                    transform3D2.mul(transform3D);
                    FurniturePanel.this.updateModelRotation(transform3D2);
                }
            });
            this.turnRightButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "TURN_RIGHT", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    Transform3D transform3D = FurniturePanel.this.getModelRotationTransform();
                    Transform3D transform3D2 = new Transform3D();
                    transform3D2.rotY(1.5707963267948966);
                    transform3D2.mul(transform3D);
                    FurniturePanel.this.updateModelRotation(transform3D2);
                }
            });
            this.turnUpButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "TURN_UP", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    Transform3D transform3D = FurniturePanel.this.getModelRotationTransform();
                    Transform3D transform3D2 = new Transform3D();
                    transform3D2.rotX(-1.5707963267948966);
                    transform3D2.mul(transform3D);
                    FurniturePanel.this.updateModelRotation(transform3D2);
                }
            });
            this.turnDownButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "TURN_DOWN", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    Transform3D transform3D = FurniturePanel.this.getModelRotationTransform();
                    Transform3D transform3D2 = new Transform3D();
                    transform3D2.rotX(1.5707963267948966);
                    transform3D2.mul(transform3D);
                    FurniturePanel.this.updateModelRotation(transform3D2);
                }
            });
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL)) {
            if (this.iconComponent != null) {
                furnitureController.addPropertyChangeListener(FurnitureController.Property.MODEL, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        FurniturePanel.this.resetIcon(true);
                    }
                });
                this.iconComponent.setTransferHandler(new TransferHandler(){

                    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                        return Arrays.asList(dataFlavorArray).contains(DataFlavor.javaFileListFlavor);
                    }

                    public boolean importData(JComponent jComponent, Transferable transferable) {
                        boolean bl = false;
                        try {
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            for (File file : list) {
                                final String string = file.getAbsolutePath();
                                if (!furnitureController.getContentManager().isAcceptable(string, ContentManager.ContentType.MODEL)) continue;
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        furnitureController.setModel(string);
                                    }
                                });
                                bl = true;
                                break;
                            }
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!bl) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(FurniturePanel.this), userPreferences.getLocalizedString(FurniturePanel.class, "modelError", new Object[0]), userPreferences.getLocalizedString(FurniturePanel.class, "errorTitle", new Object[0]), 0);
                                }
                            });
                        }
                        return bl;
                    }
                });
                this.iconComponent.setBorder(SwingTools.getDropableComponentBorder());
            }
            this.changeModelButton = new JButton(new ResourceAction(userPreferences, FurniturePanel.class, "CHANGE_MODEL", true){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = furnitureController.getContentManager().showOpenDialog(FurniturePanel.this, userPreferences.getLocalizedString(FurniturePanel.class, "modelChoiceDialog.title", new Object[0]), ContentManager.ContentType.MODEL);
                    if (string != null) {
                        furnitureController.setModel(string);
                    }
                }
            });
        }
        if (furnitureController.isPropertyEditable(FurnitureController.Property.ADDITIONAL_PROPERTIES)) {
            this.additionalPropertiesLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "additionalPropertiesLabel.text", new Object[0]));
            final JTextField jTextField = new JTextField();
            object2 = UUID.randomUUID();
            jTextField.getInputMap(0).put(KeyStroke.getKeyStroke("pressed TAB"), object2);
            class TabAction
            extends AbstractAction {
                private int direction;

                TabAction(int n) {
                    this.direction = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (FurniturePanel.this.additionalPropertiesTable.getEditingRow() + FurniturePanel.this.additionalPropertiesTable.getRowCount() + this.direction) % FurniturePanel.this.additionalPropertiesTable.getRowCount();
                    while (!(FurniturePanel.this.additionalPropertiesTable.isCellEditable(n, 1) && ((ObjectProperty)FurniturePanel.this.additionalPropertiesTable.getValueAt(n, 0)).getType() != ObjectProperty.Type.CONTENT || n == FurniturePanel.this.additionalPropertiesTable.getEditingRow())) {
                        n = (n + FurniturePanel.this.additionalPropertiesTable.getRowCount() + this.direction) % FurniturePanel.this.additionalPropertiesTable.getRowCount();
                    }
                    if (n != FurniturePanel.this.additionalPropertiesTable.getEditingRow()) {
                        FurniturePanel.this.additionalPropertiesTable.setRowSelectionInterval(n, n);
                        FurniturePanel.this.additionalPropertiesTable.scrollRectToVisible(FurniturePanel.this.additionalPropertiesTable.getCellRect(n, 1, true));
                        FurniturePanel.this.additionalPropertiesTable.editCellAt(n, 1);
                        FurniturePanel.this.additionalPropertiesTable.getEditorComponent().requestFocusInWindow();
                    }
                }
            }
            jTextField.getActionMap().put(object2, new TabAction(1));
            object = UUID.randomUUID();
            jTextField.getInputMap(0).put(KeyStroke.getKeyStroke("shift pressed TAB"), object);
            jTextField.getActionMap().put(object, new TabAction(-1));
            UUID uUID = UUID.randomUUID();
            jTextField.getInputMap(0).put(KeyStroke.getKeyStroke("pressed ENTER"), uUID);
            jTextField.getActionMap().put(uUID, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane jOptionPane = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, jTextField);
                    if (jOptionPane != null) {
                        jOptionPane.setValue(0);
                    }
                }
            });
            JButton jButton = new JButton(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "modifyContentButton.text", new Object[0]));
            final JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(UIManager.getColor("Table.background"));
            jPanel.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField){
                private DocumentListener documentListener;

                public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, final int n, final int n2) {
                    FurnitureProperty furnitureProperty = (FurnitureProperty)jTable.getValueAt(n, 0);
                    if (furnitureProperty.getType() == ObjectProperty.Type.CONTENT) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                String string = furnitureController.getContentManager().showOpenDialog(FurniturePanel.this, userPreferences.getLocalizedString(FurniturePanel.class, "selectContent.title", new Object[0]), ContentManager.ContentType.IMAGE);
                                jTable.editingCanceled(null);
                                if (string != null) {
                                    try {
                                        TemporaryURLContent temporaryURLContent = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(new File(string).toURI().toURL()));
                                        jTable.setValueAt(temporaryURLContent, n, n2);
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                        });
                        return jPanel;
                    }
                    this.documentListener = new DocumentListener(){

                        public void changedUpdate(DocumentEvent documentEvent) {
                            jTable.setValueAt(jTextField.getText() != null && jTextField.getText().length() > 0 ? jTextField.getText() : null, n, n2);
                        }

                        public void removeUpdate(DocumentEvent documentEvent) {
                            this.changedUpdate(documentEvent);
                        }

                        public void insertUpdate(DocumentEvent documentEvent) {
                            this.changedUpdate(documentEvent);
                        }
                    };
                    jTextField.getDocument().addDocumentListener(this.documentListener);
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }

                public boolean stopCellEditing() {
                    jTextField.getDocument().removeDocumentListener(this.documentListener);
                    return super.stopCellEditing();
                }

                public void cancelCellEditing() {
                    jTextField.getDocument().removeDocumentListener(this.documentListener);
                    super.cancelCellEditing();
                }

                public Object getCellEditorValue() {
                    Object object = super.getCellEditorValue();
                    return "".equals(object) ? null : object;
                }
            };
            defaultCellEditor.setClickCountToStart(1);
            final PropertiesTableModel propertiesTableModel = new PropertiesTableModel(furnitureController.getAdditionalProperties(), furnitureController, userPreferences);
            this.additionalPropertiesTable = new JTable(propertiesTableModel);
            this.additionalPropertiesTable.getTableHeader().setReorderingAllowed(false);
            this.additionalPropertiesTable.setSelectionMode(0);
            float f3 = SwingTools.getResolutionScale();
            if (f3 != 1.0f) {
                this.additionalPropertiesTable.setRowHeight(Math.round((float)this.additionalPropertiesTable.getRowHeight() * f3));
            }
            this.additionalPropertiesTable.setAutoResizeMode(2);
            TableColumnModel tableColumnModel = this.additionalPropertiesTable.getColumnModel();
            int[] nArray = new int[]{100, 150};
            Font font = new DefaultTableCellRenderer().getFont();
            int n = font != null ? this.getFontMetrics(font).getWidths()[65] : 10;
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth(nArray[i] * n);
            }
            tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    FurnitureProperty furnitureProperty = (FurnitureProperty)object;
                    JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, furnitureProperty.getName(), bl, bl2, n, n2);
                    jComponent.setEnabled(jTable.isCellEditable(n, 1));
                    if (furnitureProperty.getDefaultPropertyKeyName() == null) {
                        jComponent.setFont(jComponent.getFont().deriveFont(2));
                    }
                    return jComponent;
                }
            });
            final TableCellRenderer tableCellRenderer = this.additionalPropertiesTable.getDefaultRenderer(String.class);
            final JButton jButton2 = new JButton(SwingTools.getLocalizedLabelText(userPreferences, FurniturePanel.class, "modifyContentButton.text", new Object[0]));
            jButton2.setPreferredSize(new Dimension(jButton2.getPreferredSize().width + this.additionalPropertiesTable.getRowHeight(), this.additionalPropertiesTable.getRowHeight() - 2));
            final JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBackground(UIManager.getColor("Table.background"));
            jPanel2.add((Component)jButton2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            TableCellRenderer tableCellRenderer2 = new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    FurnitureProperty furnitureProperty = (FurnitureProperty)propertiesTableModel.getValueAt(n, 0);
                    if (furnitureProperty.getType() == ObjectProperty.Type.CONTENT) {
                        if (object != null) {
                            jButton2.setIcon(IconManager.getInstance().getIcon((Content)object, FurniturePanel.this.additionalPropertiesTable.getRowHeight() - 4, FurniturePanel.this.additionalPropertiesTable));
                        } else {
                            jButton2.setIcon(null);
                        }
                        return jPanel2;
                    }
                    JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    jComponent.setEnabled(jTable.isCellEditable(n, 1));
                    return jComponent;
                }
            };
            tableColumnModel.getColumn(1).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(1).setCellEditor(defaultCellEditor);
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    propertiesTableModel.setFurnitureProperties(furnitureController.getAdditionalProperties());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.ADDITIONAL_PROPERTIES, propertyChangeListener);
            propertiesTableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    furnitureController.removePropertyChangeListener(FurnitureController.Property.ADDITIONAL_PROPERTIES, propertyChangeListener);
                    furnitureController.setAdditionalProperties(propertiesTableModel.getAdditionalProperties());
                    furnitureController.addPropertyChangeListener(FurnitureController.Property.ADDITIONAL_PROPERTIES, propertyChangeListener);
                }
            });
        }
        this.dialogTitle = userPreferences.getLocalizedString(FurniturePanel.class, "homeFurniture.title", new Object[0]);
    }

    private Transform3D getModelRotationTransform() {
        float[][] fArray = this.controller.getModelRotation();
        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
        Transform3D transform3D = new Transform3D();
        transform3D.setRotation(matrix3f);
        return transform3D;
    }

    private void updateModelRotation(Transform3D transform3D) {
        Matrix3f matrix3f = new Matrix3f();
        transform3D.getRotationScale(matrix3f);
        boolean bl = this.controller.isProportional();
        this.controller.setProportional(false);
        this.controller.setModelRotation(new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}});
        this.controller.setProportional(bl);
        this.resetIcon(true);
    }

    private void resetIcon(boolean bl) {
        try {
            if (bl) {
                this.iconComponent.resetView();
            }
            if (this.controller.isPropertyEditable(FurnitureController.Property.ICON) && this.iconComponent != null) {
                this.controller.setIcon(this.iconComponent.getIcon(400));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.idLabel != null) {
                this.idLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "idLabel.mnemonic", new Object[0])).getKeyCode());
                this.idLabel.setLabelFor(this.idTextField);
            }
            if (this.nameLabel != null) {
                this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
                this.nameLabel.setLabelFor(this.nameTextField);
            }
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "descriptionLabel.mnemonic", new Object[0])).getKeyCode());
                this.descriptionLabel.setLabelFor(this.descriptionTextField);
            }
            if (this.informationLabel != null) {
                this.informationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "informationLabel.mnemonic", new Object[0])).getKeyCode());
                this.informationLabel.setLabelFor(this.informationTextField);
            }
            if (this.tagsLabel != null) {
                this.tagsLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "tagsLabel.mnemonic", new Object[0])).getKeyCode());
                this.tagsLabel.setLabelFor(this.tagsTextField);
            }
            if (this.creatorLabel != null) {
                this.creatorLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "creatorLabel.mnemonic", new Object[0])).getKeyCode());
                this.creatorLabel.setLabelFor(this.creatorTextField);
            }
            if (this.licenseLabel != null) {
                this.licenseLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "licenseLabel.mnemonic", new Object[0])).getKeyCode());
                this.licenseLabel.setLabelFor(this.licenseTextField);
            }
            if (this.categoryLabel != null) {
                this.categoryLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "categoryLabel.mnemonic", new Object[0])).getKeyCode());
                this.categoryLabel.setLabelFor(this.categoryComboBox);
            }
            if (this.creationDateLabel != null) {
                this.creationDateLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "creationDateLabel.mnemonic", new Object[0])).getKeyCode());
                this.creationDateLabel.setLabelFor(this.creationDateSpinner);
            }
            if (this.priceLabel != null) {
                this.priceLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "priceLabel.mnemonic", new Object[0])).getKeyCode());
                this.priceLabel.setLabelFor(this.priceSpinner);
            }
            if (this.valueAddedTaxPercentageLabel != null) {
                this.valueAddedTaxPercentageLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "valueAddedTaxPercentageLabel.mnemonic", new Object[0])).getKeyCode());
                this.valueAddedTaxPercentageLabel.setLabelFor(this.valueAddedTaxPercentageSpinner);
            }
            if (this.widthLabel != null) {
                this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
                this.widthLabel.setLabelFor(this.widthSpinner);
            }
            if (this.depthLabel != null) {
                this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
                this.depthLabel.setLabelFor(this.depthSpinner);
            }
            if (this.heightLabel != null) {
                this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
                this.heightLabel.setLabelFor(this.heightSpinner);
            }
            if (this.keepProportionsCheckBox != null) {
                this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.elevationLabel != null) {
                this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
                this.elevationLabel.setLabelFor(this.elevationSpinner);
            }
            if (this.movableCheckBox != null) {
                this.movableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "movableCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.doorOrWindowCheckBox != null) {
                this.doorOrWindowCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "doorOrWindowCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.doorOrWindowCustomizedCutOutShapeCheckBox != null) {
                this.doorOrWindowCustomizedCutOutShapeCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "doorOrWindowCustomizedCutOutShapeCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.staircaseCheckBox != null) {
                this.staircaseCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "staircaseCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.staircaseCutOutShapeLabel != null) {
                this.staircaseCutOutShapeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "staircaseCutOutShapeLabel.mnemonic", new Object[0])).getKeyCode());
                this.staircaseCutOutShapeLabel.setLabelFor(this.staircaseCutOutShapeTextField);
            }
            if (this.backFaceShownCheckBox != null) {
                this.backFaceShownCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "backFaceShownCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.edgeColorMaterialHiddenCheckBox != null) {
                this.edgeColorMaterialHiddenCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "edgeColorMaterialHiddenCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.resizableCheckBox != null) {
                this.resizableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "resizableCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.deformableCheckBox != null) {
                this.deformableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "deformableCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.texturableCheckBox != null) {
                this.texturableCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurniturePanel.class, "texturableCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
        }
    }

    private void layoutComponents() {
        JComponent jComponent;
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        Insets insets = new Insets(0, 0, n2, n2);
        Insets insets2 = new Insets(0, 0, n2, 0);
        if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL) || this.controller.isPropertyEditable(FurnitureController.Property.MODEL_ROTATION) || this.controller.isPropertyEditable(FurnitureController.Property.ICON)) {
            jComponent = new JPanel(new GridBagLayout());
            jComponent.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL)) {
                jComponent.add((Component)this.changeModelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n2, 0), 0, 0));
            }
            jComponent.add((Component)this.iconComponent, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n2, 0), 0, 0));
            if (this.controller.isPropertyEditable(FurnitureController.Property.MODEL_ROTATION)) {
                JPanel jPanel = new JPanel(new GridBagLayout()){

                    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
                    }
                };
                jPanel.add((Component)this.turnUpButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 2, 0), 0, 0));
                jPanel.add((Component)this.turnLeftButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 2), 0, 0));
                jPanel.add((Component)this.turnRightButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
                jPanel.add((Component)this.turnDownButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 2, 0), 0, 0));
                jComponent.add((Component)jPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            jComponent.add((Component)new JLabel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 18, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3 * n2), 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.ID)) {
            this.add((Component)this.idLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.idTextField, new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.NAME)) {
            this.add((Component)this.nameLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(2, 1, 3, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DESCRIPTION)) {
            this.add((Component)this.descriptionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.descriptionTextField, new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.INFORMATION)) {
            this.add((Component)this.informationLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.informationTextField, new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.TAGS)) {
            this.add((Component)this.tagsLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.tagsTextField, new GridBagConstraints(2, 4, 3, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CREATOR)) {
            this.add((Component)this.creatorLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.creatorTextField, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.LICENSE)) {
            this.add((Component)this.licenseLabel, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.licenseTextField, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CATEGORY)) {
            if (this.controller.isPropertyEditable(FurnitureController.Property.LICENSE)) {
                this.add((Component)this.categoryLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
                this.add((Component)this.categoryComboBox, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), 0, 0));
            } else {
                this.add((Component)this.categoryLabel, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
                this.add((Component)this.categoryComboBox, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
            }
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.CREATION_DATE)) {
            this.add((Component)this.creationDateLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.creationDateSpinner, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.GRADE)) {
            this.add((Component)this.gradeLabel, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.gradeSpinner, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.PRICE)) {
            this.add((Component)this.priceLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.priceSpinner, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), -10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.VALUE_ADDED_TAX_PERCENTAGE)) {
            this.add((Component)this.valueAddedTaxPercentageLabel, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.valueAddedTaxPercentageSpinner, new GridBagConstraints(4, 8, 2, 1, 0.0, 0.0, 21, 0, insets2, 10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.WIDTH)) {
            this.add((Component)this.widthLabel, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.widthSpinner, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), -10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DEPTH)) {
            this.add((Component)this.depthLabel, new GridBagConstraints(3, 9, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.depthSpinner, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 21, 2, insets2, -10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.HEIGHT)) {
            this.add((Component)this.heightLabel, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.heightSpinner, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 2 * n2), -10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.ELEVATION)) {
            this.add((Component)this.elevationLabel, new GridBagConstraints(3, 10, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.elevationSpinner, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 21, 2, insets2, -10, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.PROPORTIONAL)) {
            jComponent = new JPanel();
            jComponent.add(this.enlargeTenTimesButton);
            jComponent.add(this.reduceTenTimesButton);
            jComponent.add(this.enlargeInchTimesButton);
            this.add((Component)jComponent, new GridBagConstraints(1, 11, 3, 1, 0.0, 0.0, 10, 0, insets2, 0, 0));
            this.add((Component)this.keepProportionsCheckBox, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.BACK_FACE_SHOWN)) {
            this.add((Component)this.backFaceShownCheckBox, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN)) {
            this.add((Component)this.edgeColorMaterialHiddenCheckBox, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DOOR_OR_WINDOW)) {
            this.add((Component)this.doorOrWindowCheckBox, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
            if (this.controller.isPropertyEditable(FurnitureController.Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE)) {
                this.add((Component)this.doorOrWindowCustomizedCutOutShapeCheckBox, new GridBagConstraints(2, 13, 2, 1, 0.0, 0.0, n, 0, OperatingSystem.isMacOSX() ? new Insets(0, 0, n2, 0) : insets, 0, 0));
                this.add((Component)this.doorOrWindowCustomizedCutOutShapeTextField, new GridBagConstraints(4, 13, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
            }
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.STAIRCASE_CUT_OUT_SHAPE)) {
            this.add((Component)this.staircaseCheckBox, new GridBagConstraints(1, 14, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
            this.add((Component)this.staircaseCutOutShapeLabel, new GridBagConstraints(2, 14, 2, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.staircaseCutOutShapeTextField, new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.MOVABLE)) {
            this.add((Component)this.movableCheckBox, new GridBagConstraints(1, 15, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.RESIZABLE)) {
            this.add((Component)this.resizableCheckBox, new GridBagConstraints(2, 15, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.DEFORMABLE)) {
            this.add((Component)this.deformableCheckBox, new GridBagConstraints(3, 15, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.TEXTURABLE)) {
            this.add((Component)this.texturableCheckBox, new GridBagConstraints(4, 15, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        }
        if (this.controller.isPropertyEditable(FurnitureController.Property.ADDITIONAL_PROPERTIES)) {
            this.add((Component)this.additionalPropertiesLabel, new GridBagConstraints(1, 16, 3, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            jComponent = SwingTools.createScrollPane(this.additionalPropertiesTable);
            ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(31);
            jComponent.setPreferredSize(new Dimension(Math.round(250.0f * SwingTools.getResolutionScale()), this.additionalPropertiesTable.getTableHeader().getPreferredSize().height + 6 + this.additionalPropertiesTable.getRowHeight() * Math.min(6, this.additionalPropertiesTable.getRowCount())));
            this.add((Component)jComponent, new GridBagConstraints(1, 17, 4, 1, 0.0, 0.0, 10, 1, insets2, 0, 0));
        }
    }

    public void displayView(View view) {
        boolean bl;
        final JOptionPane jOptionPane = new JOptionPane(this, -1, 2);
        final JDialog jDialog = jOptionPane.createDialog((JComponent)((Object)view), this.dialogTitle);
        jDialog.applyComponentOrientation(((JComponent)((Object)view)).getComponentOrientation());
        jDialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                FurniturePanel.this.nameTextField.requestFocusInWindow();
                jDialog.removeComponentListener(this);
            }
        });
        jDialog.setVisible(true);
        do {
            bl = false;
            if (!jOptionPane.getValue().equals(0)) continue;
            try {
                this.controller.modifyFurniture();
            }
            catch (IllegalStateException illegalStateException) {
                bl = true;
                jDialog.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        SwingTools.showMessageDialog(jOptionPane, illegalStateException.getMessage(), "Error", 0);
                        jDialog.removeComponentListener(this);
                    }
                });
                jDialog.setVisible(true);
            }
        } while (bl);
    }

    private static class IconPreviewComponent
    extends ModelPreviewComponent {
        private static final int PREFERRED_SIZE = 128;
        private float defaultViewYaw;
        private float defaultViewPitch;
        private float defaultViewScale;

        public IconPreviewComponent(final FurnitureController furnitureController, UserPreferences userPreferences) {
            super(true);
            if (furnitureController != null) {
                this.addModelListener(furnitureController, userPreferences);
                this.addSizeListeners(furnitureController);
                this.addRotationListener(furnitureController);
                this.addModelFlagsListener(furnitureController);
                this.setBackground(UIManager.getColor("window"));
                if (furnitureController.getModel() != null) {
                    this.setModel(furnitureController.getModel(), furnitureController.getBackFaceShown() != null ? furnitureController.getBackFaceShown() : false, furnitureController.getEdgeColorMaterialHidden() != null ? furnitureController.getEdgeColorMaterialHidden() : false, furnitureController.getModelRotation(), furnitureController.getWidth(), furnitureController.getDepth(), furnitureController.getHeight(), userPreferences);
                } else {
                    this.setModel(null);
                }
                this.addMouseListener(new MouseAdapter(){
                    private boolean mousePressedInIcon;

                    public void mousePressed(MouseEvent mouseEvent) {
                        this.mousePressedInIcon = true;
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (furnitureController.isPropertyEditable(FurnitureController.Property.ICON) && this.mousePressedInIcon) {
                            this.mousePressedInIcon = false;
                            try {
                                furnitureController.setIcon(IconPreviewComponent.this.getIcon(400));
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                });
            }
            this.defaultViewYaw = this.getViewYaw();
            this.defaultViewPitch = this.getViewPitch();
            this.defaultViewScale = this.getViewScale();
        }

        private void addRotationListener(final FurnitureController furnitureController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IconPreviewComponent.this.setModelRotation(furnitureController.getModelRotation());
                    if (propertyChangeEvent.getOldValue() != null) {
                        float f = furnitureController.getWidth().floatValue();
                        float f2 = furnitureController.getDepth().floatValue();
                        float f3 = furnitureController.getHeight().floatValue();
                        float[][] fArray = (float[][])propertyChangeEvent.getOldValue();
                        Matrix3f matrix3f = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                        matrix3f.invert();
                        float f4 = matrix3f.m00 * f + matrix3f.m01 * f3 + matrix3f.m02 * f2;
                        float f5 = matrix3f.m10 * f + matrix3f.m11 * f3 + matrix3f.m12 * f2;
                        float f6 = matrix3f.m20 * f + matrix3f.m21 * f3 + matrix3f.m22 * f2;
                        float[][] fArray2 = (float[][])propertyChangeEvent.getNewValue();
                        furnitureController.setWidth(Float.valueOf(Math.abs(fArray2[0][0] * f4 + fArray2[0][1] * f5 + fArray2[0][2] * f6)));
                        furnitureController.setHeight(Float.valueOf(Math.abs(fArray2[1][0] * f4 + fArray2[1][1] * f5 + fArray2[1][2] * f6)));
                        furnitureController.setDepth(Float.valueOf(Math.abs(fArray2[2][0] * f4 + fArray2[2][1] * f5 + fArray2[2][2] * f6)));
                    }
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.MODEL_ROTATION, propertyChangeListener);
        }

        private void addSizeListeners(final FurnitureController furnitureController) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IconPreviewComponent.this.setModelRotationAndSize(furnitureController.getModelRotation(), furnitureController.getWidth().floatValue(), furnitureController.getDepth().floatValue(), furnitureController.getHeight().floatValue());
                }
            };
            furnitureController.addPropertyChangeListener(FurnitureController.Property.MODEL_ROTATION, propertyChangeListener);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.WIDTH, propertyChangeListener);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.DEPTH, propertyChangeListener);
            furnitureController.addPropertyChangeListener(FurnitureController.Property.HEIGHT, propertyChangeListener);
        }

        private void addModelFlagsListener(final FurnitureController furnitureController) {
            furnitureController.addPropertyChangeListener(FurnitureController.Property.BACK_FACE_SHOWN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (furnitureController.getBackFaceShown() != null) {
                        IconPreviewComponent.this.setBackFaceShown(furnitureController.getBackFaceShown());
                    }
                }
            });
            furnitureController.addPropertyChangeListener(FurnitureController.Property.EDGE_COLOR_MATERIAL_HIDDEN, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (furnitureController.getEdgeColorMaterialHidden() != null) {
                        IconPreviewComponent.this.setEdgeColorMaterialHidden(furnitureController.getEdgeColorMaterialHidden());
                    }
                }
            });
        }

        private void addModelListener(final FurnitureController furnitureController, final UserPreferences userPreferences) {
            furnitureController.addPropertyChangeListener(FurnitureController.Property.MODEL, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IconPreviewComponent.this.setModel(furnitureController.getModel(), furnitureController.getBackFaceShown() != null ? furnitureController.getBackFaceShown() : false, furnitureController.getEdgeColorMaterialHidden() != null ? furnitureController.getEdgeColorMaterialHidden() : false, furnitureController.getModelRotation(), furnitureController.getWidth(), furnitureController.getDepth(), furnitureController.getHeight(), userPreferences);
                }
            });
        }

        public void setModel(final Content content, final boolean bl, final boolean bl2, final float[][] fArray, final Float f, final Float f2, final Float f3, final UserPreferences userPreferences) {
            if (content == null) {
                this.setModel(null);
            } else {
                ModelManager.getInstance().loadModel(content, new ModelManager.ModelObserver(){

                    public void modelUpdated(BranchGroup branchGroup) {
                        IconPreviewComponent.this.setModel(content);
                        if (f != null && f2 != null && f3 != null) {
                            IconPreviewComponent.this.setModelRotationAndSize(fArray, f.floatValue(), f2.floatValue(), f3.floatValue());
                            IconPreviewComponent.this.setBackFaceShown(bl);
                            IconPreviewComponent.this.setEdgeColorMaterialHidden(bl2);
                        }
                    }

                    public void modelError(Exception exception) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(IconPreviewComponent.this), userPreferences.getLocalizedString(FurniturePanel.class, "modelError", new Object[0]), userPreferences.getLocalizedString(FurniturePanel.class, "errorTitle", new Object[0]), 0);
                    }
                });
            }
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(128 + insets.left + insets.right, 128 + insets.top + insets.bottom);
        }

        public void resetView() {
            this.setViewYaw(this.defaultViewYaw);
            this.setViewPitch(this.defaultViewPitch);
            this.setViewScale(this.defaultViewScale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertiesTableModel
    extends AbstractTableModel {
        private Map<FurnitureProperty, Object> additionalProperties;
        private List<FurnitureProperty> keys;
        private FurnitureController controller;
        private String[] columnNames;

        private PropertiesTableModel(Map<FurnitureProperty, Object> map, FurnitureController furnitureController, UserPreferences userPreferences) {
            this.controller = furnitureController;
            this.additionalProperties = new LinkedHashMap<FurnitureProperty, Object>(map);
            this.keys = new ArrayList<FurnitureProperty>(map.keySet());
            this.columnNames = new String[]{userPreferences.getLocalizedString(FurniturePanel.class, "additionalProperties.nameColumn", new Object[0]), userPreferences.getLocalizedString(FurniturePanel.class, "additionalProperties.valueColumn", new Object[0])};
        }

        @Override
        public int getRowCount() {
            return this.additionalProperties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FurnitureProperty furnitureProperty = this.keys.get(n);
            switch (n2) {
                case 0: {
                    return furnitureProperty;
                }
                case 1: {
                    return this.additionalProperties.get(furnitureProperty);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FurnitureProperty furnitureProperty = this.keys.get(n);
            if (n2 == 1) {
                this.additionalProperties.put(furnitureProperty, object);
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                FurnitureProperty furnitureProperty = this.keys.get(n);
                if (furnitureProperty.getDefaultPropertyKeyName() != null) {
                    switch (DefaultFurnitureCatalog.PropertyKey.valueOf(furnitureProperty.getDefaultPropertyKeyName())) {
                        case DOOR_OR_WINDOW_SASH_X_AXIS: 
                        case DOOR_OR_WINDOW_SASH_Y_AXIS: 
                        case DOOR_OR_WINDOW_SASH_WIDTH: 
                        case DOOR_OR_WINDOW_SASH_START_ANGLE: 
                        case DOOR_OR_WINDOW_SASH_END_ANGLE: 
                        case DOOR_OR_WINDOW_WALL_THICKNESS: 
                        case DOOR_OR_WINDOW_WALL_DISTANCE: 
                        case DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES: 
                        case DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE: {
                            return this.controller.getDoorOrWindow();
                        }
                        case LIGHT_SOURCE_X: 
                        case LIGHT_SOURCE_Y: 
                        case LIGHT_SOURCE_Z: 
                        case LIGHT_SOURCE_COLOR: 
                        case LIGHT_SOURCE_DIAMETER: 
                        case LIGHT_SOURCE_MATERIAL_NAME: 
                        case HORIZONTALLY_ROTATABLE: 
                        case SHELF_ELEVATIONS: 
                        case SHELF_BOXES: {
                            return this.controller.getDoorOrWindow() == false;
                        }
                    }
                }
                return true;
            }
            return false;
        }

        public Map<FurnitureProperty, Object> getAdditionalProperties() {
            return new LinkedHashMap<FurnitureProperty, Object>(this.additionalProperties);
        }

        public void setFurnitureProperties(Map<FurnitureProperty, Object> map) {
            this.additionalProperties = new LinkedHashMap<FurnitureProperty, Object>(map);
            this.keys = new ArrayList<FurnitureProperty>(map.keySet());
            this.fireTableDataChanged();
        }
    }
}

