/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.swing;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureTaskView;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.ThreadedTaskPanel;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.vecmath.Vector3f;

public class ImportFurnitureTaskPanel
extends ThreadedTaskPanel
implements ImportFurnitureTaskView {
    private static final int PREVIEW_PREFERRED_SIZE = 128;
    private final FurnitureLibraryUserPreferences preferences;
    private ModelPreviewComponent iconPreviewComponent;
    private boolean firstRendering = true;

    public ImportFurnitureTaskPanel(String string, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, ThreadedTaskController threadedTaskController) {
        super(string, furnitureLibraryUserPreferences, threadedTaskController);
        this.preferences = furnitureLibraryUserPreferences;
        this.iconPreviewComponent = new ModelPreviewComponent();
        Insets insets = this.iconPreviewComponent.getInsets();
        this.iconPreviewComponent.setPreferredSize(new Dimension(128 + insets.left + insets.right, 128 + insets.top + insets.bottom));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(this.getComponent(0), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 16, 0, new Insets(0, 0, 10, 0), 0, 0));
        gridBagLayout.setConstraints(this.getComponent(1), new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.iconPreviewComponent, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatalogPieceOfFurniture readPieceOfFurniture(Content content) throws InterruptedException {
        try {
            void var12_34;
            Object object;
            int n;
            HomeMaterial[] homeMaterialArray;
            ZipInputStream zipInputStream;
            Object object2;
            String string = "model";
            if (content instanceof URLContent && ((String)(object2 = ((URLContent)content).getURL().getFile())).indexOf(63) == -1) {
                int n2;
                string = URLDecoder.decode(((String)object2).replace("+", "%2B"), "UTF-8");
                if (string.lastIndexOf(47) != -1) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                if ((n2 = string.lastIndexOf(46)) != -1) {
                    string = string.substring(0, n2);
                }
            }
            object2 = new AtomicReference();
            ModelManager modelManager = ModelManager.getInstance();
            try {
                ((AtomicReference)object2).set(modelManager.loadModel(content));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URLContent uRLContent = null;
            if (((AtomicReference)object2).get() != null) {
                uRLContent = ImportFurnitureTaskPanel.copyToTemporaryOBJContent((BranchGroup)((AtomicReference)object2).get(), content);
                modelManager.loadModel(content, true, new ModelManager.ModelObserver(){

                    public void modelUpdated(BranchGroup branchGroup) {
                    }

                    public void modelError(Exception exception) {
                    }
                });
            } else {
                zipInputStream = null;
                try {
                    ZipEntry zipEntry;
                    homeMaterialArray = TemporaryURLContent.copyToTemporaryURLContent(content);
                    zipInputStream = new ZipInputStream(homeMaterialArray.openStream());
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string2;
                        String string3 = zipEntry.getName();
                        if (string3.endsWith("/") || (string2 = string3.substring((n = string3.lastIndexOf(47)) + 1)).startsWith(".")) continue;
                        URL uRL = new URL("jar:" + homeMaterialArray.getURL() + "!/" + URLEncoder.encode(string3, "UTF-8").replace("+", "%20").replace("%2F", "/"));
                        object = new TemporaryURLContent(uRL);
                        modelManager.loadModel((Content)object, true, new ModelManager.ModelObserver((AtomicReference)object2){
                            final /* synthetic */ AtomicReference val$modelNode;
                            {
                                this.val$modelNode = atomicReference;
                            }

                            public void modelUpdated(BranchGroup branchGroup) {
                                this.val$modelNode.set(branchGroup);
                            }

                            public void modelError(Exception exception) {
                            }
                        });
                        if (((AtomicReference)object2).get() == null) continue;
                        uRLContent = new TemporaryURLContent(uRL);
                        if (!string2.toLowerCase().endsWith(".obj") && (this.preferences.isModelContentAlwaysConvertedToOBJFormat() || n > 0)) {
                            uRLContent = ImportFurnitureTaskPanel.copyToTemporaryOBJContent((BranchGroup)((AtomicReference)object2).get(), content);
                        }
                        if (!"model.dae".equals(string2)) {
                            int n3 = string2.lastIndexOf(".");
                            string = n3 != -1 ? string2.substring(0, n3) : string2;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = null;
                    return catalogPieceOfFurniture;
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (((AtomicReference)object2).get() == null) {
                return null;
            }
            zipInputStream = modelManager.getSize((Node)((AtomicReference)object2).get());
            homeMaterialArray = modelManager.getMaterials((Node)((AtomicReference)object2).get());
            boolean bl = false;
            for (HomeMaterial homeMaterial : homeMaterialArray) {
                if (!homeMaterial.getName().startsWith("edge_color")) continue;
                bl = true;
            }
            final URLContent uRLContent2 = uRLContent;
            n = bl ? 2 : 0;
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ImportFurnitureTaskPanel.this.iconPreviewComponent.setModel(uRLContent2);
                    ImportFurnitureTaskPanel.this.iconPreviewComponent.setModelFlags(n);
                }
            });
            Thread.sleep(this.firstRendering ? 1000L : 100L);
            this.firstRendering = false;
            final AtomicReference atomicReference = new AtomicReference();
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        atomicReference.set(ImportFurnitureTaskPanel.this.iconPreviewComponent.getIcon(100));
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Couldn't retrieve icon", iOException);
                    }
                }
            });
            if (Arrays.asList(this.preferences.getEditedProperties()).contains(FurnitureLibrary.FURNITURE_ID_PROPERTY) || this.preferences.isFurnitureIdEditable()) {
                void var12_31;
                String string4 = this.preferences.getDefaultCreator();
                if (string4 == null) {
                    String string5 = System.getProperty("user.name");
                }
                String string6 = (String)var12_31 + "#" + string;
            } else {
                Object var12_33 = null;
            }
            object = new CatalogPieceOfFurniture((String)var12_34, this.getPieceOfFurnitureName(string), null, null, new String[0], null, null, (Content)atomicReference.get(), null, (Content)uRLContent, ((Vector3f)zipInputStream).x, ((Vector3f)zipInputStream).z, ((Vector3f)zipInputStream).y, 0.0f, 1.0f, true, null, (float[][])null, n, (Long)uRLContent.getSize(), this.preferences.getDefaultCreator(), true, true, true, true, null, null, null, null);
            FurnitureCategory furnitureCategory = new FurnitureCategory(this.preferences.getLocalizedString(ImportFurnitureTaskPanel.class, "defaultCategory", new Object[0]));
            new FurnitureCatalog().add(furnitureCategory, (CatalogPieceOfFurniture)object);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    protected String getPieceOfFurnitureName(String string) {
        if (this.preferences.isFurnitureNameEqualToImportedModelFileName()) {
            return string;
        }
        String string2 = "" + Character.toUpperCase(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-' || c == '_') {
                string2 = string2 + ' ';
                continue;
            }
            if ((Character.isUpperCase(c) || Character.isDigit(c)) && Character.isLowerCase(string.charAt(i - 1))) {
                string2 = string2 + ' ';
                c = Character.toLowerCase(c);
            }
            string2 = string2 + c;
        }
        return string2;
    }

    static URLContent copyToTemporaryOBJContent(BranchGroup branchGroup, Content content) throws IOException {
        String string;
        if (content instanceof URLContent) {
            string = ((URLContent)content).getURL().getFile();
            if (string.lastIndexOf(47) != -1) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            if (!(string = new File(string).getName()).toLowerCase().endsWith(".obj")) {
                if (string.lastIndexOf(46) != -1) {
                    string = string.substring(0, string.lastIndexOf(46));
                }
                string = string + ".obj";
            }
            if ((string = URLDecoder.decode(string.replace("+", "%2B"), "UTF-8")).matches(".*[^a-zA-Z0-9_\\.\\-\\ ].*")) {
                string = "model.obj";
            }
        } else {
            string = "model.obj";
        }
        File file = File.createTempFile("urlContent", "tmp");
        file.deleteOnExit();
        OBJWriter.writeNodeInZIPFile((Node)branchGroup, file, 0, string, "3D model " + string);
        return new TemporaryURLContent(new URL("jar:" + file.toURI().toURL() + "!/" + URLEncoder.encode(string, "UTF-8").replace("+", "%20")));
    }
}

