/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.model.FurnitureProperty;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureController;
import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.model.BoxBounds;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogShelfUnit;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.ShelfUnit;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureController
implements Controller {
    private static final String DEFAULT_CUT_OUT_SHAPE = "M0,0 v1 h1 v-1 z";
    private final FurnitureLibrary furnitureLibrary;
    private final List<CatalogPieceOfFurniture> modifiedFurniture;
    private final Set<Property> editableProperties;
    private final FurnitureLibraryUserPreferences preferences;
    private final FurnitureLanguageController furnitureLanguageController;
    private final EditorViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView homeFurnitureView;
    private String id;
    private String name;
    private String description;
    private String information;
    private String[] tags;
    private Long creationDate;
    private Float grade;
    private FurnitureCategory category;
    private Content model;
    private Content icon;
    private Float width;
    private Float proportionalWidth;
    private Float depth;
    private Float proportionalDepth;
    private Float height;
    private Float proportionalHeight;
    private Float elevation;
    private Boolean movable;
    private Boolean doorOrWindow;
    private String doorOrWindowCutOutShape;
    private Boolean staircase;
    private String staircaseCutOutShape;
    private Boolean backFaceShown;
    private Boolean edgeColorMaterialHidden;
    private Long modelSize;
    private Boolean resizable;
    private Boolean deformable;
    private Boolean texturable;
    private float[][] modelRotation;
    private String creator;
    private String license;
    private BigDecimal price;
    private BigDecimal valueAddedTaxPercentage;
    private Map<FurnitureProperty, Object> additionalProperties;
    private boolean proportional;
    private PropertyChangeListener widthChangeListener;
    private PropertyChangeListener depthChangeListener;
    private PropertyChangeListener heightChangeListener;

    public FurnitureController(FurnitureLibrary furnitureLibrary, List<CatalogPieceOfFurniture> list, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController, EditorViewFactory editorViewFactory, ContentManager contentManager) {
        this.furnitureLibrary = furnitureLibrary;
        this.modifiedFurniture = list;
        this.preferences = furnitureLibraryUserPreferences;
        this.furnitureLanguageController = furnitureLanguageController;
        this.viewFactory = editorViewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.editableProperties = new HashSet<Property>();
        for (FurnitureProperty furnitureProperty : furnitureLibraryUserPreferences.getFurnitureProperties()) {
            if (!furnitureProperty.isModifiable() || furnitureProperty.getDefaultPropertyKeyName() == null) continue;
            try {
                this.editableProperties.add(Property.valueOf(furnitureProperty.getDefaultPropertyKeyName()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setProportional(list.size() == 1);
        this.updateProperties();
        this.addListeners();
    }

    @Override
    public DialogView getView() {
        if (this.homeFurnitureView == null) {
            this.homeFurnitureView = this.viewFactory.createFurnitureView(this.preferences, this);
        }
        return this.homeFurnitureView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    private void addListeners() {
        this.widthChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setDepth(Float.valueOf(FurnitureController.this.proportionalDepth.floatValue() * f), true);
                    FurnitureController.this.setHeight(Float.valueOf(FurnitureController.this.proportionalHeight.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                }
            }
        };
        this.depthChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setWidth(Float.valueOf(FurnitureController.this.proportionalWidth.floatValue() * f), true);
                    FurnitureController.this.setHeight(Float.valueOf(FurnitureController.this.proportionalHeight.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                }
            }
        };
        this.heightChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setWidth(Float.valueOf(FurnitureController.this.proportionalWidth.floatValue() * f), true);
                    FurnitureController.this.setDepth(Float.valueOf(FurnitureController.this.proportionalDepth.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                }
            }
        };
        this.addPropertyChangeListener(Property.WIDTH, this.widthChangeListener);
        this.addPropertyChangeListener(Property.DEPTH, this.depthChangeListener);
        this.addPropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public boolean isPropertyEditable(Property property) {
        if (this.modifiedFurniture.size() == 1) {
            if (property == Property.ADDITIONAL_PROPERTIES) {
                return this.getAdditionalProperties().size() > 0;
            }
            return this.editableProperties.contains((Object)property);
        }
        return this.editableProperties.contains((Object)property) && property != Property.ID && property != Property.MODEL && property != Property.ICON && property != Property.MODEL_ROTATION && property != Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE && property != Property.ADDITIONAL_PROPERTIES;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateProperties() {
        if (this.modifiedFurniture.isEmpty()) {
            this.setId(null);
            this.setName(null);
            this.setDescription(null);
            this.setInformation(null);
            this.setTags(null);
            this.setCreationDate(null);
            this.setGrade(null);
            this.setCategory(null);
            this.setModel((Content)null);
            this.setIcon(null);
            this.setWidth(null);
            this.setDepth(null);
            this.setHeight(null);
            this.setElevation(null);
            this.setMovable(null);
            this.setDoorOrWindow(null);
            this.setResizable(null);
            this.setDeformable(null);
            this.setTexturable(null);
            this.setDoorOrWindowCutOutShape(null);
            this.setStaircase(null);
            this.setStaircaseCutOutShape(null);
            this.setModelRotation(null);
            this.setBackFaceShown(null);
            this.setEdgeColorMaterialHidden(null);
            this.setCreator(null);
            this.setLicense(null);
            this.setPrice(null);
            this.setValueAddedTaxPercentage(null);
            this.setAdditionalProperties(Collections.<FurnitureProperty, Object>emptyMap());
            this.editableProperties.remove((Object)Property.PROPORTIONAL);
        } else {
            Comparable<CatalogPieceOfFurniture> comparable;
            int n;
            String string;
            void var8_21;
            int n2;
            Object object;
            Object furnitureCategory;
            Object object2;
            Object object4;
            Object object5;
            Object object6;
            CatalogPieceOfFurniture catalogPieceOfFurniture = this.modifiedFurniture.get(0);
            if (this.modifiedFurniture.size() == 1) {
                this.setIcon(catalogPieceOfFurniture.getIcon());
                this.setModel(catalogPieceOfFurniture.getModel());
                this.setModelSize(catalogPieceOfFurniture.getModelSize());
                this.editableProperties.add(Property.ICON);
                this.editableProperties.add(Property.BACK_FACE_SHOWN);
                this.editableProperties.add(Property.EDGE_COLOR_MATERIAL_HIDDEN);
                object6 = new LinkedHashMap();
                object5 = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
                object4 = this.preferences.getLengthUnit().getFormat();
                block30: for (FurnitureProperty object7 : this.preferences.getFurnitureProperties()) {
                    if (object7.isModifiable()) {
                        if (object7.getDefaultPropertyKeyName() != null) {
                            object2 = null;
                            switch (DefaultFurnitureCatalog.PropertyKey.valueOf(object7.getDefaultPropertyKeyName())) {
                                case ICON: {
                                    this.editableProperties.remove((Object)Property.ICON);
                                    object2 = catalogPieceOfFurniture.getIcon();
                                    break;
                                }
                                case PLAN_ICON: {
                                    object2 = catalogPieceOfFurniture.getPlanIcon();
                                    break;
                                }
                                case DROP_ON_TOP_ELEVATION: {
                                    if (!(Math.abs(catalogPieceOfFurniture.getDropOnTopElevation() - 1.0f) > 1.0E-6f)) break;
                                    object2 = ((Format)object4).format(Float.valueOf(catalogPieceOfFurniture.getDropOnTopElevation() * catalogPieceOfFurniture.getHeight()));
                                    break;
                                }
                                case DOOR_OR_WINDOW_WALL_THICKNESS: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((CatalogDoorOrWindow)catalogPieceOfFurniture).getWallThickness() == 1.0f) break;
                                    object2 = ((Format)object4).format(Float.valueOf(((DoorOrWindow)((Object)catalogPieceOfFurniture)).getWallThickness() * catalogPieceOfFurniture.getDepth()));
                                    break;
                                }
                                case DOOR_OR_WINDOW_WALL_DISTANCE: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((CatalogDoorOrWindow)catalogPieceOfFurniture).getWallDistance() == 0.0f) break;
                                    object2 = ((Format)object4).format(Float.valueOf(((DoorOrWindow)((Object)catalogPieceOfFurniture)).getWallDistance() * catalogPieceOfFurniture.getDepth()));
                                    break;
                                }
                                case DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow()) break;
                                    object2 = String.valueOf(((DoorOrWindow)((Object)catalogPieceOfFurniture)).isWallCutOutOnBothSides());
                                    break;
                                }
                                case DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow()) break;
                                    object2 = String.valueOf(((DoorOrWindow)((Object)catalogPieceOfFurniture)).isWidthDepthDeformable());
                                    break;
                                }
                                case DOOR_OR_WINDOW_SASH_X_AXIS: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes().length <= 0) break;
                                    furnitureCategory = ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((Sash)furnitureCategory[n2]).getXAxis() * catalogPieceOfFurniture.getWidth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case DOOR_OR_WINDOW_SASH_Y_AXIS: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes().length <= 0) break;
                                    furnitureCategory = ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((Sash)furnitureCategory[n2]).getYAxis() * catalogPieceOfFurniture.getDepth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case DOOR_OR_WINDOW_SASH_WIDTH: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes().length <= 0) break;
                                    furnitureCategory = ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((Sash)furnitureCategory[n2]).getWidth() * catalogPieceOfFurniture.getWidth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case DOOR_OR_WINDOW_SASH_START_ANGLE: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes().length <= 0) break;
                                    furnitureCategory = ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((NumberFormat)object5).format(Math.toDegrees(((Sash)furnitureCategory[n2]).getStartAngle()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case DOOR_OR_WINDOW_SASH_END_ANGLE: {
                                    if (!catalogPieceOfFurniture.isDoorOrWindow() || ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes().length <= 0) break;
                                    furnitureCategory = ((DoorOrWindow)((Object)catalogPieceOfFurniture)).getSashes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((NumberFormat)object5).format(Math.toDegrees(((Sash)furnitureCategory[n2]).getEndAngle()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_X: {
                                    if (!(catalogPieceOfFurniture instanceof Light) || ((Light)((Object)catalogPieceOfFurniture)).getLightSources().length <= 0) break;
                                    furnitureCategory = ((Light)((Object)catalogPieceOfFurniture)).getLightSources();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((LightSource)furnitureCategory[n2]).getX() * catalogPieceOfFurniture.getWidth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_Y: {
                                    if (!(catalogPieceOfFurniture instanceof Light) || ((Light)((Object)catalogPieceOfFurniture)).getLightSources().length <= 0) break;
                                    furnitureCategory = ((Light)((Object)catalogPieceOfFurniture)).getLightSources();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((LightSource)furnitureCategory[n2]).getY() * catalogPieceOfFurniture.getDepth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_Z: {
                                    if (!(catalogPieceOfFurniture instanceof Light) || ((Light)((Object)catalogPieceOfFurniture)).getLightSources().length <= 0) break;
                                    furnitureCategory = ((Light)((Object)catalogPieceOfFurniture)).getLightSources();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((LightSource)furnitureCategory[n2]).getZ() * catalogPieceOfFurniture.getHeight()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_COLOR: {
                                    if (!(catalogPieceOfFurniture instanceof Light) || ((Light)((Object)catalogPieceOfFurniture)).getLightSources().length <= 0) break;
                                    furnitureCategory = ((Light)((Object)catalogPieceOfFurniture)).getLightSources();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + "#" + String.format("%06X", ((LightSource)furnitureCategory[n2]).getColor());
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_DIAMETER: {
                                    if (!(catalogPieceOfFurniture instanceof Light) || ((Light)((Object)catalogPieceOfFurniture)).getLightSources().length <= 0) break;
                                    furnitureCategory = ((Light)((Object)catalogPieceOfFurniture)).getLightSources();
                                    object = null;
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        if (((LightSource)furnitureCategory[n2]).getDiameter() == null) continue;
                                        if (object == null) {
                                            object = "";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((LightSource)furnitureCategory[n2]).getDiameter().floatValue() * catalogPieceOfFurniture.getWidth()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case LIGHT_SOURCE_MATERIAL_NAME: {
                                    if (!(catalogPieceOfFurniture instanceof Light)) break;
                                    furnitureCategory = Arrays.toString(((Light)((Object)catalogPieceOfFurniture)).getLightSourceMaterialNames());
                                    object2 = ((String)furnitureCategory).substring(1, ((String)furnitureCategory).length() - 1);
                                    break;
                                }
                                case SHELF_ELEVATIONS: {
                                    if (!(catalogPieceOfFurniture instanceof ShelfUnit) || ((ShelfUnit)((Object)catalogPieceOfFurniture)).getShelfElevations().length <= 0) break;
                                    furnitureCategory = ((ShelfUnit)((Object)catalogPieceOfFurniture)).getShelfElevations();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + " ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf((float)(furnitureCategory[n2] * catalogPieceOfFurniture.getHeight())));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case SHELF_BOXES: {
                                    if (!(catalogPieceOfFurniture instanceof ShelfUnit) || ((ShelfUnit)((Object)catalogPieceOfFurniture)).getShelfBoxes().length <= 0) break;
                                    furnitureCategory = ((ShelfUnit)((Object)catalogPieceOfFurniture)).getShelfBoxes();
                                    object = "";
                                    for (n2 = 0; n2 < ((Serializable[])furnitureCategory).length; ++n2) {
                                        if (n2 > 0) {
                                            object = (String)object + "   ";
                                        }
                                        object = (String)object + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getXLower() * catalogPieceOfFurniture.getWidth())) + " " + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getYLower() * catalogPieceOfFurniture.getDepth())) + " " + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getZLower() * catalogPieceOfFurniture.getHeight())) + " " + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getXUpper() * catalogPieceOfFurniture.getWidth())) + " " + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getYUpper() * catalogPieceOfFurniture.getDepth())) + " " + ((Format)object4).format(Float.valueOf(((BoxBounds)furnitureCategory[n2]).getZUpper() * catalogPieceOfFurniture.getHeight()));
                                    }
                                    object2 = object;
                                    break;
                                }
                                case HORIZONTALLY_ROTATABLE: {
                                    object2 = String.valueOf(catalogPieceOfFurniture.isHorizontallyRotatable());
                                    break;
                                }
                                case CURRENCY: {
                                    object2 = catalogPieceOfFurniture.getCurrency();
                                    break;
                                }
                                default: {
                                    continue block30;
                                }
                            }
                            object6.put(object7, object2);
                            continue;
                        }
                        if (object7.getType() == ObjectProperty.Type.NUMBER) {
                            object2 = catalogPieceOfFurniture.getProperty(object7.getName());
                            if (object2 != null) {
                                try {
                                    object2 = NumberFormat.getNumberInstance().format(Float.parseFloat((String)object2));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            object6.put(object7, object2);
                            continue;
                        }
                        if (object7.getType() == ObjectProperty.Type.LENGTH) {
                            object2 = catalogPieceOfFurniture.getProperty(object7.getName());
                            if (object2 != null) {
                                try {
                                    object2 = this.preferences.getLengthUnit().getFormat().format(Float.valueOf(Float.parseFloat((String)object2)));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            object6.put(object7, object2);
                            continue;
                        }
                        if (object7.getType() == ObjectProperty.Type.DATE) {
                            object2 = catalogPieceOfFurniture.getProperty(object7.getName());
                            if (object2 != null) {
                                try {
                                    object2 = DateFormat.getDateInstance(3).format(new SimpleDateFormat("yyyy-MM-dd").parse((String)object2));
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                            }
                            object6.put(object7, object2);
                            continue;
                        }
                        if (object7.getType() == ObjectProperty.Type.CONTENT) {
                            object6.put(object7, catalogPieceOfFurniture.getContentProperty(object7.getName()));
                            continue;
                        }
                        object6.put(object7, catalogPieceOfFurniture.getProperty(object7.getName()));
                        continue;
                    }
                    if (!DefaultFurnitureCatalog.PropertyKey.MODEL_FLAGS.name().equals(object7.getDefaultPropertyKeyName())) continue;
                    this.editableProperties.remove((Object)Property.BACK_FACE_SHOWN);
                    this.editableProperties.remove((Object)Property.EDGE_COLOR_MATERIAL_HIDDEN);
                }
                this.setAdditionalProperties((Map<FurnitureProperty, Object>)object6);
            } else {
                this.setIcon(null);
                this.setModel((Content)null);
                this.setModelSize(null);
                this.editableProperties.remove((Object)Property.BACK_FACE_SHOWN);
                this.editableProperties.remove((Object)Property.EDGE_COLOR_MATERIAL_HIDDEN);
                this.setAdditionalProperties(Collections.<FurnitureProperty, Object>emptyMap());
            }
            object6 = catalogPieceOfFurniture.getId();
            if (object6 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (((String)object6).equals(this.modifiedFurniture.get(i).getId())) continue;
                    object6 = null;
                    break;
                }
            }
            this.setId((String)object6);
            object5 = this.furnitureLanguageController.getFurnitureLangauge();
            object4 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_NAME_PROPERTY, catalogPieceOfFurniture.getName());
            if (object4 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.modifiedFurniture.get(i);
                    if (((String)object4).equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, (String)object5, FurnitureLibrary.FURNITURE_NAME_PROPERTY, catalogPieceOfFurniture2.getName()))) continue;
                    object4 = null;
                    break;
                }
            }
            this.setName((String)object4);
            Object object8 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY, catalogPieceOfFurniture.getDescription());
            if (object8 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture3 = this.modifiedFurniture.get(i);
                    if (((String)object8).equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture3, (String)object5, FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY, catalogPieceOfFurniture3.getDescription()))) continue;
                    object8 = null;
                    break;
                }
            }
            this.setDescription((String)object8);
            String string2 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY, catalogPieceOfFurniture.getInformation());
            if (string2 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture l = this.modifiedFurniture.get(i);
                    if (string2.equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData(l, (String)object5, FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY, l.getInformation()))) continue;
                    string2 = null;
                    break;
                }
            }
            this.setInformation(string2);
            Object[] objectArray = (String[])this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_TAGS_PROPERTY, catalogPieceOfFurniture.getTags());
            if (objectArray != null) {
                void var8_18;
                boolean bl = true;
                while (var8_18 < this.modifiedFurniture.size()) {
                    object2 = this.modifiedFurniture.get((int)var8_18);
                    if (!Arrays.equals(objectArray, (String[])this.furnitureLibrary.getPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object2, (String)object5, FurnitureLibrary.FURNITURE_TAGS_PROPERTY, ((CatalogPieceOfFurniture)object2).getTags()))) {
                        objectArray = null;
                        break;
                    }
                    ++var8_18;
                }
            }
            this.setTags((String[])objectArray);
            Long l = catalogPieceOfFurniture.getCreationDate();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                furnitureCategory = this.modifiedFurniture.get(i);
                if ((l != null || ((CatalogPieceOfFurniture)furnitureCategory).getCreationDate() == null) && (l == null || l.equals(((CatalogPieceOfFurniture)furnitureCategory).getCreationDate()))) continue;
                Object var8_20 = null;
                break;
            }
            this.setCreationDate((Long)var8_21);
            Float f = catalogPieceOfFurniture.getGrade();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                object = this.modifiedFurniture.get(i);
                if ((f != null || ((CatalogPieceOfFurniture)object).getGrade() == null) && (f == null || f.equals(((CatalogPieceOfFurniture)object).getGrade()))) continue;
                f = null;
                break;
            }
            this.setGrade(f);
            FurnitureCategory furnitureCategory2 = catalogPieceOfFurniture.getCategory();
            object = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, furnitureCategory2.getName());
            if (furnitureCategory2 != null) {
                for (n2 = 1; n2 < this.modifiedFurniture.size(); ++n2) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.modifiedFurniture.get(n2);
                    if (((String)object).equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, (String)object5, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, catalogPieceOfFurniture2.getCategory().getName()))) continue;
                    furnitureCategory2 = null;
                    break;
                }
            }
            this.setCategory(furnitureCategory2 == null ? null : new FurnitureCategory((String)object));
            Float f2 = Float.valueOf(catalogPieceOfFurniture.getWidth());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f2.floatValue() == this.modifiedFurniture.get(i).getWidth()) continue;
                f2 = null;
                break;
            }
            this.setWidth(f2);
            Float f3 = Float.valueOf(catalogPieceOfFurniture.getDepth());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f3.floatValue() == this.modifiedFurniture.get(i).getDepth()) continue;
                f3 = null;
                break;
            }
            this.setDepth(f3);
            Float f4 = Float.valueOf(catalogPieceOfFurniture.getHeight());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f4.floatValue() == this.modifiedFurniture.get(i).getHeight()) continue;
                f4 = null;
                break;
            }
            this.setHeight(f4);
            Float f5 = Float.valueOf(catalogPieceOfFurniture.getElevation());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f5.floatValue() == this.modifiedFurniture.get(i).getElevation()) continue;
                f5 = null;
                break;
            }
            this.setElevation(f5);
            Boolean bl = catalogPieceOfFurniture.isMovable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl.booleanValue() == this.modifiedFurniture.get(i).isMovable()) continue;
                bl = null;
                break;
            }
            this.setMovable(bl);
            Boolean bl2 = catalogPieceOfFurniture.isResizable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl2.booleanValue() == this.modifiedFurniture.get(i).isResizable()) continue;
                bl2 = null;
                break;
            }
            this.setResizable(bl2);
            Boolean bl3 = catalogPieceOfFurniture.isDeformable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl3.booleanValue() == this.modifiedFurniture.get(i).isDeformable()) continue;
                bl3 = null;
                break;
            }
            this.setDeformable(bl3);
            Boolean bl4 = catalogPieceOfFurniture.isTexturable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl4.booleanValue() == this.modifiedFurniture.get(i).isTexturable()) continue;
                bl4 = null;
                break;
            }
            this.setTexturable(bl4);
            Boolean bl5 = catalogPieceOfFurniture.isDoorOrWindow();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl5.booleanValue() == this.modifiedFurniture.get(i).isDoorOrWindow()) continue;
                bl5 = null;
                break;
            }
            this.setDoorOrWindow(bl5);
            String string3 = string = catalogPieceOfFurniture instanceof CatalogDoorOrWindow ? ((CatalogDoorOrWindow)catalogPieceOfFurniture).getCutOutShape() : null;
            if (string != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture3 = this.modifiedFurniture.get(i);
                    if (catalogPieceOfFurniture3 instanceof CatalogDoorOrWindow && string.equals(((CatalogDoorOrWindow)catalogPieceOfFurniture3).getCutOutShape())) continue;
                    string = null;
                    break;
                }
            }
            this.setDoorOrWindowCutOutShape(string);
            Boolean bl6 = catalogPieceOfFurniture.getStaircaseCutOutShape() != null;
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl6 == (this.modifiedFurniture.get(i).getStaircaseCutOutShape() != null)) continue;
                bl6 = null;
                break;
            }
            this.setStaircase(bl6);
            if (Boolean.TRUE.equals(bl6)) {
                String string4 = catalogPieceOfFurniture.getStaircaseCutOutShape();
                for (n = 1; n < this.modifiedFurniture.size(); ++n) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture4 = this.modifiedFurniture.get(n);
                    if ((string4 != null || catalogPieceOfFurniture4.getStaircaseCutOutShape() == null) && (string4 == null || string4.equals(catalogPieceOfFurniture4.getStaircaseCutOutShape()))) continue;
                    string4 = null;
                    break;
                }
                this.setStaircaseCutOutShape(string4);
            } else if (Boolean.FALSE.equals(bl6)) {
                this.setStaircaseCutOutShape(DEFAULT_CUT_OUT_SHAPE);
            } else {
                this.setStaircaseCutOutShape(null);
            }
            float[][] fArray = catalogPieceOfFurniture.getModelRotation();
            if (fArray != null) {
                for (n = 1; n < this.modifiedFurniture.size(); ++n) {
                    if (Arrays.deepEquals((Object[])fArray, (Object[])this.modifiedFurniture.get(n).getModelRotation())) continue;
                    fArray = null;
                    break;
                }
            }
            this.setModelRotation(fArray);
            Boolean bl7 = catalogPieceOfFurniture.isBackFaceShown();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl7.booleanValue() == this.modifiedFurniture.get(i).isBackFaceShown()) continue;
                bl7 = null;
                break;
            }
            this.setBackFaceShown(bl7);
            Boolean bl8 = (catalogPieceOfFurniture.getModelFlags() & 2) != 0;
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl8 == ((this.modifiedFurniture.get(i).getModelFlags() & 2) != 0)) continue;
                bl8 = null;
                break;
            }
            this.setEdgeColorMaterialHidden(bl8);
            String string5 = catalogPieceOfFurniture.getCreator();
            if (string5 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (string5.equals(this.modifiedFurniture.get(i).getCreator())) continue;
                    string5 = null;
                    break;
                }
            }
            this.setCreator(string5);
            String string6 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, (String)object5, FurnitureLibrary.FURNITURE_LICENSE_PROPERTY, catalogPieceOfFurniture.getLicense());
            if (string6 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    comparable = this.modifiedFurniture.get(i);
                    if (string6.equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)comparable, (String)object5, FurnitureLibrary.FURNITURE_LICENSE_PROPERTY, ((CatalogPieceOfFurniture)comparable).getLicense()))) continue;
                    string6 = null;
                    break;
                }
            }
            this.setLicense(string6);
            BigDecimal bigDecimal = catalogPieceOfFurniture.getPrice();
            if (bigDecimal != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (bigDecimal.equals(this.modifiedFurniture.get(i).getPrice())) continue;
                    bigDecimal = null;
                    break;
                }
            }
            this.setPrice(bigDecimal);
            comparable = catalogPieceOfFurniture.getValueAddedTaxPercentage();
            if (comparable != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (((BigDecimal)comparable).equals(this.modifiedFurniture.get(i).getValueAddedTaxPercentage())) continue;
                    comparable = null;
                    break;
                }
            }
            this.setValueAddedTaxPercentage((BigDecimal)comparable);
            if (this.editableProperties.contains((Object)Property.WIDTH) && this.editableProperties.contains((Object)Property.DEPTH) && this.editableProperties.contains((Object)Property.HEIGHT) && this.getWidth() != null && this.getDepth() != null && this.getHeight() != null) {
                this.editableProperties.add(Property.PROPORTIONAL);
            }
        }
    }

    public void setId(String string) {
        if (string != this.id) {
            String string2 = this.id;
            this.id = string;
            this.propertyChangeSupport.firePropertyChange(Property.ID.name(), string2, string);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        if (string != this.description) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setInformation(String string) {
        if (string != this.information) {
            String string2 = this.information;
            this.information = string;
            this.propertyChangeSupport.firePropertyChange(Property.INFORMATION.name(), string2, string);
        }
    }

    public String getInformation() {
        return this.information;
    }

    public void setTags(String[] stringArray) {
        if (stringArray != this.tags) {
            String[] stringArray2 = this.tags;
            this.tags = stringArray;
            this.propertyChangeSupport.firePropertyChange(Property.TAGS.name(), stringArray2, stringArray);
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setCreationDate(Long l) {
        if (l != this.creationDate) {
            Long l2 = this.creationDate;
            this.creationDate = l;
            this.propertyChangeSupport.firePropertyChange(Property.INFORMATION.name(), l2, l);
        }
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setGrade(Float f) {
        if (f != this.grade) {
            Float f2 = this.grade;
            this.grade = f;
            this.propertyChangeSupport.firePropertyChange(Property.GRADE.name(), f2, f);
        }
    }

    public Float getGrade() {
        return this.grade;
    }

    public void setCategory(FurnitureCategory furnitureCategory) {
        if (furnitureCategory != this.category) {
            FurnitureCategory furnitureCategory2 = this.category;
            this.category = furnitureCategory;
            this.propertyChangeSupport.firePropertyChange(Property.CATEGORY.name(), furnitureCategory2, furnitureCategory);
        }
    }

    public FurnitureCategory getCategory() {
        return this.category;
    }

    public List<FurnitureCategory> getAvailableCategories() {
        String string = this.furnitureLanguageController.getFurnitureLangauge();
        TreeSet<FurnitureCategory> treeSet = new TreeSet<FurnitureCategory>(this.getDefaultCategories(string));
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.furnitureLibrary.getFurniture()) {
            String string2 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, catalogPieceOfFurniture.getCategory().getName());
            treeSet.add(new FurnitureCategory(string2));
        }
        return new ArrayList<FurnitureCategory>(treeSet);
    }

    public List<FurnitureCategory> getDefaultCategories(String string) {
        int n = string.indexOf(95);
        Locale locale = n != -1 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string.length() == 0 ? this.preferences.getFurnitureDefaultLanguage() : string);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.eteks.furniturelibraryeditor.viewcontroller.DefaultCategories", locale);
        ArrayList<FurnitureCategory> arrayList = new ArrayList<FurnitureCategory>();
        int n2 = 1;
        try {
            while (true) {
                arrayList.add(new FurnitureCategory(resourceBundle.getString("defaultFurnitureCategory#" + n2++)));
            }
        }
        catch (MissingResourceException missingResourceException) {
            return arrayList;
        }
    }

    public void setIcon(Content content) {
        if (content != this.icon) {
            Content content2 = this.icon;
            this.icon = content;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), content2, content);
        }
    }

    public Content getIcon() {
        return this.icon;
    }

    public void setModel(Content content) {
        if (content != this.model) {
            Content content2 = this.model;
            this.model = content;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL.name(), content2, content);
        }
    }

    public Content getModel() {
        return this.model;
    }

    private void setModelSize(Long l) {
        if (l != this.modelSize) {
            Long l2 = this.modelSize;
            this.modelSize = l;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_SIZE.name(), l2, l);
        }
    }

    public Long getModelSize() {
        return this.modelSize;
    }

    public void setModel(String string) {
        final FurnitureLibrary furnitureLibrary = new FurnitureLibrary();
        Runnable runnable = new Runnable(){

            public void run() {
                List<CatalogPieceOfFurniture> list = furnitureLibrary.getFurniture();
                if (!list.isEmpty()) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = list.get(0);
                    FurnitureController.this.setModel(catalogPieceOfFurniture.getModel());
                    FurnitureController.this.setModelRotation(catalogPieceOfFurniture.getModelRotation());
                    FurnitureController.this.setModelSize(catalogPieceOfFurniture.getModelSize());
                    boolean bl = FurnitureController.this.isProportional();
                    FurnitureController.this.setProportional(false);
                    FurnitureController.this.setWidth(Float.valueOf(catalogPieceOfFurniture.getWidth()));
                    FurnitureController.this.setDepth(Float.valueOf(catalogPieceOfFurniture.getDepth()));
                    FurnitureController.this.setHeight(Float.valueOf(catalogPieceOfFurniture.getHeight()));
                    FurnitureController.this.setProportional(bl);
                }
            }
        };
        new ImportFurnitureController(furnitureLibrary, new String[]{string}, runnable, this.preferences, this.viewFactory, this.contentManager).executeTask(this.getView());
    }

    public void setWidth(Float f) {
        this.setWidth(f, false);
    }

    private void setWidth(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 == null && this.width != null || f2 != null && !f2.equals(this.width)) {
            Float f4 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), f4, f2);
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public void setDepth(Float f) {
        this.setDepth(f, false);
    }

    private void setDepth(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 == null && this.depth != null || f2 != null && !f2.equals(this.depth)) {
            Float f4 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), f4, f2);
        }
    }

    public Float getDepth() {
        return this.depth;
    }

    public void setHeight(Float f) {
        this.setHeight(f, false);
    }

    private void setHeight(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 == null && this.height != null || f2 != null && !f2.equals(this.height)) {
            Float f4 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f4, f2);
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), !bl, bl);
        }
    }

    public void multiplySize(float f) {
        if (this.isProportional()) {
            this.setWidth(Float.valueOf(this.getWidth().floatValue() * f));
        } else {
            this.setProportional(true);
            this.setWidth(Float.valueOf(this.getWidth().floatValue() * f));
            this.setProportional(false);
        }
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setMovable(Boolean bl) {
        if (bl != this.movable) {
            Boolean bl2 = this.movable;
            this.movable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MOVABLE.name(), bl2, bl);
        }
    }

    public Boolean getMovable() {
        return this.movable;
    }

    public void setDoorOrWindow(Boolean bl) {
        if (bl != this.doorOrWindow) {
            Boolean bl2 = this.doorOrWindow;
            this.doorOrWindow = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DOOR_OR_WINDOW.name(), bl2, bl);
        }
    }

    public Boolean getDoorOrWindow() {
        return this.doorOrWindow;
    }

    public void setDoorOrWindowCutOutShape(String string) {
        if (string != this.doorOrWindowCutOutShape || string != null && !string.equals(this.doorOrWindowCutOutShape)) {
            String string2 = this.doorOrWindowCutOutShape;
            this.doorOrWindowCutOutShape = string;
            this.propertyChangeSupport.firePropertyChange(Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE.name(), string2, string);
        }
    }

    public String getDoorOrWindowCutOutShape() {
        return this.doorOrWindowCutOutShape;
    }

    public void setStaircase(Boolean bl) {
        if (bl != this.staircase) {
            Boolean bl2 = this.staircase;
            this.staircase = bl;
            this.propertyChangeSupport.firePropertyChange(Property.STAIRCASE.name(), bl2, bl);
        }
    }

    public Boolean getStaircase() {
        return this.staircase;
    }

    public void setStaircaseCutOutShape(String string) {
        if (string != this.staircaseCutOutShape || string != null && !string.equals(this.staircaseCutOutShape)) {
            String string2 = this.staircaseCutOutShape;
            this.staircaseCutOutShape = string;
            this.propertyChangeSupport.firePropertyChange(Property.STAIRCASE_CUT_OUT_SHAPE.name(), string2, string);
        }
    }

    public String getStaircaseCutOutShape() {
        return this.staircaseCutOutShape;
    }

    public void setResizable(Boolean bl) {
        if (bl != this.resizable) {
            Boolean bl2 = this.resizable;
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), bl2, bl);
        }
    }

    public Boolean getResizable() {
        return this.resizable;
    }

    public void setDeformable(Boolean bl) {
        if (bl != this.deformable) {
            Boolean bl2 = this.deformable;
            this.deformable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DEFORMABLE.name(), bl2, bl);
        }
    }

    public Boolean getDeformable() {
        return this.deformable;
    }

    public void setTexturable(Boolean bl) {
        if (bl != this.texturable) {
            Boolean bl2 = this.texturable;
            this.texturable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURABLE.name(), bl2, bl);
        }
    }

    public Boolean getTexturable() {
        return this.texturable;
    }

    public void setModelRotation(float[][] fArray) {
        if (fArray != this.modelRotation) {
            float[][] fArray2 = this.modelRotation;
            this.modelRotation = fArray;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_ROTATION.name(), fArray2, fArray);
        }
    }

    public float[][] getModelRotation() {
        return this.modelRotation;
    }

    public void setBackFaceShown(Boolean bl) {
        if (bl != this.backFaceShown) {
            Boolean bl2 = this.backFaceShown;
            this.backFaceShown = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BACK_FACE_SHOWN.name(), bl2, bl);
        }
    }

    public Boolean getBackFaceShown() {
        return this.backFaceShown;
    }

    public void setEdgeColorMaterialHidden(Boolean bl) {
        if (bl != this.edgeColorMaterialHidden) {
            Boolean bl2 = this.edgeColorMaterialHidden;
            this.edgeColorMaterialHidden = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDGE_COLOR_MATERIAL_HIDDEN.name(), bl2, bl);
        }
    }

    public Boolean getEdgeColorMaterialHidden() {
        return this.edgeColorMaterialHidden;
    }

    public void setCreator(String string) {
        if (string != this.creator) {
            String string2 = this.creator;
            this.creator = string;
            this.propertyChangeSupport.firePropertyChange(Property.CREATOR.name(), string2, string);
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setLicense(String string) {
        if (string != this.license) {
            String string2 = this.license;
            this.license = string;
            this.propertyChangeSupport.firePropertyChange(Property.LICENSE.name(), string2, string);
        }
    }

    public String getLicense() {
        return this.license;
    }

    public void setPrice(BigDecimal bigDecimal) {
        if (bigDecimal != this.price) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setValueAddedTaxPercentage(BigDecimal bigDecimal) {
        if (bigDecimal != this.valueAddedTaxPercentage) {
            BigDecimal bigDecimal2 = this.valueAddedTaxPercentage;
            this.valueAddedTaxPercentage = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.VALUE_ADDED_TAX_PERCENTAGE.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getValueAddedTaxPercentage() {
        return this.valueAddedTaxPercentage;
    }

    public void setAdditionalProperties(Map<FurnitureProperty, Object> map) {
        if (!(map == this.additionalProperties || map != null && map.equals(this.additionalProperties))) {
            Map<FurnitureProperty, Object> map2 = this.additionalProperties;
            this.additionalProperties = new LinkedHashMap<FurnitureProperty, Object>(map);
            this.propertyChangeSupport.firePropertyChange(Property.ADDITIONAL_PROPERTIES.name(), map2, map);
        }
    }

    public Map<FurnitureProperty, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /*
     * WARNING - void declaration
     */
    public void modifyFurniture() {
        if (!this.modifiedFurniture.isEmpty()) {
            String string = this.getId();
            String string2 = this.getName();
            String string3 = this.getDescription();
            String string4 = this.getInformation();
            String[] stringArray = this.getTags();
            Long l = this.getCreationDate();
            Float f = this.getGrade();
            FurnitureCategory furnitureCategory = this.getCategory();
            Content content = this.getModel();
            Content content2 = this.getIcon();
            Float f2 = this.getWidth();
            Float f3 = this.getDepth();
            Float f4 = this.getHeight();
            Float f5 = this.getElevation();
            Boolean bl = this.getMovable();
            Boolean bl2 = this.getResizable();
            Boolean bl3 = this.getDeformable();
            Boolean bl4 = this.getTexturable();
            Boolean bl5 = this.getDoorOrWindow();
            String string5 = this.getDoorOrWindowCutOutShape();
            Boolean bl6 = this.getStaircase();
            String string6 = this.getStaircaseCutOutShape();
            float[][] fArray = this.getModelRotation();
            Boolean bl7 = this.getBackFaceShown();
            Boolean bl8 = this.getEdgeColorMaterialHidden();
            Long l2 = this.getModelSize();
            String string7 = this.getCreator();
            String string8 = this.getLicense();
            BigDecimal bigDecimal = this.getPrice();
            BigDecimal bigDecimal2 = this.getValueAddedTaxPercentage();
            HashMap<FurnitureProperty, Object> hashMap = new HashMap<FurnitureProperty, Object>(this.getAdditionalProperties());
            boolean bl9 = "".equals(this.furnitureLanguageController.getFurnitureLangauge());
            int n = this.modifiedFurniture.size();
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.modifiedFurniture) {
                Object object;
                String[] stringArray2;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                String[] stringArray3;
                String[] stringArray4;
                String[] stringArray5;
                String[] stringArray6;
                Object[] objectArray;
                String string9;
                Content content3;
                HashMap<String, Content> hashMap2;
                HashMap<String, String> hashMap3;
                int n3 = this.furnitureLibrary.getPieceOfFurnitureIndex(catalogPieceOfFurniture);
                String string10 = catalogPieceOfFurniture.getId();
                String string11 = catalogPieceOfFurniture.getName();
                String string12 = catalogPieceOfFurniture.getDescription();
                String string13 = catalogPieceOfFurniture.getInformation();
                String[] stringArray7 = catalogPieceOfFurniture.getTags();
                Long l3 = catalogPieceOfFurniture.getCreationDate();
                Float f6 = catalogPieceOfFurniture.getGrade();
                FurnitureCategory furnitureCategory2 = catalogPieceOfFurniture.getCategory();
                Content content4 = catalogPieceOfFurniture.getModel();
                Content content5 = catalogPieceOfFurniture.getIcon();
                float f7 = catalogPieceOfFurniture.getWidth();
                float f8 = catalogPieceOfFurniture.getDepth();
                float f9 = catalogPieceOfFurniture.getHeight();
                float f10 = catalogPieceOfFurniture.getElevation();
                boolean bl10 = catalogPieceOfFurniture.isMovable();
                float[][] fArray2 = catalogPieceOfFurniture.getModelRotation();
                int n4 = catalogPieceOfFurniture.getModelFlags();
                String string14 = catalogPieceOfFurniture instanceof CatalogDoorOrWindow ? ((CatalogDoorOrWindow)catalogPieceOfFurniture).getCutOutShape() : null;
                String string15 = catalogPieceOfFurniture.getStaircaseCutOutShape();
                Long l4 = catalogPieceOfFurniture.getModelSize();
                String string16 = catalogPieceOfFurniture.getCreator();
                String string17 = catalogPieceOfFurniture.getLicense();
                boolean bl11 = catalogPieceOfFurniture.isResizable();
                boolean bl12 = catalogPieceOfFurniture.isDeformable();
                boolean bl13 = catalogPieceOfFurniture.isTexturable();
                BigDecimal bigDecimal3 = catalogPieceOfFurniture.getPrice();
                BigDecimal bigDecimal4 = catalogPieceOfFurniture.getValueAddedTaxPercentage();
                Collection<String> collection = catalogPieceOfFurniture.getPropertyNames();
                if (collection.isEmpty()) {
                    hashMap3 = new HashMap<String, String>();
                } else {
                    hashMap3 = new HashMap(collection.size());
                    for (String string18 : collection) {
                        if (catalogPieceOfFurniture.isContentProperty(string18)) continue;
                        hashMap3.put(string18, catalogPieceOfFurniture.getProperty(string18));
                    }
                }
                if (collection.isEmpty()) {
                    hashMap2 = new HashMap();
                } else {
                    hashMap2 = new HashMap<String, Content>(collection.size() - hashMap3.size());
                    for (String string19 : collection) {
                        if (!catalogPieceOfFurniture.isContentProperty(string19)) continue;
                        hashMap2.put(string19, catalogPieceOfFurniture.getContentProperty(string19));
                    }
                }
                HashMap<String, Object> object82 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, object82, FurnitureLibrary.FURNITURE_NAME_PROPERTY);
                HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap4, FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY);
                HashMap<String, Object> hashMap5 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap5, FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY);
                HashMap<String, Object> hashMap6 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap6, FurnitureLibrary.FURNITURE_TAGS_PROPERTY);
                HashMap<String, Object> hashMap7 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap7, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY);
                HashMap<String, Object> hashMap8 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap8, FurnitureLibrary.FURNITURE_LICENSE_PROPERTY);
                if (content != null) {
                    content4 = content;
                }
                if (f2 != null) {
                    f7 = f2.floatValue();
                }
                if (f3 != null) {
                    f8 = f3.floatValue();
                }
                if (f4 != null) {
                    f9 = f4.floatValue();
                }
                if (bl != null) {
                    bl10 = bl;
                }
                if (string != null || n == 1) {
                    string10 = string;
                }
                if (l != null || n == 1) {
                    l3 = l;
                }
                if (f != null || n == 1) {
                    f6 = f;
                }
                if (f5 != null || n == 1) {
                    f10 = f5.floatValue();
                }
                if (fArray != null || n == 1) {
                    fArray2 = fArray;
                }
                if (bl7 != null) {
                    n4 = n4 & 0xFFFFFFFE | (bl7 != false ? 1 : 0);
                }
                if (bl8 != null) {
                    n4 = n4 & 0xFFFFFFFD | (bl8 != false ? 2 : 0);
                }
                if (string14 != null || n == 1) {
                    string14 = string5;
                }
                if (bl6 != null) {
                    if (bl6.booleanValue()) {
                        if (string6 != null) {
                            string15 = string6;
                        } else if (n == 1) {
                            string15 = DEFAULT_CUT_OUT_SHAPE;
                        }
                    } else {
                        string15 = null;
                    }
                } else if (string6 != null && string15 != null) {
                    string15 = string6;
                }
                if (l2 != null || n == 1) {
                    l4 = l2;
                }
                if (string7 != null || n == 1) {
                    string16 = string7;
                }
                if (bl2 != null || n == 1) {
                    bl11 = bl2;
                }
                if (bl3 != null || n == 1) {
                    bl12 = bl3;
                }
                if (bl4 != null || n == 1) {
                    bl13 = bl4;
                }
                if (bigDecimal != null || n == 1) {
                    bigDecimal3 = bigDecimal;
                }
                if (bigDecimal2 != null || n == 1) {
                    bigDecimal4 = bigDecimal2;
                }
                if (string2 != null) {
                    if (bl9) {
                        string11 = string2;
                    } else {
                        object82.put(this.furnitureLanguageController.getFurnitureLangauge(), string2);
                    }
                }
                if (furnitureCategory != null) {
                    if (bl9) {
                        furnitureCategory2 = furnitureCategory;
                    } else {
                        hashMap7.put(this.furnitureLanguageController.getFurnitureLangauge(), furnitureCategory.getName());
                    }
                }
                if (string3 != null || n == 1) {
                    if (bl9) {
                        string12 = string3;
                    } else {
                        hashMap4.put(this.furnitureLanguageController.getFurnitureLangauge(), string3);
                    }
                }
                if (string4 != null || n == 1) {
                    if (bl9) {
                        string13 = string4;
                    } else {
                        hashMap5.put(this.furnitureLanguageController.getFurnitureLangauge(), string4);
                    }
                }
                if (stringArray != null || n == 1) {
                    if (bl9) {
                        stringArray7 = stringArray == null ? new String[]{} : stringArray;
                    } else {
                        hashMap6.put(this.furnitureLanguageController.getFurnitureLangauge(), stringArray);
                    }
                }
                if (string8 != null || n == 1) {
                    if (bl9) {
                        string17 = string8;
                    } else {
                        hashMap8.put(this.furnitureLanguageController.getFurnitureLangauge(), string8);
                    }
                }
                if ((content3 = (Content)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.ICON.getKeyPrefix()))) != null) {
                    content5 = content3;
                } else if (content2 != null) {
                    content5 = content2;
                }
                Content content6 = (Content)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.PLAN_ICON.getKeyPrefix()));
                Content content7 = content6 != null ? content6 : catalogPieceOfFurniture.getPlanIcon();
                Format format = this.preferences.getLengthUnit().getFormat();
                float f11 = catalogPieceOfFurniture.getDropOnTopElevation();
                String string20 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION.getKeyPrefix()));
                if (string20 != null) {
                    try {
                        f11 = ((Number)format.parseObject(string20)).floatValue() / f9;
                    }
                    catch (ParseException parseException) {
                        throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DROP_ON_TOP_ELEVATION.getKeyPrefix() + " : Invalid distance in " + this.preferences.getLengthUnit().getName(), parseException);
                    }
                }
                boolean bl14 = catalogPieceOfFurniture.isHorizontallyRotatable();
                String string21 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.HORIZONTALLY_ROTATABLE.getKeyPrefix()));
                if (string21 != null) {
                    bl14 = Boolean.parseBoolean(string21);
                }
                String string22 = catalogPieceOfFurniture.getCurrency();
                String string23 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.CURRENCY.getKeyPrefix()));
                if (string23 != null) {
                    try {
                        Currency.getInstance(string23);
                        string22 = string23;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.CURRENCY.getKeyPrefix() + " : Invalid currency code", illegalArgumentException);
                    }
                }
                String string24 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS.getKeyPrefix()));
                String string25 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE.getKeyPrefix()));
                String string26 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES.getKeyPrefix()));
                String string27 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE.getKeyPrefix()));
                String string28 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS.getKeyPrefix()));
                String string29 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKeyPrefix()));
                String string30 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKeyPrefix()));
                String string31 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKeyPrefix()));
                String string32 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKeyPrefix()));
                float f12 = 0.0f;
                float f13 = 0.0f;
                boolean bl15 = true;
                boolean bl16 = false;
                Sash[] sashArray = new Sash[]{};
                boolean bl17 = this.preferences.getLengthUnit() == LengthUnit.INCH || this.preferences.getLengthUnit() == LengthUnit.INCH_FRACTION;
                String string33 = string9 = bl17 ? "\" +" : " +";
                if (bl5 != null && bl5.booleanValue()) {
                    if (string24 != null) {
                        try {
                            f12 = ((Number)format.parseObject(string24)).floatValue() / f3.floatValue();
                        }
                        catch (ParseException parseException) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS.getKeyPrefix() + " : Invalid distance in " + this.preferences.getLengthUnit().getName(), parseException);
                        }
                    }
                    if (string25 != null) {
                        try {
                            f13 = ((Number)format.parseObject(string25)).floatValue() / f3.floatValue();
                        }
                        catch (ParseException parseException) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE.getKeyPrefix() + " : Invalid distance in " + this.preferences.getLengthUnit().getName(), parseException);
                        }
                    }
                    if (string26 != null) {
                        bl15 = Boolean.parseBoolean(string26);
                    } else if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow) {
                        bl15 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).isWallCutOutOnBothSides();
                    }
                    if (string27 != null) {
                        bl16 = Boolean.parseBoolean(string27);
                    } else if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow) {
                        bl16 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).isWidthDepthDeformable();
                    }
                    if (string28 != null) {
                        objectArray = string28.split(string9);
                        if (string29 == null || (stringArray6 = string29.split(string9)).length != objectArray.length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKeyPrefix() + " : Expected " + objectArray.length + " values");
                        }
                        if (string30 == null || (stringArray5 = string30.split(string9)).length != objectArray.length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKeyPrefix() + " : Expected " + objectArray.length + " values");
                        }
                        if (string31 == null || (stringArray4 = string31.split(" ")).length != objectArray.length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKeyPrefix() + " : Expected " + objectArray.length + " values");
                        }
                        if (string32 == null || (stringArray3 = string32.split(" ")).length != objectArray.length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKeyPrefix() + " : Expected " + objectArray.length + " values");
                        }
                        sashArray = new Sash[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            try {
                                object6 = Float.valueOf(((Number)format.parseObject((String)objectArray[i] + (bl17 ? "\"" : ""))).floatValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                object5 = Float.valueOf(((Number)format.parseObject(stringArray6[i] + (bl17 ? "\"" : ""))).floatValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                object4 = Float.valueOf(((Number)format.parseObject(stringArray5[i] + (bl17 ? "\"" : ""))).floatValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                object3 = Float.valueOf(NumberFormat.getNumberInstance().parse(stringArray4[i]).floatValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKeyPrefix() + " : Invalid list of decimal numbers in \u00b0", parseException);
                            }
                            try {
                                object2 = Float.valueOf(NumberFormat.getNumberInstance().parse(stringArray3[i]).floatValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKeyPrefix() + " : Invalid list of decimal numbers in \u00b0", parseException);
                            }
                            sashArray[i] = new Sash(((Float)object6).floatValue() / f7, ((Float)object5).floatValue() / f8, ((Float)object4).floatValue() / f7, (float)Math.toRadians(((Float)object3).floatValue()), (float)Math.toRadians(((Float)object2).floatValue()));
                        }
                    } else if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow) {
                        sashArray = ((CatalogDoorOrWindow)catalogPieceOfFurniture).getSashes();
                    }
                } else if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow) {
                    f12 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).getWallThickness();
                    f13 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).getWallDistance();
                    bl15 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).isWallCutOutOnBothSides();
                    bl16 = ((CatalogDoorOrWindow)catalogPieceOfFurniture).isWidthDepthDeformable();
                    sashArray = ((CatalogDoorOrWindow)catalogPieceOfFurniture).getSashes();
                }
                objectArray = null;
                stringArray6 = null;
                stringArray5 = (String[])hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_X.getKeyPrefix()));
                stringArray4 = (String[])hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y.getKeyPrefix()));
                stringArray3 = (String[])hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z.getKeyPrefix()));
                String string34 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR.getKeyPrefix()));
                object6 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER.getKeyPrefix()));
                object5 = (String)hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_MATERIAL_NAME.getKeyPrefix()));
                if (bl5 != null && !bl5.booleanValue()) {
                    if (stringArray5 != null) {
                        void var112_130;
                        object4 = stringArray5.split(string9);
                        if (stringArray4 == null || ((String[])(object3 = stringArray4.split(string9))).length != ((String[])object4).length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y.getKeyPrefix() + " : Expected " + ((String[])object4).length + " values");
                        }
                        if (stringArray3 == null || ((String[])(object2 = stringArray3.split(string9))).length != ((String[])object4).length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z.getKeyPrefix() + " : Expected " + ((String[])object4).length + " values");
                        }
                        if (string34 == null || (stringArray2 = string34.split(" ")).length != ((String[])object4).length) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR.getKeyPrefix() + " : Expected " + ((String[])object4).length + " values");
                        }
                        if (object6 != null) {
                            object = ((String)object6).split(string9);
                            if (((String[])object).length != ((String[])object4).length) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER.getKeyPrefix() + " : Expected " + ((String[])object4).length + " values");
                            }
                        } else {
                            object = null;
                        }
                        objectArray = new LightSource[((String[])object4).length];
                        boolean bl18 = false;
                        while (var112_130 < ((String[])object4).length) {
                            int n2;
                            float f14;
                            float f15;
                            float f16;
                            try {
                                f16 = ((Number)format.parseObject(object4[var112_130] + (bl17 ? "\"" : ""))).floatValue();
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_X.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                f15 = ((Number)format.parseObject((String)object3[var112_130] + (bl17 ? "\"" : ""))).floatValue();
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Y.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                f14 = ((Number)format.parseObject(object2[var112_130] + (bl17 ? "\"" : ""))).floatValue();
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_Z.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            try {
                                n2 = stringArray2[var112_130].startsWith("#") ? Integer.parseInt(stringArray2[var112_130].substring(1), 16) : Integer.parseInt(stringArray2[var112_130]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_COLOR.getKeyPrefix() + " : Invalid list of color integers", numberFormatException);
                            }
                            float f17 = 0.0f;
                            try {
                                if (object != null) {
                                    f17 = ((Number)format.parseObject(object[var112_130] + (bl17 ? "\"" : ""))).floatValue();
                                }
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.LIGHT_SOURCE_DIAMETER.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            objectArray[var112_130] = new LightSource(f16 / f7, f15 / f8, f14 / f9, n2, object != null ? Float.valueOf(f17 / f7) : null);
                            ++var112_130;
                        }
                    } else if (catalogPieceOfFurniture instanceof CatalogLight) {
                        objectArray = ((CatalogLight)catalogPieceOfFurniture).getLightSources();
                    }
                    if (object5 != null) {
                        stringArray6 = object5 != null ? ((String)object5).split(" ") : null;
                    } else if (catalogPieceOfFurniture instanceof CatalogLight) {
                        stringArray6 = ((CatalogLight)catalogPieceOfFurniture).getLightSourceMaterialNames();
                    }
                } else if (catalogPieceOfFurniture instanceof CatalogLight) {
                    objectArray = ((CatalogLight)catalogPieceOfFurniture).getLightSources();
                    stringArray6 = ((CatalogLight)catalogPieceOfFurniture).getLightSourceMaterialNames();
                }
                object4 = null;
                object3 = null;
                object2 = (String[])hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.SHELF_ELEVATIONS.getKeyPrefix()));
                stringArray2 = (String[])hashMap.remove(new FurnitureProperty(DefaultFurnitureCatalog.PropertyKey.SHELF_BOXES.getKeyPrefix()));
                if (bl5 != null && !bl5.booleanValue()) {
                    if (object2 != null) {
                        void var112_132;
                        object = ((String)object2).split(string9);
                        object4 = new float[((String[])object).length];
                        boolean bl19 = false;
                        while (var112_132 < ((String[])object4).length) {
                            try {
                                object4[var112_132] = (String)(((Number)format.parseObject(object[var112_132] + (bl17 ? "\"" : ""))).floatValue() / f9);
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.SHELF_ELEVATIONS.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            ++var112_132;
                        }
                    } else if (catalogPieceOfFurniture instanceof CatalogShelfUnit) {
                        object4 = ((CatalogShelfUnit)catalogPieceOfFurniture).getShelfElevations();
                    }
                    if (stringArray2 != null) {
                        void var112_134;
                        object = stringArray2.split(string9);
                        if (((String[])object).length % 6 != 0) {
                            throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.SHELF_BOXES.getKeyPrefix() + " : Expected multiple of 6 values");
                        }
                        object3 = new BoxBounds[((String[])object).length / 6];
                        boolean bl20 = false;
                        while (var112_134 < ((Object[])object3).length) {
                            try {
                                object3[var112_134] = new BoxBounds(((Number)format.parseObject(object[var112_134 * 6] + (bl17 ? "\"" : ""))).floatValue() / f7, ((Number)format.parseObject(object[var112_134 * 6 + true] + (bl17 ? "\"" : ""))).floatValue() / f8, ((Number)format.parseObject(object[var112_134 * 6 + 2] + (bl17 ? "\"" : ""))).floatValue() / f9, ((Number)format.parseObject(object[var112_134 * 6 + 3] + (bl17 ? "\"" : ""))).floatValue() / f7, ((Number)format.parseObject(object[var112_134 * 6 + 4] + (bl17 ? "\"" : ""))).floatValue() / f8, ((Number)format.parseObject(object[var112_134 * 6 + 5] + (bl17 ? "\"" : ""))).floatValue() / f9);
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(DefaultFurnitureCatalog.PropertyKey.SHELF_BOXES.getKeyPrefix() + " : Invalid list of distances in " + this.preferences.getLengthUnit().getName(), parseException);
                            }
                            ++var112_134;
                        }
                    } else if (catalogPieceOfFurniture instanceof CatalogShelfUnit) {
                        object3 = ((CatalogShelfUnit)catalogPieceOfFurniture).getShelfBoxes();
                    }
                } else if (catalogPieceOfFurniture instanceof CatalogShelfUnit) {
                    object4 = ((CatalogShelfUnit)catalogPieceOfFurniture).getShelfElevations();
                    object3 = ((CatalogShelfUnit)catalogPieceOfFurniture).getShelfBoxes();
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (entry.getValue() != null) {
                        ObjectProperty.Type type = ((FurnitureProperty)entry.getKey()).getType();
                        if (type == ObjectProperty.Type.NUMBER) {
                            float f18;
                            try {
                                f18 = NumberFormat.getNumberInstance().parse((String)entry.getValue()).floatValue();
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(((FurnitureProperty)entry.getKey()).getName() + " : Invalid number", parseException);
                            }
                            hashMap3.put(((FurnitureProperty)entry.getKey()).getName(), String.valueOf(f18));
                            continue;
                        }
                        if (type == ObjectProperty.Type.LENGTH) {
                            float f19;
                            try {
                                f19 = ((Number)this.preferences.getLengthUnit().getFormat().parseObject((String)entry.getValue())).floatValue();
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(((FurnitureProperty)entry.getKey()).getName() + " : Invalid length", parseException);
                            }
                            hashMap3.put(((FurnitureProperty)entry.getKey()).getName(), String.valueOf(f19));
                            continue;
                        }
                        if (type == ObjectProperty.Type.DATE) {
                            Date date;
                            try {
                                date = DateFormat.getDateInstance(3).parse((String)entry.getValue());
                            }
                            catch (ParseException parseException) {
                                throw new IllegalStateException(((FurnitureProperty)entry.getKey()).getName() + " : Invalid date", parseException);
                            }
                            hashMap3.put(((FurnitureProperty)entry.getKey()).getName(), new SimpleDateFormat("yyyy-MM-dd").format(date));
                            continue;
                        }
                        if (type == ObjectProperty.Type.CONTENT) {
                            hashMap2.put(((FurnitureProperty)entry.getKey()).getName(), (Content)entry.getValue());
                            continue;
                        }
                        hashMap3.put(((FurnitureProperty)entry.getKey()).getName(), (String)entry.getValue());
                        continue;
                    }
                    hashMap3.put(((FurnitureProperty)entry.getKey()).getName(), (String)entry.getValue());
                }
                object = catalogPieceOfFurniture instanceof CatalogDoorOrWindow && (bl5 == null || bl5 != false) || bl5 != null && bl5 != false ? new CatalogDoorOrWindow(string10, string11, string12, string13, string17, stringArray7, l3, f6, content5, content7, content4, f7, f8, f9, f10, f11, bl10, string14, f12, f13, bl15, bl16, sashArray, fArray2, n4, l4, string16, bl11, bl12, bl13, bigDecimal3, bigDecimal4, string22, hashMap3, hashMap2) : (catalogPieceOfFurniture instanceof CatalogLight || objectArray != null || stringArray6 != null ? new CatalogLight(string10, string11, string12, string13, string17, stringArray7, l3, f6, content5, content7, content4, f7, f8, f9, f10, f11, bl10, (LightSource[])objectArray, stringArray6, string15, fArray2, n4, l4, string16, bl11, bl12, bl13, bl14, bigDecimal3, bigDecimal4, string22, hashMap3, hashMap2) : (catalogPieceOfFurniture instanceof CatalogShelfUnit || object4 != null || object3 != null ? new CatalogShelfUnit(string10, string11, string12, string13, string17, stringArray7, l3, f6, content5, content7, content4, f7, f8, f9, f10, f11, (float[])object4, (BoxBounds[])object3, bl10, string15, fArray2, n4, l4, string16, bl11, bl12, bl13, bl14, bigDecimal3, bigDecimal4, string22, hashMap3, hashMap2) : new CatalogPieceOfFurniture(string10, string11, string12, string13, string17, stringArray7, l3, f6, content5, content7, content4, f7, f8, f9, f10, f11, bl10, string15, fArray2, n4, l4, string16, bl11, bl12, bl13, bl14, bigDecimal3, bigDecimal4, string22, hashMap3, hashMap2)));
                new FurnitureCatalog().add(furnitureCategory2, (CatalogPieceOfFurniture)object);
                this.furnitureLibrary.addPieceOfFurniture((CatalogPieceOfFurniture)object, n3);
                HashSet<String> hashSet = new HashSet<String>(this.furnitureLibrary.getSupportedLanguages());
                hashSet.add(this.furnitureLanguageController.getFurnitureLangauge());
                for (String string35 : hashSet) {
                    Object v;
                    Object v2;
                    Object v3;
                    Object v4;
                    Object v5;
                    if ("".equals(string35)) continue;
                    Object v6 = object82.get(string35);
                    if (v6 != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_NAME_PROPERTY, v6);
                    }
                    if ((v5 = hashMap4.get(string35)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_DESCRIPTION_PROPERTY, v5);
                    }
                    if ((v4 = hashMap5.get(string35)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_INFORMATION_PROPERTY, v4);
                    }
                    if ((v3 = hashMap6.get(string35)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_TAGS_PROPERTY, v3);
                    }
                    if ((v2 = hashMap7.get(string35)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, v2);
                    }
                    if ((v = hashMap8.get(string35)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, FurnitureLibrary.FURNITURE_LICENSE_PROPERTY, v);
                    }
                    for (String string36 : catalogPieceOfFurniture.getPropertyNames()) {
                        Object object7 = this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string35, string36);
                        if (object7 == null) continue;
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object, string35, string36, object7);
                    }
                }
                this.furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
            }
        }
    }

    private void retrieveLocalizedData(CatalogPieceOfFurniture catalogPieceOfFurniture, Map<String, Object> map, String string) {
        for (String string2 : this.furnitureLibrary.getSupportedLanguages()) {
            Object object = this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string2, string);
            if (object == null) continue;
            map.put(string2, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ID,
        NAME,
        DESCRIPTION,
        INFORMATION,
        TAGS,
        GRADE,
        CREATION_DATE,
        CATEGORY,
        MODEL,
        ICON,
        WIDTH,
        DEPTH,
        HEIGHT,
        ELEVATION,
        MOVABLE,
        RESIZABLE,
        DEFORMABLE,
        TEXTURABLE,
        DOOR_OR_WINDOW,
        DOOR_OR_WINDOW_CUT_OUT_SHAPE,
        STAIRCASE,
        STAIRCASE_CUT_OUT_SHAPE,
        MODEL_ROTATION,
        MODEL_SIZE,
        CREATOR,
        LICENSE,
        PROPORTIONAL,
        BACK_FACE_SHOWN,
        EDGE_COLOR_MATERIAL_HIDDEN,
        PRICE,
        VALUE_ADDED_TAX_PERCENTAGE,
        ADDITIONAL_PROPERTIES;

    }
}

