/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureController;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureController;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureLibraryController
implements Controller {
    private final FurnitureLibrary furnitureLibrary;
    private final FurnitureLibraryUserPreferences preferences;
    private final ContentManager contentManager;
    private final EditorViewFactory viewFactory;
    private final List<SelectionListener> selectionListeners;
    private FurnitureLanguageController furnitureLanguageController;
    private List<CatalogPieceOfFurniture> selectedFurniture;
    private View view;

    public FurnitureLibraryController(final FurnitureLibrary furnitureLibrary, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController, EditorViewFactory editorViewFactory, ContentManager contentManager) {
        this.furnitureLibrary = furnitureLibrary;
        this.preferences = furnitureLibraryUserPreferences;
        this.viewFactory = editorViewFactory;
        this.contentManager = contentManager;
        this.furnitureLanguageController = furnitureLanguageController;
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.selectedFurniture = Collections.emptyList();
        this.furnitureLibrary.addListener(new CollectionListener<CatalogPieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    FurnitureLibraryController.this.deselectPieceOfFurniture(collectionEvent.getItem());
                }
                furnitureLibrary.setModified(true);
            }
        });
        this.furnitureLanguageController.addPropertyChangeListener(FurnitureLanguageController.Property.FURNITURE_LANGUAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getOldValue() != null) {
                    FurnitureLibraryController.this.translateFurnitureCategories((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    @Override
    public View getView() {
        if (this.view == null) {
            this.view = this.viewFactory.createFurnitureLibraryView(this.furnitureLibrary, this.preferences, this, this.furnitureLanguageController);
        }
        return this.view;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public List<CatalogPieceOfFurniture> getSelectedFurniture() {
        return Collections.unmodifiableList(this.selectedFurniture);
    }

    public void setSelectedFurniture(List<CatalogPieceOfFurniture> list) {
        this.selectedFurniture = new ArrayList<CatalogPieceOfFurniture>(list);
        if (!this.selectionListeners.isEmpty()) {
            SelectionListener[] selectionListenerArray;
            SelectionEvent selectionEvent = new SelectionEvent(this, this.getSelectedFurniture());
            for (SelectionListener selectionListener : selectionListenerArray = this.selectionListeners.toArray(new SelectionListener[this.selectionListeners.size()])) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    private void deselectPieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        for (int i = 0; i < this.selectedFurniture.size(); ++i) {
            CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.selectedFurniture.get(i);
            if (catalogPieceOfFurniture != catalogPieceOfFurniture2) continue;
            ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>(this.getSelectedFurniture());
            arrayList.remove(i);
            this.setSelectedFurniture(arrayList);
            break;
        }
    }

    public void importFurniture() {
        String string = this.preferences.getLocalizedString(FurnitureLibraryController.class, "importFurnitureTitle", new Object[0]);
        String string2 = this.contentManager.showOpenDialog(null, string, ContentManager.ContentType.USER_DEFINED);
        if (string2 != null) {
            this.importFurniture(string2.split(File.pathSeparator));
        }
    }

    public void importFurniture(String[] stringArray) {
        final AddedFurnitureSelector addedFurnitureSelector = new AddedFurnitureSelector();
        this.furnitureLibrary.addListener(addedFurnitureSelector);
        Runnable runnable = new Runnable(){

            public void run() {
                addedFurnitureSelector.selectAddedFurniture();
                FurnitureLibraryController.this.furnitureLibrary.removeListener(addedFurnitureSelector);
            }
        };
        new ImportFurnitureController(this.furnitureLibrary, stringArray, runnable, this.preferences, this.viewFactory, this.contentManager).executeTask(this.getView());
    }

    public void modifySelectedFurniture() {
        if (this.selectedFurniture.size() > 0) {
            AddedFurnitureSelector addedFurnitureSelector = new AddedFurnitureSelector();
            this.furnitureLibrary.addListener(addedFurnitureSelector);
            new FurnitureController(this.furnitureLibrary, this.selectedFurniture, this.preferences, this.furnitureLanguageController, this.viewFactory, this.contentManager).displayView(this.getView());
            addedFurnitureSelector.selectAddedFurniture();
            this.furnitureLibrary.removeListener(addedFurnitureSelector);
        }
    }

    public void deleteSelectedFurniture() {
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.selectedFurniture) {
            this.furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
        }
    }

    public void selectAll() {
        this.setSelectedFurniture(this.furnitureLibrary.getFurniture());
    }

    private void translateFurnitureCategories(String string, String string2) {
        if (string2.length() > 0) {
            List<FurnitureCategory> list = null;
            List<FurnitureCategory> list2 = null;
            final ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.furnitureLibrary.getFurniture()) {
                final boolean bl = this.selectedFurniture.contains(catalogPieceOfFurniture);
                if (this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string2, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY) == null) {
                    String string3;
                    int n;
                    FurnitureController furnitureController = new FurnitureController(this.furnitureLibrary, Arrays.asList(catalogPieceOfFurniture), this.preferences, this.furnitureLanguageController, this.viewFactory, this.contentManager);
                    if (list == null) {
                        list = furnitureController.getDefaultCategories(string);
                        list2 = furnitureController.getDefaultCategories(string2);
                    }
                    if ((n = list.indexOf(new FurnitureCategory(string3 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, FurnitureLibrary.FURNITURE_CATEGORY_PROPERTY, catalogPieceOfFurniture.getCategory().getName())))) >= 0) {
                        furnitureController.setCategory(list2.get(n));
                        this.furnitureLibrary.addListener(new CollectionListener<CatalogPieceOfFurniture>(){

                            @Override
                            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                                    if (bl) {
                                        arrayList.add(collectionEvent.getItem());
                                    }
                                    FurnitureLibraryController.this.furnitureLibrary.removeListener(this);
                                }
                            }
                        });
                        furnitureController.modifyFurniture();
                        continue;
                    }
                }
                if (!bl) continue;
                arrayList.add(catalogPieceOfFurniture);
            }
            this.setSelectedFurniture(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddedFurnitureSelector
    implements CollectionListener<CatalogPieceOfFurniture> {
        private List<CatalogPieceOfFurniture> addedFurniture = new ArrayList<CatalogPieceOfFurniture>();

        private AddedFurnitureSelector() {
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                this.addedFurniture.add(collectionEvent.getItem());
            }
        }

        public void selectAddedFurniture() {
            if (this.addedFurniture.size() > 0) {
                FurnitureLibraryController.this.setSelectedFurniture(this.addedFurniture);
            }
        }
    }
}

