/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.DefaultLibrary;
import com.eteks.sweethome3d.io.ResourceBundleTools;
import com.eteks.sweethome3d.model.BoxBounds;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogShelfUnit;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFurnitureCatalog
extends FurnitureCatalog {
    public static final String PLUGIN_FURNITURE_CATALOG_FAMILY = "PluginFurnitureCatalog";
    private static final String CONTRIBUTED_FURNITURE_CATALOG_FAMILY = "ContributedFurnitureCatalog";
    private static final String ADDITIONAL_FURNITURE_CATALOG_FAMILY = "AdditionalFurnitureCatalog";
    private static Map<ResourceBundle, Map<Integer, Map<String, ObjectProperty>>> furnitureAdditionalProperties = new WeakHashMap<ResourceBundle, Map<Integer, Map<String, ObjectProperty>>>();
    private List<Library> libraries;
    private static final Map<File, URL> pluginFurnitureCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultFurnitureCatalog() {
        this((File)null);
    }

    public DefaultFurnitureCatalog(File file) {
        this(null, file);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File[] fileArray) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readDefaultFurnitureCatalogs(userPreferences, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    this.readPluginFurnitureCatalog(file2, arrayList);
                }
            }
        }
    }

    public DefaultFurnitureCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultFurnitureCatalog(URL[] uRLArray, URL uRL) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL2 : uRLArray) {
            try {
                ResourceBundle resourceBundle = ResourceBundleTools.getBundle(uRL2, PLUGIN_FURNITURE_CATALOG_FAMILY);
                this.libraries.add(0, new DefaultLibrary(uRL2.toExternalForm(), "Furniture library", resourceBundle));
                this.readFurniture(resourceBundle, uRL2, uRL, arrayList);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    private void readPluginFurnitureCatalog(File file, List<String> list) {
        try {
            URL uRL;
            Object object;
            long l = file.lastModified();
            URL uRL2 = pluginFurnitureCatalogUrlUpdates.get(file);
            if (file.canWrite() && (uRL2 == null || uRL2.openConnection().getLastModified() < l)) {
                object = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(file.toURI().toURL()));
                URL uRL3 = ((URLContent)object).getURL();
                pluginFurnitureCatalogUrlUpdates.put(file, uRL3);
                uRL = uRL3;
            } else {
                uRL = uRL2 != null ? uRL2 : file.toURI().toURL();
            }
            object = ResourceBundleTools.getBundle(uRL, PLUGIN_FURNITURE_CATALOG_FAMILY);
            if (object != null) {
                this.libraries.add(0, new DefaultLibrary(file.getCanonicalPath(), "Furniture library", (ResourceBundle)object));
                this.readFurniture((ResourceBundle)object, uRL, null, list);
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readDefaultFurnitureCatalogs(UserPreferences userPreferences, List<String> list) {
        String string = DefaultFurnitureCatalog.class.getName();
        this.readFurnitureCatalog(string, userPreferences, list);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readFurnitureCatalog(string2 + "." + CONTRIBUTED_FURNITURE_CATALOG_FAMILY, userPreferences, list);
        this.readFurnitureCatalog(string2 + "." + ADDITIONAL_FURNITURE_CATALOG_FAMILY, userPreferences, list);
    }

    private void readFurnitureCatalog(final String string, final UserPreferences userPreferences, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    final Iterator<String> iterator = userPreferences.getLocalizedStringKeys(string);
                    return new Enumeration<String>(){

                        @Override
                        public boolean hasMoreElements() {
                            return iterator.hasNext();
                        }

                        @Override
                        public String nextElement() {
                            return (String)iterator.next();
                        }
                    };
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readFurniture(resourceBundle, null, null, list);
    }

    private void readFurniture(ResourceBundle resourceBundle, URL uRL, URL uRL2, List<String> list) {
        int n = 0;
        while (true) {
            CatalogPieceOfFurniture catalogPieceOfFurniture;
            String string;
            try {
                string = resourceBundle.getString("ignored#" + ++n);
            }
            catch (MissingResourceException missingResourceException) {
                string = null;
            }
            if (string != null && Boolean.parseBoolean(string)) continue;
            CatalogPieceOfFurniture catalogPieceOfFurniture2 = catalogPieceOfFurniture = string == null ? this.readPieceOfFurniture(resourceBundle, n, uRL, uRL2) : null;
            if (catalogPieceOfFurniture == null) break;
            if (catalogPieceOfFurniture.getId() != null) {
                if (list.contains(catalogPieceOfFurniture.getId())) continue;
                list.add(catalogPieceOfFurniture.getId());
            }
            FurnitureCategory furnitureCategory = this.readFurnitureCategory(resourceBundle, n);
            this.add(furnitureCategory, catalogPieceOfFurniture);
        }
    }

    protected Map<String, String> getAdditionalProperties(ResourceBundle resourceBundle, int n) {
        Map<String, ObjectProperty> map = this.getCatalogAdditionalProperties(resourceBundle).get(n);
        if (map != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, ObjectProperty> entry : map.entrySet()) {
                if (entry.getValue().getType() == ObjectProperty.Type.CONTENT) continue;
                hashMap.put(entry.getValue().getName(), resourceBundle.getString(entry.getKey()));
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Content> getAdditionalContents(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        Map<String, ObjectProperty> map = this.getCatalogAdditionalProperties(resourceBundle).get(n);
        if (map != null) {
            HashMap<String, Content> hashMap = new HashMap<String, Content>(map.size());
            for (Map.Entry<String, ObjectProperty> entry : map.entrySet()) {
                if (entry.getValue().getType() != ObjectProperty.Type.CONTENT) continue;
                hashMap.put(entry.getValue().getName(), this.getContent(resourceBundle, entry.getKey(), null, uRL, uRL2, false, true));
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private Map<Integer, Map<String, ObjectProperty>> getCatalogAdditionalProperties(ResourceBundle resourceBundle) {
        Map<Integer, Map<String, ObjectProperty>> map = furnitureAdditionalProperties.get(resourceBundle);
        if (map == null) {
            map = new HashMap<Integer, Map<String, ObjectProperty>>();
            furnitureAdditionalProperties.put(resourceBundle, map);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                int n = string.lastIndexOf(35);
                if (n == -1 || n + 1 >= string.length()) continue;
                try {
                    int n2 = string.indexOf(58, n + 1);
                    int n3 = Integer.parseInt(string.substring(n + 1, n2 != -1 ? n2 : string.length()).trim());
                    String string2 = string.substring(0, n);
                    if (this.isDefaultProperty(string2)) continue;
                    Map<String, ObjectProperty> map2 = map.get(n3);
                    if (map2 == null) {
                        map2 = new HashMap<String, ObjectProperty>();
                        map.put(n3, map2);
                    }
                    ObjectProperty.Type type = null;
                    if (n2 > 0) {
                        try {
                            type = ObjectProperty.Type.valueOf(string.substring(n2 + 1));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    map2.put(string, new ObjectProperty(string2, type));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return map;
    }

    protected boolean isDefaultProperty(String string) {
        try {
            PropertyKey.fromPrefix(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "ignored".equals(string);
        }
    }

    protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        String[] stringArray;
        String string = null;
        try {
            string = resourceBundle.getString(PropertyKey.NAME.getKey(n));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        String string2 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n), null);
        String string3 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.DESCRIPTION.getKey(n), null);
        String string4 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.INFORMATION.getKey(n), null);
        String string5 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.LICENSE.getKey(n), null);
        String string6 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.TAGS.getKey(n), null);
        String[] stringArray2 = string6 != null ? string6.split("\\s*,\\s*") : new String[]{};
        String string7 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.CREATION_DATE.getKey(n), null);
        Long l = null;
        if (string7 != null) {
            try {
                l = new SimpleDateFormat("yyyy-MM-dd").parse(string7).getTime();
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Can't parse date " + string7, parseException);
            }
        }
        String string8 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.GRADE.getKey(n), null);
        Float f = null;
        if (string8 != null) {
            f = Float.valueOf(string8);
        }
        Content content = this.getContent(resourceBundle, PropertyKey.ICON.getKey(n), PropertyKey.ICON_DIGEST.getKey(n), uRL, uRL2, false, false);
        Content content2 = this.getContent(resourceBundle, PropertyKey.PLAN_ICON.getKey(n), PropertyKey.PLAN_ICON_DIGEST.getKey(n), uRL, uRL2, false, true);
        boolean bl = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.MULTI_PART_MODEL.getKey(n), false);
        Content content3 = this.getContent(resourceBundle, PropertyKey.MODEL.getKey(n), PropertyKey.MODEL_DIGEST.getKey(n), uRL, uRL2, bl, false);
        float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
        float f3 = Float.parseFloat(resourceBundle.getString(PropertyKey.DEPTH.getKey(n)));
        float f4 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
        float f5 = ResourceBundleTools.getOptionalFloat(resourceBundle, PropertyKey.ELEVATION.getKey(n), 0.0f);
        float f6 = ResourceBundleTools.getOptionalFloat(resourceBundle, PropertyKey.DROP_ON_TOP_ELEVATION.getKey(n), f4) / f4;
        boolean bl2 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.MOVABLE.getKey(n)));
        boolean bl3 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW.getKey(n)));
        String string9 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKey(n), null);
        float[][] fArray = this.getModelRotation(resourceBundle, PropertyKey.MODEL_ROTATION.getKey(n));
        String string10 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.MODEL_FLAGS.getKey(n), null);
        int n2 = 0;
        if (string10 != null) {
            n2 = Integer.parseInt(string10);
        }
        String string11 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.MODEL_SIZE.getKey(n), null);
        Long l2 = null;
        l2 = string11 != null ? Long.valueOf(Long.parseLong(string11)) : ContentDigestManager.getInstance().getContentSize(content3);
        String string12 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n), null);
        boolean bl4 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.RESIZABLE.getKey(n), true);
        boolean bl5 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.DEFORMABLE.getKey(n), true);
        boolean bl6 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.TEXTURABLE.getKey(n), true);
        boolean bl7 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.HORIZONTALLY_ROTATABLE.getKey(n), true);
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(resourceBundle.getString(PropertyKey.PRICE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        BigDecimal bigDecimal2 = null;
        try {
            bigDecimal2 = new BigDecimal(resourceBundle.getString(PropertyKey.VALUE_ADDED_TAX_PERCENTAGE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string13 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.CURRENCY.getKey(n), null);
        Map<String, String> map = this.getAdditionalProperties(resourceBundle, n);
        Map<String, Content> map2 = this.getAdditionalContents(resourceBundle, n, uRL, uRL2);
        if (bl3) {
            String string14 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.DOOR_OR_WINDOW_CUT_OUT_SHAPE.getKey(n), null);
            float f7 = ResourceBundleTools.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS.getKey(n), f3) / f3;
            float f8 = ResourceBundleTools.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE.getKey(n), 0.0f) / f3;
            boolean bl8 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES.getKey(n), true);
            boolean bl9 = ResourceBundleTools.getOptionalBoolean(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE.getKey(n), true);
            Sash[] sashArray = this.getDoorOrWindowSashes(resourceBundle, n, f2, f3);
            return new CatalogDoorOrWindow(string2, string, string3, string4, string5, stringArray2, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, string14, f7, f8, bl8, bl9, sashArray, fArray, n2, l2, string12, bl4, bl5, bl6, bigDecimal, bigDecimal2, string13, map, map2);
        }
        LightSource[] lightSourceArray = this.getLightSources(resourceBundle, n, f2, f3, f4);
        String string15 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_MATERIAL_NAME.getKey(n), null);
        String[] stringArray3 = stringArray = string15 != null ? string15.split(" +") : null;
        if (lightSourceArray != null || stringArray != null) {
            return new CatalogLight(string2, string, string3, string4, string5, stringArray2, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, lightSourceArray, stringArray, string9, fArray, n2, l2, string12, bl4, bl5, bl6, bl7, bigDecimal, bigDecimal2, string13, map, map2);
        }
        float[] fArray2 = this.getShelfElevations(resourceBundle, n, f4);
        BoxBounds[] boxBoundsArray = this.getShelfBoxes(resourceBundle, n, f2, f3, f4);
        if (fArray2 != null || boxBoundsArray != null) {
            return new CatalogShelfUnit(string2, string, string3, string4, string5, stringArray2, l, f, content, content2, content3, f2, f3, f4, f5, f6, fArray2, boxBoundsArray, bl2, string9, fArray, n2, l2, string12, bl4, bl5, bl6, bl7, bigDecimal, bigDecimal2, string13, map, map2);
        }
        return new CatalogPieceOfFurniture(string2, string, string3, string4, string5, stringArray2, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, string9, fArray, n2, l2, string12, bl4, bl5, bl6, bl7, bigDecimal, bigDecimal2, string13, map, map2);
    }

    protected FurnitureCategory readFurnitureCategory(ResourceBundle resourceBundle, int n) {
        String string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
        return new FurnitureCategory(string);
    }

    private Content getContent(ResourceBundle resourceBundle, String string, String string2, URL uRL, URL uRL2, boolean bl, boolean bl2) {
        URLContent uRLContent;
        Object object;
        String string3;
        String string4 = string3 = bl2 ? ResourceBundleTools.getOptionalString(resourceBundle, string, null) : resourceBundle.getString(string);
        if (bl2 && string3 == null) {
            return null;
        }
        try {
            if (uRL2 == null) {
                object = new URL(string3);
            } else {
                Object object2 = object = string3.startsWith("?") ? new URL(uRL2 + string3) : new URL(uRL2, string3);
                if (string3.indexOf("!/") >= 0 && !string3.startsWith("jar:")) {
                    object = new URL("jar:" + object);
                }
            }
            uRLContent = new URLContent((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                uRLContent = new ResourceURLContent(DefaultFurnitureCatalog.class, string3, bl);
            }
            try {
                uRLContent = new ResourceURLContent(new URL("jar:" + uRL + "!" + string3), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
        if (string2 != null && (object = ResourceBundleTools.getOptionalString(resourceBundle, string2, null)) != null && ((String)object).length() > 0) {
            try {
                ContentDigestManager.getInstance().setContentDigest(uRLContent, Base64.decode((String)object));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uRLContent;
    }

    private float[][] getModelRotation(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            String[] stringArray = string2.split(" +", 9);
            if (stringArray.length == 9) {
                return new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])}, {Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])}, {Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7]), Float.parseFloat(stringArray[8])}};
            }
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Sash[] getDoorOrWindowSashes(ResourceBundle resourceBundle, int n, float f, float f2) {
        Sash[] sashArray;
        String string = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS.getKey(n), null);
        if (string != null) {
            String[] stringArray = string.split(" +");
            String[] stringArray2 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n)).split(" +");
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n) + " key");
            }
            String[] stringArray3 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n)).split(" +");
            if (stringArray3.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n)).split(" +");
            if (stringArray4.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n)).split(" +");
            if (stringArray5.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n) + " key");
            }
            sashArray = new Sash[stringArray.length];
            for (int i = 0; i < sashArray.length; ++i) {
                sashArray[i] = new Sash(Float.parseFloat(stringArray[i]) / f, Float.parseFloat(stringArray2[i]) / f2, Float.parseFloat(stringArray3[i]) / f, (float)Math.toRadians(Float.parseFloat(stringArray4[i])), (float)Math.toRadians(Float.parseFloat(stringArray5[i])));
            }
        } else {
            sashArray = new Sash[]{};
        }
        return sashArray;
    }

    private LightSource[] getLightSources(ResourceBundle resourceBundle, int n, float f, float f2, float f3) {
        LightSource[] lightSourceArray = null;
        String string = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_X.getKey(n), null);
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = string.split(" +");
            String[] stringArray3 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Y.getKey(n)).split(" +");
            if (stringArray3.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Y.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Z.getKey(n)).split(" +");
            if (stringArray4.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Z.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_COLOR.getKey(n)).split(" +");
            if (stringArray5.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_COLOR.getKey(n) + " key");
            }
            String string2 = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n), null);
            if (string2 != null) {
                stringArray = string2.split(" +");
                if (stringArray.length != stringArray2.length) {
                    throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n) + " key");
                }
            } else {
                stringArray = null;
            }
            lightSourceArray = new LightSource[stringArray2.length];
            for (int i = 0; i < lightSourceArray.length; ++i) {
                int n2 = stringArray5[i].startsWith("#") ? Integer.parseInt(stringArray5[i].substring(1), 16) : Integer.parseInt(stringArray5[i]);
                lightSourceArray[i] = new LightSource(Float.parseFloat(stringArray2[i]) / f, Float.parseFloat(stringArray3[i]) / f2, Float.parseFloat(stringArray4[i]) / f3, n2, stringArray != null ? Float.valueOf(Float.parseFloat(stringArray[i]) / f) : null);
            }
        }
        return lightSourceArray;
    }

    private float[] getShelfElevations(ResourceBundle resourceBundle, int n, float f) {
        float[] fArray = null;
        String string = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.SHELF_ELEVATIONS.getKey(n), null);
        if (string != null) {
            String[] stringArray = string.split(" +");
            fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]) / f;
            }
        }
        return fArray;
    }

    private BoxBounds[] getShelfBoxes(ResourceBundle resourceBundle, int n, float f, float f2, float f3) {
        BoxBounds[] boxBoundsArray = null;
        String string = ResourceBundleTools.getOptionalString(resourceBundle, PropertyKey.SHELF_BOXES.getKey(n), null);
        if (string != null) {
            String[] stringArray = string.split(" +");
            if (stringArray.length % 6 != 0) {
                throw new IllegalArgumentException("Expected a multiple of 6 values in " + PropertyKey.SHELF_BOXES.getKey(n) + " key");
            }
            boxBoundsArray = new BoxBounds[stringArray.length / 6];
            for (int i = 0; i < boxBoundsArray.length; ++i) {
                boxBoundsArray[i] = new BoxBounds(Float.parseFloat(stringArray[i * 6]) / f, Float.parseFloat(stringArray[i * 6 + 1]) / f2, Float.parseFloat(stringArray[i * 6 + 2]) / f3, Float.parseFloat(stringArray[i * 6 + 3]) / f, Float.parseFloat(stringArray[i * 6 + 4]) / f2, Float.parseFloat(stringArray[i * 6 + 5]) / f3);
            }
        }
        return boxBoundsArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        INFORMATION("information"),
        LICENSE("license"),
        TAGS("tags"),
        CREATION_DATE("creationDate"),
        GRADE("grade"),
        CATEGORY("category"),
        ICON("icon"),
        ICON_DIGEST("iconDigest"),
        PLAN_ICON("planIcon"),
        PLAN_ICON_DIGEST("planIconDigest"),
        MODEL("model"),
        MODEL_SIZE("modelSize"),
        MODEL_DIGEST("modelDigest"),
        MULTI_PART_MODEL("multiPartModel"),
        WIDTH("width"),
        DEPTH("depth"),
        HEIGHT("height"),
        MOVABLE("movable"),
        DOOR_OR_WINDOW("doorOrWindow"),
        DOOR_OR_WINDOW_CUT_OUT_SHAPE("doorOrWindowCutOutShape"),
        DOOR_OR_WINDOW_WALL_THICKNESS("doorOrWindowWallThickness"),
        DOOR_OR_WINDOW_WALL_DISTANCE("doorOrWindowWallDistance"),
        DOOR_OR_WINDOW_WALL_CUT_OUT_ON_BOTH_SIDES("doorOrWindowWallCutOutOnBothSides"),
        DOOR_OR_WINDOW_WIDTH_DEPTH_DEFORMABLE("doorOrWindowWidthDepthDeformable"),
        DOOR_OR_WINDOW_SASH_X_AXIS("doorOrWindowSashXAxis"),
        DOOR_OR_WINDOW_SASH_Y_AXIS("doorOrWindowSashYAxis"),
        DOOR_OR_WINDOW_SASH_WIDTH("doorOrWindowSashWidth"),
        DOOR_OR_WINDOW_SASH_START_ANGLE("doorOrWindowSashStartAngle"),
        DOOR_OR_WINDOW_SASH_END_ANGLE("doorOrWindowSashEndAngle"),
        LIGHT_SOURCE_X("lightSourceX"),
        LIGHT_SOURCE_Y("lightSourceY"),
        LIGHT_SOURCE_Z("lightSourceZ"),
        LIGHT_SOURCE_COLOR("lightSourceColor"),
        LIGHT_SOURCE_DIAMETER("lightSourceDiameter"),
        LIGHT_SOURCE_MATERIAL_NAME("lightSourceMaterialName"),
        STAIRCASE_CUT_OUT_SHAPE("staircaseCutOutShape"),
        ELEVATION("elevation"),
        DROP_ON_TOP_ELEVATION("dropOnTopElevation"),
        SHELF_ELEVATIONS("shelfElevations"),
        SHELF_BOXES("shelfBoxes"),
        MODEL_ROTATION("modelRotation"),
        MODEL_FLAGS("modelFlags"),
        CREATOR("creator"),
        RESIZABLE("resizable"),
        DEFORMABLE("deformable"),
        TEXTURABLE("texturable"),
        HORIZONTALLY_ROTATABLE("horizontallyRotatable"),
        PRICE("price"),
        VALUE_ADDED_TAX_PERCENTAGE("valueAddedTaxPercentage"),
        CURRENCY("currency");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }

        public static PropertyKey fromPrefix(String string) {
            for (PropertyKey propertyKey : PropertyKey.values()) {
                if (!propertyKey.keyPrefix.equals(string)) continue;
                return propertyKey;
            }
            throw new IllegalArgumentException("Unknow prefix " + string);
        }
    }
}

